#ifndef _MPYTHON_UNICODE_H
#define _MPYTHON_UNICODE_H

const unsigned short giGB2312[][2]={
    0xA1A1, 0x3000,    /* '　' -> 12288 */
    0xA1A2, 0x3001,    /* '、' -> 12289 */
    0xA1A3, 0x3002,    /* '。' -> 12290 */
    0xA1A4, 0x30FB,    /* '·' -> 12539 */
    0xA1A5, 0x02C9,    /* 'ˉ' ->     713 */
    0xA1A6, 0x02C7,    /* 'ˇ' ->     711 */
    0xA1A7, 0x00A8,    /* '¨' ->     168 */
    0xA1A8, 0x3003,    /* '〃' -> 12291 */
    0xA1A9, 0x3005,    /* '々' -> 12293 */
    0xA1AA, 0x2015,    /* '—' ->    8213 */
    0xA1AB, 0xFF5E,    /* '～' -> 65374 */
    0xA1AC, 0x2016,    /* '‖' ->    8214 */
    0xA1AD, 0x2026,    /* '…' ->    8230 */
    0xA1AE, 0x2018,    /* '‘' ->    8216 */
    0xA1AF, 0x2019,    /* '’' ->    8217 */
    0xA1B0, 0x201C,    /* '“' ->    8220 */
    0xA1B1, 0x201D,    /* '”' ->    8221 */
    0xA1B2, 0x3014,    /* '〔' -> 12308 */
    0xA1B3, 0x3015,    /* '〕' -> 12309 */
    0xA1B4, 0x3008,    /* '〈' -> 12296 */
    0xA1B5, 0x3009,    /* '〉' -> 12297 */
    0xA1B6, 0x300A,    /* '《' -> 12298 */
    0xA1B7, 0x300B,    /* '》' -> 12299 */
    0xA1B8, 0x300C,    /* '「' -> 12300 */
    0xA1B9, 0x300D,    /* '」' -> 12301 */
    0xA1BA, 0x300E,    /* '『' -> 12302 */
    0xA1BB, 0x300F,    /* '』' -> 12303 */
    0xA1BC, 0x3016,    /* '〖' -> 12310 */
    0xA1BD, 0x3017,    /* '〗' -> 12311 */
    0xA1BE, 0x3010,    /* '【' -> 12304 */
    0xA1BF, 0x3011,    /* '】' -> 12305 */
    0xA1C0, 0x00B1,    /* '±' ->     177 */
    0xA1C1, 0x00D7,    /* '×' ->     215 */
    0xA1C2, 0x00F7,    /* '÷' ->     247 */
    0xA1C3, 0x2236,    /* '∶' ->    8758 */
    0xA1C4, 0x2227,    /* '∧' ->    8743 */
    0xA1C5, 0x2228,    /* '∨' ->    8744 */
    0xA1C6, 0x2211,    /* '∑' ->    8721 */
    0xA1C7, 0x220F,    /* '∏' ->    8719 */
    0xA1C8, 0x222A,    /* '∪' ->    8746 */
    0xA1C9, 0x2229,    /* '∩' ->    8745 */
    0xA1CA, 0x2208,    /* '∈' ->    8712 */
    0xA1CB, 0x2237,    /* '∷' ->    8759 */
    0xA1CC, 0x221A,    /* '√' ->    8730 */
    0xA1CD, 0x22A5,    /* '⊥' ->    8869 */
    0xA1CE, 0x2225,    /* '∥' ->    8741 */
    0xA1CF, 0x2220,    /* '∠' ->    8736 */
    0xA1D0, 0x2312,    /* '⌒' ->    8978 */
    0xA1D1, 0x2299,    /* '⊙' ->    8857 */
    0xA1D2, 0x222B,    /* '∫' ->    8747 */
    0xA1D3, 0x222E,    /* '∮' ->    8750 */
    0xA1D4, 0x2261,    /* '≡' ->    8801 */
    0xA1D5, 0x224C,    /* '≌' ->    8780 */
    0xA1D6, 0x2248,    /* '≈' ->    8776 */
    0xA1D7, 0x223D,    /* '∽' ->    8765 */
    0xA1D8, 0x221D,    /* '∝' ->    8733 */
    0xA1D9, 0x2260,    /* '≠' ->    8800 */
    0xA1DA, 0x226E,    /* '≮' ->    8814 */
    0xA1DB, 0x226F,    /* '≯' ->    8815 */
    0xA1DC, 0x2264,    /* '≤' ->    8804 */
    0xA1DD, 0x2265,    /* '≥' ->    8805 */
    0xA1DE, 0x221E,    /* '∞' ->    8734 */
    0xA1DF, 0x2235,    /* '∵' ->    8757 */
    0xA1E0, 0x2234,    /* '∴' ->    8756 */
    0xA1E1, 0x2642,    /* '♂' ->    9794 */
    0xA1E2, 0x2640,    /* '♀' ->    9792 */
    0xA1E3, 0x00B0,    /* '°' ->     176 */
    0xA1E4, 0x2032,    /* '′' ->    8242 */
    0xA1E5, 0x2033,    /* '″' ->    8243 */
    0xA1E6, 0x2103,    /* '℃' ->    8451 */
    0xA1E7, 0xFF04,    /* '＄' -> 65284 */
    0xA1E8, 0x00A4,    /* '¤' ->     164 */
    0xA1E9, 0xFFE0,    /* '￠' -> 65504 */
    0xA1EA, 0xFFE1,    /* '￡' -> 65505 */
    0xA1EB, 0x2030,    /* '‰' ->    8240 */
    0xA1EC, 0x00A7,    /* '§' ->     167 */
    0xA1ED, 0x2116,    /* '№' ->    8470 */
    0xA1EE, 0x2606,    /* '☆' ->    9734 */
    0xA1EF, 0x2605,    /* '★' ->    9733 */
    0xA1F0, 0x25CB,    /* '○' ->    9675 */
    0xA1F1, 0x25CF,    /* '●' ->    9679 */
    0xA1F2, 0x25CE,    /* '◎' ->    9678 */
    0xA1F3, 0x25C7,    /* '◇' ->    9671 */
    0xA1F4, 0x25C6,    /* '◆' ->    9670 */
    0xA1F5, 0x25A1,    /* '□' ->    9633 */
    0xA1F6, 0x25A0,    /* '■' ->    9632 */
    0xA1F7, 0x25B3,    /* '△' ->    9651 */
    0xA1F8, 0x25B2,    /* '▲' ->    9650 */
    0xA1F9, 0x203B,    /* '※' ->    8251 */
    0xA1FA, 0x2192,    /* '→' ->    8594 */
    0xA1FB, 0x2190,    /* '←' ->    8592 */
    0xA1FC, 0x2191,    /* '↑' ->    8593 */
    0xA1FD, 0x2193,    /* '↓' ->    8595 */
    0xA1FE, 0x3013,    /* '〓' -> 12307 */
    0xA2B1, 0x2488,    /* '⒈' ->    9352 */
    0xA2B2, 0x2489,    /* '⒉' ->    9353 */
    0xA2B3, 0x248A,    /* '⒊' ->    9354 */
    0xA2B4, 0x248B,    /* '⒋' ->    9355 */
    0xA2B5, 0x248C,    /* '⒌' ->    9356 */
    0xA2B6, 0x248D,    /* '⒍' ->    9357 */
    0xA2B7, 0x248E,    /* '⒎' ->    9358 */
    0xA2B8, 0x248F,    /* '⒏' ->    9359 */
    0xA2B9, 0x2490,    /* '⒐' ->    9360 */
    0xA2BA, 0x2491,    /* '⒑' ->    9361 */
    0xA2BB, 0x2492,    /* '⒒' ->    9362 */
    0xA2BC, 0x2493,    /* '⒓' ->    9363 */
    0xA2BD, 0x2494,    /* '⒔' ->    9364 */
    0xA2BE, 0x2495,    /* '⒕' ->    9365 */
    0xA2BF, 0x2496,    /* '⒖' ->    9366 */
    0xA2C0, 0x2497,    /* '⒗' ->    9367 */
    0xA2C1, 0x2498,    /* '⒘' ->    9368 */
    0xA2C2, 0x2499,    /* '⒙' ->    9369 */
    0xA2C3, 0x249A,    /* '⒚' ->    9370 */
    0xA2C4, 0x249B,    /* '⒛' ->    9371 */
    0xA2C5, 0x2474,    /* '⑴' ->    9332 */
    0xA2C6, 0x2475,    /* '⑵' ->    9333 */
    0xA2C7, 0x2476,    /* '⑶' ->    9334 */
    0xA2C8, 0x2477,    /* '⑷' ->    9335 */
    0xA2C9, 0x2478,    /* '⑸' ->    9336 */
    0xA2CA, 0x2479,    /* '⑹' ->    9337 */
    0xA2CB, 0x247A,    /* '⑺' ->    9338 */
    0xA2CC, 0x247B,    /* '⑻' ->    9339 */
    0xA2CD, 0x247C,    /* '⑼' ->    9340 */
    0xA2CE, 0x247D,    /* '⑽' ->    9341 */
    0xA2CF, 0x247E,    /* '⑾' ->    9342 */
    0xA2D0, 0x247F,    /* '⑿' ->    9343 */
    0xA2D1, 0x2480,    /* '⒀' ->    9344 */
    0xA2D2, 0x2481,    /* '⒁' ->    9345 */
    0xA2D3, 0x2482,    /* '⒂' ->    9346 */
    0xA2D4, 0x2483,    /* '⒃' ->    9347 */
    0xA2D5, 0x2484,    /* '⒄' ->    9348 */
    0xA2D6, 0x2485,    /* '⒅' ->    9349 */
    0xA2D7, 0x2486,    /* '⒆' ->    9350 */
    0xA2D8, 0x2487,    /* '⒇' ->    9351 */
    0xA2D9, 0x2460,    /* '①' ->    9312 */
    0xA2DA, 0x2461,    /* '②' ->    9313 */
    0xA2DB, 0x2462,    /* '③' ->    9314 */
    0xA2DC, 0x2463,    /* '④' ->    9315 */
    0xA2DD, 0x2464,    /* '⑤' ->    9316 */
    0xA2DE, 0x2465,    /* '⑥' ->    9317 */
    0xA2DF, 0x2466,    /* '⑦' ->    9318 */
    0xA2E0, 0x2467,    /* '⑧' ->    9319 */
    0xA2E1, 0x2468,    /* '⑨' ->    9320 */
    0xA2E2, 0x2469,    /* '⑩' ->    9321 */
    0xA2E5, 0x3220,    /* '㈠' -> 12832 */
    0xA2E6, 0x3221,    /* '㈡' -> 12833 */
    0xA2E7, 0x3222,    /* '㈢' -> 12834 */
    0xA2E8, 0x3223,    /* '㈣' -> 12835 */
    0xA2E9, 0x3224,    /* '㈤' -> 12836 */
    0xA2EA, 0x3225,    /* '㈥' -> 12837 */
    0xA2EB, 0x3226,    /* '㈦' -> 12838 */
    0xA2EC, 0x3227,    /* '㈧' -> 12839 */
    0xA2ED, 0x3228,    /* '㈨' -> 12840 */
    0xA2EE, 0x3229,    /* '㈩' -> 12841 */
    0xA2F1, 0x2160,    /* 'Ⅰ' ->    8544 */
    0xA2F2, 0x2161,    /* 'Ⅱ' ->    8545 */
    0xA2F3, 0x2162,    /* 'Ⅲ' ->    8546 */
    0xA2F4, 0x2163,    /* 'Ⅳ' ->    8547 */
    0xA2F5, 0x2164,    /* 'Ⅴ' ->    8548 */
    0xA2F6, 0x2165,    /* 'Ⅵ' ->    8549 */
    0xA2F7, 0x2166,    /* 'Ⅶ' ->    8550 */
    0xA2F8, 0x2167,    /* 'Ⅷ' ->    8551 */
    0xA2F9, 0x2168,    /* 'Ⅸ' ->    8552 */
    0xA2FA, 0x2169,    /* 'Ⅹ' ->    8553 */
    0xA2FB, 0x216A,    /* 'Ⅺ' ->    8554 */
    0xA2FC, 0x216B,    /* 'Ⅻ' ->    8555 */
    0xA3A1, 0xFF01,    /* '！' -> 65281 */
    0xA3A2, 0xFF02,    /* '＂' -> 65282 */
    0xA3A3, 0xFF03,    /* '＃' -> 65283 */
    0xA3A4, 0xFFE5,    /* '￥' -> 65509 */
    0xA3A5, 0xFF05,    /* '％' -> 65285 */
    0xA3A6, 0xFF06,    /* '＆' -> 65286 */
    0xA3A7, 0xFF07,    /* '＇' -> 65287 */
    0xA3A8, 0xFF08,    /* '（' -> 65288 */
    0xA3A9, 0xFF09,    /* '）' -> 65289 */
    0xA3AA, 0xFF0A,    /* '＊' -> 65290 */
    0xA3AB, 0xFF0B,    /* '＋' -> 65291 */
    0xA3AC, 0xFF0C,    /* '，' -> 65292 */
    0xA3AD, 0xFF0D,    /* '－' -> 65293 */
    0xA3AE, 0xFF0E,    /* '．' -> 65294 */
    0xA3AF, 0xFF0F,    /* '／' -> 65295 */
    0xA3B0, 0xFF10,    /* '０' -> 65296 */
    0xA3B1, 0xFF11,    /* '１' -> 65297 */
    0xA3B2, 0xFF12,    /* '２' -> 65298 */
    0xA3B3, 0xFF13,    /* '３' -> 65299 */
    0xA3B4, 0xFF14,    /* '４' -> 65300 */
    0xA3B5, 0xFF15,    /* '５' -> 65301 */
    0xA3B6, 0xFF16,    /* '６' -> 65302 */
    0xA3B7, 0xFF17,    /* '７' -> 65303 */
    0xA3B8, 0xFF18,    /* '８' -> 65304 */
    0xA3B9, 0xFF19,    /* '９' -> 65305 */
    0xA3BA, 0xFF1A,    /* '：' -> 65306 */
    0xA3BB, 0xFF1B,    /* '；' -> 65307 */
    0xA3BC, 0xFF1C,    /* '＜' -> 65308 */
    0xA3BD, 0xFF1D,    /* '＝' -> 65309 */
    0xA3BE, 0xFF1E,    /* '＞' -> 65310 */
    0xA3BF, 0xFF1F,    /* '？' -> 65311 */
    0xA3C0, 0xFF20,    /* '＠' -> 65312 */
    0xA3C1, 0xFF21,    /* 'Ａ' -> 65313 */
    0xA3C2, 0xFF22,    /* 'Ｂ' -> 65314 */
    0xA3C3, 0xFF23,    /* 'Ｃ' -> 65315 */
    0xA3C4, 0xFF24,    /* 'Ｄ' -> 65316 */
    0xA3C5, 0xFF25,    /* 'Ｅ' -> 65317 */
    0xA3C6, 0xFF26,    /* 'Ｆ' -> 65318 */
    0xA3C7, 0xFF27,    /* 'Ｇ' -> 65319 */
    0xA3C8, 0xFF28,    /* 'Ｈ' -> 65320 */
    0xA3C9, 0xFF29,    /* 'Ｉ' -> 65321 */
    0xA3CA, 0xFF2A,    /* 'Ｊ' -> 65322 */
    0xA3CB, 0xFF2B,    /* 'Ｋ' -> 65323 */
    0xA3CC, 0xFF2C,    /* 'Ｌ' -> 65324 */
    0xA3CD, 0xFF2D,    /* 'Ｍ' -> 65325 */
    0xA3CE, 0xFF2E,    /* 'Ｎ' -> 65326 */
    0xA3CF, 0xFF2F,    /* 'Ｏ' -> 65327 */
    0xA3D0, 0xFF30,    /* 'Ｐ' -> 65328 */
    0xA3D1, 0xFF31,    /* 'Ｑ' -> 65329 */
    0xA3D2, 0xFF32,    /* 'Ｒ' -> 65330 */
    0xA3D3, 0xFF33,    /* 'Ｓ' -> 65331 */
    0xA3D4, 0xFF34,    /* 'Ｔ' -> 65332 */
    0xA3D5, 0xFF35,    /* 'Ｕ' -> 65333 */
    0xA3D6, 0xFF36,    /* 'Ｖ' -> 65334 */
    0xA3D7, 0xFF37,    /* 'Ｗ' -> 65335 */
    0xA3D8, 0xFF38,    /* 'Ｘ' -> 65336 */
    0xA3D9, 0xFF39,    /* 'Ｙ' -> 65337 */
    0xA3DA, 0xFF3A,    /* 'Ｚ' -> 65338 */
    0xA3DB, 0xFF3B,    /* '［' -> 65339 */
    0xA3DC, 0xFF3C,    /* '＼' -> 65340 */
    0xA3DD, 0xFF3D,    /* '］' -> 65341 */
    0xA3DE, 0xFF3E,    /* '＾' -> 65342 */
    0xA3DF, 0xFF3F,    /* '＿' -> 65343 */
    0xA3E0, 0xFF40,    /* '｀' -> 65344 */
    0xA3E1, 0xFF41,    /* 'ａ' -> 65345 */
    0xA3E2, 0xFF42,    /* 'ｂ' -> 65346 */
    0xA3E3, 0xFF43,    /* 'ｃ' -> 65347 */
    0xA3E4, 0xFF44,    /* 'ｄ' -> 65348 */
    0xA3E5, 0xFF45,    /* 'ｅ' -> 65349 */
    0xA3E6, 0xFF46,    /* 'ｆ' -> 65350 */
    0xA3E7, 0xFF47,    /* 'ｇ' -> 65351 */
    0xA3E8, 0xFF48,    /* 'ｈ' -> 65352 */
    0xA3E9, 0xFF49,    /* 'ｉ' -> 65353 */
    0xA3EA, 0xFF4A,    /* 'ｊ' -> 65354 */
    0xA3EB, 0xFF4B,    /* 'ｋ' -> 65355 */
    0xA3EC, 0xFF4C,    /* 'ｌ' -> 65356 */
    0xA3ED, 0xFF4D,    /* 'ｍ' -> 65357 */
    0xA3EE, 0xFF4E,    /* 'ｎ' -> 65358 */
    0xA3EF, 0xFF4F,    /* 'ｏ' -> 65359 */
    0xA3F0, 0xFF50,    /* 'ｐ' -> 65360 */
    0xA3F1, 0xFF51,    /* 'ｑ' -> 65361 */
    0xA3F2, 0xFF52,    /* 'ｒ' -> 65362 */
    0xA3F3, 0xFF53,    /* 'ｓ' -> 65363 */
    0xA3F4, 0xFF54,    /* 'ｔ' -> 65364 */
    0xA3F5, 0xFF55,    /* 'ｕ' -> 65365 */
    0xA3F6, 0xFF56,    /* 'ｖ' -> 65366 */
    0xA3F7, 0xFF57,    /* 'ｗ' -> 65367 */
    0xA3F8, 0xFF58,    /* 'ｘ' -> 65368 */
    0xA3F9, 0xFF59,    /* 'ｙ' -> 65369 */
    0xA3FA, 0xFF5A,    /* 'ｚ' -> 65370 */
    0xA3FB, 0xFF5B,    /* '｛' -> 65371 */
    0xA3FC, 0xFF5C,    /* '｜' -> 65372 */
    0xA3FD, 0xFF5D,    /* '｝' -> 65373 */
    0xA3FE, 0xFFE3,    /* '￣' -> 65507 */
    0xA4A1, 0x3041,    /* 'ぁ' -> 12353 */
    0xA4A2, 0x3042,    /* 'あ' -> 12354 */
    0xA4A3, 0x3043,    /* 'ぃ' -> 12355 */
    0xA4A4, 0x3044,    /* 'い' -> 12356 */
    0xA4A5, 0x3045,    /* 'ぅ' -> 12357 */
    0xA4A6, 0x3046,    /* 'う' -> 12358 */
    0xA4A7, 0x3047,    /* 'ぇ' -> 12359 */
    0xA4A8, 0x3048,    /* 'え' -> 12360 */
    0xA4A9, 0x3049,    /* 'ぉ' -> 12361 */
    0xA4AA, 0x304A,    /* 'お' -> 12362 */
    0xA4AB, 0x304B,    /* 'か' -> 12363 */
    0xA4AC, 0x304C,    /* 'が' -> 12364 */
    0xA4AD, 0x304D,    /* 'き' -> 12365 */
    0xA4AE, 0x304E,    /* 'ぎ' -> 12366 */
    0xA4AF, 0x304F,    /* 'く' -> 12367 */
    0xA4B0, 0x3050,    /* 'ぐ' -> 12368 */
    0xA4B1, 0x3051,    /* 'け' -> 12369 */
    0xA4B2, 0x3052,    /* 'げ' -> 12370 */
    0xA4B3, 0x3053,    /* 'こ' -> 12371 */
    0xA4B4, 0x3054,    /* 'ご' -> 12372 */
    0xA4B5, 0x3055,    /* 'さ' -> 12373 */
    0xA4B6, 0x3056,    /* 'ざ' -> 12374 */
    0xA4B7, 0x3057,    /* 'し' -> 12375 */
    0xA4B8, 0x3058,    /* 'じ' -> 12376 */
    0xA4B9, 0x3059,    /* 'す' -> 12377 */
    0xA4BA, 0x305A,    /* 'ず' -> 12378 */
    0xA4BB, 0x305B,    /* 'せ' -> 12379 */
    0xA4BC, 0x305C,    /* 'ぜ' -> 12380 */
    0xA4BD, 0x305D,    /* 'そ' -> 12381 */
    0xA4BE, 0x305E,    /* 'ぞ' -> 12382 */
    0xA4BF, 0x305F,    /* 'た' -> 12383 */
    0xA4C0, 0x3060,    /* 'だ' -> 12384 */
    0xA4C1, 0x3061,    /* 'ち' -> 12385 */
    0xA4C2, 0x3062,    /* 'ぢ' -> 12386 */
    0xA4C3, 0x3063,    /* 'っ' -> 12387 */
    0xA4C4, 0x3064,    /* 'つ' -> 12388 */
    0xA4C5, 0x3065,    /* 'づ' -> 12389 */
    0xA4C6, 0x3066,    /* 'て' -> 12390 */
    0xA4C7, 0x3067,    /* 'で' -> 12391 */
    0xA4C8, 0x3068,    /* 'と' -> 12392 */
    0xA4C9, 0x3069,    /* 'ど' -> 12393 */
    0xA4CA, 0x306A,    /* 'な' -> 12394 */
    0xA4CB, 0x306B,    /* 'に' -> 12395 */
    0xA4CC, 0x306C,    /* 'ぬ' -> 12396 */
    0xA4CD, 0x306D,    /* 'ね' -> 12397 */
    0xA4CE, 0x306E,    /* 'の' -> 12398 */
    0xA4CF, 0x306F,    /* 'は' -> 12399 */
    0xA4D0, 0x3070,    /* 'ば' -> 12400 */
    0xA4D1, 0x3071,    /* 'ぱ' -> 12401 */
    0xA4D2, 0x3072,    /* 'ひ' -> 12402 */
    0xA4D3, 0x3073,    /* 'び' -> 12403 */
    0xA4D4, 0x3074,    /* 'ぴ' -> 12404 */
    0xA4D5, 0x3075,    /* 'ふ' -> 12405 */
    0xA4D6, 0x3076,    /* 'ぶ' -> 12406 */
    0xA4D7, 0x3077,    /* 'ぷ' -> 12407 */
    0xA4D8, 0x3078,    /* 'へ' -> 12408 */
    0xA4D9, 0x3079,    /* 'べ' -> 12409 */
    0xA4DA, 0x307A,    /* 'ぺ' -> 12410 */
    0xA4DB, 0x307B,    /* 'ほ' -> 12411 */
    0xA4DC, 0x307C,    /* 'ぼ' -> 12412 */
    0xA4DD, 0x307D,    /* 'ぽ' -> 12413 */
    0xA4DE, 0x307E,    /* 'ま' -> 12414 */
    0xA4DF, 0x307F,    /* 'み' -> 12415 */
    0xA4E0, 0x3080,    /* 'む' -> 12416 */
    0xA4E1, 0x3081,    /* 'め' -> 12417 */
    0xA4E2, 0x3082,    /* 'も' -> 12418 */
    0xA4E3, 0x3083,    /* 'ゃ' -> 12419 */
    0xA4E4, 0x3084,    /* 'や' -> 12420 */
    0xA4E5, 0x3085,    /* 'ゅ' -> 12421 */
    0xA4E6, 0x3086,    /* 'ゆ' -> 12422 */
    0xA4E7, 0x3087,    /* 'ょ' -> 12423 */
    0xA4E8, 0x3088,    /* 'よ' -> 12424 */
    0xA4E9, 0x3089,    /* 'ら' -> 12425 */
    0xA4EA, 0x308A,    /* 'り' -> 12426 */
    0xA4EB, 0x308B,    /* 'る' -> 12427 */
    0xA4EC, 0x308C,    /* 'れ' -> 12428 */
    0xA4ED, 0x308D,    /* 'ろ' -> 12429 */
    0xA4EE, 0x308E,    /* 'ゎ' -> 12430 */
    0xA4EF, 0x308F,    /* 'わ' -> 12431 */
    0xA4F0, 0x3090,    /* 'ゐ' -> 12432 */
    0xA4F1, 0x3091,    /* 'ゑ' -> 12433 */
    0xA4F2, 0x3092,    /* 'を' -> 12434 */
    0xA4F3, 0x3093,    /* 'ん' -> 12435 */
    0xA5A1, 0x30A1,    /* 'ァ' -> 12449 */
    0xA5A2, 0x30A2,    /* 'ア' -> 12450 */
    0xA5A3, 0x30A3,    /* 'ィ' -> 12451 */
    0xA5A4, 0x30A4,    /* 'イ' -> 12452 */
    0xA5A5, 0x30A5,    /* 'ゥ' -> 12453 */
    0xA5A6, 0x30A6,    /* 'ウ' -> 12454 */
    0xA5A7, 0x30A7,    /* 'ェ' -> 12455 */
    0xA5A8, 0x30A8,    /* 'エ' -> 12456 */
    0xA5A9, 0x30A9,    /* 'ォ' -> 12457 */
    0xA5AA, 0x30AA,    /* 'オ' -> 12458 */
    0xA5AB, 0x30AB,    /* 'カ' -> 12459 */
    0xA5AC, 0x30AC,    /* 'ガ' -> 12460 */
    0xA5AD, 0x30AD,    /* 'キ' -> 12461 */
    0xA5AE, 0x30AE,    /* 'ギ' -> 12462 */
    0xA5AF, 0x30AF,    /* 'ク' -> 12463 */
    0xA5B0, 0x30B0,    /* 'グ' -> 12464 */
    0xA5B1, 0x30B1,    /* 'ケ' -> 12465 */
    0xA5B2, 0x30B2,    /* 'ゲ' -> 12466 */
    0xA5B3, 0x30B3,    /* 'コ' -> 12467 */
    0xA5B4, 0x30B4,    /* 'ゴ' -> 12468 */
    0xA5B5, 0x30B5,    /* 'サ' -> 12469 */
    0xA5B6, 0x30B6,    /* 'ザ' -> 12470 */
    0xA5B7, 0x30B7,    /* 'シ' -> 12471 */
    0xA5B8, 0x30B8,    /* 'ジ' -> 12472 */
    0xA5B9, 0x30B9,    /* 'ス' -> 12473 */
    0xA5BA, 0x30BA,    /* 'ズ' -> 12474 */
    0xA5BB, 0x30BB,    /* 'セ' -> 12475 */
    0xA5BC, 0x30BC,    /* 'ゼ' -> 12476 */
    0xA5BD, 0x30BD,    /* 'ソ' -> 12477 */
    0xA5BE, 0x30BE,    /* 'ゾ' -> 12478 */
    0xA5BF, 0x30BF,    /* 'タ' -> 12479 */
    0xA5C0, 0x30C0,    /* 'ダ' -> 12480 */
    0xA5C1, 0x30C1,    /* 'チ' -> 12481 */
    0xA5C2, 0x30C2,    /* 'ヂ' -> 12482 */
    0xA5C3, 0x30C3,    /* 'ッ' -> 12483 */
    0xA5C4, 0x30C4,    /* 'ツ' -> 12484 */
    0xA5C5, 0x30C5,    /* 'ヅ' -> 12485 */
    0xA5C6, 0x30C6,    /* 'テ' -> 12486 */
    0xA5C7, 0x30C7,    /* 'デ' -> 12487 */
    0xA5C8, 0x30C8,    /* 'ト' -> 12488 */
    0xA5C9, 0x30C9,    /* 'ド' -> 12489 */
    0xA5CA, 0x30CA,    /* 'ナ' -> 12490 */
    0xA5CB, 0x30CB,    /* 'ニ' -> 12491 */
    0xA5CC, 0x30CC,    /* 'ヌ' -> 12492 */
    0xA5CD, 0x30CD,    /* 'ネ' -> 12493 */
    0xA5CE, 0x30CE,    /* 'ノ' -> 12494 */
    0xA5CF, 0x30CF,    /* 'ハ' -> 12495 */
    0xA5D0, 0x30D0,    /* 'バ' -> 12496 */
    0xA5D1, 0x30D1,    /* 'パ' -> 12497 */
    0xA5D2, 0x30D2,    /* 'ヒ' -> 12498 */
    0xA5D3, 0x30D3,    /* 'ビ' -> 12499 */
    0xA5D4, 0x30D4,    /* 'ピ' -> 12500 */
    0xA5D5, 0x30D5,    /* 'フ' -> 12501 */
    0xA5D6, 0x30D6,    /* 'ブ' -> 12502 */
    0xA5D7, 0x30D7,    /* 'プ' -> 12503 */
    0xA5D8, 0x30D8,    /* 'ヘ' -> 12504 */
    0xA5D9, 0x30D9,    /* 'ベ' -> 12505 */
    0xA5DA, 0x30DA,    /* 'ペ' -> 12506 */
    0xA5DB, 0x30DB,    /* 'ホ' -> 12507 */
    0xA5DC, 0x30DC,    /* 'ボ' -> 12508 */
    0xA5DD, 0x30DD,    /* 'ポ' -> 12509 */
    0xA5DE, 0x30DE,    /* 'マ' -> 12510 */
    0xA5DF, 0x30DF,    /* 'ミ' -> 12511 */
    0xA5E0, 0x30E0,    /* 'ム' -> 12512 */
    0xA5E1, 0x30E1,    /* 'メ' -> 12513 */
    0xA5E2, 0x30E2,    /* 'モ' -> 12514 */
    0xA5E3, 0x30E3,    /* 'ャ' -> 12515 */
    0xA5E4, 0x30E4,    /* 'ヤ' -> 12516 */
    0xA5E5, 0x30E5,    /* 'ュ' -> 12517 */
    0xA5E6, 0x30E6,    /* 'ユ' -> 12518 */
    0xA5E7, 0x30E7,    /* 'ョ' -> 12519 */
    0xA5E8, 0x30E8,    /* 'ヨ' -> 12520 */
    0xA5E9, 0x30E9,    /* 'ラ' -> 12521 */
    0xA5EA, 0x30EA,    /* 'リ' -> 12522 */
    0xA5EB, 0x30EB,    /* 'ル' -> 12523 */
    0xA5EC, 0x30EC,    /* 'レ' -> 12524 */
    0xA5ED, 0x30ED,    /* 'ロ' -> 12525 */
    0xA5EE, 0x30EE,    /* 'ヮ' -> 12526 */
    0xA5EF, 0x30EF,    /* 'ワ' -> 12527 */
    0xA5F0, 0x30F0,    /* 'ヰ' -> 12528 */
    0xA5F1, 0x30F1,    /* 'ヱ' -> 12529 */
    0xA5F2, 0x30F2,    /* 'ヲ' -> 12530 */
    0xA5F3, 0x30F3,    /* 'ン' -> 12531 */
    0xA5F4, 0x30F4,    /* 'ヴ' -> 12532 */
    0xA5F5, 0x30F5,    /* 'ヵ' -> 12533 */
    0xA5F6, 0x30F6,    /* 'ヶ' -> 12534 */
    0xA6A1, 0x0391,    /* 'Α' ->     913 */
    0xA6A2, 0x0392,    /* 'Β' ->     914 */
    0xA6A3, 0x0393,    /* 'Γ' ->     915 */
    0xA6A4, 0x0394,    /* 'Δ' ->     916 */
    0xA6A5, 0x0395,    /* 'Ε' ->     917 */
    0xA6A6, 0x0396,    /* 'Ζ' ->     918 */
    0xA6A7, 0x0397,    /* 'Η' ->     919 */
    0xA6A8, 0x0398,    /* 'Θ' ->     920 */
    0xA6A9, 0x0399,    /* 'Ι' ->     921 */
    0xA6AA, 0x039A,    /* 'Κ' ->     922 */
    0xA6AB, 0x039B,    /* 'Λ' ->     923 */
    0xA6AC, 0x039C,    /* 'Μ' ->     924 */
    0xA6AD, 0x039D,    /* 'Ν' ->     925 */
    0xA6AE, 0x039E,    /* 'Ξ' ->     926 */
    0xA6AF, 0x039F,    /* 'Ο' ->     927 */
    0xA6B0, 0x03A0,    /* 'Π' ->     928 */
    0xA6B1, 0x03A1,    /* 'Ρ' ->     929 */
    0xA6B2, 0x03A3,    /* 'Σ' ->     931 */
    0xA6B3, 0x03A4,    /* 'Τ' ->     932 */
    0xA6B4, 0x03A5,    /* 'Υ' ->     933 */
    0xA6B5, 0x03A6,    /* 'Φ' ->     934 */
    0xA6B6, 0x03A7,    /* 'Χ' ->     935 */
    0xA6B7, 0x03A8,    /* 'Ψ' ->     936 */
    0xA6B8, 0x03A9,    /* 'Ω' ->     937 */
    0xA6C1, 0x03B1,    /* 'α' ->     945 */
    0xA6C2, 0x03B2,    /* 'β' ->     946 */
    0xA6C3, 0x03B3,    /* 'γ' ->     947 */
    0xA6C4, 0x03B4,    /* 'δ' ->     948 */
    0xA6C5, 0x03B5,    /* 'ε' ->     949 */
    0xA6C6, 0x03B6,    /* 'ζ' ->     950 */
    0xA6C7, 0x03B7,    /* 'η' ->     951 */
    0xA6C8, 0x03B8,    /* 'θ' ->     952 */
    0xA6C9, 0x03B9,    /* 'ι' ->     953 */
    0xA6CA, 0x03BA,    /* 'κ' ->     954 */
    0xA6CB, 0x03BB,    /* 'λ' ->     955 */
    0xA6CC, 0x03BC,    /* 'μ' ->     956 */
    0xA6CD, 0x03BD,    /* 'ν' ->     957 */
    0xA6CE, 0x03BE,    /* 'ξ' ->     958 */
    0xA6CF, 0x03BF,    /* 'ο' ->     959 */
    0xA6D0, 0x03C0,    /* 'π' ->     960 */
    0xA6D1, 0x03C1,    /* 'ρ' ->     961 */
    0xA6D2, 0x03C3,    /* 'σ' ->     963 */
    0xA6D3, 0x03C4,    /* 'τ' ->     964 */
    0xA6D4, 0x03C5,    /* 'υ' ->     965 */
    0xA6D5, 0x03C6,    /* 'φ' ->     966 */
    0xA6D6, 0x03C7,    /* 'χ' ->     967 */
    0xA6D7, 0x03C8,    /* 'ψ' ->     968 */
    0xA6D8, 0x03C9,    /* 'ω' ->     969 */
    0xA7A1, 0x0410,    /* 'А' ->    1040 */
    0xA7A2, 0x0411,    /* 'Б' ->    1041 */
    0xA7A3, 0x0412,    /* 'В' ->    1042 */
    0xA7A4, 0x0413,    /* 'Г' ->    1043 */
    0xA7A5, 0x0414,    /* 'Д' ->    1044 */
    0xA7A6, 0x0415,    /* 'Е' ->    1045 */
    0xA7A7, 0x0401,    /* 'Ё' ->    1025 */
    0xA7A8, 0x0416,    /* 'Ж' ->    1046 */
    0xA7A9, 0x0417,    /* 'З' ->    1047 */
    0xA7AA, 0x0418,    /* 'И' ->    1048 */
    0xA7AB, 0x0419,    /* 'Й' ->    1049 */
    0xA7AC, 0x041A,    /* 'К' ->    1050 */
    0xA7AD, 0x041B,    /* 'Л' ->    1051 */
    0xA7AE, 0x041C,    /* 'М' ->    1052 */
    0xA7AF, 0x041D,    /* 'Н' ->    1053 */
    0xA7B0, 0x041E,    /* 'О' ->    1054 */
    0xA7B1, 0x041F,    /* 'П' ->    1055 */
    0xA7B2, 0x0420,    /* 'Р' ->    1056 */
    0xA7B3, 0x0421,    /* 'С' ->    1057 */
    0xA7B4, 0x0422,    /* 'Т' ->    1058 */
    0xA7B5, 0x0423,    /* 'У' ->    1059 */
    0xA7B6, 0x0424,    /* 'Ф' ->    1060 */
    0xA7B7, 0x0425,    /* 'Х' ->    1061 */
    0xA7B8, 0x0426,    /* 'Ц' ->    1062 */
    0xA7B9, 0x0427,    /* 'Ч' ->    1063 */
    0xA7BA, 0x0428,    /* 'Ш' ->    1064 */
    0xA7BB, 0x0429,    /* 'Щ' ->    1065 */
    0xA7BC, 0x042A,    /* 'Ъ' ->    1066 */
    0xA7BD, 0x042B,    /* 'Ы' ->    1067 */
    0xA7BE, 0x042C,    /* 'Ь' ->    1068 */
    0xA7BF, 0x042D,    /* 'Э' ->    1069 */
    0xA7C0, 0x042E,    /* 'Ю' ->    1070 */
    0xA7C1, 0x042F,    /* 'Я' ->    1071 */
    0xA7D1, 0x0430,    /* 'а' ->    1072 */
    0xA7D2, 0x0431,    /* 'б' ->    1073 */
    0xA7D3, 0x0432,    /* 'в' ->    1074 */
    0xA7D4, 0x0433,    /* 'г' ->    1075 */
    0xA7D5, 0x0434,    /* 'д' ->    1076 */
    0xA7D6, 0x0435,    /* 'е' ->    1077 */
    0xA7D7, 0x0451,    /* 'ё' ->    1105 */
    0xA7D8, 0x0436,    /* 'ж' ->    1078 */
    0xA7D9, 0x0437,    /* 'з' ->    1079 */
    0xA7DA, 0x0438,    /* 'и' ->    1080 */
    0xA7DB, 0x0439,    /* 'й' ->    1081 */
    0xA7DC, 0x043A,    /* 'к' ->    1082 */
    0xA7DD, 0x043B,    /* 'л' ->    1083 */
    0xA7DE, 0x043C,    /* 'м' ->    1084 */
    0xA7DF, 0x043D,    /* 'н' ->    1085 */
    0xA7E0, 0x043E,    /* 'о' ->    1086 */
    0xA7E1, 0x043F,    /* 'п' ->    1087 */
    0xA7E2, 0x0440,    /* 'р' ->    1088 */
    0xA7E3, 0x0441,    /* 'с' ->    1089 */
    0xA7E4, 0x0442,    /* 'т' ->    1090 */
    0xA7E5, 0x0443,    /* 'у' ->    1091 */
    0xA7E6, 0x0444,    /* 'ф' ->    1092 */
    0xA7E7, 0x0445,    /* 'х' ->    1093 */
    0xA7E8, 0x0446,    /* 'ц' ->    1094 */
    0xA7E9, 0x0447,    /* 'ч' ->    1095 */
    0xA7EA, 0x0448,    /* 'ш' ->    1096 */
    0xA7EB, 0x0449,    /* 'щ' ->    1097 */
    0xA7EC, 0x044A,    /* 'ъ' ->    1098 */
    0xA7ED, 0x044B,    /* 'ы' ->    1099 */
    0xA7EE, 0x044C,    /* 'ь' ->    1100 */
    0xA7EF, 0x044D,    /* 'э' ->    1101 */
    0xA7F0, 0x044E,    /* 'ю' ->    1102 */
    0xA7F1, 0x044F,    /* 'я' ->    1103 */
    0xA8A1, 0x0101,    /* 'ā' ->     257 */
    0xA8A2, 0x00E1,    /* 'á' ->     225 */
    0xA8A3, 0x01CE,    /* 'ǎ' ->     462 */
    0xA8A4, 0x00E0,    /* 'à' ->     224 */
    0xA8A5, 0x0113,    /* 'ē' ->     275 */
    0xA8A6, 0x00E9,    /* 'é' ->     233 */
    0xA8A7, 0x011B,    /* 'ě' ->     283 */
    0xA8A8, 0x00E8,    /* 'è' ->     232 */
    0xA8A9, 0x012B,    /* 'ī' ->     299 */
    0xA8AA, 0x00ED,    /* 'í' ->     237 */
    0xA8AB, 0x01D0,    /* 'ǐ' ->     464 */
    0xA8AC, 0x00EC,    /* 'ì' ->     236 */
    0xA8AD, 0x014D,    /* 'ō' ->     333 */
    0xA8AE, 0x00F3,    /* 'ó' ->     243 */
    0xA8AF, 0x01D2,    /* 'ǒ' ->     466 */
    0xA8B0, 0x00F2,    /* 'ò' ->     242 */
    0xA8B1, 0x016B,    /* 'ū' ->     363 */
    0xA8B2, 0x00FA,    /* 'ú' ->     250 */
    0xA8B3, 0x01D4,    /* 'ǔ' ->     468 */
    0xA8B4, 0x00F9,    /* 'ù' ->     249 */
    0xA8B5, 0x01D6,    /* 'ǖ' ->     470 */
    0xA8B6, 0x01D8,    /* 'ǘ' ->     472 */
    0xA8B7, 0x01DA,    /* 'ǚ' ->     474 */
    0xA8B8, 0x01DC,    /* 'ǜ' ->     476 */
    0xA8B9, 0x00FC,    /* 'ü' ->     252 */
    0xA8BA, 0x00EA,    /* 'ê' ->     234 */
    0xA8C5, 0x3105,    /* 'ㄅ' -> 12549 */
    0xA8C6, 0x3106,    /* 'ㄆ' -> 12550 */
    0xA8C7, 0x3107,    /* 'ㄇ' -> 12551 */
    0xA8C8, 0x3108,    /* 'ㄈ' -> 12552 */
    0xA8C9, 0x3109,    /* 'ㄉ' -> 12553 */
    0xA8CA, 0x310A,    /* 'ㄊ' -> 12554 */
    0xA8CB, 0x310B,    /* 'ㄋ' -> 12555 */
    0xA8CC, 0x310C,    /* 'ㄌ' -> 12556 */
    0xA8CD, 0x310D,    /* 'ㄍ' -> 12557 */
    0xA8CE, 0x310E,    /* 'ㄎ' -> 12558 */
    0xA8CF, 0x310F,    /* 'ㄏ' -> 12559 */
    0xA8D0, 0x3110,    /* 'ㄐ' -> 12560 */
    0xA8D1, 0x3111,    /* 'ㄑ' -> 12561 */
    0xA8D2, 0x3112,    /* 'ㄒ' -> 12562 */
    0xA8D3, 0x3113,    /* 'ㄓ' -> 12563 */
    0xA8D4, 0x3114,    /* 'ㄔ' -> 12564 */
    0xA8D5, 0x3115,    /* 'ㄕ' -> 12565 */
    0xA8D6, 0x3116,    /* 'ㄖ' -> 12566 */
    0xA8D7, 0x3117,    /* 'ㄗ' -> 12567 */
    0xA8D8, 0x3118,    /* 'ㄘ' -> 12568 */
    0xA8D9, 0x3119,    /* 'ㄙ' -> 12569 */
    0xA8DA, 0x311A,    /* 'ㄚ' -> 12570 */
    0xA8DB, 0x311B,    /* 'ㄛ' -> 12571 */
    0xA8DC, 0x311C,    /* 'ㄜ' -> 12572 */
    0xA8DD, 0x311D,    /* 'ㄝ' -> 12573 */
    0xA8DE, 0x311E,    /* 'ㄞ' -> 12574 */
    0xA8DF, 0x311F,    /* 'ㄟ' -> 12575 */
    0xA8E0, 0x3120,    /* 'ㄠ' -> 12576 */
    0xA8E1, 0x3121,    /* 'ㄡ' -> 12577 */
    0xA8E2, 0x3122,    /* 'ㄢ' -> 12578 */
    0xA8E3, 0x3123,    /* 'ㄣ' -> 12579 */
    0xA8E4, 0x3124,    /* 'ㄤ' -> 12580 */
    0xA8E5, 0x3125,    /* 'ㄥ' -> 12581 */
    0xA8E6, 0x3126,    /* 'ㄦ' -> 12582 */
    0xA8E7, 0x3127,    /* 'ㄧ' -> 12583 */
    0xA8E8, 0x3128,    /* 'ㄨ' -> 12584 */
    0xA8E9, 0x3129,    /* 'ㄩ' -> 12585 */
    0xA9A4, 0x2500,    /* '─' ->    9472 */
    0xA9A5, 0x2501,    /* '━' ->    9473 */
    0xA9A6, 0x2502,    /* '│' ->    9474 */
    0xA9A7, 0x2503,    /* '┃' ->    9475 */
    0xA9A8, 0x2504,    /* '┄' ->    9476 */
    0xA9A9, 0x2505,    /* '┅' ->    9477 */
    0xA9AA, 0x2506,    /* '┆' ->    9478 */
    0xA9AB, 0x2507,    /* '┇' ->    9479 */
    0xA9AC, 0x2508,    /* '┈' ->    9480 */
    0xA9AD, 0x2509,    /* '┉' ->    9481 */
    0xA9AE, 0x250A,    /* '┊' ->    9482 */
    0xA9AF, 0x250B,    /* '┋' ->    9483 */
    0xA9B0, 0x250C,    /* '┌' ->    9484 */
    0xA9B1, 0x250D,    /* '┍' ->    9485 */
    0xA9B2, 0x250E,    /* '┎' ->    9486 */
    0xA9B3, 0x250F,    /* '┏' ->    9487 */
    0xA9B4, 0x2510,    /* '┐' ->    9488 */
    0xA9B5, 0x2511,    /* '┑' ->    9489 */
    0xA9B6, 0x2512,    /* '┒' ->    9490 */
    0xA9B7, 0x2513,    /* '┓' ->    9491 */
    0xA9B8, 0x2514,    /* '└' ->    9492 */
    0xA9B9, 0x2515,    /* '┕' ->    9493 */
    0xA9BA, 0x2516,    /* '┖' ->    9494 */
    0xA9BB, 0x2517,    /* '┗' ->    9495 */
    0xA9BC, 0x2518,    /* '┘' ->    9496 */
    0xA9BD, 0x2519,    /* '┙' ->    9497 */
    0xA9BE, 0x251A,    /* '┚' ->    9498 */
    0xA9BF, 0x251B,    /* '┛' ->    9499 */
    0xA9C0, 0x251C,    /* '├' ->    9500 */
    0xA9C1, 0x251D,    /* '┝' ->    9501 */
    0xA9C2, 0x251E,    /* '┞' ->    9502 */
    0xA9C3, 0x251F,    /* '┟' ->    9503 */
    0xA9C4, 0x2520,    /* '┠' ->    9504 */
    0xA9C5, 0x2521,    /* '┡' ->    9505 */
    0xA9C6, 0x2522,    /* '┢' ->    9506 */
    0xA9C7, 0x2523,    /* '┣' ->    9507 */
    0xA9C8, 0x2524,    /* '┤' ->    9508 */
    0xA9C9, 0x2525,    /* '┥' ->    9509 */
    0xA9CA, 0x2526,    /* '┦' ->    9510 */
    0xA9CB, 0x2527,    /* '┧' ->    9511 */
    0xA9CC, 0x2528,    /* '┨' ->    9512 */
    0xA9CD, 0x2529,    /* '┩' ->    9513 */
    0xA9CE, 0x252A,    /* '┪' ->    9514 */
    0xA9CF, 0x252B,    /* '┫' ->    9515 */
    0xA9D0, 0x252C,    /* '┬' ->    9516 */
    0xA9D1, 0x252D,    /* '┭' ->    9517 */
    0xA9D2, 0x252E,    /* '┮' ->    9518 */
    0xA9D3, 0x252F,    /* '┯' ->    9519 */
    0xA9D4, 0x2530,    /* '┰' ->    9520 */
    0xA9D5, 0x2531,    /* '┱' ->    9521 */
    0xA9D6, 0x2532,    /* '┲' ->    9522 */
    0xA9D7, 0x2533,    /* '┳' ->    9523 */
    0xA9D8, 0x2534,    /* '┴' ->    9524 */
    0xA9D9, 0x2535,    /* '┵' ->    9525 */
    0xA9DA, 0x2536,    /* '┶' ->    9526 */
    0xA9DB, 0x2537,    /* '┷' ->    9527 */
    0xA9DC, 0x2538,    /* '┸' ->    9528 */
    0xA9DD, 0x2539,    /* '┹' ->    9529 */
    0xA9DE, 0x253A,    /* '┺' ->    9530 */
    0xA9DF, 0x253B,    /* '┻' ->    9531 */
    0xA9E0, 0x253C,    /* '┼' ->    9532 */
    0xA9E1, 0x253D,    /* '┽' ->    9533 */
    0xA9E2, 0x253E,    /* '┾' ->    9534 */
    0xA9E3, 0x253F,    /* '┿' ->    9535 */
    0xA9E4, 0x2540,    /* '╀' ->    9536 */
    0xA9E5, 0x2541,    /* '╁' ->    9537 */
    0xA9E6, 0x2542,    /* '╂' ->    9538 */
    0xA9E7, 0x2543,    /* '╃' ->    9539 */
    0xA9E8, 0x2544,    /* '╄' ->    9540 */
    0xA9E9, 0x2545,    /* '╅' ->    9541 */
    0xA9EA, 0x2546,    /* '╆' ->    9542 */
    0xA9EB, 0x2547,    /* '╇' ->    9543 */
    0xA9EC, 0x2548,    /* '╈' ->    9544 */
    0xA9ED, 0x2549,    /* '╉' ->    9545 */
    0xA9EE, 0x254A,    /* '╊' ->    9546 */
    0xA9EF, 0x254B,    /* '╋' ->    9547 */
    0xB0A1, 0x554A,    /* '啊' -> 21834 */
    0xB0A2, 0x963F,    /* '阿' -> 38463 */
    0xB0A3, 0x57C3,    /* '埃' -> 22467 */
    0xB0A4, 0x6328,    /* '挨' -> 25384 */
    0xB0A5, 0x54CE,    /* '哎' -> 21710 */
    0xB0A6, 0x5509,    /* '唉' -> 21769 */
    0xB0A7, 0x54C0,    /* '哀' -> 21696 */
    0xB0A8, 0x7691,    /* '皑' -> 30353 */
    0xB0A9, 0x764C,    /* '癌' -> 30284 */
    0xB0AA, 0x853C,    /* '蔼' -> 34108 */
    0xB0AB, 0x77EE,    /* '矮' -> 30702 */
    0xB0AC, 0x827E,    /* '艾' -> 33406 */
    0xB0AD, 0x788D,    /* '碍' -> 30861 */
    0xB0AE, 0x7231,    /* '爱' -> 29233 */
    0xB0AF, 0x9698,    /* '隘' -> 38552 */
    0xB0B0, 0x978D,    /* '鞍' -> 38797 */
    0xB0B1, 0x6C28,    /* '氨' -> 27688 */
    0xB0B2, 0x5B89,    /* '安' -> 23433 */
    0xB0B3, 0x4FFA,    /* '俺' -> 20474 */
    0xB0B4, 0x6309,    /* '按' -> 25353 */
    0xB0B5, 0x6697,    /* '暗' -> 26263 */
    0xB0B6, 0x5CB8,    /* '岸' -> 23736 */
    0xB0B7, 0x80FA,    /* '胺' -> 33018 */
    0xB0B8, 0x6848,    /* '案' -> 26696 */
    0xB0B9, 0x80AE,    /* '肮' -> 32942 */
    0xB0BA, 0x6602,    /* '昂' -> 26114 */
    0xB0BB, 0x76CE,    /* '盎' -> 30414 */
    0xB0BC, 0x51F9,    /* '凹' -> 20985 */
    0xB0BD, 0x6556,    /* '敖' -> 25942 */
    0xB0BE, 0x71AC,    /* '熬' -> 29100 */
    0xB0BF, 0x7FF1,    /* '翱' -> 32753 */
    0xB0C0, 0x8884,    /* '袄' -> 34948 */
    0xB0C1, 0x50B2,    /* '傲' -> 20658 */
    0xB0C2, 0x5965,    /* '奥' -> 22885 */
    0xB0C3, 0x61CA,    /* '懊' -> 25034 */
    0xB0C4, 0x6FB3,    /* '澳' -> 28595 */
    0xB0C5, 0x82AD,    /* '芭' -> 33453 */
    0xB0C6, 0x634C,    /* '捌' -> 25420 */
    0xB0C7, 0x6252,    /* '扒' -> 25170 */
    0xB0C8, 0x53ED,    /* '叭' -> 21485 */
    0xB0C9, 0x5427,    /* '吧' -> 21543 */
    0xB0CA, 0x7B06,    /* '笆' -> 31494 */
    0xB0CB, 0x516B,    /* '八' -> 20843 */
    0xB0CC, 0x75A4,    /* '疤' -> 30116 */
    0xB0CD, 0x5DF4,    /* '巴' -> 24052 */
    0xB0CE, 0x62D4,    /* '拔' -> 25300 */
    0xB0CF, 0x8DCB,    /* '跋' -> 36299 */
    0xB0D0, 0x9776,    /* '靶' -> 38774 */
    0xB0D1, 0x628A,    /* '把' -> 25226 */
    0xB0D2, 0x8019,    /* '耙' -> 32793 */
    0xB0D3, 0x575D,    /* '坝' -> 22365 */
    0xB0D4, 0x9738,    /* '霸' -> 38712 */
    0xB0D5, 0x7F62,    /* '罢' -> 32610 */
    0xB0D6, 0x7238,    /* '爸' -> 29240 */
    0xB0D7, 0x767D,    /* '白' -> 30333 */
    0xB0D8, 0x67CF,    /* '柏' -> 26575 */
    0xB0D9, 0x767E,    /* '百' -> 30334 */
    0xB0DA, 0x6446,    /* '摆' -> 25670 */
    0xB0DB, 0x4F70,    /* '佰' -> 20336 */
    0xB0DC, 0x8D25,    /* '败' -> 36133 */
    0xB0DD, 0x62DC,    /* '拜' -> 25308 */
    0xB0DE, 0x7A17,    /* '稗' -> 31255 */
    0xB0DF, 0x6591,    /* '斑' -> 26001 */
    0xB0E0, 0x73ED,    /* '班' -> 29677 */
    0xB0E1, 0x642C,    /* '搬' -> 25644 */
    0xB0E2, 0x6273,    /* '扳' -> 25203 */
    0xB0E3, 0x822C,    /* '般' -> 33324 */
    0xB0E4, 0x9881,    /* '颁' -> 39041 */
    0xB0E5, 0x677F,    /* '板' -> 26495 */
    0xB0E6, 0x7248,    /* '版' -> 29256 */
    0xB0E7, 0x626E,    /* '扮' -> 25198 */
    0xB0E8, 0x62CC,    /* '拌' -> 25292 */
    0xB0E9, 0x4F34,    /* '伴' -> 20276 */
    0xB0EA, 0x74E3,    /* '瓣' -> 29923 */
    0xB0EB, 0x534A,    /* '半' -> 21322 */
    0xB0EC, 0x529E,    /* '办' -> 21150 */
    0xB0ED, 0x7ECA,    /* '绊' -> 32458 */
    0xB0EE, 0x90A6,    /* '邦' -> 37030 */
    0xB0EF, 0x5E2E,    /* '帮' -> 24110 */
    0xB0F0, 0x6886,    /* '梆' -> 26758 */
    0xB0F1, 0x699C,    /* '榜' -> 27036 */
    0xB0F2, 0x8180,    /* '膀' -> 33152 */
    0xB0F3, 0x7ED1,    /* '绑' -> 32465 */
    0xB0F4, 0x68D2,    /* '棒' -> 26834 */
    0xB0F5, 0x78C5,    /* '磅' -> 30917 */
    0xB0F6, 0x868C,    /* '蚌' -> 34444 */
    0xB0F7, 0x9551,    /* '镑' -> 38225 */
    0xB0F8, 0x508D,    /* '傍' -> 20621 */
    0xB0F9, 0x8C24,    /* '谤' -> 35876 */
    0xB0FA, 0x82DE,    /* '苞' -> 33502 */
    0xB0FB, 0x80DE,    /* '胞' -> 32990 */
    0xB0FC, 0x5305,    /* '包' -> 21253 */
    0xB0FD, 0x8912,    /* '褒' -> 35090 */
    0xB0FE, 0x5265,    /* '剥' -> 21093 */
    0xB1A1, 0x8584,    /* '薄' -> 34180 */
    0xB1A2, 0x96F9,    /* '雹' -> 38649 */
    0xB1A3, 0x4FDD,    /* '保' -> 20445 */
    0xB1A4, 0x5821,    /* '堡' -> 22561 */
    0xB1A5, 0x9971,    /* '饱' -> 39281 */
    0xB1A6, 0x5B9D,    /* '宝' -> 23453 */
    0xB1A7, 0x62B1,    /* '抱' -> 25265 */
    0xB1A8, 0x62A5,    /* '报' -> 25253 */
    0xB1A9, 0x66B4,    /* '暴' -> 26292 */
    0xB1AA, 0x8C79,    /* '豹' -> 35961 */
    0xB1AB, 0x9C8D,    /* '鲍' -> 40077 */
    0xB1AC, 0x7206,    /* '爆' -> 29190 */
    0xB1AD, 0x676F,    /* '杯' -> 26479 */
    0xB1AE, 0x7891,    /* '碑' -> 30865 */
    0xB1AF, 0x60B2,    /* '悲' -> 24754 */
    0xB1B0, 0x5351,    /* '卑' -> 21329 */
    0xB1B1, 0x5317,    /* '北' -> 21271 */
    0xB1B2, 0x8F88,    /* '辈' -> 36744 */
    0xB1B3, 0x80CC,    /* '背' -> 32972 */
    0xB1B4, 0x8D1D,    /* '贝' -> 36125 */
    0xB1B5, 0x94A1,    /* '钡' -> 38049 */
    0xB1B6, 0x500D,    /* '倍' -> 20493 */
    0xB1B7, 0x72C8,    /* '狈' -> 29384 */
    0xB1B8, 0x5907,    /* '备' -> 22791 */
    0xB1B9, 0x60EB,    /* '惫' -> 24811 */
    0xB1BA, 0x7119,    /* '焙' -> 28953 */
    0xB1BB, 0x88AB,    /* '被' -> 34987 */
    0xB1BC, 0x5954,    /* '奔' -> 22868 */
    0xB1BD, 0x82EF,    /* '苯' -> 33519 */
    0xB1BE, 0x672C,    /* '本' -> 26412 */
    0xB1BF, 0x7B28,    /* '笨' -> 31528 */
    0xB1C0, 0x5D29,    /* '崩' -> 23849 */
    0xB1C1, 0x7EF7,    /* '绷' -> 32503 */
    0xB1C2, 0x752D,    /* '甭' -> 29997 */
    0xB1C3, 0x6CF5,    /* '泵' -> 27893 */
    0xB1C4, 0x8E66,    /* '蹦' -> 36454 */
    0xB1C5, 0x8FF8,    /* '迸' -> 36856 */
    0xB1C6, 0x903C,    /* '逼' -> 36924 */
    0xB1C7, 0x9F3B,    /* '鼻' -> 40763 */
    0xB1C8, 0x6BD4,    /* '比' -> 27604 */
    0xB1C9, 0x9119,    /* '鄙' -> 37145 */
    0xB1CA, 0x7B14,    /* '笔' -> 31508 */
    0xB1CB, 0x5F7C,    /* '彼' -> 24444 */
    0xB1CC, 0x78A7,    /* '碧' -> 30887 */
    0xB1CD, 0x84D6,    /* '蓖' -> 34006 */
    0xB1CE, 0x853D,    /* '蔽' -> 34109 */
    0xB1CF, 0x6BD5,    /* '毕' -> 27605 */
    0xB1D0, 0x6BD9,    /* '毙' -> 27609 */
    0xB1D1, 0x6BD6,    /* '毖' -> 27606 */
    0xB1D2, 0x5E01,    /* '币' -> 24065 */
    0xB1D3, 0x5E87,    /* '庇' -> 24199 */
    0xB1D4, 0x75F9,    /* '痹' -> 30201 */
    0xB1D5, 0x95ED,    /* '闭' -> 38381 */
    0xB1D6, 0x655D,    /* '敝' -> 25949 */
    0xB1D7, 0x5F0A,    /* '弊' -> 24330 */
    0xB1D8, 0x5FC5,    /* '必' -> 24517 */
    0xB1D9, 0x8F9F,    /* '辟' -> 36767 */
    0xB1DA, 0x58C1,    /* '壁' -> 22721 */
    0xB1DB, 0x81C2,    /* '臂' -> 33218 */
    0xB1DC, 0x907F,    /* '避' -> 36991 */
    0xB1DD, 0x965B,    /* '陛' -> 38491 */
    0xB1DE, 0x97AD,    /* '鞭' -> 38829 */
    0xB1DF, 0x8FB9,    /* '边' -> 36793 */
    0xB1E0, 0x7F16,    /* '编' -> 32534 */
    0xB1E1, 0x8D2C,    /* '贬' -> 36140 */
    0xB1E2, 0x6241,    /* '扁' -> 25153 */
    0xB1E3, 0x4FBF,    /* '便' -> 20415 */
    0xB1E4, 0x53D8,    /* '变' -> 21464 */
    0xB1E5, 0x535E,    /* '卞' -> 21342 */
    0xB1E6, 0x8FA8,    /* '辨' -> 36776 */
    0xB1E7, 0x8FA9,    /* '辩' -> 36777 */
    0xB1E8, 0x8FAB,    /* '辫' -> 36779 */
    0xB1E9, 0x904D,    /* '遍' -> 36941 */
    0xB1EA, 0x6807,    /* '标' -> 26631 */
    0xB1EB, 0x5F6A,    /* '彪' -> 24426 */
    0xB1EC, 0x8198,    /* '膘' -> 33176 */
    0xB1ED, 0x8868,    /* '表' -> 34920 */
    0xB1EE, 0x9CD6,    /* '鳖' -> 40150 */
    0xB1EF, 0x618B,    /* '憋' -> 24971 */
    0xB1F0, 0x522B,    /* '别' -> 21035 */
    0xB1F1, 0x762A,    /* '瘪' -> 30250 */
    0xB1F2, 0x5F6C,    /* '彬' -> 24428 */
    0xB1F3, 0x658C,    /* '斌' -> 25996 */
    0xB1F4, 0x6FD2,    /* '濒' -> 28626 */
    0xB1F5, 0x6EE8,    /* '滨' -> 28392 */
    0xB1F6, 0x5BBE,    /* '宾' -> 23486 */
    0xB1F7, 0x6448,    /* '摈' -> 25672 */
    0xB1F8, 0x5175,    /* '兵' -> 20853 */
    0xB1F9, 0x51B0,    /* '冰' -> 20912 */
    0xB1FA, 0x67C4,    /* '柄' -> 26564 */
    0xB1FB, 0x4E19,    /* '丙' -> 19993 */
    0xB1FC, 0x79C9,    /* '秉' -> 31177 */
    0xB1FD, 0x997C,    /* '饼' -> 39292 */
    0xB1FE, 0x70B3,    /* '炳' -> 28851 */
    0xB2A1, 0x75C5,    /* '病' -> 30149 */
    0xB2A2, 0x5E76,    /* '并' -> 24182 */
    0xB2A3, 0x73BB,    /* '玻' -> 29627 */
    0xB2A4, 0x83E0,    /* '菠' -> 33760 */
    0xB2A5, 0x64AD,    /* '播' -> 25773 */
    0xB2A6, 0x62E8,    /* '拨' -> 25320 */
    0xB2A7, 0x94B5,    /* '钵' -> 38069 */
    0xB2A8, 0x6CE2,    /* '波' -> 27874 */
    0xB2A9, 0x535A,    /* '博' -> 21338 */
    0xB2AA, 0x52C3,    /* '勃' -> 21187 */
    0xB2AB, 0x640F,    /* '搏' -> 25615 */
    0xB2AC, 0x94C2,    /* '铂' -> 38082 */
    0xB2AD, 0x7B94,    /* '箔' -> 31636 */
    0xB2AE, 0x4F2F,    /* '伯' -> 20271 */
    0xB2AF, 0x5E1B,    /* '帛' -> 24091 */
    0xB2B0, 0x8236,    /* '舶' -> 33334 */
    0xB2B1, 0x8116,    /* '脖' -> 33046 */
    0xB2B2, 0x818A,    /* '膊' -> 33162 */
    0xB2B3, 0x6E24,    /* '渤' -> 28196 */
    0xB2B4, 0x6CCA,    /* '泊' -> 27850 */
    0xB2B5, 0x9A73,    /* '驳' -> 39539 */
    0xB2B6, 0x6355,    /* '捕' -> 25429 */
    0xB2B7, 0x535C,    /* '卜' -> 21340 */
    0xB2B8, 0x54FA,    /* '哺' -> 21754 */
    0xB2B9, 0x8865,    /* '补' -> 34917 */
    0xB2BA, 0x57E0,    /* '埠' -> 22496 */
    0xB2BB, 0x4E0D,    /* '不' -> 19981 */
    0xB2BC, 0x5E03,    /* '布' -> 24067 */
    0xB2BD, 0x6B65,    /* '步' -> 27493 */
    0xB2BE, 0x7C3F,    /* '簿' -> 31807 */
    0xB2BF, 0x90E8,    /* '部' -> 37096 */
    0xB2C0, 0x6016,    /* '怖' -> 24598 */
    0xB2C1, 0x64E6,    /* '擦' -> 25830 */
    0xB2C2, 0x731C,    /* '猜' -> 29468 */
    0xB2C3, 0x88C1,    /* '裁' -> 35009 */
    0xB2C4, 0x6750,    /* '材' -> 26448 */
    0xB2C5, 0x624D,    /* '才' -> 25165 */
    0xB2C6, 0x8D22,    /* '财' -> 36130 */
    0xB2C7, 0x776C,    /* '睬' -> 30572 */
    0xB2C8, 0x8E29,    /* '踩' -> 36393 */
    0xB2C9, 0x91C7,    /* '采' -> 37319 */
    0xB2CA, 0x5F69,    /* '彩' -> 24425 */
    0xB2CB, 0x83DC,    /* '菜' -> 33756 */
    0xB2CC, 0x8521,    /* '蔡' -> 34081 */
    0xB2CD, 0x9910,    /* '餐' -> 39184 */
    0xB2CE, 0x53C2,    /* '参' -> 21442 */
    0xB2CF, 0x8695,    /* '蚕' -> 34453 */
    0xB2D0, 0x6B8B,    /* '残' -> 27531 */
    0xB2D1, 0x60ED,    /* '惭' -> 24813 */
    0xB2D2, 0x60E8,    /* '惨' -> 24808 */
    0xB2D3, 0x707F,    /* '灿' -> 28799 */
    0xB2D4, 0x82CD,    /* '苍' -> 33485 */
    0xB2D5, 0x8231,    /* '舱' -> 33329 */
    0xB2D6, 0x4ED3,    /* '仓' -> 20179 */
    0xB2D7, 0x6CA7,    /* '沧' -> 27815 */
    0xB2D8, 0x85CF,    /* '藏' -> 34255 */
    0xB2D9, 0x64CD,    /* '操' -> 25805 */
    0xB2DA, 0x7CD9,    /* '糙' -> 31961 */
    0xB2DB, 0x69FD,    /* '槽' -> 27133 */
    0xB2DC, 0x66F9,    /* '曹' -> 26361 */
    0xB2DD, 0x8349,    /* '草' -> 33609 */
    0xB2DE, 0x5395,    /* '厕' -> 21397 */
    0xB2DF, 0x7B56,    /* '策' -> 31574 */
    0xB2E0, 0x4FA7,    /* '侧' -> 20391 */
    0xB2E1, 0x518C,    /* '册' -> 20876 */
    0xB2E2, 0x6D4B,    /* '测' -> 27979 */
    0xB2E3, 0x5C42,    /* '层' -> 23618 */
    0xB2E4, 0x8E6D,    /* '蹭' -> 36461 */
    0xB2E5, 0x63D2,    /* '插' -> 25554 */
    0xB2E6, 0x53C9,    /* '叉' -> 21449 */
    0xB2E7, 0x832C,    /* '茬' -> 33580 */
    0xB2E8, 0x8336,    /* '茶' -> 33590 */
    0xB2E9, 0x67E5,    /* '查' -> 26597 */
    0xB2EA, 0x78B4,    /* '碴' -> 30900 */
    0xB2EB, 0x643D,    /* '搽' -> 25661 */
    0xB2EC, 0x5BDF,    /* '察' -> 23519 */
    0xB2ED, 0x5C94,    /* '岔' -> 23700 */
    0xB2EE, 0x5DEE,    /* '差' -> 24046 */
    0xB2EF, 0x8BE7,    /* '诧' -> 35815 */
    0xB2F0, 0x62C6,    /* '拆' -> 25286 */
    0xB2F1, 0x67F4,    /* '柴' -> 26612 */
    0xB2F2, 0x8C7A,    /* '豺' -> 35962 */
    0xB2F3, 0x6400,    /* '搀' -> 25600 */
    0xB2F4, 0x63BA,    /* '掺' -> 25530 */
    0xB2F5, 0x8749,    /* '蝉' -> 34633 */
    0xB2F6, 0x998B,    /* '馋' -> 39307 */
    0xB2F7, 0x8C17,    /* '谗' -> 35863 */
    0xB2F8, 0x7F20,    /* '缠' -> 32544 */
    0xB2F9, 0x94F2,    /* '铲' -> 38130 */
    0xB2FA, 0x4EA7,    /* '产' -> 20135 */
    0xB2FB, 0x9610,    /* '阐' -> 38416 */
    0xB2FC, 0x98A4,    /* '颤' -> 39076 */
    0xB2FD, 0x660C,    /* '昌' -> 26124 */
    0xB2FE, 0x7316,    /* '猖' -> 29462 */
    0xB3A1, 0x573A,    /* '场' -> 22330 */
    0xB3A2, 0x5C1D,    /* '尝' -> 23581 */
    0xB3A3, 0x5E38,    /* '常' -> 24120 */
    0xB3A4, 0x957F,    /* '长' -> 38271 */
    0xB3A5, 0x507F,    /* '偿' -> 20607 */
    0xB3A6, 0x80A0,    /* '肠' -> 32928 */
    0xB3A7, 0x5382,    /* '厂' -> 21378 */
    0xB3A8, 0x655E,    /* '敞' -> 25950 */
    0xB3A9, 0x7545,    /* '畅' -> 30021 */
    0xB3AA, 0x5531,    /* '唱' -> 21809 */
    0xB3AB, 0x5021,    /* '倡' -> 20513 */
    0xB3AC, 0x8D85,    /* '超' -> 36229 */
    0xB3AD, 0x6284,    /* '抄' -> 25220 */
    0xB3AE, 0x949E,    /* '钞' -> 38046 */
    0xB3AF, 0x671D,    /* '朝' -> 26397 */
    0xB3B0, 0x5632,    /* '嘲' -> 22066 */
    0xB3B1, 0x6F6E,    /* '潮' -> 28526 */
    0xB3B2, 0x5DE2,    /* '巢' -> 24034 */
    0xB3B3, 0x5435,    /* '吵' -> 21557 */
    0xB3B4, 0x7092,    /* '炒' -> 28818 */
    0xB3B5, 0x8F66,    /* '车' -> 36710 */
    0xB3B6, 0x626F,    /* '扯' -> 25199 */
    0xB3B7, 0x64A4,    /* '撤' -> 25764 */
    0xB3B8, 0x63A3,    /* '掣' -> 25507 */
    0xB3B9, 0x5F7B,    /* '彻' -> 24443 */
    0xB3BA, 0x6F88,    /* '澈' -> 28552 */
    0xB3BB, 0x90F4,    /* '郴' -> 37108 */
    0xB3BC, 0x81E3,    /* '臣' -> 33251 */
    0xB3BD, 0x8FB0,    /* '辰' -> 36784 */
    0xB3BE, 0x5C18,    /* '尘' -> 23576 */
    0xB3BF, 0x6668,    /* '晨' -> 26216 */
    0xB3C0, 0x5FF1,    /* '忱' -> 24561 */
    0xB3C1, 0x6C89,    /* '沉' -> 27785 */
    0xB3C2, 0x9648,    /* '陈' -> 38472 */
    0xB3C3, 0x8D81,    /* '趁' -> 36225 */
    0xB3C4, 0x886C,    /* '衬' -> 34924 */
    0xB3C5, 0x6491,    /* '撑' -> 25745 */
    0xB3C6, 0x79F0,    /* '称' -> 31216 */
    0xB3C7, 0x57CE,    /* '城' -> 22478 */
    0xB3C8, 0x6A59,    /* '橙' -> 27225 */
    0xB3C9, 0x6210,    /* '成' -> 25104 */
    0xB3CA, 0x5448,    /* '呈' -> 21576 */
    0xB3CB, 0x4E58,    /* '乘' -> 20056 */
    0xB3CC, 0x7A0B,    /* '程' -> 31243 */
    0xB3CD, 0x60E9,    /* '惩' -> 24809 */
    0xB3CE, 0x6F84,    /* '澄' -> 28548 */
    0xB3CF, 0x8BDA,    /* '诚' -> 35802 */
    0xB3D0, 0x627F,    /* '承' -> 25215 */
    0xB3D1, 0x901E,    /* '逞' -> 36894 */
    0xB3D2, 0x9A8B,    /* '骋' -> 39563 */
    0xB3D3, 0x79E4,    /* '秤' -> 31204 */
    0xB3D4, 0x5403,    /* '吃' -> 21507 */
    0xB3D5, 0x75F4,    /* '痴' -> 30196 */
    0xB3D6, 0x6301,    /* '持' -> 25345 */
    0xB3D7, 0x5319,    /* '匙' -> 21273 */
    0xB3D8, 0x6C60,    /* '池' -> 27744 */
    0xB3D9, 0x8FDF,    /* '迟' -> 36831 */
    0xB3DA, 0x5F1B,    /* '弛' -> 24347 */
    0xB3DB, 0x9A70,    /* '驰' -> 39536 */
    0xB3DC, 0x803B,    /* '耻' -> 32827 */
    0xB3DD, 0x9F7F,    /* '齿' -> 40831 */
    0xB3DE, 0x4F88,    /* '侈' -> 20360 */
    0xB3DF, 0x5C3A,    /* '尺' -> 23610 */
    0xB3E0, 0x8D64,    /* '赤' -> 36196 */
    0xB3E1, 0x7FC5,    /* '翅' -> 32709 */
    0xB3E2, 0x65A5,    /* '斥' -> 26021 */
    0xB3E3, 0x70BD,    /* '炽' -> 28861 */
    0xB3E4, 0x5145,    /* '充' -> 20805 */
    0xB3E5, 0x51B2,    /* '冲' -> 20914 */
    0xB3E6, 0x866B,    /* '虫' -> 34411 */
    0xB3E7, 0x5D07,    /* '崇' -> 23815 */
    0xB3E8, 0x5BA0,    /* '宠' -> 23456 */
    0xB3E9, 0x62BD,    /* '抽' -> 25277 */
    0xB3EA, 0x916C,    /* '酬' -> 37228 */
    0xB3EB, 0x7574,    /* '畴' -> 30068 */
    0xB3EC, 0x8E0C,    /* '踌' -> 36364 */
    0xB3ED, 0x7A20,    /* '稠' -> 31264 */
    0xB3EE, 0x6101,    /* '愁' -> 24833 */
    0xB3EF, 0x7B79,    /* '筹' -> 31609 */
    0xB3F0, 0x4EC7,    /* '仇' -> 20167 */
    0xB3F1, 0x7EF8,    /* '绸' -> 32504 */
    0xB3F2, 0x7785,    /* '瞅' -> 30597 */
    0xB3F3, 0x4E11,    /* '丑' -> 19985 */
    0xB3F4, 0x81ED,    /* '臭' -> 33261 */
    0xB3F5, 0x521D,    /* '初' -> 21021 */
    0xB3F6, 0x51FA,    /* '出' -> 20986 */
    0xB3F7, 0x6A71,    /* '橱' -> 27249 */
    0xB3F8, 0x53A8,    /* '厨' -> 21416 */
    0xB3F9, 0x8E87,    /* '躇' -> 36487 */
    0xB3FA, 0x9504,    /* '锄' -> 38148 */
    0xB3FB, 0x96CF,    /* '雏' -> 38607 */
    0xB3FC, 0x6EC1,    /* '滁' -> 28353 */
    0xB3FD, 0x9664,    /* '除' -> 38500 */
    0xB3FE, 0x695A,    /* '楚' -> 26970 */
    0xB4A1, 0x7840,    /* '础' -> 30784 */
    0xB4A2, 0x50A8,    /* '储' -> 20648 */
    0xB4A3, 0x77D7,    /* '矗' -> 30679 */
    0xB4A4, 0x6410,    /* '搐' -> 25616 */
    0xB4A5, 0x89E6,    /* '触' -> 35302 */
    0xB4A6, 0x5904,    /* '处' -> 22788 */
    0xB4A7, 0x63E3,    /* '揣' -> 25571 */
    0xB4A8, 0x5DDD,    /* '川' -> 24029 */
    0xB4A9, 0x7A7F,    /* '穿' -> 31359 */
    0xB4AA, 0x693D,    /* '椽' -> 26941 */
    0xB4AB, 0x4F20,    /* '传' -> 20256 */
    0xB4AC, 0x8239,    /* '船' -> 33337 */
    0xB4AD, 0x5598,    /* '喘' -> 21912 */
    0xB4AE, 0x4E32,    /* '串' -> 20018 */
    0xB4AF, 0x75AE,    /* '疮' -> 30126 */
    0xB4B0, 0x7A97,    /* '窗' -> 31383 */
    0xB4B1, 0x5E62,    /* '幢' -> 24162 */
    0xB4B2, 0x5E8A,    /* '床' -> 24202 */
    0xB4B3, 0x95EF,    /* '闯' -> 38383 */
    0xB4B4, 0x521B,    /* '创' -> 21019 */
    0xB4B5, 0x5439,    /* '吹' -> 21561 */
    0xB4B6, 0x708A,    /* '炊' -> 28810 */
    0xB4B7, 0x6376,    /* '捶' -> 25462 */
    0xB4B8, 0x9524,    /* '锤' -> 38180 */
    0xB4B9, 0x5782,    /* '垂' -> 22402 */
    0xB4BA, 0x6625,    /* '春' -> 26149 */
    0xB4BB, 0x693F,    /* '椿' -> 26943 */
    0xB4BC, 0x9187,    /* '醇' -> 37255 */
    0xB4BD, 0x5507,    /* '唇' -> 21767 */
    0xB4BE, 0x6DF3,    /* '淳' -> 28147 */
    0xB4BF, 0x7EAF,    /* '纯' -> 32431 */
    0xB4C0, 0x8822,    /* '蠢' -> 34850 */
    0xB4C1, 0x6233,    /* '戳' -> 25139 */
    0xB4C2, 0x7EF0,    /* '绰' -> 32496 */
    0xB4C3, 0x75B5,    /* '疵' -> 30133 */
    0xB4C4, 0x8328,    /* '茨' -> 33576 */
    0xB4C5, 0x78C1,    /* '磁' -> 30913 */
    0xB4C6, 0x96CC,    /* '雌' -> 38604 */
    0xB4C7, 0x8F9E,    /* '辞' -> 36766 */
    0xB4C8, 0x6148,    /* '慈' -> 24904 */
    0xB4C9, 0x74F7,    /* '瓷' -> 29943 */
    0xB4CA, 0x8BCD,    /* '词' -> 35789 */
    0xB4CB, 0x6B64,    /* '此' -> 27492 */
    0xB4CC, 0x523A,    /* '刺' -> 21050 */
    0xB4CD, 0x8D50,    /* '赐' -> 36176 */
    0xB4CE, 0x6B21,    /* '次' -> 27425 */
    0xB4CF, 0x806A,    /* '聪' -> 32874 */
    0xB4D0, 0x8471,    /* '葱' -> 33905 */
    0xB4D1, 0x56F1,    /* '囱' -> 22257 */
    0xB4D2, 0x5306,    /* '匆' -> 21254 */
    0xB4D3, 0x4ECE,    /* '从' -> 20174 */
    0xB4D4, 0x4E1B,    /* '丛' -> 19995 */
    0xB4D5, 0x51D1,    /* '凑' -> 20945 */
    0xB4D6, 0x7C97,    /* '粗' -> 31895 */
    0xB4D7, 0x918B,    /* '醋' -> 37259 */
    0xB4D8, 0x7C07,    /* '簇' -> 31751 */
    0xB4D9, 0x4FC3,    /* '促' -> 20419 */
    0xB4DA, 0x8E7F,    /* '蹿' -> 36479 */
    0xB4DB, 0x7BE1,    /* '篡' -> 31713 */
    0xB4DC, 0x7A9C,    /* '窜' -> 31388 */
    0xB4DD, 0x6467,    /* '摧' -> 25703 */
    0xB4DE, 0x5D14,    /* '崔' -> 23828 */
    0xB4DF, 0x50AC,    /* '催' -> 20652 */
    0xB4E0, 0x8106,    /* '脆' -> 33030 */
    0xB4E1, 0x7601,    /* '瘁' -> 30209 */
    0xB4E2, 0x7CB9,    /* '粹' -> 31929 */
    0xB4E3, 0x6DEC,    /* '淬' -> 28140 */
    0xB4E4, 0x7FE0,    /* '翠' -> 32736 */
    0xB4E5, 0x6751,    /* '村' -> 26449 */
    0xB4E6, 0x5B58,    /* '存' -> 23384 */
    0xB4E7, 0x5BF8,    /* '寸' -> 23544 */
    0xB4E8, 0x78CB,    /* '磋' -> 30923 */
    0xB4E9, 0x64AE,    /* '撮' -> 25774 */
    0xB4EA, 0x6413,    /* '搓' -> 25619 */
    0xB4EB, 0x63AA,    /* '措' -> 25514 */
    0xB4EC, 0x632B,    /* '挫' -> 25387 */
    0xB4ED, 0x9519,    /* '错' -> 38169 */
    0xB4EE, 0x642D,    /* '搭' -> 25645 */
    0xB4EF, 0x8FBE,    /* '达' -> 36798 */
    0xB4F0, 0x7B54,    /* '答' -> 31572 */
    0xB4F1, 0x7629,    /* '瘩' -> 30249 */
    0xB4F2, 0x6253,    /* '打' -> 25171 */
    0xB4F3, 0x5927,    /* '大' -> 22823 */
    0xB4F4, 0x5446,    /* '呆' -> 21574 */
    0xB4F5, 0x6B79,    /* '歹' -> 27513 */
    0xB4F6, 0x50A3,    /* '傣' -> 20643 */
    0xB4F7, 0x6234,    /* '戴' -> 25140 */
    0xB4F8, 0x5E26,    /* '带' -> 24102 */
    0xB4F9, 0x6B86,    /* '殆' -> 27526 */
    0xB4FA, 0x4EE3,    /* '代' -> 20195 */
    0xB4FB, 0x8D37,    /* '贷' -> 36151 */
    0xB4FC, 0x888B,    /* '袋' -> 34955 */
    0xB4FD, 0x5F85,    /* '待' -> 24453 */
    0xB4FE, 0x902E,    /* '逮' -> 36910 */
    0xB5A1, 0x6020,    /* '怠' -> 24608 */
    0xB5A2, 0x803D,    /* '耽' -> 32829 */
    0xB5A3, 0x62C5,    /* '担' -> 25285 */
    0xB5A4, 0x4E39,    /* '丹' -> 20025 */
    0xB5A5, 0x5355,    /* '单' -> 21333 */
    0xB5A6, 0x90F8,    /* '郸' -> 37112 */
    0xB5A7, 0x63B8,    /* '掸' -> 25528 */
    0xB5A8, 0x80C6,    /* '胆' -> 32966 */
    0xB5A9, 0x65E6,    /* '旦' -> 26086 */
    0xB5AA, 0x6C2E,    /* '氮' -> 27694 */
    0xB5AB, 0x4F46,    /* '但' -> 20294 */
    0xB5AC, 0x60EE,    /* '惮' -> 24814 */
    0xB5AD, 0x6DE1,    /* '淡' -> 28129 */
    0xB5AE, 0x8BDE,    /* '诞' -> 35806 */
    0xB5AF, 0x5F39,    /* '弹' -> 24377 */
    0xB5B0, 0x86CB,    /* '蛋' -> 34507 */
    0xB5B1, 0x5F53,    /* '当' -> 24403 */
    0xB5B2, 0x6321,    /* '挡' -> 25377 */
    0xB5B3, 0x515A,    /* '党' -> 20826 */
    0xB5B4, 0x8361,    /* '荡' -> 33633 */
    0xB5B5, 0x6863,    /* '档' -> 26723 */
    0xB5B6, 0x5200,    /* '刀' -> 20992 */
    0xB5B7, 0x6363,    /* '捣' -> 25443 */
    0xB5B8, 0x8E48,    /* '蹈' -> 36424 */
    0xB5B9, 0x5012,    /* '倒' -> 20498 */
    0xB5BA, 0x5C9B,    /* '岛' -> 23707 */
    0xB5BB, 0x7977,    /* '祷' -> 31095 */
    0xB5BC, 0x5BFC,    /* '导' -> 23548 */
    0xB5BD, 0x5230,    /* '到' -> 21040 */
    0xB5BE, 0x7A3B,    /* '稻' -> 31291 */
    0xB5BF, 0x60BC,    /* '悼' -> 24764 */
    0xB5C0, 0x9053,    /* '道' -> 36947 */
    0xB5C1, 0x76D7,    /* '盗' -> 30423 */
    0xB5C2, 0x5FB7,    /* '德' -> 24503 */
    0xB5C3, 0x5F97,    /* '得' -> 24471 */
    0xB5C4, 0x7684,    /* '的' -> 30340 */
    0xB5C5, 0x8E6C,    /* '蹬' -> 36460 */
    0xB5C6, 0x706F,    /* '灯' -> 28783 */
    0xB5C7, 0x767B,    /* '登' -> 30331 */
    0xB5C8, 0x7B49,    /* '等' -> 31561 */
    0xB5C9, 0x77AA,    /* '瞪' -> 30634 */
    0xB5CA, 0x51F3,    /* '凳' -> 20979 */
    0xB5CB, 0x9093,    /* '邓' -> 37011 */
    0xB5CC, 0x5824,    /* '堤' -> 22564 */
    0xB5CD, 0x4F4E,    /* '低' -> 20302 */
    0xB5CE, 0x6EF4,    /* '滴' -> 28404 */
    0xB5CF, 0x8FEA,    /* '迪' -> 36842 */
    0xB5D0, 0x654C,    /* '敌' -> 25932 */
    0xB5D1, 0x7B1B,    /* '笛' -> 31515 */
    0xB5D2, 0x72C4,    /* '狄' -> 29380 */
    0xB5D3, 0x6DA4,    /* '涤' -> 28068 */
    0xB5D4, 0x7FDF,    /* '翟' -> 32735 */
    0xB5D5, 0x5AE1,    /* '嫡' -> 23265 */
    0xB5D6, 0x62B5,    /* '抵' -> 25269 */
    0xB5D7, 0x5E95,    /* '底' -> 24213 */
    0xB5D8, 0x5730,    /* '地' -> 22320 */
    0xB5D9, 0x8482,    /* '蒂' -> 33922 */
    0xB5DA, 0x7B2C,    /* '第' -> 31532 */
    0xB5DB, 0x5E1D,    /* '帝' -> 24093 */
    0xB5DC, 0x5F1F,    /* '弟' -> 24351 */
    0xB5DD, 0x9012,    /* '递' -> 36882 */
    0xB5DE, 0x7F14,    /* '缔' -> 32532 */
    0xB5DF, 0x98A0,    /* '颠' -> 39072 */
    0xB5E0, 0x6382,    /* '掂' -> 25474 */
    0xB5E1, 0x6EC7,    /* '滇' -> 28359 */
    0xB5E2, 0x7898,    /* '碘' -> 30872 */
    0xB5E3, 0x70B9,    /* '点' -> 28857 */
    0xB5E4, 0x5178,    /* '典' -> 20856 */
    0xB5E5, 0x975B,    /* '靛' -> 38747 */
    0xB5E6, 0x57AB,    /* '垫' -> 22443 */
    0xB5E7, 0x7535,    /* '电' -> 30005 */
    0xB5E8, 0x4F43,    /* '佃' -> 20291 */
    0xB5E9, 0x7538,    /* '甸' -> 30008 */
    0xB5EA, 0x5E97,    /* '店' -> 24215 */
    0xB5EB, 0x60E6,    /* '惦' -> 24806 */
    0xB5EC, 0x5960,    /* '奠' -> 22880 */
    0xB5ED, 0x6DC0,    /* '淀' -> 28096 */
    0xB5EE, 0x6BBF,    /* '殿' -> 27583 */
    0xB5EF, 0x7889,    /* '碉' -> 30857 */
    0xB5F0, 0x53FC,    /* '叼' -> 21500 */
    0xB5F1, 0x96D5,    /* '雕' -> 38613 */
    0xB5F2, 0x51CB,    /* '凋' -> 20939 */
    0xB5F3, 0x5201,    /* '刁' -> 20993 */
    0xB5F4, 0x6389,    /* '掉' -> 25481 */
    0xB5F5, 0x540A,    /* '吊' -> 21514 */
    0xB5F6, 0x9493,    /* '钓' -> 38035 */
    0xB5F7, 0x8C03,    /* '调' -> 35843 */
    0xB5F8, 0x8DCC,    /* '跌' -> 36300 */
    0xB5F9, 0x7239,    /* '爹' -> 29241 */
    0xB5FA, 0x789F,    /* '碟' -> 30879 */
    0xB5FB, 0x8776,    /* '蝶' -> 34678 */
    0xB5FC, 0x8FED,    /* '迭' -> 36845 */
    0xB5FD, 0x8C0D,    /* '谍' -> 35853 */
    0xB5FE, 0x53E0,    /* '叠' -> 21472 */
    0xB6A1, 0x4E01,    /* '丁' -> 19969 */
    0xB6A2, 0x76EF,    /* '盯' -> 30447 */
    0xB6A3, 0x53EE,    /* '叮' -> 21486 */
    0xB6A4, 0x9489,    /* '钉' -> 38025 */
    0xB6A5, 0x9876,    /* '顶' -> 39030 */
    0xB6A6, 0x9F0E,    /* '鼎' -> 40718 */
    0xB6A7, 0x952D,    /* '锭' -> 38189 */
    0xB6A8, 0x5B9A,    /* '定' -> 23450 */
    0xB6A9, 0x8BA2,    /* '订' -> 35746 */
    0xB6AA, 0x4E22,    /* '丢' -> 20002 */
    0xB6AB, 0x4E1C,    /* '东' -> 19996 */
    0xB6AC, 0x51AC,    /* '冬' -> 20908 */
    0xB6AD, 0x8463,    /* '董' -> 33891 */
    0xB6AE, 0x61C2,    /* '懂' -> 25026 */
    0xB6AF, 0x52A8,    /* '动' -> 21160 */
    0xB6B0, 0x680B,    /* '栋' -> 26635 */
    0xB6B1, 0x4F97,    /* '侗' -> 20375 */
    0xB6B2, 0x606B,    /* '恫' -> 24683 */
    0xB6B3, 0x51BB,    /* '冻' -> 20923 */
    0xB6B4, 0x6D1E,    /* '洞' -> 27934 */
    0xB6B5, 0x515C,    /* '兜' -> 20828 */
    0xB6B6, 0x6296,    /* '抖' -> 25238 */
    0xB6B7, 0x6597,    /* '斗' -> 26007 */
    0xB6B8, 0x9661,    /* '陡' -> 38497 */
    0xB6B9, 0x8C46,    /* '豆' -> 35910 */
    0xB6BA, 0x9017,    /* '逗' -> 36887 */
    0xB6BB, 0x75D8,    /* '痘' -> 30168 */
    0xB6BC, 0x90FD,    /* '都' -> 37117 */
    0xB6BD, 0x7763,    /* '督' -> 30563 */
    0xB6BE, 0x6BD2,    /* '毒' -> 27602 */
    0xB6BF, 0x728A,    /* '犊' -> 29322 */
    0xB6C0, 0x72EC,    /* '独' -> 29420 */
    0xB6C1, 0x8BFB,    /* '读' -> 35835 */
    0xB6C2, 0x5835,    /* '堵' -> 22581 */
    0xB6C3, 0x7779,    /* '睹' -> 30585 */
    0xB6C4, 0x8D4C,    /* '赌' -> 36172 */
    0xB6C5, 0x675C,    /* '杜' -> 26460 */
    0xB6C6, 0x9540,    /* '镀' -> 38208 */
    0xB6C7, 0x809A,    /* '肚' -> 32922 */
    0xB6C8, 0x5EA6,    /* '度' -> 24230 */
    0xB6C9, 0x6E21,    /* '渡' -> 28193 */
    0xB6CA, 0x5992,    /* '妒' -> 22930 */
    0xB6CB, 0x7AEF,    /* '端' -> 31471 */
    0xB6CC, 0x77ED,    /* '短' -> 30701 */
    0xB6CD, 0x953B,    /* '锻' -> 38203 */
    0xB6CE, 0x6BB5,    /* '段' -> 27573 */
    0xB6CF, 0x65AD,    /* '断' -> 26029 */
    0xB6D0, 0x7F0E,    /* '缎' -> 32526 */
    0xB6D1, 0x5806,    /* '堆' -> 22534 */
    0xB6D2, 0x5151,    /* '兑' -> 20817 */
    0xB6D3, 0x961F,    /* '队' -> 38431 */
    0xB6D4, 0x5BF9,    /* '对' -> 23545 */
    0xB6D5, 0x58A9,    /* '墩' -> 22697 */
    0xB6D6, 0x5428,    /* '吨' -> 21544 */
    0xB6D7, 0x8E72,    /* '蹲' -> 36466 */
    0xB6D8, 0x6566,    /* '敦' -> 25958 */
    0xB6D9, 0x987F,    /* '顿' -> 39039 */
    0xB6DA, 0x56E4,    /* '囤' -> 22244 */
    0xB6DB, 0x949D,    /* '钝' -> 38045 */
    0xB6DC, 0x76FE,    /* '盾' -> 30462 */
    0xB6DD, 0x9041,    /* '遁' -> 36929 */
    0xB6DE, 0x6387,    /* '掇' -> 25479 */
    0xB6DF, 0x54C6,    /* '哆' -> 21702 */
    0xB6E0, 0x591A,    /* '多' -> 22810 */
    0xB6E1, 0x593A,    /* '夺' -> 22842 */
    0xB6E2, 0x579B,    /* '垛' -> 22427 */
    0xB6E3, 0x8EB2,    /* '躲' -> 36530 */
    0xB6E4, 0x6735,    /* '朵' -> 26421 */
    0xB6E5, 0x8DFA,    /* '跺' -> 36346 */
    0xB6E6, 0x8235,    /* '舵' -> 33333 */
    0xB6E7, 0x5241,    /* '剁' -> 21057 */
    0xB6E8, 0x60F0,    /* '惰' -> 24816 */
    0xB6E9, 0x5815,    /* '堕' -> 22549 */
    0xB6EA, 0x86FE,    /* '蛾' -> 34558 */
    0xB6EB, 0x5CE8,    /* '峨' -> 23784 */
    0xB6EC, 0x9E45,    /* '鹅' -> 40517 */
    0xB6ED, 0x4FC4,    /* '俄' -> 20420 */
    0xB6EE, 0x989D,    /* '额' -> 39069 */
    0xB6EF, 0x8BB9,    /* '讹' -> 35769 */
    0xB6F0, 0x5A25,    /* '娥' -> 23077 */
    0xB6F1, 0x6076,    /* '恶' -> 24694 */
    0xB6F2, 0x5384,    /* '厄' -> 21380 */
    0xB6F3, 0x627C,    /* '扼' -> 25212 */
    0xB6F4, 0x904F,    /* '遏' -> 36943 */
    0xB6F5, 0x9102,    /* '鄂' -> 37122 */
    0xB6F6, 0x997F,    /* '饿' -> 39295 */
    0xB6F7, 0x6069,    /* '恩' -> 24681 */
    0xB6F8, 0x800C,    /* '而' -> 32780 */
    0xB6F9, 0x513F,    /* '儿' -> 20799 */
    0xB6FA, 0x8033,    /* '耳' -> 32819 */
    0xB6FB, 0x5C14,    /* '尔' -> 23572 */
    0xB6FC, 0x9975,    /* '饵' -> 39285 */
    0xB6FD, 0x6D31,    /* '洱' -> 27953 */
    0xB6FE, 0x4E8C,    /* '二' -> 20108 */
    0xB7A1, 0x8D30,    /* '贰' -> 36144 */
    0xB7A2, 0x53D1,    /* '发' -> 21457 */
    0xB7A3, 0x7F5A,    /* '罚' -> 32602 */
    0xB7A4, 0x7B4F,    /* '筏' -> 31567 */
    0xB7A5, 0x4F10,    /* '伐' -> 20240 */
    0xB7A6, 0x4E4F,    /* '乏' -> 20047 */
    0xB7A7, 0x9600,    /* '阀' -> 38400 */
    0xB7A8, 0x6CD5,    /* '法' -> 27861 */
    0xB7A9, 0x73D0,    /* '珐' -> 29648 */
    0xB7AA, 0x85E9,    /* '藩' -> 34281 */
    0xB7AB, 0x5E06,    /* '帆' -> 24070 */
    0xB7AC, 0x756A,    /* '番' -> 30058 */
    0xB7AD, 0x7FFB,    /* '翻' -> 32763 */
    0xB7AE, 0x6A0A,    /* '樊' -> 27146 */
    0xB7AF, 0x77FE,    /* '矾' -> 30718 */
    0xB7B0, 0x9492,    /* '钒' -> 38034 */
    0xB7B1, 0x7E41,    /* '繁' -> 32321 */
    0xB7B2, 0x51E1,    /* '凡' -> 20961 */
    0xB7B3, 0x70E6,    /* '烦' -> 28902 */
    0xB7B4, 0x53CD,    /* '反' -> 21453 */
    0xB7B5, 0x8FD4,    /* '返' -> 36820 */
    0xB7B6, 0x8303,    /* '范' -> 33539 */
    0xB7B7, 0x8D29,    /* '贩' -> 36137 */
    0xB7B8, 0x72AF,    /* '犯' -> 29359 */
    0xB7B9, 0x996D,    /* '饭' -> 39277 */
    0xB7BA, 0x6CDB,    /* '泛' -> 27867 */
    0xB7BB, 0x574A,    /* '坊' -> 22346 */
    0xB7BC, 0x82B3,    /* '芳' -> 33459 */
    0xB7BD, 0x65B9,    /* '方' -> 26041 */
    0xB7BE, 0x80AA,    /* '肪' -> 32938 */
    0xB7BF, 0x623F,    /* '房' -> 25151 */
    0xB7C0, 0x9632,    /* '防' -> 38450 */
    0xB7C1, 0x59A8,    /* '妨' -> 22952 */
    0xB7C2, 0x4EFF,    /* '仿' -> 20223 */
    0xB7C3, 0x8BBF,    /* '访' -> 35775 */
    0xB7C4, 0x7EBA,    /* '纺' -> 32442 */
    0xB7C5, 0x653E,    /* '放' -> 25918 */
    0xB7C6, 0x83F2,    /* '菲' -> 33778 */
    0xB7C7, 0x975E,    /* '非' -> 38750 */
    0xB7C8, 0x5561,    /* '啡' -> 21857 */
    0xB7C9, 0x98DE,    /* '飞' -> 39134 */
    0xB7CA, 0x80A5,    /* '肥' -> 32933 */
    0xB7CB, 0x532A,    /* '匪' -> 21290 */
    0xB7CC, 0x8BFD,    /* '诽' -> 35837 */
    0xB7CD, 0x5420,    /* '吠' -> 21536 */
    0xB7CE, 0x80BA,    /* '肺' -> 32954 */
    0xB7CF, 0x5E9F,    /* '废' -> 24223 */
    0xB7D0, 0x6CB8,    /* '沸' -> 27832 */
    0xB7D1, 0x8D39,    /* '费' -> 36153 */
    0xB7D2, 0x82AC,    /* '芬' -> 33452 */
    0xB7D3, 0x915A,    /* '酚' -> 37210 */
    0xB7D4, 0x5429,    /* '吩' -> 21545 */
    0xB7D5, 0x6C1B,    /* '氛' -> 27675 */
    0xB7D6, 0x5206,    /* '分' -> 20998 */
    0xB7D7, 0x7EB7,    /* '纷' -> 32439 */
    0xB7D8, 0x575F,    /* '坟' -> 22367 */
    0xB7D9, 0x711A,    /* '焚' -> 28954 */
    0xB7DA, 0x6C7E,    /* '汾' -> 27774 */
    0xB7DB, 0x7C89,    /* '粉' -> 31881 */
    0xB7DC, 0x594B,    /* '奋' -> 22859 */
    0xB7DD, 0x4EFD,    /* '份' -> 20221 */
    0xB7DE, 0x5FFF,    /* '忿' -> 24575 */
    0xB7DF, 0x6124,    /* '愤' -> 24868 */
    0xB7E0, 0x7CAA,    /* '粪' -> 31914 */
    0xB7E1, 0x4E30,    /* '丰' -> 20016 */
    0xB7E2, 0x5C01,    /* '封' -> 23553 */
    0xB7E3, 0x67AB,    /* '枫' -> 26539 */
    0xB7E4, 0x8702,    /* '蜂' -> 34562 */
    0xB7E5, 0x5CF0,    /* '峰' -> 23792 */
    0xB7E6, 0x950B,    /* '锋' -> 38155 */
    0xB7E7, 0x98CE,    /* '风' -> 39118 */
    0xB7E8, 0x75AF,    /* '疯' -> 30127 */
    0xB7E9, 0x70FD,    /* '烽' -> 28925 */
    0xB7EA, 0x9022,    /* '逢' -> 36898 */
    0xB7EB, 0x51AF,    /* '冯' -> 20911 */
    0xB7EC, 0x7F1D,    /* '缝' -> 32541 */
    0xB7ED, 0x8BBD,    /* '讽' -> 35773 */
    0xB7EE, 0x5949,    /* '奉' -> 22857 */
    0xB7EF, 0x51E4,    /* '凤' -> 20964 */
    0xB7F0, 0x4F5B,    /* '佛' -> 20315 */
    0xB7F1, 0x5426,    /* '否' -> 21542 */
    0xB7F2, 0x592B,    /* '夫' -> 22827 */
    0xB7F3, 0x6577,    /* '敷' -> 25975 */
    0xB7F4, 0x80A4,    /* '肤' -> 32932 */
    0xB7F5, 0x5B75,    /* '孵' -> 23413 */
    0xB7F6, 0x6276,    /* '扶' -> 25206 */
    0xB7F7, 0x62C2,    /* '拂' -> 25282 */
    0xB7F8, 0x8F90,    /* '辐' -> 36752 */
    0xB7F9, 0x5E45,    /* '幅' -> 24133 */
    0xB7FA, 0x6C1F,    /* '氟' -> 27679 */
    0xB7FB, 0x7B26,    /* '符' -> 31526 */
    0xB7FC, 0x4F0F,    /* '伏' -> 20239 */
    0xB7FD, 0x4FD8,    /* '俘' -> 20440 */
    0xB7FE, 0x670D,    /* '服' -> 26381 */
    0xB8A1, 0x6D6E,    /* '浮' -> 28014 */
    0xB8A2, 0x6DAA,    /* '涪' -> 28074 */
    0xB8A3, 0x798F,    /* '福' -> 31119 */
    0xB8A4, 0x88B1,    /* '袱' -> 34993 */
    0xB8A5, 0x5F17,    /* '弗' -> 24343 */
    0xB8A6, 0x752B,    /* '甫' -> 29995 */
    0xB8A7, 0x629A,    /* '抚' -> 25242 */
    0xB8A8, 0x8F85,    /* '辅' -> 36741 */
    0xB8A9, 0x4FEF,    /* '俯' -> 20463 */
    0xB8AA, 0x91DC,    /* '釜' -> 37340 */
    0xB8AB, 0x65A7,    /* '斧' -> 26023 */
    0xB8AC, 0x812F,    /* '脯' -> 33071 */
    0xB8AD, 0x8151,    /* '腑' -> 33105 */
    0xB8AE, 0x5E9C,    /* '府' -> 24220 */
    0xB8AF, 0x8150,    /* '腐' -> 33104 */
    0xB8B0, 0x8D74,    /* '赴' -> 36212 */
    0xB8B1, 0x526F,    /* '副' -> 21103 */
    0xB8B2, 0x8986,    /* '覆' -> 35206 */
    0xB8B3, 0x8D4B,    /* '赋' -> 36171 */
    0xB8B4, 0x590D,    /* '复' -> 22797 */
    0xB8B5, 0x5085,    /* '傅' -> 20613 */
    0xB8B6, 0x4ED8,    /* '付' -> 20184 */
    0xB8B7, 0x961C,    /* '阜' -> 38428 */
    0xB8B8, 0x7236,    /* '父' -> 29238 */
    0xB8B9, 0x8179,    /* '腹' -> 33145 */
    0xB8BA, 0x8D1F,    /* '负' -> 36127 */
    0xB8BB, 0x5BCC,    /* '富' -> 23500 */
    0xB8BC, 0x8BA3,    /* '讣' -> 35747 */
    0xB8BD, 0x9644,    /* '附' -> 38468 */
    0xB8BE, 0x5987,    /* '妇' -> 22919 */
    0xB8BF, 0x7F1A,    /* '缚' -> 32538 */
    0xB8C0, 0x5490,    /* '咐' -> 21648 */
    0xB8C1, 0x5676,    /* '噶' -> 22134 */
    0xB8C2, 0x560E,    /* '嘎' -> 22030 */
    0xB8C3, 0x8BE5,    /* '该' -> 35813 */
    0xB8C4, 0x6539,    /* '改' -> 25913 */
    0xB8C5, 0x6982,    /* '概' -> 27010 */
    0xB8C6, 0x9499,    /* '钙' -> 38041 */
    0xB8C7, 0x76D6,    /* '盖' -> 30422 */
    0xB8C8, 0x6E89,    /* '溉' -> 28297 */
    0xB8C9, 0x5E72,    /* '干' -> 24178 */
    0xB8CA, 0x7518,    /* '甘' -> 29976 */
    0xB8CB, 0x6746,    /* '杆' -> 26438 */
    0xB8CC, 0x67D1,    /* '柑' -> 26577 */
    0xB8CD, 0x7AFF,    /* '竿' -> 31487 */
    0xB8CE, 0x809D,    /* '肝' -> 32925 */
    0xB8CF, 0x8D76,    /* '赶' -> 36214 */
    0xB8D0, 0x611F,    /* '感' -> 24863 */
    0xB8D1, 0x79C6,    /* '秆' -> 31174 */
    0xB8D2, 0x6562,    /* '敢' -> 25954 */
    0xB8D3, 0x8D63,    /* '赣' -> 36195 */
    0xB8D4, 0x5188,    /* '冈' -> 20872 */
    0xB8D5, 0x521A,    /* '刚' -> 21018 */
    0xB8D6, 0x94A2,    /* '钢' -> 38050 */
    0xB8D7, 0x7F38,    /* '缸' -> 32568 */
    0xB8D8, 0x809B,    /* '肛' -> 32923 */
    0xB8D9, 0x7EB2,    /* '纲' -> 32434 */
    0xB8DA, 0x5C97,    /* '岗' -> 23703 */
    0xB8DB, 0x6E2F,    /* '港' -> 28207 */
    0xB8DC, 0x6760,    /* '杠' -> 26464 */
    0xB8DD, 0x7BD9,    /* '篙' -> 31705 */
    0xB8DE, 0x768B,    /* '皋' -> 30347 */
    0xB8DF, 0x9AD8,    /* '高' -> 39640 */
    0xB8E0, 0x818F,    /* '膏' -> 33167 */
    0xB8E1, 0x7F94,    /* '羔' -> 32660 */
    0xB8E2, 0x7CD5,    /* '糕' -> 31957 */
    0xB8E3, 0x641E,    /* '搞' -> 25630 */
    0xB8E4, 0x9550,    /* '镐' -> 38224 */
    0xB8E5, 0x7A3F,    /* '稿' -> 31295 */
    0xB8E6, 0x544A,    /* '告' -> 21578 */
    0xB8E7, 0x54E5,    /* '哥' -> 21733 */
    0xB8E8, 0x6B4C,    /* '歌' -> 27468 */
    0xB8E9, 0x6401,    /* '搁' -> 25601 */
    0xB8EA, 0x6208,    /* '戈' -> 25096 */
    0xB8EB, 0x9E3D,    /* '鸽' -> 40509 */
    0xB8EC, 0x80F3,    /* '胳' -> 33011 */
    0xB8ED, 0x7599,    /* '疙' -> 30105 */
    0xB8EE, 0x5272,    /* '割' -> 21106 */
    0xB8EF, 0x9769,    /* '革' -> 38761 */
    0xB8F0, 0x845B,    /* '葛' -> 33883 */
    0xB8F1, 0x683C,    /* '格' -> 26684 */
    0xB8F2, 0x86E4,    /* '蛤' -> 34532 */
    0xB8F3, 0x9601,    /* '阁' -> 38401 */
    0xB8F4, 0x9694,    /* '隔' -> 38548 */
    0xB8F5, 0x94EC,    /* '铬' -> 38124 */
    0xB8F6, 0x4E2A,    /* '个' -> 20010 */
    0xB8F7, 0x5404,    /* '各' -> 21508 */
    0xB8F8, 0x7ED9,    /* '给' -> 32473 */
    0xB8F9, 0x6839,    /* '根' -> 26681 */
    0xB8FA, 0x8DDF,    /* '跟' -> 36319 */
    0xB8FB, 0x8015,    /* '耕' -> 32789 */
    0xB8FC, 0x66F4,    /* '更' -> 26356 */
    0xB8FD, 0x5E9A,    /* '庚' -> 24218 */
    0xB8FE, 0x7FB9,    /* '羹' -> 32697 */
    0xB9A1, 0x57C2,    /* '埂' -> 22466 */
    0xB9A2, 0x803F,    /* '耿' -> 32831 */
    0xB9A3, 0x6897,    /* '梗' -> 26775 */
    0xB9A4, 0x5DE5,    /* '工' -> 24037 */
    0xB9A5, 0x653B,    /* '攻' -> 25915 */
    0xB9A6, 0x529F,    /* '功' -> 21151 */
    0xB9A7, 0x606D,    /* '恭' -> 24685 */
    0xB9A8, 0x9F9A,    /* '龚' -> 40858 */
    0xB9A9, 0x4F9B,    /* '供' -> 20379 */
    0xB9AA, 0x8EAC,    /* '躬' -> 36524 */
    0xB9AB, 0x516C,    /* '公' -> 20844 */
    0xB9AC, 0x5BAB,    /* '宫' -> 23467 */
    0xB9AD, 0x5F13,    /* '弓' -> 24339 */
    0xB9AE, 0x5DE9,    /* '巩' -> 24041 */
    0xB9AF, 0x6C5E,    /* '汞' -> 27742 */
    0xB9B0, 0x62F1,    /* '拱' -> 25329 */
    0xB9B1, 0x8D21,    /* '贡' -> 36129 */
    0xB9B2, 0x5171,    /* '共' -> 20849 */
    0xB9B3, 0x94A9,    /* '钩' -> 38057 */
    0xB9B4, 0x52FE,    /* '勾' -> 21246 */
    0xB9B5, 0x6C9F,    /* '沟' -> 27807 */
    0xB9B6, 0x82DF,    /* '苟' -> 33503 */
    0xB9B7, 0x72D7,    /* '狗' -> 29399 */
    0xB9B8, 0x57A2,    /* '垢' -> 22434 */
    0xB9B9, 0x6784,    /* '构' -> 26500 */
    0xB9BA, 0x8D2D,    /* '购' -> 36141 */
    0xB9BB, 0x591F,    /* '够' -> 22815 */
    0xB9BC, 0x8F9C,    /* '辜' -> 36764 */
    0xB9BD, 0x83C7,    /* '菇' -> 33735 */
    0xB9BE, 0x5495,    /* '咕' -> 21653 */
    0xB9BF, 0x7B8D,    /* '箍' -> 31629 */
    0xB9C0, 0x4F30,    /* '估' -> 20272 */
    0xB9C1, 0x6CBD,    /* '沽' -> 27837 */
    0xB9C2, 0x5B64,    /* '孤' -> 23396 */
    0xB9C3, 0x59D1,    /* '姑' -> 22993 */
    0xB9C4, 0x9F13,    /* '鼓' -> 40723 */
    0xB9C5, 0x53E4,    /* '古' -> 21476 */
    0xB9C6, 0x86CA,    /* '蛊' -> 34506 */
    0xB9C7, 0x9AA8,    /* '骨' -> 39592 */
    0xB9C8, 0x8C37,    /* '谷' -> 35895 */
    0xB9C9, 0x80A1,    /* '股' -> 32929 */
    0xB9CA, 0x6545,    /* '故' -> 25925 */
    0xB9CB, 0x987E,    /* '顾' -> 39038 */
    0xB9CC, 0x56FA,    /* '固' -> 22266 */
    0xB9CD, 0x96C7,    /* '雇' -> 38599 */
    0xB9CE, 0x522E,    /* '刮' -> 21038 */
    0xB9CF, 0x74DC,    /* '瓜' -> 29916 */
    0xB9D0, 0x5250,    /* '剐' -> 21072 */
    0xB9D1, 0x5BE1,    /* '寡' -> 23521 */
    0xB9D2, 0x6302,    /* '挂' -> 25346 */
    0xB9D3, 0x8902,    /* '褂' -> 35074 */
    0xB9D4, 0x4E56,    /* '乖' -> 20054 */
    0xB9D5, 0x62D0,    /* '拐' -> 25296 */
    0xB9D6, 0x602A,    /* '怪' -> 24618 */
    0xB9D7, 0x68FA,    /* '棺' -> 26874 */
    0xB9D8, 0x5173,    /* '关' -> 20851 */
    0xB9D9, 0x5B98,    /* '官' -> 23448 */
    0xB9DA, 0x51A0,    /* '冠' -> 20896 */
    0xB9DB, 0x89C2,    /* '观' -> 35266 */
    0xB9DC, 0x7BA1,    /* '管' -> 31649 */
    0xB9DD, 0x9986,    /* '馆' -> 39302 */
    0xB9DE, 0x7F50,    /* '罐' -> 32592 */
    0xB9DF, 0x60EF,    /* '惯' -> 24815 */
    0xB9E0, 0x704C,    /* '灌' -> 28748 */
    0xB9E1, 0x8D2F,    /* '贯' -> 36143 */
    0xB9E2, 0x5149,    /* '光' -> 20809 */
    0xB9E3, 0x5E7F,    /* '广' -> 24191 */
    0xB9E4, 0x901B,    /* '逛' -> 36891 */
    0xB9E5, 0x7470,    /* '瑰' -> 29808 */
    0xB9E6, 0x89C4,    /* '规' -> 35268 */
    0xB9E7, 0x572D,    /* '圭' -> 22317 */
    0xB9E8, 0x7845,    /* '硅' -> 30789 */
    0xB9E9, 0x5F52,    /* '归' -> 24402 */
    0xB9EA, 0x9F9F,    /* '龟' -> 40863 */
    0xB9EB, 0x95FA,    /* '闺' -> 38394 */
    0xB9EC, 0x8F68,    /* '轨' -> 36712 */
    0xB9ED, 0x9B3C,    /* '鬼' -> 39740 */
    0xB9EE, 0x8BE1,    /* '诡' -> 35809 */
    0xB9EF, 0x7678,    /* '癸' -> 30328 */
    0xB9F0, 0x6842,    /* '桂' -> 26690 */
    0xB9F1, 0x67DC,    /* '柜' -> 26588 */
    0xB9F2, 0x8DEA,    /* '跪' -> 36330 */
    0xB9F3, 0x8D35,    /* '贵' -> 36149 */
    0xB9F4, 0x523D,    /* '刽' -> 21053 */
    0xB9F5, 0x8F8A,    /* '辊' -> 36746 */
    0xB9F6, 0x6EDA,    /* '滚' -> 28378 */
    0xB9F7, 0x68CD,    /* '棍' -> 26829 */
    0xB9F8, 0x9505,    /* '锅' -> 38149 */
    0xB9F9, 0x90ED,    /* '郭' -> 37101 */
    0xB9FA, 0x56FD,    /* '国' -> 22269 */
    0xB9FB, 0x679C,    /* '果' -> 26524 */
    0xB9FC, 0x88F9,    /* '裹' -> 35065 */
    0xB9FD, 0x8FC7,    /* '过' -> 36807 */
    0xB9FE, 0x54C8,    /* '哈' -> 21704 */
    0xBAA1, 0x9AB8,    /* '骸' -> 39608 */
    0xBAA2, 0x5B69,    /* '孩' -> 23401 */
    0xBAA3, 0x6D77,    /* '海' -> 28023 */
    0xBAA4, 0x6C26,    /* '氦' -> 27686 */
    0xBAA5, 0x4EA5,    /* '亥' -> 20133 */
    0xBAA6, 0x5BB3,    /* '害' -> 23475 */
    0xBAA7, 0x9A87,    /* '骇' -> 39559 */
    0xBAA8, 0x9163,    /* '酣' -> 37219 */
    0xBAA9, 0x61A8,    /* '憨' -> 25000 */
    0xBAAA, 0x90AF,    /* '邯' -> 37039 */
    0xBAAB, 0x97E9,    /* '韩' -> 38889 */
    0xBAAC, 0x542B,    /* '含' -> 21547 */
    0xBAAD, 0x6DB5,    /* '涵' -> 28085 */
    0xBAAE, 0x5BD2,    /* '寒' -> 23506 */
    0xBAAF, 0x51FD,    /* '函' -> 20989 */
    0xBAB0, 0x558A,    /* '喊' -> 21898 */
    0xBAB1, 0x7F55,    /* '罕' -> 32597 */
    0xBAB2, 0x7FF0,    /* '翰' -> 32752 */
    0xBAB3, 0x64BC,    /* '撼' -> 25788 */
    0xBAB4, 0x634D,    /* '捍' -> 25421 */
    0xBAB5, 0x65F1,    /* '旱' -> 26097 */
    0xBAB6, 0x61BE,    /* '憾' -> 25022 */
    0xBAB7, 0x608D,    /* '悍' -> 24717 */
    0xBAB8, 0x710A,    /* '焊' -> 28938 */
    0xBAB9, 0x6C57,    /* '汗' -> 27735 */
    0xBABA, 0x6C49,    /* '汉' -> 27721 */
    0xBABB, 0x592F,    /* '夯' -> 22831 */
    0xBABC, 0x676D,    /* '杭' -> 26477 */
    0xBABD, 0x822A,    /* '航' -> 33322 */
    0xBABE, 0x58D5,    /* '壕' -> 22741 */
    0xBABF, 0x568E,    /* '嚎' -> 22158 */
    0xBAC0, 0x8C6A,    /* '豪' -> 35946 */
    0xBAC1, 0x6BEB,    /* '毫' -> 27627 */
    0xBAC2, 0x90DD,    /* '郝' -> 37085 */
    0xBAC3, 0x597D,    /* '好' -> 22909 */
    0xBAC4, 0x8017,    /* '耗' -> 32791 */
    0xBAC5, 0x53F7,    /* '号' -> 21495 */
    0xBAC6, 0x6D69,    /* '浩' -> 28009 */
    0xBAC7, 0x5475,    /* '呵' -> 21621 */
    0xBAC8, 0x559D,    /* '喝' -> 21917 */
    0xBAC9, 0x8377,    /* '荷' -> 33655 */
    0xBACA, 0x83CF,    /* '菏' -> 33743 */
    0xBACB, 0x6838,    /* '核' -> 26680 */
    0xBACC, 0x79BE,    /* '禾' -> 31166 */
    0xBACD, 0x548C,    /* '和' -> 21644 */
    0xBACE, 0x4F55,    /* '何' -> 20309 */
    0xBACF, 0x5408,    /* '合' -> 21512 */
    0xBAD0, 0x76D2,    /* '盒' -> 30418 */
    0xBAD1, 0x8C89,    /* '貉' -> 35977 */
    0xBAD2, 0x9602,    /* '阂' -> 38402 */
    0xBAD3, 0x6CB3,    /* '河' -> 27827 */
    0xBAD4, 0x6DB8,    /* '涸' -> 28088 */
    0xBAD5, 0x8D6B,    /* '赫' -> 36203 */
    0xBAD6, 0x8910,    /* '褐' -> 35088 */
    0xBAD7, 0x9E64,    /* '鹤' -> 40548 */
    0xBAD8, 0x8D3A,    /* '贺' -> 36154 */
    0xBAD9, 0x563F,    /* '嘿' -> 22079 */
    0xBADA, 0x9ED1,    /* '黑' -> 40657 */
    0xBADB, 0x75D5,    /* '痕' -> 30165 */
    0xBADC, 0x5F88,    /* '很' -> 24456 */
    0xBADD, 0x72E0,    /* '狠' -> 29408 */
    0xBADE, 0x6068,    /* '恨' -> 24680 */
    0xBADF, 0x54FC,    /* '哼' -> 21756 */
    0xBAE0, 0x4EA8,    /* '亨' -> 20136 */
    0xBAE1, 0x6A2A,    /* '横' -> 27178 */
    0xBAE2, 0x8861,    /* '衡' -> 34913 */
    0xBAE3, 0x6052,    /* '恒' -> 24658 */
    0xBAE4, 0x8F70,    /* '轰' -> 36720 */
    0xBAE5, 0x54C4,    /* '哄' -> 21700 */
    0xBAE6, 0x70D8,    /* '烘' -> 28888 */
    0xBAE7, 0x8679,    /* '虹' -> 34425 */
    0xBAE8, 0x9E3F,    /* '鸿' -> 40511 */
    0xBAE9, 0x6D2A,    /* '洪' -> 27946 */
    0xBAEA, 0x5B8F,    /* '宏' -> 23439 */
    0xBAEB, 0x5F18,    /* '弘' -> 24344 */
    0xBAEC, 0x7EA2,    /* '红' -> 32418 */
    0xBAED, 0x5589,    /* '喉' -> 21897 */
    0xBAEE, 0x4FAF,    /* '侯' -> 20399 */
    0xBAEF, 0x7334,    /* '猴' -> 29492 */
    0xBAF0, 0x543C,    /* '吼' -> 21564 */
    0xBAF1, 0x539A,    /* '厚' -> 21402 */
    0xBAF2, 0x5019,    /* '候' -> 20505 */
    0xBAF3, 0x540E,    /* '后' -> 21518 */
    0xBAF4, 0x547C,    /* '呼' -> 21628 */
    0xBAF5, 0x4E4E,    /* '乎' -> 20046 */
    0xBAF6, 0x5FFD,    /* '忽' -> 24573 */
    0xBAF7, 0x745A,    /* '瑚' -> 29786 */
    0xBAF8, 0x58F6,    /* '壶' -> 22774 */
    0xBAF9, 0x846B,    /* '葫' -> 33899 */
    0xBAFA, 0x80E1,    /* '胡' -> 32993 */
    0xBAFB, 0x8774,    /* '蝴' -> 34676 */
    0xBAFC, 0x72D0,    /* '狐' -> 29392 */
    0xBAFD, 0x7CCA,    /* '糊' -> 31946 */
    0xBAFE, 0x6E56,    /* '湖' -> 28246 */
    0xBBA1, 0x5F27,    /* '弧' -> 24359 */
    0xBBA2, 0x864E,    /* '虎' -> 34382 */
    0xBBA3, 0x552C,    /* '唬' -> 21804 */
    0xBBA4, 0x62A4,    /* '护' -> 25252 */
    0xBBA5, 0x4E92,    /* '互' -> 20114 */
    0xBBA6, 0x6CAA,    /* '沪' -> 27818 */
    0xBBA7, 0x6237,    /* '户' -> 25143 */
    0xBBA8, 0x82B1,    /* '花' -> 33457 */
    0xBBA9, 0x54D7,    /* '哗' -> 21719 */
    0xBBAA, 0x534E,    /* '华' -> 21326 */
    0xBBAB, 0x733E,    /* '猾' -> 29502 */
    0xBBAC, 0x6ED1,    /* '滑' -> 28369 */
    0xBBAD, 0x753B,    /* '画' -> 30011 */
    0xBBAE, 0x5212,    /* '划' -> 21010 */
    0xBBAF, 0x5316,    /* '化' -> 21270 */
    0xBBB0, 0x8BDD,    /* '话' -> 35805 */
    0xBBB1, 0x69D0,    /* '槐' -> 27088 */
    0xBBB2, 0x5F8A,    /* '徊' -> 24458 */
    0xBBB3, 0x6000,    /* '怀' -> 24576 */
    0xBBB4, 0x6DEE,    /* '淮' -> 28142 */
    0xBBB5, 0x574F,    /* '坏' -> 22351 */
    0xBBB6, 0x6B22,    /* '欢' -> 27426 */
    0xBBB7, 0x73AF,    /* '环' -> 29615 */
    0xBBB8, 0x6853,    /* '桓' -> 26707 */
    0xBBB9, 0x8FD8,    /* '还' -> 36824 */
    0xBBBA, 0x7F13,    /* '缓' -> 32531 */
    0xBBBB, 0x6362,    /* '换' -> 25442 */
    0xBBBC, 0x60A3,    /* '患' -> 24739 */
    0xBBBD, 0x5524,    /* '唤' -> 21796 */
    0xBBBE, 0x75EA,    /* '痪' -> 30186 */
    0xBBBF, 0x8C62,    /* '豢' -> 35938 */
    0xBBC0, 0x7115,    /* '焕' -> 28949 */
    0xBBC1, 0x6DA3,    /* '涣' -> 28067 */
    0xBBC2, 0x5BA6,    /* '宦' -> 23462 */
    0xBBC3, 0x5E7B,    /* '幻' -> 24187 */
    0xBBC4, 0x8352,    /* '荒' -> 33618 */
    0xBBC5, 0x614C,    /* '慌' -> 24908 */
    0xBBC6, 0x9EC4,    /* '黄' -> 40644 */
    0xBBC7, 0x78FA,    /* '磺' -> 30970 */
    0xBBC8, 0x8757,    /* '蝗' -> 34647 */
    0xBBC9, 0x7C27,    /* '簧' -> 31783 */
    0xBBCA, 0x7687,    /* '皇' -> 30343 */
    0xBBCB, 0x51F0,    /* '凰' -> 20976 */
    0xBBCC, 0x60F6,    /* '惶' -> 24822 */
    0xBBCD, 0x714C,    /* '煌' -> 29004 */
    0xBBCE, 0x6643,    /* '晃' -> 26179 */
    0xBBCF, 0x5E4C,    /* '幌' -> 24140 */
    0xBBD0, 0x604D,    /* '恍' -> 24653 */
    0xBBD1, 0x8C0E,    /* '谎' -> 35854 */
    0xBBD2, 0x7070,    /* '灰' -> 28784 */
    0xBBD3, 0x6325,    /* '挥' -> 25381 */
    0xBBD4, 0x8F89,    /* '辉' -> 36745 */
    0xBBD5, 0x5FBD,    /* '徽' -> 24509 */
    0xBBD6, 0x6062,    /* '恢' -> 24674 */
    0xBBD7, 0x86D4,    /* '蛔' -> 34516 */
    0xBBD8, 0x56DE,    /* '回' -> 22238 */
    0xBBD9, 0x6BC1,    /* '毁' -> 27585 */
    0xBBDA, 0x6094,    /* '悔' -> 24724 */
    0xBBDB, 0x6167,    /* '慧' -> 24935 */
    0xBBDC, 0x5349,    /* '卉' -> 21321 */
    0xBBDD, 0x60E0,    /* '惠' -> 24800 */
    0xBBDE, 0x6666,    /* '晦' -> 26214 */
    0xBBDF, 0x8D3F,    /* '贿' -> 36159 */
    0xBBE0, 0x79FD,    /* '秽' -> 31229 */
    0xBBE1, 0x4F1A,    /* '会' -> 20250 */
    0xBBE2, 0x70E9,    /* '烩' -> 28905 */
    0xBBE3, 0x6C47,    /* '汇' -> 27719 */
    0xBBE4, 0x8BB3,    /* '讳' -> 35763 */
    0xBBE5, 0x8BF2,    /* '诲' -> 35826 */
    0xBBE6, 0x7ED8,    /* '绘' -> 32472 */
    0xBBE7, 0x8364,    /* '荤' -> 33636 */
    0xBBE8, 0x660F,    /* '昏' -> 26127 */
    0xBBE9, 0x5A5A,    /* '婚' -> 23130 */
    0xBBEA, 0x9B42,    /* '魂' -> 39746 */
    0xBBEB, 0x6D51,    /* '浑' -> 27985 */
    0xBBEC, 0x6DF7,    /* '混' -> 28151 */
    0xBBED, 0x8C41,    /* '豁' -> 35905 */
    0xBBEE, 0x6D3B,    /* '活' -> 27963 */
    0xBBEF, 0x4F19,    /* '伙' -> 20249 */
    0xBBF0, 0x706B,    /* '火' -> 28779 */
    0xBBF1, 0x83B7,    /* '获' -> 33719 */
    0xBBF2, 0x6216,    /* '或' -> 25110 */
    0xBBF3, 0x60D1,    /* '惑' -> 24785 */
    0xBBF4, 0x970D,    /* '霍' -> 38669 */
    0xBBF5, 0x8D27,    /* '货' -> 36135 */
    0xBBF6, 0x7978,    /* '祸' -> 31096 */
    0xBBF7, 0x51FB,    /* '击' -> 20987 */
    0xBBF8, 0x573E,    /* '圾' -> 22334 */
    0xBBF9, 0x57FA,    /* '基' -> 22522 */
    0xBBFA, 0x673A,    /* '机' -> 26426 */
    0xBBFB, 0x7578,    /* '畸' -> 30072 */
    0xBBFC, 0x7A3D,    /* '稽' -> 31293 */
    0xBBFD, 0x79EF,    /* '积' -> 31215 */
    0xBBFE, 0x7B95,    /* '箕' -> 31637 */
    0xBCA1, 0x808C,    /* '肌' -> 32908 */
    0xBCA2, 0x9965,    /* '饥' -> 39269 */
    0xBCA3, 0x8FF9,    /* '迹' -> 36857 */
    0xBCA4, 0x6FC0,    /* '激' -> 28608 */
    0xBCA5, 0x8BA5,    /* '讥' -> 35749 */
    0xBCA6, 0x9E21,    /* '鸡' -> 40481 */
    0xBCA7, 0x59EC,    /* '姬' -> 23020 */
    0xBCA8, 0x7EE9,    /* '绩' -> 32489 */
    0xBCA9, 0x7F09,    /* '缉' -> 32521 */
    0xBCAA, 0x5409,    /* '吉' -> 21513 */
    0xBCAB, 0x6781,    /* '极' -> 26497 */
    0xBCAC, 0x68D8,    /* '棘' -> 26840 */
    0xBCAD, 0x8F91,    /* '辑' -> 36753 */
    0xBCAE, 0x7C4D,    /* '籍' -> 31821 */
    0xBCAF, 0x96C6,    /* '集' -> 38598 */
    0xBCB0, 0x53CA,    /* '及' -> 21450 */
    0xBCB1, 0x6025,    /* '急' -> 24613 */
    0xBCB2, 0x75BE,    /* '疾' -> 30142 */
    0xBCB3, 0x6C72,    /* '汲' -> 27762 */
    0xBCB4, 0x5373,    /* '即' -> 21363 */
    0xBCB5, 0x5AC9,    /* '嫉' -> 23241 */
    0xBCB6, 0x7EA7,    /* '级' -> 32423 */
    0xBCB7, 0x6324,    /* '挤' -> 25380 */
    0xBCB8, 0x51E0,    /* '几' -> 20960 */
    0xBCB9, 0x810A,    /* '脊' -> 33034 */
    0xBCBA, 0x5DF1,    /* '己' -> 24049 */
    0xBCBB, 0x84DF,    /* '蓟' -> 34015 */
    0xBCBC, 0x6280,    /* '技' -> 25216 */
    0xBCBD, 0x5180,    /* '冀' -> 20864 */
    0xBCBE, 0x5B63,    /* '季' -> 23395 */
    0xBCBF, 0x4F0E,    /* '伎' -> 20238 */
    0xBCC0, 0x796D,    /* '祭' -> 31085 */
    0xBCC1, 0x5242,    /* '剂' -> 21058 */
    0xBCC2, 0x60B8,    /* '悸' -> 24760 */
    0xBCC3, 0x6D4E,    /* '济' -> 27982 */
    0xBCC4, 0x5BC4,    /* '寄' -> 23492 */
    0xBCC5, 0x5BC2,    /* '寂' -> 23490 */
    0xBCC6, 0x8BA1,    /* '计' -> 35745 */
    0xBCC7, 0x8BB0,    /* '记' -> 35760 */
    0xBCC8, 0x65E2,    /* '既' -> 26082 */
    0xBCC9, 0x5FCC,    /* '忌' -> 24524 */
    0xBCCA, 0x9645,    /* '际' -> 38469 */
    0xBCCB, 0x5993,    /* '妓' -> 22931 */
    0xBCCC, 0x7EE7,    /* '继' -> 32487 */
    0xBCCD, 0x7EAA,    /* '纪' -> 32426 */
    0xBCCE, 0x5609,    /* '嘉' -> 22025 */
    0xBCCF, 0x67B7,    /* '枷' -> 26551 */
    0xBCD0, 0x5939,    /* '夹' -> 22841 */
    0xBCD1, 0x4F73,    /* '佳' -> 20339 */
    0xBCD2, 0x5BB6,    /* '家' -> 23478 */
    0xBCD3, 0x52A0,    /* '加' -> 21152 */
    0xBCD4, 0x835A,    /* '荚' -> 33626 */
    0xBCD5, 0x988A,    /* '颊' -> 39050 */
    0xBCD6, 0x8D3E,    /* '贾' -> 36158 */
    0xBCD7, 0x7532,    /* '甲' -> 30002 */
    0xBCD8, 0x94BE,    /* '钾' -> 38078 */
    0xBCD9, 0x5047,    /* '假' -> 20551 */
    0xBCDA, 0x7A3C,    /* '稼' -> 31292 */
    0xBCDB, 0x4EF7,    /* '价' -> 20215 */
    0xBCDC, 0x67B6,    /* '架' -> 26550 */
    0xBCDD, 0x9A7E,    /* '驾' -> 39550 */
    0xBCDE, 0x5AC1,    /* '嫁' -> 23233 */
    0xBCDF, 0x6B7C,    /* '歼' -> 27516 */
    0xBCE0, 0x76D1,    /* '监' -> 30417 */
    0xBCE1, 0x575A,    /* '坚' -> 22362 */
    0xBCE2, 0x5C16,    /* '尖' -> 23574 */
    0xBCE3, 0x7B3A,    /* '笺' -> 31546 */
    0xBCE4, 0x95F4,    /* '间' -> 38388 */
    0xBCE5, 0x714E,    /* '煎' -> 29006 */
    0xBCE6, 0x517C,    /* '兼' -> 20860 */
    0xBCE7, 0x80A9,    /* '肩' -> 32937 */
    0xBCE8, 0x8270,    /* '艰' -> 33392 */
    0xBCE9, 0x5978,    /* '奸' -> 22904 */
    0xBCEA, 0x7F04,    /* '缄' -> 32516 */
    0xBCEB, 0x8327,    /* '茧' -> 33575 */
    0xBCEC, 0x68C0,    /* '检' -> 26816 */
    0xBCED, 0x67EC,    /* '柬' -> 26604 */
    0xBCEE, 0x78B1,    /* '碱' -> 30897 */
    0xBCEF, 0x7877,    /* '硷' -> 30839 */
    0xBCF0, 0x62E3,    /* '拣' -> 25315 */
    0xBCF1, 0x6361,    /* '捡' -> 25441 */
    0xBCF2, 0x7B80,    /* '简' -> 31616 */
    0xBCF3, 0x4FED,    /* '俭' -> 20461 */
    0xBCF4, 0x526A,    /* '剪' -> 21098 */
    0xBCF5, 0x51CF,    /* '减' -> 20943 */
    0xBCF6, 0x8350,    /* '荐' -> 33616 */
    0xBCF7, 0x69DB,    /* '槛' -> 27099 */
    0xBCF8, 0x9274,    /* '鉴' -> 37492 */
    0xBCF9, 0x8DF5,    /* '践' -> 36341 */
    0xBCFA, 0x8D31,    /* '贱' -> 36145 */
    0xBCFB, 0x89C1,    /* '见' -> 35265 */
    0xBCFC, 0x952E,    /* '键' -> 38190 */
    0xBCFD, 0x7BAD,    /* '箭' -> 31661 */
    0xBCFE, 0x4EF6,    /* '件' -> 20214 */
    0xBDA1, 0x5065,    /* '健' -> 20581 */
    0xBDA2, 0x8230,    /* '舰' -> 33328 */
    0xBDA3, 0x5251,    /* '剑' -> 21073 */
    0xBDA4, 0x996F,    /* '饯' -> 39279 */
    0xBDA5, 0x6E10,    /* '渐' -> 28176 */
    0xBDA6, 0x6E85,    /* '溅' -> 28293 */
    0xBDA7, 0x6DA7,    /* '涧' -> 28071 */
    0xBDA8, 0x5EFA,    /* '建' -> 24314 */
    0xBDA9, 0x50F5,    /* '僵' -> 20725 */
    0xBDAA, 0x59DC,    /* '姜' -> 23004 */
    0xBDAB, 0x5C06,    /* '将' -> 23558 */
    0xBDAC, 0x6D46,    /* '浆' -> 27974 */
    0xBDAD, 0x6C5F,    /* '江' -> 27743 */
    0xBDAE, 0x7586,    /* '疆' -> 30086 */
    0xBDAF, 0x848B,    /* '蒋' -> 33931 */
    0xBDB0, 0x6868,    /* '桨' -> 26728 */
    0xBDB1, 0x5956,    /* '奖' -> 22870 */
    0xBDB2, 0x8BB2,    /* '讲' -> 35762 */
    0xBDB3, 0x5320,    /* '匠' -> 21280 */
    0xBDB4, 0x9171,    /* '酱' -> 37233 */
    0xBDB5, 0x964D,    /* '降' -> 38477 */
    0xBDB6, 0x8549,    /* '蕉' -> 34121 */
    0xBDB7, 0x6912,    /* '椒' -> 26898 */
    0xBDB8, 0x7901,    /* '礁' -> 30977 */
    0xBDB9, 0x7126,    /* '焦' -> 28966 */
    0xBDBA, 0x80F6,    /* '胶' -> 33014 */
    0xBDBB, 0x4EA4,    /* '交' -> 20132 */
    0xBDBC, 0x90CA,    /* '郊' -> 37066 */
    0xBDBD, 0x6D47,    /* '浇' -> 27975 */
    0xBDBE, 0x9A84,    /* '骄' -> 39556 */
    0xBDBF, 0x5A07,    /* '娇' -> 23047 */
    0xBDC0, 0x56BC,    /* '嚼' -> 22204 */
    0xBDC1, 0x6405,    /* '搅' -> 25605 */
    0xBDC2, 0x94F0,    /* '铰' -> 38128 */
    0xBDC3, 0x77EB,    /* '矫' -> 30699 */
    0xBDC4, 0x4FA5,    /* '侥' -> 20389 */
    0xBDC5, 0x811A,    /* '脚' -> 33050 */
    0xBDC6, 0x72E1,    /* '狡' -> 29409 */
    0xBDC7, 0x89D2,    /* '角' -> 35282 */
    0xBDC8, 0x997A,    /* '饺' -> 39290 */
    0xBDC9, 0x7F34,    /* '缴' -> 32564 */
    0xBDCA, 0x7EDE,    /* '绞' -> 32478 */
    0xBDCB, 0x527F,    /* '剿' -> 21119 */
    0xBDCC, 0x6559,    /* '教' -> 25945 */
    0xBDCD, 0x9175,    /* '酵' -> 37237 */
    0xBDCE, 0x8F7F,    /* '轿' -> 36735 */
    0xBDCF, 0x8F83,    /* '较' -> 36739 */
    0xBDD0, 0x53EB,    /* '叫' -> 21483 */
    0xBDD1, 0x7A96,    /* '窖' -> 31382 */
    0xBDD2, 0x63ED,    /* '揭' -> 25581 */
    0xBDD3, 0x63A5,    /* '接' -> 25509 */
    0xBDD4, 0x7686,    /* '皆' -> 30342 */
    0xBDD5, 0x79F8,    /* '秸' -> 31224 */
    0xBDD6, 0x8857,    /* '街' -> 34903 */
    0xBDD7, 0x9636,    /* '阶' -> 38454 */
    0xBDD8, 0x622A,    /* '截' -> 25130 */
    0xBDD9, 0x52AB,    /* '劫' -> 21163 */
    0xBDDA, 0x8282,    /* '节' -> 33410 */
    0xBDDB, 0x6854,    /* '桔' -> 26708 */
    0xBDDC, 0x6770,    /* '杰' -> 26480 */
    0xBDDD, 0x6377,    /* '捷' -> 25463 */
    0xBDDE, 0x776B,    /* '睫' -> 30571 */
    0xBDDF, 0x7AED,    /* '竭' -> 31469 */
    0xBDE0, 0x6D01,    /* '洁' -> 27905 */
    0xBDE1, 0x7ED3,    /* '结' -> 32467 */
    0xBDE2, 0x89E3,    /* '解' -> 35299 */
    0xBDE3, 0x59D0,    /* '姐' -> 22992 */
    0xBDE4, 0x6212,    /* '戒' -> 25106 */
    0xBDE5, 0x85C9,    /* '藉' -> 34249 */
    0xBDE6, 0x82A5,    /* '芥' -> 33445 */
    0xBDE7, 0x754C,    /* '界' -> 30028 */
    0xBDE8, 0x501F,    /* '借' -> 20511 */
    0xBDE9, 0x4ECB,    /* '介' -> 20171 */
    0xBDEA, 0x75A5,    /* '疥' -> 30117 */
    0xBDEB, 0x8BEB,    /* '诫' -> 35819 */
    0xBDEC, 0x5C4A,    /* '届' -> 23626 */
    0xBDED, 0x5DFE,    /* '巾' -> 24062 */
    0xBDEE, 0x7B4B,    /* '筋' -> 31563 */
    0xBDEF, 0x65A4,    /* '斤' -> 26020 */
    0xBDF0, 0x91D1,    /* '金' -> 37329 */
    0xBDF1, 0x4ECA,    /* '今' -> 20170 */
    0xBDF2, 0x6D25,    /* '津' -> 27941 */
    0xBDF3, 0x895F,    /* '襟' -> 35167 */
    0xBDF4, 0x7D27,    /* '紧' -> 32039 */
    0xBDF5, 0x9526,    /* '锦' -> 38182 */
    0xBDF6, 0x4EC5,    /* '仅' -> 20165 */
    0xBDF7, 0x8C28,    /* '谨' -> 35880 */
    0xBDF8, 0x8FDB,    /* '进' -> 36827 */
    0xBDF9, 0x9773,    /* '靳' -> 38771 */
    0xBDFA, 0x664B,    /* '晋' -> 26187 */
    0xBDFB, 0x7981,    /* '禁' -> 31105 */
    0xBDFC, 0x8FD1,    /* '近' -> 36817 */
    0xBDFD, 0x70EC,    /* '烬' -> 28908 */
    0xBDFE, 0x6D78,    /* '浸' -> 28024 */
    0xBEA1, 0x5C3D,    /* '尽' -> 23613 */
    0xBEA2, 0x52B2,    /* '劲' -> 21170 */
    0xBEA3, 0x8346,    /* '荆' -> 33606 */
    0xBEA4, 0x5162,    /* '兢' -> 20834 */
    0xBEA5, 0x830E,    /* '茎' -> 33550 */
    0xBEA6, 0x775B,    /* '睛' -> 30555 */
    0xBEA7, 0x6676,    /* '晶' -> 26230 */
    0xBEA8, 0x9CB8,    /* '鲸' -> 40120 */
    0xBEA9, 0x4EAC,    /* '京' -> 20140 */
    0xBEAA, 0x60CA,    /* '惊' -> 24778 */
    0xBEAB, 0x7CBE,    /* '精' -> 31934 */
    0xBEAC, 0x7CB3,    /* '粳' -> 31923 */
    0xBEAD, 0x7ECF,    /* '经' -> 32463 */
    0xBEAE, 0x4E95,    /* '井' -> 20117 */
    0xBEAF, 0x8B66,    /* '警' -> 35686 */
    0xBEB0, 0x666F,    /* '景' -> 26223 */
    0xBEB1, 0x9888,    /* '颈' -> 39048 */
    0xBEB2, 0x9759,    /* '静' -> 38745 */
    0xBEB3, 0x5883,    /* '境' -> 22659 */
    0xBEB4, 0x656C,    /* '敬' -> 25964 */
    0xBEB5, 0x955C,    /* '镜' -> 38236 */
    0xBEB6, 0x5F84,    /* '径' -> 24452 */
    0xBEB7, 0x75C9,    /* '痉' -> 30153 */
    0xBEB8, 0x9756,    /* '靖' -> 38742 */
    0xBEB9, 0x7ADF,    /* '竟' -> 31455 */
    0xBEBA, 0x7ADE,    /* '竞' -> 31454 */
    0xBEBB, 0x51C0,    /* '净' -> 20928 */
    0xBEBC, 0x70AF,    /* '炯' -> 28847 */
    0xBEBD, 0x7A98,    /* '窘' -> 31384 */
    0xBEBE, 0x63EA,    /* '揪' -> 25578 */
    0xBEBF, 0x7A76,    /* '究' -> 31350 */
    0xBEC0, 0x7EA0,    /* '纠' -> 32416 */
    0xBEC1, 0x7396,    /* '玖' -> 29590 */
    0xBEC2, 0x97ED,    /* '韭' -> 38893 */
    0xBEC3, 0x4E45,    /* '久' -> 20037 */
    0xBEC4, 0x7078,    /* '灸' -> 28792 */
    0xBEC5, 0x4E5D,    /* '九' -> 20061 */
    0xBEC6, 0x9152,    /* '酒' -> 37202 */
    0xBEC7, 0x53A9,    /* '厩' -> 21417 */
    0xBEC8, 0x6551,    /* '救' -> 25937 */
    0xBEC9, 0x65E7,    /* '旧' -> 26087 */
    0xBECA, 0x81FC,    /* '臼' -> 33276 */
    0xBECB, 0x8205,    /* '舅' -> 33285 */
    0xBECC, 0x548E,    /* '咎' -> 21646 */
    0xBECD, 0x5C31,    /* '就' -> 23601 */
    0xBECE, 0x759A,    /* '疚' -> 30106 */
    0xBECF, 0x97A0,    /* '鞠' -> 38816 */
    0xBED0, 0x62D8,    /* '拘' -> 25304 */
    0xBED1, 0x72D9,    /* '狙' -> 29401 */
    0xBED2, 0x75BD,    /* '疽' -> 30141 */
    0xBED3, 0x5C45,    /* '居' -> 23621 */
    0xBED4, 0x9A79,    /* '驹' -> 39545 */
    0xBED5, 0x83CA,    /* '菊' -> 33738 */
    0xBED6, 0x5C40,    /* '局' -> 23616 */
    0xBED7, 0x5480,    /* '咀' -> 21632 */
    0xBED8, 0x77E9,    /* '矩' -> 30697 */
    0xBED9, 0x4E3E,    /* '举' -> 20030 */
    0xBEDA, 0x6CAE,    /* '沮' -> 27822 */
    0xBEDB, 0x805A,    /* '聚' -> 32858 */
    0xBEDC, 0x62D2,    /* '拒' -> 25298 */
    0xBEDD, 0x636E,    /* '据' -> 25454 */
    0xBEDE, 0x5DE8,    /* '巨' -> 24040 */
    0xBEDF, 0x5177,    /* '具' -> 20855 */
    0xBEE0, 0x8DDD,    /* '距' -> 36317 */
    0xBEE1, 0x8E1E,    /* '踞' -> 36382 */
    0xBEE2, 0x952F,    /* '锯' -> 38191 */
    0xBEE3, 0x4FF1,    /* '俱' -> 20465 */
    0xBEE4, 0x53E5,    /* '句' -> 21477 */
    0xBEE5, 0x60E7,    /* '惧' -> 24807 */
    0xBEE6, 0x70AC,    /* '炬' -> 28844 */
    0xBEE7, 0x5267,    /* '剧' -> 21095 */
    0xBEE8, 0x6350,    /* '捐' -> 25424 */
    0xBEE9, 0x9E43,    /* '鹃' -> 40515 */
    0xBEEA, 0x5A1F,    /* '娟' -> 23071 */
    0xBEEB, 0x5026,    /* '倦' -> 20518 */
    0xBEEC, 0x7737,    /* '眷' -> 30519 */
    0xBEED, 0x5377,    /* '卷' -> 21367 */
    0xBEEE, 0x7EE2,    /* '绢' -> 32482 */
    0xBEEF, 0x6485,    /* '撅' -> 25733 */
    0xBEF0, 0x652B,    /* '攫' -> 25899 */
    0xBEF1, 0x6289,    /* '抉' -> 25225 */
    0xBEF2, 0x6398,    /* '掘' -> 25496 */
    0xBEF3, 0x5014,    /* '倔' -> 20500 */
    0xBEF4, 0x7235,    /* '爵' -> 29237 */
    0xBEF5, 0x89C9,    /* '觉' -> 35273 */
    0xBEF6, 0x51B3,    /* '决' -> 20915 */
    0xBEF7, 0x8BC0,    /* '诀' -> 35776 */
    0xBEF8, 0x7EDD,    /* '绝' -> 32477 */
    0xBEF9, 0x5747,    /* '均' -> 22343 */
    0xBEFA, 0x83CC,    /* '菌' -> 33740 */
    0xBEFB, 0x94A7,    /* '钧' -> 38055 */
    0xBEFC, 0x519B,    /* '军' -> 20891 */
    0xBEFD, 0x541B,    /* '君' -> 21531 */
    0xBEFE, 0x5CFB,    /* '峻' -> 23803 */
    0xBFA1, 0x4FCA,    /* '俊' -> 20426 */
    0xBFA2, 0x7AE3,    /* '竣' -> 31459 */
    0xBFA3, 0x6D5A,    /* '浚' -> 27994 */
    0xBFA4, 0x90E1,    /* '郡' -> 37089 */
    0xBFA5, 0x9A8F,    /* '骏' -> 39567 */
    0xBFA6, 0x5580,    /* '喀' -> 21888 */
    0xBFA7, 0x5496,    /* '咖' -> 21654 */
    0xBFA8, 0x5361,    /* '卡' -> 21345 */
    0xBFA9, 0x54AF,    /* '咯' -> 21679 */
    0xBFAA, 0x5F00,    /* '开' -> 24320 */
    0xBFAB, 0x63E9,    /* '揩' -> 25577 */
    0xBFAC, 0x6977,    /* '楷' -> 26999 */
    0xBFAD, 0x51EF,    /* '凯' -> 20975 */
    0xBFAE, 0x6168,    /* '慨' -> 24936 */
    0xBFAF, 0x520A,    /* '刊' -> 21002 */
    0xBFB0, 0x582A,    /* '堪' -> 22570 */
    0xBFB1, 0x52D8,    /* '勘' -> 21208 */
    0xBFB2, 0x574E,    /* '坎' -> 22350 */
    0xBFB3, 0x780D,    /* '砍' -> 30733 */
    0xBFB4, 0x770B,    /* '看' -> 30475 */
    0xBFB5, 0x5EB7,    /* '康' -> 24247 */
    0xBFB6, 0x6177,    /* '慷' -> 24951 */
    0xBFB7, 0x7CE0,    /* '糠' -> 31968 */
    0xBFB8, 0x625B,    /* '扛' -> 25179 */
    0xBFB9, 0x6297,    /* '抗' -> 25239 */
    0xBFBA, 0x4EA2,    /* '亢' -> 20130 */
    0xBFBB, 0x7095,    /* '炕' -> 28821 */
    0xBFBC, 0x8003,    /* '考' -> 32771 */
    0xBFBD, 0x62F7,    /* '拷' -> 25335 */
    0xBFBE, 0x70E4,    /* '烤' -> 28900 */
    0xBFBF, 0x9760,    /* '靠' -> 38752 */
    0xBFC0, 0x5777,    /* '坷' -> 22391 */
    0xBFC1, 0x82DB,    /* '苛' -> 33499 */
    0xBFC2, 0x67EF,    /* '柯' -> 26607 */
    0xBFC3, 0x68F5,    /* '棵' -> 26869 */
    0xBFC4, 0x78D5,    /* '磕' -> 30933 */
    0xBFC5, 0x9897,    /* '颗' -> 39063 */
    0xBFC6, 0x79D1,    /* '科' -> 31185 */
    0xBFC7, 0x58F3,    /* '壳' -> 22771 */
    0xBFC8, 0x54B3,    /* '咳' -> 21683 */
    0xBFC9, 0x53EF,    /* '可' -> 21487 */
    0xBFCA, 0x6E34,    /* '渴' -> 28212 */
    0xBFCB, 0x514B,    /* '克' -> 20811 */
    0xBFCC, 0x523B,    /* '刻' -> 21051 */
    0xBFCD, 0x5BA2,    /* '客' -> 23458 */
    0xBFCE, 0x8BFE,    /* '课' -> 35838 */
    0xBFCF, 0x80AF,    /* '肯' -> 32943 */
    0xBFD0, 0x5543,    /* '啃' -> 21827 */
    0xBFD1, 0x57A6,    /* '垦' -> 22438 */
    0xBFD2, 0x6073,    /* '恳' -> 24691 */
    0xBFD3, 0x5751,    /* '坑' -> 22353 */
    0xBFD4, 0x542D,    /* '吭' -> 21549 */
    0xBFD5, 0x7A7A,    /* '空' -> 31354 */
    0xBFD6, 0x6050,    /* '恐' -> 24656 */
    0xBFD7, 0x5B54,    /* '孔' -> 23380 */
    0xBFD8, 0x63A7,    /* '控' -> 25511 */
    0xBFD9, 0x62A0,    /* '抠' -> 25248 */
    0xBFDA, 0x53E3,    /* '口' -> 21475 */
    0xBFDB, 0x6263,    /* '扣' -> 25187 */
    0xBFDC, 0x5BC7,    /* '寇' -> 23495 */
    0xBFDD, 0x67AF,    /* '枯' -> 26543 */
    0xBFDE, 0x54ED,    /* '哭' -> 21741 */
    0xBFDF, 0x7A9F,    /* '窟' -> 31391 */
    0xBFE0, 0x82E6,    /* '苦' -> 33510 */
    0xBFE1, 0x9177,    /* '酷' -> 37239 */
    0xBFE2, 0x5E93,    /* '库' -> 24211 */
    0xBFE3, 0x88E4,    /* '裤' -> 35044 */
    0xBFE4, 0x5938,    /* '夸' -> 22840 */
    0xBFE5, 0x57AE,    /* '垮' -> 22446 */
    0xBFE6, 0x630E,    /* '挎' -> 25358 */
    0xBFE7, 0x8DE8,    /* '跨' -> 36328 */
    0xBFE8, 0x80EF,    /* '胯' -> 33007 */
    0xBFE9, 0x5757,    /* '块' -> 22359 */
    0xBFEA, 0x7B77,    /* '筷' -> 31607 */
    0xBFEB, 0x4FA9,    /* '侩' -> 20393 */
    0xBFEC, 0x5FEB,    /* '快' -> 24555 */
    0xBFED, 0x5BBD,    /* '宽' -> 23485 */
    0xBFEE, 0x6B3E,    /* '款' -> 27454 */
    0xBFEF, 0x5321,    /* '匡' -> 21281 */
    0xBFF0, 0x7B50,    /* '筐' -> 31568 */
    0xBFF1, 0x72C2,    /* '狂' -> 29378 */
    0xBFF2, 0x6846,    /* '框' -> 26694 */
    0xBFF3, 0x77FF,    /* '矿' -> 30719 */
    0xBFF4, 0x7736,    /* '眶' -> 30518 */
    0xBFF5, 0x65F7,    /* '旷' -> 26103 */
    0xBFF6, 0x51B5,    /* '况' -> 20917 */
    0xBFF7, 0x4E8F,    /* '亏' -> 20111 */
    0xBFF8, 0x76D4,    /* '盔' -> 30420 */
    0xBFF9, 0x5CBF,    /* '岿' -> 23743 */
    0xBFFA, 0x7AA5,    /* '窥' -> 31397 */
    0xBFFB, 0x8475,    /* '葵' -> 33909 */
    0xBFFC, 0x594E,    /* '奎' -> 22862 */
    0xBFFD, 0x9B41,    /* '魁' -> 39745 */
    0xBFFE, 0x5080,    /* '傀' -> 20608 */
    0xC0A1, 0x9988,    /* '馈' -> 39304 */
    0xC0A2, 0x6127,    /* '愧' -> 24871 */
    0xC0A3, 0x6E83,    /* '溃' -> 28291 */
    0xC0A4, 0x5764,    /* '坤' -> 22372 */
    0xC0A5, 0x6606,    /* '昆' -> 26118 */
    0xC0A6, 0x6346,    /* '捆' -> 25414 */
    0xC0A7, 0x56F0,    /* '困' -> 22256 */
    0xC0A8, 0x62EC,    /* '括' -> 25324 */
    0xC0A9, 0x6269,    /* '扩' -> 25193 */
    0xC0AA, 0x5ED3,    /* '廓' -> 24275 */
    0xC0AB, 0x9614,    /* '阔' -> 38420 */
    0xC0AC, 0x5783,    /* '垃' -> 22403 */
    0xC0AD, 0x62C9,    /* '拉' -> 25289 */
    0xC0AE, 0x5587,    /* '喇' -> 21895 */
    0xC0AF, 0x8721,    /* '蜡' -> 34593 */
    0xC0B0, 0x814A,    /* '腊' -> 33098 */
    0xC0B1, 0x8FA3,    /* '辣' -> 36771 */
    0xC0B2, 0x5566,    /* '啦' -> 21862 */
    0xC0B3, 0x83B1,    /* '莱' -> 33713 */
    0xC0B4, 0x6765,    /* '来' -> 26469 */
    0xC0B5, 0x8D56,    /* '赖' -> 36182 */
    0xC0B6, 0x84DD,    /* '蓝' -> 34013 */
    0xC0B7, 0x5A6A,    /* '婪' -> 23146 */
    0xC0B8, 0x680F,    /* '栏' -> 26639 */
    0xC0B9, 0x62E6,    /* '拦' -> 25318 */
    0xC0BA, 0x7BEE,    /* '篮' -> 31726 */
    0xC0BB, 0x9611,    /* '阑' -> 38417 */
    0xC0BC, 0x5170,    /* '兰' -> 20848 */
    0xC0BD, 0x6F9C,    /* '澜' -> 28572 */
    0xC0BE, 0x8C30,    /* '谰' -> 35888 */
    0xC0BF, 0x63FD,    /* '揽' -> 25597 */
    0xC0C0, 0x89C8,    /* '览' -> 35272 */
    0xC0C1, 0x61D2,    /* '懒' -> 25042 */
    0xC0C2, 0x7F06,    /* '缆' -> 32518 */
    0xC0C3, 0x70C2,    /* '烂' -> 28866 */
    0xC0C4, 0x6EE5,    /* '滥' -> 28389 */
    0xC0C5, 0x7405,    /* '琅' -> 29701 */
    0xC0C6, 0x6994,    /* '榔' -> 27028 */
    0xC0C7, 0x72FC,    /* '狼' -> 29436 */
    0xC0C8, 0x5ECA,    /* '廊' -> 24266 */
    0xC0C9, 0x90CE,    /* '郎' -> 37070 */
    0xC0CA, 0x6717,    /* '朗' -> 26391 */
    0xC0CB, 0x6D6A,    /* '浪' -> 28010 */
    0xC0CC, 0x635E,    /* '捞' -> 25438 */
    0xC0CD, 0x52B3,    /* '劳' -> 21171 */
    0xC0CE, 0x7262,    /* '牢' -> 29282 */
    0xC0CF, 0x8001,    /* '老' -> 32769 */
    0xC0D0, 0x4F6C,    /* '佬' -> 20332 */
    0xC0D1, 0x59E5,    /* '姥' -> 23013 */
    0xC0D2, 0x916A,    /* '酪' -> 37226 */
    0xC0D3, 0x70D9,    /* '烙' -> 28889 */
    0xC0D4, 0x6D9D,    /* '涝' -> 28061 */
    0xC0D5, 0x52D2,    /* '勒' -> 21202 */
    0xC0D6, 0x4E50,    /* '乐' -> 20048 */
    0xC0D7, 0x96F7,    /* '雷' -> 38647 */
    0xC0D8, 0x956D,    /* '镭' -> 38253 */
    0xC0D9, 0x857E,    /* '蕾' -> 34174 */
    0xC0DA, 0x78CA,    /* '磊' -> 30922 */
    0xC0DB, 0x7D2F,    /* '累' -> 32047 */
    0xC0DC, 0x5121,    /* '儡' -> 20769 */
    0xC0DD, 0x5792,    /* '垒' -> 22418 */
    0xC0DE, 0x64C2,    /* '擂' -> 25794 */
    0xC0DF, 0x808B,    /* '肋' -> 32907 */
    0xC0E0, 0x7C7B,    /* '类' -> 31867 */
    0xC0E1, 0x6CEA,    /* '泪' -> 27882 */
    0xC0E2, 0x68F1,    /* '棱' -> 26865 */
    0xC0E3, 0x695E,    /* '楞' -> 26974 */
    0xC0E4, 0x51B7,    /* '冷' -> 20919 */
    0xC0E5, 0x5398,    /* '厘' -> 21400 */
    0xC0E6, 0x68A8,    /* '梨' -> 26792 */
    0xC0E7, 0x7281,    /* '犁' -> 29313 */
    0xC0E8, 0x9ECE,    /* '黎' -> 40654 */
    0xC0E9, 0x7BF1,    /* '篱' -> 31729 */
    0xC0EA, 0x72F8,    /* '狸' -> 29432 */
    0xC0EB, 0x79BB,    /* '离' -> 31163 */
    0xC0EC, 0x6F13,    /* '漓' -> 28435 */
    0xC0ED, 0x7406,    /* '理' -> 29702 */
    0xC0EE, 0x674E,    /* '李' -> 26446 */
    0xC0EF, 0x91CC,    /* '里' -> 37324 */
    0xC0F0, 0x9CA4,    /* '鲤' -> 40100 */
    0xC0F1, 0x793C,    /* '礼' -> 31036 */
    0xC0F2, 0x8389,    /* '莉' -> 33673 */
    0xC0F3, 0x8354,    /* '荔' -> 33620 */
    0xC0F4, 0x540F,    /* '吏' -> 21519 */
    0xC0F5, 0x6817,    /* '栗' -> 26647 */
    0xC0F6, 0x4E3D,    /* '丽' -> 20029 */
    0xC0F7, 0x5389,    /* '厉' -> 21385 */
    0xC0F8, 0x52B1,    /* '励' -> 21169 */
    0xC0F9, 0x783E,    /* '砾' -> 30782 */
    0xC0FA, 0x5386,    /* '历' -> 21382 */
    0xC0FB, 0x5229,    /* '利' -> 21033 */
    0xC0FC, 0x5088,    /* '傈' -> 20616 */
    0xC0FD, 0x4F8B,    /* '例' -> 20363 */
    0xC0FE, 0x4FD0,    /* '俐' -> 20432 */
    0xC1A1, 0x75E2,    /* '痢' -> 30178 */
    0xC1A2, 0x7ACB,    /* '立' -> 31435 */
    0xC1A3, 0x7C92,    /* '粒' -> 31890 */
    0xC1A4, 0x6CA5,    /* '沥' -> 27813 */
    0xC1A5, 0x96B6,    /* '隶' -> 38582 */
    0xC1A6, 0x529B,    /* '力' -> 21147 */
    0xC1A7, 0x7483,    /* '璃' -> 29827 */
    0xC1A8, 0x54E9,    /* '哩' -> 21737 */
    0xC1A9, 0x4FE9,    /* '俩' -> 20457 */
    0xC1AA, 0x8054,    /* '联' -> 32852 */
    0xC1AB, 0x83B2,    /* '莲' -> 33714 */
    0xC1AC, 0x8FDE,    /* '连' -> 36830 */
    0xC1AD, 0x9570,    /* '镰' -> 38256 */
    0xC1AE, 0x5EC9,    /* '廉' -> 24265 */
    0xC1AF, 0x601C,    /* '怜' -> 24604 */
    0xC1B0, 0x6D9F,    /* '涟' -> 28063 */
    0xC1B1, 0x5E18,    /* '帘' -> 24088 */
    0xC1B2, 0x655B,    /* '敛' -> 25947 */
    0xC1B3, 0x8138,    /* '脸' -> 33080 */
    0xC1B4, 0x94FE,    /* '链' -> 38142 */
    0xC1B5, 0x604B,    /* '恋' -> 24651 */
    0xC1B6, 0x70BC,    /* '炼' -> 28860 */
    0xC1B7, 0x7EC3,    /* '练' -> 32451 */
    0xC1B8, 0x7CAE,    /* '粮' -> 31918 */
    0xC1B9, 0x51C9,    /* '凉' -> 20937 */
    0xC1BA, 0x6881,    /* '梁' -> 26753 */
    0xC1BB, 0x7CB1,    /* '粱' -> 31921 */
    0xC1BC, 0x826F,    /* '良' -> 33391 */
    0xC1BD, 0x4E24,    /* '两' -> 20004 */
    0xC1BE, 0x8F86,    /* '辆' -> 36742 */
    0xC1BF, 0x91CF,    /* '量' -> 37327 */
    0xC1C0, 0x667E,    /* '晾' -> 26238 */
    0xC1C1, 0x4EAE,    /* '亮' -> 20142 */
    0xC1C2, 0x8C05,    /* '谅' -> 35845 */
    0xC1C3, 0x64A9,    /* '撩' -> 25769 */
    0xC1C4, 0x804A,    /* '聊' -> 32842 */
    0xC1C5, 0x50DA,    /* '僚' -> 20698 */
    0xC1C6, 0x7597,    /* '疗' -> 30103 */
    0xC1C7, 0x71CE,    /* '燎' -> 29134 */
    0xC1C8, 0x5BE5,    /* '寥' -> 23525 */
    0xC1C9, 0x8FBD,    /* '辽' -> 36797 */
    0xC1CA, 0x6F66,    /* '潦' -> 28518 */
    0xC1CB, 0x4E86,    /* '了' -> 20102 */
    0xC1CC, 0x6482,    /* '撂' -> 25730 */
    0xC1CD, 0x9563,    /* '镣' -> 38243 */
    0xC1CE, 0x5ED6,    /* '廖' -> 24278 */
    0xC1CF, 0x6599,    /* '料' -> 26009 */
    0xC1D0, 0x5217,    /* '列' -> 21015 */
    0xC1D1, 0x88C2,    /* '裂' -> 35010 */
    0xC1D2, 0x70C8,    /* '烈' -> 28872 */
    0xC1D3, 0x52A3,    /* '劣' -> 21155 */
    0xC1D4, 0x730E,    /* '猎' -> 29454 */
    0xC1D5, 0x7433,    /* '琳' -> 29747 */
    0xC1D6, 0x6797,    /* '林' -> 26519 */
    0xC1D7, 0x78F7,    /* '磷' -> 30967 */
    0xC1D8, 0x9716,    /* '霖' -> 38678 */
    0xC1D9, 0x4E34,    /* '临' -> 20020 */
    0xC1DA, 0x90BB,    /* '邻' -> 37051 */
    0xC1DB, 0x9CDE,    /* '鳞' -> 40158 */
    0xC1DC, 0x6DCB,    /* '淋' -> 28107 */
    0xC1DD, 0x51DB,    /* '凛' -> 20955 */
    0xC1DE, 0x8D41,    /* '赁' -> 36161 */
    0xC1DF, 0x541D,    /* '吝' -> 21533 */
    0xC1E0, 0x62CE,    /* '拎' -> 25294 */
    0xC1E1, 0x73B2,    /* '玲' -> 29618 */
    0xC1E2, 0x83F1,    /* '菱' -> 33777 */
    0xC1E3, 0x96F6,    /* '零' -> 38646 */
    0xC1E4, 0x9F84,    /* '龄' -> 40836 */
    0xC1E5, 0x94C3,    /* '铃' -> 38083 */
    0xC1E6, 0x4F36,    /* '伶' -> 20278 */
    0xC1E7, 0x7F9A,    /* '羚' -> 32666 */
    0xC1E8, 0x51CC,    /* '凌' -> 20940 */
    0xC1E9, 0x7075,    /* '灵' -> 28789 */
    0xC1EA, 0x9675,    /* '陵' -> 38517 */
    0xC1EB, 0x5CAD,    /* '岭' -> 23725 */
    0xC1EC, 0x9886,    /* '领' -> 39046 */
    0xC1ED, 0x53E6,    /* '另' -> 21478 */
    0xC1EE, 0x4EE4,    /* '令' -> 20196 */
    0xC1EF, 0x6E9C,    /* '溜' -> 28316 */
    0xC1F0, 0x7409,    /* '琉' -> 29705 */
    0xC1F1, 0x69B4,    /* '榴' -> 27060 */
    0xC1F2, 0x786B,    /* '硫' -> 30827 */
    0xC1F3, 0x998F,    /* '馏' -> 39311 */
    0xC1F4, 0x7559,    /* '留' -> 30041 */
    0xC1F5, 0x5218,    /* '刘' -> 21016 */
    0xC1F6, 0x7624,    /* '瘤' -> 30244 */
    0xC1F7, 0x6D41,    /* '流' -> 27969 */
    0xC1F8, 0x67F3,    /* '柳' -> 26611 */
    0xC1F9, 0x516D,    /* '六' -> 20845 */
    0xC1FA, 0x9F99,    /* '龙' -> 40857 */
    0xC1FB, 0x804B,    /* '聋' -> 32843 */
    0xC1FC, 0x5499,    /* '咙' -> 21657 */
    0xC1FD, 0x7B3C,    /* '笼' -> 31548 */
    0xC1FE, 0x7ABF,    /* '窿' -> 31423 */
    0xC2A1, 0x9686,    /* '隆' -> 38534 */
    0xC2A2, 0x5784,    /* '垄' -> 22404 */
    0xC2A3, 0x62E2,    /* '拢' -> 25314 */
    0xC2A4, 0x9647,    /* '陇' -> 38471 */
    0xC2A5, 0x697C,    /* '楼' -> 27004 */
    0xC2A6, 0x5A04,    /* '娄' -> 23044 */
    0xC2A7, 0x6402,    /* '搂' -> 25602 */
    0xC2A8, 0x7BD3,    /* '篓' -> 31699 */
    0xC2A9, 0x6F0F,    /* '漏' -> 28431 */
    0xC2AA, 0x964B,    /* '陋' -> 38475 */
    0xC2AB, 0x82A6,    /* '芦' -> 33446 */
    0xC2AC, 0x5362,    /* '卢' -> 21346 */
    0xC2AD, 0x9885,    /* '颅' -> 39045 */
    0xC2AE, 0x5E90,    /* '庐' -> 24208 */
    0xC2AF, 0x7089,    /* '炉' -> 28809 */
    0xC2B0, 0x63B3,    /* '掳' -> 25523 */
    0xC2B1, 0x5364,    /* '卤' -> 21348 */
    0xC2B2, 0x864F,    /* '虏' -> 34383 */
    0xC2B3, 0x9C81,    /* '鲁' -> 40065 */
    0xC2B4, 0x9E93,    /* '麓' -> 40595 */
    0xC2B5, 0x788C,    /* '碌' -> 30860 */
    0xC2B6, 0x9732,    /* '露' -> 38706 */
    0xC2B7, 0x8DEF,    /* '路' -> 36335 */
    0xC2B8, 0x8D42,    /* '赂' -> 36162 */
    0xC2B9, 0x9E7F,    /* '鹿' -> 40575 */
    0xC2BA, 0x6F5E,    /* '潞' -> 28510 */
    0xC2BB, 0x7984,    /* '禄' -> 31108 */
    0xC2BC, 0x5F55,    /* '录' -> 24405 */
    0xC2BD, 0x9646,    /* '陆' -> 38470 */
    0xC2BE, 0x622E,    /* '戮' -> 25134 */
    0xC2BF, 0x9A74,    /* '驴' -> 39540 */
    0xC2C0, 0x5415,    /* '吕' -> 21525 */
    0xC2C1, 0x94DD,    /* '铝' -> 38109 */
    0xC2C2, 0x4FA3,    /* '侣' -> 20387 */
    0xC2C3, 0x65C5,    /* '旅' -> 26053 */
    0xC2C4, 0x5C65,    /* '履' -> 23653 */
    0xC2C5, 0x5C61,    /* '屡' -> 23649 */
    0xC2C6, 0x7F15,    /* '缕' -> 32533 */
    0xC2C7, 0x8651,    /* '虑' -> 34385 */
    0xC2C8, 0x6C2F,    /* '氯' -> 27695 */
    0xC2C9, 0x5F8B,    /* '律' -> 24459 */
    0xC2CA, 0x7387,    /* '率' -> 29575 */
    0xC2CB, 0x6EE4,    /* '滤' -> 28388 */
    0xC2CC, 0x7EFF,    /* '绿' -> 32511 */
    0xC2CD, 0x5CE6,    /* '峦' -> 23782 */
    0xC2CE, 0x631B,    /* '挛' -> 25371 */
    0xC2CF, 0x5B6A,    /* '孪' -> 23402 */
    0xC2D0, 0x6EE6,    /* '滦' -> 28390 */
    0xC2D1, 0x5375,    /* '卵' -> 21365 */
    0xC2D2, 0x4E71,    /* '乱' -> 20081 */
    0xC2D3, 0x63A0,    /* '掠' -> 25504 */
    0xC2D4, 0x7565,    /* '略' -> 30053 */
    0xC2D5, 0x62A1,    /* '抡' -> 25249 */
    0xC2D6, 0x8F6E,    /* '轮' -> 36718 */
    0xC2D7, 0x4F26,    /* '伦' -> 20262 */
    0xC2D8, 0x4ED1,    /* '仑' -> 20177 */
    0xC2D9, 0x6CA6,    /* '沦' -> 27814 */
    0xC2DA, 0x7EB6,    /* '纶' -> 32438 */
    0xC2DB, 0x8BBA,    /* '论' -> 35770 */
    0xC2DC, 0x841D,    /* '萝' -> 33821 */
    0xC2DD, 0x87BA,    /* '螺' -> 34746 */
    0xC2DE, 0x7F57,    /* '罗' -> 32599 */
    0xC2DF, 0x903B,    /* '逻' -> 36923 */
    0xC2E0, 0x9523,    /* '锣' -> 38179 */
    0xC2E1, 0x7BA9,    /* '箩' -> 31657 */
    0xC2E2, 0x9AA1,    /* '骡' -> 39585 */
    0xC2E3, 0x88F8,    /* '裸' -> 35064 */
    0xC2E4, 0x843D,    /* '落' -> 33853 */
    0xC2E5, 0x6D1B,    /* '洛' -> 27931 */
    0xC2E6, 0x9A86,    /* '骆' -> 39558 */
    0xC2E7, 0x7EDC,    /* '络' -> 32476 */
    0xC2E8, 0x5988,    /* '妈' -> 22920 */
    0xC2E9, 0x9EBB,    /* '麻' -> 40635 */
    0xC2EA, 0x739B,    /* '玛' -> 29595 */
    0xC2EB, 0x7801,    /* '码' -> 30721 */
    0xC2EC, 0x8682,    /* '蚂' -> 34434 */
    0xC2ED, 0x9A6C,    /* '马' -> 39532 */
    0xC2EE, 0x9A82,    /* '骂' -> 39554 */
    0xC2EF, 0x561B,    /* '嘛' -> 22043 */
    0xC2F0, 0x5417,    /* '吗' -> 21527 */
    0xC2F1, 0x57CB,    /* '埋' -> 22475 */
    0xC2F2, 0x4E70,    /* '买' -> 20080 */
    0xC2F3, 0x9EA6,    /* '麦' -> 40614 */
    0xC2F4, 0x5356,    /* '卖' -> 21334 */
    0xC2F5, 0x8FC8,    /* '迈' -> 36808 */
    0xC2F6, 0x8109,    /* '脉' -> 33033 */
    0xC2F7, 0x7792,    /* '瞒' -> 30610 */
    0xC2F8, 0x9992,    /* '馒' -> 39314 */
    0xC2F9, 0x86EE,    /* '蛮' -> 34542 */
    0xC2FA, 0x6EE1,    /* '满' -> 28385 */
    0xC2FB, 0x8513,    /* '蔓' -> 34067 */
    0xC2FC, 0x66FC,    /* '曼' -> 26364 */
    0xC2FD, 0x6162,    /* '慢' -> 24930 */
    0xC2FE, 0x6F2B,    /* '漫' -> 28459 */
    0xC3A1, 0x8C29,    /* '谩' -> 35881 */
    0xC3A2, 0x8292,    /* '芒' -> 33426 */
    0xC3A3, 0x832B,    /* '茫' -> 33579 */
    0xC3A4, 0x76F2,    /* '盲' -> 30450 */
    0xC3A5, 0x6C13,    /* '氓' -> 27667 */
    0xC3A6, 0x5FD9,    /* '忙' -> 24537 */
    0xC3A7, 0x83BD,    /* '莽' -> 33725 */
    0xC3A8, 0x732B,    /* '猫' -> 29483 */
    0xC3A9, 0x8305,    /* '茅' -> 33541 */
    0xC3AA, 0x951A,    /* '锚' -> 38170 */
    0xC3AB, 0x6BDB,    /* '毛' -> 27611 */
    0xC3AC, 0x77DB,    /* '矛' -> 30683 */
    0xC3AD, 0x94C6,    /* '铆' -> 38086 */
    0xC3AE, 0x536F,    /* '卯' -> 21359 */
    0xC3AF, 0x8302,    /* '茂' -> 33538 */
    0xC3B0, 0x5192,    /* '冒' -> 20882 */
    0xC3B1, 0x5E3D,    /* '帽' -> 24125 */
    0xC3B2, 0x8C8C,    /* '貌' -> 35980 */
    0xC3B3, 0x8D38,    /* '贸' -> 36152 */
    0xC3B4, 0x4E48,    /* '么' -> 20040 */
    0xC3B5, 0x73AB,    /* '玫' -> 29611 */
    0xC3B6, 0x679A,    /* '枚' -> 26522 */
    0xC3B7, 0x6885,    /* '梅' -> 26757 */
    0xC3B8, 0x9176,    /* '酶' -> 37238 */
    0xC3B9, 0x9709,    /* '霉' -> 38665 */
    0xC3BA, 0x7164,    /* '煤' -> 29028 */
    0xC3BB, 0x6CA1,    /* '没' -> 27809 */
    0xC3BC, 0x7709,    /* '眉' -> 30473 */
    0xC3BD, 0x5A92,    /* '媒' -> 23186 */
    0xC3BE, 0x9541,    /* '镁' -> 38209 */
    0xC3BF, 0x6BCF,    /* '每' -> 27599 */
    0xC3C0, 0x7F8E,    /* '美' -> 32654 */
    0xC3C1, 0x6627,    /* '昧' -> 26151 */
    0xC3C2, 0x5BD0,    /* '寐' -> 23504 */
    0xC3C3, 0x59B9,    /* '妹' -> 22969 */
    0xC3C4, 0x5A9A,    /* '媚' -> 23194 */
    0xC3C5, 0x95E8,    /* '门' -> 38376 */
    0xC3C6, 0x95F7,    /* '闷' -> 38391 */
    0xC3C7, 0x4EEC,    /* '们' -> 20204 */
    0xC3C8, 0x840C,    /* '萌' -> 33804 */
    0xC3C9, 0x8499,    /* '蒙' -> 33945 */
    0xC3CA, 0x6AAC,    /* '檬' -> 27308 */
    0xC3CB, 0x76DF,    /* '盟' -> 30431 */
    0xC3CC, 0x9530,    /* '锰' -> 38192 */
    0xC3CD, 0x731B,    /* '猛' -> 29467 */
    0xC3CE, 0x68A6,    /* '梦' -> 26790 */
    0xC3CF, 0x5B5F,    /* '孟' -> 23391 */
    0xC3D0, 0x772F,    /* '眯' -> 30511 */
    0xC3D1, 0x919A,    /* '醚' -> 37274 */
    0xC3D2, 0x9761,    /* '靡' -> 38753 */
    0xC3D3, 0x7CDC,    /* '糜' -> 31964 */
    0xC3D4, 0x8FF7,    /* '迷' -> 36855 */
    0xC3D5, 0x8C1C,    /* '谜' -> 35868 */
    0xC3D6, 0x5F25,    /* '弥' -> 24357 */
    0xC3D7, 0x7C73,    /* '米' -> 31859 */
    0xC3D8, 0x79D8,    /* '秘' -> 31192 */
    0xC3D9, 0x89C5,    /* '觅' -> 35269 */
    0xC3DA, 0x6CCC,    /* '泌' -> 27852 */
    0xC3DB, 0x871C,    /* '蜜' -> 34588 */
    0xC3DC, 0x5BC6,    /* '密' -> 23494 */
    0xC3DD, 0x5E42,    /* '幂' -> 24130 */
    0xC3DE, 0x68C9,    /* '棉' -> 26825 */
    0xC3DF, 0x7720,    /* '眠' -> 30496 */
    0xC3E0, 0x7EF5,    /* '绵' -> 32501 */
    0xC3E1, 0x5195,    /* '冕' -> 20885 */
    0xC3E2, 0x514D,    /* '免' -> 20813 */
    0xC3E3, 0x52C9,    /* '勉' -> 21193 */
    0xC3E4, 0x5A29,    /* '娩' -> 23081 */
    0xC3E5, 0x7F05,    /* '缅' -> 32517 */
    0xC3E6, 0x9762,    /* '面' -> 38754 */
    0xC3E7, 0x82D7,    /* '苗' -> 33495 */
    0xC3E8, 0x63CF,    /* '描' -> 25551 */
    0xC3E9, 0x7784,    /* '瞄' -> 30596 */
    0xC3EA, 0x85D0,    /* '藐' -> 34256 */
    0xC3EB, 0x79D2,    /* '秒' -> 31186 */
    0xC3EC, 0x6E3A,    /* '渺' -> 28218 */
    0xC3ED, 0x5E99,    /* '庙' -> 24217 */
    0xC3EE, 0x5999,    /* '妙' -> 22937 */
    0xC3EF, 0x8511,    /* '蔑' -> 34065 */
    0xC3F0, 0x706D,    /* '灭' -> 28781 */
    0xC3F1, 0x6C11,    /* '民' -> 27665 */
    0xC3F2, 0x62BF,    /* '抿' -> 25279 */
    0xC3F3, 0x76BF,    /* '皿' -> 30399 */
    0xC3F4, 0x654F,    /* '敏' -> 25935 */
    0xC3F5, 0x60AF,    /* '悯' -> 24751 */
    0xC3F6, 0x95FD,    /* '闽' -> 38397 */
    0xC3F7, 0x660E,    /* '明' -> 26126 */
    0xC3F8, 0x879F,    /* '螟' -> 34719 */
    0xC3F9, 0x9E23,    /* '鸣' -> 40483 */
    0xC3FA, 0x94ED,    /* '铭' -> 38125 */
    0xC3FB, 0x540D,    /* '名' -> 21517 */
    0xC3FC, 0x547D,    /* '命' -> 21629 */
    0xC3FD, 0x8C2C,    /* '谬' -> 35884 */
    0xC3FE, 0x6478,    /* '摸' -> 25720 */
    0xC4A1, 0x6479,    /* '摹' -> 25721 */
    0xC4A2, 0x8611,    /* '蘑' -> 34321 */
    0xC4A3, 0x6A21,    /* '模' -> 27169 */
    0xC4A4, 0x819C,    /* '膜' -> 33180 */
    0xC4A5, 0x78E8,    /* '磨' -> 30952 */
    0xC4A6, 0x6469,    /* '摩' -> 25705 */
    0xC4A7, 0x9B54,    /* '魔' -> 39764 */
    0xC4A8, 0x62B9,    /* '抹' -> 25273 */
    0xC4A9, 0x672B,    /* '末' -> 26411 */
    0xC4AA, 0x83AB,    /* '莫' -> 33707 */
    0xC4AB, 0x58A8,    /* '墨' -> 22696 */
    0xC4AC, 0x9ED8,    /* '默' -> 40664 */
    0xC4AD, 0x6CAB,    /* '沫' -> 27819 */
    0xC4AE, 0x6F20,    /* '漠' -> 28448 */
    0xC4AF, 0x5BDE,    /* '寞' -> 23518 */
    0xC4B0, 0x964C,    /* '陌' -> 38476 */
    0xC4B1, 0x8C0B,    /* '谋' -> 35851 */
    0xC4B2, 0x725F,    /* '牟' -> 29279 */
    0xC4B3, 0x67D0,    /* '某' -> 26576 */
    0xC4B4, 0x62C7,    /* '拇' -> 25287 */
    0xC4B5, 0x7261,    /* '牡' -> 29281 */
    0xC4B6, 0x4EA9,    /* '亩' -> 20137 */
    0xC4B7, 0x59C6,    /* '姆' -> 22982 */
    0xC4B8, 0x6BCD,    /* '母' -> 27597 */
    0xC4B9, 0x5893,    /* '墓' -> 22675 */
    0xC4BA, 0x66AE,    /* '暮' -> 26286 */
    0xC4BB, 0x5E55,    /* '幕' -> 24149 */
    0xC4BC, 0x52DF,    /* '募' -> 21215 */
    0xC4BD, 0x6155,    /* '慕' -> 24917 */
    0xC4BE, 0x6728,    /* '木' -> 26408 */
    0xC4BF, 0x76EE,    /* '目' -> 30446 */
    0xC4C0, 0x7766,    /* '睦' -> 30566 */
    0xC4C1, 0x7267,    /* '牧' -> 29287 */
    0xC4C2, 0x7A46,    /* '穆' -> 31302 */
    0xC4C3, 0x62FF,    /* '拿' -> 25343 */
    0xC4C4, 0x54EA,    /* '哪' -> 21738 */
    0xC4C5, 0x5450,    /* '呐' -> 21584 */
    0xC4C6, 0x94A0,    /* '钠' -> 38048 */
    0xC4C7, 0x90A3,    /* '那' -> 37027 */
    0xC4C8, 0x5A1C,    /* '娜' -> 23068 */
    0xC4C9, 0x7EB3,    /* '纳' -> 32435 */
    0xC4CA, 0x6C16,    /* '氖' -> 27670 */
    0xC4CB, 0x4E43,    /* '乃' -> 20035 */
    0xC4CC, 0x5976,    /* '奶' -> 22902 */
    0xC4CD, 0x8010,    /* '耐' -> 32784 */
    0xC4CE, 0x5948,    /* '奈' -> 22856 */
    0xC4CF, 0x5357,    /* '南' -> 21335 */
    0xC4D0, 0x7537,    /* '男' -> 30007 */
    0xC4D1, 0x96BE,    /* '难' -> 38590 */
    0xC4D2, 0x56CA,    /* '囊' -> 22218 */
    0xC4D3, 0x6320,    /* '挠' -> 25376 */
    0xC4D4, 0x8111,    /* '脑' -> 33041 */
    0xC4D5, 0x607C,    /* '恼' -> 24700 */
    0xC4D6, 0x95F9,    /* '闹' -> 38393 */
    0xC4D7, 0x6DD6,    /* '淖' -> 28118 */
    0xC4D8, 0x5462,    /* '呢' -> 21602 */
    0xC4D9, 0x9981,    /* '馁' -> 39297 */
    0xC4DA, 0x5185,    /* '内' -> 20869 */
    0xC4DB, 0x5AE9,    /* '嫩' -> 23273 */
    0xC4DC, 0x80FD,    /* '能' -> 33021 */
    0xC4DD, 0x59AE,    /* '妮' -> 22958 */
    0xC4DE, 0x9713,    /* '霓' -> 38675 */
    0xC4DF, 0x502A,    /* '倪' -> 20522 */
    0xC4E0, 0x6CE5,    /* '泥' -> 27877 */
    0xC4E1, 0x5C3C,    /* '尼' -> 23612 */
    0xC4E2, 0x62DF,    /* '拟' -> 25311 */
    0xC4E3, 0x4F60,    /* '你' -> 20320 */
    0xC4E4, 0x533F,    /* '匿' -> 21311 */
    0xC4E5, 0x817B,    /* '腻' -> 33147 */
    0xC4E6, 0x9006,    /* '逆' -> 36870 */
    0xC4E7, 0x6EBA,    /* '溺' -> 28346 */
    0xC4E8, 0x852B,    /* '蔫' -> 34091 */
    0xC4E9, 0x62C8,    /* '拈' -> 25288 */
    0xC4EA, 0x5E74,    /* '年' -> 24180 */
    0xC4EB, 0x78BE,    /* '碾' -> 30910 */
    0xC4EC, 0x64B5,    /* '撵' -> 25781 */
    0xC4ED, 0x637B,    /* '捻' -> 25467 */
    0xC4EE, 0x5FF5,    /* '念' -> 24565 */
    0xC4EF, 0x5A18,    /* '娘' -> 23064 */
    0xC4F0, 0x917F,    /* '酿' -> 37247 */
    0xC4F1, 0x9E1F,    /* '鸟' -> 40479 */
    0xC4F2, 0x5C3F,    /* '尿' -> 23615 */
    0xC4F3, 0x634F,    /* '捏' -> 25423 */
    0xC4F4, 0x8042,    /* '聂' -> 32834 */
    0xC4F5, 0x5B7D,    /* '孽' -> 23421 */
    0xC4F6, 0x556E,    /* '啮' -> 21870 */
    0xC4F7, 0x954A,    /* '镊' -> 38218 */
    0xC4F8, 0x954D,    /* '镍' -> 38221 */
    0xC4F9, 0x6D85,    /* '涅' -> 28037 */
    0xC4FA, 0x60A8,    /* '您' -> 24744 */
    0xC4FB, 0x67E0,    /* '柠' -> 26592 */
    0xC4FC, 0x72DE,    /* '狞' -> 29406 */
    0xC4FD, 0x51DD,    /* '凝' -> 20957 */
    0xC4FE, 0x5B81,    /* '宁' -> 23425 */
    0xC5A1, 0x62E7,    /* '拧' -> 25319 */
    0xC5A2, 0x6CDE,    /* '泞' -> 27870 */
    0xC5A3, 0x725B,    /* '牛' -> 29275 */
    0xC5A4, 0x626D,    /* '扭' -> 25197 */
    0xC5A5, 0x94AE,    /* '钮' -> 38062 */
    0xC5A6, 0x7EBD,    /* '纽' -> 32445 */
    0xC5A7, 0x8113,    /* '脓' -> 33043 */
    0xC5A8, 0x6D53,    /* '浓' -> 27987 */
    0xC5A9, 0x519C,    /* '农' -> 20892 */
    0xC5AA, 0x5F04,    /* '弄' -> 24324 */
    0xC5AB, 0x5974,    /* '奴' -> 22900 */
    0xC5AC, 0x52AA,    /* '努' -> 21162 */
    0xC5AD, 0x6012,    /* '怒' -> 24594 */
    0xC5AE, 0x5973,    /* '女' -> 22899 */
    0xC5AF, 0x6696,    /* '暖' -> 26262 */
    0xC5B0, 0x8650,    /* '虐' -> 34384 */
    0xC5B1, 0x759F,    /* '疟' -> 30111 */
    0xC5B2, 0x632A,    /* '挪' -> 25386 */
    0xC5B3, 0x61E6,    /* '懦' -> 25062 */
    0xC5B4, 0x7CEF,    /* '糯' -> 31983 */
    0xC5B5, 0x8BFA,    /* '诺' -> 35834 */
    0xC5B6, 0x54E6,    /* '哦' -> 21734 */
    0xC5B7, 0x6B27,    /* '欧' -> 27431 */
    0xC5B8, 0x9E25,    /* '鸥' -> 40485 */
    0xC5B9, 0x6BB4,    /* '殴' -> 27572 */
    0xC5BA, 0x85D5,    /* '藕' -> 34261 */
    0xC5BB, 0x5455,    /* '呕' -> 21589 */
    0xC5BC, 0x5076,    /* '偶' -> 20598 */
    0xC5BD, 0x6CA4,    /* '沤' -> 27812 */
    0xC5BE, 0x556A,    /* '啪' -> 21866 */
    0xC5BF, 0x8DB4,    /* '趴' -> 36276 */
    0xC5C0, 0x722C,    /* '爬' -> 29228 */
    0xC5C1, 0x5E15,    /* '帕' -> 24085 */
    0xC5C2, 0x6015,    /* '怕' -> 24597 */
    0xC5C3, 0x7436,    /* '琶' -> 29750 */
    0xC5C4, 0x62CD,    /* '拍' -> 25293 */
    0xC5C5, 0x6392,    /* '排' -> 25490 */
    0xC5C6, 0x724C,    /* '牌' -> 29260 */
    0xC5C7, 0x5F98,    /* '徘' -> 24472 */
    0xC5C8, 0x6E43,    /* '湃' -> 28227 */
    0xC5C9, 0x6D3E,    /* '派' -> 27966 */
    0xC5CA, 0x6500,    /* '攀' -> 25856 */
    0xC5CB, 0x6F58,    /* '潘' -> 28504 */
    0xC5CC, 0x76D8,    /* '盘' -> 30424 */
    0xC5CD, 0x78D0,    /* '磐' -> 30928 */
    0xC5CE, 0x76FC,    /* '盼' -> 30460 */
    0xC5CF, 0x7554,    /* '畔' -> 30036 */
    0xC5D0, 0x5224,    /* '判' -> 21028 */
    0xC5D1, 0x53DB,    /* '叛' -> 21467 */
    0xC5D2, 0x4E53,    /* '乓' -> 20051 */
    0xC5D3, 0x5E9E,    /* '庞' -> 24222 */
    0xC5D4, 0x65C1,    /* '旁' -> 26049 */
    0xC5D5, 0x802A,    /* '耪' -> 32810 */
    0xC5D6, 0x80D6,    /* '胖' -> 32982 */
    0xC5D7, 0x629B,    /* '抛' -> 25243 */
    0xC5D8, 0x5486,    /* '咆' -> 21638 */
    0xC5D9, 0x5228,    /* '刨' -> 21032 */
    0xC5DA, 0x70AE,    /* '炮' -> 28846 */
    0xC5DB, 0x888D,    /* '袍' -> 34957 */
    0xC5DC, 0x8DD1,    /* '跑' -> 36305 */
    0xC5DD, 0x6CE1,    /* '泡' -> 27873 */
    0xC5DE, 0x5478,    /* '呸' -> 21624 */
    0xC5DF, 0x80DA,    /* '胚' -> 32986 */
    0xC5E0, 0x57F9,    /* '培' -> 22521 */
    0xC5E1, 0x88F4,    /* '裴' -> 35060 */
    0xC5E2, 0x8D54,    /* '赔' -> 36180 */
    0xC5E3, 0x966A,    /* '陪' -> 38506 */
    0xC5E4, 0x914D,    /* '配' -> 37197 */
    0xC5E5, 0x4F69,    /* '佩' -> 20329 */
    0xC5E6, 0x6C9B,    /* '沛' -> 27803 */
    0xC5E7, 0x55B7,    /* '喷' -> 21943 */
    0xC5E8, 0x76C6,    /* '盆' -> 30406 */
    0xC5E9, 0x7830,    /* '砰' -> 30768 */
    0xC5EA, 0x62A8,    /* '抨' -> 25256 */
    0xC5EB, 0x70F9,    /* '烹' -> 28921 */
    0xC5EC, 0x6F8E,    /* '澎' -> 28558 */
    0xC5ED, 0x5F6D,    /* '彭' -> 24429 */
    0xC5EE, 0x84EC,    /* '蓬' -> 34028 */
    0xC5EF, 0x68DA,    /* '棚' -> 26842 */
    0xC5F0, 0x787C,    /* '硼' -> 30844 */
    0xC5F1, 0x7BF7,    /* '篷' -> 31735 */
    0xC5F2, 0x81A8,    /* '膨' -> 33192 */
    0xC5F3, 0x670B,    /* '朋' -> 26379 */
    0xC5F4, 0x9E4F,    /* '鹏' -> 40527 */
    0xC5F5, 0x6367,    /* '捧' -> 25447 */
    0xC5F6, 0x78B0,    /* '碰' -> 30896 */
    0xC5F7, 0x576F,    /* '坯' -> 22383 */
    0xC5F8, 0x7812,    /* '砒' -> 30738 */
    0xC5F9, 0x9739,    /* '霹' -> 38713 */
    0xC5FA, 0x6279,    /* '批' -> 25209 */
    0xC5FB, 0x62AB,    /* '披' -> 25259 */
    0xC5FC, 0x5288,    /* '劈' -> 21128 */
    0xC5FD, 0x7435,    /* '琵' -> 29749 */
    0xC5FE, 0x6BD7,    /* '毗' -> 27607 */
    0xC6A1, 0x5564,    /* '啤' -> 21860 */
    0xC6A2, 0x813E,    /* '脾' -> 33086 */
    0xC6A3, 0x75B2,    /* '疲' -> 30130 */
    0xC6A4, 0x76AE,    /* '皮' -> 30382 */
    0xC6A5, 0x5339,    /* '匹' -> 21305 */
    0xC6A6, 0x75DE,    /* '痞' -> 30174 */
    0xC6A7, 0x50FB,    /* '僻' -> 20731 */
    0xC6A8, 0x5C41,    /* '屁' -> 23617 */
    0xC6A9, 0x8B6C,    /* '譬' -> 35692 */
    0xC6AA, 0x7BC7,    /* '篇' -> 31687 */
    0xC6AB, 0x504F,    /* '偏' -> 20559 */
    0xC6AC, 0x7247,    /* '片' -> 29255 */
    0xC6AD, 0x9A97,    /* '骗' -> 39575 */
    0xC6AE, 0x98D8,    /* '飘' -> 39128 */
    0xC6AF, 0x6F02,    /* '漂' -> 28418 */
    0xC6B0, 0x74E2,    /* '瓢' -> 29922 */
    0xC6B1, 0x7968,    /* '票' -> 31080 */
    0xC6B2, 0x6487,    /* '撇' -> 25735 */
    0xC6B3, 0x77A5,    /* '瞥' -> 30629 */
    0xC6B4, 0x62FC,    /* '拼' -> 25340 */
    0xC6B5, 0x9891,    /* '频' -> 39057 */
    0xC6B6, 0x8D2B,    /* '贫' -> 36139 */
    0xC6B7, 0x54C1,    /* '品' -> 21697 */
    0xC6B8, 0x8058,    /* '聘' -> 32856 */
    0xC6B9, 0x4E52,    /* '乒' -> 20050 */
    0xC6BA, 0x576A,    /* '坪' -> 22378 */
    0xC6BB, 0x82F9,    /* '苹' -> 33529 */
    0xC6BC, 0x840D,    /* '萍' -> 33805 */
    0xC6BD, 0x5E73,    /* '平' -> 24179 */
    0xC6BE, 0x51ED,    /* '凭' -> 20973 */
    0xC6BF, 0x74F6,    /* '瓶' -> 29942 */
    0xC6C0, 0x8BC4,    /* '评' -> 35780 */
    0xC6C1, 0x5C4F,    /* '屏' -> 23631 */
    0xC6C2, 0x5761,    /* '坡' -> 22369 */
    0xC6C3, 0x6CFC,    /* '泼' -> 27900 */
    0xC6C4, 0x9887,    /* '颇' -> 39047 */
    0xC6C5, 0x5A46,    /* '婆' -> 23110 */
    0xC6C6, 0x7834,    /* '破' -> 30772 */
    0xC6C7, 0x9B44,    /* '魄' -> 39748 */
    0xC6C8, 0x8FEB,    /* '迫' -> 36843 */
    0xC6C9, 0x7C95,    /* '粕' -> 31893 */
    0xC6CA, 0x5256,    /* '剖' -> 21078 */
    0xC6CB, 0x6251,    /* '扑' -> 25169 */
    0xC6CC, 0x94FA,    /* '铺' -> 38138 */
    0xC6CD, 0x4EC6,    /* '仆' -> 20166 */
    0xC6CE, 0x8386,    /* '莆' -> 33670 */
    0xC6CF, 0x8461,    /* '葡' -> 33889 */
    0xC6D0, 0x83E9,    /* '菩' -> 33769 */
    0xC6D1, 0x84B2,    /* '蒲' -> 33970 */
    0xC6D2, 0x57D4,    /* '埔' -> 22484 */
    0xC6D3, 0x6734,    /* '朴' -> 26420 */
    0xC6D4, 0x5703,    /* '圃' -> 22275 */
    0xC6D5, 0x666E,    /* '普' -> 26222 */
    0xC6D6, 0x6D66,    /* '浦' -> 28006 */
    0xC6D7, 0x8C31,    /* '谱' -> 35889 */
    0xC6D8, 0x66DD,    /* '曝' -> 26333 */
    0xC6D9, 0x7011,    /* '瀑' -> 28689 */
    0xC6DA, 0x671F,    /* '期' -> 26399 */
    0xC6DB, 0x6B3A,    /* '欺' -> 27450 */
    0xC6DC, 0x6816,    /* '栖' -> 26646 */
    0xC6DD, 0x621A,    /* '戚' -> 25114 */
    0xC6DE, 0x59BB,    /* '妻' -> 22971 */
    0xC6DF, 0x4E03,    /* '七' -> 19971 */
    0xC6E0, 0x51C4,    /* '凄' -> 20932 */
    0xC6E1, 0x6F06,    /* '漆' -> 28422 */
    0xC6E2, 0x67D2,    /* '柒' -> 26578 */
    0xC6E3, 0x6C8F,    /* '沏' -> 27791 */
    0xC6E4, 0x5176,    /* '其' -> 20854 */
    0xC6E5, 0x68CB,    /* '棋' -> 26827 */
    0xC6E6, 0x5947,    /* '奇' -> 22855 */
    0xC6E7, 0x6B67,    /* '歧' -> 27495 */
    0xC6E8, 0x7566,    /* '畦' -> 30054 */
    0xC6E9, 0x5D0E,    /* '崎' -> 23822 */
    0xC6EA, 0x8110,    /* '脐' -> 33040 */
    0xC6EB, 0x9F50,    /* '齐' -> 40784 */
    0xC6EC, 0x65D7,    /* '旗' -> 26071 */
    0xC6ED, 0x7948,    /* '祈' -> 31048 */
    0xC6EE, 0x7941,    /* '祁' -> 31041 */
    0xC6EF, 0x9A91,    /* '骑' -> 39569 */
    0xC6F0, 0x8D77,    /* '起' -> 36215 */
    0xC6F1, 0x5C82,    /* '岂' -> 23682 */
    0xC6F2, 0x4E5E,    /* '乞' -> 20062 */
    0xC6F3, 0x4F01,    /* '企' -> 20225 */
    0xC6F4, 0x542F,    /* '启' -> 21551 */
    0xC6F5, 0x5951,    /* '契' -> 22865 */
    0xC6F6, 0x780C,    /* '砌' -> 30732 */
    0xC6F7, 0x5668,    /* '器' -> 22120 */
    0xC6F8, 0x6C14,    /* '气' -> 27668 */
    0xC6F9, 0x8FC4,    /* '迄' -> 36804 */
    0xC6FA, 0x5F03,    /* '弃' -> 24323 */
    0xC6FB, 0x6C7D,    /* '汽' -> 27773 */
    0xC6FC, 0x6CE3,    /* '泣' -> 27875 */
    0xC6FD, 0x8BAB,    /* '讫' -> 35755 */
    0xC6FE, 0x6390,    /* '掐' -> 25488 */
    0xC7A1, 0x6070,    /* '恰' -> 24688 */
    0xC7A2, 0x6D3D,    /* '洽' -> 27965 */
    0xC7A3, 0x7275,    /* '牵' -> 29301 */
    0xC7A4, 0x6266,    /* '扦' -> 25190 */
    0xC7A5, 0x948E,    /* '钎' -> 38030 */
    0xC7A6, 0x94C5,    /* '铅' -> 38085 */
    0xC7A7, 0x5343,    /* '千' -> 21315 */
    0xC7A8, 0x8FC1,    /* '迁' -> 36801 */
    0xC7A9, 0x7B7E,    /* '签' -> 31614 */
    0xC7AA, 0x4EDF,    /* '仟' -> 20191 */
    0xC7AB, 0x8C26,    /* '谦' -> 35878 */
    0xC7AC, 0x4E7E,    /* '乾' -> 20094 */
    0xC7AD, 0x9ED4,    /* '黔' -> 40660 */
    0xC7AE, 0x94B1,    /* '钱' -> 38065 */
    0xC7AF, 0x94B3,    /* '钳' -> 38067 */
    0xC7B0, 0x524D,    /* '前' -> 21069 */
    0xC7B1, 0x6F5C,    /* '潜' -> 28508 */
    0xC7B2, 0x9063,    /* '遣' -> 36963 */
    0xC7B3, 0x6D45,    /* '浅' -> 27973 */
    0xC7B4, 0x8C34,    /* '谴' -> 35892 */
    0xC7B5, 0x5811,    /* '堑' -> 22545 */
    0xC7B6, 0x5D4C,    /* '嵌' -> 23884 */
    0xC7B7, 0x6B20,    /* '欠' -> 27424 */
    0xC7B8, 0x6B49,    /* '歉' -> 27465 */
    0xC7B9, 0x67AA,    /* '枪' -> 26538 */
    0xC7BA, 0x545B,    /* '呛' -> 21595 */
    0xC7BB, 0x8154,    /* '腔' -> 33108 */
    0xC7BC, 0x7F8C,    /* '羌' -> 32652 */
    0xC7BD, 0x5899,    /* '墙' -> 22681 */
    0xC7BE, 0x8537,    /* '蔷' -> 34103 */
    0xC7BF, 0x5F3A,    /* '强' -> 24378 */
    0xC7C0, 0x62A2,    /* '抢' -> 25250 */
    0xC7C1, 0x6A47,    /* '橇' -> 27207 */
    0xC7C2, 0x9539,    /* '锹' -> 38201 */
    0xC7C3, 0x6572,    /* '敲' -> 25970 */
    0xC7C4, 0x6084,    /* '悄' -> 24708 */
    0xC7C5, 0x6865,    /* '桥' -> 26725 */
    0xC7C6, 0x77A7,    /* '瞧' -> 30631 */
    0xC7C7, 0x4E54,    /* '乔' -> 20052 */
    0xC7C8, 0x4FA8,    /* '侨' -> 20392 */
    0xC7C9, 0x5DE7,    /* '巧' -> 24039 */
    0xC7CA, 0x9798,    /* '鞘' -> 38808 */
    0xC7CB, 0x64AC,    /* '撬' -> 25772 */
    0xC7CC, 0x7FD8,    /* '翘' -> 32728 */
    0xC7CD, 0x5CED,    /* '峭' -> 23789 */
    0xC7CE, 0x4FCF,    /* '俏' -> 20431 */
    0xC7CF, 0x7A8D,    /* '窍' -> 31373 */
    0xC7D0, 0x5207,    /* '切' -> 20999 */
    0xC7D1, 0x8304,    /* '茄' -> 33540 */
    0xC7D2, 0x4E14,    /* '且' -> 19988 */
    0xC7D3, 0x602F,    /* '怯' -> 24623 */
    0xC7D4, 0x7A83,    /* '窃' -> 31363 */
    0xC7D5, 0x94A6,    /* '钦' -> 38054 */
    0xC7D6, 0x4FB5,    /* '侵' -> 20405 */
    0xC7D7, 0x4EB2,    /* '亲' -> 20146 */
    0xC7D8, 0x79E6,    /* '秦' -> 31206 */
    0xC7D9, 0x7434,    /* '琴' -> 29748 */
    0xC7DA, 0x52E4,    /* '勤' -> 21220 */
    0xC7DB, 0x82B9,    /* '芹' -> 33465 */
    0xC7DC, 0x64D2,    /* '擒' -> 25810 */
    0xC7DD, 0x79BD,    /* '禽' -> 31165 */
    0xC7DE, 0x5BDD,    /* '寝' -> 23517 */
    0xC7DF, 0x6C81,    /* '沁' -> 27777 */
    0xC7E0, 0x9752,    /* '青' -> 38738 */
    0xC7E1, 0x8F7B,    /* '轻' -> 36731 */
    0xC7E2, 0x6C22,    /* '氢' -> 27682 */
    0xC7E3, 0x503E,    /* '倾' -> 20542 */
    0xC7E4, 0x537F,    /* '卿' -> 21375 */
    0xC7E5, 0x6E05,    /* '清' -> 28165 */
    0xC7E6, 0x64CE,    /* '擎' -> 25806 */
    0xC7E7, 0x6674,    /* '晴' -> 26228 */
    0xC7E8, 0x6C30,    /* '氰' -> 27696 */
    0xC7E9, 0x60C5,    /* '情' -> 24773 */
    0xC7EA, 0x9877,    /* '顷' -> 39031 */
    0xC7EB, 0x8BF7,    /* '请' -> 35831 */
    0xC7EC, 0x5E86,    /* '庆' -> 24198 */
    0xC7ED, 0x743C,    /* '琼' -> 29756 */
    0xC7EE, 0x7A77,    /* '穷' -> 31351 */
    0xC7EF, 0x79CB,    /* '秋' -> 31179 */
    0xC7F0, 0x4E18,    /* '丘' -> 19992 */
    0xC7F1, 0x90B1,    /* '邱' -> 37041 */
    0xC7F2, 0x7403,    /* '球' -> 29699 */
    0xC7F3, 0x6C42,    /* '求' -> 27714 */
    0xC7F4, 0x56DA,    /* '囚' -> 22234 */
    0xC7F5, 0x914B,    /* '酋' -> 37195 */
    0xC7F6, 0x6CC5,    /* '泅' -> 27845 */
    0xC7F7, 0x8D8B,    /* '趋' -> 36235 */
    0xC7F8, 0x533A,    /* '区' -> 21306 */
    0xC7F9, 0x86C6,    /* '蛆' -> 34502 */
    0xC7FA, 0x66F2,    /* '曲' -> 26354 */
    0xC7FB, 0x8EAF,    /* '躯' -> 36527 */
    0xC7FC, 0x5C48,    /* '屈' -> 23624 */
    0xC7FD, 0x9A71,    /* '驱' -> 39537 */
    0xC7FE, 0x6E20,    /* '渠' -> 28192 */
    0xC8A1, 0x53D6,    /* '取' -> 21462 */
    0xC8A2, 0x5A36,    /* '娶' -> 23094 */
    0xC8A3, 0x9F8B,    /* '龋' -> 40843 */
    0xC8A4, 0x8DA3,    /* '趣' -> 36259 */
    0xC8A5, 0x53BB,    /* '去' -> 21435 */
    0xC8A6, 0x5708,    /* '圈' -> 22280 */
    0xC8A7, 0x98A7,    /* '颧' -> 39079 */
    0xC8A8, 0x6743,    /* '权' -> 26435 */
    0xC8A9, 0x919B,    /* '醛' -> 37275 */
    0xC8AA, 0x6CC9,    /* '泉' -> 27849 */
    0xC8AB, 0x5168,    /* '全' -> 20840 */
    0xC8AC, 0x75CA,    /* '痊' -> 30154 */
    0xC8AD, 0x62F3,    /* '拳' -> 25331 */
    0xC8AE, 0x72AC,    /* '犬' -> 29356 */
    0xC8AF, 0x5238,    /* '券' -> 21048 */
    0xC8B0, 0x529D,    /* '劝' -> 21149 */
    0xC8B1, 0x7F3A,    /* '缺' -> 32570 */
    0xC8B2, 0x7094,    /* '炔' -> 28820 */
    0xC8B3, 0x7638,    /* '瘸' -> 30264 */
    0xC8B4, 0x5374,    /* '却' -> 21364 */
    0xC8B5, 0x9E4A,    /* '鹊' -> 40522 */
    0xC8B6, 0x69B7,    /* '榷' -> 27063 */
    0xC8B7, 0x786E,    /* '确' -> 30830 */
    0xC8B8, 0x96C0,    /* '雀' -> 38592 */
    0xC8B9, 0x88D9,    /* '裙' -> 35033 */
    0xC8BA, 0x7FA4,    /* '群' -> 32676 */
    0xC8BB, 0x7136,    /* '然' -> 28982 */
    0xC8BC, 0x71C3,    /* '燃' -> 29123 */
    0xC8BD, 0x5189,    /* '冉' -> 20873 */
    0xC8BE, 0x67D3,    /* '染' -> 26579 */
    0xC8BF, 0x74E4,    /* '瓤' -> 29924 */
    0xC8C0, 0x58E4,    /* '壤' -> 22756 */
    0xC8C1, 0x6518,    /* '攘' -> 25880 */
    0xC8C2, 0x56B7,    /* '嚷' -> 22199 */
    0xC8C3, 0x8BA9,    /* '让' -> 35753 */
    0xC8C4, 0x9976,    /* '饶' -> 39286 */
    0xC8C5, 0x6270,    /* '扰' -> 25200 */
    0xC8C6, 0x7ED5,    /* '绕' -> 32469 */
    0xC8C7, 0x60F9,    /* '惹' -> 24825 */
    0xC8C8, 0x70ED,    /* '热' -> 28909 */
    0xC8C9, 0x58EC,    /* '壬' -> 22764 */
    0xC8CA, 0x4EC1,    /* '仁' -> 20161 */
    0xC8CB, 0x4EBA,    /* '人' -> 20154 */
    0xC8CC, 0x5FCD,    /* '忍' -> 24525 */
    0xC8CD, 0x97E7,    /* '韧' -> 38887 */
    0xC8CE, 0x4EFB,    /* '任' -> 20219 */
    0xC8CF, 0x8BA4,    /* '认' -> 35748 */
    0xC8D0, 0x5203,    /* '刃' -> 20995 */
    0xC8D1, 0x598A,    /* '妊' -> 22922 */
    0xC8D2, 0x7EAB,    /* '纫' -> 32427 */
    0xC8D3, 0x6254,    /* '扔' -> 25172 */
    0xC8D4, 0x4ECD,    /* '仍' -> 20173 */
    0xC8D5, 0x65E5,    /* '日' -> 26085 */
    0xC8D6, 0x620E,    /* '戎' -> 25102 */
    0xC8D7, 0x8338,    /* '茸' -> 33592 */
    0xC8D8, 0x84C9,    /* '蓉' -> 33993 */
    0xC8D9, 0x8363,    /* '荣' -> 33635 */
    0xC8DA, 0x878D,    /* '融' -> 34701 */
    0xC8DB, 0x7194,    /* '熔' -> 29076 */
    0xC8DC, 0x6EB6,    /* '溶' -> 28342 */
    0xC8DD, 0x5BB9,    /* '容' -> 23481 */
    0xC8DE, 0x7ED2,    /* '绒' -> 32466 */
    0xC8DF, 0x5197,    /* '冗' -> 20887 */
    0xC8E0, 0x63C9,    /* '揉' -> 25545 */
    0xC8E1, 0x67D4,    /* '柔' -> 26580 */
    0xC8E2, 0x8089,    /* '肉' -> 32905 */
    0xC8E3, 0x8339,    /* '茹' -> 33593 */
    0xC8E4, 0x8815,    /* '蠕' -> 34837 */
    0xC8E5, 0x5112,    /* '儒' -> 20754 */
    0xC8E6, 0x5B7A,    /* '孺' -> 23418 */
    0xC8E7, 0x5982,    /* '如' -> 22914 */
    0xC8E8, 0x8FB1,    /* '辱' -> 36785 */
    0xC8E9, 0x4E73,    /* '乳' -> 20083 */
    0xC8EA, 0x6C5D,    /* '汝' -> 27741 */
    0xC8EB, 0x5165,    /* '入' -> 20837 */
    0xC8EC, 0x8925,    /* '褥' -> 35109 */
    0xC8ED, 0x8F6F,    /* '软' -> 36719 */
    0xC8EE, 0x962E,    /* '阮' -> 38446 */
    0xC8EF, 0x854A,    /* '蕊' -> 34122 */
    0xC8F0, 0x745E,    /* '瑞' -> 29790 */
    0xC8F1, 0x9510,    /* '锐' -> 38160 */
    0xC8F2, 0x95F0,    /* '闰' -> 38384 */
    0xC8F3, 0x6DA6,    /* '润' -> 28070 */
    0xC8F4, 0x82E5,    /* '若' -> 33509 */
    0xC8F5, 0x5F31,    /* '弱' -> 24369 */
    0xC8F6, 0x6492,    /* '撒' -> 25746 */
    0xC8F7, 0x6D12,    /* '洒' -> 27922 */
    0xC8F8, 0x8428,    /* '萨' -> 33832 */
    0xC8F9, 0x816E,    /* '腮' -> 33134 */
    0xC8FA, 0x9CC3,    /* '鳃' -> 40131 */
    0xC8FB, 0x585E,    /* '塞' -> 22622 */
    0xC8FC, 0x8D5B,    /* '赛' -> 36187 */
    0xC8FD, 0x4E09,    /* '三' -> 19977 */
    0xC8FE, 0x53C1,    /* '叁' -> 21441 */
    0xC9A1, 0x4F1E,    /* '伞' -> 20254 */
    0xC9A2, 0x6563,    /* '散' -> 25955 */
    0xC9A3, 0x6851,    /* '桑' -> 26705 */
    0xC9A4, 0x55D3,    /* '嗓' -> 21971 */
    0xC9A5, 0x4E27,    /* '丧' -> 20007 */
    0xC9A6, 0x6414,    /* '搔' -> 25620 */
    0xC9A7, 0x9A9A,    /* '骚' -> 39578 */
    0xC9A8, 0x626B,    /* '扫' -> 25195 */
    0xC9A9, 0x5AC2,    /* '嫂' -> 23234 */
    0xC9AA, 0x745F,    /* '瑟' -> 29791 */
    0xC9AB, 0x8272,    /* '色' -> 33394 */
    0xC9AC, 0x6DA9,    /* '涩' -> 28073 */
    0xC9AD, 0x68EE,    /* '森' -> 26862 */
    0xC9AE, 0x50E7,    /* '僧' -> 20711 */
    0xC9AF, 0x838E,    /* '莎' -> 33678 */
    0xC9B0, 0x7802,    /* '砂' -> 30722 */
    0xC9B1, 0x6740,    /* '杀' -> 26432 */
    0xC9B2, 0x5239,    /* '刹' -> 21049 */
    0xC9B3, 0x6C99,    /* '沙' -> 27801 */
    0xC9B4, 0x7EB1,    /* '纱' -> 32433 */
    0xC9B5, 0x50BB,    /* '傻' -> 20667 */
    0xC9B6, 0x5565,    /* '啥' -> 21861 */
    0xC9B7, 0x715E,    /* '煞' -> 29022 */
    0xC9B8, 0x7B5B,    /* '筛' -> 31579 */
    0xC9B9, 0x6652,    /* '晒' -> 26194 */
    0xC9BA, 0x73CA,    /* '珊' -> 29642 */
    0xC9BB, 0x82EB,    /* '苫' -> 33515 */
    0xC9BC, 0x6749,    /* '杉' -> 26441 */
    0xC9BD, 0x5C71,    /* '山' -> 23665 */
    0xC9BE, 0x5220,    /* '删' -> 21024 */
    0xC9BF, 0x717D,    /* '煽' -> 29053 */
    0xC9C0, 0x886B,    /* '衫' -> 34923 */
    0xC9C1, 0x95EA,    /* '闪' -> 38378 */
    0xC9C2, 0x9655,    /* '陕' -> 38485 */
    0xC9C3, 0x64C5,    /* '擅' -> 25797 */
    0xC9C4, 0x8D61,    /* '赡' -> 36193 */
    0xC9C5, 0x81B3,    /* '膳' -> 33203 */
    0xC9C6, 0x5584,    /* '善' -> 21892 */
    0xC9C7, 0x6C55,    /* '汕' -> 27733 */
    0xC9C8, 0x6247,    /* '扇' -> 25159 */
    0xC9C9, 0x7F2E,    /* '缮' -> 32558 */
    0xC9CA, 0x5892,    /* '墒' -> 22674 */
    0xC9CB, 0x4F24,    /* '伤' -> 20260 */
    0xC9CC, 0x5546,    /* '商' -> 21830 */
    0xC9CD, 0x8D4F,    /* '赏' -> 36175 */
    0xC9CE, 0x664C,    /* '晌' -> 26188 */
    0xC9CF, 0x4E0A,    /* '上' -> 19978 */
    0xC9D0, 0x5C1A,    /* '尚' -> 23578 */
    0xC9D1, 0x88F3,    /* '裳' -> 35059 */
    0xC9D2, 0x68A2,    /* '梢' -> 26786 */
    0xC9D3, 0x634E,    /* '捎' -> 25422 */
    0xC9D4, 0x7A0D,    /* '稍' -> 31245 */
    0xC9D5, 0x70E7,    /* '烧' -> 28903 */
    0xC9D6, 0x828D,    /* '芍' -> 33421 */
    0xC9D7, 0x52FA,    /* '勺' -> 21242 */
    0xC9D8, 0x97F6,    /* '韶' -> 38902 */
    0xC9D9, 0x5C11,    /* '少' -> 23569 */
    0xC9DA, 0x54E8,    /* '哨' -> 21736 */
    0xC9DB, 0x90B5,    /* '邵' -> 37045 */
    0xC9DC, 0x7ECD,    /* '绍' -> 32461 */
    0xC9DD, 0x5962,    /* '奢' -> 22882 */
    0xC9DE, 0x8D4A,    /* '赊' -> 36170 */
    0xC9DF, 0x86C7,    /* '蛇' -> 34503 */
    0xC9E0, 0x820C,    /* '舌' -> 33292 */
    0xC9E1, 0x820D,    /* '舍' -> 33293 */
    0xC9E2, 0x8D66,    /* '赦' -> 36198 */
    0xC9E3, 0x6444,    /* '摄' -> 25668 */
    0xC9E4, 0x5C04,    /* '射' -> 23556 */
    0xC9E5, 0x6151,    /* '慑' -> 24913 */
    0xC9E6, 0x6D89,    /* '涉' -> 28041 */
    0xC9E7, 0x793E,    /* '社' -> 31038 */
    0xC9E8, 0x8BBE,    /* '设' -> 35774 */
    0xC9E9, 0x7837,    /* '砷' -> 30775 */
    0xC9EA, 0x7533,    /* '申' -> 30003 */
    0xC9EB, 0x547B,    /* '呻' -> 21627 */
    0xC9EC, 0x4F38,    /* '伸' -> 20280 */
    0xC9ED, 0x8EAB,    /* '身' -> 36523 */
    0xC9EE, 0x6DF1,    /* '深' -> 28145 */
    0xC9EF, 0x5A20,    /* '娠' -> 23072 */
    0xC9F0, 0x7EC5,    /* '绅' -> 32453 */
    0xC9F1, 0x795E,    /* '神' -> 31070 */
    0xC9F2, 0x6C88,    /* '沈' -> 27784 */
    0xC9F3, 0x5BA1,    /* '审' -> 23457 */
    0xC9F4, 0x5A76,    /* '婶' -> 23158 */
    0xC9F5, 0x751A,    /* '甚' -> 29978 */
    0xC9F6, 0x80BE,    /* '肾' -> 32958 */
    0xC9F7, 0x614E,    /* '慎' -> 24910 */
    0xC9F8, 0x6E17,    /* '渗' -> 28183 */
    0xC9F9, 0x58F0,    /* '声' -> 22768 */
    0xC9FA, 0x751F,    /* '生' -> 29983 */
    0xC9FB, 0x7525,    /* '甥' -> 29989 */
    0xC9FC, 0x7272,    /* '牲' -> 29298 */
    0xC9FD, 0x5347,    /* '升' -> 21319 */
    0xC9FE, 0x7EF3,    /* '绳' -> 32499 */
    0xCAA1, 0x7701,    /* '省' -> 30465 */
    0xCAA2, 0x76DB,    /* '盛' -> 30427 */
    0xCAA3, 0x5269,    /* '剩' -> 21097 */
    0xCAA4, 0x80DC,    /* '胜' -> 32988 */
    0xCAA5, 0x5723,    /* '圣' -> 22307 */
    0xCAA6, 0x5E08,    /* '师' -> 24072 */
    0xCAA7, 0x5931,    /* '失' -> 22833 */
    0xCAA8, 0x72EE,    /* '狮' -> 29422 */
    0xCAA9, 0x65BD,    /* '施' -> 26045 */
    0xCAAA, 0x6E7F,    /* '湿' -> 28287 */
    0xCAAB, 0x8BD7,    /* '诗' -> 35799 */
    0xCAAC, 0x5C38,    /* '尸' -> 23608 */
    0xCAAD, 0x8671,    /* '虱' -> 34417 */
    0xCAAE, 0x5341,    /* '十' -> 21313 */
    0xCAAF, 0x77F3,    /* '石' -> 30707 */
    0xCAB0, 0x62FE,    /* '拾' -> 25342 */
    0xCAB1, 0x65F6,    /* '时' -> 26102 */
    0xCAB2, 0x4EC0,    /* '什' -> 20160 */
    0xCAB3, 0x98DF,    /* '食' -> 39135 */
    0xCAB4, 0x8680,    /* '蚀' -> 34432 */
    0xCAB5, 0x5B9E,    /* '实' -> 23454 */
    0xCAB6, 0x8BC6,    /* '识' -> 35782 */
    0xCAB7, 0x53F2,    /* '史' -> 21490 */
    0xCAB8, 0x77E2,    /* '矢' -> 30690 */
    0xCAB9, 0x4F7F,    /* '使' -> 20351 */
    0xCABA, 0x5C4E,    /* '屎' -> 23630 */
    0xCABB, 0x9A76,    /* '驶' -> 39542 */
    0xCABC, 0x59CB,    /* '始' -> 22987 */
    0xCABD, 0x5F0F,    /* '式' -> 24335 */
    0xCABE, 0x793A,    /* '示' -> 31034 */
    0xCABF, 0x58EB,    /* '士' -> 22763 */
    0xCAC0, 0x4E16,    /* '世' -> 19990 */
    0xCAC1, 0x67FF,    /* '柿' -> 26623 */
    0xCAC2, 0x4E8B,    /* '事' -> 20107 */
    0xCAC3, 0x62ED,    /* '拭' -> 25325 */
    0xCAC4, 0x8A93,    /* '誓' -> 35475 */
    0xCAC5, 0x901D,    /* '逝' -> 36893 */
    0xCAC6, 0x52BF,    /* '势' -> 21183 */
    0xCAC7, 0x662F,    /* '是' -> 26159 */
    0xCAC8, 0x55DC,    /* '嗜' -> 21980 */
    0xCAC9, 0x566C,    /* '噬' -> 22124 */
    0xCACA, 0x9002,    /* '适' -> 36866 */
    0xCACB, 0x4ED5,    /* '仕' -> 20181 */
    0xCACC, 0x4F8D,    /* '侍' -> 20365 */
    0xCACD, 0x91CA,    /* '释' -> 37322 */
    0xCACE, 0x9970,    /* '饰' -> 39280 */
    0xCACF, 0x6C0F,    /* '氏' -> 27663 */
    0xCAD0, 0x5E02,    /* '市' -> 24066 */
    0xCAD1, 0x6043,    /* '恃' -> 24643 */
    0xCAD2, 0x5BA4,    /* '室' -> 23460 */
    0xCAD3, 0x89C6,    /* '视' -> 35270 */
    0xCAD4, 0x8BD5,    /* '试' -> 35797 */
    0xCAD5, 0x6536,    /* '收' -> 25910 */
    0xCAD6, 0x624B,    /* '手' -> 25163 */
    0xCAD7, 0x9996,    /* '首' -> 39318 */
    0xCAD8, 0x5B88,    /* '守' -> 23432 */
    0xCAD9, 0x5BFF,    /* '寿' -> 23551 */
    0xCADA, 0x6388,    /* '授' -> 25480 */
    0xCADB, 0x552E,    /* '售' -> 21806 */
    0xCADC, 0x53D7,    /* '受' -> 21463 */
    0xCADD, 0x7626,    /* '瘦' -> 30246 */
    0xCADE, 0x517D,    /* '兽' -> 20861 */
    0xCADF, 0x852C,    /* '蔬' -> 34092 */
    0xCAE0, 0x67A2,    /* '枢' -> 26530 */
    0xCAE1, 0x68B3,    /* '梳' -> 26803 */
    0xCAE2, 0x6B8A,    /* '殊' -> 27530 */
    0xCAE3, 0x6292,    /* '抒' -> 25234 */
    0xCAE4, 0x8F93,    /* '输' -> 36755 */
    0xCAE5, 0x53D4,    /* '叔' -> 21460 */
    0xCAE6, 0x8212,    /* '舒' -> 33298 */
    0xCAE7, 0x6DD1,    /* '淑' -> 28113 */
    0xCAE8, 0x758F,    /* '疏' -> 30095 */
    0xCAE9, 0x4E66,    /* '书' -> 20070 */
    0xCAEA, 0x8D4E,    /* '赎' -> 36174 */
    0xCAEB, 0x5B70,    /* '孰' -> 23408 */
    0xCAEC, 0x719F,    /* '熟' -> 29087 */
    0xCAED, 0x85AF,    /* '薯' -> 34223 */
    0xCAEE, 0x6691,    /* '暑' -> 26257 */
    0xCAEF, 0x66D9,    /* '曙' -> 26329 */
    0xCAF0, 0x7F72,    /* '署' -> 32626 */
    0xCAF1, 0x8700,    /* '蜀' -> 34560 */
    0xCAF2, 0x9ECD,    /* '黍' -> 40653 */
    0xCAF3, 0x9F20,    /* '鼠' -> 40736 */
    0xCAF4, 0x5C5E,    /* '属' -> 23646 */
    0xCAF5, 0x672F,    /* '术' -> 26415 */
    0xCAF6, 0x8FF0,    /* '述' -> 36848 */
    0xCAF7, 0x6811,    /* '树' -> 26641 */
    0xCAF8, 0x675F,    /* '束' -> 26463 */
    0xCAF9, 0x620D,    /* '戍' -> 25101 */
    0xCAFA, 0x7AD6,    /* '竖' -> 31446 */
    0xCAFB, 0x5885,    /* '墅' -> 22661 */
    0xCAFC, 0x5EB6,    /* '庶' -> 24246 */
    0xCAFD, 0x6570,    /* '数' -> 25968 */
    0xCAFE, 0x6F31,    /* '漱' -> 28465 */
    0xCBA1, 0x6055,    /* '恕' -> 24661 */
    0xCBA2, 0x5237,    /* '刷' -> 21047 */
    0xCBA3, 0x800D,    /* '耍' -> 32781 */
    0xCBA4, 0x6454,    /* '摔' -> 25684 */
    0xCBA5, 0x8870,    /* '衰' -> 34928 */
    0xCBA6, 0x7529,    /* '甩' -> 29993 */
    0xCBA7, 0x5E05,    /* '帅' -> 24069 */
    0xCBA8, 0x6813,    /* '栓' -> 26643 */
    0xCBA9, 0x62F4,    /* '拴' -> 25332 */
    0xCBAA, 0x971C,    /* '霜' -> 38684 */
    0xCBAB, 0x53CC,    /* '双' -> 21452 */
    0xCBAC, 0x723D,    /* '爽' -> 29245 */
    0xCBAD, 0x8C01,    /* '谁' -> 35841 */
    0xCBAE, 0x6C34,    /* '水' -> 27700 */
    0xCBAF, 0x7761,    /* '睡' -> 30561 */
    0xCBB0, 0x7A0E,    /* '税' -> 31246 */
    0xCBB1, 0x542E,    /* '吮' -> 21550 */
    0xCBB2, 0x77AC,    /* '瞬' -> 30636 */
    0xCBB3, 0x987A,    /* '顺' -> 39034 */
    0xCBB4, 0x821C,    /* '舜' -> 33308 */
    0xCBB5, 0x8BF4,    /* '说' -> 35828 */
    0xCBB6, 0x7855,    /* '硕' -> 30805 */
    0xCBB7, 0x6714,    /* '朔' -> 26388 */
    0xCBB8, 0x70C1,    /* '烁' -> 28865 */
    0xCBB9, 0x65AF,    /* '斯' -> 26031 */
    0xCBBA, 0x6495,    /* '撕' -> 25749 */
    0xCBBB, 0x5636,    /* '嘶' -> 22070 */
    0xCBBC, 0x601D,    /* '思' -> 24605 */
    0xCBBD, 0x79C1,    /* '私' -> 31169 */
    0xCBBE, 0x53F8,    /* '司' -> 21496 */
    0xCBBF, 0x4E1D,    /* '丝' -> 19997 */
    0xCBC0, 0x6B7B,    /* '死' -> 27515 */
    0xCBC1, 0x8086,    /* '肆' -> 32902 */
    0xCBC2, 0x5BFA,    /* '寺' -> 23546 */
    0xCBC3, 0x55E3,    /* '嗣' -> 21987 */
    0xCBC4, 0x56DB,    /* '四' -> 22235 */
    0xCBC5, 0x4F3A,    /* '伺' -> 20282 */
    0xCBC6, 0x4F3C,    /* '似' -> 20284 */
    0xCBC7, 0x9972,    /* '饲' -> 39282 */
    0xCBC8, 0x5DF3,    /* '巳' -> 24051 */
    0xCBC9, 0x677E,    /* '松' -> 26494 */
    0xCBCA, 0x8038,    /* '耸' -> 32824 */
    0xCBCB, 0x6002,    /* '怂' -> 24578 */
    0xCBCC, 0x9882,    /* '颂' -> 39042 */
    0xCBCD, 0x9001,    /* '送' -> 36865 */
    0xCBCE, 0x5B8B,    /* '宋' -> 23435 */
    0xCBCF, 0x8BBC,    /* '讼' -> 35772 */
    0xCBD0, 0x8BF5,    /* '诵' -> 35829 */
    0xCBD1, 0x641C,    /* '搜' -> 25628 */
    0xCBD2, 0x8258,    /* '艘' -> 33368 */
    0xCBD3, 0x64DE,    /* '擞' -> 25822 */
    0xCBD4, 0x55FD,    /* '嗽' -> 22013 */
    0xCBD5, 0x82CF,    /* '苏' -> 33487 */
    0xCBD6, 0x9165,    /* '酥' -> 37221 */
    0xCBD7, 0x4FD7,    /* '俗' -> 20439 */
    0xCBD8, 0x7D20,    /* '素' -> 32032 */
    0xCBD9, 0x901F,    /* '速' -> 36895 */
    0xCBDA, 0x7C9F,    /* '粟' -> 31903 */
    0xCBDB, 0x50F3,    /* '僳' -> 20723 */
    0xCBDC, 0x5851,    /* '塑' -> 22609 */
    0xCBDD, 0x6EAF,    /* '溯' -> 28335 */
    0xCBDE, 0x5BBF,    /* '宿' -> 23487 */
    0xCBDF, 0x8BC9,    /* '诉' -> 35785 */
    0xCBE0, 0x8083,    /* '肃' -> 32899 */
    0xCBE1, 0x9178,    /* '酸' -> 37240 */
    0xCBE2, 0x849C,    /* '蒜' -> 33948 */
    0xCBE3, 0x7B97,    /* '算' -> 31639 */
    0xCBE4, 0x867D,    /* '虽' -> 34429 */
    0xCBE5, 0x968B,    /* '隋' -> 38539 */
    0xCBE6, 0x968F,    /* '随' -> 38543 */
    0xCBE7, 0x7EE5,    /* '绥' -> 32485 */
    0xCBE8, 0x9AD3,    /* '髓' -> 39635 */
    0xCBE9, 0x788E,    /* '碎' -> 30862 */
    0xCBEA, 0x5C81,    /* '岁' -> 23681 */
    0xCBEB, 0x7A57,    /* '穗' -> 31319 */
    0xCBEC, 0x9042,    /* '遂' -> 36930 */
    0xCBED, 0x96A7,    /* '隧' -> 38567 */
    0xCBEE, 0x795F,    /* '祟' -> 31071 */
    0xCBEF, 0x5B59,    /* '孙' -> 23385 */
    0xCBF0, 0x635F,    /* '损' -> 25439 */
    0xCBF1, 0x7B0B,    /* '笋' -> 31499 */
    0xCBF2, 0x84D1,    /* '蓑' -> 34001 */
    0xCBF3, 0x68AD,    /* '梭' -> 26797 */
    0xCBF4, 0x5506,    /* '唆' -> 21766 */
    0xCBF5, 0x7F29,    /* '缩' -> 32553 */
    0xCBF6, 0x7410,    /* '琐' -> 29712 */
    0xCBF7, 0x7D22,    /* '索' -> 32034 */
    0xCBF8, 0x9501,    /* '锁' -> 38145 */
    0xCBF9, 0x6240,    /* '所' -> 25152 */
    0xCBFA, 0x584C,    /* '塌' -> 22604 */
    0xCBFB, 0x4ED6,    /* '他' -> 20182 */
    0xCBFC, 0x5B83,    /* '它' -> 23427 */
    0xCBFD, 0x5979,    /* '她' -> 22905 */
    0xCBFE, 0x5854,    /* '塔' -> 22612 */
    0xCCA1, 0x736D,    /* '獭' -> 29549 */
    0xCCA2, 0x631E,    /* '挞' -> 25374 */
    0xCCA3, 0x8E4B,    /* '蹋' -> 36427 */
    0xCCA4, 0x8E0F,    /* '踏' -> 36367 */
    0xCCA5, 0x80CE,    /* '胎' -> 32974 */
    0xCCA6, 0x82D4,    /* '苔' -> 33492 */
    0xCCA7, 0x62AC,    /* '抬' -> 25260 */
    0xCCA8, 0x53F0,    /* '台' -> 21488 */
    0xCCA9, 0x6CF0,    /* '泰' -> 27888 */
    0xCCAA, 0x915E,    /* '酞' -> 37214 */
    0xCCAB, 0x592A,    /* '太' -> 22826 */
    0xCCAC, 0x6001,    /* '态' -> 24577 */
    0xCCAD, 0x6C70,    /* '汰' -> 27760 */
    0xCCAE, 0x574D,    /* '坍' -> 22349 */
    0xCCAF, 0x644A,    /* '摊' -> 25674 */
    0xCCB0, 0x8D2A,    /* '贪' -> 36138 */
    0xCCB1, 0x762B,    /* '瘫' -> 30251 */
    0xCCB2, 0x6EE9,    /* '滩' -> 28393 */
    0xCCB3, 0x575B,    /* '坛' -> 22363 */
    0xCCB4, 0x6A80,    /* '檀' -> 27264 */
    0xCCB5, 0x75F0,    /* '痰' -> 30192 */
    0xCCB6, 0x6F6D,    /* '潭' -> 28525 */
    0xCCB7, 0x8C2D,    /* '谭' -> 35885 */
    0xCCB8, 0x8C08,    /* '谈' -> 35848 */
    0xCCB9, 0x5766,    /* '坦' -> 22374 */
    0xCCBA, 0x6BEF,    /* '毯' -> 27631 */
    0xCCBB, 0x8892,    /* '袒' -> 34962 */
    0xCCBC, 0x78B3,    /* '碳' -> 30899 */
    0xCCBD, 0x63A2,    /* '探' -> 25506 */
    0xCCBE, 0x53F9,    /* '叹' -> 21497 */
    0xCCBF, 0x70AD,    /* '炭' -> 28845 */
    0xCCC0, 0x6C64,    /* '汤' -> 27748 */
    0xCCC1, 0x5858,    /* '塘' -> 22616 */
    0xCCC2, 0x642A,    /* '搪' -> 25642 */
    0xCCC3, 0x5802,    /* '堂' -> 22530 */
    0xCCC4, 0x68E0,    /* '棠' -> 26848 */
    0xCCC5, 0x819B,    /* '膛' -> 33179 */
    0xCCC6, 0x5510,    /* '唐' -> 21776 */
    0xCCC7, 0x7CD6,    /* '糖' -> 31958 */
    0xCCC8, 0x5018,    /* '倘' -> 20504 */
    0xCCC9, 0x8EBA,    /* '躺' -> 36538 */
    0xCCCA, 0x6DCC,    /* '淌' -> 28108 */
    0xCCCB, 0x8D9F,    /* '趟' -> 36255 */
    0xCCCC, 0x70EB,    /* '烫' -> 28907 */
    0xCCCD, 0x638F,    /* '掏' -> 25487 */
    0xCCCE, 0x6D9B,    /* '涛' -> 28059 */
    0xCCCF, 0x6ED4,    /* '滔' -> 28372 */
    0xCCD0, 0x7EE6,    /* '绦' -> 32486 */
    0xCCD1, 0x8404,    /* '萄' -> 33796 */
    0xCCD2, 0x6843,    /* '桃' -> 26691 */
    0xCCD3, 0x9003,    /* '逃' -> 36867 */
    0xCCD4, 0x6DD8,    /* '淘' -> 28120 */
    0xCCD5, 0x9676,    /* '陶' -> 38518 */
    0xCCD6, 0x8BA8,    /* '讨' -> 35752 */
    0xCCD7, 0x5957,    /* '套' -> 22871 */
    0xCCD8, 0x7279,    /* '特' -> 29305 */
    0xCCD9, 0x85E4,    /* '藤' -> 34276 */
    0xCCDA, 0x817E,    /* '腾' -> 33150 */
    0xCCDB, 0x75BC,    /* '疼' -> 30140 */
    0xCCDC, 0x8A8A,    /* '誊' -> 35466 */
    0xCCDD, 0x68AF,    /* '梯' -> 26799 */
    0xCCDE, 0x5254,    /* '剔' -> 21076 */
    0xCCDF, 0x8E22,    /* '踢' -> 36386 */
    0xCCE0, 0x9511,    /* '锑' -> 38161 */
    0xCCE1, 0x63D0,    /* '提' -> 25552 */
    0xCCE2, 0x9898,    /* '题' -> 39064 */
    0xCCE3, 0x8E44,    /* '蹄' -> 36420 */
    0xCCE4, 0x557C,    /* '啼' -> 21884 */
    0xCCE5, 0x4F53,    /* '体' -> 20307 */
    0xCCE6, 0x66FF,    /* '替' -> 26367 */
    0xCCE7, 0x568F,    /* '嚏' -> 22159 */
    0xCCE8, 0x60D5,    /* '惕' -> 24789 */
    0xCCE9, 0x6D95,    /* '涕' -> 28053 */
    0xCCEA, 0x5243,    /* '剃' -> 21059 */
    0xCCEB, 0x5C49,    /* '屉' -> 23625 */
    0xCCEC, 0x5929,    /* '天' -> 22825 */
    0xCCED, 0x6DFB,    /* '添' -> 28155 */
    0xCCEE, 0x586B,    /* '填' -> 22635 */
    0xCCEF, 0x7530,    /* '田' -> 30000 */
    0xCCF0, 0x751C,    /* '甜' -> 29980 */
    0xCCF1, 0x606C,    /* '恬' -> 24684 */
    0xCCF2, 0x8214,    /* '舔' -> 33300 */
    0xCCF3, 0x8146,    /* '腆' -> 33094 */
    0xCCF4, 0x6311,    /* '挑' -> 25361 */
    0xCCF5, 0x6761,    /* '条' -> 26465 */
    0xCCF6, 0x8FE2,    /* '迢' -> 36834 */
    0xCCF7, 0x773A,    /* '眺' -> 30522 */
    0xCCF8, 0x8DF3,    /* '跳' -> 36339 */
    0xCCF9, 0x8D34,    /* '贴' -> 36148 */
    0xCCFA, 0x94C1,    /* '铁' -> 38081 */
    0xCCFB, 0x5E16,    /* '帖' -> 24086 */
    0xCCFC, 0x5385,    /* '厅' -> 21381 */
    0xCCFD, 0x542C,    /* '听' -> 21548 */
    0xCCFE, 0x70C3,    /* '烃' -> 28867 */
    0xCDA1, 0x6C40,    /* '汀' -> 27712 */
    0xCDA2, 0x5EF7,    /* '廷' -> 24311 */
    0xCDA3, 0x505C,    /* '停' -> 20572 */
    0xCDA4, 0x4EAD,    /* '亭' -> 20141 */
    0xCDA5, 0x5EAD,    /* '庭' -> 24237 */
    0xCDA6, 0x633A,    /* '挺' -> 25402 */
    0xCDA7, 0x8247,    /* '艇' -> 33351 */
    0xCDA8, 0x901A,    /* '通' -> 36890 */
    0xCDA9, 0x6850,    /* '桐' -> 26704 */
    0xCDAA, 0x916E,    /* '酮' -> 37230 */
    0xCDAB, 0x77B3,    /* '瞳' -> 30643 */
    0xCDAC, 0x540C,    /* '同' -> 21516 */
    0xCDAD, 0x94DC,    /* '铜' -> 38108 */
    0xCDAE, 0x5F64,    /* '彤' -> 24420 */
    0xCDAF, 0x7AE5,    /* '童' -> 31461 */
    0xCDB0, 0x6876,    /* '桶' -> 26742 */
    0xCDB1, 0x6345,    /* '捅' -> 25413 */
    0xCDB2, 0x7B52,    /* '筒' -> 31570 */
    0xCDB3, 0x7EDF,    /* '统' -> 32479 */
    0xCDB4, 0x75DB,    /* '痛' -> 30171 */
    0xCDB5, 0x5077,    /* '偷' -> 20599 */
    0xCDB6, 0x6295,    /* '投' -> 25237 */
    0xCDB7, 0x5934,    /* '头' -> 22836 */
    0xCDB8, 0x900F,    /* '透' -> 36879 */
    0xCDB9, 0x51F8,    /* '凸' -> 20984 */
    0xCDBA, 0x79C3,    /* '秃' -> 31171 */
    0xCDBB, 0x7A81,    /* '突' -> 31361 */
    0xCDBC, 0x56FE,    /* '图' -> 22270 */
    0xCDBD, 0x5F92,    /* '徒' -> 24466 */
    0xCDBE, 0x9014,    /* '途' -> 36884 */
    0xCDBF, 0x6D82,    /* '涂' -> 28034 */
    0xCDC0, 0x5C60,    /* '屠' -> 23648 */
    0xCDC1, 0x571F,    /* '土' -> 22303 */
    0xCDC2, 0x5410,    /* '吐' -> 21520 */
    0xCDC3, 0x5154,    /* '兔' -> 20820 */
    0xCDC4, 0x6E4D,    /* '湍' -> 28237 */
    0xCDC5, 0x56E2,    /* '团' -> 22242 */
    0xCDC6, 0x63A8,    /* '推' -> 25512 */
    0xCDC7, 0x9893,    /* '颓' -> 39059 */
    0xCDC8, 0x817F,    /* '腿' -> 33151 */
    0xCDC9, 0x8715,    /* '蜕' -> 34581 */
    0xCDCA, 0x892A,    /* '褪' -> 35114 */
    0xCDCB, 0x9000,    /* '退' -> 36864 */
    0xCDCC, 0x541E,    /* '吞' -> 21534 */
    0xCDCD, 0x5C6F,    /* '屯' -> 23663 */
    0xCDCE, 0x81C0,    /* '臀' -> 33216 */
    0xCDCF, 0x62D6,    /* '拖' -> 25302 */
    0xCDD0, 0x6258,    /* '托' -> 25176 */
    0xCDD1, 0x8131,    /* '脱' -> 33073 */
    0xCDD2, 0x9E35,    /* '鸵' -> 40501 */
    0xCDD3, 0x9640,    /* '陀' -> 38464 */
    0xCDD4, 0x9A6E,    /* '驮' -> 39534 */
    0xCDD5, 0x9A7C,    /* '驼' -> 39548 */
    0xCDD6, 0x692D,    /* '椭' -> 26925 */
    0xCDD7, 0x59A5,    /* '妥' -> 22949 */
    0xCDD8, 0x62D3,    /* '拓' -> 25299 */
    0xCDD9, 0x553E,    /* '唾' -> 21822 */
    0xCDDA, 0x6316,    /* '挖' -> 25366 */
    0xCDDB, 0x54C7,    /* '哇' -> 21703 */
    0xCDDC, 0x86D9,    /* '蛙' -> 34521 */
    0xCDDD, 0x6D3C,    /* '洼' -> 27964 */
    0xCDDE, 0x5A03,    /* '娃' -> 23043 */
    0xCDDF, 0x74E6,    /* '瓦' -> 29926 */
    0xCDE0, 0x889C,    /* '袜' -> 34972 */
    0xCDE1, 0x6B6A,    /* '歪' -> 27498 */
    0xCDE2, 0x5916,    /* '外' -> 22806 */
    0xCDE3, 0x8C4C,    /* '豌' -> 35916 */
    0xCDE4, 0x5F2F,    /* '弯' -> 24367 */
    0xCDE5, 0x6E7E,    /* '湾' -> 28286 */
    0xCDE6, 0x73A9,    /* '玩' -> 29609 */
    0xCDE7, 0x987D,    /* '顽' -> 39037 */
    0xCDE8, 0x4E38,    /* '丸' -> 20024 */
    0xCDE9, 0x70F7,    /* '烷' -> 28919 */
    0xCDEA, 0x5B8C,    /* '完' -> 23436 */
    0xCDEB, 0x7897,    /* '碗' -> 30871 */
    0xCDEC, 0x633D,    /* '挽' -> 25405 */
    0xCDED, 0x665A,    /* '晚' -> 26202 */
    0xCDEE, 0x7696,    /* '皖' -> 30358 */
    0xCDEF, 0x60CB,    /* '惋' -> 24779 */
    0xCDF0, 0x5B9B,    /* '宛' -> 23451 */
    0xCDF1, 0x5A49,    /* '婉' -> 23113 */
    0xCDF2, 0x4E07,    /* '万' -> 19975 */
    0xCDF3, 0x8155,    /* '腕' -> 33109 */
    0xCDF4, 0x6C6A,    /* '汪' -> 27754 */
    0xCDF5, 0x738B,    /* '王' -> 29579 */
    0xCDF6, 0x4EA1,    /* '亡' -> 20129 */
    0xCDF7, 0x6789,    /* '枉' -> 26505 */
    0xCDF8, 0x7F51,    /* '网' -> 32593 */
    0xCDF9, 0x5F80,    /* '往' -> 24448 */
    0xCDFA, 0x65FA,    /* '旺' -> 26106 */
    0xCDFB, 0x671B,    /* '望' -> 26395 */
    0xCDFC, 0x5FD8,    /* '忘' -> 24536 */
    0xCDFD, 0x5984,    /* '妄' -> 22916 */
    0xCDFE, 0x5A01,    /* '威' -> 23041 */
    0xCEA1, 0x5DCD,    /* '巍' -> 24013 */
    0xCEA2, 0x5FAE,    /* '微' -> 24494 */
    0xCEA3, 0x5371,    /* '危' -> 21361 */
    0xCEA4, 0x97E6,    /* '韦' -> 38886 */
    0xCEA5, 0x8FDD,    /* '违' -> 36829 */
    0xCEA6, 0x6845,    /* '桅' -> 26693 */
    0xCEA7, 0x56F4,    /* '围' -> 22260 */
    0xCEA8, 0x552F,    /* '唯' -> 21807 */
    0xCEA9, 0x60DF,    /* '惟' -> 24799 */
    0xCEAA, 0x4E3A,    /* '为' -> 20026 */
    0xCEAB, 0x6F4D,    /* '潍' -> 28493 */
    0xCEAC, 0x7EF4,    /* '维' -> 32500 */
    0xCEAD, 0x82C7,    /* '苇' -> 33479 */
    0xCEAE, 0x840E,    /* '萎' -> 33806 */
    0xCEAF, 0x59D4,    /* '委' -> 22996 */
    0xCEB0, 0x4F1F,    /* '伟' -> 20255 */
    0xCEB1, 0x4F2A,    /* '伪' -> 20266 */
    0xCEB2, 0x5C3E,    /* '尾' -> 23614 */
    0xCEB3, 0x7EAC,    /* '纬' -> 32428 */
    0xCEB4, 0x672A,    /* '未' -> 26410 */
    0xCEB5, 0x851A,    /* '蔚' -> 34074 */
    0xCEB6, 0x5473,    /* '味' -> 21619 */
    0xCEB7, 0x754F,    /* '畏' -> 30031 */
    0xCEB8, 0x80C3,    /* '胃' -> 32963 */
    0xCEB9, 0x5582,    /* '喂' -> 21890 */
    0xCEBA, 0x9B4F,    /* '魏' -> 39759 */
    0xCEBB, 0x4F4D,    /* '位' -> 20301 */
    0xCEBC, 0x6E2D,    /* '渭' -> 28205 */
    0xCEBD, 0x8C13,    /* '谓' -> 35859 */
    0xCEBE, 0x5C09,    /* '尉' -> 23561 */
    0xCEBF, 0x6170,    /* '慰' -> 24944 */
    0xCEC0, 0x536B,    /* '卫' -> 21355 */
    0xCEC1, 0x761F,    /* '瘟' -> 30239 */
    0xCEC2, 0x6E29,    /* '温' -> 28201 */
    0xCEC3, 0x868A,    /* '蚊' -> 34442 */
    0xCEC4, 0x6587,    /* '文' -> 25991 */
    0xCEC5, 0x95FB,    /* '闻' -> 38395 */
    0xCEC6, 0x7EB9,    /* '纹' -> 32441 */
    0xCEC7, 0x543B,    /* '吻' -> 21563 */
    0xCEC8, 0x7A33,    /* '稳' -> 31283 */
    0xCEC9, 0x7D0A,    /* '紊' -> 32010 */
    0xCECA, 0x95EE,    /* '问' -> 38382 */
    0xCECB, 0x55E1,    /* '嗡' -> 21985 */
    0xCECC, 0x7FC1,    /* '翁' -> 32705 */
    0xCECD, 0x74EE,    /* '瓮' -> 29934 */
    0xCECE, 0x631D,    /* '挝' -> 25373 */
    0xCECF, 0x8717,    /* '蜗' -> 34583 */
    0xCED0, 0x6DA1,    /* '涡' -> 28065 */
    0xCED1, 0x7A9D,    /* '窝' -> 31389 */
    0xCED2, 0x6211,    /* '我' -> 25105 */
    0xCED3, 0x65A1,    /* '斡' -> 26017 */
    0xCED4, 0x5367,    /* '卧' -> 21351 */
    0xCED5, 0x63E1,    /* '握' -> 25569 */
    0xCED6, 0x6C83,    /* '沃' -> 27779 */
    0xCED7, 0x5DEB,    /* '巫' -> 24043 */
    0xCED8, 0x545C,    /* '呜' -> 21596 */
    0xCED9, 0x94A8,    /* '钨' -> 38056 */
    0xCEDA, 0x4E4C,    /* '乌' -> 20044 */
    0xCEDB, 0x6C61,    /* '污' -> 27745 */
    0xCEDC, 0x8BEC,    /* '诬' -> 35820 */
    0xCEDD, 0x5C4B,    /* '屋' -> 23627 */
    0xCEDE, 0x65E0,    /* '无' -> 26080 */
    0xCEDF, 0x829C,    /* '芜' -> 33436 */
    0xCEE0, 0x68A7,    /* '梧' -> 26791 */
    0xCEE1, 0x543E,    /* '吾' -> 21566 */
    0xCEE2, 0x5434,    /* '吴' -> 21556 */
    0xCEE3, 0x6BCB,    /* '毋' -> 27595 */
    0xCEE4, 0x6B66,    /* '武' -> 27494 */
    0xCEE5, 0x4E94,    /* '五' -> 20116 */
    0xCEE6, 0x6342,    /* '捂' -> 25410 */
    0xCEE7, 0x5348,    /* '午' -> 21320 */
    0xCEE8, 0x821E,    /* '舞' -> 33310 */
    0xCEE9, 0x4F0D,    /* '伍' -> 20237 */
    0xCEEA, 0x4FAE,    /* '侮' -> 20398 */
    0xCEEB, 0x575E,    /* '坞' -> 22366 */
    0xCEEC, 0x620A,    /* '戊' -> 25098 */
    0xCEED, 0x96FE,    /* '雾' -> 38654 */
    0xCEEE, 0x6664,    /* '晤' -> 26212 */
    0xCEEF, 0x7269,    /* '物' -> 29289 */
    0xCEF0, 0x52FF,    /* '勿' -> 21247 */
    0xCEF1, 0x52A1,    /* '务' -> 21153 */
    0xCEF2, 0x609F,    /* '悟' -> 24735 */
    0xCEF3, 0x8BEF,    /* '误' -> 35823 */
    0xCEF4, 0x6614,    /* '昔' -> 26132 */
    0xCEF5, 0x7199,    /* '熙' -> 29081 */
    0xCEF6, 0x6790,    /* '析' -> 26512 */
    0xCEF7, 0x897F,    /* '西' -> 35199 */
    0xCEF8, 0x7852,    /* '硒' -> 30802 */
    0xCEF9, 0x77FD,    /* '矽' -> 30717 */
    0xCEFA, 0x6670,    /* '晰' -> 26224 */
    0xCEFB, 0x563B,    /* '嘻' -> 22075 */
    0xCEFC, 0x5438,    /* '吸' -> 21560 */
    0xCEFD, 0x9521,    /* '锡' -> 38177 */
    0xCEFE, 0x727A,    /* '牺' -> 29306 */
    0xCFA1, 0x7A00,    /* '稀' -> 31232 */
    0xCFA2, 0x606F,    /* '息' -> 24687 */
    0xCFA3, 0x5E0C,    /* '希' -> 24076 */
    0xCFA4, 0x6089,    /* '悉' -> 24713 */
    0xCFA5, 0x819D,    /* '膝' -> 33181 */
    0xCFA6, 0x5915,    /* '夕' -> 22805 */
    0xCFA7, 0x60DC,    /* '惜' -> 24796 */
    0xCFA8, 0x7184,    /* '熄' -> 29060 */
    0xCFA9, 0x70EF,    /* '烯' -> 28911 */
    0xCFAA, 0x6EAA,    /* '溪' -> 28330 */
    0xCFAB, 0x6C50,    /* '汐' -> 27728 */
    0xCFAC, 0x7280,    /* '犀' -> 29312 */
    0xCFAD, 0x6A84,    /* '檄' -> 27268 */
    0xCFAE, 0x88AD,    /* '袭' -> 34989 */
    0xCFAF, 0x5E2D,    /* '席' -> 24109 */
    0xCFB0, 0x4E60,    /* '习' -> 20064 */
    0xCFB1, 0x5AB3,    /* '媳' -> 23219 */
    0xCFB2, 0x559C,    /* '喜' -> 21916 */
    0xCFB3, 0x94E3,    /* '铣' -> 38115 */
    0xCFB4, 0x6D17,    /* '洗' -> 27927 */
    0xCFB5, 0x7CFB,    /* '系' -> 31995 */
    0xCFB6, 0x9699,    /* '隙' -> 38553 */
    0xCFB7, 0x620F,    /* '戏' -> 25103 */
    0xCFB8, 0x7EC6,    /* '细' -> 32454 */
    0xCFB9, 0x778E,    /* '瞎' -> 30606 */
    0xCFBA, 0x867E,    /* '虾' -> 34430 */
    0xCFBB, 0x5323,    /* '匣' -> 21283 */
    0xCFBC, 0x971E,    /* '霞' -> 38686 */
    0xCFBD, 0x8F96,    /* '辖' -> 36758 */
    0xCFBE, 0x6687,    /* '暇' -> 26247 */
    0xCFBF, 0x5CE1,    /* '峡' -> 23777 */
    0xCFC0, 0x4FA0,    /* '侠' -> 20384 */
    0xCFC1, 0x72ED,    /* '狭' -> 29421 */
    0xCFC2, 0x4E0B,    /* '下' -> 19979 */
    0xCFC3, 0x53A6,    /* '厦' -> 21414 */
    0xCFC4, 0x590F,    /* '夏' -> 22799 */
    0xCFC5, 0x5413,    /* '吓' -> 21523 */
    0xCFC6, 0x6380,    /* '掀' -> 25472 */
    0xCFC7, 0x9528,    /* '锨' -> 38184 */
    0xCFC8, 0x5148,    /* '先' -> 20808 */
    0xCFC9, 0x4ED9,    /* '仙' -> 20185 */
    0xCFCA, 0x9C9C,    /* '鲜' -> 40092 */
    0xCFCB, 0x7EA4,    /* '纤' -> 32420 */
    0xCFCC, 0x54B8,    /* '咸' -> 21688 */
    0xCFCD, 0x8D24,    /* '贤' -> 36132 */
    0xCFCE, 0x8854,    /* '衔' -> 34900 */
    0xCFCF, 0x8237,    /* '舷' -> 33335 */
    0xCFD0, 0x95F2,    /* '闲' -> 38386 */
    0xCFD1, 0x6D8E,    /* '涎' -> 28046 */
    0xCFD2, 0x5F26,    /* '弦' -> 24358 */
    0xCFD3, 0x5ACC,    /* '嫌' -> 23244 */
    0xCFD4, 0x663E,    /* '显' -> 26174 */
    0xCFD5, 0x9669,    /* '险' -> 38505 */
    0xCFD6, 0x73B0,    /* '现' -> 29616 */
    0xCFD7, 0x732E,    /* '献' -> 29486 */
    0xCFD8, 0x53BF,    /* '县' -> 21439 */
    0xCFD9, 0x817A,    /* '腺' -> 33146 */
    0xCFDA, 0x9985,    /* '馅' -> 39301 */
    0xCFDB, 0x7FA1,    /* '羡' -> 32673 */
    0xCFDC, 0x5BAA,    /* '宪' -> 23466 */
    0xCFDD, 0x9677,    /* '陷' -> 38519 */
    0xCFDE, 0x9650,    /* '限' -> 38480 */
    0xCFDF, 0x7EBF,    /* '线' -> 32447 */
    0xCFE0, 0x76F8,    /* '相' -> 30456 */
    0xCFE1, 0x53A2,    /* '厢' -> 21410 */
    0xCFE2, 0x9576,    /* '镶' -> 38262 */
    0xCFE3, 0x9999,    /* '香' -> 39321 */
    0xCFE4, 0x7BB1,    /* '箱' -> 31665 */
    0xCFE5, 0x8944,    /* '襄' -> 35140 */
    0xCFE6, 0x6E58,    /* '湘' -> 28248 */
    0xCFE7, 0x4E61,    /* '乡' -> 20065 */
    0xCFE8, 0x7FD4,    /* '翔' -> 32724 */
    0xCFE9, 0x7965,    /* '祥' -> 31077 */
    0xCFEA, 0x8BE6,    /* '详' -> 35814 */
    0xCFEB, 0x60F3,    /* '想' -> 24819 */
    0xCFEC, 0x54CD,    /* '响' -> 21709 */
    0xCFED, 0x4EAB,    /* '享' -> 20139 */
    0xCFEE, 0x9879,    /* '项' -> 39033 */
    0xCFEF, 0x5DF7,    /* '巷' -> 24055 */
    0xCFF0, 0x6A61,    /* '橡' -> 27233 */
    0xCFF1, 0x50CF,    /* '像' -> 20687 */
    0xCFF2, 0x5411,    /* '向' -> 21521 */
    0xCFF3, 0x8C61,    /* '象' -> 35937 */
    0xCFF4, 0x8427,    /* '萧' -> 33831 */
    0xCFF5, 0x785D,    /* '硝' -> 30813 */
    0xCFF6, 0x9704,    /* '霄' -> 38660 */
    0xCFF7, 0x524A,    /* '削' -> 21066 */
    0xCFF8, 0x54EE,    /* '哮' -> 21742 */
    0xCFF9, 0x56A3,    /* '嚣' -> 22179 */
    0xCFFA, 0x9500,    /* '销' -> 38144 */
    0xCFFB, 0x6D88,    /* '消' -> 28040 */
    0xCFFC, 0x5BB5,    /* '宵' -> 23477 */
    0xCFFD, 0x6DC6,    /* '淆' -> 28102 */
    0xCFFE, 0x6653,    /* '晓' -> 26195 */
    0xD0A1, 0x5C0F,    /* '小' -> 23567 */
    0xD0A2, 0x5B5D,    /* '孝' -> 23389 */
    0xD0A3, 0x6821,    /* '校' -> 26657 */
    0xD0A4, 0x8096,    /* '肖' -> 32918 */
    0xD0A5, 0x5578,    /* '啸' -> 21880 */
    0xD0A6, 0x7B11,    /* '笑' -> 31505 */
    0xD0A7, 0x6548,    /* '效' -> 25928 */
    0xD0A8, 0x6954,    /* '楔' -> 26964 */
    0xD0A9, 0x4E9B,    /* '些' -> 20123 */
    0xD0AA, 0x6B47,    /* '歇' -> 27463 */
    0xD0AB, 0x874E,    /* '蝎' -> 34638 */
    0xD0AC, 0x978B,    /* '鞋' -> 38795 */
    0xD0AD, 0x534F,    /* '协' -> 21327 */
    0xD0AE, 0x631F,    /* '挟' -> 25375 */
    0xD0AF, 0x643A,    /* '携' -> 25658 */
    0xD0B0, 0x90AA,    /* '邪' -> 37034 */
    0xD0B1, 0x659C,    /* '斜' -> 26012 */
    0xD0B2, 0x80C1,    /* '胁' -> 32961 */
    0xD0B3, 0x8C10,    /* '谐' -> 35856 */
    0xD0B4, 0x5199,    /* '写' -> 20889 */
    0xD0B5, 0x68B0,    /* '械' -> 26800 */
    0xD0B6, 0x5378,    /* '卸' -> 21368 */
    0xD0B7, 0x87F9,    /* '蟹' -> 34809 */
    0xD0B8, 0x61C8,    /* '懈' -> 25032 */
    0xD0B9, 0x6CC4,    /* '泄' -> 27844 */
    0xD0BA, 0x6CFB,    /* '泻' -> 27899 */
    0xD0BB, 0x8C22,    /* '谢' -> 35874 */
    0xD0BC, 0x5C51,    /* '屑' -> 23633 */
    0xD0BD, 0x85AA,    /* '薪' -> 34218 */
    0xD0BE, 0x82AF,    /* '芯' -> 33455 */
    0xD0BF, 0x950C,    /* '锌' -> 38156 */
    0xD0C0, 0x6B23,    /* '欣' -> 27427 */
    0xD0C1, 0x8F9B,    /* '辛' -> 36763 */
    0xD0C2, 0x65B0,    /* '新' -> 26032 */
    0xD0C3, 0x5FFB,    /* '忻' -> 24571 */
    0xD0C4, 0x5FC3,    /* '心' -> 24515 */
    0xD0C5, 0x4FE1,    /* '信' -> 20449 */
    0xD0C6, 0x8845,    /* '衅' -> 34885 */
    0xD0C7, 0x661F,    /* '星' -> 26143 */
    0xD0C8, 0x8165,    /* '腥' -> 33125 */
    0xD0C9, 0x7329,    /* '猩' -> 29481 */
    0xD0CA, 0x60FA,    /* '惺' -> 24826 */
    0xD0CB, 0x5174,    /* '兴' -> 20852 */
    0xD0CC, 0x5211,    /* '刑' -> 21009 */
    0xD0CD, 0x578B,    /* '型' -> 22411 */
    0xD0CE, 0x5F62,    /* '形' -> 24418 */
    0xD0CF, 0x90A2,    /* '邢' -> 37026 */
    0xD0D0, 0x884C,    /* '行' -> 34892 */
    0xD0D1, 0x9192,    /* '醒' -> 37266 */
    0xD0D2, 0x5E78,    /* '幸' -> 24184 */
    0xD0D3, 0x674F,    /* '杏' -> 26447 */
    0xD0D4, 0x6027,    /* '性' -> 24615 */
    0xD0D5, 0x59D3,    /* '姓' -> 22995 */
    0xD0D6, 0x5144,    /* '兄' -> 20804 */
    0xD0D7, 0x51F6,    /* '凶' -> 20982 */
    0xD0D8, 0x80F8,    /* '胸' -> 33016 */
    0xD0D9, 0x5308,    /* '匈' -> 21256 */
    0xD0DA, 0x6C79,    /* '汹' -> 27769 */
    0xD0DB, 0x96C4,    /* '雄' -> 38596 */
    0xD0DC, 0x718A,    /* '熊' -> 29066 */
    0xD0DD, 0x4F11,    /* '休' -> 20241 */
    0xD0DE, 0x4FEE,    /* '修' -> 20462 */
    0xD0DF, 0x7F9E,    /* '羞' -> 32670 */
    0xD0E0, 0x673D,    /* '朽' -> 26429 */
    0xD0E1, 0x55C5,    /* '嗅' -> 21957 */
    0xD0E2, 0x9508,    /* '锈' -> 38152 */
    0xD0E3, 0x79C0,    /* '秀' -> 31168 */
    0xD0E4, 0x8896,    /* '袖' -> 34966 */
    0xD0E5, 0x7EE3,    /* '绣' -> 32483 */
    0xD0E6, 0x589F,    /* '墟' -> 22687 */
    0xD0E7, 0x620C,    /* '戌' -> 25100 */
    0xD0E8, 0x9700,    /* '需' -> 38656 */
    0xD0E9, 0x865A,    /* '虚' -> 34394 */
    0xD0EA, 0x5618,    /* '嘘' -> 22040 */
    0xD0EB, 0x987B,    /* '须' -> 39035 */
    0xD0EC, 0x5F90,    /* '徐' -> 24464 */
    0xD0ED, 0x8BB8,    /* '许' -> 35768 */
    0xD0EE, 0x84C4,    /* '蓄' -> 33988 */
    0xD0EF, 0x9157,    /* '酗' -> 37207 */
    0xD0F0, 0x53D9,    /* '叙' -> 21465 */
    0xD0F1, 0x65ED,    /* '旭' -> 26093 */
    0xD0F2, 0x5E8F,    /* '序' -> 24207 */
    0xD0F3, 0x755C,    /* '畜' -> 30044 */
    0xD0F4, 0x6064,    /* '恤' -> 24676 */
    0xD0F5, 0x7D6E,    /* '絮' -> 32110 */
    0xD0F6, 0x5A7F,    /* '婿' -> 23167 */
    0xD0F7, 0x7EEA,    /* '绪' -> 32490 */
    0xD0F8, 0x7EED,    /* '续' -> 32493 */
    0xD0F9, 0x8F69,    /* '轩' -> 36713 */
    0xD0FA, 0x55A7,    /* '喧' -> 21927 */
    0xD0FB, 0x5BA3,    /* '宣' -> 23459 */
    0xD0FC, 0x60AC,    /* '悬' -> 24748 */
    0xD0FD, 0x65CB,    /* '旋' -> 26059 */
    0xD0FE, 0x7384,    /* '玄' -> 29572 */
    0xD1A1, 0x9009,    /* '选' -> 36873 */
    0xD1A2, 0x7663,    /* '癣' -> 30307 */
    0xD1A3, 0x7729,    /* '眩' -> 30505 */
    0xD1A4, 0x7EDA,    /* '绚' -> 32474 */
    0xD1A5, 0x9774,    /* '靴' -> 38772 */
    0xD1A6, 0x859B,    /* '薛' -> 34203 */
    0xD1A7, 0x5B66,    /* '学' -> 23398 */
    0xD1A8, 0x7A74,    /* '穴' -> 31348 */
    0xD1A9, 0x96EA,    /* '雪' -> 38634 */
    0xD1AA, 0x8840,    /* '血' -> 34880 */
    0xD1AB, 0x52CB,    /* '勋' -> 21195 */
    0xD1AC, 0x718F,    /* '熏' -> 29071 */
    0xD1AD, 0x5FAA,    /* '循' -> 24490 */
    0xD1AE, 0x65EC,    /* '旬' -> 26092 */
    0xD1AF, 0x8BE2,    /* '询' -> 35810 */
    0xD1B0, 0x5BFB,    /* '寻' -> 23547 */
    0xD1B1, 0x9A6F,    /* '驯' -> 39535 */
    0xD1B2, 0x5DE1,    /* '巡' -> 24033 */
    0xD1B3, 0x6B89,    /* '殉' -> 27529 */
    0xD1B4, 0x6C5B,    /* '汛' -> 27739 */
    0xD1B5, 0x8BAD,    /* '训' -> 35757 */
    0xD1B6, 0x8BAF,    /* '讯' -> 35759 */
    0xD1B7, 0x900A,    /* '逊' -> 36874 */
    0xD1B8, 0x8FC5,    /* '迅' -> 36805 */
    0xD1B9, 0x538B,    /* '压' -> 21387 */
    0xD1BA, 0x62BC,    /* '押' -> 25276 */
    0xD1BB, 0x9E26,    /* '鸦' -> 40486 */
    0xD1BC, 0x9E2D,    /* '鸭' -> 40493 */
    0xD1BD, 0x5440,    /* '呀' -> 21568 */
    0xD1BE, 0x4E2B,    /* '丫' -> 20011 */
    0xD1BF, 0x82BD,    /* '芽' -> 33469 */
    0xD1C0, 0x7259,    /* '牙' -> 29273 */
    0xD1C1, 0x869C,    /* '蚜' -> 34460 */
    0xD1C2, 0x5D16,    /* '崖' -> 23830 */
    0xD1C3, 0x8859,    /* '衙' -> 34905 */
    0xD1C4, 0x6DAF,    /* '涯' -> 28079 */
    0xD1C5, 0x96C5,    /* '雅' -> 38597 */
    0xD1C6, 0x54D1,    /* '哑' -> 21713 */
    0xD1C7, 0x4E9A,    /* '亚' -> 20122 */
    0xD1C8, 0x8BB6,    /* '讶' -> 35766 */
    0xD1C9, 0x7109,    /* '焉' -> 28937 */
    0xD1CA, 0x54BD,    /* '咽' -> 21693 */
    0xD1CB, 0x9609,    /* '阉' -> 38409 */
    0xD1CC, 0x70DF,    /* '烟' -> 28895 */
    0xD1CD, 0x6DF9,    /* '淹' -> 28153 */
    0xD1CE, 0x76D0,    /* '盐' -> 30416 */
    0xD1CF, 0x4E25,    /* '严' -> 20005 */
    0xD1D0, 0x7814,    /* '研' -> 30740 */
    0xD1D1, 0x8712,    /* '蜒' -> 34578 */
    0xD1D2, 0x5CA9,    /* '岩' -> 23721 */
    0xD1D3, 0x5EF6,    /* '延' -> 24310 */
    0xD1D4, 0x8A00,    /* '言' -> 35328 */
    0xD1D5, 0x989C,    /* '颜' -> 39068 */
    0xD1D6, 0x960E,    /* '阎' -> 38414 */
    0xD1D7, 0x708E,    /* '炎' -> 28814 */
    0xD1D8, 0x6CBF,    /* '沿' -> 27839 */
    0xD1D9, 0x5944,    /* '奄' -> 22852 */
    0xD1DA, 0x63A9,    /* '掩' -> 25513 */
    0xD1DB, 0x773C,    /* '眼' -> 30524 */
    0xD1DC, 0x884D,    /* '衍' -> 34893 */
    0xD1DD, 0x6F14,    /* '演' -> 28436 */
    0xD1DE, 0x8273,    /* '艳' -> 33395 */
    0xD1DF, 0x5830,    /* '堰' -> 22576 */
    0xD1E0, 0x71D5,    /* '燕' -> 29141 */
    0xD1E1, 0x538C,    /* '厌' -> 21388 */
    0xD1E2, 0x781A,    /* '砚' -> 30746 */
    0xD1E3, 0x96C1,    /* '雁' -> 38593 */
    0xD1E4, 0x5501,    /* '唁' -> 21761 */
    0xD1E5, 0x5F66,    /* '彦' -> 24422 */
    0xD1E6, 0x7130,    /* '焰' -> 28976 */
    0xD1E7, 0x5BB4,    /* '宴' -> 23476 */
    0xD1E8, 0x8C1A,    /* '谚' -> 35866 */
    0xD1E9, 0x9A8C,    /* '验' -> 39564 */
    0xD1EA, 0x6B83,    /* '殃' -> 27523 */
    0xD1EB, 0x592E,    /* '央' -> 22830 */
    0xD1EC, 0x9E2F,    /* '鸯' -> 40495 */
    0xD1ED, 0x79E7,    /* '秧' -> 31207 */
    0xD1EE, 0x6768,    /* '杨' -> 26472 */
    0xD1EF, 0x626C,    /* '扬' -> 25196 */
    0xD1F0, 0x4F6F,    /* '佯' -> 20335 */
    0xD1F1, 0x75A1,    /* '疡' -> 30113 */
    0xD1F2, 0x7F8A,    /* '羊' -> 32650 */
    0xD1F3, 0x6D0B,    /* '洋' -> 27915 */
    0xD1F4, 0x9633,    /* '阳' -> 38451 */
    0xD1F5, 0x6C27,    /* '氧' -> 27687 */
    0xD1F6, 0x4EF0,    /* '仰' -> 20208 */
    0xD1F7, 0x75D2,    /* '痒' -> 30162 */
    0xD1F8, 0x517B,    /* '养' -> 20859 */
    0xD1F9, 0x6837,    /* '样' -> 26679 */
    0xD1FA, 0x6F3E,    /* '漾' -> 28478 */
    0xD1FB, 0x9080,    /* '邀' -> 36992 */
    0xD1FC, 0x8170,    /* '腰' -> 33136 */
    0xD1FD, 0x5996,    /* '妖' -> 22934 */
    0xD1FE, 0x7476,    /* '瑶' -> 29814 */
    0xD2A1, 0x6447,    /* '摇' -> 25671 */
    0xD2A2, 0x5C27,    /* '尧' -> 23591 */
    0xD2A3, 0x9065,    /* '遥' -> 36965 */
    0xD2A4, 0x7A91,    /* '窑' -> 31377 */
    0xD2A5, 0x8C23,    /* '谣' -> 35875 */
    0xD2A6, 0x59DA,    /* '姚' -> 23002 */
    0xD2A7, 0x54AC,    /* '咬' -> 21676 */
    0xD2A8, 0x8200,    /* '舀' -> 33280 */
    0xD2A9, 0x836F,    /* '药' -> 33647 */
    0xD2AA, 0x8981,    /* '要' -> 35201 */
    0xD2AB, 0x8000,    /* '耀' -> 32768 */
    0xD2AC, 0x6930,    /* '椰' -> 26928 */
    0xD2AD, 0x564E,    /* '噎' -> 22094 */
    0xD2AE, 0x8036,    /* '耶' -> 32822 */
    0xD2AF, 0x7237,    /* '爷' -> 29239 */
    0xD2B0, 0x91CE,    /* '野' -> 37326 */
    0xD2B1, 0x51B6,    /* '冶' -> 20918 */
    0xD2B2, 0x4E5F,    /* '也' -> 20063 */
    0xD2B3, 0x9875,    /* '页' -> 39029 */
    0xD2B4, 0x6396,    /* '掖' -> 25494 */
    0xD2B5, 0x4E1A,    /* '业' -> 19994 */
    0xD2B6, 0x53F6,    /* '叶' -> 21494 */
    0xD2B7, 0x66F3,    /* '曳' -> 26355 */
    0xD2B8, 0x814B,    /* '腋' -> 33099 */
    0xD2B9, 0x591C,    /* '夜' -> 22812 */
    0xD2BA, 0x6DB2,    /* '液' -> 28082 */
    0xD2BB, 0x4E00,    /* '一' -> 19968 */
    0xD2BC, 0x58F9,    /* '壹' -> 22777 */
    0xD2BD, 0x533B,    /* '医' -> 21307 */
    0xD2BE, 0x63D6,    /* '揖' -> 25558 */
    0xD2BF, 0x94F1,    /* '铱' -> 38129 */
    0xD2C0, 0x4F9D,    /* '依' -> 20381 */
    0xD2C1, 0x4F0A,    /* '伊' -> 20234 */
    0xD2C2, 0x8863,    /* '衣' -> 34915 */
    0xD2C3, 0x9890,    /* '颐' -> 39056 */
    0xD2C4, 0x5937,    /* '夷' -> 22839 */
    0xD2C5, 0x9057,    /* '遗' -> 36951 */
    0xD2C6, 0x79FB,    /* '移' -> 31227 */
    0xD2C7, 0x4EEA,    /* '仪' -> 20202 */
    0xD2C8, 0x80F0,    /* '胰' -> 33008 */
    0xD2C9, 0x7591,    /* '疑' -> 30097 */
    0xD2CA, 0x6C82,    /* '沂' -> 27778 */
    0xD2CB, 0x5B9C,    /* '宜' -> 23452 */
    0xD2CC, 0x59E8,    /* '姨' -> 23016 */
    0xD2CD, 0x5F5D,    /* '彝' -> 24413 */
    0xD2CE, 0x6905,    /* '椅' -> 26885 */
    0xD2CF, 0x8681,    /* '蚁' -> 34433 */
    0xD2D0, 0x501A,    /* '倚' -> 20506 */
    0xD2D1, 0x5DF2,    /* '已' -> 24050 */
    0xD2D2, 0x4E59,    /* '乙' -> 20057 */
    0xD2D3, 0x77E3,    /* '矣' -> 30691 */
    0xD2D4, 0x4EE5,    /* '以' -> 20197 */
    0xD2D5, 0x827A,    /* '艺' -> 33402 */
    0xD2D6, 0x6291,    /* '抑' -> 25233 */
    0xD2D7, 0x6613,    /* '易' -> 26131 */
    0xD2D8, 0x9091,    /* '邑' -> 37009 */
    0xD2D9, 0x5C79,    /* '屹' -> 23673 */
    0xD2DA, 0x4EBF,    /* '亿' -> 20159 */
    0xD2DB, 0x5F79,    /* '役' -> 24441 */
    0xD2DC, 0x81C6,    /* '臆' -> 33222 */
    0xD2DD, 0x9038,    /* '逸' -> 36920 */
    0xD2DE, 0x8084,    /* '肄' -> 32900 */
    0xD2DF, 0x75AB,    /* '疫' -> 30123 */
    0xD2E0, 0x4EA6,    /* '亦' -> 20134 */
    0xD2E1, 0x88D4,    /* '裔' -> 35028 */
    0xD2E2, 0x610F,    /* '意' -> 24847 */
    0xD2E3, 0x6BC5,    /* '毅' -> 27589 */
    0xD2E4, 0x5FC6,    /* '忆' -> 24518 */
    0xD2E5, 0x4E49,    /* '义' -> 20041 */
    0xD2E6, 0x76CA,    /* '益' -> 30410 */
    0xD2E7, 0x6EA2,    /* '溢' -> 28322 */
    0xD2E8, 0x8BE3,    /* '诣' -> 35811 */
    0xD2E9, 0x8BAE,    /* '议' -> 35758 */
    0xD2EA, 0x8C0A,    /* '谊' -> 35850 */
    0xD2EB, 0x8BD1,    /* '译' -> 35793 */
    0xD2EC, 0x5F02,    /* '异' -> 24322 */
    0xD2ED, 0x7FFC,    /* '翼' -> 32764 */
    0xD2EE, 0x7FCC,    /* '翌' -> 32716 */
    0xD2EF, 0x7ECE,    /* '绎' -> 32462 */
    0xD2F0, 0x8335,    /* '茵' -> 33589 */
    0xD2F1, 0x836B,    /* '荫' -> 33643 */
    0xD2F2, 0x56E0,    /* '因' -> 22240 */
    0xD2F3, 0x6BB7,    /* '殷' -> 27575 */
    0xD2F4, 0x97F3,    /* '音' -> 38899 */
    0xD2F5, 0x9634,    /* '阴' -> 38452 */
    0xD2F6, 0x59FB,    /* '姻' -> 23035 */
    0xD2F7, 0x541F,    /* '吟' -> 21535 */
    0xD2F8, 0x94F6,    /* '银' -> 38134 */
    0xD2F9, 0x6DEB,    /* '淫' -> 28139 */
    0xD2FA, 0x5BC5,    /* '寅' -> 23493 */
    0xD2FB, 0x996E,    /* '饮' -> 39278 */
    0xD2FC, 0x5C39,    /* '尹' -> 23609 */
    0xD2FD, 0x5F15,    /* '引' -> 24341 */
    0xD2FE, 0x9690,    /* '隐' -> 38544 */
    0xD3A1, 0x5370,    /* '印' -> 21360 */
    0xD3A2, 0x82F1,    /* '英' -> 33521 */
    0xD3A3, 0x6A31,    /* '樱' -> 27185 */
    0xD3A4, 0x5A74,    /* '婴' -> 23156 */
    0xD3A5, 0x9E70,    /* '鹰' -> 40560 */
    0xD3A6, 0x5E94,    /* '应' -> 24212 */
    0xD3A7, 0x7F28,    /* '缨' -> 32552 */
    0xD3A8, 0x83B9,    /* '莹' -> 33721 */
    0xD3A9, 0x8424,    /* '萤' -> 33828 */
    0xD3AA, 0x8425,    /* '营' -> 33829 */
    0xD3AB, 0x8367,    /* '荧' -> 33639 */
    0xD3AC, 0x8747,    /* '蝇' -> 34631 */
    0xD3AD, 0x8FCE,    /* '迎' -> 36814 */
    0xD3AE, 0x8D62,    /* '赢' -> 36194 */
    0xD3AF, 0x76C8,    /* '盈' -> 30408 */
    0xD3B0, 0x5F71,    /* '影' -> 24433 */
    0xD3B1, 0x9896,    /* '颖' -> 39062 */
    0xD3B2, 0x786C,    /* '硬' -> 30828 */
    0xD3B3, 0x6620,    /* '映' -> 26144 */
    0xD3B4, 0x54DF,    /* '哟' -> 21727 */
    0xD3B5, 0x62E5,    /* '拥' -> 25317 */
    0xD3B6, 0x4F63,    /* '佣' -> 20323 */
    0xD3B7, 0x81C3,    /* '臃' -> 33219 */
    0xD3B8, 0x75C8,    /* '痈' -> 30152 */
    0xD3B9, 0x5EB8,    /* '庸' -> 24248 */
    0xD3BA, 0x96CD,    /* '雍' -> 38605 */
    0xD3BB, 0x8E0A,    /* '踊' -> 36362 */
    0xD3BC, 0x86F9,    /* '蛹' -> 34553 */
    0xD3BD, 0x548F,    /* '咏' -> 21647 */
    0xD3BE, 0x6CF3,    /* '泳' -> 27891 */
    0xD3BF, 0x6D8C,    /* '涌' -> 28044 */
    0xD3C0, 0x6C38,    /* '永' -> 27704 */
    0xD3C1, 0x607F,    /* '恿' -> 24703 */
    0xD3C2, 0x52C7,    /* '勇' -> 21191 */
    0xD3C3, 0x7528,    /* '用' -> 29992 */
    0xD3C4, 0x5E7D,    /* '幽' -> 24189 */
    0xD3C5, 0x4F18,    /* '优' -> 20248 */
    0xD3C6, 0x60A0,    /* '悠' -> 24736 */
    0xD3C7, 0x5FE7,    /* '忧' -> 24551 */
    0xD3C8, 0x5C24,    /* '尤' -> 23588 */
    0xD3C9, 0x7531,    /* '由' -> 30001 */
    0xD3CA, 0x90AE,    /* '邮' -> 37038 */
    0xD3CB, 0x94C0,    /* '铀' -> 38080 */
    0xD3CC, 0x72B9,    /* '犹' -> 29369 */
    0xD3CD, 0x6CB9,    /* '油' -> 27833 */
    0xD3CE, 0x6E38,    /* '游' -> 28216 */
    0xD3CF, 0x9149,    /* '酉' -> 37193 */
    0xD3D0, 0x6709,    /* '有' -> 26377 */
    0xD3D1, 0x53CB,    /* '友' -> 21451 */
    0xD3D2, 0x53F3,    /* '右' -> 21491 */
    0xD3D3, 0x4F51,    /* '佑' -> 20305 */
    0xD3D4, 0x91C9,    /* '釉' -> 37321 */
    0xD3D5, 0x8BF1,    /* '诱' -> 35825 */
    0xD3D6, 0x53C8,    /* '又' -> 21448 */
    0xD3D7, 0x5E7C,    /* '幼' -> 24188 */
    0xD3D8, 0x8FC2,    /* '迂' -> 36802 */
    0xD3D9, 0x6DE4,    /* '淤' -> 28132 */
    0xD3DA, 0x4E8E,    /* '于' -> 20110 */
    0xD3DB, 0x76C2,    /* '盂' -> 30402 */
    0xD3DC, 0x6986,    /* '榆' -> 27014 */
    0xD3DD, 0x865E,    /* '虞' -> 34398 */
    0xD3DE, 0x611A,    /* '愚' -> 24858 */
    0xD3DF, 0x8206,    /* '舆' -> 33286 */
    0xD3E0, 0x4F59,    /* '余' -> 20313 */
    0xD3E1, 0x4FDE,    /* '俞' -> 20446 */
    0xD3E2, 0x903E,    /* '逾' -> 36926 */
    0xD3E3, 0x9C7C,    /* '鱼' -> 40060 */
    0xD3E4, 0x6109,    /* '愉' -> 24841 */
    0xD3E5, 0x6E1D,    /* '渝' -> 28189 */
    0xD3E6, 0x6E14,    /* '渔' -> 28180 */
    0xD3E7, 0x9685,    /* '隅' -> 38533 */
    0xD3E8, 0x4E88,    /* '予' -> 20104 */
    0xD3E9, 0x5A31,    /* '娱' -> 23089 */
    0xD3EA, 0x96E8,    /* '雨' -> 38632 */
    0xD3EB, 0x4E0E,    /* '与' -> 19982 */
    0xD3EC, 0x5C7F,    /* '屿' -> 23679 */
    0xD3ED, 0x79B9,    /* '禹' -> 31161 */
    0xD3EE, 0x5B87,    /* '宇' -> 23431 */
    0xD3EF, 0x8BED,    /* '语' -> 35821 */
    0xD3F0, 0x7FBD,    /* '羽' -> 32701 */
    0xD3F1, 0x7389,    /* '玉' -> 29577 */
    0xD3F2, 0x57DF,    /* '域' -> 22495 */
    0xD3F3, 0x828B,    /* '芋' -> 33419 */
    0xD3F4, 0x90C1,    /* '郁' -> 37057 */
    0xD3F5, 0x5401,    /* '吁' -> 21505 */
    0xD3F6, 0x9047,    /* '遇' -> 36935 */
    0xD3F7, 0x55BB,    /* '喻' -> 21947 */
    0xD3F8, 0x5CEA,    /* '峪' -> 23786 */
    0xD3F9, 0x5FA1,    /* '御' -> 24481 */
    0xD3FA, 0x6108,    /* '愈' -> 24840 */
    0xD3FB, 0x6B32,    /* '欲' -> 27442 */
    0xD3FC, 0x72F1,    /* '狱' -> 29425 */
    0xD3FD, 0x80B2,    /* '育' -> 32946 */
    0xD3FE, 0x8A89,    /* '誉' -> 35465 */
    0xD4A1, 0x6D74,    /* '浴' -> 28020 */
    0xD4A2, 0x5BD3,    /* '寓' -> 23507 */
    0xD4A3, 0x88D5,    /* '裕' -> 35029 */
    0xD4A4, 0x9884,    /* '预' -> 39044 */
    0xD4A5, 0x8C6B,    /* '豫' -> 35947 */
    0xD4A6, 0x9A6D,    /* '驭' -> 39533 */
    0xD4A7, 0x9E33,    /* '鸳' -> 40499 */
    0xD4A8, 0x6E0A,    /* '渊' -> 28170 */
    0xD4A9, 0x51A4,    /* '冤' -> 20900 */
    0xD4AA, 0x5143,    /* '元' -> 20803 */
    0xD4AB, 0x57A3,    /* '垣' -> 22435 */
    0xD4AC, 0x8881,    /* '袁' -> 34945 */
    0xD4AD, 0x539F,    /* '原' -> 21407 */
    0xD4AE, 0x63F4,    /* '援' -> 25588 */
    0xD4AF, 0x8F95,    /* '辕' -> 36757 */
    0xD4B0, 0x56ED,    /* '园' -> 22253 */
    0xD4B1, 0x5458,    /* '员' -> 21592 */
    0xD4B2, 0x5706,    /* '圆' -> 22278 */
    0xD4B3, 0x733F,    /* '猿' -> 29503 */
    0xD4B4, 0x6E90,    /* '源' -> 28304 */
    0xD4B5, 0x7F18,    /* '缘' -> 32536 */
    0xD4B6, 0x8FDC,    /* '远' -> 36828 */
    0xD4B7, 0x82D1,    /* '苑' -> 33489 */
    0xD4B8, 0x613F,    /* '愿' -> 24895 */
    0xD4B9, 0x6028,    /* '怨' -> 24616 */
    0xD4BA, 0x9662,    /* '院' -> 38498 */
    0xD4BB, 0x66F0,    /* '曰' -> 26352 */
    0xD4BC, 0x7EA6,    /* '约' -> 32422 */
    0xD4BD, 0x8D8A,    /* '越' -> 36234 */
    0xD4BE, 0x8DC3,    /* '跃' -> 36291 */
    0xD4BF, 0x94A5,    /* '钥' -> 38053 */
    0xD4C0, 0x5CB3,    /* '岳' -> 23731 */
    0xD4C1, 0x7CA4,    /* '粤' -> 31908 */
    0xD4C2, 0x6708,    /* '月' -> 26376 */
    0xD4C3, 0x60A6,    /* '悦' -> 24742 */
    0xD4C4, 0x9605,    /* '阅' -> 38405 */
    0xD4C5, 0x8018,    /* '耘' -> 32792 */
    0xD4C6, 0x4E91,    /* '云' -> 20113 */
    0xD4C7, 0x90E7,    /* '郧' -> 37095 */
    0xD4C8, 0x5300,    /* '匀' -> 21248 */
    0xD4C9, 0x9668,    /* '陨' -> 38504 */
    0xD4CA, 0x5141,    /* '允' -> 20801 */
    0xD4CB, 0x8FD0,    /* '运' -> 36816 */
    0xD4CC, 0x8574,    /* '蕴' -> 34164 */
    0xD4CD, 0x915D,    /* '酝' -> 37213 */
    0xD4CE, 0x6655,    /* '晕' -> 26197 */
    0xD4CF, 0x97F5,    /* '韵' -> 38901 */
    0xD4D0, 0x5B55,    /* '孕' -> 23381 */
    0xD4D1, 0x531D,    /* '匝' -> 21277 */
    0xD4D2, 0x7838,    /* '砸' -> 30776 */
    0xD4D3, 0x6742,    /* '杂' -> 26434 */
    0xD4D4, 0x683D,    /* '栽' -> 26685 */
    0xD4D5, 0x54C9,    /* '哉' -> 21705 */
    0xD4D6, 0x707E,    /* '灾' -> 28798 */
    0xD4D7, 0x5BB0,    /* '宰' -> 23472 */
    0xD4D8, 0x8F7D,    /* '载' -> 36733 */
    0xD4D9, 0x518D,    /* '再' -> 20877 */
    0xD4DA, 0x5728,    /* '在' -> 22312 */
    0xD4DB, 0x54B1,    /* '咱' -> 21681 */
    0xD4DC, 0x6512,    /* '攒' -> 25874 */
    0xD4DD, 0x6682,    /* '暂' -> 26242 */
    0xD4DE, 0x8D5E,    /* '赞' -> 36190 */
    0xD4DF, 0x8D43,    /* '赃' -> 36163 */
    0xD4E0, 0x810F,    /* '脏' -> 33039 */
    0xD4E1, 0x846C,    /* '葬' -> 33900 */
    0xD4E2, 0x906D,    /* '遭' -> 36973 */
    0xD4E3, 0x7CDF,    /* '糟' -> 31967 */
    0xD4E4, 0x51FF,    /* '凿' -> 20991 */
    0xD4E5, 0x85FB,    /* '藻' -> 34299 */
    0xD4E6, 0x67A3,    /* '枣' -> 26531 */
    0xD4E7, 0x65E9,    /* '早' -> 26089 */
    0xD4E8, 0x6FA1,    /* '澡' -> 28577 */
    0xD4E9, 0x86A4,    /* '蚤' -> 34468 */
    0xD4EA, 0x8E81,    /* '躁' -> 36481 */
    0xD4EB, 0x566A,    /* '噪' -> 22122 */
    0xD4EC, 0x9020,    /* '造' -> 36896 */
    0xD4ED, 0x7682,    /* '皂' -> 30338 */
    0xD4EE, 0x7076,    /* '灶' -> 28790 */
    0xD4EF, 0x71E5,    /* '燥' -> 29157 */
    0xD4F0, 0x8D23,    /* '责' -> 36131 */
    0xD4F1, 0x62E9,    /* '择' -> 25321 */
    0xD4F2, 0x5219,    /* '则' -> 21017 */
    0xD4F3, 0x6CFD,    /* '泽' -> 27901 */
    0xD4F4, 0x8D3C,    /* '贼' -> 36156 */
    0xD4F5, 0x600E,    /* '怎' -> 24590 */
    0xD4F6, 0x589E,    /* '增' -> 22686 */
    0xD4F7, 0x618E,    /* '憎' -> 24974 */
    0xD4F8, 0x66FE,    /* '曾' -> 26366 */
    0xD4F9, 0x8D60,    /* '赠' -> 36192 */
    0xD4FA, 0x624E,    /* '扎' -> 25166 */
    0xD4FB, 0x55B3,    /* '喳' -> 21939 */
    0xD4FC, 0x6E23,    /* '渣' -> 28195 */
    0xD4FD, 0x672D,    /* '札' -> 26413 */
    0xD4FE, 0x8F67,    /* '轧' -> 36711 */
    0xD5A1, 0x94E1,    /* '铡' -> 38113 */
    0xD5A2, 0x95F8,    /* '闸' -> 38392 */
    0xD5A3, 0x7728,    /* '眨' -> 30504 */
    0xD5A4, 0x6805,    /* '栅' -> 26629 */
    0xD5A5, 0x69A8,    /* '榨' -> 27048 */
    0xD5A6, 0x548B,    /* '咋' -> 21643 */
    0xD5A7, 0x4E4D,    /* '乍' -> 20045 */
    0xD5A8, 0x70B8,    /* '炸' -> 28856 */
    0xD5A9, 0x8BC8,    /* '诈' -> 35784 */
    0xD5AA, 0x6458,    /* '摘' -> 25688 */
    0xD5AB, 0x658B,    /* '斋' -> 25995 */
    0xD5AC, 0x5B85,    /* '宅' -> 23429 */
    0xD5AD, 0x7A84,    /* '窄' -> 31364 */
    0xD5AE, 0x503A,    /* '债' -> 20538 */
    0xD5AF, 0x5BE8,    /* '寨' -> 23528 */
    0xD5B0, 0x77BB,    /* '瞻' -> 30651 */
    0xD5B1, 0x6BE1,    /* '毡' -> 27617 */
    0xD5B2, 0x8A79,    /* '詹' -> 35449 */
    0xD5B3, 0x7C98,    /* '粘' -> 31896 */
    0xD5B4, 0x6CBE,    /* '沾' -> 27838 */
    0xD5B5, 0x76CF,    /* '盏' -> 30415 */
    0xD5B6, 0x65A9,    /* '斩' -> 26025 */
    0xD5B7, 0x8F97,    /* '辗' -> 36759 */
    0xD5B8, 0x5D2D,    /* '崭' -> 23853 */
    0xD5B9, 0x5C55,    /* '展' -> 23637 */
    0xD5BA, 0x8638,    /* '蘸' -> 34360 */
    0xD5BB, 0x6808,    /* '栈' -> 26632 */
    0xD5BC, 0x5360,    /* '占' -> 21344 */
    0xD5BD, 0x6218,    /* '战' -> 25112 */
    0xD5BE, 0x7AD9,    /* '站' -> 31449 */
    0xD5BF, 0x6E5B,    /* '湛' -> 28251 */
    0xD5C0, 0x7EFD,    /* '绽' -> 32509 */
    0xD5C1, 0x6A1F,    /* '樟' -> 27167 */
    0xD5C2, 0x7AE0,    /* '章' -> 31456 */
    0xD5C3, 0x5F70,    /* '彰' -> 24432 */
    0xD5C4, 0x6F33,    /* '漳' -> 28467 */
    0xD5C5, 0x5F20,    /* '张' -> 24352 */
    0xD5C6, 0x638C,    /* '掌' -> 25484 */
    0xD5C7, 0x6DA8,    /* '涨' -> 28072 */
    0xD5C8, 0x6756,    /* '杖' -> 26454 */
    0xD5C9, 0x4E08,    /* '丈' -> 19976 */
    0xD5CA, 0x5E10,    /* '帐' -> 24080 */
    0xD5CB, 0x8D26,    /* '账' -> 36134 */
    0xD5CC, 0x4ED7,    /* '仗' -> 20183 */
    0xD5CD, 0x80C0,    /* '胀' -> 32960 */
    0xD5CE, 0x7634,    /* '瘴' -> 30260 */
    0xD5CF, 0x969C,    /* '障' -> 38556 */
    0xD5D0, 0x62DB,    /* '招' -> 25307 */
    0xD5D1, 0x662D,    /* '昭' -> 26157 */
    0xD5D2, 0x627E,    /* '找' -> 25214 */
    0xD5D3, 0x6CBC,    /* '沼' -> 27836 */
    0xD5D4, 0x8D75,    /* '赵' -> 36213 */
    0xD5D5, 0x7167,    /* '照' -> 29031 */
    0xD5D6, 0x7F69,    /* '罩' -> 32617 */
    0xD5D7, 0x5146,    /* '兆' -> 20806 */
    0xD5D8, 0x8087,    /* '肇' -> 32903 */
    0xD5D9, 0x53EC,    /* '召' -> 21484 */
    0xD5DA, 0x906E,    /* '遮' -> 36974 */
    0xD5DB, 0x6298,    /* '折' -> 25240 */
    0xD5DC, 0x54F2,    /* '哲' -> 21746 */
    0xD5DD, 0x86F0,    /* '蛰' -> 34544 */
    0xD5DE, 0x8F99,    /* '辙' -> 36761 */
    0xD5DF, 0x8005,    /* '者' -> 32773 */
    0xD5E0, 0x9517,    /* '锗' -> 38167 */
    0xD5E1, 0x8517,    /* '蔗' -> 34071 */
    0xD5E2, 0x8FD9,    /* '这' -> 36825 */
    0xD5E3, 0x6D59,    /* '浙' -> 27993 */
    0xD5E4, 0x73CD,    /* '珍' -> 29645 */
    0xD5E5, 0x659F,    /* '斟' -> 26015 */
    0xD5E6, 0x771F,    /* '真' -> 30495 */
    0xD5E7, 0x7504,    /* '甄' -> 29956 */
    0xD5E8, 0x7827,    /* '砧' -> 30759 */
    0xD5E9, 0x81FB,    /* '臻' -> 33275 */
    0xD5EA, 0x8D1E,    /* '贞' -> 36126 */
    0xD5EB, 0x9488,    /* '针' -> 38024 */
    0xD5EC, 0x4FA6,    /* '侦' -> 20390 */
    0xD5ED, 0x6795,    /* '枕' -> 26517 */
    0xD5EE, 0x75B9,    /* '疹' -> 30137 */
    0xD5EF, 0x8BCA,    /* '诊' -> 35786 */
    0xD5F0, 0x9707,    /* '震' -> 38663 */
    0xD5F1, 0x632F,    /* '振' -> 25391 */
    0xD5F2, 0x9547,    /* '镇' -> 38215 */
    0xD5F3, 0x9635,    /* '阵' -> 38453 */
    0xD5F4, 0x84B8,    /* '蒸' -> 33976 */
    0xD5F5, 0x6323,    /* '挣' -> 25379 */
    0xD5F6, 0x7741,    /* '睁' -> 30529 */
    0xD5F7, 0x5F81,    /* '征' -> 24449 */
    0xD5F8, 0x72F0,    /* '狰' -> 29424 */
    0xD5F9, 0x4E89,    /* '争' -> 20105 */
    0xD5FA, 0x6014,    /* '怔' -> 24596 */
    0xD5FB, 0x6574,    /* '整' -> 25972 */
    0xD5FC, 0x62EF,    /* '拯' -> 25327 */
    0xD5FD, 0x6B63,    /* '正' -> 27491 */
    0xD5FE, 0x653F,    /* '政' -> 25919 */
    0xD6A1, 0x5E27,    /* '帧' -> 24103 */
    0xD6A2, 0x75C7,    /* '症' -> 30151 */
    0xD6A3, 0x90D1,    /* '郑' -> 37073 */
    0xD6A4, 0x8BC1,    /* '证' -> 35777 */
    0xD6A5, 0x829D,    /* '芝' -> 33437 */
    0xD6A6, 0x679D,    /* '枝' -> 26525 */
    0xD6A7, 0x652F,    /* '支' -> 25903 */
    0xD6A8, 0x5431,    /* '吱' -> 21553 */
    0xD6A9, 0x8718,    /* '蜘' -> 34584 */
    0xD6AA, 0x77E5,    /* '知' -> 30693 */
    0xD6AB, 0x80A2,    /* '肢' -> 32930 */
    0xD6AC, 0x8102,    /* '脂' -> 33026 */
    0xD6AD, 0x6C41,    /* '汁' -> 27713 */
    0xD6AE, 0x4E4B,    /* '之' -> 20043 */
    0xD6AF, 0x7EC7,    /* '织' -> 32455 */
    0xD6B0, 0x804C,    /* '职' -> 32844 */
    0xD6B1, 0x76F4,    /* '直' -> 30452 */
    0xD6B2, 0x690D,    /* '植' -> 26893 */
    0xD6B3, 0x6B96,    /* '殖' -> 27542 */
    0xD6B4, 0x6267,    /* '执' -> 25191 */
    0xD6B5, 0x503C,    /* '值' -> 20540 */
    0xD6B6, 0x4F84,    /* '侄' -> 20356 */
    0xD6B7, 0x5740,    /* '址' -> 22336 */
    0xD6B8, 0x6307,    /* '指' -> 25351 */
    0xD6B9, 0x6B62,    /* '止' -> 27490 */
    0xD6BA, 0x8DBE,    /* '趾' -> 36286 */
    0xD6BB, 0x53EA,    /* '只' -> 21482 */
    0xD6BC, 0x65E8,    /* '旨' -> 26088 */
    0xD6BD, 0x7EB8,    /* '纸' -> 32440 */
    0xD6BE, 0x5FD7,    /* '志' -> 24535 */
    0xD6BF, 0x631A,    /* '挚' -> 25370 */
    0xD6C0, 0x63B7,    /* '掷' -> 25527 */
    0xD6C1, 0x81F3,    /* '至' -> 33267 */
    0xD6C2, 0x81F4,    /* '致' -> 33268 */
    0xD6C3, 0x7F6E,    /* '置' -> 32622 */
    0xD6C4, 0x5E1C,    /* '帜' -> 24092 */
    0xD6C5, 0x5CD9,    /* '峙' -> 23769 */
    0xD6C6, 0x5236,    /* '制' -> 21046 */
    0xD6C7, 0x667A,    /* '智' -> 26234 */
    0xD6C8, 0x79E9,    /* '秩' -> 31209 */
    0xD6C9, 0x7A1A,    /* '稚' -> 31258 */
    0xD6CA, 0x8D28,    /* '质' -> 36136 */
    0xD6CB, 0x7099,    /* '炙' -> 28825 */
    0xD6CC, 0x75D4,    /* '痔' -> 30164 */
    0xD6CD, 0x6EDE,    /* '滞' -> 28382 */
    0xD6CE, 0x6CBB,    /* '治' -> 27835 */
    0xD6CF, 0x7A92,    /* '窒' -> 31378 */
    0xD6D0, 0x4E2D,    /* '中' -> 20013 */
    0xD6D1, 0x76C5,    /* '盅' -> 30405 */
    0xD6D2, 0x5FE0,    /* '忠' -> 24544 */
    0xD6D3, 0x949F,    /* '钟' -> 38047 */
    0xD6D4, 0x8877,    /* '衷' -> 34935 */
    0xD6D5, 0x7EC8,    /* '终' -> 32456 */
    0xD6D6, 0x79CD,    /* '种' -> 31181 */
    0xD6D7, 0x80BF,    /* '肿' -> 32959 */
    0xD6D8, 0x91CD,    /* '重' -> 37325 */
    0xD6D9, 0x4EF2,    /* '仲' -> 20210 */
    0xD6DA, 0x4F17,    /* '众' -> 20247 */
    0xD6DB, 0x821F,    /* '舟' -> 33311 */
    0xD6DC, 0x5468,    /* '周' -> 21608 */
    0xD6DD, 0x5DDE,    /* '州' -> 24030 */
    0xD6DE, 0x6D32,    /* '洲' -> 27954 */
    0xD6DF, 0x8BCC,    /* '诌' -> 35788 */
    0xD6E0, 0x7CA5,    /* '粥' -> 31909 */
    0xD6E1, 0x8F74,    /* '轴' -> 36724 */
    0xD6E2, 0x8098,    /* '肘' -> 32920 */
    0xD6E3, 0x5E1A,    /* '帚' -> 24090 */
    0xD6E4, 0x5492,    /* '咒' -> 21650 */
    0xD6E5, 0x76B1,    /* '皱' -> 30385 */
    0xD6E6, 0x5B99,    /* '宙' -> 23449 */
    0xD6E7, 0x663C,    /* '昼' -> 26172 */
    0xD6E8, 0x9AA4,    /* '骤' -> 39588 */
    0xD6E9, 0x73E0,    /* '珠' -> 29664 */
    0xD6EA, 0x682A,    /* '株' -> 26666 */
    0xD6EB, 0x86DB,    /* '蛛' -> 34523 */
    0xD6EC, 0x6731,    /* '朱' -> 26417 */
    0xD6ED, 0x732A,    /* '猪' -> 29482 */
    0xD6EE, 0x8BF8,    /* '诸' -> 35832 */
    0xD6EF, 0x8BDB,    /* '诛' -> 35803 */
    0xD6F0, 0x9010,    /* '逐' -> 36880 */
    0xD6F1, 0x7AF9,    /* '竹' -> 31481 */
    0xD6F2, 0x70DB,    /* '烛' -> 28891 */
    0xD6F3, 0x716E,    /* '煮' -> 29038 */
    0xD6F4, 0x62C4,    /* '拄' -> 25284 */
    0xD6F5, 0x77A9,    /* '瞩' -> 30633 */
    0xD6F6, 0x5631,    /* '嘱' -> 22065 */
    0xD6F7, 0x4E3B,    /* '主' -> 20027 */
    0xD6F8, 0x8457,    /* '著' -> 33879 */
    0xD6F9, 0x67F1,    /* '柱' -> 26609 */
    0xD6FA, 0x52A9,    /* '助' -> 21161 */
    0xD6FB, 0x86C0,    /* '蛀' -> 34496 */
    0xD6FC, 0x8D2E,    /* '贮' -> 36142 */
    0xD6FD, 0x94F8,    /* '铸' -> 38136 */
    0xD6FE, 0x7B51,    /* '筑' -> 31569 */
    0xD7A1, 0x4F4F,    /* '住' -> 20303 */
    0xD7A2, 0x6CE8,    /* '注' -> 27880 */
    0xD7A3, 0x795D,    /* '祝' -> 31069 */
    0xD7A4, 0x9A7B,    /* '驻' -> 39547 */
    0xD7A5, 0x6293,    /* '抓' -> 25235 */
    0xD7A6, 0x722A,    /* '爪' -> 29226 */
    0xD7A7, 0x62FD,    /* '拽' -> 25341 */
    0xD7A8, 0x4E13,    /* '专' -> 19987 */
    0xD7A9, 0x7816,    /* '砖' -> 30742 */
    0xD7AA, 0x8F6C,    /* '转' -> 36716 */
    0xD7AB, 0x64B0,    /* '撰' -> 25776 */
    0xD7AC, 0x8D5A,    /* '赚' -> 36186 */
    0xD7AD, 0x7BC6,    /* '篆' -> 31686 */
    0xD7AE, 0x6869,    /* '桩' -> 26729 */
    0xD7AF, 0x5E84,    /* '庄' -> 24196 */
    0xD7B0, 0x88C5,    /* '装' -> 35013 */
    0xD7B1, 0x5986,    /* '妆' -> 22918 */
    0xD7B2, 0x649E,    /* '撞' -> 25758 */
    0xD7B3, 0x58EE,    /* '壮' -> 22766 */
    0xD7B4, 0x72B6,    /* '状' -> 29366 */
    0xD7B5, 0x690E,    /* '椎' -> 26894 */
    0xD7B6, 0x9525,    /* '锥' -> 38181 */
    0xD7B7, 0x8FFD,    /* '追' -> 36861 */
    0xD7B8, 0x8D58,    /* '赘' -> 36184 */
    0xD7B9, 0x5760,    /* '坠' -> 22368 */
    0xD7BA, 0x7F00,    /* '缀' -> 32512 */
    0xD7BB, 0x8C06,    /* '谆' -> 35846 */
    0xD7BC, 0x51C6,    /* '准' -> 20934 */
    0xD7BD, 0x6349,    /* '捉' -> 25417 */
    0xD7BE, 0x62D9,    /* '拙' -> 25305 */
    0xD7BF, 0x5353,    /* '卓' -> 21331 */
    0xD7C0, 0x684C,    /* '桌' -> 26700 */
    0xD7C1, 0x7422,    /* '琢' -> 29730 */
    0xD7C2, 0x8301,    /* '茁' -> 33537 */
    0xD7C3, 0x914C,    /* '酌' -> 37196 */
    0xD7C4, 0x5544,    /* '啄' -> 21828 */
    0xD7C5, 0x7740,    /* '着' -> 30528 */
    0xD7C6, 0x707C,    /* '灼' -> 28796 */
    0xD7C7, 0x6D4A,    /* '浊' -> 27978 */
    0xD7C8, 0x5179,    /* '兹' -> 20857 */
    0xD7C9, 0x54A8,    /* '咨' -> 21672 */
    0xD7CA, 0x8D44,    /* '资' -> 36164 */
    0xD7CB, 0x59FF,    /* '姿' -> 23039 */
    0xD7CC, 0x6ECB,    /* '滋' -> 28363 */
    0xD7CD, 0x6DC4,    /* '淄' -> 28100 */
    0xD7CE, 0x5B5C,    /* '孜' -> 23388 */
    0xD7CF, 0x7D2B,    /* '紫' -> 32043 */
    0xD7D0, 0x4ED4,    /* '仔' -> 20180 */
    0xD7D1, 0x7C7D,    /* '籽' -> 31869 */
    0xD7D2, 0x6ED3,    /* '滓' -> 28371 */
    0xD7D3, 0x5B50,    /* '子' -> 23376 */
    0xD7D4, 0x81EA,    /* '自' -> 33258 */
    0xD7D5, 0x6E0D,    /* '渍' -> 28173 */
    0xD7D6, 0x5B57,    /* '字' -> 23383 */
    0xD7D7, 0x9B03,    /* '鬃' -> 39683 */
    0xD7D8, 0x68D5,    /* '棕' -> 26837 */
    0xD7D9, 0x8E2A,    /* '踪' -> 36394 */
    0xD7DA, 0x5B97,    /* '宗' -> 23447 */
    0xD7DB, 0x7EFC,    /* '综' -> 32508 */
    0xD7DC, 0x603B,    /* '总' -> 24635 */
    0xD7DD, 0x7EB5,    /* '纵' -> 32437 */
    0xD7DE, 0x90B9,    /* '邹' -> 37049 */
    0xD7DF, 0x8D70,    /* '走' -> 36208 */
    0xD7E0, 0x594F,    /* '奏' -> 22863 */
    0xD7E1, 0x63CD,    /* '揍' -> 25549 */
    0xD7E2, 0x79DF,    /* '租' -> 31199 */
    0xD7E3, 0x8DB3,    /* '足' -> 36275 */
    0xD7E4, 0x5352,    /* '卒' -> 21330 */
    0xD7E5, 0x65CF,    /* '族' -> 26063 */
    0xD7E6, 0x7956,    /* '祖' -> 31062 */
    0xD7E7, 0x8BC5,    /* '诅' -> 35781 */
    0xD7E8, 0x963B,    /* '阻' -> 38459 */
    0xD7E9, 0x7EC4,    /* '组' -> 32452 */
    0xD7EA, 0x94BB,    /* '钻' -> 38075 */
    0xD7EB, 0x7E82,    /* '纂' -> 32386 */
    0xD7EC, 0x5634,    /* '嘴' -> 22068 */
    0xD7ED, 0x9189,    /* '醉' -> 37257 */
    0xD7EE, 0x6700,    /* '最' -> 26368 */
    0xD7EF, 0x7F6A,    /* '罪' -> 32618 */
    0xD7F0, 0x5C0A,    /* '尊' -> 23562 */
    0xD7F1, 0x9075,    /* '遵' -> 36981 */
    0xD7F2, 0x6628,    /* '昨' -> 26152 */
    0xD7F3, 0x5DE6,    /* '左' -> 24038 */
    0xD7F4, 0x4F50,    /* '佐' -> 20304 */
    0xD7F5, 0x67DE,    /* '柞' -> 26590 */
    0xD7F6, 0x505A,    /* '做' -> 20570 */
    0xD7F7, 0x4F5C,    /* '作' -> 20316 */
    0xD7F8, 0x5750,    /* '坐' -> 22352 */
    0xD7F9, 0x5EA7,    /* '座' -> 24231 */
    0xD8A1, 0x4E8D,    /* '亍' -> 20109 */
    0xD8A2, 0x4E0C,    /* '丌' -> 19980 */
    0xD8A3, 0x5140,    /* '兀' -> 20800 */
    0xD8A4, 0x4E10,    /* '丐' -> 19984 */
    0xD8A5, 0x5EFF,    /* '廿' -> 24319 */
    0xD8A6, 0x5345,    /* '卅' -> 21317 */
    0xD8A7, 0x4E15,    /* '丕' -> 19989 */
    0xD8A8, 0x4E98,    /* '亘' -> 20120 */
    0xD8A9, 0x4E1E,    /* '丞' -> 19998 */
    0xD8AA, 0x9B32,    /* '鬲' -> 39730 */
    0xD8AB, 0x5B6C,    /* '孬' -> 23404 */
    0xD8AC, 0x5669,    /* '噩' -> 22121 */
    0xD8AD, 0x4E28,    /* '丨' -> 20008 */
    0xD8AE, 0x79BA,    /* '禺' -> 31162 */
    0xD8AF, 0x4E3F,    /* '丿' -> 20031 */
    0xD8B0, 0x5315,    /* '匕' -> 21269 */
    0xD8B1, 0x4E47,    /* '乇' -> 20039 */
    0xD8B2, 0x592D,    /* '夭' -> 22829 */
    0xD8B3, 0x723B,    /* '爻' -> 29243 */
    0xD8B4, 0x536E,    /* '卮' -> 21358 */
    0xD8B5, 0x6C10,    /* '氐' -> 27664 */
    0xD8B6, 0x56DF,    /* '囟' -> 22239 */
    0xD8B7, 0x80E4,    /* '胤' -> 32996 */
    0xD8B8, 0x9997,    /* '馗' -> 39319 */
    0xD8B9, 0x6BD3,    /* '毓' -> 27603 */
    0xD8BA, 0x777E,    /* '睾' -> 30590 */
    0xD8BB, 0x9F17,    /* '鼗' -> 40727 */
    0xD8BC, 0x4E36,    /* '丶' -> 20022 */
    0xD8BD, 0x4E9F,    /* '亟' -> 20127 */
    0xD8BE, 0x9F10,    /* '鼐' -> 40720 */
    0xD8BF, 0x4E5C,    /* '乜' -> 20060 */
    0xD8C0, 0x4E69,    /* '乩' -> 20073 */
    0xD8C1, 0x4E93,    /* '亓' -> 20115 */
    0xD8C2, 0x8288,    /* '芈' -> 33416 */
    0xD8C3, 0x5B5B,    /* '孛' -> 23387 */
    0xD8C4, 0x556C,    /* '啬' -> 21868 */
    0xD8C5, 0x560F,    /* '嘏' -> 22031 */
    0xD8C6, 0x4EC4,    /* '仄' -> 20164 */
    0xD8C7, 0x538D,    /* '厍' -> 21389 */
    0xD8C8, 0x539D,    /* '厝' -> 21405 */
    0xD8C9, 0x53A3,    /* '厣' -> 21411 */
    0xD8CA, 0x53A5,    /* '厥' -> 21413 */
    0xD8CB, 0x53AE,    /* '厮' -> 21422 */
    0xD8CC, 0x9765,    /* '靥' -> 38757 */
    0xD8CD, 0x8D5D,    /* '赝' -> 36189 */
    0xD8CE, 0x531A,    /* '匚' -> 21274 */
    0xD8CF, 0x53F5,    /* '叵' -> 21493 */
    0xD8D0, 0x5326,    /* '匦' -> 21286 */
    0xD8D1, 0x532E,    /* '匮' -> 21294 */
    0xD8D2, 0x533E,    /* '匾' -> 21310 */
    0xD8D3, 0x8D5C,    /* '赜' -> 36188 */
    0xD8D4, 0x5366,    /* '卦' -> 21350 */
    0xD8D5, 0x5363,    /* '卣' -> 21347 */
    0xD8D6, 0x5202,    /* '刂' -> 20994 */
    0xD8D7, 0x5208,    /* '刈' -> 21000 */
    0xD8D8, 0x520E,    /* '刎' -> 21006 */
    0xD8D9, 0x522D,    /* '刭' -> 21037 */
    0xD8DA, 0x5233,    /* '刳' -> 21043 */
    0xD8DB, 0x523F,    /* '刿' -> 21055 */
    0xD8DC, 0x5240,    /* '剀' -> 21056 */
    0xD8DD, 0x524C,    /* '剌' -> 21068 */
    0xD8DE, 0x525E,    /* '剞' -> 21086 */
    0xD8DF, 0x5261,    /* '剡' -> 21089 */
    0xD8E0, 0x525C,    /* '剜' -> 21084 */
    0xD8E1, 0x84AF,    /* '蒯' -> 33967 */
    0xD8E2, 0x527D,    /* '剽' -> 21117 */
    0xD8E3, 0x5282,    /* '劂' -> 21122 */
    0xD8E4, 0x5281,    /* '劁' -> 21121 */
    0xD8E5, 0x5290,    /* '劐' -> 21136 */
    0xD8E6, 0x5293,    /* '劓' -> 21139 */
    0xD8E7, 0x5182,    /* '冂' -> 20866 */
    0xD8E8, 0x7F54,    /* '罔' -> 32596 */
    0xD8E9, 0x4EBB,    /* '亻' -> 20155 */
    0xD8EA, 0x4EC3,    /* '仃' -> 20163 */
    0xD8EB, 0x4EC9,    /* '仉' -> 20169 */
    0xD8EC, 0x4EC2,    /* '仂' -> 20162 */
    0xD8ED, 0x4EE8,    /* '仨' -> 20200 */
    0xD8EE, 0x4EE1,    /* '仡' -> 20193 */
    0xD8EF, 0x4EEB,    /* '仫' -> 20203 */
    0xD8F0, 0x4EDE,    /* '仞' -> 20190 */
    0xD8F1, 0x4F1B,    /* '伛' -> 20251 */
    0xD8F2, 0x4EF3,    /* '仳' -> 20211 */
    0xD8F3, 0x4F22,    /* '伢' -> 20258 */
    0xD8F4, 0x4F64,    /* '佤' -> 20324 */
    0xD8F5, 0x4EF5,    /* '仵' -> 20213 */
    0xD8F6, 0x4F25,    /* '伥' -> 20261 */
    0xD8F7, 0x4F27,    /* '伧' -> 20263 */
    0xD8F8, 0x4F09,    /* '伉' -> 20233 */
    0xD8F9, 0x4F2B,    /* '伫' -> 20267 */
    0xD8FA, 0x4F5E,    /* '佞' -> 20318 */
    0xD8FB, 0x4F67,    /* '佧' -> 20327 */
    0xD8FC, 0x6538,    /* '攸' -> 25912 */
    0xD8FD, 0x4F5A,    /* '佚' -> 20314 */
    0xD8FE, 0x4F5D,    /* '佝' -> 20317 */
    0xD9A1, 0x4F5F,    /* '佟' -> 20319 */
    0xD9A2, 0x4F57,    /* '佗' -> 20311 */
    0xD9A3, 0x4F32,    /* '伲' -> 20274 */
    0xD9A4, 0x4F3D,    /* '伽' -> 20285 */
    0xD9A5, 0x4F76,    /* '佶' -> 20342 */
    0xD9A6, 0x4F74,    /* '佴' -> 20340 */
    0xD9A7, 0x4F91,    /* '侑' -> 20369 */
    0xD9A8, 0x4F89,    /* '侉' -> 20361 */
    0xD9A9, 0x4F83,    /* '侃' -> 20355 */
    0xD9AA, 0x4F8F,    /* '侏' -> 20367 */
    0xD9AB, 0x4F7E,    /* '佾' -> 20350 */
    0xD9AC, 0x4F7B,    /* '佻' -> 20347 */
    0xD9AD, 0x4FAA,    /* '侪' -> 20394 */
    0xD9AE, 0x4F7C,    /* '佼' -> 20348 */
    0xD9AF, 0x4FAC,    /* '侬' -> 20396 */
    0xD9B0, 0x4F94,    /* '侔' -> 20372 */
    0xD9B1, 0x4FE6,    /* '俦' -> 20454 */
    0xD9B2, 0x4FE8,    /* '俨' -> 20456 */
    0xD9B3, 0x4FEA,    /* '俪' -> 20458 */
    0xD9B4, 0x4FC5,    /* '俅' -> 20421 */
    0xD9B5, 0x4FDA,    /* '俚' -> 20442 */
    0xD9B6, 0x4FE3,    /* '俣' -> 20451 */
    0xD9B7, 0x4FDC,    /* '俜' -> 20444 */
    0xD9B8, 0x4FD1,    /* '俑' -> 20433 */
    0xD9B9, 0x4FDF,    /* '俟' -> 20447 */
    0xD9BA, 0x4FF8,    /* '俸' -> 20472 */
    0xD9BB, 0x5029,    /* '倩' -> 20521 */
    0xD9BC, 0x504C,    /* '偌' -> 20556 */
    0xD9BD, 0x4FF3,    /* '俳' -> 20467 */
    0xD9BE, 0x502C,    /* '倬' -> 20524 */
    0xD9BF, 0x500F,    /* '倏' -> 20495 */
    0xD9C0, 0x502E,    /* '倮' -> 20526 */
    0xD9C1, 0x502D,    /* '倭' -> 20525 */
    0xD9C2, 0x4FFE,    /* '俾' -> 20478 */
    0xD9C3, 0x501C,    /* '倜' -> 20508 */
    0xD9C4, 0x500C,    /* '倌' -> 20492 */
    0xD9C5, 0x5025,    /* '倥' -> 20517 */
    0xD9C6, 0x5028,    /* '倨' -> 20520 */
    0xD9C7, 0x507E,    /* '偾' -> 20606 */
    0xD9C8, 0x5043,    /* '偃' -> 20547 */
    0xD9C9, 0x5055,    /* '偕' -> 20565 */
    0xD9CA, 0x5048,    /* '偈' -> 20552 */
    0xD9CB, 0x504E,    /* '偎' -> 20558 */
    0xD9CC, 0x506C,    /* '偬' -> 20588 */
    0xD9CD, 0x507B,    /* '偻' -> 20603 */
    0xD9CE, 0x50A5,    /* '傥' -> 20645 */
    0xD9CF, 0x50A7,    /* '傧' -> 20647 */
    0xD9D0, 0x50A9,    /* '傩' -> 20649 */
    0xD9D1, 0x50BA,    /* '傺' -> 20666 */
    0xD9D2, 0x50D6,    /* '僖' -> 20694 */
    0xD9D3, 0x5106,    /* '儆' -> 20742 */
    0xD9D4, 0x50ED,    /* '僭' -> 20717 */
    0xD9D5, 0x50EC,    /* '僬' -> 20716 */
    0xD9D6, 0x50E6,    /* '僦' -> 20710 */
    0xD9D7, 0x50EE,    /* '僮' -> 20718 */
    0xD9D8, 0x5107,    /* '儇' -> 20743 */
    0xD9D9, 0x510B,    /* '儋' -> 20747 */
    0xD9DA, 0x4EDD,    /* '仝' -> 20189 */
    0xD9DB, 0x6C3D,    /* '氽' -> 27709 */
    0xD9DC, 0x4F58,    /* '佘' -> 20312 */
    0xD9DD, 0x4F65,    /* '佥' -> 20325 */
    0xD9DE, 0x4FCE,    /* '俎' -> 20430 */
    0xD9DF, 0x9FA0,    /* '龠' -> 40864 */
    0xD9E0, 0x6C46,    /* '汆' -> 27718 */
    0xD9E1, 0x7C74,    /* '籴' -> 31860 */
    0xD9E2, 0x516E,    /* '兮' -> 20846 */
    0xD9E3, 0x5DFD,    /* '巽' -> 24061 */
    0xD9E4, 0x9EC9,    /* '黉' -> 40649 */
    0xD9E5, 0x9998,    /* '馘' -> 39320 */
    0xD9E6, 0x5181,    /* '冁' -> 20865 */
    0xD9E7, 0x5914,    /* '夔' -> 22804 */
    0xD9E8, 0x52F9,    /* '勹' -> 21241 */
    0xD9E9, 0x530D,    /* '匍' -> 21261 */
    0xD9EA, 0x8A07,    /* '訇' -> 35335 */
    0xD9EB, 0x5310,    /* '匐' -> 21264 */
    0xD9EC, 0x51EB,    /* '凫' -> 20971 */
    0xD9ED, 0x5919,    /* '夙' -> 22809 */
    0xD9EE, 0x5155,    /* '兕' -> 20821 */
    0xD9EF, 0x4EA0,    /* '亠' -> 20128 */
    0xD9F0, 0x5156,    /* '兖' -> 20822 */
    0xD9F1, 0x4EB3,    /* '亳' -> 20147 */
    0xD9F2, 0x886E,    /* '衮' -> 34926 */
    0xD9F3, 0x88A4,    /* '袤' -> 34980 */
    0xD9F4, 0x4EB5,    /* '亵' -> 20149 */
    0xD9F5, 0x8114,    /* '脔' -> 33044 */
    0xD9F6, 0x88D2,    /* '裒' -> 35026 */
    0xD9F7, 0x7980,    /* '禀' -> 31104 */
    0xD9F8, 0x5B34,    /* '嬴' -> 23348 */
    0xD9F9, 0x8803,    /* '蠃' -> 34819 */
    0xD9FA, 0x7FB8,    /* '羸' -> 32696 */
    0xD9FB, 0x51AB,    /* '冫' -> 20907 */
    0xD9FC, 0x51B1,    /* '冱' -> 20913 */
    0xD9FD, 0x51BD,    /* '冽' -> 20925 */
    0xD9FE, 0x51BC,    /* '冼' -> 20924 */
    0xDAA1, 0x51C7,    /* '凇' -> 20935 */
    0xDAA2, 0x5196,    /* '冖' -> 20886 */
    0xDAA3, 0x51A2,    /* '冢' -> 20898 */
    0xDAA4, 0x51A5,    /* '冥' -> 20901 */
    0xDAA5, 0x8BA0,    /* '讠' -> 35744 */
    0xDAA6, 0x8BA6,    /* '讦' -> 35750 */
    0xDAA7, 0x8BA7,    /* '讧' -> 35751 */
    0xDAA8, 0x8BAA,    /* '讪' -> 35754 */
    0xDAA9, 0x8BB4,    /* '讴' -> 35764 */
    0xDAAA, 0x8BB5,    /* '讵' -> 35765 */
    0xDAAB, 0x8BB7,    /* '讷' -> 35767 */
    0xDAAC, 0x8BC2,    /* '诂' -> 35778 */
    0xDAAD, 0x8BC3,    /* '诃' -> 35779 */
    0xDAAE, 0x8BCB,    /* '诋' -> 35787 */
    0xDAAF, 0x8BCF,    /* '诏' -> 35791 */
    0xDAB0, 0x8BCE,    /* '诎' -> 35790 */
    0xDAB1, 0x8BD2,    /* '诒' -> 35794 */
    0xDAB2, 0x8BD3,    /* '诓' -> 35795 */
    0xDAB3, 0x8BD4,    /* '诔' -> 35796 */
    0xDAB4, 0x8BD6,    /* '诖' -> 35798 */
    0xDAB5, 0x8BD8,    /* '诘' -> 35800 */
    0xDAB6, 0x8BD9,    /* '诙' -> 35801 */
    0xDAB7, 0x8BDC,    /* '诜' -> 35804 */
    0xDAB8, 0x8BDF,    /* '诟' -> 35807 */
    0xDAB9, 0x8BE0,    /* '诠' -> 35808 */
    0xDABA, 0x8BE4,    /* '诤' -> 35812 */
    0xDABB, 0x8BE8,    /* '诨' -> 35816 */
    0xDABC, 0x8BE9,    /* '诩' -> 35817 */
    0xDABD, 0x8BEE,    /* '诮' -> 35822 */
    0xDABE, 0x8BF0,    /* '诰' -> 35824 */
    0xDABF, 0x8BF3,    /* '诳' -> 35827 */
    0xDAC0, 0x8BF6,    /* '诶' -> 35830 */
    0xDAC1, 0x8BF9,    /* '诹' -> 35833 */
    0xDAC2, 0x8BFC,    /* '诼' -> 35836 */
    0xDAC3, 0x8BFF,    /* '诿' -> 35839 */
    0xDAC4, 0x8C00,    /* '谀' -> 35840 */
    0xDAC5, 0x8C02,    /* '谂' -> 35842 */
    0xDAC6, 0x8C04,    /* '谄' -> 35844 */
    0xDAC7, 0x8C07,    /* '谇' -> 35847 */
    0xDAC8, 0x8C0C,    /* '谌' -> 35852 */
    0xDAC9, 0x8C0F,    /* '谏' -> 35855 */
    0xDACA, 0x8C11,    /* '谑' -> 35857 */
    0xDACB, 0x8C12,    /* '谒' -> 35858 */
    0xDACC, 0x8C14,    /* '谔' -> 35860 */
    0xDACD, 0x8C15,    /* '谕' -> 35861 */
    0xDACE, 0x8C16,    /* '谖' -> 35862 */
    0xDACF, 0x8C19,    /* '谙' -> 35865 */
    0xDAD0, 0x8C1B,    /* '谛' -> 35867 */
    0xDAD1, 0x8C18,    /* '谘' -> 35864 */
    0xDAD2, 0x8C1D,    /* '谝' -> 35869 */
    0xDAD3, 0x8C1F,    /* '谟' -> 35871 */
    0xDAD4, 0x8C20,    /* '谠' -> 35872 */
    0xDAD5, 0x8C21,    /* '谡' -> 35873 */
    0xDAD6, 0x8C25,    /* '谥' -> 35877 */
    0xDAD7, 0x8C27,    /* '谧' -> 35879 */
    0xDAD8, 0x8C2A,    /* '谪' -> 35882 */
    0xDAD9, 0x8C2B,    /* '谫' -> 35883 */
    0xDADA, 0x8C2E,    /* '谮' -> 35886 */
    0xDADB, 0x8C2F,    /* '谯' -> 35887 */
    0xDADC, 0x8C32,    /* '谲' -> 35890 */
    0xDADD, 0x8C33,    /* '谳' -> 35891 */
    0xDADE, 0x8C35,    /* '谵' -> 35893 */
    0xDADF, 0x8C36,    /* '谶' -> 35894 */
    0xDAE0, 0x5369,    /* '卩' -> 21353 */
    0xDAE1, 0x537A,    /* '卺' -> 21370 */
    0xDAE2, 0x961D,    /* '阝' -> 38429 */
    0xDAE3, 0x9622,    /* '阢' -> 38434 */
    0xDAE4, 0x9621,    /* '阡' -> 38433 */
    0xDAE5, 0x9631,    /* '阱' -> 38449 */
    0xDAE6, 0x962A,    /* '阪' -> 38442 */
    0xDAE7, 0x963D,    /* '阽' -> 38461 */
    0xDAE8, 0x963C,    /* '阼' -> 38460 */
    0xDAE9, 0x9642,    /* '陂' -> 38466 */
    0xDAEA, 0x9649,    /* '陉' -> 38473 */
    0xDAEB, 0x9654,    /* '陔' -> 38484 */
    0xDAEC, 0x965F,    /* '陟' -> 38495 */
    0xDAED, 0x9667,    /* '陧' -> 38503 */
    0xDAEE, 0x966C,    /* '陬' -> 38508 */
    0xDAEF, 0x9672,    /* '陲' -> 38514 */
    0xDAF0, 0x9674,    /* '陴' -> 38516 */
    0xDAF1, 0x9688,    /* '隈' -> 38536 */
    0xDAF2, 0x968D,    /* '隍' -> 38541 */
    0xDAF3, 0x9697,    /* '隗' -> 38551 */
    0xDAF4, 0x96B0,    /* '隰' -> 38576 */
    0xDAF5, 0x9097,    /* '邗' -> 37015 */
    0xDAF6, 0x909B,    /* '邛' -> 37019 */
    0xDAF7, 0x909D,    /* '邝' -> 37021 */
    0xDAF8, 0x9099,    /* '邙' -> 37017 */
    0xDAF9, 0x90AC,    /* '邬' -> 37036 */
    0xDAFA, 0x90A1,    /* '邡' -> 37025 */
    0xDAFB, 0x90B4,    /* '邴' -> 37044 */
    0xDAFC, 0x90B3,    /* '邳' -> 37043 */
    0xDAFD, 0x90B6,    /* '邶' -> 37046 */
    0xDAFE, 0x90BA,    /* '邺' -> 37050 */
    0xDBA1, 0x90B8,    /* '邸' -> 37048 */
    0xDBA2, 0x90B0,    /* '邰' -> 37040 */
    0xDBA3, 0x90CF,    /* '郏' -> 37071 */
    0xDBA4, 0x90C5,    /* '郅' -> 37061 */
    0xDBA5, 0x90BE,    /* '邾' -> 37054 */
    0xDBA6, 0x90D0,    /* '郐' -> 37072 */
    0xDBA7, 0x90C4,    /* '郄' -> 37060 */
    0xDBA8, 0x90C7,    /* '郇' -> 37063 */
    0xDBA9, 0x90D3,    /* '郓' -> 37075 */
    0xDBAA, 0x90E6,    /* '郦' -> 37094 */
    0xDBAB, 0x90E2,    /* '郢' -> 37090 */
    0xDBAC, 0x90DC,    /* '郜' -> 37084 */
    0xDBAD, 0x90D7,    /* '郗' -> 37079 */
    0xDBAE, 0x90DB,    /* '郛' -> 37083 */
    0xDBAF, 0x90EB,    /* '郫' -> 37099 */
    0xDBB0, 0x90EF,    /* '郯' -> 37103 */
    0xDBB1, 0x90FE,    /* '郾' -> 37118 */
    0xDBB2, 0x9104,    /* '鄄' -> 37124 */
    0xDBB3, 0x9122,    /* '鄢' -> 37154 */
    0xDBB4, 0x911E,    /* '鄞' -> 37150 */
    0xDBB5, 0x9123,    /* '鄣' -> 37155 */
    0xDBB6, 0x9131,    /* '鄱' -> 37169 */
    0xDBB7, 0x912F,    /* '鄯' -> 37167 */
    0xDBB8, 0x9139,    /* '鄹' -> 37177 */
    0xDBB9, 0x9143,    /* '酃' -> 37187 */
    0xDBBA, 0x9146,    /* '酆' -> 37190 */
    0xDBBB, 0x520D,    /* '刍' -> 21005 */
    0xDBBC, 0x5942,    /* '奂' -> 22850 */
    0xDBBD, 0x52A2,    /* '劢' -> 21154 */
    0xDBBE, 0x52AC,    /* '劬' -> 21164 */
    0xDBBF, 0x52AD,    /* '劭' -> 21165 */
    0xDBC0, 0x52BE,    /* '劾' -> 21182 */
    0xDBC1, 0x54FF,    /* '哿' -> 21759 */
    0xDBC2, 0x52D0,    /* '勐' -> 21200 */
    0xDBC3, 0x52D6,    /* '勖' -> 21206 */
    0xDBC4, 0x52F0,    /* '勰' -> 21232 */
    0xDBC5, 0x53DF,    /* '叟' -> 21471 */
    0xDBC6, 0x71EE,    /* '燮' -> 29166 */
    0xDBC7, 0x77CD,    /* '矍' -> 30669 */
    0xDBC8, 0x5EF4,    /* '廴' -> 24308 */
    0xDBC9, 0x51F5,    /* '凵' -> 20981 */
    0xDBCA, 0x51FC,    /* '凼' -> 20988 */
    0xDBCB, 0x9B2F,    /* '鬯' -> 39727 */
    0xDBCC, 0x53B6,    /* '厶' -> 21430 */
    0xDBCD, 0x5F01,    /* '弁' -> 24321 */
    0xDBCE, 0x755A,    /* '畚' -> 30042 */
    0xDBCF, 0x5DEF,    /* '巯' -> 24047 */
    0xDBD0, 0x574C,    /* '坌' -> 22348 */
    0xDBD1, 0x57A9,    /* '垩' -> 22441 */
    0xDBD2, 0x57A1,    /* '垡' -> 22433 */
    0xDBD3, 0x587E,    /* '塾' -> 22654 */
    0xDBD4, 0x58BC,    /* '墼' -> 22716 */
    0xDBD5, 0x58C5,    /* '壅' -> 22725 */
    0xDBD6, 0x58D1,    /* '壑' -> 22737 */
    0xDBD7, 0x5729,    /* '圩' -> 22313 */
    0xDBD8, 0x572C,    /* '圬' -> 22316 */
    0xDBD9, 0x572A,    /* '圪' -> 22314 */
    0xDBDA, 0x5733,    /* '圳' -> 22323 */
    0xDBDB, 0x5739,    /* '圹' -> 22329 */
    0xDBDC, 0x572E,    /* '圮' -> 22318 */
    0xDBDD, 0x572F,    /* '圯' -> 22319 */
    0xDBDE, 0x575C,    /* '坜' -> 22364 */
    0xDBDF, 0x573B,    /* '圻' -> 22331 */
    0xDBE0, 0x5742,    /* '坂' -> 22338 */
    0xDBE1, 0x5769,    /* '坩' -> 22377 */
    0xDBE2, 0x5785,    /* '垅' -> 22405 */
    0xDBE3, 0x576B,    /* '坫' -> 22379 */
    0xDBE4, 0x5786,    /* '垆' -> 22406 */
    0xDBE5, 0x577C,    /* '坼' -> 22396 */
    0xDBE6, 0x577B,    /* '坻' -> 22395 */
    0xDBE7, 0x5768,    /* '坨' -> 22376 */
    0xDBE8, 0x576D,    /* '坭' -> 22381 */
    0xDBE9, 0x5776,    /* '坶' -> 22390 */
    0xDBEA, 0x5773,    /* '坳' -> 22387 */
    0xDBEB, 0x57AD,    /* '垭' -> 22445 */
    0xDBEC, 0x57A4,    /* '垤' -> 22436 */
    0xDBED, 0x578C,    /* '垌' -> 22412 */
    0xDBEE, 0x57B2,    /* '垲' -> 22450 */
    0xDBEF, 0x57CF,    /* '埏' -> 22479 */
    0xDBF0, 0x57A7,    /* '垧' -> 22439 */
    0xDBF1, 0x57B4,    /* '垴' -> 22452 */
    0xDBF2, 0x5793,    /* '垓' -> 22419 */
    0xDBF3, 0x57A0,    /* '垠' -> 22432 */
    0xDBF4, 0x57D5,    /* '埕' -> 22485 */
    0xDBF5, 0x57D8,    /* '埘' -> 22488 */
    0xDBF6, 0x57DA,    /* '埚' -> 22490 */
    0xDBF7, 0x57D9,    /* '埙' -> 22489 */
    0xDBF8, 0x57D2,    /* '埒' -> 22482 */
    0xDBF9, 0x57B8,    /* '垸' -> 22456 */
    0xDBFA, 0x57F4,    /* '埴' -> 22516 */
    0xDBFB, 0x57EF,    /* '埯' -> 22511 */
    0xDBFC, 0x57F8,    /* '埸' -> 22520 */
    0xDBFD, 0x57E4,    /* '埤' -> 22500 */
    0xDBFE, 0x57DD,    /* '埝' -> 22493 */
    0xDCA1, 0x580B,    /* '堋' -> 22539 */
    0xDCA2, 0x580D,    /* '堍' -> 22541 */
    0xDCA3, 0x57FD,    /* '埽' -> 22525 */
    0xDCA4, 0x57ED,    /* '埭' -> 22509 */
    0xDCA5, 0x5800,    /* '堀' -> 22528 */
    0xDCA6, 0x581E,    /* '堞' -> 22558 */
    0xDCA7, 0x5819,    /* '堙' -> 22553 */
    0xDCA8, 0x5844,    /* '塄' -> 22596 */
    0xDCA9, 0x5820,    /* '堠' -> 22560 */
    0xDCAA, 0x5865,    /* '塥' -> 22629 */
    0xDCAB, 0x586C,    /* '塬' -> 22636 */
    0xDCAC, 0x5881,    /* '墁' -> 22657 */
    0xDCAD, 0x5889,    /* '墉' -> 22665 */
    0xDCAE, 0x589A,    /* '墚' -> 22682 */
    0xDCAF, 0x5880,    /* '墀' -> 22656 */
    0xDCB0, 0x99A8,    /* '馨' -> 39336 */
    0xDCB1, 0x9F19,    /* '鼙' -> 40729 */
    0xDCB2, 0x61FF,    /* '懿' -> 25087 */
    0xDCB3, 0x8279,    /* '艹' -> 33401 */
    0xDCB4, 0x827D,    /* '艽' -> 33405 */
    0xDCB5, 0x827F,    /* '艿' -> 33407 */
    0xDCB6, 0x828F,    /* '芏' -> 33423 */
    0xDCB7, 0x828A,    /* '芊' -> 33418 */
    0xDCB8, 0x82A8,    /* '芨' -> 33448 */
    0xDCB9, 0x8284,    /* '芄' -> 33412 */
    0xDCBA, 0x828E,    /* '芎' -> 33422 */
    0xDCBB, 0x8291,    /* '芑' -> 33425 */
    0xDCBC, 0x8297,    /* '芗' -> 33431 */
    0xDCBD, 0x8299,    /* '芙' -> 33433 */
    0xDCBE, 0x82AB,    /* '芫' -> 33451 */
    0xDCBF, 0x82B8,    /* '芸' -> 33464 */
    0xDCC0, 0x82BE,    /* '芾' -> 33470 */
    0xDCC1, 0x82B0,    /* '芰' -> 33456 */
    0xDCC2, 0x82C8,    /* '苈' -> 33480 */
    0xDCC3, 0x82CA,    /* '苊' -> 33482 */
    0xDCC4, 0x82E3,    /* '苣' -> 33507 */
    0xDCC5, 0x8298,    /* '芘' -> 33432 */
    0xDCC6, 0x82B7,    /* '芷' -> 33463 */
    0xDCC7, 0x82AE,    /* '芮' -> 33454 */
    0xDCC8, 0x82CB,    /* '苋' -> 33483 */
    0xDCC9, 0x82CC,    /* '苌' -> 33484 */
    0xDCCA, 0x82C1,    /* '苁' -> 33473 */
    0xDCCB, 0x82A9,    /* '芩' -> 33449 */
    0xDCCC, 0x82B4,    /* '芴' -> 33460 */
    0xDCCD, 0x82A1,    /* '芡' -> 33441 */
    0xDCCE, 0x82AA,    /* '芪' -> 33450 */
    0xDCCF, 0x829F,    /* '芟' -> 33439 */
    0xDCD0, 0x82C4,    /* '苄' -> 33476 */
    0xDCD1, 0x82CE,    /* '苎' -> 33486 */
    0xDCD2, 0x82A4,    /* '芤' -> 33444 */
    0xDCD3, 0x82E1,    /* '苡' -> 33505 */
    0xDCD4, 0x8309,    /* '茉' -> 33545 */
    0xDCD5, 0x82F7,    /* '苷' -> 33527 */
    0xDCD6, 0x82E4,    /* '苤' -> 33508 */
    0xDCD7, 0x830F,    /* '茏' -> 33551 */
    0xDCD8, 0x8307,    /* '茇' -> 33543 */
    0xDCD9, 0x82DC,    /* '苜' -> 33500 */
    0xDCDA, 0x82F4,    /* '苴' -> 33524 */
    0xDCDB, 0x82D2,    /* '苒' -> 33490 */
    0xDCDC, 0x82D8,    /* '苘' -> 33496 */
    0xDCDD, 0x830C,    /* '茌' -> 33548 */
    0xDCDE, 0x82FB,    /* '苻' -> 33531 */
    0xDCDF, 0x82D3,    /* '苓' -> 33491 */
    0xDCE0, 0x8311,    /* '茑' -> 33553 */
    0xDCE1, 0x831A,    /* '茚' -> 33562 */
    0xDCE2, 0x8306,    /* '茆' -> 33542 */
    0xDCE3, 0x8314,    /* '茔' -> 33556 */
    0xDCE4, 0x8315,    /* '茕' -> 33557 */
    0xDCE5, 0x82E0,    /* '苠' -> 33504 */
    0xDCE6, 0x82D5,    /* '苕' -> 33493 */
    0xDCE7, 0x831C,    /* '茜' -> 33564 */
    0xDCE8, 0x8351,    /* '荑' -> 33617 */
    0xDCE9, 0x835B,    /* '荛' -> 33627 */
    0xDCEA, 0x835C,    /* '荜' -> 33628 */
    0xDCEB, 0x8308,    /* '茈' -> 33544 */
    0xDCEC, 0x8392,    /* '莒' -> 33682 */
    0xDCED, 0x833C,    /* '茼' -> 33596 */
    0xDCEE, 0x8334,    /* '茴' -> 33588 */
    0xDCEF, 0x8331,    /* '茱' -> 33585 */
    0xDCF0, 0x839B,    /* '莛' -> 33691 */
    0xDCF1, 0x835E,    /* '荞' -> 33630 */
    0xDCF2, 0x832F,    /* '茯' -> 33583 */
    0xDCF3, 0x834F,    /* '荏' -> 33615 */
    0xDCF4, 0x8347,    /* '荇' -> 33607 */
    0xDCF5, 0x8343,    /* '荃' -> 33603 */
    0xDCF6, 0x835F,    /* '荟' -> 33631 */
    0xDCF7, 0x8340,    /* '荀' -> 33600 */
    0xDCF8, 0x8317,    /* '茗' -> 33559 */
    0xDCF9, 0x8360,    /* '荠' -> 33632 */
    0xDCFA, 0x832D,    /* '茭' -> 33581 */
    0xDCFB, 0x833A,    /* '茺' -> 33594 */
    0xDCFC, 0x8333,    /* '茳' -> 33587 */
    0xDCFD, 0x8366,    /* '荦' -> 33638 */
    0xDCFE, 0x8365,    /* '荥' -> 33637 */
    0xDDA1, 0x8368,    /* '荨' -> 33640 */
    0xDDA2, 0x831B,    /* '茛' -> 33563 */
    0xDDA3, 0x8369,    /* '荩' -> 33641 */
    0xDDA4, 0x836C,    /* '荬' -> 33644 */
    0xDDA5, 0x836A,    /* '荪' -> 33642 */
    0xDDA6, 0x836D,    /* '荭' -> 33645 */
    0xDDA7, 0x836E,    /* '荮' -> 33646 */
    0xDDA8, 0x83B0,    /* '莰' -> 33712 */
    0xDDA9, 0x8378,    /* '荸' -> 33656 */
    0xDDAA, 0x83B3,    /* '莳' -> 33715 */
    0xDDAB, 0x83B4,    /* '莴' -> 33716 */
    0xDDAC, 0x83A0,    /* '莠' -> 33696 */
    0xDDAD, 0x83AA,    /* '莪' -> 33706 */
    0xDDAE, 0x8393,    /* '莓' -> 33683 */
    0xDDAF, 0x839C,    /* '莜' -> 33692 */
    0xDDB0, 0x8385,    /* '莅' -> 33669 */
    0xDDB1, 0x837C,    /* '荼' -> 33660 */
    0xDDB2, 0x83B6,    /* '莶' -> 33718 */
    0xDDB3, 0x83A9,    /* '莩' -> 33705 */
    0xDDB4, 0x837D,    /* '荽' -> 33661 */
    0xDDB5, 0x83B8,    /* '莸' -> 33720 */
    0xDDB6, 0x837B,    /* '荻' -> 33659 */
    0xDDB7, 0x8398,    /* '莘' -> 33688 */
    0xDDB8, 0x839E,    /* '莞' -> 33694 */
    0xDDB9, 0x83A8,    /* '莨' -> 33704 */
    0xDDBA, 0x83BA,    /* '莺' -> 33722 */
    0xDDBB, 0x83BC,    /* '莼' -> 33724 */
    0xDDBC, 0x83C1,    /* '菁' -> 33729 */
    0xDDBD, 0x8401,    /* '萁' -> 33793 */
    0xDDBE, 0x83E5,    /* '菥' -> 33765 */
    0xDDBF, 0x83D8,    /* '菘' -> 33752 */
    0xDDC0, 0x5807,    /* '堇' -> 22535 */
    0xDDC1, 0x8418,    /* '萘' -> 33816 */
    0xDDC2, 0x840B,    /* '萋' -> 33803 */
    0xDDC3, 0x83DD,    /* '菝' -> 33757 */
    0xDDC4, 0x83FD,    /* '菽' -> 33789 */
    0xDDC5, 0x83D6,    /* '菖' -> 33750 */
    0xDDC6, 0x841C,    /* '萜' -> 33820 */
    0xDDC7, 0x8438,    /* '萸' -> 33848 */
    0xDDC8, 0x8411,    /* '萑' -> 33809 */
    0xDDC9, 0x8406,    /* '萆' -> 33798 */
    0xDDCA, 0x83D4,    /* '菔' -> 33748 */
    0xDDCB, 0x83DF,    /* '菟' -> 33759 */
    0xDDCC, 0x840F,    /* '萏' -> 33807 */
    0xDDCD, 0x8403,    /* '萃' -> 33795 */
    0xDDCE, 0x83F8,    /* '菸' -> 33784 */
    0xDDCF, 0x83F9,    /* '菹' -> 33785 */
    0xDDD0, 0x83EA,    /* '菪' -> 33770 */
    0xDDD1, 0x83C5,    /* '菅' -> 33733 */
    0xDDD2, 0x83C0,    /* '菀' -> 33728 */
    0xDDD3, 0x8426,    /* '萦' -> 33830 */
    0xDDD4, 0x83F0,    /* '菰' -> 33776 */
    0xDDD5, 0x83E1,    /* '菡' -> 33761 */
    0xDDD6, 0x845C,    /* '葜' -> 33884 */
    0xDDD7, 0x8451,    /* '葑' -> 33873 */
    0xDDD8, 0x845A,    /* '葚' -> 33882 */
    0xDDD9, 0x8459,    /* '葙' -> 33881 */
    0xDDDA, 0x8473,    /* '葳' -> 33907 */
    0xDDDB, 0x8487,    /* '蒇' -> 33927 */
    0xDDDC, 0x8488,    /* '蒈' -> 33928 */
    0xDDDD, 0x847A,    /* '葺' -> 33914 */
    0xDDDE, 0x8489,    /* '蒉' -> 33929 */
    0xDDDF, 0x8478,    /* '葸' -> 33912 */
    0xDDE0, 0x843C,    /* '萼' -> 33852 */
    0xDDE1, 0x8446,    /* '葆' -> 33862 */
    0xDDE2, 0x8469,    /* '葩' -> 33897 */
    0xDDE3, 0x8476,    /* '葶' -> 33910 */
    0xDDE4, 0x848C,    /* '蒌' -> 33932 */
    0xDDE5, 0x848E,    /* '蒎' -> 33934 */
    0xDDE6, 0x8431,    /* '萱' -> 33841 */
    0xDDE7, 0x846D,    /* '葭' -> 33901 */
    0xDDE8, 0x84C1,    /* '蓁' -> 33985 */
    0xDDE9, 0x84CD,    /* '蓍' -> 33997 */
    0xDDEA, 0x84D0,    /* '蓐' -> 34000 */
    0xDDEB, 0x84E6,    /* '蓦' -> 34022 */
    0xDDEC, 0x84BD,    /* '蒽' -> 33981 */
    0xDDED, 0x84D3,    /* '蓓' -> 34003 */
    0xDDEE, 0x84CA,    /* '蓊' -> 33994 */
    0xDDEF, 0x84BF,    /* '蒿' -> 33983 */
    0xDDF0, 0x84BA,    /* '蒺' -> 33978 */
    0xDDF1, 0x84E0,    /* '蓠' -> 34016 */
    0xDDF2, 0x84A1,    /* '蒡' -> 33953 */
    0xDDF3, 0x84B9,    /* '蒹' -> 33977 */
    0xDDF4, 0x84B4,    /* '蒴' -> 33972 */
    0xDDF5, 0x8497,    /* '蒗' -> 33943 */
    0xDDF6, 0x84E5,    /* '蓥' -> 34021 */
    0xDDF7, 0x84E3,    /* '蓣' -> 34019 */
    0xDDF8, 0x850C,    /* '蔌' -> 34060 */
    0xDDF9, 0x750D,    /* '甍' -> 29965 */
    0xDDFA, 0x8538,    /* '蔸' -> 34104 */
    0xDDFB, 0x84F0,    /* '蓰' -> 34032 */
    0xDDFC, 0x8539,    /* '蔹' -> 34105 */
    0xDDFD, 0x851F,    /* '蔟' -> 34079 */
    0xDDFE, 0x853A,    /* '蔺' -> 34106 */
    0xDEA1, 0x8556,    /* '蕖' -> 34134 */
    0xDEA2, 0x853B,    /* '蔻' -> 34107 */
    0xDEA3, 0x84FF,    /* '蓿' -> 34047 */
    0xDEA4, 0x84FC,    /* '蓼' -> 34044 */
    0xDEA5, 0x8559,    /* '蕙' -> 34137 */
    0xDEA6, 0x8548,    /* '蕈' -> 34120 */
    0xDEA7, 0x8568,    /* '蕨' -> 34152 */
    0xDEA8, 0x8564,    /* '蕤' -> 34148 */
    0xDEA9, 0x855E,    /* '蕞' -> 34142 */
    0xDEAA, 0x857A,    /* '蕺' -> 34170 */
    0xDEAB, 0x77A2,    /* '瞢' -> 30626 */
    0xDEAC, 0x8543,    /* '蕃' -> 34115 */
    0xDEAD, 0x8572,    /* '蕲' -> 34162 */
    0xDEAE, 0x857B,    /* '蕻' -> 34171 */
    0xDEAF, 0x85A4,    /* '薤' -> 34212 */
    0xDEB0, 0x85A8,    /* '薨' -> 34216 */
    0xDEB1, 0x8587,    /* '薇' -> 34183 */
    0xDEB2, 0x858F,    /* '薏' -> 34191 */
    0xDEB3, 0x8579,    /* '蕹' -> 34169 */
    0xDEB4, 0x85AE,    /* '薮' -> 34222 */
    0xDEB5, 0x859C,    /* '薜' -> 34204 */
    0xDEB6, 0x8585,    /* '薅' -> 34181 */
    0xDEB7, 0x85B9,    /* '薹' -> 34233 */
    0xDEB8, 0x85B7,    /* '薷' -> 34231 */
    0xDEB9, 0x85B0,    /* '薰' -> 34224 */
    0xDEBA, 0x85D3,    /* '藓' -> 34259 */
    0xDEBB, 0x85C1,    /* '藁' -> 34241 */
    0xDEBC, 0x85DC,    /* '藜' -> 34268 */
    0xDEBD, 0x85FF,    /* '藿' -> 34303 */
    0xDEBE, 0x8627,    /* '蘧' -> 34343 */
    0xDEBF, 0x8605,    /* '蘅' -> 34309 */
    0xDEC0, 0x8629,    /* '蘩' -> 34345 */
    0xDEC1, 0x8616,    /* '蘖' -> 34326 */
    0xDEC2, 0x863C,    /* '蘼' -> 34364 */
    0xDEC3, 0x5EFE,    /* '廾' -> 24318 */
    0xDEC4, 0x5F08,    /* '弈' -> 24328 */
    0xDEC5, 0x593C,    /* '夼' -> 22844 */
    0xDEC6, 0x5941,    /* '奁' -> 22849 */
    0xDEC7, 0x8037,    /* '耷' -> 32823 */
    0xDEC8, 0x5955,    /* '奕' -> 22869 */
    0xDEC9, 0x595A,    /* '奚' -> 22874 */
    0xDECA, 0x5958,    /* '奘' -> 22872 */
    0xDECB, 0x530F,    /* '匏' -> 21263 */
    0xDECC, 0x5C22,    /* '尢' -> 23586 */
    0xDECD, 0x5C25,    /* '尥' -> 23589 */
    0xDECE, 0x5C2C,    /* '尬' -> 23596 */
    0xDECF, 0x5C34,    /* '尴' -> 23604 */
    0xDED0, 0x624C,    /* '扌' -> 25164 */
    0xDED1, 0x626A,    /* '扪' -> 25194 */
    0xDED2, 0x629F,    /* '抟' -> 25247 */
    0xDED3, 0x62BB,    /* '抻' -> 25275 */
    0xDED4, 0x62CA,    /* '拊' -> 25290 */
    0xDED5, 0x62DA,    /* '拚' -> 25306 */
    0xDED6, 0x62D7,    /* '拗' -> 25303 */
    0xDED7, 0x62EE,    /* '拮' -> 25326 */
    0xDED8, 0x6322,    /* '挢' -> 25378 */
    0xDED9, 0x62F6,    /* '拶' -> 25334 */
    0xDEDA, 0x6339,    /* '挹' -> 25401 */
    0xDEDB, 0x634B,    /* '捋' -> 25419 */
    0xDEDC, 0x6343,    /* '捃' -> 25411 */
    0xDEDD, 0x63AD,    /* '掭' -> 25517 */
    0xDEDE, 0x63F6,    /* '揶' -> 25590 */
    0xDEDF, 0x6371,    /* '捱' -> 25457 */
    0xDEE0, 0x637A,    /* '捺' -> 25466 */
    0xDEE1, 0x638E,    /* '掎' -> 25486 */
    0xDEE2, 0x63B4,    /* '掴' -> 25524 */
    0xDEE3, 0x636D,    /* '捭' -> 25453 */
    0xDEE4, 0x63AC,    /* '掬' -> 25516 */
    0xDEE5, 0x638A,    /* '掊' -> 25482 */
    0xDEE6, 0x6369,    /* '捩' -> 25449 */
    0xDEE7, 0x63AE,    /* '掮' -> 25518 */
    0xDEE8, 0x63BC,    /* '掼' -> 25532 */
    0xDEE9, 0x63F2,    /* '揲' -> 25586 */
    0xDEEA, 0x63F8,    /* '揸' -> 25592 */
    0xDEEB, 0x63E0,    /* '揠' -> 25568 */
    0xDEEC, 0x63FF,    /* '揿' -> 25599 */
    0xDEED, 0x63C4,    /* '揄' -> 25540 */
    0xDEEE, 0x63DE,    /* '揞' -> 25566 */
    0xDEEF, 0x63CE,    /* '揎' -> 25550 */
    0xDEF0, 0x6452,    /* '摒' -> 25682 */
    0xDEF1, 0x63C6,    /* '揆' -> 25542 */
    0xDEF2, 0x63BE,    /* '掾' -> 25534 */
    0xDEF3, 0x6445,    /* '摅' -> 25669 */
    0xDEF4, 0x6441,    /* '摁' -> 25665 */
    0xDEF5, 0x640B,    /* '搋' -> 25611 */
    0xDEF6, 0x641B,    /* '搛' -> 25627 */
    0xDEF7, 0x6420,    /* '搠' -> 25632 */
    0xDEF8, 0x640C,    /* '搌' -> 25612 */
    0xDEF9, 0x6426,    /* '搦' -> 25638 */
    0xDEFA, 0x6421,    /* '搡' -> 25633 */
    0xDEFB, 0x645E,    /* '摞' -> 25694 */
    0xDEFC, 0x6484,    /* '撄' -> 25732 */
    0xDEFD, 0x646D,    /* '摭' -> 25709 */
    0xDEFE, 0x6496,    /* '撖' -> 25750 */
    0xDFA1, 0x647A,    /* '摺' -> 25722 */
    0xDFA2, 0x64B7,    /* '撷' -> 25783 */
    0xDFA3, 0x64B8,    /* '撸' -> 25784 */
    0xDFA4, 0x6499,    /* '撙' -> 25753 */
    0xDFA5, 0x64BA,    /* '撺' -> 25786 */
    0xDFA6, 0x64C0,    /* '擀' -> 25792 */
    0xDFA7, 0x64D0,    /* '擐' -> 25808 */
    0xDFA8, 0x64D7,    /* '擗' -> 25815 */
    0xDFA9, 0x64E4,    /* '擤' -> 25828 */
    0xDFAA, 0x64E2,    /* '擢' -> 25826 */
    0xDFAB, 0x6509,    /* '攉' -> 25865 */
    0xDFAC, 0x6525,    /* '攥' -> 25893 */
    0xDFAD, 0x652E,    /* '攮' -> 25902 */
    0xDFAE, 0x5F0B,    /* '弋' -> 24331 */
    0xDFAF, 0x5FD2,    /* '忒' -> 24530 */
    0xDFB0, 0x7519,    /* '甙' -> 29977 */
    0xDFB1, 0x5F11,    /* '弑' -> 24337 */
    0xDFB2, 0x535F,    /* '卟' -> 21343 */
    0xDFB3, 0x53F1,    /* '叱' -> 21489 */
    0xDFB4, 0x53FD,    /* '叽' -> 21501 */
    0xDFB5, 0x53E9,    /* '叩' -> 21481 */
    0xDFB6, 0x53E8,    /* '叨' -> 21480 */
    0xDFB7, 0x53FB,    /* '叻' -> 21499 */
    0xDFB8, 0x5412,    /* '吒' -> 21522 */
    0xDFB9, 0x5416,    /* '吖' -> 21526 */
    0xDFBA, 0x5406,    /* '吆' -> 21510 */
    0xDFBB, 0x544B,    /* '呋' -> 21579 */
    0xDFBC, 0x5452,    /* '呒' -> 21586 */
    0xDFBD, 0x5453,    /* '呓' -> 21587 */
    0xDFBE, 0x5454,    /* '呔' -> 21588 */
    0xDFBF, 0x5456,    /* '呖' -> 21590 */
    0xDFC0, 0x5443,    /* '呃' -> 21571 */
    0xDFC1, 0x5421,    /* '吡' -> 21537 */
    0xDFC2, 0x5457,    /* '呗' -> 21591 */
    0xDFC3, 0x5459,    /* '呙' -> 21593 */
    0xDFC4, 0x5423,    /* '吣' -> 21539 */
    0xDFC5, 0x5432,    /* '吲' -> 21554 */
    0xDFC6, 0x5482,    /* '咂' -> 21634 */
    0xDFC7, 0x5494,    /* '咔' -> 21652 */
    0xDFC8, 0x5477,    /* '呷' -> 21623 */
    0xDFC9, 0x5471,    /* '呱' -> 21617 */
    0xDFCA, 0x5464,    /* '呤' -> 21604 */
    0xDFCB, 0x549A,    /* '咚' -> 21658 */
    0xDFCC, 0x549B,    /* '咛' -> 21659 */
    0xDFCD, 0x5484,    /* '咄' -> 21636 */
    0xDFCE, 0x5476,    /* '呶' -> 21622 */
    0xDFCF, 0x5466,    /* '呦' -> 21606 */
    0xDFD0, 0x549D,    /* '咝' -> 21661 */
    0xDFD1, 0x54D0,    /* '哐' -> 21712 */
    0xDFD2, 0x54AD,    /* '咭' -> 21677 */
    0xDFD3, 0x54C2,    /* '哂' -> 21698 */
    0xDFD4, 0x54B4,    /* '咴' -> 21684 */
    0xDFD5, 0x54D2,    /* '哒' -> 21714 */
    0xDFD6, 0x54A7,    /* '咧' -> 21671 */
    0xDFD7, 0x54A6,    /* '咦' -> 21670 */
    0xDFD8, 0x54D3,    /* '哓' -> 21715 */
    0xDFD9, 0x54D4,    /* '哔' -> 21716 */
    0xDFDA, 0x5472,    /* '呲' -> 21618 */
    0xDFDB, 0x54A3,    /* '咣' -> 21667 */
    0xDFDC, 0x54D5,    /* '哕' -> 21717 */
    0xDFDD, 0x54BB,    /* '咻' -> 21691 */
    0xDFDE, 0x54BF,    /* '咿' -> 21695 */
    0xDFDF, 0x54CC,    /* '哌' -> 21708 */
    0xDFE0, 0x54D9,    /* '哙' -> 21721 */
    0xDFE1, 0x54DA,    /* '哚' -> 21722 */
    0xDFE2, 0x54DC,    /* '哜' -> 21724 */
    0xDFE3, 0x54A9,    /* '咩' -> 21673 */
    0xDFE4, 0x54AA,    /* '咪' -> 21674 */
    0xDFE5, 0x54A4,    /* '咤' -> 21668 */
    0xDFE6, 0x54DD,    /* '哝' -> 21725 */
    0xDFE7, 0x54CF,    /* '哏' -> 21711 */
    0xDFE8, 0x54DE,    /* '哞' -> 21726 */
    0xDFE9, 0x551B,    /* '唛' -> 21787 */
    0xDFEA, 0x54E7,    /* '哧' -> 21735 */
    0xDFEB, 0x5520,    /* '唠' -> 21792 */
    0xDFEC, 0x54FD,    /* '哽' -> 21757 */
    0xDFED, 0x5514,    /* '唔' -> 21780 */
    0xDFEE, 0x54F3,    /* '哳' -> 21747 */
    0xDFEF, 0x5522,    /* '唢' -> 21794 */
    0xDFF0, 0x5523,    /* '唣' -> 21795 */
    0xDFF1, 0x550F,    /* '唏' -> 21775 */
    0xDFF2, 0x5511,    /* '唑' -> 21777 */
    0xDFF3, 0x5527,    /* '唧' -> 21799 */
    0xDFF4, 0x552A,    /* '唪' -> 21802 */
    0xDFF5, 0x5567,    /* '啧' -> 21863 */
    0xDFF6, 0x558F,    /* '喏' -> 21903 */
    0xDFF7, 0x55B5,    /* '喵' -> 21941 */
    0xDFF8, 0x5549,    /* '啉' -> 21833 */
    0xDFF9, 0x556D,    /* '啭' -> 21869 */
    0xDFFA, 0x5541,    /* '啁' -> 21825 */
    0xDFFB, 0x5555,    /* '啕' -> 21845 */
    0xDFFC, 0x553F,    /* '唿' -> 21823 */
    0xDFFD, 0x5550,    /* '啐' -> 21840 */
    0xDFFE, 0x553C,    /* '唼' -> 21820 */
    0xE0A1, 0x5537,    /* '唷' -> 21815 */
    0xE0A2, 0x5556,    /* '啖' -> 21846 */
    0xE0A3, 0x5575,    /* '啵' -> 21877 */
    0xE0A4, 0x5576,    /* '啶' -> 21878 */
    0xE0A5, 0x5577,    /* '啷' -> 21879 */
    0xE0A6, 0x5533,    /* '唳' -> 21811 */
    0xE0A7, 0x5530,    /* '唰' -> 21808 */
    0xE0A8, 0x555C,    /* '啜' -> 21852 */
    0xE0A9, 0x558B,    /* '喋' -> 21899 */
    0xE0AA, 0x55D2,    /* '嗒' -> 21970 */
    0xE0AB, 0x5583,    /* '喃' -> 21891 */
    0xE0AC, 0x55B1,    /* '喱' -> 21937 */
    0xE0AD, 0x55B9,    /* '喹' -> 21945 */
    0xE0AE, 0x5588,    /* '喈' -> 21896 */
    0xE0AF, 0x5581,    /* '喁' -> 21889 */
    0xE0B0, 0x559F,    /* '喟' -> 21919 */
    0xE0B1, 0x557E,    /* '啾' -> 21886 */
    0xE0B2, 0x55D6,    /* '嗖' -> 21974 */
    0xE0B3, 0x5591,    /* '喑' -> 21905 */
    0xE0B4, 0x557B,    /* '啻' -> 21883 */
    0xE0B5, 0x55DF,    /* '嗟' -> 21983 */
    0xE0B6, 0x55BD,    /* '喽' -> 21949 */
    0xE0B7, 0x55BE,    /* '喾' -> 21950 */
    0xE0B8, 0x5594,    /* '喔' -> 21908 */
    0xE0B9, 0x5599,    /* '喙' -> 21913 */
    0xE0BA, 0x55EA,    /* '嗪' -> 21994 */
    0xE0BB, 0x55F7,    /* '嗷' -> 22007 */
    0xE0BC, 0x55C9,    /* '嗉' -> 21961 */
    0xE0BD, 0x561F,    /* '嘟' -> 22047 */
    0xE0BE, 0x55D1,    /* '嗑' -> 21969 */
    0xE0BF, 0x55EB,    /* '嗫' -> 21995 */
    0xE0C0, 0x55EC,    /* '嗬' -> 21996 */
    0xE0C1, 0x55D4,    /* '嗔' -> 21972 */
    0xE0C2, 0x55E6,    /* '嗦' -> 21990 */
    0xE0C3, 0x55DD,    /* '嗝' -> 21981 */
    0xE0C4, 0x55C4,    /* '嗄' -> 21956 */
    0xE0C5, 0x55EF,    /* '嗯' -> 21999 */
    0xE0C6, 0x55E5,    /* '嗥' -> 21989 */
    0xE0C7, 0x55F2,    /* '嗲' -> 22002 */
    0xE0C8, 0x55F3,    /* '嗳' -> 22003 */
    0xE0C9, 0x55CC,    /* '嗌' -> 21964 */
    0xE0CA, 0x55CD,    /* '嗍' -> 21965 */
    0xE0CB, 0x55E8,    /* '嗨' -> 21992 */
    0xE0CC, 0x55F5,    /* '嗵' -> 22005 */
    0xE0CD, 0x55E4,    /* '嗤' -> 21988 */
    0xE0CE, 0x8F94,    /* '辔' -> 36756 */
    0xE0CF, 0x561E,    /* '嘞' -> 22046 */
    0xE0D0, 0x5608,    /* '嘈' -> 22024 */
    0xE0D1, 0x560C,    /* '嘌' -> 22028 */
    0xE0D2, 0x5601,    /* '嘁' -> 22017 */
    0xE0D3, 0x5624,    /* '嘤' -> 22052 */
    0xE0D4, 0x5623,    /* '嘣' -> 22051 */
    0xE0D5, 0x55FE,    /* '嗾' -> 22014 */
    0xE0D6, 0x5600,    /* '嘀' -> 22016 */
    0xE0D7, 0x5627,    /* '嘧' -> 22055 */
    0xE0D8, 0x562D,    /* '嘭' -> 22061 */
    0xE0D9, 0x5658,    /* '噘' -> 22104 */
    0xE0DA, 0x5639,    /* '嘹' -> 22073 */
    0xE0DB, 0x5657,    /* '噗' -> 22103 */
    0xE0DC, 0x562C,    /* '嘬' -> 22060 */
    0xE0DD, 0x564D,    /* '噍' -> 22093 */
    0xE0DE, 0x5662,    /* '噢' -> 22114 */
    0xE0DF, 0x5659,    /* '噙' -> 22105 */
    0xE0E0, 0x565C,    /* '噜' -> 22108 */
    0xE0E1, 0x564C,    /* '噌' -> 22092 */
    0xE0E2, 0x5654,    /* '噔' -> 22100 */
    0xE0E3, 0x5686,    /* '嚆' -> 22150 */
    0xE0E4, 0x5664,    /* '噤' -> 22116 */
    0xE0E5, 0x5671,    /* '噱' -> 22129 */
    0xE0E6, 0x566B,    /* '噫' -> 22123 */
    0xE0E7, 0x567B,    /* '噻' -> 22139 */
    0xE0E8, 0x567C,    /* '噼' -> 22140 */
    0xE0E9, 0x5685,    /* '嚅' -> 22149 */
    0xE0EA, 0x5693,    /* '嚓' -> 22163 */
    0xE0EB, 0x56AF,    /* '嚯' -> 22191 */
    0xE0EC, 0x56D4,    /* '囔' -> 22228 */
    0xE0ED, 0x56D7,    /* '囗' -> 22231 */
    0xE0EE, 0x56DD,    /* '囝' -> 22237 */
    0xE0EF, 0x56E1,    /* '囡' -> 22241 */
    0xE0F0, 0x56F5,    /* '囵' -> 22261 */
    0xE0F1, 0x56EB,    /* '囫' -> 22251 */
    0xE0F2, 0x56F9,    /* '囹' -> 22265 */
    0xE0F3, 0x56FF,    /* '囿' -> 22271 */
    0xE0F4, 0x5704,    /* '圄' -> 22276 */
    0xE0F5, 0x570A,    /* '圊' -> 22282 */
    0xE0F6, 0x5709,    /* '圉' -> 22281 */
    0xE0F7, 0x571C,    /* '圜' -> 22300 */
    0xE0F8, 0x5E0F,    /* '帏' -> 24079 */
    0xE0F9, 0x5E19,    /* '帙' -> 24089 */
    0xE0FA, 0x5E14,    /* '帔' -> 24084 */
    0xE0FB, 0x5E11,    /* '帑' -> 24081 */
    0xE0FC, 0x5E31,    /* '帱' -> 24113 */
    0xE0FD, 0x5E3B,    /* '帻' -> 24123 */
    0xE0FE, 0x5E3C,    /* '帼' -> 24124 */
    0xE1A1, 0x5E37,    /* '帷' -> 24119 */
    0xE1A2, 0x5E44,    /* '幄' -> 24132 */
    0xE1A3, 0x5E54,    /* '幔' -> 24148 */
    0xE1A4, 0x5E5B,    /* '幛' -> 24155 */
    0xE1A5, 0x5E5E,    /* '幞' -> 24158 */
    0xE1A6, 0x5E61,    /* '幡' -> 24161 */
    0xE1A7, 0x5C8C,    /* '岌' -> 23692 */
    0xE1A8, 0x5C7A,    /* '屺' -> 23674 */
    0xE1A9, 0x5C8D,    /* '岍' -> 23693 */
    0xE1AA, 0x5C90,    /* '岐' -> 23696 */
    0xE1AB, 0x5C96,    /* '岖' -> 23702 */
    0xE1AC, 0x5C88,    /* '岈' -> 23688 */
    0xE1AD, 0x5C98,    /* '岘' -> 23704 */
    0xE1AE, 0x5C99,    /* '岙' -> 23705 */
    0xE1AF, 0x5C91,    /* '岑' -> 23697 */
    0xE1B0, 0x5C9A,    /* '岚' -> 23706 */
    0xE1B1, 0x5C9C,    /* '岜' -> 23708 */
    0xE1B2, 0x5CB5,    /* '岵' -> 23733 */
    0xE1B3, 0x5CA2,    /* '岢' -> 23714 */
    0xE1B4, 0x5CBD,    /* '岽' -> 23741 */
    0xE1B5, 0x5CAC,    /* '岬' -> 23724 */
    0xE1B6, 0x5CAB,    /* '岫' -> 23723 */
    0xE1B7, 0x5CB1,    /* '岱' -> 23729 */
    0xE1B8, 0x5CA3,    /* '岣' -> 23715 */
    0xE1B9, 0x5CC1,    /* '峁' -> 23745 */
    0xE1BA, 0x5CB7,    /* '岷' -> 23735 */
    0xE1BB, 0x5CC4,    /* '峄' -> 23748 */
    0xE1BC, 0x5CD2,    /* '峒' -> 23762 */
    0xE1BD, 0x5CE4,    /* '峤' -> 23780 */
    0xE1BE, 0x5CCB,    /* '峋' -> 23755 */
    0xE1BF, 0x5CE5,    /* '峥' -> 23781 */
    0xE1C0, 0x5D02,    /* '崂' -> 23810 */
    0xE1C1, 0x5D03,    /* '崃' -> 23811 */
    0xE1C2, 0x5D27,    /* '崧' -> 23847 */
    0xE1C3, 0x5D26,    /* '崦' -> 23846 */
    0xE1C4, 0x5D2E,    /* '崮' -> 23854 */
    0xE1C5, 0x5D24,    /* '崤' -> 23844 */
    0xE1C6, 0x5D1E,    /* '崞' -> 23838 */
    0xE1C7, 0x5D06,    /* '崆' -> 23814 */
    0xE1C8, 0x5D1B,    /* '崛' -> 23835 */
    0xE1C9, 0x5D58,    /* '嵘' -> 23896 */
    0xE1CA, 0x5D3E,    /* '崾' -> 23870 */
    0xE1CB, 0x5D34,    /* '崴' -> 23860 */
    0xE1CC, 0x5D3D,    /* '崽' -> 23869 */
    0xE1CD, 0x5D6C,    /* '嵬' -> 23916 */
    0xE1CE, 0x5D5B,    /* '嵛' -> 23899 */
    0xE1CF, 0x5D6F,    /* '嵯' -> 23919 */
    0xE1D0, 0x5D5D,    /* '嵝' -> 23901 */
    0xE1D1, 0x5D6B,    /* '嵫' -> 23915 */
    0xE1D2, 0x5D4B,    /* '嵋' -> 23883 */
    0xE1D3, 0x5D4A,    /* '嵊' -> 23882 */
    0xE1D4, 0x5D69,    /* '嵩' -> 23913 */
    0xE1D5, 0x5D74,    /* '嵴' -> 23924 */
    0xE1D6, 0x5D82,    /* '嶂' -> 23938 */
    0xE1D7, 0x5D99,    /* '嶙' -> 23961 */
    0xE1D8, 0x5D9D,    /* '嶝' -> 23965 */
    0xE1D9, 0x8C73,    /* '豳' -> 35955 */
    0xE1DA, 0x5DB7,    /* '嶷' -> 23991 */
    0xE1DB, 0x5DC5,    /* '巅' -> 24005 */
    0xE1DC, 0x5F73,    /* '彳' -> 24435 */
    0xE1DD, 0x5F77,    /* '彷' -> 24439 */
    0xE1DE, 0x5F82,    /* '徂' -> 24450 */
    0xE1DF, 0x5F87,    /* '徇' -> 24455 */
    0xE1E0, 0x5F89,    /* '徉' -> 24457 */
    0xE1E1, 0x5F8C,    /* '後' -> 24460 */
    0xE1E2, 0x5F95,    /* '徕' -> 24469 */
    0xE1E3, 0x5F99,    /* '徙' -> 24473 */
    0xE1E4, 0x5F9C,    /* '徜' -> 24476 */
    0xE1E5, 0x5FA8,    /* '徨' -> 24488 */
    0xE1E6, 0x5FAD,    /* '徭' -> 24493 */
    0xE1E7, 0x5FB5,    /* '徵' -> 24501 */
    0xE1E8, 0x5FBC,    /* '徼' -> 24508 */
    0xE1E9, 0x8862,    /* '衢' -> 34914 */
    0xE1EA, 0x5F61,    /* '彡' -> 24417 */
    0xE1EB, 0x72AD,    /* '犭' -> 29357 */
    0xE1EC, 0x72B0,    /* '犰' -> 29360 */
    0xE1ED, 0x72B4,    /* '犴' -> 29364 */
    0xE1EE, 0x72B7,    /* '犷' -> 29367 */
    0xE1EF, 0x72B8,    /* '犸' -> 29368 */
    0xE1F0, 0x72C3,    /* '狃' -> 29379 */
    0xE1F1, 0x72C1,    /* '狁' -> 29377 */
    0xE1F2, 0x72CE,    /* '狎' -> 29390 */
    0xE1F3, 0x72CD,    /* '狍' -> 29389 */
    0xE1F4, 0x72D2,    /* '狒' -> 29394 */
    0xE1F5, 0x72E8,    /* '狨' -> 29416 */
    0xE1F6, 0x72EF,    /* '狯' -> 29423 */
    0xE1F7, 0x72E9,    /* '狩' -> 29417 */
    0xE1F8, 0x72F2,    /* '狲' -> 29426 */
    0xE1F9, 0x72F4,    /* '狴' -> 29428 */
    0xE1FA, 0x72F7,    /* '狷' -> 29431 */
    0xE1FB, 0x7301,    /* '猁' -> 29441 */
    0xE1FC, 0x72F3,    /* '狳' -> 29427 */
    0xE1FD, 0x7303,    /* '猃' -> 29443 */
    0xE1FE, 0x72FA,    /* '狺' -> 29434 */
    0xE2A1, 0x72FB,    /* '狻' -> 29435 */
    0xE2A2, 0x7317,    /* '猗' -> 29463 */
    0xE2A3, 0x7313,    /* '猓' -> 29459 */
    0xE2A4, 0x7321,    /* '猡' -> 29473 */
    0xE2A5, 0x730A,    /* '猊' -> 29450 */
    0xE2A6, 0x731E,    /* '猞' -> 29470 */
    0xE2A7, 0x731D,    /* '猝' -> 29469 */
    0xE2A8, 0x7315,    /* '猕' -> 29461 */
    0xE2A9, 0x7322,    /* '猢' -> 29474 */
    0xE2AA, 0x7339,    /* '猹' -> 29497 */
    0xE2AB, 0x7325,    /* '猥' -> 29477 */
    0xE2AC, 0x732C,    /* '猬' -> 29484 */
    0xE2AD, 0x7338,    /* '猸' -> 29496 */
    0xE2AE, 0x7331,    /* '猱' -> 29489 */
    0xE2AF, 0x7350,    /* '獐' -> 29520 */
    0xE2B0, 0x734D,    /* '獍' -> 29517 */
    0xE2B1, 0x7357,    /* '獗' -> 29527 */
    0xE2B2, 0x7360,    /* '獠' -> 29536 */
    0xE2B3, 0x736C,    /* '獬' -> 29548 */
    0xE2B4, 0x736F,    /* '獯' -> 29551 */
    0xE2B5, 0x737E,    /* '獾' -> 29566 */
    0xE2B6, 0x821B,    /* '舛' -> 33307 */
    0xE2B7, 0x5925,    /* '夥' -> 22821 */
    0xE2B8, 0x98E7,    /* '飧' -> 39143 */
    0xE2B9, 0x5924,    /* '夤' -> 22820 */
    0xE2BA, 0x5902,    /* '夂' -> 22786 */
    0xE2BB, 0x9963,    /* '饣' -> 39267 */
    0xE2BC, 0x9967,    /* '饧' -> 39271 */
    0xE2BD, 0x9968,    /* '饨' -> 39272 */
    0xE2BE, 0x9969,    /* '饩' -> 39273 */
    0xE2BF, 0x996A,    /* '饪' -> 39274 */
    0xE2C0, 0x996B,    /* '饫' -> 39275 */
    0xE2C1, 0x996C,    /* '饬' -> 39276 */
    0xE2C2, 0x9974,    /* '饴' -> 39284 */
    0xE2C3, 0x9977,    /* '饷' -> 39287 */
    0xE2C4, 0x997D,    /* '饽' -> 39293 */
    0xE2C5, 0x9980,    /* '馀' -> 39296 */
    0xE2C6, 0x9984,    /* '馄' -> 39300 */
    0xE2C7, 0x9987,    /* '馇' -> 39303 */
    0xE2C8, 0x998A,    /* '馊' -> 39306 */
    0xE2C9, 0x998D,    /* '馍' -> 39309 */
    0xE2CA, 0x9990,    /* '馐' -> 39312 */
    0xE2CB, 0x9991,    /* '馑' -> 39313 */
    0xE2CC, 0x9993,    /* '馓' -> 39315 */
    0xE2CD, 0x9994,    /* '馔' -> 39316 */
    0xE2CE, 0x9995,    /* '馕' -> 39317 */
    0xE2CF, 0x5E80,    /* '庀' -> 24192 */
    0xE2D0, 0x5E91,    /* '庑' -> 24209 */
    0xE2D1, 0x5E8B,    /* '庋' -> 24203 */
    0xE2D2, 0x5E96,    /* '庖' -> 24214 */
    0xE2D3, 0x5EA5,    /* '庥' -> 24229 */
    0xE2D4, 0x5EA0,    /* '庠' -> 24224 */
    0xE2D5, 0x5EB9,    /* '庹' -> 24249 */
    0xE2D6, 0x5EB5,    /* '庵' -> 24245 */
    0xE2D7, 0x5EBE,    /* '庾' -> 24254 */
    0xE2D8, 0x5EB3,    /* '庳' -> 24243 */
    0xE2D9, 0x8D53,    /* '赓' -> 36179 */
    0xE2DA, 0x5ED2,    /* '廒' -> 24274 */
    0xE2DB, 0x5ED1,    /* '廑' -> 24273 */
    0xE2DC, 0x5EDB,    /* '廛' -> 24283 */
    0xE2DD, 0x5EE8,    /* '廨' -> 24296 */
    0xE2DE, 0x5EEA,    /* '廪' -> 24298 */
    0xE2DF, 0x81BA,    /* '膺' -> 33210 */
    0xE2E0, 0x5FC4,    /* '忄' -> 24516 */
    0xE2E1, 0x5FC9,    /* '忉' -> 24521 */
    0xE2E2, 0x5FD6,    /* '忖' -> 24534 */
    0xE2E3, 0x5FCF,    /* '忏' -> 24527 */
    0xE2E4, 0x6003,    /* '怃' -> 24579 */
    0xE2E5, 0x5FEE,    /* '忮' -> 24558 */
    0xE2E6, 0x6004,    /* '怄' -> 24580 */
    0xE2E7, 0x5FE1,    /* '忡' -> 24545 */
    0xE2E8, 0x5FE4,    /* '忤' -> 24548 */
    0xE2E9, 0x5FFE,    /* '忾' -> 24574 */
    0xE2EA, 0x6005,    /* '怅' -> 24581 */
    0xE2EB, 0x6006,    /* '怆' -> 24582 */
    0xE2EC, 0x5FEA,    /* '忪' -> 24554 */
    0xE2ED, 0x5FED,    /* '忭' -> 24557 */
    0xE2EE, 0x5FF8,    /* '忸' -> 24568 */
    0xE2EF, 0x6019,    /* '怙' -> 24601 */
    0xE2F0, 0x6035,    /* '怵' -> 24629 */
    0xE2F1, 0x6026,    /* '怦' -> 24614 */
    0xE2F2, 0x601B,    /* '怛' -> 24603 */
    0xE2F3, 0x600F,    /* '怏' -> 24591 */
    0xE2F4, 0x600D,    /* '怍' -> 24589 */
    0xE2F5, 0x6029,    /* '怩' -> 24617 */
    0xE2F6, 0x602B,    /* '怫' -> 24619 */
    0xE2F7, 0x600A,    /* '怊' -> 24586 */
    0xE2F8, 0x603F,    /* '怿' -> 24639 */
    0xE2F9, 0x6021,    /* '怡' -> 24609 */
    0xE2FA, 0x6078,    /* '恸' -> 24696 */
    0xE2FB, 0x6079,    /* '恹' -> 24697 */
    0xE2FC, 0x607B,    /* '恻' -> 24699 */
    0xE2FD, 0x607A,    /* '恺' -> 24698 */
    0xE2FE, 0x6042,    /* '恂' -> 24642 */
    0xE3A1, 0x606A,    /* '恪' -> 24682 */
    0xE3A2, 0x607D,    /* '恽' -> 24701 */
    0xE3A3, 0x6096,    /* '悖' -> 24726 */
    0xE3A4, 0x609A,    /* '悚' -> 24730 */
    0xE3A5, 0x60AD,    /* '悭' -> 24749 */
    0xE3A6, 0x609D,    /* '悝' -> 24733 */
    0xE3A7, 0x6083,    /* '悃' -> 24707 */
    0xE3A8, 0x6092,    /* '悒' -> 24722 */
    0xE3A9, 0x608C,    /* '悌' -> 24716 */
    0xE3AA, 0x609B,    /* '悛' -> 24731 */
    0xE3AB, 0x60EC,    /* '惬' -> 24812 */
    0xE3AC, 0x60BB,    /* '悻' -> 24763 */
    0xE3AD, 0x60B1,    /* '悱' -> 24753 */
    0xE3AE, 0x60DD,    /* '惝' -> 24797 */
    0xE3AF, 0x60D8,    /* '惘' -> 24792 */
    0xE3B0, 0x60C6,    /* '惆' -> 24774 */
    0xE3B1, 0x60DA,    /* '惚' -> 24794 */
    0xE3B2, 0x60B4,    /* '悴' -> 24756 */
    0xE3B3, 0x6120,    /* '愠' -> 24864 */
    0xE3B4, 0x6126,    /* '愦' -> 24870 */
    0xE3B5, 0x6115,    /* '愕' -> 24853 */
    0xE3B6, 0x6123,    /* '愣' -> 24867 */
    0xE3B7, 0x60F4,    /* '惴' -> 24820 */
    0xE3B8, 0x6100,    /* '愀' -> 24832 */
    0xE3B9, 0x610E,    /* '愎' -> 24846 */
    0xE3BA, 0x612B,    /* '愫' -> 24875 */
    0xE3BB, 0x614A,    /* '慊' -> 24906 */
    0xE3BC, 0x6175,    /* '慵' -> 24949 */
    0xE3BD, 0x61AC,    /* '憬' -> 25004 */
    0xE3BE, 0x6194,    /* '憔' -> 24980 */
    0xE3BF, 0x61A7,    /* '憧' -> 24999 */
    0xE3C0, 0x61B7,    /* '憷' -> 25015 */
    0xE3C1, 0x61D4,    /* '懔' -> 25044 */
    0xE3C2, 0x61F5,    /* '懵' -> 25077 */
    0xE3C3, 0x5FDD,    /* '忝' -> 24541 */
    0xE3C4, 0x96B3,    /* '隳' -> 38579 */
    0xE3C5, 0x95E9,    /* '闩' -> 38377 */
    0xE3C6, 0x95EB,    /* '闫' -> 38379 */
    0xE3C7, 0x95F1,    /* '闱' -> 38385 */
    0xE3C8, 0x95F3,    /* '闳' -> 38387 */
    0xE3C9, 0x95F5,    /* '闵' -> 38389 */
    0xE3CA, 0x95F6,    /* '闶' -> 38390 */
    0xE3CB, 0x95FC,    /* '闼' -> 38396 */
    0xE3CC, 0x95FE,    /* '闾' -> 38398 */
    0xE3CD, 0x9603,    /* '阃' -> 38403 */
    0xE3CE, 0x9604,    /* '阄' -> 38404 */
    0xE3CF, 0x9606,    /* '阆' -> 38406 */
    0xE3D0, 0x9608,    /* '阈' -> 38408 */
    0xE3D1, 0x960A,    /* '阊' -> 38410 */
    0xE3D2, 0x960B,    /* '阋' -> 38411 */
    0xE3D3, 0x960C,    /* '阌' -> 38412 */
    0xE3D4, 0x960D,    /* '阍' -> 38413 */
    0xE3D5, 0x960F,    /* '阏' -> 38415 */
    0xE3D6, 0x9612,    /* '阒' -> 38418 */
    0xE3D7, 0x9615,    /* '阕' -> 38421 */
    0xE3D8, 0x9616,    /* '阖' -> 38422 */
    0xE3D9, 0x9617,    /* '阗' -> 38423 */
    0xE3DA, 0x9619,    /* '阙' -> 38425 */
    0xE3DB, 0x961A,    /* '阚' -> 38426 */
    0xE3DC, 0x4E2C,    /* '丬' -> 20012 */
    0xE3DD, 0x723F,    /* '爿' -> 29247 */
    0xE3DE, 0x6215,    /* '戕' -> 25109 */
    0xE3DF, 0x6C35,    /* '氵' -> 27701 */
    0xE3E0, 0x6C54,    /* '汔' -> 27732 */
    0xE3E1, 0x6C5C,    /* '汜' -> 27740 */
    0xE3E2, 0x6C4A,    /* '汊' -> 27722 */
    0xE3E3, 0x6CA3,    /* '沣' -> 27811 */
    0xE3E4, 0x6C85,    /* '沅' -> 27781 */
    0xE3E5, 0x6C90,    /* '沐' -> 27792 */
    0xE3E6, 0x6C94,    /* '沔' -> 27796 */
    0xE3E7, 0x6C8C,    /* '沌' -> 27788 */
    0xE3E8, 0x6C68,    /* '汨' -> 27752 */
    0xE3E9, 0x6C69,    /* '汩' -> 27753 */
    0xE3EA, 0x6C74,    /* '汴' -> 27764 */
    0xE3EB, 0x6C76,    /* '汶' -> 27766 */
    0xE3EC, 0x6C86,    /* '沆' -> 27782 */
    0xE3ED, 0x6CA9,    /* '沩' -> 27817 */
    0xE3EE, 0x6CD0,    /* '泐' -> 27856 */
    0xE3EF, 0x6CD4,    /* '泔' -> 27860 */
    0xE3F0, 0x6CAD,    /* '沭' -> 27821 */
    0xE3F1, 0x6CF7,    /* '泷' -> 27895 */
    0xE3F2, 0x6CF8,    /* '泸' -> 27896 */
    0xE3F3, 0x6CF1,    /* '泱' -> 27889 */
    0xE3F4, 0x6CD7,    /* '泗' -> 27863 */
    0xE3F5, 0x6CB2,    /* '沲' -> 27826 */
    0xE3F6, 0x6CE0,    /* '泠' -> 27872 */
    0xE3F7, 0x6CD6,    /* '泖' -> 27862 */
    0xE3F8, 0x6CFA,    /* '泺' -> 27898 */
    0xE3F9, 0x6CEB,    /* '泫' -> 27883 */
    0xE3FA, 0x6CEE,    /* '泮' -> 27886 */
    0xE3FB, 0x6CB1,    /* '沱' -> 27825 */
    0xE3FC, 0x6CD3,    /* '泓' -> 27859 */
    0xE3FD, 0x6CEF,    /* '泯' -> 27887 */
    0xE3FE, 0x6CFE,    /* '泾' -> 27902 */
    0xE4A1, 0x6D39,    /* '洹' -> 27961 */
    0xE4A2, 0x6D27,    /* '洧' -> 27943 */
    0xE4A3, 0x6D0C,    /* '洌' -> 27916 */
    0xE4A4, 0x6D43,    /* '浃' -> 27971 */
    0xE4A5, 0x6D48,    /* '浈' -> 27976 */
    0xE4A6, 0x6D07,    /* '洇' -> 27911 */
    0xE4A7, 0x6D04,    /* '洄' -> 27908 */
    0xE4A8, 0x6D19,    /* '洙' -> 27929 */
    0xE4A9, 0x6D0E,    /* '洎' -> 27918 */
    0xE4AA, 0x6D2B,    /* '洫' -> 27947 */
    0xE4AB, 0x6D4D,    /* '浍' -> 27981 */
    0xE4AC, 0x6D2E,    /* '洮' -> 27950 */
    0xE4AD, 0x6D35,    /* '洵' -> 27957 */
    0xE4AE, 0x6D1A,    /* '洚' -> 27930 */
    0xE4AF, 0x6D4F,    /* '浏' -> 27983 */
    0xE4B0, 0x6D52,    /* '浒' -> 27986 */
    0xE4B1, 0x6D54,    /* '浔' -> 27988 */
    0xE4B2, 0x6D33,    /* '洳' -> 27955 */
    0xE4B3, 0x6D91,    /* '涑' -> 28049 */
    0xE4B4, 0x6D6F,    /* '浯' -> 28015 */
    0xE4B5, 0x6D9E,    /* '涞' -> 28062 */
    0xE4B6, 0x6DA0,    /* '涠' -> 28064 */
    0xE4B7, 0x6D5E,    /* '浞' -> 27998 */
    0xE4B8, 0x6D93,    /* '涓' -> 28051 */
    0xE4B9, 0x6D94,    /* '涔' -> 28052 */
    0xE4BA, 0x6D5C,    /* '浜' -> 27996 */
    0xE4BB, 0x6D60,    /* '浠' -> 28000 */
    0xE4BC, 0x6D7C,    /* '浼' -> 28028 */
    0xE4BD, 0x6D63,    /* '浣' -> 28003 */
    0xE4BE, 0x6E1A,    /* '渚' -> 28186 */
    0xE4BF, 0x6DC7,    /* '淇' -> 28103 */
    0xE4C0, 0x6DC5,    /* '淅' -> 28101 */
    0xE4C1, 0x6DDE,    /* '淞' -> 28126 */
    0xE4C2, 0x6E0E,    /* '渎' -> 28174 */
    0xE4C3, 0x6DBF,    /* '涿' -> 28095 */
    0xE4C4, 0x6DE0,    /* '淠' -> 28128 */
    0xE4C5, 0x6E11,    /* '渑' -> 28177 */
    0xE4C6, 0x6DE6,    /* '淦' -> 28134 */
    0xE4C7, 0x6DDD,    /* '淝' -> 28125 */
    0xE4C8, 0x6DD9,    /* '淙' -> 28121 */
    0xE4C9, 0x6E16,    /* '渖' -> 28182 */
    0xE4CA, 0x6DAB,    /* '涫' -> 28075 */
    0xE4CB, 0x6E0C,    /* '渌' -> 28172 */
    0xE4CC, 0x6DAE,    /* '涮' -> 28078 */
    0xE4CD, 0x6E2B,    /* '渫' -> 28203 */
    0xE4CE, 0x6E6E,    /* '湮' -> 28270 */
    0xE4CF, 0x6E4E,    /* '湎' -> 28238 */
    0xE4D0, 0x6E6B,    /* '湫' -> 28267 */
    0xE4D1, 0x6EB2,    /* '溲' -> 28338 */
    0xE4D2, 0x6E5F,    /* '湟' -> 28255 */
    0xE4D3, 0x6E86,    /* '溆' -> 28294 */
    0xE4D4, 0x6E53,    /* '湓' -> 28243 */
    0xE4D5, 0x6E54,    /* '湔' -> 28244 */
    0xE4D6, 0x6E32,    /* '渲' -> 28210 */
    0xE4D7, 0x6E25,    /* '渥' -> 28197 */
    0xE4D8, 0x6E44,    /* '湄' -> 28228 */
    0xE4D9, 0x6EDF,    /* '滟' -> 28383 */
    0xE4DA, 0x6EB1,    /* '溱' -> 28337 */
    0xE4DB, 0x6E98,    /* '溘' -> 28312 */
    0xE4DC, 0x6EE0,    /* '滠' -> 28384 */
    0xE4DD, 0x6F2D,    /* '漭' -> 28461 */
    0xE4DE, 0x6EE2,    /* '滢' -> 28386 */
    0xE4DF, 0x6EA5,    /* '溥' -> 28325 */
    0xE4E0, 0x6EA7,    /* '溧' -> 28327 */
    0xE4E1, 0x6EBD,    /* '溽' -> 28349 */
    0xE4E2, 0x6EBB,    /* '溻' -> 28347 */
    0xE4E3, 0x6EB7,    /* '溷' -> 28343 */
    0xE4E4, 0x6ED7,    /* '滗' -> 28375 */
    0xE4E5, 0x6EB4,    /* '溴' -> 28340 */
    0xE4E6, 0x6ECF,    /* '滏' -> 28367 */
    0xE4E7, 0x6E8F,    /* '溏' -> 28303 */
    0xE4E8, 0x6EC2,    /* '滂' -> 28354 */
    0xE4E9, 0x6E9F,    /* '溟' -> 28319 */
    0xE4EA, 0x6F62,    /* '潢' -> 28514 */
    0xE4EB, 0x6F46,    /* '潆' -> 28486 */
    0xE4EC, 0x6F47,    /* '潇' -> 28487 */
    0xE4ED, 0x6F24,    /* '漤' -> 28452 */
    0xE4EE, 0x6F15,    /* '漕' -> 28437 */
    0xE4EF, 0x6EF9,    /* '滹' -> 28409 */
    0xE4F0, 0x6F2F,    /* '漯' -> 28463 */
    0xE4F1, 0x6F36,    /* '漶' -> 28470 */
    0xE4F2, 0x6F4B,    /* '潋' -> 28491 */
    0xE4F3, 0x6F74,    /* '潴' -> 28532 */
    0xE4F4, 0x6F2A,    /* '漪' -> 28458 */
    0xE4F5, 0x6F09,    /* '漉' -> 28425 */
    0xE4F6, 0x6F29,    /* '漩' -> 28457 */
    0xE4F7, 0x6F89,    /* '澉' -> 28553 */
    0xE4F8, 0x6F8D,    /* '澍' -> 28557 */
    0xE4F9, 0x6F8C,    /* '澌' -> 28556 */
    0xE4FA, 0x6F78,    /* '潸' -> 28536 */
    0xE4FB, 0x6F72,    /* '潲' -> 28530 */
    0xE4FC, 0x6F7C,    /* '潼' -> 28540 */
    0xE4FD, 0x6F7A,    /* '潺' -> 28538 */
    0xE4FE, 0x6FD1,    /* '濑' -> 28625 */
    0xE5A1, 0x6FC9,    /* '濉' -> 28617 */
    0xE5A2, 0x6FA7,    /* '澧' -> 28583 */
    0xE5A3, 0x6FB9,    /* '澹' -> 28601 */
    0xE5A4, 0x6FB6,    /* '澶' -> 28598 */
    0xE5A5, 0x6FC2,    /* '濂' -> 28610 */
    0xE5A6, 0x6FE1,    /* '濡' -> 28641 */
    0xE5A7, 0x6FEE,    /* '濮' -> 28654 */
    0xE5A8, 0x6FDE,    /* '濞' -> 28638 */
    0xE5A9, 0x6FE0,    /* '濠' -> 28640 */
    0xE5AA, 0x6FEF,    /* '濯' -> 28655 */
    0xE5AB, 0x701A,    /* '瀚' -> 28698 */
    0xE5AC, 0x7023,    /* '瀣' -> 28707 */
    0xE5AD, 0x701B,    /* '瀛' -> 28699 */
    0xE5AE, 0x7039,    /* '瀹' -> 28729 */
    0xE5AF, 0x7035,    /* '瀵' -> 28725 */
    0xE5B0, 0x704F,    /* '灏' -> 28751 */
    0xE5B1, 0x705E,    /* '灞' -> 28766 */
    0xE5B2, 0x5B80,    /* '宀' -> 23424 */
    0xE5B3, 0x5B84,    /* '宄' -> 23428 */
    0xE5B4, 0x5B95,    /* '宕' -> 23445 */
    0xE5B5, 0x5B93,    /* '宓' -> 23443 */
    0xE5B6, 0x5BA5,    /* '宥' -> 23461 */
    0xE5B7, 0x5BB8,    /* '宸' -> 23480 */
    0xE5B8, 0x752F,    /* '甯' -> 29999 */
    0xE5B9, 0x9A9E,    /* '骞' -> 39582 */
    0xE5BA, 0x6434,    /* '搴' -> 25652 */
    0xE5BB, 0x5BE4,    /* '寤' -> 23524 */
    0xE5BC, 0x5BEE,    /* '寮' -> 23534 */
    0xE5BD, 0x8930,    /* '褰' -> 35120 */
    0xE5BE, 0x5BF0,    /* '寰' -> 23536 */
    0xE5BF, 0x8E47,    /* '蹇' -> 36423 */
    0xE5C0, 0x8B07,    /* '謇' -> 35591 */
    0xE5C1, 0x8FB6,    /* '辶' -> 36790 */
    0xE5C2, 0x8FD3,    /* '迓' -> 36819 */
    0xE5C3, 0x8FD5,    /* '迕' -> 36821 */
    0xE5C4, 0x8FE5,    /* '迥' -> 36837 */
    0xE5C5, 0x8FEE,    /* '迮' -> 36846 */
    0xE5C6, 0x8FE4,    /* '迤' -> 36836 */
    0xE5C7, 0x8FE9,    /* '迩' -> 36841 */
    0xE5C8, 0x8FE6,    /* '迦' -> 36838 */
    0xE5C9, 0x8FF3,    /* '迳' -> 36851 */
    0xE5CA, 0x8FE8,    /* '迨' -> 36840 */
    0xE5CB, 0x9005,    /* '逅' -> 36869 */
    0xE5CC, 0x9004,    /* '逄' -> 36868 */
    0xE5CD, 0x900B,    /* '逋' -> 36875 */
    0xE5CE, 0x9026,    /* '逦' -> 36902 */
    0xE5CF, 0x9011,    /* '逑' -> 36881 */
    0xE5D0, 0x900D,    /* '逍' -> 36877 */
    0xE5D1, 0x9016,    /* '逖' -> 36886 */
    0xE5D2, 0x9021,    /* '逡' -> 36897 */
    0xE5D3, 0x9035,    /* '逵' -> 36917 */
    0xE5D4, 0x9036,    /* '逶' -> 36918 */
    0xE5D5, 0x902D,    /* '逭' -> 36909 */
    0xE5D6, 0x902F,    /* '逯' -> 36911 */
    0xE5D7, 0x9044,    /* '遄' -> 36932 */
    0xE5D8, 0x9051,    /* '遑' -> 36945 */
    0xE5D9, 0x9052,    /* '遒' -> 36946 */
    0xE5DA, 0x9050,    /* '遐' -> 36944 */
    0xE5DB, 0x9068,    /* '遨' -> 36968 */
    0xE5DC, 0x9058,    /* '遘' -> 36952 */
    0xE5DD, 0x9062,    /* '遢' -> 36962 */
    0xE5DE, 0x905B,    /* '遛' -> 36955 */
    0xE5DF, 0x66B9,    /* '暹' -> 26297 */
    0xE5E0, 0x9074,    /* '遴' -> 36980 */
    0xE5E1, 0x907D,    /* '遽' -> 36989 */
    0xE5E2, 0x9082,    /* '邂' -> 36994 */
    0xE5E3, 0x9088,    /* '邈' -> 37000 */
    0xE5E4, 0x9083,    /* '邃' -> 36995 */
    0xE5E5, 0x908B,    /* '邋' -> 37003 */
    0xE5E6, 0x5F50,    /* '彐' -> 24400 */
    0xE5E7, 0x5F57,    /* '彗' -> 24407 */
    0xE5E8, 0x5F56,    /* '彖' -> 24406 */
    0xE5E9, 0x5F58,    /* '彘' -> 24408 */
    0xE5EA, 0x5C3B,    /* '尻' -> 23611 */
    0xE5EB, 0x54AB,    /* '咫' -> 21675 */
    0xE5EC, 0x5C50,    /* '屐' -> 23632 */
    0xE5ED, 0x5C59,    /* '屙' -> 23641 */
    0xE5EE, 0x5B71,    /* '孱' -> 23409 */
    0xE5EF, 0x5C63,    /* '屣' -> 23651 */
    0xE5F0, 0x5C66,    /* '屦' -> 23654 */
    0xE5F1, 0x7FBC,    /* '羼' -> 32700 */
    0xE5F2, 0x5F2A,    /* '弪' -> 24362 */
    0xE5F3, 0x5F29,    /* '弩' -> 24361 */
    0xE5F4, 0x5F2D,    /* '弭' -> 24365 */
    0xE5F5, 0x8274,    /* '艴' -> 33396 */
    0xE5F6, 0x5F3C,    /* '弼' -> 24380 */
    0xE5F7, 0x9B3B,    /* '鬻' -> 39739 */
    0xE5F8, 0x5C6E,    /* '屮' -> 23662 */
    0xE5F9, 0x5981,    /* '妁' -> 22913 */
    0xE5FA, 0x5983,    /* '妃' -> 22915 */
    0xE5FB, 0x598D,    /* '妍' -> 22925 */
    0xE5FC, 0x59A9,    /* '妩' -> 22953 */
    0xE5FD, 0x59AA,    /* '妪' -> 22954 */
    0xE5FE, 0x59A3,    /* '妣' -> 22947 */
    0xE6A1, 0x5997,    /* '妗' -> 22935 */
    0xE6A2, 0x59CA,    /* '姊' -> 22986 */
    0xE6A3, 0x59AB,    /* '妫' -> 22955 */
    0xE6A4, 0x599E,    /* '妞' -> 22942 */
    0xE6A5, 0x59A4,    /* '妤' -> 22948 */
    0xE6A6, 0x59D2,    /* '姒' -> 22994 */
    0xE6A7, 0x59B2,    /* '妲' -> 22962 */
    0xE6A8, 0x59AF,    /* '妯' -> 22959 */
    0xE6A9, 0x59D7,    /* '姗' -> 22999 */
    0xE6AA, 0x59BE,    /* '妾' -> 22974 */
    0xE6AB, 0x5A05,    /* '娅' -> 23045 */
    0xE6AC, 0x5A06,    /* '娆' -> 23046 */
    0xE6AD, 0x59DD,    /* '姝' -> 23005 */
    0xE6AE, 0x5A08,    /* '娈' -> 23048 */
    0xE6AF, 0x59E3,    /* '姣' -> 23011 */
    0xE6B0, 0x59D8,    /* '姘' -> 23000 */
    0xE6B1, 0x59F9,    /* '姹' -> 23033 */
    0xE6B2, 0x5A0C,    /* '娌' -> 23052 */
    0xE6B3, 0x5A09,    /* '娉' -> 23049 */
    0xE6B4, 0x5A32,    /* '娲' -> 23090 */
    0xE6B5, 0x5A34,    /* '娴' -> 23092 */
    0xE6B6, 0x5A11,    /* '娑' -> 23057 */
    0xE6B7, 0x5A23,    /* '娣' -> 23075 */
    0xE6B8, 0x5A13,    /* '娓' -> 23059 */
    0xE6B9, 0x5A40,    /* '婀' -> 23104 */
    0xE6BA, 0x5A67,    /* '婧' -> 23143 */
    0xE6BB, 0x5A4A,    /* '婊' -> 23114 */
    0xE6BC, 0x5A55,    /* '婕' -> 23125 */
    0xE6BD, 0x5A3C,    /* '娼' -> 23100 */
    0xE6BE, 0x5A62,    /* '婢' -> 23138 */
    0xE6BF, 0x5A75,    /* '婵' -> 23157 */
    0xE6C0, 0x80EC,    /* '胬' -> 33004 */
    0xE6C1, 0x5AAA,    /* '媪' -> 23210 */
    0xE6C2, 0x5A9B,    /* '媛' -> 23195 */
    0xE6C3, 0x5A77,    /* '婷' -> 23159 */
    0xE6C4, 0x5A7A,    /* '婺' -> 23162 */
    0xE6C5, 0x5ABE,    /* '媾' -> 23230 */
    0xE6C6, 0x5AEB,    /* '嫫' -> 23275 */
    0xE6C7, 0x5AB2,    /* '媲' -> 23218 */
    0xE6C8, 0x5AD2,    /* '嫒' -> 23250 */
    0xE6C9, 0x5AD4,    /* '嫔' -> 23252 */
    0xE6CA, 0x5AB8,    /* '媸' -> 23224 */
    0xE6CB, 0x5AE0,    /* '嫠' -> 23264 */
    0xE6CC, 0x5AE3,    /* '嫣' -> 23267 */
    0xE6CD, 0x5AF1,    /* '嫱' -> 23281 */
    0xE6CE, 0x5AD6,    /* '嫖' -> 23254 */
    0xE6CF, 0x5AE6,    /* '嫦' -> 23270 */
    0xE6D0, 0x5AD8,    /* '嫘' -> 23256 */
    0xE6D1, 0x5ADC,    /* '嫜' -> 23260 */
    0xE6D2, 0x5B09,    /* '嬉' -> 23305 */
    0xE6D3, 0x5B17,    /* '嬗' -> 23319 */
    0xE6D4, 0x5B16,    /* '嬖' -> 23318 */
    0xE6D5, 0x5B32,    /* '嬲' -> 23346 */
    0xE6D6, 0x5B37,    /* '嬷' -> 23351 */
    0xE6D7, 0x5B40,    /* '孀' -> 23360 */
    0xE6D8, 0x5C15,    /* '尕' -> 23573 */
    0xE6D9, 0x5C1C,    /* '尜' -> 23580 */
    0xE6DA, 0x5B5A,    /* '孚' -> 23386 */
    0xE6DB, 0x5B65,    /* '孥' -> 23397 */
    0xE6DC, 0x5B73,    /* '孳' -> 23411 */
    0xE6DD, 0x5B51,    /* '孑' -> 23377 */
    0xE6DE, 0x5B53,    /* '孓' -> 23379 */
    0xE6DF, 0x5B62,    /* '孢' -> 23394 */
    0xE6E0, 0x9A75,    /* '驵' -> 39541 */
    0xE6E1, 0x9A77,    /* '驷' -> 39543 */
    0xE6E2, 0x9A78,    /* '驸' -> 39544 */
    0xE6E3, 0x9A7A,    /* '驺' -> 39546 */
    0xE6E4, 0x9A7F,    /* '驿' -> 39551 */
    0xE6E5, 0x9A7D,    /* '驽' -> 39549 */
    0xE6E6, 0x9A80,    /* '骀' -> 39552 */
    0xE6E7, 0x9A81,    /* '骁' -> 39553 */
    0xE6E8, 0x9A85,    /* '骅' -> 39557 */
    0xE6E9, 0x9A88,    /* '骈' -> 39560 */
    0xE6EA, 0x9A8A,    /* '骊' -> 39562 */
    0xE6EB, 0x9A90,    /* '骐' -> 39568 */
    0xE6EC, 0x9A92,    /* '骒' -> 39570 */
    0xE6ED, 0x9A93,    /* '骓' -> 39571 */
    0xE6EE, 0x9A96,    /* '骖' -> 39574 */
    0xE6EF, 0x9A98,    /* '骘' -> 39576 */
    0xE6F0, 0x9A9B,    /* '骛' -> 39579 */
    0xE6F1, 0x9A9C,    /* '骜' -> 39580 */
    0xE6F2, 0x9A9D,    /* '骝' -> 39581 */
    0xE6F3, 0x9A9F,    /* '骟' -> 39583 */
    0xE6F4, 0x9AA0,    /* '骠' -> 39584 */
    0xE6F5, 0x9AA2,    /* '骢' -> 39586 */
    0xE6F6, 0x9AA3,    /* '骣' -> 39587 */
    0xE6F7, 0x9AA5,    /* '骥' -> 39589 */
    0xE6F8, 0x9AA7,    /* '骧' -> 39591 */
    0xE6F9, 0x7E9F,    /* '纟' -> 32415 */
    0xE6FA, 0x7EA1,    /* '纡' -> 32417 */
    0xE6FB, 0x7EA3,    /* '纣' -> 32419 */
    0xE6FC, 0x7EA5,    /* '纥' -> 32421 */
    0xE6FD, 0x7EA8,    /* '纨' -> 32424 */
    0xE6FE, 0x7EA9,    /* '纩' -> 32425 */
    0xE7A1, 0x7EAD,    /* '纭' -> 32429 */
    0xE7A2, 0x7EB0,    /* '纰' -> 32432 */
    0xE7A3, 0x7EBE,    /* '纾' -> 32446 */
    0xE7A4, 0x7EC0,    /* '绀' -> 32448 */
    0xE7A5, 0x7EC1,    /* '绁' -> 32449 */
    0xE7A6, 0x7EC2,    /* '绂' -> 32450 */
    0xE7A7, 0x7EC9,    /* '绉' -> 32457 */
    0xE7A8, 0x7ECB,    /* '绋' -> 32459 */
    0xE7A9, 0x7ECC,    /* '绌' -> 32460 */
    0xE7AA, 0x7ED0,    /* '绐' -> 32464 */
    0xE7AB, 0x7ED4,    /* '绔' -> 32468 */
    0xE7AC, 0x7ED7,    /* '绗' -> 32471 */
    0xE7AD, 0x7EDB,    /* '绛' -> 32475 */
    0xE7AE, 0x7EE0,    /* '绠' -> 32480 */
    0xE7AF, 0x7EE1,    /* '绡' -> 32481 */
    0xE7B0, 0x7EE8,    /* '绨' -> 32488 */
    0xE7B1, 0x7EEB,    /* '绫' -> 32491 */
    0xE7B2, 0x7EEE,    /* '绮' -> 32494 */
    0xE7B3, 0x7EEF,    /* '绯' -> 32495 */
    0xE7B4, 0x7EF1,    /* '绱' -> 32497 */
    0xE7B5, 0x7EF2,    /* '绲' -> 32498 */
    0xE7B6, 0x7F0D,    /* '缍' -> 32525 */
    0xE7B7, 0x7EF6,    /* '绶' -> 32502 */
    0xE7B8, 0x7EFA,    /* '绺' -> 32506 */
    0xE7B9, 0x7EFB,    /* '绻' -> 32507 */
    0xE7BA, 0x7EFE,    /* '绾' -> 32510 */
    0xE7BB, 0x7F01,    /* '缁' -> 32513 */
    0xE7BC, 0x7F02,    /* '缂' -> 32514 */
    0xE7BD, 0x7F03,    /* '缃' -> 32515 */
    0xE7BE, 0x7F07,    /* '缇' -> 32519 */
    0xE7BF, 0x7F08,    /* '缈' -> 32520 */
    0xE7C0, 0x7F0B,    /* '缋' -> 32523 */
    0xE7C1, 0x7F0C,    /* '缌' -> 32524 */
    0xE7C2, 0x7F0F,    /* '缏' -> 32527 */
    0xE7C3, 0x7F11,    /* '缑' -> 32529 */
    0xE7C4, 0x7F12,    /* '缒' -> 32530 */
    0xE7C5, 0x7F17,    /* '缗' -> 32535 */
    0xE7C6, 0x7F19,    /* '缙' -> 32537 */
    0xE7C7, 0x7F1C,    /* '缜' -> 32540 */
    0xE7C8, 0x7F1B,    /* '缛' -> 32539 */
    0xE7C9, 0x7F1F,    /* '缟' -> 32543 */
    0xE7CA, 0x7F21,    /* '缡' -> 32545 */
    0xE7CB, 0x7F22,    /* '缢' -> 32546 */
    0xE7CC, 0x7F23,    /* '缣' -> 32547 */
    0xE7CD, 0x7F24,    /* '缤' -> 32548 */
    0xE7CE, 0x7F25,    /* '缥' -> 32549 */
    0xE7CF, 0x7F26,    /* '缦' -> 32550 */
    0xE7D0, 0x7F27,    /* '缧' -> 32551 */
    0xE7D1, 0x7F2A,    /* '缪' -> 32554 */
    0xE7D2, 0x7F2B,    /* '缫' -> 32555 */
    0xE7D3, 0x7F2C,    /* '缬' -> 32556 */
    0xE7D4, 0x7F2D,    /* '缭' -> 32557 */
    0xE7D5, 0x7F2F,    /* '缯' -> 32559 */
    0xE7D6, 0x7F30,    /* '缰' -> 32560 */
    0xE7D7, 0x7F31,    /* '缱' -> 32561 */
    0xE7D8, 0x7F32,    /* '缲' -> 32562 */
    0xE7D9, 0x7F33,    /* '缳' -> 32563 */
    0xE7DA, 0x7F35,    /* '缵' -> 32565 */
    0xE7DB, 0x5E7A,    /* '幺' -> 24186 */
    0xE7DC, 0x757F,    /* '畿' -> 30079 */
    0xE7DD, 0x5DDB,    /* '巛' -> 24027 */
    0xE7DE, 0x753E,    /* '甾' -> 30014 */
    0xE7DF, 0x9095,    /* '邕' -> 37013 */
    0xE7E0, 0x738E,    /* '玎' -> 29582 */
    0xE7E1, 0x7391,    /* '玑' -> 29585 */
    0xE7E2, 0x73AE,    /* '玮' -> 29614 */
    0xE7E3, 0x73A2,    /* '玢' -> 29602 */
    0xE7E4, 0x739F,    /* '玟' -> 29599 */
    0xE7E5, 0x73CF,    /* '珏' -> 29647 */
    0xE7E6, 0x73C2,    /* '珂' -> 29634 */
    0xE7E7, 0x73D1,    /* '珑' -> 29649 */
    0xE7E8, 0x73B7,    /* '玷' -> 29623 */
    0xE7E9, 0x73B3,    /* '玳' -> 29619 */
    0xE7EA, 0x73C0,    /* '珀' -> 29632 */
    0xE7EB, 0x73C9,    /* '珉' -> 29641 */
    0xE7EC, 0x73C8,    /* '珈' -> 29640 */
    0xE7ED, 0x73E5,    /* '珥' -> 29669 */
    0xE7EE, 0x73D9,    /* '珙' -> 29657 */
    0xE7EF, 0x987C,    /* '顼' -> 39036 */
    0xE7F0, 0x740A,    /* '琊' -> 29706 */
    0xE7F1, 0x73E9,    /* '珩' -> 29673 */
    0xE7F2, 0x73E7,    /* '珧' -> 29671 */
    0xE7F3, 0x73DE,    /* '珞' -> 29662 */
    0xE7F4, 0x73BA,    /* '玺' -> 29626 */
    0xE7F5, 0x73F2,    /* '珲' -> 29682 */
    0xE7F6, 0x740F,    /* '琏' -> 29711 */
    0xE7F7, 0x742A,    /* '琪' -> 29738 */
    0xE7F8, 0x745B,    /* '瑛' -> 29787 */
    0xE7F9, 0x7426,    /* '琦' -> 29734 */
    0xE7FA, 0x7425,    /* '琥' -> 29733 */
    0xE7FB, 0x7428,    /* '琨' -> 29736 */
    0xE7FC, 0x7430,    /* '琰' -> 29744 */
    0xE7FD, 0x742E,    /* '琮' -> 29742 */
    0xE7FE, 0x742C,    /* '琬' -> 29740 */
    0xE8A1, 0x741B,    /* '琛' -> 29723 */
    0xE8A2, 0x741A,    /* '琚' -> 29722 */
    0xE8A3, 0x7441,    /* '瑁' -> 29761 */
    0xE8A4, 0x745C,    /* '瑜' -> 29788 */
    0xE8A5, 0x7457,    /* '瑗' -> 29783 */
    0xE8A6, 0x7455,    /* '瑕' -> 29781 */
    0xE8A7, 0x7459,    /* '瑙' -> 29785 */
    0xE8A8, 0x7477,    /* '瑷' -> 29815 */
    0xE8A9, 0x746D,    /* '瑭' -> 29805 */
    0xE8AA, 0x747E,    /* '瑾' -> 29822 */
    0xE8AB, 0x749C,    /* '璜' -> 29852 */
    0xE8AC, 0x748E,    /* '璎' -> 29838 */
    0xE8AD, 0x7480,    /* '璀' -> 29824 */
    0xE8AE, 0x7481,    /* '璁' -> 29825 */
    0xE8AF, 0x7487,    /* '璇' -> 29831 */
    0xE8B0, 0x748B,    /* '璋' -> 29835 */
    0xE8B1, 0x749E,    /* '璞' -> 29854 */
    0xE8B2, 0x74A8,    /* '璨' -> 29864 */
    0xE8B3, 0x74A9,    /* '璩' -> 29865 */
    0xE8B4, 0x7490,    /* '璐' -> 29840 */
    0xE8B5, 0x74A7,    /* '璧' -> 29863 */
    0xE8B6, 0x74D2,    /* '瓒' -> 29906 */
    0xE8B7, 0x74BA,    /* '璺' -> 29882 */
    0xE8B8, 0x97EA,    /* '韪' -> 38890 */
    0xE8B9, 0x97EB,    /* '韫' -> 38891 */
    0xE8BA, 0x97EC,    /* '韬' -> 38892 */
    0xE8BB, 0x674C,    /* '杌' -> 26444 */
    0xE8BC, 0x6753,    /* '杓' -> 26451 */
    0xE8BD, 0x675E,    /* '杞' -> 26462 */
    0xE8BE, 0x6748,    /* '杈' -> 26440 */
    0xE8BF, 0x6769,    /* '杩' -> 26473 */
    0xE8C0, 0x67A5,    /* '枥' -> 26533 */
    0xE8C1, 0x6787,    /* '枇' -> 26503 */
    0xE8C2, 0x676A,    /* '杪' -> 26474 */
    0xE8C3, 0x6773,    /* '杳' -> 26483 */
    0xE8C4, 0x6798,    /* '枘' -> 26520 */
    0xE8C5, 0x67A7,    /* '枧' -> 26535 */
    0xE8C6, 0x6775,    /* '杵' -> 26485 */
    0xE8C7, 0x67A8,    /* '枨' -> 26536 */
    0xE8C8, 0x679E,    /* '枞' -> 26526 */
    0xE8C9, 0x67AD,    /* '枭' -> 26541 */
    0xE8CA, 0x678B,    /* '枋' -> 26507 */
    0xE8CB, 0x6777,    /* '杷' -> 26487 */
    0xE8CC, 0x677C,    /* '杼' -> 26492 */
    0xE8CD, 0x67F0,    /* '柰' -> 26608 */
    0xE8CE, 0x6809,    /* '栉' -> 26633 */
    0xE8CF, 0x67D8,    /* '柘' -> 26584 */
    0xE8D0, 0x680A,    /* '栊' -> 26634 */
    0xE8D1, 0x67E9,    /* '柩' -> 26601 */
    0xE8D2, 0x67B0,    /* '枰' -> 26544 */
    0xE8D3, 0x680C,    /* '栌' -> 26636 */
    0xE8D4, 0x67D9,    /* '柙' -> 26585 */
    0xE8D5, 0x67B5,    /* '枵' -> 26549 */
    0xE8D6, 0x67DA,    /* '柚' -> 26586 */
    0xE8D7, 0x67B3,    /* '枳' -> 26547 */
    0xE8D8, 0x67DD,    /* '柝' -> 26589 */
    0xE8D9, 0x6800,    /* '栀' -> 26624 */
    0xE8DA, 0x67C3,    /* '柃' -> 26563 */
    0xE8DB, 0x67B8,    /* '枸' -> 26552 */
    0xE8DC, 0x67E2,    /* '柢' -> 26594 */
    0xE8DD, 0x680E,    /* '栎' -> 26638 */
    0xE8DE, 0x67C1,    /* '柁' -> 26561 */
    0xE8DF, 0x67FD,    /* '柽' -> 26621 */
    0xE8E0, 0x6832,    /* '栲' -> 26674 */
    0xE8E1, 0x6833,    /* '栳' -> 26675 */
    0xE8E2, 0x6860,    /* '桠' -> 26720 */
    0xE8E3, 0x6861,    /* '桡' -> 26721 */
    0xE8E4, 0x684E,    /* '桎' -> 26702 */
    0xE8E5, 0x6862,    /* '桢' -> 26722 */
    0xE8E6, 0x6844,    /* '桄' -> 26692 */
    0xE8E7, 0x6864,    /* '桤' -> 26724 */
    0xE8E8, 0x6883,    /* '梃' -> 26755 */
    0xE8E9, 0x681D,    /* '栝' -> 26653 */
    0xE8EA, 0x6855,    /* '桕' -> 26709 */
    0xE8EB, 0x6866,    /* '桦' -> 26726 */
    0xE8EC, 0x6841,    /* '桁' -> 26689 */
    0xE8ED, 0x6867,    /* '桧' -> 26727 */
    0xE8EE, 0x6840,    /* '桀' -> 26688 */
    0xE8EF, 0x683E,    /* '栾' -> 26686 */
    0xE8F0, 0x684A,    /* '桊' -> 26698 */
    0xE8F1, 0x6849,    /* '桉' -> 26697 */
    0xE8F2, 0x6829,    /* '栩' -> 26665 */
    0xE8F3, 0x68B5,    /* '梵' -> 26805 */
    0xE8F4, 0x688F,    /* '梏' -> 26767 */
    0xE8F5, 0x6874,    /* '桴' -> 26740 */
    0xE8F6, 0x6877,    /* '桷' -> 26743 */
    0xE8F7, 0x6893,    /* '梓' -> 26771 */
    0xE8F8, 0x686B,    /* '桫' -> 26731 */
    0xE8F9, 0x68C2,    /* '棂' -> 26818 */
    0xE8FA, 0x696E,    /* '楮' -> 26990 */
    0xE8FB, 0x68FC,    /* '棼' -> 26876 */
    0xE8FC, 0x691F,    /* '椟' -> 26911 */
    0xE8FD, 0x6920,    /* '椠' -> 26912 */
    0xE8FE, 0x68F9,    /* '棹' -> 26873 */
    0xE9A1, 0x6924,    /* '椤' -> 26916 */
    0xE9A2, 0x68F0,    /* '棰' -> 26864 */
    0xE9A3, 0x690B,    /* '椋' -> 26891 */
    0xE9A4, 0x6901,    /* '椁' -> 26881 */
    0xE9A5, 0x6957,    /* '楗' -> 26967 */
    0xE9A6, 0x68E3,    /* '棣' -> 26851 */
    0xE9A7, 0x6910,    /* '椐' -> 26896 */
    0xE9A8, 0x6971,    /* '楱' -> 26993 */
    0xE9A9, 0x6939,    /* '椹' -> 26937 */
    0xE9AA, 0x6960,    /* '楠' -> 26976 */
    0xE9AB, 0x6942,    /* '楂' -> 26946 */
    0xE9AC, 0x695D,    /* '楝' -> 26973 */
    0xE9AD, 0x6984,    /* '榄' -> 27012 */
    0xE9AE, 0x696B,    /* '楫' -> 26987 */
    0xE9AF, 0x6980,    /* '榀' -> 27008 */
    0xE9B0, 0x6998,    /* '榘' -> 27032 */
    0xE9B1, 0x6978,    /* '楸' -> 27000 */
    0xE9B2, 0x6934,    /* '椴' -> 26932 */
    0xE9B3, 0x69CC,    /* '槌' -> 27084 */
    0xE9B4, 0x6987,    /* '榇' -> 27015 */
    0xE9B5, 0x6988,    /* '榈' -> 27016 */
    0xE9B6, 0x69CE,    /* '槎' -> 27086 */
    0xE9B7, 0x6989,    /* '榉' -> 27017 */
    0xE9B8, 0x6966,    /* '楦' -> 26982 */
    0xE9B9, 0x6963,    /* '楣' -> 26979 */
    0xE9BA, 0x6979,    /* '楹' -> 27001 */
    0xE9BB, 0x699B,    /* '榛' -> 27035 */
    0xE9BC, 0x69A7,    /* '榧' -> 27047 */
    0xE9BD, 0x69BB,    /* '榻' -> 27067 */
    0xE9BE, 0x69AB,    /* '榫' -> 27051 */
    0xE9BF, 0x69AD,    /* '榭' -> 27053 */
    0xE9C0, 0x69D4,    /* '槔' -> 27092 */
    0xE9C1, 0x69B1,    /* '榱' -> 27057 */
    0xE9C2, 0x69C1,    /* '槁' -> 27073 */
    0xE9C3, 0x69CA,    /* '槊' -> 27082 */
    0xE9C4, 0x69DF,    /* '槟' -> 27103 */
    0xE9C5, 0x6995,    /* '榕' -> 27029 */
    0xE9C6, 0x69E0,    /* '槠' -> 27104 */
    0xE9C7, 0x698D,    /* '榍' -> 27021 */
    0xE9C8, 0x69FF,    /* '槿' -> 27135 */
    0xE9C9, 0x6A2F,    /* '樯' -> 27183 */
    0xE9CA, 0x69ED,    /* '槭' -> 27117 */
    0xE9CB, 0x6A17,    /* '樗' -> 27159 */
    0xE9CC, 0x6A18,    /* '樘' -> 27160 */
    0xE9CD, 0x6A65,    /* '橥' -> 27237 */
    0xE9CE, 0x69F2,    /* '槲' -> 27122 */
    0xE9CF, 0x6A44,    /* '橄' -> 27204 */
    0xE9D0, 0x6A3E,    /* '樾' -> 27198 */
    0xE9D1, 0x6AA0,    /* '檠' -> 27296 */
    0xE9D2, 0x6A50,    /* '橐' -> 27216 */
    0xE9D3, 0x6A5B,    /* '橛' -> 27227 */
    0xE9D4, 0x6A35,    /* '樵' -> 27189 */
    0xE9D5, 0x6A8E,    /* '檎' -> 27278 */
    0xE9D6, 0x6A79,    /* '橹' -> 27257 */
    0xE9D7, 0x6A3D,    /* '樽' -> 27197 */
    0xE9D8, 0x6A28,    /* '樨' -> 27176 */
    0xE9D9, 0x6A58,    /* '橘' -> 27224 */
    0xE9DA, 0x6A7C,    /* '橼' -> 27260 */
    0xE9DB, 0x6A91,    /* '檑' -> 27281 */
    0xE9DC, 0x6A90,    /* '檐' -> 27280 */
    0xE9DD, 0x6AA9,    /* '檩' -> 27305 */
    0xE9DE, 0x6A97,    /* '檗' -> 27287 */
    0xE9DF, 0x6AAB,    /* '檫' -> 27307 */
    0xE9E0, 0x7337,    /* '猷' -> 29495 */
    0xE9E1, 0x7352,    /* '獒' -> 29522 */
    0xE9E2, 0x6B81,    /* '殁' -> 27521 */
    0xE9E3, 0x6B82,    /* '殂' -> 27522 */
    0xE9E4, 0x6B87,    /* '殇' -> 27527 */
    0xE9E5, 0x6B84,    /* '殄' -> 27524 */
    0xE9E6, 0x6B92,    /* '殒' -> 27538 */
    0xE9E7, 0x6B93,    /* '殓' -> 27539 */
    0xE9E8, 0x6B8D,    /* '殍' -> 27533 */
    0xE9E9, 0x6B9A,    /* '殚' -> 27546 */
    0xE9EA, 0x6B9B,    /* '殛' -> 27547 */
    0xE9EB, 0x6BA1,    /* '殡' -> 27553 */
    0xE9EC, 0x6BAA,    /* '殪' -> 27562 */
    0xE9ED, 0x8F6B,    /* '轫' -> 36715 */
    0xE9EE, 0x8F6D,    /* '轭' -> 36717 */
    0xE9EF, 0x8F71,    /* '轱' -> 36721 */
    0xE9F0, 0x8F72,    /* '轲' -> 36722 */
    0xE9F1, 0x8F73,    /* '轳' -> 36723 */
    0xE9F2, 0x8F75,    /* '轵' -> 36725 */
    0xE9F3, 0x8F76,    /* '轶' -> 36726 */
    0xE9F4, 0x8F78,    /* '轸' -> 36728 */
    0xE9F5, 0x8F77,    /* '轷' -> 36727 */
    0xE9F6, 0x8F79,    /* '轹' -> 36729 */
    0xE9F7, 0x8F7A,    /* '轺' -> 36730 */
    0xE9F8, 0x8F7C,    /* '轼' -> 36732 */
    0xE9F9, 0x8F7E,    /* '轾' -> 36734 */
    0xE9FA, 0x8F81,    /* '辁' -> 36737 */
    0xE9FB, 0x8F82,    /* '辂' -> 36738 */
    0xE9FC, 0x8F84,    /* '辄' -> 36740 */
    0xE9FD, 0x8F87,    /* '辇' -> 36743 */
    0xE9FE, 0x8F8B,    /* '辋' -> 36747 */
    0xEAA1, 0x8F8D,    /* '辍' -> 36749 */
    0xEAA2, 0x8F8E,    /* '辎' -> 36750 */
    0xEAA3, 0x8F8F,    /* '辏' -> 36751 */
    0xEAA4, 0x8F98,    /* '辘' -> 36760 */
    0xEAA5, 0x8F9A,    /* '辚' -> 36762 */
    0xEAA6, 0x8ECE,    /* '軎' -> 36558 */
    0xEAA7, 0x620B,    /* '戋' -> 25099 */
    0xEAA8, 0x6217,    /* '戗' -> 25111 */
    0xEAA9, 0x621B,    /* '戛' -> 25115 */
    0xEAAA, 0x621F,    /* '戟' -> 25119 */
    0xEAAB, 0x6222,    /* '戢' -> 25122 */
    0xEAAC, 0x6221,    /* '戡' -> 25121 */
    0xEAAD, 0x6225,    /* '戥' -> 25125 */
    0xEAAE, 0x6224,    /* '戤' -> 25124 */
    0xEAAF, 0x622C,    /* '戬' -> 25132 */
    0xEAB0, 0x81E7,    /* '臧' -> 33255 */
    0xEAB1, 0x74EF,    /* '瓯' -> 29935 */
    0xEAB2, 0x74F4,    /* '瓴' -> 29940 */
    0xEAB3, 0x74FF,    /* '瓿' -> 29951 */
    0xEAB4, 0x750F,    /* '甏' -> 29967 */
    0xEAB5, 0x7511,    /* '甑' -> 29969 */
    0xEAB6, 0x7513,    /* '甓' -> 29971 */
    0xEAB7, 0x6534,    /* '攴' -> 25908 */
    0xEAB8, 0x65EE,    /* '旮' -> 26094 */
    0xEAB9, 0x65EF,    /* '旯' -> 26095 */
    0xEABA, 0x65F0,    /* '旰' -> 26096 */
    0xEABB, 0x660A,    /* '昊' -> 26122 */
    0xEABC, 0x6619,    /* '昙' -> 26137 */
    0xEABD, 0x6772,    /* '杲' -> 26482 */
    0xEABE, 0x6603,    /* '昃' -> 26115 */
    0xEABF, 0x6615,    /* '昕' -> 26133 */
    0xEAC0, 0x6600,    /* '昀' -> 26112 */
    0xEAC1, 0x7085,    /* '炅' -> 28805 */
    0xEAC2, 0x66F7,    /* '曷' -> 26359 */
    0xEAC3, 0x661D,    /* '昝' -> 26141 */
    0xEAC4, 0x6634,    /* '昴' -> 26164 */
    0xEAC5, 0x6631,    /* '昱' -> 26161 */
    0xEAC6, 0x6636,    /* '昶' -> 26166 */
    0xEAC7, 0x6635,    /* '昵' -> 26165 */
    0xEAC8, 0x8006,    /* '耆' -> 32774 */
    0xEAC9, 0x665F,    /* '晟' -> 26207 */
    0xEACA, 0x6654,    /* '晔' -> 26196 */
    0xEACB, 0x6641,    /* '晁' -> 26177 */
    0xEACC, 0x664F,    /* '晏' -> 26191 */
    0xEACD, 0x6656,    /* '晖' -> 26198 */
    0xEACE, 0x6661,    /* '晡' -> 26209 */
    0xEACF, 0x6657,    /* '晗' -> 26199 */
    0xEAD0, 0x6677,    /* '晷' -> 26231 */
    0xEAD1, 0x6684,    /* '暄' -> 26244 */
    0xEAD2, 0x668C,    /* '暌' -> 26252 */
    0xEAD3, 0x66A7,    /* '暧' -> 26279 */
    0xEAD4, 0x669D,    /* '暝' -> 26269 */
    0xEAD5, 0x66BE,    /* '暾' -> 26302 */
    0xEAD6, 0x66DB,    /* '曛' -> 26331 */
    0xEAD7, 0x66DC,    /* '曜' -> 26332 */
    0xEAD8, 0x66E6,    /* '曦' -> 26342 */
    0xEAD9, 0x66E9,    /* '曩' -> 26345 */
    0xEADA, 0x8D32,    /* '贲' -> 36146 */
    0xEADB, 0x8D33,    /* '贳' -> 36147 */
    0xEADC, 0x8D36,    /* '贶' -> 36150 */
    0xEADD, 0x8D3B,    /* '贻' -> 36155 */
    0xEADE, 0x8D3D,    /* '贽' -> 36157 */
    0xEADF, 0x8D40,    /* '赀' -> 36160 */
    0xEAE0, 0x8D45,    /* '赅' -> 36165 */
    0xEAE1, 0x8D46,    /* '赆' -> 36166 */
    0xEAE2, 0x8D48,    /* '赈' -> 36168 */
    0xEAE3, 0x8D49,    /* '赉' -> 36169 */
    0xEAE4, 0x8D47,    /* '赇' -> 36167 */
    0xEAE5, 0x8D4D,    /* '赍' -> 36173 */
    0xEAE6, 0x8D55,    /* '赕' -> 36181 */
    0xEAE7, 0x8D59,    /* '赙' -> 36185 */
    0xEAE8, 0x89C7,    /* '觇' -> 35271 */
    0xEAE9, 0x89CA,    /* '觊' -> 35274 */
    0xEAEA, 0x89CB,    /* '觋' -> 35275 */
    0xEAEB, 0x89CC,    /* '觌' -> 35276 */
    0xEAEC, 0x89CE,    /* '觎' -> 35278 */
    0xEAED, 0x89CF,    /* '觏' -> 35279 */
    0xEAEE, 0x89D0,    /* '觐' -> 35280 */
    0xEAEF, 0x89D1,    /* '觑' -> 35281 */
    0xEAF0, 0x726E,    /* '牮' -> 29294 */
    0xEAF1, 0x729F,    /* '犟' -> 29343 */
    0xEAF2, 0x725D,    /* '牝' -> 29277 */
    0xEAF3, 0x7266,    /* '牦' -> 29286 */
    0xEAF4, 0x726F,    /* '牯' -> 29295 */
    0xEAF5, 0x727E,    /* '牾' -> 29310 */
    0xEAF6, 0x727F,    /* '牿' -> 29311 */
    0xEAF7, 0x7284,    /* '犄' -> 29316 */
    0xEAF8, 0x728B,    /* '犋' -> 29323 */
    0xEAF9, 0x728D,    /* '犍' -> 29325 */
    0xEAFA, 0x728F,    /* '犏' -> 29327 */
    0xEAFB, 0x7292,    /* '犒' -> 29330 */
    0xEAFC, 0x6308,    /* '挈' -> 25352 */
    0xEAFD, 0x6332,    /* '挲' -> 25394 */
    0xEAFE, 0x63B0,    /* '掰' -> 25520 */
    0xEBA1, 0x643F,    /* '搿' -> 25663 */
    0xEBA2, 0x64D8,    /* '擘' -> 25816 */
    0xEBA3, 0x8004,    /* '耄' -> 32772 */
    0xEBA4, 0x6BEA,    /* '毪' -> 27626 */
    0xEBA5, 0x6BF3,    /* '毳' -> 27635 */
    0xEBA6, 0x6BFD,    /* '毽' -> 27645 */
    0xEBA7, 0x6BF5,    /* '毵' -> 27637 */
    0xEBA8, 0x6BF9,    /* '毹' -> 27641 */
    0xEBA9, 0x6C05,    /* '氅' -> 27653 */
    0xEBAA, 0x6C07,    /* '氇' -> 27655 */
    0xEBAB, 0x6C06,    /* '氆' -> 27654 */
    0xEBAC, 0x6C0D,    /* '氍' -> 27661 */
    0xEBAD, 0x6C15,    /* '氕' -> 27669 */
    0xEBAE, 0x6C18,    /* '氘' -> 27672 */
    0xEBAF, 0x6C19,    /* '氙' -> 27673 */
    0xEBB0, 0x6C1A,    /* '氚' -> 27674 */
    0xEBB1, 0x6C21,    /* '氡' -> 27681 */
    0xEBB2, 0x6C29,    /* '氩' -> 27689 */
    0xEBB3, 0x6C24,    /* '氤' -> 27684 */
    0xEBB4, 0x6C2A,    /* '氪' -> 27690 */
    0xEBB5, 0x6C32,    /* '氲' -> 27698 */
    0xEBB6, 0x6535,    /* '攵' -> 25909 */
    0xEBB7, 0x6555,    /* '敕' -> 25941 */
    0xEBB8, 0x656B,    /* '敫' -> 25963 */
    0xEBB9, 0x724D,    /* '牍' -> 29261 */
    0xEBBA, 0x7252,    /* '牒' -> 29266 */
    0xEBBB, 0x7256,    /* '牖' -> 29270 */
    0xEBBC, 0x7230,    /* '爰' -> 29232 */
    0xEBBD, 0x8662,    /* '虢' -> 34402 */
    0xEBBE, 0x5216,    /* '刖' -> 21014 */
    0xEBBF, 0x809F,    /* '肟' -> 32927 */
    0xEBC0, 0x809C,    /* '肜' -> 32924 */
    0xEBC1, 0x8093,    /* '肓' -> 32915 */
    0xEBC2, 0x80BC,    /* '肼' -> 32956 */
    0xEBC3, 0x670A,    /* '朊' -> 26378 */
    0xEBC4, 0x80BD,    /* '肽' -> 32957 */
    0xEBC5, 0x80B1,    /* '肱' -> 32945 */
    0xEBC6, 0x80AB,    /* '肫' -> 32939 */
    0xEBC7, 0x80AD,    /* '肭' -> 32941 */
    0xEBC8, 0x80B4,    /* '肴' -> 32948 */
    0xEBC9, 0x80B7,    /* '肷' -> 32951 */
    0xEBCA, 0x80E7,    /* '胧' -> 32999 */
    0xEBCB, 0x80E8,    /* '胨' -> 33000 */
    0xEBCC, 0x80E9,    /* '胩' -> 33001 */
    0xEBCD, 0x80EA,    /* '胪' -> 33002 */
    0xEBCE, 0x80DB,    /* '胛' -> 32987 */
    0xEBCF, 0x80C2,    /* '胂' -> 32962 */
    0xEBD0, 0x80C4,    /* '胄' -> 32964 */
    0xEBD1, 0x80D9,    /* '胙' -> 32985 */
    0xEBD2, 0x80CD,    /* '胍' -> 32973 */
    0xEBD3, 0x80D7,    /* '胗' -> 32983 */
    0xEBD4, 0x6710,    /* '朐' -> 26384 */
    0xEBD5, 0x80DD,    /* '胝' -> 32989 */
    0xEBD6, 0x80EB,    /* '胫' -> 33003 */
    0xEBD7, 0x80F1,    /* '胱' -> 33009 */
    0xEBD8, 0x80F4,    /* '胴' -> 33012 */
    0xEBD9, 0x80ED,    /* '胭' -> 33005 */
    0xEBDA, 0x810D,    /* '脍' -> 33037 */
    0xEBDB, 0x810E,    /* '脎' -> 33038 */
    0xEBDC, 0x80F2,    /* '胲' -> 33010 */
    0xEBDD, 0x80FC,    /* '胼' -> 33020 */
    0xEBDE, 0x6715,    /* '朕' -> 26389 */
    0xEBDF, 0x8112,    /* '脒' -> 33042 */
    0xEBE0, 0x8C5A,    /* '豚' -> 35930 */
    0xEBE1, 0x8136,    /* '脶' -> 33078 */
    0xEBE2, 0x811E,    /* '脞' -> 33054 */
    0xEBE3, 0x812C,    /* '脬' -> 33068 */
    0xEBE4, 0x8118,    /* '脘' -> 33048 */
    0xEBE5, 0x8132,    /* '脲' -> 33074 */
    0xEBE6, 0x8148,    /* '腈' -> 33096 */
    0xEBE7, 0x814C,    /* '腌' -> 33100 */
    0xEBE8, 0x8153,    /* '腓' -> 33107 */
    0xEBE9, 0x8174,    /* '腴' -> 33140 */
    0xEBEA, 0x8159,    /* '腙' -> 33113 */
    0xEBEB, 0x815A,    /* '腚' -> 33114 */
    0xEBEC, 0x8171,    /* '腱' -> 33137 */
    0xEBED, 0x8160,    /* '腠' -> 33120 */
    0xEBEE, 0x8169,    /* '腩' -> 33129 */
    0xEBEF, 0x817C,    /* '腼' -> 33148 */
    0xEBF0, 0x817D,    /* '腽' -> 33149 */
    0xEBF1, 0x816D,    /* '腭' -> 33133 */
    0xEBF2, 0x8167,    /* '腧' -> 33127 */
    0xEBF3, 0x584D,    /* '塍' -> 22605 */
    0xEBF4, 0x5AB5,    /* '媵' -> 23221 */
    0xEBF5, 0x8188,    /* '膈' -> 33160 */
    0xEBF6, 0x8182,    /* '膂' -> 33154 */
    0xEBF7, 0x8191,    /* '膑' -> 33169 */
    0xEBF8, 0x6ED5,    /* '滕' -> 28373 */
    0xEBF9, 0x81A3,    /* '膣' -> 33187 */
    0xEBFA, 0x81AA,    /* '膪' -> 33194 */
    0xEBFB, 0x81CC,    /* '臌' -> 33228 */
    0xEBFC, 0x6726,    /* '朦' -> 26406 */
    0xEBFD, 0x81CA,    /* '臊' -> 33226 */
    0xEBFE, 0x81BB,    /* '膻' -> 33211 */
    0xECA1, 0x81C1,    /* '臁' -> 33217 */
    0xECA2, 0x81A6,    /* '膦' -> 33190 */
    0xECA3, 0x6B24,    /* '欤' -> 27428 */
    0xECA4, 0x6B37,    /* '欷' -> 27447 */
    0xECA5, 0x6B39,    /* '欹' -> 27449 */
    0xECA6, 0x6B43,    /* '歃' -> 27459 */
    0xECA7, 0x6B46,    /* '歆' -> 27462 */
    0xECA8, 0x6B59,    /* '歙' -> 27481 */
    0xECA9, 0x98D1,    /* '飑' -> 39121 */
    0xECAA, 0x98D2,    /* '飒' -> 39122 */
    0xECAB, 0x98D3,    /* '飓' -> 39123 */
    0xECAC, 0x98D5,    /* '飕' -> 39125 */
    0xECAD, 0x98D9,    /* '飙' -> 39129 */
    0xECAE, 0x98DA,    /* '飚' -> 39130 */
    0xECAF, 0x6BB3,    /* '殳' -> 27571 */
    0xECB0, 0x5F40,    /* '彀' -> 24384 */
    0xECB1, 0x6BC2,    /* '毂' -> 27586 */
    0xECB2, 0x89F3,    /* '觳' -> 35315 */
    0xECB3, 0x6590,    /* '斐' -> 26000 */
    0xECB4, 0x9F51,    /* '齑' -> 40785 */
    0xECB5, 0x6593,    /* '斓' -> 26003 */
    0xECB6, 0x65BC,    /* '於' -> 26044 */
    0xECB7, 0x65C6,    /* '旆' -> 26054 */
    0xECB8, 0x65C4,    /* '旄' -> 26052 */
    0xECB9, 0x65C3,    /* '旃' -> 26051 */
    0xECBA, 0x65CC,    /* '旌' -> 26060 */
    0xECBB, 0x65CE,    /* '旎' -> 26062 */
    0xECBC, 0x65D2,    /* '旒' -> 26066 */
    0xECBD, 0x65D6,    /* '旖' -> 26070 */
    0xECBE, 0x7080,    /* '炀' -> 28800 */
    0xECBF, 0x709C,    /* '炜' -> 28828 */
    0xECC0, 0x7096,    /* '炖' -> 28822 */
    0xECC1, 0x709D,    /* '炝' -> 28829 */
    0xECC2, 0x70BB,    /* '炻' -> 28859 */
    0xECC3, 0x70C0,    /* '烀' -> 28864 */
    0xECC4, 0x70B7,    /* '炷' -> 28855 */
    0xECC5, 0x70AB,    /* '炫' -> 28843 */
    0xECC6, 0x70B1,    /* '炱' -> 28849 */
    0xECC7, 0x70E8,    /* '烨' -> 28904 */
    0xECC8, 0x70CA,    /* '烊' -> 28874 */
    0xECC9, 0x7110,    /* '焐' -> 28944 */
    0xECCA, 0x7113,    /* '焓' -> 28947 */
    0xECCB, 0x7116,    /* '焖' -> 28950 */
    0xECCC, 0x712F,    /* '焯' -> 28975 */
    0xECCD, 0x7131,    /* '焱' -> 28977 */
    0xECCE, 0x7173,    /* '煳' -> 29043 */
    0xECCF, 0x715C,    /* '煜' -> 29020 */
    0xECD0, 0x7168,    /* '煨' -> 29032 */
    0xECD1, 0x7145,    /* '煅' -> 28997 */
    0xECD2, 0x7172,    /* '煲' -> 29042 */
    0xECD3, 0x714A,    /* '煊' -> 29002 */
    0xECD4, 0x7178,    /* '煸' -> 29048 */
    0xECD5, 0x717A,    /* '煺' -> 29050 */
    0xECD6, 0x7198,    /* '熘' -> 29080 */
    0xECD7, 0x71B3,    /* '熳' -> 29107 */
    0xECD8, 0x71B5,    /* '熵' -> 29109 */
    0xECD9, 0x71A8,    /* '熨' -> 29096 */
    0xECDA, 0x71A0,    /* '熠' -> 29088 */
    0xECDB, 0x71E0,    /* '燠' -> 29152 */
    0xECDC, 0x71D4,    /* '燔' -> 29140 */
    0xECDD, 0x71E7,    /* '燧' -> 29159 */
    0xECDE, 0x71F9,    /* '燹' -> 29177 */
    0xECDF, 0x721D,    /* '爝' -> 29213 */
    0xECE0, 0x7228,    /* '爨' -> 29224 */
    0xECE1, 0x706C,    /* '灬' -> 28780 */
    0xECE2, 0x7118,    /* '焘' -> 28952 */
    0xECE3, 0x7166,    /* '煦' -> 29030 */
    0xECE4, 0x71B9,    /* '熹' -> 29113 */
    0xECE5, 0x623E,    /* '戾' -> 25150 */
    0xECE6, 0x623D,    /* '戽' -> 25149 */
    0xECE7, 0x6243,    /* '扃' -> 25155 */
    0xECE8, 0x6248,    /* '扈' -> 25160 */
    0xECE9, 0x6249,    /* '扉' -> 25161 */
    0xECEA, 0x793B,    /* '礻' -> 31035 */
    0xECEB, 0x7940,    /* '祀' -> 31040 */
    0xECEC, 0x7946,    /* '祆' -> 31046 */
    0xECED, 0x7949,    /* '祉' -> 31049 */
    0xECEE, 0x795B,    /* '祛' -> 31067 */
    0xECEF, 0x795C,    /* '祜' -> 31068 */
    0xECF0, 0x7953,    /* '祓' -> 31059 */
    0xECF1, 0x795A,    /* '祚' -> 31066 */
    0xECF2, 0x7962,    /* '祢' -> 31074 */
    0xECF3, 0x7957,    /* '祗' -> 31063 */
    0xECF4, 0x7960,    /* '祠' -> 31072 */
    0xECF5, 0x796F,    /* '祯' -> 31087 */
    0xECF6, 0x7967,    /* '祧' -> 31079 */
    0xECF7, 0x797A,    /* '祺' -> 31098 */
    0xECF8, 0x7985,    /* '禅' -> 31109 */
    0xECF9, 0x798A,    /* '禊' -> 31114 */
    0xECFA, 0x799A,    /* '禚' -> 31130 */
    0xECFB, 0x79A7,    /* '禧' -> 31143 */
    0xECFC, 0x79B3,    /* '禳' -> 31155 */
    0xECFD, 0x5FD1,    /* '忑' -> 24529 */
    0xECFE, 0x5FD0,    /* '忐' -> 24528 */
    0xEDA1, 0x603C,    /* '怼' -> 24636 */
    0xEDA2, 0x605D,    /* '恝' -> 24669 */
    0xEDA3, 0x605A,    /* '恚' -> 24666 */
    0xEDA4, 0x6067,    /* '恧' -> 24679 */
    0xEDA5, 0x6041,    /* '恁' -> 24641 */
    0xEDA6, 0x6059,    /* '恙' -> 24665 */
    0xEDA7, 0x6063,    /* '恣' -> 24675 */
    0xEDA8, 0x60AB,    /* '悫' -> 24747 */
    0xEDA9, 0x6106,    /* '愆' -> 24838 */
    0xEDAA, 0x610D,    /* '愍' -> 24845 */
    0xEDAB, 0x615D,    /* '慝' -> 24925 */
    0xEDAC, 0x61A9,    /* '憩' -> 25001 */
    0xEDAD, 0x619D,    /* '憝' -> 24989 */
    0xEDAE, 0x61CB,    /* '懋' -> 25035 */
    0xEDAF, 0x61D1,    /* '懑' -> 25041 */
    0xEDB0, 0x6206,    /* '戆' -> 25094 */
    0xEDB1, 0x8080,    /* '肀' -> 32896 */
    0xEDB2, 0x807F,    /* '聿' -> 32895 */
    0xEDB3, 0x6C93,    /* '沓' -> 27795 */
    0xEDB4, 0x6CF6,    /* '泶' -> 27894 */
    0xEDB5, 0x6DFC,    /* '淼' -> 28156 */
    0xEDB6, 0x77F6,    /* '矶' -> 30710 */
    0xEDB7, 0x77F8,    /* '矸' -> 30712 */
    0xEDB8, 0x7800,    /* '砀' -> 30720 */
    0xEDB9, 0x7809,    /* '砉' -> 30729 */
    0xEDBA, 0x7817,    /* '砗' -> 30743 */
    0xEDBB, 0x7818,    /* '砘' -> 30744 */
    0xEDBC, 0x7811,    /* '砑' -> 30737 */
    0xEDBD, 0x65AB,    /* '斫' -> 26027 */
    0xEDBE, 0x782D,    /* '砭' -> 30765 */
    0xEDBF, 0x781C,    /* '砜' -> 30748 */
    0xEDC0, 0x781D,    /* '砝' -> 30749 */
    0xEDC1, 0x7839,    /* '砹' -> 30777 */
    0xEDC2, 0x783A,    /* '砺' -> 30778 */
    0xEDC3, 0x783B,    /* '砻' -> 30779 */
    0xEDC4, 0x781F,    /* '砟' -> 30751 */
    0xEDC5, 0x783C,    /* '砼' -> 30780 */
    0xEDC6, 0x7825,    /* '砥' -> 30757 */
    0xEDC7, 0x782C,    /* '砬' -> 30764 */
    0xEDC8, 0x7823,    /* '砣' -> 30755 */
    0xEDC9, 0x7829,    /* '砩' -> 30761 */
    0xEDCA, 0x784E,    /* '硎' -> 30798 */
    0xEDCB, 0x786D,    /* '硭' -> 30829 */
    0xEDCC, 0x7856,    /* '硖' -> 30806 */
    0xEDCD, 0x7857,    /* '硗' -> 30807 */
    0xEDCE, 0x7826,    /* '砦' -> 30758 */
    0xEDCF, 0x7850,    /* '硐' -> 30800 */
    0xEDD0, 0x7847,    /* '硇' -> 30791 */
    0xEDD1, 0x784C,    /* '硌' -> 30796 */
    0xEDD2, 0x786A,    /* '硪' -> 30826 */
    0xEDD3, 0x789B,    /* '碛' -> 30875 */
    0xEDD4, 0x7893,    /* '碓' -> 30867 */
    0xEDD5, 0x789A,    /* '碚' -> 30874 */
    0xEDD6, 0x7887,    /* '碇' -> 30855 */
    0xEDD7, 0x789C,    /* '碜' -> 30876 */
    0xEDD8, 0x78A1,    /* '碡' -> 30881 */
    0xEDD9, 0x78A3,    /* '碣' -> 30883 */
    0xEDDA, 0x78B2,    /* '碲' -> 30898 */
    0xEDDB, 0x78B9,    /* '碹' -> 30905 */
    0xEDDC, 0x78A5,    /* '碥' -> 30885 */
    0xEDDD, 0x78D4,    /* '磔' -> 30932 */
    0xEDDE, 0x78D9,    /* '磙' -> 30937 */
    0xEDDF, 0x78C9,    /* '磉' -> 30921 */
    0xEDE0, 0x78EC,    /* '磬' -> 30956 */
    0xEDE1, 0x78F2,    /* '磲' -> 30962 */
    0xEDE2, 0x7905,    /* '礅' -> 30981 */
    0xEDE3, 0x78F4,    /* '磴' -> 30964 */
    0xEDE4, 0x7913,    /* '礓' -> 30995 */
    0xEDE5, 0x7924,    /* '礤' -> 31012 */
    0xEDE6, 0x791E,    /* '礞' -> 31006 */
    0xEDE7, 0x7934,    /* '礴' -> 31028 */
    0xEDE8, 0x9F9B,    /* '龛' -> 40859 */
    0xEDE9, 0x9EF9,    /* '黹' -> 40697 */
    0xEDEA, 0x9EFB,    /* '黻' -> 40699 */
    0xEDEB, 0x9EFC,    /* '黼' -> 40700 */
    0xEDEC, 0x76F1,    /* '盱' -> 30449 */
    0xEDED, 0x7704,    /* '眄' -> 30468 */
    0xEDEE, 0x770D,    /* '眍' -> 30477 */
    0xEDEF, 0x76F9,    /* '盹' -> 30457 */
    0xEDF0, 0x7707,    /* '眇' -> 30471 */
    0xEDF1, 0x7708,    /* '眈' -> 30472 */
    0xEDF2, 0x771A,    /* '眚' -> 30490 */
    0xEDF3, 0x7722,    /* '眢' -> 30498 */
    0xEDF4, 0x7719,    /* '眙' -> 30489 */
    0xEDF5, 0x772D,    /* '眭' -> 30509 */
    0xEDF6, 0x7726,    /* '眦' -> 30502 */
    0xEDF7, 0x7735,    /* '眵' -> 30517 */
    0xEDF8, 0x7738,    /* '眸' -> 30520 */
    0xEDF9, 0x7750,    /* '睐' -> 30544 */
    0xEDFA, 0x7751,    /* '睑' -> 30545 */
    0xEDFB, 0x7747,    /* '睇' -> 30535 */
    0xEDFC, 0x7743,    /* '睃' -> 30531 */
    0xEDFD, 0x775A,    /* '睚' -> 30554 */
    0xEDFE, 0x7768,    /* '睨' -> 30568 */
    0xEEA1, 0x7762,    /* '睢' -> 30562 */
    0xEEA2, 0x7765,    /* '睥' -> 30565 */
    0xEEA3, 0x777F,    /* '睿' -> 30591 */
    0xEEA4, 0x778D,    /* '瞍' -> 30605 */
    0xEEA5, 0x777D,    /* '睽' -> 30589 */
    0xEEA6, 0x7780,    /* '瞀' -> 30592 */
    0xEEA7, 0x778C,    /* '瞌' -> 30604 */
    0xEEA8, 0x7791,    /* '瞑' -> 30609 */
    0xEEA9, 0x779F,    /* '瞟' -> 30623 */
    0xEEAA, 0x77A0,    /* '瞠' -> 30624 */
    0xEEAB, 0x77B0,    /* '瞰' -> 30640 */
    0xEEAC, 0x77B5,    /* '瞵' -> 30645 */
    0xEEAD, 0x77BD,    /* '瞽' -> 30653 */
    0xEEAE, 0x753A,    /* '町' -> 30010 */
    0xEEAF, 0x7540,    /* '畀' -> 30016 */
    0xEEB0, 0x754E,    /* '畎' -> 30030 */
    0xEEB1, 0x754B,    /* '畋' -> 30027 */
    0xEEB2, 0x7548,    /* '畈' -> 30024 */
    0xEEB3, 0x755B,    /* '畛' -> 30043 */
    0xEEB4, 0x7572,    /* '畲' -> 30066 */
    0xEEB5, 0x7579,    /* '畹' -> 30073 */
    0xEEB6, 0x7583,    /* '疃' -> 30083 */
    0xEEB7, 0x7F58,    /* '罘' -> 32600 */
    0xEEB8, 0x7F61,    /* '罡' -> 32609 */
    0xEEB9, 0x7F5F,    /* '罟' -> 32607 */
    0xEEBA, 0x8A48,    /* '詈' -> 35400 */
    0xEEBB, 0x7F68,    /* '罨' -> 32616 */
    0xEEBC, 0x7F74,    /* '罴' -> 32628 */
    0xEEBD, 0x7F71,    /* '罱' -> 32625 */
    0xEEBE, 0x7F79,    /* '罹' -> 32633 */
    0xEEBF, 0x7F81,    /* '羁' -> 32641 */
    0xEEC0, 0x7F7E,    /* '罾' -> 32638 */
    0xEEC1, 0x76CD,    /* '盍' -> 30413 */
    0xEEC2, 0x76E5,    /* '盥' -> 30437 */
    0xEEC3, 0x8832,    /* '蠲' -> 34866 */
    0xEEC4, 0x9485,    /* '钅' -> 38021 */
    0xEEC5, 0x9486,    /* '钆' -> 38022 */
    0xEEC6, 0x9487,    /* '钇' -> 38023 */
    0xEEC7, 0x948B,    /* '钋' -> 38027 */
    0xEEC8, 0x948A,    /* '钊' -> 38026 */
    0xEEC9, 0x948C,    /* '钌' -> 38028 */
    0xEECA, 0x948D,    /* '钍' -> 38029 */
    0xEECB, 0x948F,    /* '钏' -> 38031 */
    0xEECC, 0x9490,    /* '钐' -> 38032 */
    0xEECD, 0x9494,    /* '钔' -> 38036 */
    0xEECE, 0x9497,    /* '钗' -> 38039 */
    0xEECF, 0x9495,    /* '钕' -> 38037 */
    0xEED0, 0x949A,    /* '钚' -> 38042 */
    0xEED1, 0x949B,    /* '钛' -> 38043 */
    0xEED2, 0x949C,    /* '钜' -> 38044 */
    0xEED3, 0x94A3,    /* '钣' -> 38051 */
    0xEED4, 0x94A4,    /* '钤' -> 38052 */
    0xEED5, 0x94AB,    /* '钫' -> 38059 */
    0xEED6, 0x94AA,    /* '钪' -> 38058 */
    0xEED7, 0x94AD,    /* '钭' -> 38061 */
    0xEED8, 0x94AC,    /* '钬' -> 38060 */
    0xEED9, 0x94AF,    /* '钯' -> 38063 */
    0xEEDA, 0x94B0,    /* '钰' -> 38064 */
    0xEEDB, 0x94B2,    /* '钲' -> 38066 */
    0xEEDC, 0x94B4,    /* '钴' -> 38068 */
    0xEEDD, 0x94B6,    /* '钶' -> 38070 */
    0xEEDE, 0x94B7,    /* '钷' -> 38071 */
    0xEEDF, 0x94B8,    /* '钸' -> 38072 */
    0xEEE0, 0x94B9,    /* '钹' -> 38073 */
    0xEEE1, 0x94BA,    /* '钺' -> 38074 */
    0xEEE2, 0x94BC,    /* '钼' -> 38076 */
    0xEEE3, 0x94BD,    /* '钽' -> 38077 */
    0xEEE4, 0x94BF,    /* '钿' -> 38079 */
    0xEEE5, 0x94C4,    /* '铄' -> 38084 */
    0xEEE6, 0x94C8,    /* '铈' -> 38088 */
    0xEEE7, 0x94C9,    /* '铉' -> 38089 */
    0xEEE8, 0x94CA,    /* '铊' -> 38090 */
    0xEEE9, 0x94CB,    /* '铋' -> 38091 */
    0xEEEA, 0x94CC,    /* '铌' -> 38092 */
    0xEEEB, 0x94CD,    /* '铍' -> 38093 */
    0xEEEC, 0x94CE,    /* '铎' -> 38094 */
    0xEEED, 0x94D0,    /* '铐' -> 38096 */
    0xEEEE, 0x94D1,    /* '铑' -> 38097 */
    0xEEEF, 0x94D2,    /* '铒' -> 38098 */
    0xEEF0, 0x94D5,    /* '铕' -> 38101 */
    0xEEF1, 0x94D6,    /* '铖' -> 38102 */
    0xEEF2, 0x94D7,    /* '铗' -> 38103 */
    0xEEF3, 0x94D9,    /* '铙' -> 38105 */
    0xEEF4, 0x94D8,    /* '铘' -> 38104 */
    0xEEF5, 0x94DB,    /* '铛' -> 38107 */
    0xEEF6, 0x94DE,    /* '铞' -> 38110 */
    0xEEF7, 0x94DF,    /* '铟' -> 38111 */
    0xEEF8, 0x94E0,    /* '铠' -> 38112 */
    0xEEF9, 0x94E2,    /* '铢' -> 38114 */
    0xEEFA, 0x94E4,    /* '铤' -> 38116 */
    0xEEFB, 0x94E5,    /* '铥' -> 38117 */
    0xEEFC, 0x94E7,    /* '铧' -> 38119 */
    0xEEFD, 0x94E8,    /* '铨' -> 38120 */
    0xEEFE, 0x94EA,    /* '铪' -> 38122 */
    0xEFA1, 0x94E9,    /* '铩' -> 38121 */
    0xEFA2, 0x94EB,    /* '铫' -> 38123 */
    0xEFA3, 0x94EE,    /* '铮' -> 38126 */
    0xEFA4, 0x94EF,    /* '铯' -> 38127 */
    0xEFA5, 0x94F3,    /* '铳' -> 38131 */
    0xEFA6, 0x94F4,    /* '铴' -> 38132 */
    0xEFA7, 0x94F5,    /* '铵' -> 38133 */
    0xEFA8, 0x94F7,    /* '铷' -> 38135 */
    0xEFA9, 0x94F9,    /* '铹' -> 38137 */
    0xEFAA, 0x94FC,    /* '铼' -> 38140 */
    0xEFAB, 0x94FD,    /* '铽' -> 38141 */
    0xEFAC, 0x94FF,    /* '铿' -> 38143 */
    0xEFAD, 0x9503,    /* '锃' -> 38147 */
    0xEFAE, 0x9502,    /* '锂' -> 38146 */
    0xEFAF, 0x9506,    /* '锆' -> 38150 */
    0xEFB0, 0x9507,    /* '锇' -> 38151 */
    0xEFB1, 0x9509,    /* '锉' -> 38153 */
    0xEFB2, 0x950A,    /* '锊' -> 38154 */
    0xEFB3, 0x950D,    /* '锍' -> 38157 */
    0xEFB4, 0x950E,    /* '锎' -> 38158 */
    0xEFB5, 0x950F,    /* '锏' -> 38159 */
    0xEFB6, 0x9512,    /* '锒' -> 38162 */
    0xEFB7, 0x9513,    /* '锓' -> 38163 */
    0xEFB8, 0x9514,    /* '锔' -> 38164 */
    0xEFB9, 0x9515,    /* '锕' -> 38165 */
    0xEFBA, 0x9516,    /* '锖' -> 38166 */
    0xEFBB, 0x9518,    /* '锘' -> 38168 */
    0xEFBC, 0x951B,    /* '锛' -> 38171 */
    0xEFBD, 0x951D,    /* '锝' -> 38173 */
    0xEFBE, 0x951E,    /* '锞' -> 38174 */
    0xEFBF, 0x951F,    /* '锟' -> 38175 */
    0xEFC0, 0x9522,    /* '锢' -> 38178 */
    0xEFC1, 0x952A,    /* '锪' -> 38186 */
    0xEFC2, 0x952B,    /* '锫' -> 38187 */
    0xEFC3, 0x9529,    /* '锩' -> 38185 */
    0xEFC4, 0x952C,    /* '锬' -> 38188 */
    0xEFC5, 0x9531,    /* '锱' -> 38193 */
    0xEFC6, 0x9532,    /* '锲' -> 38194 */
    0xEFC7, 0x9534,    /* '锴' -> 38196 */
    0xEFC8, 0x9536,    /* '锶' -> 38198 */
    0xEFC9, 0x9537,    /* '锷' -> 38199 */
    0xEFCA, 0x9538,    /* '锸' -> 38200 */
    0xEFCB, 0x953C,    /* '锼' -> 38204 */
    0xEFCC, 0x953E,    /* '锾' -> 38206 */
    0xEFCD, 0x953F,    /* '锿' -> 38207 */
    0xEFCE, 0x9542,    /* '镂' -> 38210 */
    0xEFCF, 0x9535,    /* '锵' -> 38197 */
    0xEFD0, 0x9544,    /* '镄' -> 38212 */
    0xEFD1, 0x9545,    /* '镅' -> 38213 */
    0xEFD2, 0x9546,    /* '镆' -> 38214 */
    0xEFD3, 0x9549,    /* '镉' -> 38217 */
    0xEFD4, 0x954C,    /* '镌' -> 38220 */
    0xEFD5, 0x954E,    /* '镎' -> 38222 */
    0xEFD6, 0x954F,    /* '镏' -> 38223 */
    0xEFD7, 0x9552,    /* '镒' -> 38226 */
    0xEFD8, 0x9553,    /* '镓' -> 38227 */
    0xEFD9, 0x9554,    /* '镔' -> 38228 */
    0xEFDA, 0x9556,    /* '镖' -> 38230 */
    0xEFDB, 0x9557,    /* '镗' -> 38231 */
    0xEFDC, 0x9558,    /* '镘' -> 38232 */
    0xEFDD, 0x9559,    /* '镙' -> 38233 */
    0xEFDE, 0x955B,    /* '镛' -> 38235 */
    0xEFDF, 0x955E,    /* '镞' -> 38238 */
    0xEFE0, 0x955F,    /* '镟' -> 38239 */
    0xEFE1, 0x955D,    /* '镝' -> 38237 */
    0xEFE2, 0x9561,    /* '镡' -> 38241 */
    0xEFE3, 0x9562,    /* '镢' -> 38242 */
    0xEFE4, 0x9564,    /* '镤' -> 38244 */
    0xEFE5, 0x9565,    /* '镥' -> 38245 */
    0xEFE6, 0x9566,    /* '镦' -> 38246 */
    0xEFE7, 0x9567,    /* '镧' -> 38247 */
    0xEFE8, 0x9568,    /* '镨' -> 38248 */
    0xEFE9, 0x9569,    /* '镩' -> 38249 */
    0xEFEA, 0x956A,    /* '镪' -> 38250 */
    0xEFEB, 0x956B,    /* '镫' -> 38251 */
    0xEFEC, 0x956C,    /* '镬' -> 38252 */
    0xEFED, 0x956F,    /* '镯' -> 38255 */
    0xEFEE, 0x9571,    /* '镱' -> 38257 */
    0xEFEF, 0x9572,    /* '镲' -> 38258 */
    0xEFF0, 0x9573,    /* '镳' -> 38259 */
    0xEFF1, 0x953A,    /* '锺' -> 38202 */
    0xEFF2, 0x77E7,    /* '矧' -> 30695 */
    0xEFF3, 0x77EC,    /* '矬' -> 30700 */
    0xEFF4, 0x96C9,    /* '雉' -> 38601 */
    0xEFF5, 0x79D5,    /* '秕' -> 31189 */
    0xEFF6, 0x79ED,    /* '秭' -> 31213 */
    0xEFF7, 0x79E3,    /* '秣' -> 31203 */
    0xEFF8, 0x79EB,    /* '秫' -> 31211 */
    0xEFF9, 0x7A06,    /* '稆' -> 31238 */
    0xEFFA, 0x5D47,    /* '嵇' -> 23879 */
    0xEFFB, 0x7A03,    /* '稃' -> 31235 */
    0xEFFC, 0x7A02,    /* '稂' -> 31234 */
    0xEFFD, 0x7A1E,    /* '稞' -> 31262 */
    0xEFFE, 0x7A14,    /* '稔' -> 31252 */
    0xF0A1, 0x7A39,    /* '稹' -> 31289 */
    0xF0A2, 0x7A37,    /* '稷' -> 31287 */
    0xF0A3, 0x7A51,    /* '穑' -> 31313 */
    0xF0A4, 0x9ECF,    /* '黏' -> 40655 */
    0xF0A5, 0x99A5,    /* '馥' -> 39333 */
    0xF0A6, 0x7A70,    /* '穰' -> 31344 */
    0xF0A7, 0x7688,    /* '皈' -> 30344 */
    0xF0A8, 0x768E,    /* '皎' -> 30350 */
    0xF0A9, 0x7693,    /* '皓' -> 30355 */
    0xF0AA, 0x7699,    /* '皙' -> 30361 */
    0xF0AB, 0x76A4,    /* '皤' -> 30372 */
    0xF0AC, 0x74DE,    /* '瓞' -> 29918 */
    0xF0AD, 0x74E0,    /* '瓠' -> 29920 */
    0xF0AE, 0x752C,    /* '甬' -> 29996 */
    0xF0AF, 0x9E20,    /* '鸠' -> 40480 */
    0xF0B0, 0x9E22,    /* '鸢' -> 40482 */
    0xF0B1, 0x9E28,    /* '鸨' -> 40488 */
    0xF0B2, 0x9E29,    /* '鸩' -> 40489 */
    0xF0B3, 0x9E2A,    /* '鸪' -> 40490 */
    0xF0B4, 0x9E2B,    /* '鸫' -> 40491 */
    0xF0B5, 0x9E2C,    /* '鸬' -> 40492 */
    0xF0B6, 0x9E32,    /* '鸲' -> 40498 */
    0xF0B7, 0x9E31,    /* '鸱' -> 40497 */
    0xF0B8, 0x9E36,    /* '鸶' -> 40502 */
    0xF0B9, 0x9E38,    /* '鸸' -> 40504 */
    0xF0BA, 0x9E37,    /* '鸷' -> 40503 */
    0xF0BB, 0x9E39,    /* '鸹' -> 40505 */
    0xF0BC, 0x9E3A,    /* '鸺' -> 40506 */
    0xF0BD, 0x9E3E,    /* '鸾' -> 40510 */
    0xF0BE, 0x9E41,    /* '鹁' -> 40513 */
    0xF0BF, 0x9E42,    /* '鹂' -> 40514 */
    0xF0C0, 0x9E44,    /* '鹄' -> 40516 */
    0xF0C1, 0x9E46,    /* '鹆' -> 40518 */
    0xF0C2, 0x9E47,    /* '鹇' -> 40519 */
    0xF0C3, 0x9E48,    /* '鹈' -> 40520 */
    0xF0C4, 0x9E49,    /* '鹉' -> 40521 */
    0xF0C5, 0x9E4B,    /* '鹋' -> 40523 */
    0xF0C6, 0x9E4C,    /* '鹌' -> 40524 */
    0xF0C7, 0x9E4E,    /* '鹎' -> 40526 */
    0xF0C8, 0x9E51,    /* '鹑' -> 40529 */
    0xF0C9, 0x9E55,    /* '鹕' -> 40533 */
    0xF0CA, 0x9E57,    /* '鹗' -> 40535 */
    0xF0CB, 0x9E5A,    /* '鹚' -> 40538 */
    0xF0CC, 0x9E5B,    /* '鹛' -> 40539 */
    0xF0CD, 0x9E5C,    /* '鹜' -> 40540 */
    0xF0CE, 0x9E5E,    /* '鹞' -> 40542 */
    0xF0CF, 0x9E63,    /* '鹣' -> 40547 */
    0xF0D0, 0x9E66,    /* '鹦' -> 40550 */
    0xF0D1, 0x9E67,    /* '鹧' -> 40551 */
    0xF0D2, 0x9E68,    /* '鹨' -> 40552 */
    0xF0D3, 0x9E69,    /* '鹩' -> 40553 */
    0xF0D4, 0x9E6A,    /* '鹪' -> 40554 */
    0xF0D5, 0x9E6B,    /* '鹫' -> 40555 */
    0xF0D6, 0x9E6C,    /* '鹬' -> 40556 */
    0xF0D7, 0x9E71,    /* '鹱' -> 40561 */
    0xF0D8, 0x9E6D,    /* '鹭' -> 40557 */
    0xF0D9, 0x9E73,    /* '鹳' -> 40563 */
    0xF0DA, 0x7592,    /* '疒' -> 30098 */
    0xF0DB, 0x7594,    /* '疔' -> 30100 */
    0xF0DC, 0x7596,    /* '疖' -> 30102 */
    0xF0DD, 0x75A0,    /* '疠' -> 30112 */
    0xF0DE, 0x759D,    /* '疝' -> 30109 */
    0xF0DF, 0x75AC,    /* '疬' -> 30124 */
    0xF0E0, 0x75A3,    /* '疣' -> 30115 */
    0xF0E1, 0x75B3,    /* '疳' -> 30131 */
    0xF0E2, 0x75B4,    /* '疴' -> 30132 */
    0xF0E3, 0x75B8,    /* '疸' -> 30136 */
    0xF0E4, 0x75C4,    /* '痄' -> 30148 */
    0xF0E5, 0x75B1,    /* '疱' -> 30129 */
    0xF0E6, 0x75B0,    /* '疰' -> 30128 */
    0xF0E7, 0x75C3,    /* '痃' -> 30147 */
    0xF0E8, 0x75C2,    /* '痂' -> 30146 */
    0xF0E9, 0x75D6,    /* '痖' -> 30166 */
    0xF0EA, 0x75CD,    /* '痍' -> 30157 */
    0xF0EB, 0x75E3,    /* '痣' -> 30179 */
    0xF0EC, 0x75E8,    /* '痨' -> 30184 */
    0xF0ED, 0x75E6,    /* '痦' -> 30182 */
    0xF0EE, 0x75E4,    /* '痤' -> 30180 */
    0xF0EF, 0x75EB,    /* '痫' -> 30187 */
    0xF0F0, 0x75E7,    /* '痧' -> 30183 */
    0xF0F1, 0x7603,    /* '瘃' -> 30211 */
    0xF0F2, 0x75F1,    /* '痱' -> 30193 */
    0xF0F3, 0x75FC,    /* '痼' -> 30204 */
    0xF0F4, 0x75FF,    /* '痿' -> 30207 */
    0xF0F5, 0x7610,    /* '瘐' -> 30224 */
    0xF0F6, 0x7600,    /* '瘀' -> 30208 */
    0xF0F7, 0x7605,    /* '瘅' -> 30213 */
    0xF0F8, 0x760C,    /* '瘌' -> 30220 */
    0xF0F9, 0x7617,    /* '瘗' -> 30231 */
    0xF0FA, 0x760A,    /* '瘊' -> 30218 */
    0xF0FB, 0x7625,    /* '瘥' -> 30245 */
    0xF0FC, 0x7618,    /* '瘘' -> 30232 */
    0xF0FD, 0x7615,    /* '瘕' -> 30229 */
    0xF0FE, 0x7619,    /* '瘙' -> 30233 */
    0xF1A1, 0x761B,    /* '瘛' -> 30235 */
    0xF1A2, 0x763C,    /* '瘼' -> 30268 */
    0xF1A3, 0x7622,    /* '瘢' -> 30242 */
    0xF1A4, 0x7620,    /* '瘠' -> 30240 */
    0xF1A5, 0x7640,    /* '癀' -> 30272 */
    0xF1A6, 0x762D,    /* '瘭' -> 30253 */
    0xF1A7, 0x7630,    /* '瘰' -> 30256 */
    0xF1A8, 0x763F,    /* '瘿' -> 30271 */
    0xF1A9, 0x7635,    /* '瘵' -> 30261 */
    0xF1AA, 0x7643,    /* '癃' -> 30275 */
    0xF1AB, 0x763E,    /* '瘾' -> 30270 */
    0xF1AC, 0x7633,    /* '瘳' -> 30259 */
    0xF1AD, 0x764D,    /* '癍' -> 30285 */
    0xF1AE, 0x765E,    /* '癞' -> 30302 */
    0xF1AF, 0x7654,    /* '癔' -> 30292 */
    0xF1B0, 0x765C,    /* '癜' -> 30300 */
    0xF1B1, 0x7656,    /* '癖' -> 30294 */
    0xF1B2, 0x766B,    /* '癫' -> 30315 */
    0xF1B3, 0x766F,    /* '癯' -> 30319 */
    0xF1B4, 0x7FCA,    /* '翊' -> 32714 */
    0xF1B5, 0x7AE6,    /* '竦' -> 31462 */
    0xF1B6, 0x7A78,    /* '穸' -> 31352 */
    0xF1B7, 0x7A79,    /* '穹' -> 31353 */
    0xF1B8, 0x7A80,    /* '窀' -> 31360 */
    0xF1B9, 0x7A86,    /* '窆' -> 31366 */
    0xF1BA, 0x7A88,    /* '窈' -> 31368 */
    0xF1BB, 0x7A95,    /* '窕' -> 31381 */
    0xF1BC, 0x7AA6,    /* '窦' -> 31398 */
    0xF1BD, 0x7AA0,    /* '窠' -> 31392 */
    0xF1BE, 0x7AAC,    /* '窬' -> 31404 */
    0xF1BF, 0x7AA8,    /* '窨' -> 31400 */
    0xF1C0, 0x7AAD,    /* '窭' -> 31405 */
    0xF1C1, 0x7AB3,    /* '窳' -> 31411 */
    0xF1C2, 0x8864,    /* '衤' -> 34916 */
    0xF1C3, 0x8869,    /* '衩' -> 34921 */
    0xF1C4, 0x8872,    /* '衲' -> 34930 */
    0xF1C5, 0x887D,    /* '衽' -> 34941 */
    0xF1C6, 0x887F,    /* '衿' -> 34943 */
    0xF1C7, 0x8882,    /* '袂' -> 34946 */
    0xF1C8, 0x88A2,    /* '袢' -> 34978 */
    0xF1C9, 0x88C6,    /* '裆' -> 35014 */
    0xF1CA, 0x88B7,    /* '袷' -> 34999 */
    0xF1CB, 0x88BC,    /* '袼' -> 35004 */
    0xF1CC, 0x88C9,    /* '裉' -> 35017 */
    0xF1CD, 0x88E2,    /* '裢' -> 35042 */
    0xF1CE, 0x88CE,    /* '裎' -> 35022 */
    0xF1CF, 0x88E3,    /* '裣' -> 35043 */
    0xF1D0, 0x88E5,    /* '裥' -> 35045 */
    0xF1D1, 0x88F1,    /* '裱' -> 35057 */
    0xF1D2, 0x891A,    /* '褚' -> 35098 */
    0xF1D3, 0x88FC,    /* '裼' -> 35068 */
    0xF1D4, 0x88E8,    /* '裨' -> 35048 */
    0xF1D5, 0x88FE,    /* '裾' -> 35070 */
    0xF1D6, 0x88F0,    /* '裰' -> 35056 */
    0xF1D7, 0x8921,    /* '褡' -> 35105 */
    0xF1D8, 0x8919,    /* '褙' -> 35097 */
    0xF1D9, 0x8913,    /* '褓' -> 35091 */
    0xF1DA, 0x891B,    /* '褛' -> 35099 */
    0xF1DB, 0x890A,    /* '褊' -> 35082 */
    0xF1DC, 0x8934,    /* '褴' -> 35124 */
    0xF1DD, 0x892B,    /* '褫' -> 35115 */
    0xF1DE, 0x8936,    /* '褶' -> 35126 */
    0xF1DF, 0x8941,    /* '襁' -> 35137 */
    0xF1E0, 0x8966,    /* '襦' -> 35174 */
    0xF1E1, 0x897B,    /* '襻' -> 35195 */
    0xF1E2, 0x758B,    /* '疋' -> 30091 */
    0xF1E3, 0x80E5,    /* '胥' -> 32997 */
    0xF1E4, 0x76B2,    /* '皲' -> 30386 */
    0xF1E5, 0x76B4,    /* '皴' -> 30388 */
    0xF1E6, 0x77DC,    /* '矜' -> 30684 */
    0xF1E7, 0x8012,    /* '耒' -> 32786 */
    0xF1E8, 0x8014,    /* '耔' -> 32788 */
    0xF1E9, 0x8016,    /* '耖' -> 32790 */
    0xF1EA, 0x801C,    /* '耜' -> 32796 */
    0xF1EB, 0x8020,    /* '耠' -> 32800 */
    0xF1EC, 0x8022,    /* '耢' -> 32802 */
    0xF1ED, 0x8025,    /* '耥' -> 32805 */
    0xF1EE, 0x8026,    /* '耦' -> 32806 */
    0xF1EF, 0x8027,    /* '耧' -> 32807 */
    0xF1F0, 0x8029,    /* '耩' -> 32809 */
    0xF1F1, 0x8028,    /* '耨' -> 32808 */
    0xF1F2, 0x8031,    /* '耱' -> 32817 */
    0xF1F3, 0x800B,    /* '耋' -> 32779 */
    0xF1F4, 0x8035,    /* '耵' -> 32821 */
    0xF1F5, 0x8043,    /* '聃' -> 32835 */
    0xF1F6, 0x8046,    /* '聆' -> 32838 */
    0xF1F7, 0x804D,    /* '聍' -> 32845 */
    0xF1F8, 0x8052,    /* '聒' -> 32850 */
    0xF1F9, 0x8069,    /* '聩' -> 32873 */
    0xF1FA, 0x8071,    /* '聱' -> 32881 */
    0xF1FB, 0x8983,    /* '覃' -> 35203 */
    0xF1FC, 0x9878,    /* '顸' -> 39032 */
    0xF1FD, 0x9880,    /* '颀' -> 39040 */
    0xF1FE, 0x9883,    /* '颃' -> 39043 */
    0xF2A1, 0x9889,    /* '颉' -> 39049 */
    0xF2A2, 0x988C,    /* '颌' -> 39052 */
    0xF2A3, 0x988D,    /* '颍' -> 39053 */
    0xF2A4, 0x988F,    /* '颏' -> 39055 */
    0xF2A5, 0x9894,    /* '颔' -> 39060 */
    0xF2A6, 0x989A,    /* '颚' -> 39066 */
    0xF2A7, 0x989B,    /* '颛' -> 39067 */
    0xF2A8, 0x989E,    /* '颞' -> 39070 */
    0xF2A9, 0x989F,    /* '颟' -> 39071 */
    0xF2AA, 0x98A1,    /* '颡' -> 39073 */
    0xF2AB, 0x98A2,    /* '颢' -> 39074 */
    0xF2AC, 0x98A5,    /* '颥' -> 39077 */
    0xF2AD, 0x98A6,    /* '颦' -> 39078 */
    0xF2AE, 0x864D,    /* '虍' -> 34381 */
    0xF2AF, 0x8654,    /* '虔' -> 34388 */
    0xF2B0, 0x866C,    /* '虬' -> 34412 */
    0xF2B1, 0x866E,    /* '虮' -> 34414 */
    0xF2B2, 0x867F,    /* '虿' -> 34431 */
    0xF2B3, 0x867A,    /* '虺' -> 34426 */
    0xF2B4, 0x867C,    /* '虼' -> 34428 */
    0xF2B5, 0x867B,    /* '虻' -> 34427 */
    0xF2B6, 0x86A8,    /* '蚨' -> 34472 */
    0xF2B7, 0x868D,    /* '蚍' -> 34445 */
    0xF2B8, 0x868B,    /* '蚋' -> 34443 */
    0xF2B9, 0x86AC,    /* '蚬' -> 34476 */
    0xF2BA, 0x869D,    /* '蚝' -> 34461 */
    0xF2BB, 0x86A7,    /* '蚧' -> 34471 */
    0xF2BC, 0x86A3,    /* '蚣' -> 34467 */
    0xF2BD, 0x86AA,    /* '蚪' -> 34474 */
    0xF2BE, 0x8693,    /* '蚓' -> 34451 */
    0xF2BF, 0x86A9,    /* '蚩' -> 34473 */
    0xF2C0, 0x86B6,    /* '蚶' -> 34486 */
    0xF2C1, 0x86C4,    /* '蛄' -> 34500 */
    0xF2C2, 0x86B5,    /* '蚵' -> 34485 */
    0xF2C3, 0x86CE,    /* '蛎' -> 34510 */
    0xF2C4, 0x86B0,    /* '蚰' -> 34480 */
    0xF2C5, 0x86BA,    /* '蚺' -> 34490 */
    0xF2C6, 0x86B1,    /* '蚱' -> 34481 */
    0xF2C7, 0x86AF,    /* '蚯' -> 34479 */
    0xF2C8, 0x86C9,    /* '蛉' -> 34505 */
    0xF2C9, 0x86CF,    /* '蛏' -> 34511 */
    0xF2CA, 0x86B4,    /* '蚴' -> 34484 */
    0xF2CB, 0x86E9,    /* '蛩' -> 34537 */
    0xF2CC, 0x86F1,    /* '蛱' -> 34545 */
    0xF2CD, 0x86F2,    /* '蛲' -> 34546 */
    0xF2CE, 0x86ED,    /* '蛭' -> 34541 */
    0xF2CF, 0x86F3,    /* '蛳' -> 34547 */
    0xF2D0, 0x86D0,    /* '蛐' -> 34512 */
    0xF2D1, 0x8713,    /* '蜓' -> 34579 */
    0xF2D2, 0x86DE,    /* '蛞' -> 34526 */
    0xF2D3, 0x86F4,    /* '蛴' -> 34548 */
    0xF2D4, 0x86DF,    /* '蛟' -> 34527 */
    0xF2D5, 0x86D8,    /* '蛘' -> 34520 */
    0xF2D6, 0x86D1,    /* '蛑' -> 34513 */
    0xF2D7, 0x8703,    /* '蜃' -> 34563 */
    0xF2D8, 0x8707,    /* '蜇' -> 34567 */
    0xF2D9, 0x86F8,    /* '蛸' -> 34552 */
    0xF2DA, 0x8708,    /* '蜈' -> 34568 */
    0xF2DB, 0x870A,    /* '蜊' -> 34570 */
    0xF2DC, 0x870D,    /* '蜍' -> 34573 */
    0xF2DD, 0x8709,    /* '蜉' -> 34569 */
    0xF2DE, 0x8723,    /* '蜣' -> 34595 */
    0xF2DF, 0x873B,    /* '蜻' -> 34619 */
    0xF2E0, 0x871E,    /* '蜞' -> 34590 */
    0xF2E1, 0x8725,    /* '蜥' -> 34597 */
    0xF2E2, 0x872E,    /* '蜮' -> 34606 */
    0xF2E3, 0x871A,    /* '蜚' -> 34586 */
    0xF2E4, 0x873E,    /* '蜾' -> 34622 */
    0xF2E5, 0x8748,    /* '蝈' -> 34632 */
    0xF2E6, 0x8734,    /* '蜴' -> 34612 */
    0xF2E7, 0x8731,    /* '蜱' -> 34609 */
    0xF2E8, 0x8729,    /* '蜩' -> 34601 */
    0xF2E9, 0x8737,    /* '蜷' -> 34615 */
    0xF2EA, 0x873F,    /* '蜿' -> 34623 */
    0xF2EB, 0x8782,    /* '螂' -> 34690 */
    0xF2EC, 0x8722,    /* '蜢' -> 34594 */
    0xF2ED, 0x877D,    /* '蝽' -> 34685 */
    0xF2EE, 0x877E,    /* '蝾' -> 34686 */
    0xF2EF, 0x877B,    /* '蝻' -> 34683 */
    0xF2F0, 0x8760,    /* '蝠' -> 34656 */
    0xF2F1, 0x8770,    /* '蝰' -> 34672 */
    0xF2F2, 0x874C,    /* '蝌' -> 34636 */
    0xF2F3, 0x876E,    /* '蝮' -> 34670 */
    0xF2F4, 0x878B,    /* '螋' -> 34699 */
    0xF2F5, 0x8753,    /* '蝓' -> 34643 */
    0xF2F6, 0x8763,    /* '蝣' -> 34659 */
    0xF2F7, 0x877C,    /* '蝼' -> 34684 */
    0xF2F8, 0x8764,    /* '蝤' -> 34660 */
    0xF2F9, 0x8759,    /* '蝙' -> 34649 */
    0xF2FA, 0x8765,    /* '蝥' -> 34661 */
    0xF2FB, 0x8793,    /* '螓' -> 34707 */
    0xF2FC, 0x87AF,    /* '螯' -> 34735 */
    0xF2FD, 0x87A8,    /* '螨' -> 34728 */
    0xF2FE, 0x87D2,    /* '蟒' -> 34770 */
    0xF3A1, 0x87C6,    /* '蟆' -> 34758 */
    0xF3A2, 0x8788,    /* '螈' -> 34696 */
    0xF3A3, 0x8785,    /* '螅' -> 34693 */
    0xF3A4, 0x87AD,    /* '螭' -> 34733 */
    0xF3A5, 0x8797,    /* '螗' -> 34711 */
    0xF3A6, 0x8783,    /* '螃' -> 34691 */
    0xF3A7, 0x87AB,    /* '螫' -> 34731 */
    0xF3A8, 0x87E5,    /* '蟥' -> 34789 */
    0xF3A9, 0x87AC,    /* '螬' -> 34732 */
    0xF3AA, 0x87B5,    /* '螵' -> 34741 */
    0xF3AB, 0x87B3,    /* '螳' -> 34739 */
    0xF3AC, 0x87CB,    /* '蟋' -> 34763 */
    0xF3AD, 0x87D3,    /* '蟓' -> 34771 */
    0xF3AE, 0x87BD,    /* '螽' -> 34749 */
    0xF3AF, 0x87D1,    /* '蟑' -> 34769 */
    0xF3B0, 0x87C0,    /* '蟀' -> 34752 */
    0xF3B1, 0x87CA,    /* '蟊' -> 34762 */
    0xF3B2, 0x87DB,    /* '蟛' -> 34779 */
    0xF3B3, 0x87EA,    /* '蟪' -> 34794 */
    0xF3B4, 0x87E0,    /* '蟠' -> 34784 */
    0xF3B5, 0x87EE,    /* '蟮' -> 34798 */
    0xF3B6, 0x8816,    /* '蠖' -> 34838 */
    0xF3B7, 0x8813,    /* '蠓' -> 34835 */
    0xF3B8, 0x87FE,    /* '蟾' -> 34814 */
    0xF3B9, 0x880A,    /* '蠊' -> 34826 */
    0xF3BA, 0x881B,    /* '蠛' -> 34843 */
    0xF3BB, 0x8821,    /* '蠡' -> 34849 */
    0xF3BC, 0x8839,    /* '蠹' -> 34873 */
    0xF3BD, 0x883C,    /* '蠼' -> 34876 */
    0xF3BE, 0x7F36,    /* '缶' -> 32566 */
    0xF3BF, 0x7F42,    /* '罂' -> 32578 */
    0xF3C0, 0x7F44,    /* '罄' -> 32580 */
    0xF3C1, 0x7F45,    /* '罅' -> 32581 */
    0xF3C2, 0x8210,    /* '舐' -> 33296 */
    0xF3C3, 0x7AFA,    /* '竺' -> 31482 */
    0xF3C4, 0x7AFD,    /* '竽' -> 31485 */
    0xF3C5, 0x7B08,    /* '笈' -> 31496 */
    0xF3C6, 0x7B03,    /* '笃' -> 31491 */
    0xF3C7, 0x7B04,    /* '笄' -> 31492 */
    0xF3C8, 0x7B15,    /* '笕' -> 31509 */
    0xF3C9, 0x7B0A,    /* '笊' -> 31498 */
    0xF3CA, 0x7B2B,    /* '笫' -> 31531 */
    0xF3CB, 0x7B0F,    /* '笏' -> 31503 */
    0xF3CC, 0x7B47,    /* '筇' -> 31559 */
    0xF3CD, 0x7B38,    /* '笸' -> 31544 */
    0xF3CE, 0x7B2A,    /* '笪' -> 31530 */
    0xF3CF, 0x7B19,    /* '笙' -> 31513 */
    0xF3D0, 0x7B2E,    /* '笮' -> 31534 */
    0xF3D1, 0x7B31,    /* '笱' -> 31537 */
    0xF3D2, 0x7B20,    /* '笠' -> 31520 */
    0xF3D3, 0x7B25,    /* '笥' -> 31525 */
    0xF3D4, 0x7B24,    /* '笤' -> 31524 */
    0xF3D5, 0x7B33,    /* '笳' -> 31539 */
    0xF3D6, 0x7B3E,    /* '笾' -> 31550 */
    0xF3D7, 0x7B1E,    /* '笞' -> 31518 */
    0xF3D8, 0x7B58,    /* '筘' -> 31576 */
    0xF3D9, 0x7B5A,    /* '筚' -> 31578 */
    0xF3DA, 0x7B45,    /* '筅' -> 31557 */
    0xF3DB, 0x7B75,    /* '筵' -> 31605 */
    0xF3DC, 0x7B4C,    /* '筌' -> 31564 */
    0xF3DD, 0x7B5D,    /* '筝' -> 31581 */
    0xF3DE, 0x7B60,    /* '筠' -> 31584 */
    0xF3DF, 0x7B6E,    /* '筮' -> 31598 */
    0xF3E0, 0x7B7B,    /* '筻' -> 31611 */
    0xF3E1, 0x7B62,    /* '筢' -> 31586 */
    0xF3E2, 0x7B72,    /* '筲' -> 31602 */
    0xF3E3, 0x7B71,    /* '筱' -> 31601 */
    0xF3E4, 0x7B90,    /* '箐' -> 31632 */
    0xF3E5, 0x7BA6,    /* '箦' -> 31654 */
    0xF3E6, 0x7BA7,    /* '箧' -> 31655 */
    0xF3E7, 0x7BB8,    /* '箸' -> 31672 */
    0xF3E8, 0x7BAC,    /* '箬' -> 31660 */
    0xF3E9, 0x7B9D,    /* '箝' -> 31645 */
    0xF3EA, 0x7BA8,    /* '箨' -> 31656 */
    0xF3EB, 0x7B85,    /* '箅' -> 31621 */
    0xF3EC, 0x7BAA,    /* '箪' -> 31658 */
    0xF3ED, 0x7B9C,    /* '箜' -> 31644 */
    0xF3EE, 0x7BA2,    /* '箢' -> 31650 */
    0xF3EF, 0x7BAB,    /* '箫' -> 31659 */
    0xF3F0, 0x7BB4,    /* '箴' -> 31668 */
    0xF3F1, 0x7BD1,    /* '篑' -> 31697 */
    0xF3F2, 0x7BC1,    /* '篁' -> 31681 */
    0xF3F3, 0x7BCC,    /* '篌' -> 31692 */
    0xF3F4, 0x7BDD,    /* '篝' -> 31709 */
    0xF3F5, 0x7BDA,    /* '篚' -> 31706 */
    0xF3F6, 0x7BE5,    /* '篥' -> 31717 */
    0xF3F7, 0x7BE6,    /* '篦' -> 31718 */
    0xF3F8, 0x7BEA,    /* '篪' -> 31722 */
    0xF3F9, 0x7C0C,    /* '簌' -> 31756 */
    0xF3FA, 0x7BFE,    /* '篾' -> 31742 */
    0xF3FB, 0x7BFC,    /* '篼' -> 31740 */
    0xF3FC, 0x7C0F,    /* '簏' -> 31759 */
    0xF3FD, 0x7C16,    /* '簖' -> 31766 */
    0xF3FE, 0x7C0B,    /* '簋' -> 31755 */
    0xF4A1, 0x7C1F,    /* '簟' -> 31775 */
    0xF4A2, 0x7C2A,    /* '簪' -> 31786 */
    0xF4A3, 0x7C26,    /* '簦' -> 31782 */
    0xF4A4, 0x7C38,    /* '簸' -> 31800 */
    0xF4A5, 0x7C41,    /* '籁' -> 31809 */
    0xF4A6, 0x7C40,    /* '籀' -> 31808 */
    0xF4A7, 0x81FE,    /* '臾' -> 33278 */
    0xF4A8, 0x8201,    /* '舁' -> 33281 */
    0xF4A9, 0x8202,    /* '舂' -> 33282 */
    0xF4AA, 0x8204,    /* '舄' -> 33284 */
    0xF4AB, 0x81EC,    /* '臬' -> 33260 */
    0xF4AC, 0x8844,    /* '衄' -> 34884 */
    0xF4AD, 0x8221,    /* '舡' -> 33313 */
    0xF4AE, 0x8222,    /* '舢' -> 33314 */
    0xF4AF, 0x8223,    /* '舣' -> 33315 */
    0xF4B0, 0x822D,    /* '舭' -> 33325 */
    0xF4B1, 0x822F,    /* '舯' -> 33327 */
    0xF4B2, 0x8228,    /* '舨' -> 33320 */
    0xF4B3, 0x822B,    /* '舫' -> 33323 */
    0xF4B4, 0x8238,    /* '舸' -> 33336 */
    0xF4B5, 0x823B,    /* '舻' -> 33339 */
    0xF4B6, 0x8233,    /* '舳' -> 33331 */
    0xF4B7, 0x8234,    /* '舴' -> 33332 */
    0xF4B8, 0x823E,    /* '舾' -> 33342 */
    0xF4B9, 0x8244,    /* '艄' -> 33348 */
    0xF4BA, 0x8249,    /* '艉' -> 33353 */
    0xF4BB, 0x824B,    /* '艋' -> 33355 */
    0xF4BC, 0x824F,    /* '艏' -> 33359 */
    0xF4BD, 0x825A,    /* '艚' -> 33370 */
    0xF4BE, 0x825F,    /* '艟' -> 33375 */
    0xF4BF, 0x8268,    /* '艨' -> 33384 */
    0xF4C0, 0x887E,    /* '衾' -> 34942 */
    0xF4C1, 0x8885,    /* '袅' -> 34949 */
    0xF4C2, 0x8888,    /* '袈' -> 34952 */
    0xF4C3, 0x88D8,    /* '裘' -> 35032 */
    0xF4C4, 0x88DF,    /* '裟' -> 35039 */
    0xF4C5, 0x895E,    /* '襞' -> 35166 */
    0xF4C6, 0x7F9D,    /* '羝' -> 32669 */
    0xF4C7, 0x7F9F,    /* '羟' -> 32671 */
    0xF4C8, 0x7FA7,    /* '羧' -> 32679 */
    0xF4C9, 0x7FAF,    /* '羯' -> 32687 */
    0xF4CA, 0x7FB0,    /* '羰' -> 32688 */
    0xF4CB, 0x7FB2,    /* '羲' -> 32690 */
    0xF4CC, 0x7C7C,    /* '籼' -> 31868 */
    0xF4CD, 0x6549,    /* '敉' -> 25929 */
    0xF4CE, 0x7C91,    /* '粑' -> 31889 */
    0xF4CF, 0x7C9D,    /* '粝' -> 31901 */
    0xF4D0, 0x7C9C,    /* '粜' -> 31900 */
    0xF4D1, 0x7C9E,    /* '粞' -> 31902 */
    0xF4D2, 0x7CA2,    /* '粢' -> 31906 */
    0xF4D3, 0x7CB2,    /* '粲' -> 31922 */
    0xF4D4, 0x7CBC,    /* '粼' -> 31932 */
    0xF4D5, 0x7CBD,    /* '粽' -> 31933 */
    0xF4D6, 0x7CC1,    /* '糁' -> 31937 */
    0xF4D7, 0x7CC7,    /* '糇' -> 31943 */
    0xF4D8, 0x7CCC,    /* '糌' -> 31948 */
    0xF4D9, 0x7CCD,    /* '糍' -> 31949 */
    0xF4DA, 0x7CC8,    /* '糈' -> 31944 */
    0xF4DB, 0x7CC5,    /* '糅' -> 31941 */
    0xF4DC, 0x7CD7,    /* '糗' -> 31959 */
    0xF4DD, 0x7CE8,    /* '糨' -> 31976 */
    0xF4DE, 0x826E,    /* '艮' -> 33390 */
    0xF4DF, 0x66A8,    /* '暨' -> 26280 */
    0xF4E0, 0x7FBF,    /* '羿' -> 32703 */
    0xF4E1, 0x7FCE,    /* '翎' -> 32718 */
    0xF4E2, 0x7FD5,    /* '翕' -> 32725 */
    0xF4E3, 0x7FE5,    /* '翥' -> 32741 */
    0xF4E4, 0x7FE1,    /* '翡' -> 32737 */
    0xF4E5, 0x7FE6,    /* '翦' -> 32742 */
    0xF4E6, 0x7FE9,    /* '翩' -> 32745 */
    0xF4E7, 0x7FEE,    /* '翮' -> 32750 */
    0xF4E8, 0x7FF3,    /* '翳' -> 32755 */
    0xF4E9, 0x7CF8,    /* '糸' -> 31992 */
    0xF4EA, 0x7D77,    /* '絷' -> 32119 */
    0xF4EB, 0x7DA6,    /* '綦' -> 32166 */
    0xF4EC, 0x7DAE,    /* '綮' -> 32174 */
    0xF4ED, 0x7E47,    /* '繇' -> 32327 */
    0xF4EE, 0x7E9B,    /* '纛' -> 32411 */
    0xF4EF, 0x9EB8,    /* '麸' -> 40632 */
    0xF4F0, 0x9EB4,    /* '麴' -> 40628 */
    0xF4F1, 0x8D73,    /* '赳' -> 36211 */
    0xF4F2, 0x8D84,    /* '趄' -> 36228 */
    0xF4F3, 0x8D94,    /* '趔' -> 36244 */
    0xF4F4, 0x8D91,    /* '趑' -> 36241 */
    0xF4F5, 0x8DB1,    /* '趱' -> 36273 */
    0xF4F6, 0x8D67,    /* '赧' -> 36199 */
    0xF4F7, 0x8D6D,    /* '赭' -> 36205 */
    0xF4F8, 0x8C47,    /* '豇' -> 35911 */
    0xF4F9, 0x8C49,    /* '豉' -> 35913 */
    0xF4FA, 0x914A,    /* '酊' -> 37194 */
    0xF4FB, 0x9150,    /* '酐' -> 37200 */
    0xF4FC, 0x914E,    /* '酎' -> 37198 */
    0xF4FD, 0x914F,    /* '酏' -> 37199 */
    0xF4FE, 0x9164,    /* '酤' -> 37220 */
    0xF5A1, 0x9162,    /* '酢' -> 37218 */
    0xF5A2, 0x9161,    /* '酡' -> 37217 */
    0xF5A3, 0x9170,    /* '酰' -> 37232 */
    0xF5A4, 0x9169,    /* '酩' -> 37225 */
    0xF5A5, 0x916F,    /* '酯' -> 37231 */
    0xF5A6, 0x917D,    /* '酽' -> 37245 */
    0xF5A7, 0x917E,    /* '酾' -> 37246 */
    0xF5A8, 0x9172,    /* '酲' -> 37234 */
    0xF5A9, 0x9174,    /* '酴' -> 37236 */
    0xF5AA, 0x9179,    /* '酹' -> 37241 */
    0xF5AB, 0x918C,    /* '醌' -> 37260 */
    0xF5AC, 0x9185,    /* '醅' -> 37253 */
    0xF5AD, 0x9190,    /* '醐' -> 37264 */
    0xF5AE, 0x918D,    /* '醍' -> 37261 */
    0xF5AF, 0x9191,    /* '醑' -> 37265 */
    0xF5B0, 0x91A2,    /* '醢' -> 37282 */
    0xF5B1, 0x91A3,    /* '醣' -> 37283 */
    0xF5B2, 0x91AA,    /* '醪' -> 37290 */
    0xF5B3, 0x91AD,    /* '醭' -> 37293 */
    0xF5B4, 0x91AE,    /* '醮' -> 37294 */
    0xF5B5, 0x91AF,    /* '醯' -> 37295 */
    0xF5B6, 0x91B5,    /* '醵' -> 37301 */
    0xF5B7, 0x91B4,    /* '醴' -> 37300 */
    0xF5B8, 0x91BA,    /* '醺' -> 37306 */
    0xF5B9, 0x8C55,    /* '豕' -> 35925 */
    0xF5BA, 0x9E7E,    /* '鹾' -> 40574 */
    0xF5BB, 0x8DB8,    /* '趸' -> 36280 */
    0xF5BC, 0x8DEB,    /* '跫' -> 36331 */
    0xF5BD, 0x8E05,    /* '踅' -> 36357 */
    0xF5BE, 0x8E59,    /* '蹙' -> 36441 */
    0xF5BF, 0x8E69,    /* '蹩' -> 36457 */
    0xF5C0, 0x8DB5,    /* '趵' -> 36277 */
    0xF5C1, 0x8DBF,    /* '趿' -> 36287 */
    0xF5C2, 0x8DBC,    /* '趼' -> 36284 */
    0xF5C3, 0x8DBA,    /* '趺' -> 36282 */
    0xF5C4, 0x8DC4,    /* '跄' -> 36292 */
    0xF5C5, 0x8DD6,    /* '跖' -> 36310 */
    0xF5C6, 0x8DD7,    /* '跗' -> 36311 */
    0xF5C7, 0x8DDA,    /* '跚' -> 36314 */
    0xF5C8, 0x8DDE,    /* '跞' -> 36318 */
    0xF5C9, 0x8DCE,    /* '跎' -> 36302 */
    0xF5CA, 0x8DCF,    /* '跏' -> 36303 */
    0xF5CB, 0x8DDB,    /* '跛' -> 36315 */
    0xF5CC, 0x8DC6,    /* '跆' -> 36294 */
    0xF5CD, 0x8DEC,    /* '跬' -> 36332 */
    0xF5CE, 0x8DF7,    /* '跷' -> 36343 */
    0xF5CF, 0x8DF8,    /* '跸' -> 36344 */
    0xF5D0, 0x8DE3,    /* '跣' -> 36323 */
    0xF5D1, 0x8DF9,    /* '跹' -> 36345 */
    0xF5D2, 0x8DFB,    /* '跻' -> 36347 */
    0xF5D3, 0x8DE4,    /* '跤' -> 36324 */
    0xF5D4, 0x8E09,    /* '踉' -> 36361 */
    0xF5D5, 0x8DFD,    /* '跽' -> 36349 */
    0xF5D6, 0x8E14,    /* '踔' -> 36372 */
    0xF5D7, 0x8E1D,    /* '踝' -> 36381 */
    0xF5D8, 0x8E1F,    /* '踟' -> 36383 */
    0xF5D9, 0x8E2C,    /* '踬' -> 36396 */
    0xF5DA, 0x8E2E,    /* '踮' -> 36398 */
    0xF5DB, 0x8E23,    /* '踣' -> 36387 */
    0xF5DC, 0x8E2F,    /* '踯' -> 36399 */
    0xF5DD, 0x8E3A,    /* '踺' -> 36410 */
    0xF5DE, 0x8E40,    /* '蹀' -> 36416 */
    0xF5DF, 0x8E39,    /* '踹' -> 36409 */
    0xF5E0, 0x8E35,    /* '踵' -> 36405 */
    0xF5E1, 0x8E3D,    /* '踽' -> 36413 */
    0xF5E2, 0x8E31,    /* '踱' -> 36401 */
    0xF5E3, 0x8E49,    /* '蹉' -> 36425 */
    0xF5E4, 0x8E41,    /* '蹁' -> 36417 */
    0xF5E5, 0x8E42,    /* '蹂' -> 36418 */
    0xF5E6, 0x8E51,    /* '蹑' -> 36433 */
    0xF5E7, 0x8E52,    /* '蹒' -> 36434 */
    0xF5E8, 0x8E4A,    /* '蹊' -> 36426 */
    0xF5E9, 0x8E70,    /* '蹰' -> 36464 */
    0xF5EA, 0x8E76,    /* '蹶' -> 36470 */
    0xF5EB, 0x8E7C,    /* '蹼' -> 36476 */
    0xF5EC, 0x8E6F,    /* '蹯' -> 36463 */
    0xF5ED, 0x8E74,    /* '蹴' -> 36468 */
    0xF5EE, 0x8E85,    /* '躅' -> 36485 */
    0xF5EF, 0x8E8F,    /* '躏' -> 36495 */
    0xF5F0, 0x8E94,    /* '躔' -> 36500 */
    0xF5F1, 0x8E90,    /* '躐' -> 36496 */
    0xF5F2, 0x8E9C,    /* '躜' -> 36508 */
    0xF5F3, 0x8E9E,    /* '躞' -> 36510 */
    0xF5F4, 0x8C78,    /* '豸' -> 35960 */
    0xF5F5, 0x8C82,    /* '貂' -> 35970 */
    0xF5F6, 0x8C8A,    /* '貊' -> 35978 */
    0xF5F7, 0x8C85,    /* '貅' -> 35973 */
    0xF5F8, 0x8C98,    /* '貘' -> 35992 */
    0xF5F9, 0x8C94,    /* '貔' -> 35988 */
    0xF5FA, 0x659B,    /* '斛' -> 26011 */
    0xF5FB, 0x89D6,    /* '觖' -> 35286 */
    0xF5FC, 0x89DE,    /* '觞' -> 35294 */
    0xF5FD, 0x89DA,    /* '觚' -> 35290 */
    0xF5FE, 0x89DC,    /* '觜' -> 35292 */
    0xF6A1, 0x89E5,    /* '觥' -> 35301 */
    0xF6A2, 0x89EB,    /* '觫' -> 35307 */
    0xF6A3, 0x89EF,    /* '觯' -> 35311 */
    0xF6A4, 0x8A3E,    /* '訾' -> 35390 */
    0xF6A5, 0x8B26,    /* '謦' -> 35622 */
    0xF6A6, 0x9753,    /* '靓' -> 38739 */
    0xF6A7, 0x96E9,    /* '雩' -> 38633 */
    0xF6A8, 0x96F3,    /* '雳' -> 38643 */
    0xF6A9, 0x96EF,    /* '雯' -> 38639 */
    0xF6AA, 0x9706,    /* '霆' -> 38662 */
    0xF6AB, 0x9701,    /* '霁' -> 38657 */
    0xF6AC, 0x9708,    /* '霈' -> 38664 */
    0xF6AD, 0x970F,    /* '霏' -> 38671 */
    0xF6AE, 0x970E,    /* '霎' -> 38670 */
    0xF6AF, 0x972A,    /* '霪' -> 38698 */
    0xF6B0, 0x972D,    /* '霭' -> 38701 */
    0xF6B1, 0x9730,    /* '霰' -> 38704 */
    0xF6B2, 0x973E,    /* '霾' -> 38718 */
    0xF6B3, 0x9F80,    /* '龀' -> 40832 */
    0xF6B4, 0x9F83,    /* '龃' -> 40835 */
    0xF6B5, 0x9F85,    /* '龅' -> 40837 */
    0xF6B6, 0x9F86,    /* '龆' -> 40838 */
    0xF6B7, 0x9F87,    /* '龇' -> 40839 */
    0xF6B8, 0x9F88,    /* '龈' -> 40840 */
    0xF6B9, 0x9F89,    /* '龉' -> 40841 */
    0xF6BA, 0x9F8A,    /* '龊' -> 40842 */
    0xF6BB, 0x9F8C,    /* '龌' -> 40844 */
    0xF6BC, 0x9EFE,    /* '黾' -> 40702 */
    0xF6BD, 0x9F0B,    /* '鼋' -> 40715 */
    0xF6BE, 0x9F0D,    /* '鼍' -> 40717 */
    0xF6BF, 0x96B9,    /* '隹' -> 38585 */
    0xF6C0, 0x96BC,    /* '隼' -> 38588 */
    0xF6C1, 0x96BD,    /* '隽' -> 38589 */
    0xF6C2, 0x96CE,    /* '雎' -> 38606 */
    0xF6C3, 0x96D2,    /* '雒' -> 38610 */
    0xF6C4, 0x77BF,    /* '瞿' -> 30655 */
    0xF6C5, 0x96E0,    /* '雠' -> 38624 */
    0xF6C6, 0x928E,    /* '銎' -> 37518 */
    0xF6C7, 0x92AE,    /* '銮' -> 37550 */
    0xF6C8, 0x92C8,    /* '鋈' -> 37576 */
    0xF6C9, 0x933E,    /* '錾' -> 37694 */
    0xF6CA, 0x936A,    /* '鍪' -> 37738 */
    0xF6CB, 0x93CA,    /* '鏊' -> 37834 */
    0xF6CC, 0x938F,    /* '鎏' -> 37775 */
    0xF6CD, 0x943E,    /* '鐾' -> 37950 */
    0xF6CE, 0x946B,    /* '鑫' -> 37995 */
    0xF6CF, 0x9C7F,    /* '鱿' -> 40063 */
    0xF6D0, 0x9C82,    /* '鲂' -> 40066 */
    0xF6D1, 0x9C85,    /* '鲅' -> 40069 */
    0xF6D2, 0x9C86,    /* '鲆' -> 40070 */
    0xF6D3, 0x9C87,    /* '鲇' -> 40071 */
    0xF6D4, 0x9C88,    /* '鲈' -> 40072 */
    0xF6D5, 0x7A23,    /* '稣' -> 31267 */
    0xF6D6, 0x9C8B,    /* '鲋' -> 40075 */
    0xF6D7, 0x9C8E,    /* '鲎' -> 40078 */
    0xF6D8, 0x9C90,    /* '鲐' -> 40080 */
    0xF6D9, 0x9C91,    /* '鲑' -> 40081 */
    0xF6DA, 0x9C92,    /* '鲒' -> 40082 */
    0xF6DB, 0x9C94,    /* '鲔' -> 40084 */
    0xF6DC, 0x9C95,    /* '鲕' -> 40085 */
    0xF6DD, 0x9C9A,    /* '鲚' -> 40090 */
    0xF6DE, 0x9C9B,    /* '鲛' -> 40091 */
    0xF6DF, 0x9C9E,    /* '鲞' -> 40094 */
    0xF6E0, 0x9C9F,    /* '鲟' -> 40095 */
    0xF6E1, 0x9CA0,    /* '鲠' -> 40096 */
    0xF6E2, 0x9CA1,    /* '鲡' -> 40097 */
    0xF6E3, 0x9CA2,    /* '鲢' -> 40098 */
    0xF6E4, 0x9CA3,    /* '鲣' -> 40099 */
    0xF6E5, 0x9CA5,    /* '鲥' -> 40101 */
    0xF6E6, 0x9CA6,    /* '鲦' -> 40102 */
    0xF6E7, 0x9CA7,    /* '鲧' -> 40103 */
    0xF6E8, 0x9CA8,    /* '鲨' -> 40104 */
    0xF6E9, 0x9CA9,    /* '鲩' -> 40105 */
    0xF6EA, 0x9CAB,    /* '鲫' -> 40107 */
    0xF6EB, 0x9CAD,    /* '鲭' -> 40109 */
    0xF6EC, 0x9CAE,    /* '鲮' -> 40110 */
    0xF6ED, 0x9CB0,    /* '鲰' -> 40112 */
    0xF6EE, 0x9CB1,    /* '鲱' -> 40113 */
    0xF6EF, 0x9CB2,    /* '鲲' -> 40114 */
    0xF6F0, 0x9CB3,    /* '鲳' -> 40115 */
    0xF6F1, 0x9CB4,    /* '鲴' -> 40116 */
    0xF6F2, 0x9CB5,    /* '鲵' -> 40117 */
    0xF6F3, 0x9CB6,    /* '鲶' -> 40118 */
    0xF6F4, 0x9CB7,    /* '鲷' -> 40119 */
    0xF6F5, 0x9CBA,    /* '鲺' -> 40122 */
    0xF6F6, 0x9CBB,    /* '鲻' -> 40123 */
    0xF6F7, 0x9CBC,    /* '鲼' -> 40124 */
    0xF6F8, 0x9CBD,    /* '鲽' -> 40125 */
    0xF6F9, 0x9CC4,    /* '鳄' -> 40132 */
    0xF6FA, 0x9CC5,    /* '鳅' -> 40133 */
    0xF6FB, 0x9CC6,    /* '鳆' -> 40134 */
    0xF6FC, 0x9CC7,    /* '鳇' -> 40135 */
    0xF6FD, 0x9CCA,    /* '鳊' -> 40138 */
    0xF6FE, 0x9CCB,    /* '鳋' -> 40139 */
    0xF7A1, 0x9CCC,    /* '鳌' -> 40140 */
    0xF7A2, 0x9CCD,    /* '鳍' -> 40141 */
    0xF7A3, 0x9CCE,    /* '鳎' -> 40142 */
    0xF7A4, 0x9CCF,    /* '鳏' -> 40143 */
    0xF7A5, 0x9CD0,    /* '鳐' -> 40144 */
    0xF7A6, 0x9CD3,    /* '鳓' -> 40147 */
    0xF7A7, 0x9CD4,    /* '鳔' -> 40148 */
    0xF7A8, 0x9CD5,    /* '鳕' -> 40149 */
    0xF7A9, 0x9CD7,    /* '鳗' -> 40151 */
    0xF7AA, 0x9CD8,    /* '鳘' -> 40152 */
    0xF7AB, 0x9CD9,    /* '鳙' -> 40153 */
    0xF7AC, 0x9CDC,    /* '鳜' -> 40156 */
    0xF7AD, 0x9CDD,    /* '鳝' -> 40157 */
    0xF7AE, 0x9CDF,    /* '鳟' -> 40159 */
    0xF7AF, 0x9CE2,    /* '鳢' -> 40162 */
    0xF7B0, 0x977C,    /* '靼' -> 38780 */
    0xF7B1, 0x9785,    /* '鞅' -> 38789 */
    0xF7B2, 0x9791,    /* '鞑' -> 38801 */
    0xF7B3, 0x9792,    /* '鞒' -> 38802 */
    0xF7B4, 0x9794,    /* '鞔' -> 38804 */
    0xF7B5, 0x97AF,    /* '鞯' -> 38831 */
    0xF7B6, 0x97AB,    /* '鞫' -> 38827 */
    0xF7B7, 0x97A3,    /* '鞣' -> 38819 */
    0xF7B8, 0x97B2,    /* '鞲' -> 38834 */
    0xF7B9, 0x97B4,    /* '鞴' -> 38836 */
    0xF7BA, 0x9AB1,    /* '骱' -> 39601 */
    0xF7BB, 0x9AB0,    /* '骰' -> 39600 */
    0xF7BC, 0x9AB7,    /* '骷' -> 39607 */
    0xF7BD, 0x9E58,    /* '鹘' -> 40536 */
    0xF7BE, 0x9AB6,    /* '骶' -> 39606 */
    0xF7BF, 0x9ABA,    /* '骺' -> 39610 */
    0xF7C0, 0x9ABC,    /* '骼' -> 39612 */
    0xF7C1, 0x9AC1,    /* '髁' -> 39617 */
    0xF7C2, 0x9AC0,    /* '髀' -> 39616 */
    0xF7C3, 0x9AC5,    /* '髅' -> 39621 */
    0xF7C4, 0x9AC2,    /* '髂' -> 39618 */
    0xF7C5, 0x9ACB,    /* '髋' -> 39627 */
    0xF7C6, 0x9ACC,    /* '髌' -> 39628 */
    0xF7C7, 0x9AD1,    /* '髑' -> 39633 */
    0xF7C8, 0x9B45,    /* '魅' -> 39749 */
    0xF7C9, 0x9B43,    /* '魃' -> 39747 */
    0xF7CA, 0x9B47,    /* '魇' -> 39751 */
    0xF7CB, 0x9B49,    /* '魉' -> 39753 */
    0xF7CC, 0x9B48,    /* '魈' -> 39752 */
    0xF7CD, 0x9B4D,    /* '魍' -> 39757 */
    0xF7CE, 0x9B51,    /* '魑' -> 39761 */
    0xF7CF, 0x98E8,    /* '飨' -> 39144 */
    0xF7D0, 0x990D,    /* '餍' -> 39181 */
    0xF7D1, 0x992E,    /* '餮' -> 39214 */
    0xF7D2, 0x9955,    /* '饕' -> 39253 */
    0xF7D3, 0x9954,    /* '饔' -> 39252 */
    0xF7D4, 0x9ADF,    /* '髟' -> 39647 */
    0xF7D5, 0x9AE1,    /* '髡' -> 39649 */
    0xF7D6, 0x9AE6,    /* '髦' -> 39654 */
    0xF7D7, 0x9AEF,    /* '髯' -> 39663 */
    0xF7D8, 0x9AEB,    /* '髫' -> 39659 */
    0xF7D9, 0x9AFB,    /* '髻' -> 39675 */
    0xF7DA, 0x9AED,    /* '髭' -> 39661 */
    0xF7DB, 0x9AF9,    /* '髹' -> 39673 */
    0xF7DC, 0x9B08,    /* '鬈' -> 39688 */
    0xF7DD, 0x9B0F,    /* '鬏' -> 39695 */
    0xF7DE, 0x9B13,    /* '鬓' -> 39699 */
    0xF7DF, 0x9B1F,    /* '鬟' -> 39711 */
    0xF7E0, 0x9B23,    /* '鬣' -> 39715 */
    0xF7E1, 0x9EBD,    /* '麽' -> 40637 */
    0xF7E2, 0x9EBE,    /* '麾' -> 40638 */
    0xF7E3, 0x7E3B,    /* '縻' -> 32315 */
    0xF7E4, 0x9E82,    /* '麂' -> 40578 */
    0xF7E5, 0x9E87,    /* '麇' -> 40583 */
    0xF7E6, 0x9E88,    /* '麈' -> 40584 */
    0xF7E7, 0x9E8B,    /* '麋' -> 40587 */
    0xF7E8, 0x9E92,    /* '麒' -> 40594 */
    0xF7E9, 0x93D6,    /* '鏖' -> 37846 */
    0xF7EA, 0x9E9D,    /* '麝' -> 40605 */
    0xF7EB, 0x9E9F,    /* '麟' -> 40607 */
    0xF7EC, 0x9EDB,    /* '黛' -> 40667 */
    0xF7ED, 0x9EDC,    /* '黜' -> 40668 */
    0xF7EE, 0x9EDD,    /* '黝' -> 40669 */
    0xF7EF, 0x9EE0,    /* '黠' -> 40672 */
    0xF7F0, 0x9EDF,    /* '黟' -> 40671 */
    0xF7F1, 0x9EE2,    /* '黢' -> 40674 */
    0xF7F2, 0x9EE9,    /* '黩' -> 40681 */
    0xF7F3, 0x9EE7,    /* '黧' -> 40679 */
    0xF7F4, 0x9EE5,    /* '黥' -> 40677 */
    0xF7F5, 0x9EEA,    /* '黪' -> 40682 */
    0xF7F6, 0x9EEF,    /* '黯' -> 40687 */
    0xF7F7, 0x9F22,    /* '鼢' -> 40738 */
    0xF7F8, 0x9F2C,    /* '鼬' -> 40748 */
    0xF7F9, 0x9F2F,    /* '鼯' -> 40751 */
    0xF7FA, 0x9F39,    /* '鼹' -> 40761 */
    0xF7FB, 0x9F37,    /* '鼷' -> 40759 */
    0xF7FC, 0x9F3D,    /* '鼽' -> 40765 */
    0xF7FD, 0x9F3E,    /* '鼾' -> 40766 */
    0xF7FE, 0x9F44     /* '齄' -> 40772 */
};

#endif // _MPYTHON_UNICODE_H
