#ifndef PICO_SUPPORT_H
#define PICO_SUPPORT_H

/* Constants required to manipulate the SIE. */
#define portSIE_BASE                         0xd0000000

#define SIE_OFFSET(a)              ( * ( ( volatile uint32_t * ) ( portSIE_BASE + a ) ) )

#define portSIE_CPUID              SIE_OFFSET( 0x00 )
#define portSIE_GPIO_IN            SIE_OFFSET( 0x04 )
#define portSIE_GPIO_HI_IN         SIE_OFFSET( 0x08 )
#define portSIE_GPIO_OUT           SIE_OFFSET( 0x10 )
#define portSIE_GPIO_OUT_SET       SIE_OFFSET( 0x14 )
#define portSIE_GPIO_OUT_CLR       SIE_OFFSET( 0x18 )
#define portSIE_GPIO_OUT_XOR       SIE_OFFSET( 0x1C )
#define portSIE_GPIO_OE            SIE_OFFSET( 0x20 )
#define portSIE_GPIO_OE_SET        SIE_OFFSET( 0x24 )
#define portSIE_GPIO_OE_CLR        SIE_OFFSET( 0x28 )
#define portSIE_GPIO_OE_XOR        SIE_OFFSET( 0x2C )
#define portSIE_GPIO_HI_OUT        SIE_OFFSET( 0x30 )
#define portSIE_GPIO_HI_OUT_SET    SIE_OFFSET( 0x34 )
#define portSIE_GPIO_HI_OUT_CLR    SIE_OFFSET( 0x38 )
#define portSIE_GPIO_HI_OUT_XOR    SIE_OFFSET( 0x3C )
#define portSIE_GPIO_HI_OE         SIE_OFFSET( 0x40 )
#define portSIE_GPIO_HI_OE_SET     SIE_OFFSET( 0x44 )
#define portSIE_GPIO_HI_OE_CLR     SIE_OFFSET( 0x48 )
#define portSIE_GPIO_HI_OE_XOR     SIE_OFFSET( 0x4C )
#define portSIE_FIFO_ST            SIE_OFFSET( 0x50 )
#define portSIE_FIFO_WR            SIE_OFFSET( 0x54 )
#define portSIE_FIFO_RD            SIE_OFFSET( 0x58 )
#define portSIE_SPINLOCK_ST        SIE_OFFSET( 0x5C )
#define portSIE_DIV_UDIVIDEND      SIE_OFFSET( 0x60 )
#define portSIE_DIV_UDIVISOR       SIE_OFFSET( 0x64 )
#define portSIE_DIV_SDIVIDEND      SIE_OFFSET( 0x68 )
#define portSIE_DIV_SDIVISOR       SIE_OFFSET( 0x6C )
#define portSIE_DIV_QUOTIENT       SIE_OFFSET( 0x70 )
#define portSIE_DIV_REMAINDER      SIE_OFFSET( 0x74 )
#define portSIE_DIV_CSR            SIE_OFFSET( 0x78 )
#define portSIE_INTERP0_ACCUM0     SIE_OFFSET( 0x80 )
#define portSIE_INTERP0_ACCUM1     SIE_OFFSET( 0x84 )
#define portSIE_INTERP0_BASE0      SIE_OFFSET( 0x88 )
#define portSIE_INTERP0_BASE1      SIE_OFFSET( 0x8C )
#define portSIE_INTERP0_BASE2      SIE_OFFSET( 0x90 )
#define portSIE_INTERP0_POP_LANE0  SIE_OFFSET( 0x94 )
#define portSIE_INTERP0_POP_LANE1  SIE_OFFSET( 0x98 )
#define portSIE_INTERP0_POP_FULL   SIE_OFFSET( 0x9C )
#define portSIE_INTERP0_PEEK_LANE0 SIE_OFFSET( 0xA0 )
#define portSIE_INTERP0_PEEK_LANE1 SIE_OFFSET( 0xA4 )
#define portSIE_INTERP0_PEEK_FULL  SIE_OFFSET( 0xA8 )
#define portSIE_INTERP0_CTRL_LANE0 SIE_OFFSET( 0xAC )
#define portSIE_INTERP0_CTRL_LANE1 SIE_OFFSET( 0xB0 )
#define portSIE_INTERP0_ACCUM0_ADD SIE_OFFSET( 0xB4 )
#define portSIE_INTERP0_ACCUM1_ADD SIE_OFFSET( 0xB8 )
#define portSIE_INTERP0_BASE_1AND0 SIE_OFFSET( 0xBC )
#define portSIE_INTERP1_ACCUM0     SIE_OFFSET( 0xC0 )
#define portSIE_INTERP1_ACCUM1     SIE_OFFSET( 0xC4 )
#define portSIE_INTERP1_BASE0      SIE_OFFSET( 0xC8 )
#define portSIE_INTERP1_BASE1      SIE_OFFSET( 0xCC )
#define portSIE_INTERP1_BASE2      SIE_OFFSET( 0xD0 )
#define portSIE_INTERP1_POP_LANE0  SIE_OFFSET( 0xD4 )
#define portSIE_INTERP1_POP_LANE1  SIE_OFFSET( 0xD8 )
#define portSIE_INTERP1_POP_FULL   SIE_OFFSET( 0xDC )
#define portSIE_INTERP1_PEEK_LANE0 SIE_OFFSET( 0xE0 )
#define portSIE_INTERP1_PEEK_LANE1 SIE_OFFSET( 0xE4 )
#define portSIE_INTERP1_PEEK_FULL  SIE_OFFSET( 0xE8 )
#define portSIE_INTERP1_CTRL_LANE0 SIE_OFFSET( 0xEC )
#define portSIE_INTERP1_CTRL_LANE1 SIE_OFFSET( 0xF0 )
#define portSIE_INTERP1_ACCUM0_ADD SIE_OFFSET( 0xF4 )
#define portSIE_INTERP1_ACCUM1_ADD SIE_OFFSET( 0xF8 )
#define portSIE_INTERP1_BASE_1AND0 SIE_OFFSET( 0xFC )
#define portSIE_SPINLOCK0          SIE_OFFSET( 0x100 )
#define portSIE_SPINLOCK1          SIE_OFFSET( 0x104 )
#define portSIE_SPINLOCK2          SIE_OFFSET( 0x108 )
#define portSIE_SPINLOCK3          SIE_OFFSET( 0x10C )
#define portSIE_SPINLOCK4          SIE_OFFSET( 0x110 )
#define portSIE_SPINLOCK5          SIE_OFFSET( 0x114 )
#define portSIE_SPINLOCK6          SIE_OFFSET( 0x118 )
#define portSIE_SPINLOCK7          SIE_OFFSET( 0x11C )
#define portSIE_SPINLOCK8          SIE_OFFSET( 0x120 )
#define portSIE_SPINLOCK9          SIE_OFFSET( 0x124 )
#define portSIE_SPINLOCK10         SIE_OFFSET( 0x128 )
#define portSIE_SPINLOCK11         SIE_OFFSET( 0x12C )
#define portSIE_SPINLOCK12         SIE_OFFSET( 0x130 )
#define portSIE_SPINLOCK13         SIE_OFFSET( 0x134 )
#define portSIE_SPINLOCK14         SIE_OFFSET( 0x138 )
#define portSIE_SPINLOCK15         SIE_OFFSET( 0x13C )
#define portSIE_SPINLOCK16         SIE_OFFSET( 0x140 )
#define portSIE_SPINLOCK17         SIE_OFFSET( 0x144 )
#define portSIE_SPINLOCK18         SIE_OFFSET( 0x148 )
#define portSIE_SPINLOCK19         SIE_OFFSET( 0x14C )
#define portSIE_SPINLOCK20         SIE_OFFSET( 0x150 )
#define portSIE_SPINLOCK21         SIE_OFFSET( 0x154 )
#define portSIE_SPINLOCK22         SIE_OFFSET( 0x158 )
#define portSIE_SPINLOCK23         SIE_OFFSET( 0x15C )
#define portSIE_SPINLOCK24         SIE_OFFSET( 0x160 )
#define portSIE_SPINLOCK25         SIE_OFFSET( 0x164 )
#define portSIE_SPINLOCK26         SIE_OFFSET( 0x168 )
#define portSIE_SPINLOCK27         SIE_OFFSET( 0x16C )
#define portSIE_SPINLOCK28         SIE_OFFSET( 0x170 )
#define portSIE_SPINLOCK29         SIE_OFFSET( 0x174 )
#define portSIE_SPINLOCK30         SIE_OFFSET( 0x178 )
#define portSIE_SPINLOCK31         SIE_OFFSET( 0x17C )

#endif
