
/****************************************************************************************************//**
 * @file     s1ja.h
 *
 * @brief    CMSIS Cortex-M4 Peripheral Access Layer Header File for
 *           R7FS3A7x from Renesas.
 *
 * @version  V1.2
 * @date     5. December 2014
 *
 * @note     Generated with SVDConv V2.85b
 *           from CMSIS SVD File 'R7FS1JAx.svd' Version 1.2, Hand edited 9/11/2017
 *******************************************************************************************************/



/** @addtogroup Renesas
  * @{
  */

/** @addtogroup R7FS1JAx
  * @{
  */

#ifndef R7FS1JAX_H
#define R7FS1JAX_H

#ifdef __cplusplus
extern "C" {
#endif

/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum {
/* -------------------  Cortex-M0 Processor Exceptions Numbers  ------------------- */
  Reset_IRQn                    = -15,              /*!<   1  Reset Vector, invoked on Power up and warm reset                 */
  NonMaskableInt_IRQn           = -14,              /*!<   2  Non maskable Interrupt, cannot be stopped or preempted           */
  HardFault_IRQn                = -13,              /*!<   3  Hard Fault, all classes of Fault                                 */
  MemoryManagement_IRQn         = -12,              /*!<   4  Memory Management, MPU mismatch, including Access Violation
                                                         and No Match                                                          */
  BusFault_IRQn                 = -11,              /*!<   5  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                         related Fault                                                         */
  UsageFault_IRQn               = -10,              /*!<   6  Usage Fault, i.e. Undef Instruction, Illegal State Transition    */
  SVCall_IRQn                   =  -5,              /*!<  11  System Service Call via SVC instruction                          */
  DebugMonitor_IRQn             =  -4,              /*!<  12  Debug Monitor                                                    */
  PendSV_IRQn                   =  -2,              /*!<  14  Pendable request for system service                              */
  SysTick_IRQn                  =  -1,              /*!<  15  System Tick Timer                                                */
} IRQn_Type;

/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

/* ----------------Configuration of the Cortex-M0 Processor and Core Peripherals---------------- */
#define __CM0_REV                 0x0001            /*!< Cortex-M0 Core Revision                                               */
#define __MPU_PRESENT                  1            /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS               2            /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig         0            /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT                  0            /*!< FPU present or not                                                    */
#define __VTOR_PRESENT                 1            /*!< Vector table VTOR register available or not                           */
/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_armv8mbl.h"                          /*!< Cortex-M23 (ARMv8MBL) processor and core peripherals                  */
#include "system_S1JA.h"                            /*!< S1JA System                                                           */


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */


/** @addtogroup Device_Peripheral_Registers
  * @{
  */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif

/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


typedef struct {
  union {
    __IO uint32_t  MMPUACAn;                        /*!< Group A Region %s Access Control Register                             */

    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< Region enable                                                         */
      __IO uint32_t  RP         :  1;               /*!< Read protection                                                       */
      __IO uint32_t  WP         :  1;               /*!< Write protection                                                      */
    } MMPUACAn_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MMPUSAn;                         /*!< Group A Region %s Start Address Register                              */

    struct {
      __IO uint32_t  MMPUSA     : 32;               /*!< Address where the region starts, for use in region determination.
                                                         NOTE: The low-order 2 bits are fixed to 0.                            */
    } MMPUSAn_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MMPUEAn;                         /*!< Group A Region %s End Address Register                                */

    struct {
      __IO uint32_t  MMPUEA     : 32;               /*!< Region end address register Address where the region end, for
                                                         use in region determination. NOTE: The low-order 2 bits are
                                                          fixed to 1.                                                          */
    } MMPUEAn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED;
} R_MMPU_MMPUACAnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  MMPUACBn;                        /*!< Group B Region %s Access Control Register                             */

    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< Region enable                                                         */
      __IO uint32_t  RP         :  1;               /*!< Read protection                                                       */
      __IO uint32_t  WP         :  1;               /*!< Write protection                                                      */
    } MMPUACBn_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MMPUSBn;                         /*!< Group B Region %s Start Address Register                              */

    struct {
      __IO uint32_t  MMPUSB     : 32;               /*!< Address where the region starts, for use in region determination.
                                                         NOTE: The low-order 2 bits are fixed to 0.                            */
    } MMPUSBn_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MMPUEBn;                         /*!< Group B Region %s End Address Register                                */

    struct {
      __IO uint32_t  MMPUEB     : 32;               /*!< Region end address register Address where the region end, for
                                                         use in region determination. NOTE: The low-order 2 bits are
                                                          fixed to 1.                                                          */
    } MMPUEBn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED1;
} R_MMPU_MMPUACBnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  MMPUACCn;                        /*!< Group C Region %s Access Control Register                             */

    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< Region enable                                                         */
      __IO uint32_t  RP         :  1;               /*!< Read protection                                                       */
      __IO uint32_t  WP         :  1;               /*!< Write protection                                                      */
    } MMPUACCn_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MMPUSCn;                         /*!< Group C Region %s Start Address Register                              */

    struct {
      __IO uint32_t  MMPUSC     : 32;               /*!< Address where the region starts, for use in region determination.
                                                         NOTE: The low-order 2 bits are fixed to 0.                            */
    } MMPUSCn_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MMPUECn;                         /*!< Group C Region %s Start Address Register                              */

    struct {
      __IO uint32_t  MMPUEC     : 32;               /*!< Region end address register Address where the region end, for
                                                         use in region determination. NOTE: The low-order 2 bits are
                                                          fixed to 1.                                                          */
    } MMPUECn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED2;
} R_MMPU_MMPUACCnRC0_Type;

typedef struct {
  union {
    __IO uint16_t  SMPUSRAMn;                       /*!< Access Control Register for SRAM%s                                    */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUSRAMn_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED3;
} R_SMPU_SMPUSRAMnRC0_Type;

typedef struct {
  __I  uint16_t  RESERVED4;

  union {
    __IO uint16_t  CSnMOD;                          /*!< CS%s Mode Register                                                    */

    struct {
      __IO uint16_t  WRMOD      :  1;               /*!< Write Access Mode Select                                              */
           uint16_t             :  2;
      __IO uint16_t  EWENB      :  1;               /*!< External Wait Enable                                                  */
           uint16_t             :  4;
      __IO uint16_t  PRENB      :  1;               /*!< Page Read Access Enable                                               */
      __IO uint16_t  PWENB      :  1;               /*!< Page Write Access Enable                                              */
           uint16_t             :  5;
      __IO uint16_t  PRDMOD     :  1;               /*!< Page Read Access Mode Select                                          */
    } CSnMOD_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  CSnWCR1;                         /*!< CS%s Wait Control Register 1                                          */

    struct {
      __IO uint32_t  CSPWWAIT   :  3;               /*!< Page Write Cycle Wait Select NOTE: The CSPWWAIT value is valid
                                                         only when the PWENB bit in CSnMOD is set to 1.                        */
           uint32_t             :  5;
      __IO uint32_t  CSPRWAIT   :  3;               /*!< Page Read Cycle Wait Select NOTE: The CSPRWAIT value is valid
                                                         only when the PRENB bit in CSnMOD is set to 1.                        */
           uint32_t             :  5;
      __IO uint32_t  CSWWAIT    :  5;               /*!< Normal Write Cycle Wait Select                                        */
           uint32_t             :  3;
      __IO uint32_t  CSRWAIT    :  5;               /*!< Normal Read Cycle Wait Select                                         */
    } CSnWCR1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  CSnWCR2;                         /*!< CS%s Wait Control Register 2                                          */

    struct {
           uint32_t             :  2;
      __IO uint32_t  CSROFF     :  1;               /*!< Read-Access CS Extension Cycle Select                                 */
           uint32_t             :  3;
      __IO uint32_t  CSWOFF     :  1;               /*!< Write-Access CS Extension Cycle Select                                */
           uint32_t             :  3;
      __IO uint32_t  WDOFF      :  1;               /*!< Write Data Output Extension Cycle Select                              */
           uint32_t             :  2;
      __IO uint32_t  AWAIT      :  1;               /*!< Address Cycle Wait Select                                             */
           uint32_t             :  4;
      __IO uint32_t  RDON       :  1;               /*!< RD Assert Wait Select                                                 */
           uint32_t             :  3;
      __IO uint32_t  WRON       :  1;               /*!< WR Assert Wait Select                                                 */
           uint32_t             :  3;
      __IO uint32_t  WDON       :  1;               /*!< Write Data Output Wait Select                                         */
           uint32_t             :  1;
      __IO uint32_t  CSON       :  3;               /*!< CS Assert Wait Select                                                 */
    } CSnWCR2_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED5;
} CSRC0_Type;

typedef struct {
  __I  uint16_t  RESERVED6;

  union {
    __IO uint16_t  CSnCR;                           /*!< CS%s Control Register                                                 */

    struct {
      __IO uint16_t  EXENB      :  1;               /*!< Operation Enable                                                      */
           uint16_t             :  3;
      __IO uint16_t  BSIZE      :  2;               /*!< External Bus Width Select                                             */
           uint16_t             :  2;
      __IO uint16_t  EMODE      :  1;               /*!< Endian Mode                                                           */
    } CSnCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED7[3];

  union {
    __IO uint16_t  CSnREC;                          /*!< CS%s Recovery Cycle Register                                          */

    struct {
      __IO uint16_t  RRCV       :  4;               /*!< Read Recovery                                                         */
           uint16_t             :  4;
      __IO uint16_t  WRCV       :  4;               /*!< Write Recovery                                                        */
    } CSnREC_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED8;
} CSRC1_Type;

typedef struct {
  union {
    __I  uint32_t  BUSnERRADD;                      /*!< Bus Error Address Register %s                                         */

    struct {
      __I  uint32_t  BERAD      : 32;               /*!< Bus Error Address When a bus error occurs, It stores an error
                                                         address..                                                             */
    } BUSnERRADD_b;                                 /*!< BitSize                                                               */
  };

  union {
    __I  uint8_t   BUSnERRSTAT;                     /*!< Bus Error Status Register %s                                          */

    struct {
      __I  uint8_t   ACCSTS     :  1;               /*!< Error access status The status at the time of the error               */
           uint8_t              :  6;
      __I  uint8_t   ERRSTAT    :  1;               /*!< Bus Error Status When bus error assert, error flag occurs.            */
    } BUSnERRSTAT_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9[11];
} BUSnERRRC0_Type;

typedef struct {
  union {
    __IO uint16_t  DELSRn;                          /*!< DMAC Event Link Setting Register %s                                   */

    struct {
      __IO uint16_t  DELS       :  9;               /*!< Event selection to DMAC Start request                                 */
    } DELSRn_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED10;
} R_ICU_DELSRn_Type;

typedef struct {
  union {
    __IO uint8_t   LVDnCR1;                         /*!< Voltage Monitoring %s Circuit Control Register 1                      */

    struct {
      __IO uint8_t   IDTSEL     :  2;               /*!< Voltage Monitoring Interrupt Generation Condition Select              */
      __IO uint8_t   IRQSEL     :  1;               /*!< Voltage Monitoring Interrupt Type Select                              */
    } LVDnCR1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   LVDnSR;                          /*!< Voltage Monitoring %s Circuit Status Register                         */

    struct {
      __IO uint8_t   DET        :  1;               /*!< Voltage Monitoring Voltage Change Detection Flag NOTE: Only
                                                         0 can be written to this bit. After writing 0 to this bit, it
                                                          takes 2 system clock cycles for the bit to be read as 0.             */
      __I  uint8_t   MON        :  1;               /*!< Voltage Monitoring 1 Signal Monitor Flag                              */
    } LVDnSR_b;                                     /*!< BitSize                                                               */
  };
} R_SYSTEM_LVDnRC0_Type;

typedef struct {
  union {
    __IO uint8_t   ELSEGRn;                         /*!< Event Link Software Event Generation Register %s                      */

    struct {
      __O  uint8_t   SEG        :  1;               /*!< Software Event Generation                                             */
           uint8_t              :  5;
      __IO uint8_t   WE         :  1;               /*!< SEG Bit Write Enable                                                  */
      __O  uint8_t   WI         :  1;               /*!< ELSEGR Register Write Disable                                         */
    } ELSEGRn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED11;
} R_ELC_ELSEGRnRC0_Type;

typedef struct {
  union {
    __IO uint16_t  ELSRn;                           /*!< Event Link Setting Register %s                                        */

    struct {
      __IO uint16_t  ELS        :  9;               /*!< Event Link Select                                                     */
    } ELSRn_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED12;
} R_ELC_ELSRnRC0_Type;

typedef struct {
  union {
    __IO uint8_t   RTCCRn;                          /*!< Time Capture Control Register %s                                      */

    struct {
      __IO uint8_t   TCCT       :  2;               /*!< Time Capture Control                                                  */
      __I  uint8_t   TCST       :  1;               /*!< Time Capture Status                                                   */
           uint8_t              :  1;
      __IO uint8_t   TCNF       :  2;               /*!< Time Capture Noise Filter Control                                     */
           uint8_t              :  1;
      __IO uint8_t   TCEN       :  1;               /*!< Time Capture Event Input Pin Enable                                   */
    } RTCCRn_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED13;
} R_RTC_RTCCRnRC0_Type;

typedef struct {
  union {
    union {
      __I  uint8_t   BCNT0CPn;                      /*!< BCNT0 Capture Register %s                                             */

      struct {
        __I  uint8_t   BCNT0CP  :  8;               /*!< BCNT0CP is a read-only register that captures the BCNT0 value
                                                         when a time capture event is detected.                                */
      } BCNT0CPn_b;                                 /*!< BitSize                                                               */
    };

    union {
      __I  uint8_t   RSECCPn;                       /*!< Second Capture Register %s                                            */

      struct {
        __I  uint8_t   SEC1     :  4;               /*!< 1-Second Capture Capture value for the ones place of seconds          */
        __I  uint8_t   SEC10    :  3;               /*!< 10-Second Capture Capture value for the tens place of seconds         */
      } RSECCPn_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED14;

  union {
    union {
      __I  uint8_t   BCNT1CPn;                      /*!< BCNT1 Capture Register %s                                             */

      struct {
        __I  uint8_t   BCNT1CP  :  8;               /*!< BCNT1CP is a read-only register that captures the BCNT1 value
                                                         when a time capture event is detected.                                */
      } BCNT1CPn_b;                                 /*!< BitSize                                                               */
    };

    union {
      __I  uint8_t   RMINCPn;                       /*!< Minute Capture Register %s                                            */

      struct {
        __I  uint8_t   MIN1     :  4;               /*!< 1-Minute Capture Capture value for the ones place of minutes          */
        __I  uint8_t   MIN10    :  3;               /*!< 10-Minute Capture Capture value for the tens place of minutes         */
      } RMINCPn_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED15;

  union {
    union {
      __I  uint8_t   BCNT2CPn;                      /*!< BCNT2 Capture Register %s                                             */

      struct {
        __I  uint8_t   BCNT2CP  :  8;               /*!< BCNT2CP is a read-only register that captures the BCNT2 value
                                                         when a time capture event is detected.                                */
      } BCNT2CPn_b;                                 /*!< BitSize                                                               */
    };

    union {
      __I  uint8_t   RHRCPn;                        /*!< Hour Capture Register %s                                              */

      struct {
        __I  uint8_t   HR1      :  4;               /*!< 1-Minute Capture Capture value for the ones place of minutes          */
        __I  uint8_t   HR10     :  2;               /*!< 10-Minute Capture Capture value for the tens place of minutes         */
        __I  uint8_t   PM       :  1;               /*!< PM                                                                    */
      } RHRCPn_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED16[3];

  union {
    union {
      __I  uint8_t   BCNT3CPn;                      /*!< BCNT3 Capture Register %s                                             */

      struct {
        __I  uint8_t   BCNT3CP  :  8;               /*!< BCNT3CP is a read-only register that captures the BCNT3 value
                                                         when a time capture event is detected.                                */
      } BCNT3CPn_b;                                 /*!< BitSize                                                               */
    };

    union {
      __I  uint8_t   RDATECPn;                      /*!< Date Capture Register %s                                              */

      struct {
        __I  uint8_t   DATE1    :  4;               /*!< 1-Day Capture Capture value for the ones place of minutes             */
        __I  uint8_t   DATE10   :  2;               /*!< 10-Day Capture Capture value for the tens place of minutes            */
      } RDATECPn_b;                                 /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED17;

  union {
    __I  uint8_t   RMONCPn;                         /*!< Month Capture Register %s                                             */

    struct {
      __I  uint8_t   MON1       :  4;               /*!< 1-Month Capture Capture value for the ones place of months            */
      __I  uint8_t   MON10      :  1;               /*!< 10-Month Capture Capture value for the tens place of months           */
    } RMONCPn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED18[5];
} R_RTC_CnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  MBn_ID;                          /*!< Mailbox Register ID                                                   */

    struct {
      __IO uint32_t  EID        : 18;               /*!< Extended ID                                                           */
      __IO uint32_t  SID        : 11;               /*!< Standard ID                                                           */
           uint32_t             :  1;
      __IO uint32_t  RTR        :  1;               /*!< Remote Transmission Request                                           */
      __IO uint32_t  IDE        :  1;               /*!< ID Extension                                                          */
    } MBn_ID_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED19;

  union {
    __IO uint8_t   MBn_DL;                          /*!< Mailbox Register DL                                                   */

    struct {
      __IO uint8_t   DLC        :  4;               /*!< Data Length Code                                                      */
    } MBn_DL_b;                                     /*!< BitSize                                                               */
  };
  __IO uint8_t   MBn_D[8];                          /*!< Mailbox Register Data %s                                              */

  union {
    __IO uint16_t  MBn_TS;                          /*!< Mailbox Register TS                                                   */

    struct {
      __IO uint16_t  TSL        :  8;               /*!< Time Stamp Higher Byte Bits TSL[7:0] store the counter value
                                                         of the time stamp when received messages are stored in the mailbox.   */
      __IO uint16_t  TSH        :  8;               /*!< Time Stamp Lower Byte Bits TSH[7:0] store the counter value
                                                         of the time stamp when received messages are stored in the mailbox.   */
    } MBn_TS_b;                                     /*!< BitSize                                                               */
  };
} R_CAN0_MBn_Type;

typedef struct {
  union {
    __IO uint8_t   SARLn;                           /*!< Slave Address Register L%s                                            */

    struct {
      __IO uint8_t   SVA        :  8;               /*!< A slave address is set.7-Bit Address = SVA[7:1] 10-Bit Address
                                                         = { SVA9,SVA8,SVA[7:0] }                                              */
    } SARLn_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SARUn;                           /*!< Slave Address Register U%s                                            */

    struct {
      __IO uint8_t   FS         :  1;               /*!< 7-Bit/10-Bit Address Format Selection                                 */
      __IO uint8_t   SVA8       :  1;               /*!< 10-Bit Address(bit8)                                                  */
      __IO uint8_t   SVA9       :  1;               /*!< 10-Bit Address(bit9)                                                  */
    } SARUn_b;                                      /*!< BitSize                                                               */
  };
} R_IIC0_SARLnRC0_Type;

typedef struct {
  union {
    union {
      __IO uint32_t  GTDLYRn;                       /*!< GTIOC%s Rising Output Delay Register                                  */

      struct {
        __IO uint32_t  DLYA     :  5;               /*!< GTIOCnA Output Rising Edge Delay Setting                              */
             uint32_t           : 11;
        __IO uint32_t  DLYB     :  5;               /*!< GTIOCnB Output Rising Edge Delay Setting                              */
      } GTDLYRn_b;                                  /*!< BitSize                                                               */
    };

    struct {
      union {
        __IO uint16_t  GTDLYRnA;                    /*!< GTIOC%sA Rising Output Delay Register                                 */

        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnA Output Rising Edge Delay Setting                              */
        } GTDLYRnA_b;                               /*!< BitSize                                                               */
      };

      union {
        __IO uint16_t  GTDLYRnB;                    /*!< GTIOC%sB Rising Output Delay Register                                 */

        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnB Output Rising Edge Delay Setting                              */
        } GTDLYRnB_b;                               /*!< BitSize                                                               */
      };
    };
  };
} R_GPT_ODC_GTDLYRnRC0_Type;

typedef struct {
  union {
    union {
      __IO uint32_t  GTDLYFn;                       /*!< GTIOC%s Falling Output Delay Register                                 */

      struct {
        __IO uint32_t  DLYA     :  5;               /*!< GTIOCnA Output Falling Edge Delay Setting                             */
             uint32_t           : 11;
        __IO uint32_t  DLYB     :  5;               /*!< GTIOCnB Output Falling Edge Delay Setting                             */
      } GTDLYFn_b;                                  /*!< BitSize                                                               */
    };

    struct {
      union {
        __IO uint16_t  GTDLYFnA;                    /*!< GTIOC%sA Falling Output Delay Register                                */

        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnA Output Falling Edge Delay Setting                             */
        } GTDLYFnA_b;                               /*!< BitSize                                                               */
      };

      union {
        __IO uint16_t  GTDLYFnB;                    /*!< GTIOC%sB Falling Output Delay Register                                */

        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnB Output Falling Edge Delay Setting                             */
        } GTDLYFnB_b;                               /*!< BitSize                                                               */
      };
    };
  };
} R_GPT_ODC_GTDLYFnRC0_Type;

/* =========================================================================================================================== */
/* ================            R_ACMPHS0 - High-Speed Analog Comparator 0 (R_ACMPHS0)                         ================ */
/* Note: 9/12/17 - The following structure for R_ACMPHS0 was hand edited using the output from the R7FS1JA7.svd output file    */
/* =========================================================================================================================== */
/**
  * @brief High-Speed Analog Comparator 0 (ACMPHS0)
  */

typedef struct {
    union {
      __IOM uint8_t CMPCTL;                       /*!< (@ 0x00000000) Comparator Control Register                                */

      struct {
        __IOM uint8_t CINV        : 1;            /*!< [0..0] Comparator output polarity selection                               */
        __IOM uint8_t COE         : 1;            /*!< [1..1] Comparator output enable                                           */
        __IM  uint8_t             : 1;
        __IOM uint8_t CEG         : 2;            /*!< [4..3] Selection of valid edge (Edge selector)                            */
        __IOM uint8_t CDFS        : 2;            /*!< [6..5] Noise filter selection                                             */
        __IOM uint8_t HCMPON      : 1;            /*!< [7..7] Comparator operation control                                       */
      } CMPCTL_b;
    } ;
    __IM  uint8_t   RESERVED;
    __IM  uint16_t  RESERVED1;

    union {
      __IOM uint8_t CMPSEL0;                      /*!< (@ 0x00000004) Comparator Input Select Register                           */

      struct {
        __IOM uint8_t CMPSEL      : 3;            /*!< [2..0] Comparator input selection                                         */
      } CMPSEL0_b;
    } ;
    __IM  uint8_t   RESERVED2;
    __IM  uint16_t  RESERVED3;

    union {
      __IOM uint8_t CMPSEL1;                      /*!< (@ 0x00000008) Comparator Reference Voltage Select Register               */

      struct {
        __IOM uint8_t CRVS        : 6;            /*!< [5..0] Reference voltage selection                                        */
      } CMPSEL1_b;
    } ;
    __IM  uint8_t   RESERVED4;
    __IM  uint16_t  RESERVED5;

    union {
      __IM  uint8_t CMPMON;                       /*!< (@ 0x0000000C) Comparator Output Monitor Register                         */

      struct {
        __IM  uint8_t CMPMON      : 1;            /*!< [0..0] Comparator output monitor                                          */
      } CMPMON_b;
    } ;
    __IM  uint8_t   RESERVED6;
    __IM  uint16_t  RESERVED7;

    union {
      __IOM uint8_t CPIOC;                        /*!< (@ 0x00000010) Comparator Output Control Register                         */

      struct {
        __IOM uint8_t CPOE        : 1;            /*!< [0..0] Comparator output selection                                        */
        __IM  uint8_t             : 6;
        __IOM uint8_t VREFEN      : 1;            /*!< [7..7] Internal Vref enable                                               */
      } CPIOC_b;
    } ;
  __I  uint8_t   RESERVED24[239];
} R_ACMPHS0_Type;

/* =========================================================================================================================== */
/* ================                                          R_ACMPLP                                         ================ */
/* Note: 9/12/17 - The following structure for R_ACMPLP was hand edited using the output from the R7FS1JA7.svd output file     */
/* =========================================================================================================================== */


/**
  * @brief Low-Power Analog Comparator (R_ACMPLP)
  */

typedef struct {                                /*!< (@ 0x40085E00) ACMPLP Structure                                           */

  union {
    __IOM uint8_t COMPMDR;                      /*!< (@ 0x00000000) ACMPLP Mode Setting Register                               */

    struct {
      __IOM uint8_t C0ENB       : 1;            /*!< [0..0] ACMPLP0 Operation Enable                                           */
      __IOM uint8_t C0WDE       : 1;            /*!< [1..1] ACMPLP0 Window Function Mode Enable                                */
      __IOM uint8_t C0VRF       : 1;            /*!< [2..2] ACMPLP0 Reference Voltage SelectionNote1: It's effective
                                                     only at the time of standard mode.IVREF0 and IVREF1 are
                                                     chosen at window mode condition in spite of setting of
                                                     this bit.                                                                 */
      __IOM uint8_t C0MON       : 1;            /*!< [3..3] ACMPLP0 Monitor Flag                                               */
      __IOM uint8_t C1ENB       : 1;            /*!< [4..4] ACMPLP1 Operation Enable                                           */
      __IOM uint8_t C1WDE       : 1;            /*!< [5..5] ACMPLP1 Window Function Mode Enable                                */
      __IOM uint8_t C1VRF       : 1;            /*!< [6..6] ACMPLP1 Reference Voltage SelectionNote1: It's effective
                                                     only at the time of standard mode.IVREF0 and IVREF1 are
                                                     chosen at window mode condition in spite of setting of
                                                     this bit.                                                                 */
      __IOM uint8_t C1MON       : 1;            /*!< [7..7] ACMPLP1 Monitor Flag                                               */
    } COMPMDR_b;
  } ;

  union {
    __IOM uint8_t COMPFIR;                      /*!< (@ 0x00000001) ACMPLP Filter Control Register                             */

    struct {
      __IOM uint8_t C0FCK       : 2;            /*!< [1..0] ACMPLP0 Edge Detection Selection                                   */
      __IOM uint8_t C0EPO       : 1;            /*!< [2..2] ACMPLP0 Edge Polarity Switching                                    */
      __IOM uint8_t C0EDG       : 1;            /*!< [3..3] ACMPLP0 Filter Select                                              */
      __IOM uint8_t C1FCK       : 2;            /*!< [5..4] ACMPLP1 Edge Detection Selection                                   */
      __IOM uint8_t C1EPO       : 1;            /*!< [6..6] ACMPLP1 Edge Polarity Switching                                    */
      __IOM uint8_t C1EDG       : 1;            /*!< [7..7] ACMPLP1 Filter Select                                              */
    } COMPFIR_b;
  } ;

  union {
    __IOM uint8_t COMPOCR;                      /*!< (@ 0x00000002) ACMPLP Output Control Register                             */

    struct {
      __IM  uint8_t             : 1;
      __IOM uint8_t C0OE        : 1;            /*!< [1..1] ACMPLP0 VCOUT Pin Output Enable                                    */
      __IOM uint8_t C0OP        : 1;            /*!< [2..2] ACMPLP0 VCOUT Output Polarity Selection                            */
      __IM  uint8_t             : 2;
      __IOM uint8_t C1OE        : 1;            /*!< [5..5] ACMPLP1 VCOUT Pin Output Enable                                    */
      __IOM uint8_t C1OP        : 1;            /*!< [6..6] ACMPLP1 VCOUT Output Polarity Selection                            */
      __IOM uint8_t SPDMD       : 1;            /*!< [7..7] ACMPLP0/ACMPLP1 Speed Selection                                    */
    } COMPOCR_b;
  } ;
  __IM  uint8_t   RESERVED;

  union {
    __IOM uint8_t COMPSEL0;                     /*!< (@ 0x00000004) Comparator Input Select Register                           */

    struct {
      __IOM uint8_t CMPSEL10    : 2;            /*!< [1..0] ACMPLP0 Input (IVCMP0) Selection                                   */
      __IM  uint8_t             : 2;
      __IOM uint8_t CMPSEL54    : 2;            /*!< [5..4] ACMPLP1 Input (IVCMP1) Selection                                   */
    } COMPSEL0_b;
  } ;

  union {
    __IOM uint8_t COMPSEL1;                     /*!< (@ 0x00000005) Comparator Reference voltage Select Register               */

    struct {
      __IOM uint8_t CRVS10      : 2;            /*!< [1..0] ACMPLP0 Reference Voltage (IVREF0) Selection                       */
      __IM  uint8_t             : 2;
      __IOM uint8_t CRVS54      : 2;            /*!< [5..4] ACMPLP1 Reference Voltage(IVREF1) Selection                        */
      __IM  uint8_t             : 1;
      __IOM uint8_t C1VRF2      : 1;            /*!< [7..7] ACMPLP1 Reference Voltage Selection                                */
    } COMPSEL1_b;
  } ;
} R_ACMPLP_Type;                                /*!< Size = 6 (0x6)                                                            */


/* ================================================================================ */
/* ================                     R_MMPU                     ================ */
/* ================================================================================ */


/**
  * @brief Bus Master MPU (R_MMPU)
  */

typedef struct {                                    /*!< R_MMPU Structure                                                      */

  union {
    __IO uint16_t  MMPUCTLA;                        /*!< Bus Master MPU Control Group A Register                               */

    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  6;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUCTLA_b;                                   /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED[64];

  union {
    __IO uint16_t  MMPUPTA;                         /*!< Group A Protection of Register                                        */

    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MMPUSAn, MMPUEAn and MMPUACAn)                 */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUPTA_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED1[63];
  R_MMPU_MMPUACAnRC0_Type MMPUACAnRC0[32];          /*!< Group A Region %s Access Control Register Cluster 0                   */

  union {
    __IO uint16_t  MMPUCTLB;                        /*!< Bus Master MPU Control Group B Register                               */

    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  6;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUCTLB_b;                                   /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED2[64];

  union {
    __IO uint16_t  MMPUPTB;                         /*!< Group B Protection of Register                                        */

    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MMPUSBn, MMPUEBn and MMPUACBn)                 */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUPTB_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED3[63];
  R_MMPU_MMPUACBnRC0_Type MMPUACBnRC0[8];           /*!< Group B Region %s Access Control Register Cluster 0                   */
  __I  uint32_t  RESERVED4[96];

  union {
    __IO uint16_t  MMPUCTLC;                        /*!< Bus Master MPU Control Group C Register                               */

    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  6;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUCTLC_b;                                   /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED5[64];

  union {
    __IO uint16_t  MMPUPTC;                         /*!< Group C protection of register                                        */

    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MMPUSCn, MMPUECn and MMPUACCn)                 */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUPTC_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED6[63];
  R_MMPU_MMPUACCnRC0_Type MMPUACCnRC0[8];           /*!< Group C Region %s Access Control Register Cluster 0                   */
} R_MMPU_Type;


/* ================================================================================ */
/* ================                     R_SMPU                     ================ */
/* ================================================================================ */


/**
  * @brief Bus Slave MPU (R_SMPU)
  */

typedef struct {                                    /*!< R_SMPU Structure                                                      */

  union {
    __IO uint16_t  SMPUCTL;                         /*!< Slave MPU Control Register                                            */

    struct {
      __IO uint16_t  OAD        :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  PROTECT    :  2;               /*!< Protection of register Protected register SMPUMBIU, SMPUFBIU,
                                                         SMPUSRAM0, SMPUSRAM1, SMPUP0BIU, SMPUP2BIU, SMPUP6BIU, SMPUP7BIU,
                                                          SMPUEXBIU, SMPUEXBIU2                                                */
           uint16_t             :  5;
      __O  uint16_t  KEY        :  8;               /*!< Key CodeThis bit is used to enable or disable rewriting of the
                                                         PROTECT and OAD bit.                                                  */
    } SMPUCTL_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED[7];

  union {
    __IO uint16_t  SMPUMBIU;                        /*!< Access Control Register for MBIU                                      */

    struct {
           uint16_t             :  2;
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
           uint16_t             :  4;
      __IO uint16_t  RP_ROMC    :  1;               /*!< ROMC Read protection                                                  */
      __IO uint16_t  WP_ROMC    :  1;               /*!< ROMC Write protection                                                 */
      __IO uint16_t  RP_HSSRAM  :  1;               /*!< HSSRAM Read protection                                                */
      __IO uint16_t  WP_HSSRAM  :  1;               /*!< HSSRAM Write protection                                               */
    } SMPUMBIU_b;                                   /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED1;

  union {
    __IO uint16_t  SMPUFBIU;                        /*!< Access Control Register for FBIU                                      */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUFBIU_b;                                   /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED2;
  R_SMPU_SMPUSRAMnRC0_Type SMPUSRAMnRC0[2];         /*!< Access Control Register for SRAM%s Register Cluster 0                 */

  union {
    __IO uint16_t  SMPUP0BIU;                       /*!< Access Control Register for P%sBIU                                    */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP0BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED3;

  union {
    __IO uint16_t  SMPUP2BIU;                       /*!< Access Control Register for P%sBIU                                    */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP2BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED4;

  union {
    __IO uint16_t  SMPUP6BIU;                       /*!< Access Control Register for P%sBIU                                    */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP6BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED5;

  union {
    __IO uint16_t  SMPUP7BIU;                       /*!< Access Control Register for P%sBIU                                    */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP7BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED6;

  union {
    __IO uint16_t  SMPUEXBIU;                       /*!< Access Control Register for EXBIU                                     */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUEXBIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED7;

  union {
    __IO uint16_t  SMPUEXBIU2;                      /*!< Access Control Register for EXBIU2                                    */

    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUEXBIU2_b;                                 /*!< BitSize                                                               */
  };
} R_SMPU_Type;


/* ================================================================================ */
/* ================                     R_SPMON                    ================ */
/* ================================================================================ */


/**
  * @brief CPU Stack Pointer Monitor (R_SPMON)
  */

typedef struct {                                    /*!< R_SPMON Structure                                                     */

  union {
    __IO uint16_t  MSPMPUOAD;                       /*!< SP_main Monitor Operation After Detection Register                    */

    struct {
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MSPMPUOAD_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED;

  union {
    __IO uint16_t  MSPMPUCTL;                       /*!< SP_main Monitor Access Control Register                               */

    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< SP_main monitor enable                                                */
           uint16_t             :  7;
      __I  uint16_t  ERROR      :  1;               /*!< SP_main monitor error flag                                            */
    } MSPMPUCTL_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  MSPMPUPT;                        /*!< SP_main Monitor Protection of Register                                */

    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MSPMPUAC, MSPMPUSA and MSPMPUSE)               */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MSPMPUPT_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MSPMPUSA;                        /*!< SP_main Monitor Start Address Register                                */

    struct {
      __IO uint32_t  MSPMPUSA   : 32;               /*!< Region start address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFFE
                                                          The low-order 2 bits are fixed to 0.                                 */
    } MSPMPUSA_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MSPMPUEA;                        /*!< SP_main Monitor End Address Register                                  */

    struct {
      __IO uint32_t  MSPMPUEA   : 32;               /*!< Region end address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFFF
                                                          The low-order 2 bits are fixed to 1.                                 */
    } MSPMPUEA_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PSPMPUOAD;                       /*!< SP_process Monitor Operation After Detection Register                 */

    struct {
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } PSPMPUOAD_b;                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED1;

  union {
    __IO uint16_t  PSPMPUCTL;                       /*!< SP_process Monitor Access Control Register                            */

    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< SP_process monitor enable                                             */
           uint16_t             :  7;
      __I  uint16_t  ERROR      :  1;               /*!< SP_process monitor error flag                                         */
    } PSPMPUCTL_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PSPMPUPT;                        /*!< SP_process Monitor Protection of Register                             */

    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(PSPMPUAC, PSPMPUSA and PSPMPUSE)               */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } PSPMPUPT_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PSPMPUSA;                        /*!< SP_process Monitor Start Address Register                             */

    struct {
      __IO uint32_t  MSPMPUEA   : 32;               /*!< Region start address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFFE
                                                          The low-order 2 bits are fixed to 0.                                 */
    } PSPMPUSA_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PSPMPUEA;                        /*!< SP_process Monitor End Address Register                               */

    struct {
      __IO uint32_t  PSPMPUEA   : 32;               /*!< Region end address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFFF
                                                          The low-order 2 bits are fixed to 1.                                 */
    } PSPMPUEA_b;                                   /*!< BitSize                                                               */
  };
} R_SPMON_Type;



/* ================================================================================ */
/* ================                     R_SRAM                     ================ */
/* ================================================================================ */


/**
  * @brief SRAM Control (R_SRAM)
  */

typedef struct {                                    /*!< R_SRAM Structure                                                      */

  union {
    __IO uint8_t   PARIOAD;                         /*!< RAM Parity Error Operation After Detection Register                   */

    struct {
      __IO uint8_t   OAD        :  1;               /*!< Operation after detection                                             */
    } PARIOAD_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED[3];

  union {
    __IO uint8_t   RAMPRCR;                         /*!< RAM Protection Register                                               */

    struct {
      __IO uint8_t   RAMPRCR    :  1;               /*!< Register Write Control                                                */
      __O  uint8_t   KEY        :  7;               /*!< Key Code                                                              */
    } RAMPRCR_b;                                    /*!< BitSize                                                               */
  };

  __I  uint8_t   RESERVED2[187];

  union {
    __IO uint8_t   ECCRAMMODE;                      /*!< ECCRAM Operating Mode Control Register                                */

    struct {
      __IO uint8_t   RAMMOD     :  2;               /*!< RAM Operating Mode Select                                             */
    } ECCRAMMODE_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ECCRAM2STS;                      /*!< ECCRAM 2-Bit Error Status Register                                    */

    struct {
      __IO uint8_t   ECCRAM2ERR :  1;               /*!< ECC 2-Bit Error Status                                                */
    } ECCRAM2STS_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ECCRAM1STSEN;                    /*!< ECCRAM 1-Bit Error Information Update Enable Register                 */

    struct {
      __IO uint8_t   E1STSEN    :  1;               /*!< ECC 1-Bit Error Information Update Enable                             */
    } ECCRAM1STSEN_b;                               /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ECCRAM1STS;                      /*!< ECCRAM 1-Bit Error Status Register                                    */

    struct {
      __IO uint8_t   ECCRAM1ERR :  1;               /*!< ECC 1-Bit Error Status                                                */
    } ECCRAM1STS_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ECCRAMPRCR;                      /*!< ECCRAM Protection Register                                            */

    struct {
      __IO uint8_t   ECCRAMPRCR :  1;               /*!< ECCRAMETST Register Write Control                                     */
      __O  uint8_t   KEY        :  7;               /*!< Key Code                                                              */
    } ECCRAMPRCR_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED3[11];

  union {
    __IO uint8_t   ECCRAMPRCR2;                     /*!< ECCRAM Protection Register 2                                          */

    struct {
      __IO uint8_t   ECCRAMPRCR2:  1;               /*!< ECCRAMETST Register Write Control                                     */
      __O  uint8_t   KEY        :  7;               /*!< Key Code                                                              */
    } ECCRAMPRCR2_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED4[3];

  union {
    __IO uint8_t   ECCRAMETST;                      /*!< ECCRAM Test Control Register                                          */

    struct {
      __IO uint8_t   TSTBYP     :  1;               /*!< ECC Bypass Select                                                     */
    } ECCRAMETST_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED5[3];

  union {
    __IO uint8_t   ECCOAD;                          /*!< RAM ECC Error Operation After Detection Register                      */

    struct {
      __IO uint8_t   OAD        :  1;               /*!< Operation after detection                                             */
    } ECCOAD_b;                                     /*!< BitSize                                                               */
  };
} R_SRAM_Type;


/* ================================================================================ */
/* ================                      R_BUS                     ================ */
/* ================================================================================ */


/**
  * @brief BUS Control (R_BUS)
  */

typedef struct {                                    /*!< R_BUS Structure                                                       */
  CSRC0_Type CSRC0[8];                              /*!< CS Registers Cluster 0                                                */
  __I  uint32_t  RESERVED[480];
  CSRC1_Type CSRC1[8];                              /*!< CS Registers Cluster 1                                                */

  union {
    __IO uint16_t  CSRECEN;                         /*!< CS Recovery Cycle Insertion Enable Register                           */

    struct {
      __IO uint16_t  RECVEN0    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 0                        */
      __IO uint16_t  RECVEN1    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 1                        */
      __IO uint16_t  RECVEN2    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 2                        */
      __IO uint16_t  RECVEN3    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 3                        */
      __IO uint16_t  RECVEN4    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 4                        */
      __IO uint16_t  RECVEN5    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 5                        */
      __IO uint16_t  RECVEN6    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 6                        */
      __IO uint16_t  RECVEN7    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 7                        */
    } CSRECEN_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED1[447];

  union {
    __IO uint8_t   SDCCR;                           /*!< SDC Control Register                                                  */

    struct {
      __IO uint8_t   EXENB      :  1;               /*!< Operation Enable                                                      */
           uint8_t              :  3;
      __IO uint8_t   BSIZE      :  2;               /*!< SDRAM Bus Width Select                                                */
    } SDCCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SDCMOD;                          /*!< SDC Mode Register                                                     */

    struct {
      __IO uint8_t   EMODE      :  1;               /*!< Endian Mode                                                           */
    } SDCMOD_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SDAMOD;                          /*!< SDRAM Access Mode Register                                            */

    struct {
      __IO uint8_t   BE         :  1;               /*!< Continuous Access Enable                                              */
    } SDAMOD_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2[13];

  union {
    __IO uint8_t   SDSELF;                          /*!< SDRAM Self-Refresh Control Register                                   */

    struct {
      __IO uint8_t   SFEN       :  1;               /*!< SDRAM Self-Refresh Enable                                             */
    } SDSELF_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED3[3];

  union {
    __IO uint16_t  SDRFCR;                          /*!< SDRAM Refresh Control Register                                        */

    struct {
      __IO uint16_t  RFC        : 12;               /*!< Auto-Refresh Request Interval Setting                                 */
      __IO uint16_t  REFW       :  4;               /*!< Auto-Refresh Cycle/ Self-Refresh Clearing Cycle Count Setting.
                                                         ( REFW+1 Cycles )                                                     */
    } SDRFCR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SDRFEN;                          /*!< SDRAM Auto-Refresh Control Register                                   */

    struct {
      __IO uint8_t   RFEN       :  1;               /*!< Auto-Refresh Operation Enable                                         */
    } SDRFEN_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED4[9];

  union {
    __IO uint8_t   SDICR;                           /*!< SDRAM Initialization Sequence Control Register                        */

    struct {
      __IO uint8_t   INIRQ      :  1;               /*!< Initialization Sequence Start                                         */
    } SDICR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED5[3];

  union {
    __IO uint16_t  SDIR;                            /*!< SDRAM Initialization Register                                         */

    struct {
      __IO uint16_t  ARFI       :  4;               /*!< Initialization Auto-Refresh Interval ( PRF+3 cycles )                 */
      __IO uint16_t  ARFC       :  4;               /*!< Initialization Auto-Refresh Count                                     */
      __IO uint16_t  PRC        :  3;               /*!< Initialization Precharge Cycle Count ( PRF+3 cycles )                 */
    } SDIR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED6[13];

  union {
    __IO uint8_t   SDADR;                           /*!< SDRAM Address Register                                                */

    struct {
      __IO uint8_t   MXC        :  2;               /*!< Address Multiplex Select                                              */
    } SDADR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED7[3];

  union {
    __IO uint32_t  SDTR;                            /*!< SDRAM Timing Register                                                 */

    struct {
      __IO uint32_t  CL         :  3;               /*!< SDRAMC Column Latency                                                 */
           uint32_t             :  5;
      __IO uint32_t  WR         :  1;               /*!< Write Recovery Interval                                               */
      __IO uint32_t  RP         :  3;               /*!< Row Precharge Interval ( RP+1 cycles )                                */
      __IO uint32_t  RCD        :  2;               /*!< Row Column Latency ( RCD+1 cycles )                                   */
           uint32_t             :  2;
      __IO uint32_t  RAS        :  3;               /*!< Row Active Interval                                                   */
    } SDTR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  SDMOD;                           /*!< SDRAM Mode Register                                                   */

    struct {
      __IO uint16_t  MR         : 15;               /*!< Mode Register SettingWriting to these bits: Mode register set
                                                         command is issued.                                                    */
    } SDMOD_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED8[3];

  union {
    __I  uint8_t   SDSR;                            /*!< SDRAM Status Register                                                 */

    struct {
      __I  uint8_t   MRSST      :  1;               /*!< Mode Register Setting Status                                          */
           uint8_t              :  2;
      __I  uint8_t   INIST      :  1;               /*!< Initialization Status                                                 */
      __I  uint8_t   SRFST      :  1;               /*!< Self-Refresh Transition/Recovery Status                               */
    } SDSR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9[943];

  union {
    __IO uint16_t  BUSMCNTM4I;                      /*!< Master Bus Control Register %s                                        */

    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTM4I_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED10;

  union {
    __IO uint16_t  BUSMCNTM4D;                      /*!< Master Bus Control Register %s                                        */

    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTM4D_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED11;

  union {
    __IO uint16_t  BUSMCNTSYS;                      /*!< Master Bus Control Register %s                                        */

    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTSYS_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED12;

  union {
    __IO uint16_t  BUSMCNTDMA;                      /*!< Master Bus Control Register %s                                        */

    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTDMA_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED13;

  union {
    __IO uint16_t  BUSMCNTEDM;                      /*!< Master Bus Control Register %s                                        */

    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTEDM_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED14;

  union {
    __IO uint16_t  BUSMCNTHMI;                      /*!< Master Bus Control Register %s                                        */

    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTHMI_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED15[117];

  union {
    __IO uint16_t  BUSSCNTFLI;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTFLI_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED16;

  union {
    __IO uint16_t  BUSSCNTRAMH;                     /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTRAMH_b;                                /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED17;

  union {
    __IO uint16_t  BUSSCNTMBIU;                     /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTMBIU_b;                                /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED18;

  union {
    __IO uint16_t  BUSSCNTRAM0;                     /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTRAM0_b;                                /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED19;

  union {
    __IO uint16_t  BUSSCNTRAM1;                     /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTRAM1_b;                                /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED20;

  union {
    __IO uint16_t  BUSSCNTP0B;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP0B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED21;

  union {
    __IO uint16_t  BUSSCNTP2B;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP2B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED22;

  union {
    __IO uint16_t  BUSSCNTP3B;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP3B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED23;

  union {
    __IO uint16_t  BUSSCNTP4B;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP4B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED24;

  union {
    __IO uint16_t  BUSSCNTP5B;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP5B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED25;

  union {
    __IO uint16_t  BUSSCNTP6B;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP6B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED26;

  union {
    __IO uint16_t  BUSSCNTP7B;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP7B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED27;

  union {
    __IO uint16_t  BUSSCNTFBU;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTFBU_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED28;

  union {
    __IO uint16_t  BUSSCNTEXT;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTEXT_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED29;

  union {
    __IO uint16_t  BUSSCNTEXT2;                     /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTEXT2_b;                                /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED30;

  union {
    __IO uint16_t  BUSSCNTHMI;                      /*!< Slave Bus Control Register %s                                         */

    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTHMI_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED31[865];
  BUSnERRRC0_Type BUSnERRRC0[11];                   /*!< BUS %s Error Registers Cluster 0                                      */
} R_BUS_Type;





/* ================================================================================ */
/* ================                      R_DTC                     ================ */
/* ================================================================================ */


/**
  * @brief Data Transfer Controller (R_DTC)
  */

typedef struct {                                    /*!< R_DTC Structure                                                       */

  union {
    __IO uint8_t   DTCCR;                           /*!< DTC Control Register                                                  */

    struct {
           uint8_t              :  4;
      __IO uint8_t   RRS        :  1;               /*!< DTC Transfer Information Read Skip Enable.                            */
    } DTCCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED[3];

  union {
    __IO uint32_t  DTCVBR;                          /*!< DTC Vector Base Register                                              */

    struct {
      __IO uint32_t  DTCVBR     : 32;               /*!< Set DTC Vector Base Address.Note: A value cannot be set in the
                                                         lower-order 10 bits. These bits are fixed to 0.                       */
    } DTCVBR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED1;

  union {
    __IO uint8_t   DTCST;                           /*!< DTC Module Start Register                                             */

    struct {
      __IO uint8_t   DTCST      :  1;               /*!< DTC Module Start                                                      */
    } DTCST_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2;

  union {
    __I  uint16_t  DTCSTS;                          /*!< DTC Status Register                                                   */

    struct {
      __I  uint16_t  VECN       :  8;               /*!< DTC-Activating Vector Number MonitoringThese bits indicate the
                                                         vector number for the activating source when DTC transfer is
                                                          in progress.The value is only valid if DTC transfer is in progress
                                                          (the value of the ACT flag is 1)                                     */
           uint16_t             :  7;
      __I  uint16_t  ACT        :  1;               /*!< DTC Active Flag                                                       */
    } DTCSTS_b;                                     /*!< BitSize                                                               */
  };
} R_DTC_Type;


/* ================================================================================ */
/* ================                      R_ICU                     ================ */
/* ================================================================================ */


/**
  * @brief Interrupt Controller (R_ICU)
  */

typedef struct {                                    /*!< R_ICU Structure                                                       */

  union {
    __IO uint8_t   IRQCRn[16];                      /*!< IRQ Control Register %s                                               */

    struct {
      __IO uint8_t   IRQMD      :  2;               /*!< IRQ Detection Sense Select                                            */
           uint8_t              :  2;
      __IO uint8_t   FCLKSEL    :  2;               /*!< IRQ Digital Filter Sampling Clock                                     */
           uint8_t              :  1;
      __IO uint8_t   FLTEN      :  1;               /*!< IRQ Digital Filter Enable                                             */
    } IRQCRn_b[16];                                 /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED[60];

  union {
    __IO uint8_t   NMICR;                           /*!< NMI Pin Interrupt Control Register                                    */

    struct {
      __IO uint8_t   NMIMD      :  1;               /*!< NMI Detection Set                                                     */
           uint8_t              :  3;
      __IO uint8_t   NFCLKSEL   :  2;               /*!< NMI Digital Filter Sampling Clock                                     */
           uint8_t              :  1;
      __IO uint8_t   NFLTEN     :  1;               /*!< NMI Digital Filter Enable                                             */
    } NMICR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1[31];

  union {
    __IO uint16_t  NMIER;                           /*!< Non-Maskable Interrupt Enable Register                                */

    struct {
      __IO uint16_t  IWDTEN     :  1;               /*!< IWDT Underflow/Refresh Error Enable                                   */
      __IO uint16_t  WDTEN      :  1;               /*!< WDT Underflow/Refresh Error Enable                                    */
      __IO uint16_t  LVD1EN     :  1;               /*!< Voltage-Monitoring 1 Interrupt Enable                                 */
      __IO uint16_t  LVD2EN     :  1;               /*!< Voltage-Monitoring 2 Interrupt Enable                                 */
      __IO uint16_t  VBATTEN    :  1;               /*!< VBATT monitor Interrupt Enable                                        */
           uint16_t             :  1;
      __IO uint16_t  OSTEN      :  1;               /*!< Oscillation Stop Detection Interrupt Enable                           */
      __IO uint16_t  NMIEN      :  1;               /*!< NMI Enable                                                            */
      __IO uint16_t  RPEEN      :  1;               /*!< RAM Parity Error Interrupt Enable                                     */
      __IO uint16_t  RECCEN     :  1;               /*!< RAM ECC Error Interrupt Enable                                        */
      __IO uint16_t  BUSSEN     :  1;               /*!< MPU Bus Slave Error Interrupt Enable                                  */
      __IO uint16_t  BUSMEN     :  1;               /*!< MPU Bus Master Error Interrupt Enable                                 */
      __IO uint16_t  SPEEN      :  1;               /*!< MPU Stack Error Interrupt Enable                                      */
    } NMIER_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED2[7];

  union {
    __O  uint16_t  NMICLR;                          /*!< Non-Maskable Interrupt Status Clear Register                          */

    struct {
      __O  uint16_t  IWDTCLR    :  1;               /*!< IWDTST Clear                                                          */
      __O  uint16_t  WDTCLR     :  1;               /*!< WDTST Clear                                                           */
      __O  uint16_t  LVD1CLR    :  1;               /*!< LVD1ST Clear                                                          */
      __O  uint16_t  LVD2CLR    :  1;               /*!< LVD2ST Clear                                                          */
      __O  uint16_t  VBATTCLR   :  1;               /*!< VBATTST Clear                                                         */
           uint16_t             :  1;
      __O  uint16_t  OSTCLR     :  1;               /*!< OSTST Clear                                                           */
      __O  uint16_t  NMICLR     :  1;               /*!< NMIST Clear                                                           */
      __O  uint16_t  RPECLR     :  1;               /*!< RPEST Clear                                                           */
      __O  uint16_t  RECCCLR    :  1;               /*!< RECCST Clear                                                          */
      __O  uint16_t  BUSSCLR    :  1;               /*!< BUSSST Clear                                                          */
      __O  uint16_t  BUSMCLR    :  1;               /*!< BUSMST Clear                                                          */
      __O  uint16_t  SPECLR     :  1;               /*!< SPEST Clear                                                           */
    } NMICLR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED3[7];

  union {
    __I  uint16_t  NMISR;                           /*!< Non-Maskable Interrupt Status Register                                */

    struct {
      __I  uint16_t  IWDTST     :  1;               /*!< IWDT Underflow/Refresh Error Status Flag                              */
      __I  uint16_t  WDTST      :  1;               /*!< WDT Underflow/Refresh Error Status Flag                               */
      __I  uint16_t  LVD1ST     :  1;               /*!< Voltage-Monitoring 1 Interrupt Status Flag                            */
      __I  uint16_t  LVD2ST     :  1;               /*!< Voltage-Monitoring 2 Interrupt Status Flag                            */
      __I  uint16_t  VBATTST    :  1;               /*!< VBATT monitor Interrupt Status Flag                                   */
           uint16_t             :  1;
      __I  uint16_t  OSTST      :  1;               /*!< Oscillation Stop Detection Interrupt Status Flag                      */
      __I  uint16_t  NMIST      :  1;               /*!< NMI Status Flag                                                       */
      __I  uint16_t  RPEST      :  1;               /*!< RAM Parity Error Interrupt Status Flag                                */
      __I  uint16_t  RECCST     :  1;               /*!< RAM ECC Error Interrupt Status Flag                                   */
      __I  uint16_t  BUSSST     :  1;               /*!< MPU Bus Slave Error Interrupt Status Flag                             */
      __I  uint16_t  BUSMST     :  1;               /*!< MPU Bus Master Error Interrupt Status Flag                            */
      __I  uint16_t  SPEST      :  1;               /*!< MPU Stack Error Interrupt Status Flag                                 */
    } NMISR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED4[47];

  union {
    __IO uint32_t  WUPEN;                           /*!< Wake Up interrupt enable register                                     */

    struct {
      __IO uint32_t  IRQWUPEN0  :  1;               /*!< IRQ0 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN1  :  1;               /*!< IRQ1 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN2  :  1;               /*!< IRQ2 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN3  :  1;               /*!< IRQ3 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN4  :  1;               /*!< IRQ4 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN5  :  1;               /*!< IRQ5 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN6  :  1;               /*!< IRQ6 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN7  :  1;               /*!< IRQ7 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN8  :  1;               /*!< IRQ8 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN9  :  1;               /*!< IRQ9 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN10 :  1;               /*!< IRQ10 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN11 :  1;               /*!< IRQ11 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN12 :  1;               /*!< IRQ12 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN13 :  1;               /*!< IRQ13 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN14 :  1;               /*!< IRQ14 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN15 :  1;               /*!< IRQ15 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IWDTWUPEN  :  1;               /*!< IWDT interrupt S/W standby returns enable bit                         */
      __IO uint32_t  KEYWUPEN   :  1;               /*!< Key interrupt S/W standby returns enable bit                          */
      __IO uint32_t  LVD1WUPEN  :  1;               /*!< LVD1 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  LVD2WUPEN  :  1;               /*!< LVD2 interrupt S/W standby returns enable bit                         */
           uint32_t             :  2;
      __IO uint32_t  COMPOC0WUPEN:  1;              /*!< Comparator-OC0 interrupt S/W standby returns enable bit               */
           uint32_t             :  1;
      __IO uint32_t  RTCALMWUPEN:  1;               /*!< RTC alarm interrupt S/W standby returns enable bit                    */
      __IO uint32_t  RTCPRDWUPEN:  1;               /*!< RCT period interrupt S/W standby returns enable bit                   */
      __IO uint32_t  USBHSWUPEN :  1;               /*!< USBHS interrupt S/W standby returns enable bit                        */
      __IO uint32_t  USBFSWUPEN :  1;               /*!< USBFS interrupt S/W standby returns enable bit                        */
      __IO uint32_t  AGT1UDWUPEN:  1;               /*!< AGT1 underflow interrupt S/W standby returns enable bit               */
      __IO uint32_t  AGT1CAWUPEN:  1;               /*!< AGT1 compare match A interrupt S/W standby returns enable bit         */
      __IO uint32_t  AGT1CBWUPEN:  1;               /*!< AGT1 compare match B interrupt S/W standby returns enable bit         */
      __IO uint32_t  RIIC0WUPEN :  1;               /*!< RIIC0 address match interrupt S/W standby returns enable bit          */
    } WUPEN_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED5[23];

  union {
    __IO uint16_t  SELSR0;                          /*!< Event Selection to Cancel Snooze Mode                                 */

    struct {
      __IO uint16_t  SELS       :  9;               /*!< Event selection to cancel snooze mode                                 */
    } SELSR0_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED6[63];
  R_ICU_DELSRn_Type DELSRn[8];                      /*!< DMAC Event Link Setting Register %s                                   */
  __I  uint32_t  RESERVED7[24];

  union {
    __IO uint32_t  IELSRn[96];                      /*!< INT Event Link Setting Register %s                                    */

    struct {
      __IO uint32_t  IELS       :  9;               /*!< Event selection to NVIC                                               */
           uint32_t             :  7;
      __IO uint32_t  IR         :  1;               /*!< Interrupt Status Flag                                                 */
           uint32_t             :  7;
      __IO uint32_t  DTCE       :  1;               /*!< DTC Activation Enable                                                 */
    } IELSRn_b[96];                                 /*!< BitSize                                                               */
  };
} R_ICU_Type;


/* ================================================================================ */
/* ================                      R_DBG                     ================ */
/* ================================================================================ */


/**
  * @brief Debug Function (R_DBG)
  */

typedef struct {                                    /*!< R_DBG Structure                                                       */

  union {
    __I  uint32_t  DBGSTR;                          /*!< Debug Status Register                                                 */

    struct {
           uint32_t             : 28;
      __I  uint32_t  CDBGPWRUPREQ:  1;              /*!< Debug power-up request                                                */
      __I  uint32_t  CDBGPWRUPACK:  1;              /*!< Debug power-up acknowledge                                            */
    } DBGSTR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED[3];

  union {
    __IO uint32_t  DBGSTOPCR;                       /*!< Debug Stop Control Register                                           */

    struct {
      __IO uint32_t  DSIWDT     :  1;               /*!< Mask bit for IWDT reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
      __IO uint32_t  DSWDT      :  1;               /*!< Mask bit for WDT reset/interruptNOTE: This bit is regarded as
                                                         0 when debugger is not connected.                                     */
           uint32_t             : 14;
      __IO uint32_t  DSLVD0     :  1;               /*!< Mask bit for LVD0 reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
      __IO uint32_t  DSLVD1     :  1;               /*!< Mask bit for LVD1 reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
      __IO uint32_t  DSLVD2     :  1;               /*!< Mask bit for LVD2 reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
           uint32_t             :  5;
      __IO uint32_t  DSRPER     :  1;               /*!< Mask bit for RAM parity error reset/interruptNOTE: This bit
                                                         is regarded as 0 when debugger is not connected.                      */
      __IO uint32_t  DSRECCR    :  1;               /*!< Mask bit for RAM ECC error reset/interruptNOTE: This bit is
                                                         regarded as 0 when debugger is not connected.                         */
    } DBGSTOPCR_b;                                  /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED1[3];

  union {
    __IO uint32_t  TRACECTR;                        /*!< Trace Control Register                                                */

    struct {
           uint32_t             : 31;
      __IO uint32_t  ENETBFULL  :  1;               /*!< Enable bit for halt request by ETB full                               */
    } TRACECTR_b;                                   /*!< BitSize                                                               */
  };
} R_DBG_Type;

/* ================================================================================ */
/* ================                     R_ROMC                     ================ */
/* ================================================================================ */


/**
  * @brief ROM Cache (R_ROMC)
  */

typedef struct {                                    /*!< R_ROMC Structure                                                      */
  __I  uint8_t RESERVED[64 * 4];

  union {
    __IO uint16_t  ROMCE;                           /*!< ROM Cache Enable                                                      */

    struct {
      __IO uint16_t  ROMCEN     :  1;               /*!< ROMC Enable                                                           */
    } ROMCE_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[2];   // Padding changed from uint16_t

  union {
    __IO uint16_t  ROMCIV;                          /*!< ROM Cache Invalidation                                                */

    struct {
      __IO uint16_t  ROMCIV     :  1;               /*!< ROM Cache Invalidation                                                */
    } ROMCIV_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[11 * 2];

  union {
    __IO uint8_t   ROMWT;                           /*!< ROM wait control register                                             */

    struct {
      __IO uint8_t   ROMWT      :  3;               /*!< These bits represent the ratio of the CPU clock period to the
                                                         Flash memory access time.                                             */
    } ROMWT_b;                                      /*!< BitSize                                                               */
  };
} R_ROMC_Type;


/* ================================================================================ */
/* ================                    R_SYSTEM                    ================ */
/* ================================================================================ */


/**
  * @brief System Control (R_SYSTEM)
  */

typedef struct {                                    /*!< R_SYSTEM Structure                                                    */
  __I  uint32_t  RESERVED[3];

  union {
    __IO uint16_t  SBYCR;                           /*!< Standby Control Register                                              */

    struct {
           uint16_t             : 14;
      __IO uint16_t  OPE        :  1;               /*!< Output Port Enable                                                    */
      __IO uint16_t  SSBY       :  1;               /*!< Software Standby                                                      */
    } SBYCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED1[7];

  union {
    __IO uint32_t  MSTPCRA;                         /*!< Module Stop Control Register A                                        */

    struct {
      __IO uint32_t  MSTPA0     :  1;               /*!< RAM0 Module Stop                                                      */
      __IO uint32_t  MSTPA1     :  1;               /*!< RAM1 Module Stop                                                      */
           uint32_t             :  3;
      __IO uint32_t  MSTPA5     :  1;               /*!< High-Speed RAM Module Stop                                            */
      __IO uint32_t  MSTPA6     :  1;               /*!< ECCRAM Module Stop                                                    */
      __IO uint32_t  MSTPA7     :  1;               /*!< Standby RAM Module Stop                                               */
           uint32_t             : 14;
      __IO uint32_t  MSTPA22    :  1;               /*!< DMA Controller/Data Transfer Controller Module Stop                   */
    } MSTPCRA_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  SCKDIVCR;                        /*!< System Clock Division Control Register                                */

    struct {
      __IO uint32_t  PCKD       :  3;               /*!< Peripheral Module Clock D (PCLKD) Select                              */
           uint32_t             :  1;
      __IO uint32_t  PCKC       :  3;               /*!< Peripheral Module Clock C (PCLKC) Select                              */
           uint32_t             :  1;
      __IO uint32_t  PCKB       :  3;               /*!< Peripheral Module Clock B (PCLKB) Select                              */
           uint32_t             :  1;
      __IO uint32_t  PCKA       :  3;               /*!< Peripheral Module Clock A (PCLKA) Select                              */
           uint32_t             :  1;
      __IO uint32_t  BCK        :  3;               /*!< External Bus Clock (BCLK) Select                                      */
           uint32_t             :  5;
      __IO uint32_t  ICK        :  3;               /*!< System Clock (ICLK) Select                                            */
           uint32_t             :  1;
      __IO uint32_t  FCK        :  3;               /*!< Flash IF Clock (FCLK) Select                                          */
    } SCKDIVCR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SCKDIVCR2;                       /*!< System Clock Division Control Register 2                              */

    struct {
           uint8_t              :  4;
      __IO uint8_t   UCK        :  3;               /*!< USB Clock (UCLK) Select                                               */
    } SCKDIVCR2_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2;

  union {
    __IO uint8_t   SCKSCR;                          /*!< System Clock Source Control Register                                  */

    struct {
      __IO uint8_t   CKSEL      :  3;               /*!< Clock Source Select                                                   */
    } SCKSCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED3;

  union {
    __IO uint16_t  PLLCCR;                          /*!< PLL Clock Control Register                                            */

    struct {
      __IO uint16_t  PLIDIV     :  2;               /*!< PLL Input Frequency Division Ratio Select                             */
           uint16_t             :  2;
      __IO uint16_t  PLLSRCSEL  :  1;               /*!< PLL Clock Source Select                                               */
           uint16_t             :  3;
      __IO uint16_t  PLLMUL     :  6;               /*!< PLL Frequency Multiplication Factor Select [PLL Frequency Multiplication
                                                         Factor] = (PLLUMUL+1) / 2 Range: 0x23 - 0x3B for example 010011:
                                                          x10.0 010100: x10.5 010101: x11.0 : 011100: x14.5 011101: x15.0
                                                          011110: x15.5 : 111010: x29.5 111011: x30.0                          */
    } PLLCCR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   PLLCR;                           /*!< PLL Control Register                                                  */

    struct {
      __IO uint8_t   PLLSTP     :  1;               /*!< PLL Stop Control                                                      */
      uint8_t                   :  7;

    } PLLCR_b;                                      /*!< BitSize                                                               */
  };

  union {
     __IO uint8_t  PLLCCR2;                          /*!< PLL Clock Control Register                                            */

     struct {
       __IO uint8_t  PLLMUL     :  5;               /*!< PLL Multipler                             */
            uint8_t             :  1;
       __IO uint8_t  PLODIV     :  2;               /*!< PLL Divider                 */
     } PLLCCR2_b;                                   /*!< BitSize                                                               */
   };
  __I  uint8_t   RESERVED4[4];

  union {
    __IO uint8_t   BCKCR;                           /*!< External Bus Clock Control Register                                   */

    struct {
      __IO uint8_t   BCLKDIV    :  1;               /*!< BCLK Pin Output Select                                                */
    } BCKCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   MEMWAITCR;                       /*!< Memory Wait Cycle COntrol register                                   */

    struct {
      __IO uint8_t MEMWAIT      :  1;               /*!< MEMWAIT Select                                                */
    } MEMWAITCR_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   MOSCCR;                          /*!< Main Clock Oscillator Control Register                                */

    struct {
      __IO uint8_t   MOSTP      :  1;               /*!< Main Clock Oscillator Stop                                            */
    } MOSCCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED6[3];

  union {
    __IO uint8_t   HOCOCR;                          /*!< High-Speed On-Chip Oscillator Control Register                        */

    struct {
      __IO uint8_t   HCSTP      :  1;               /*!< HOCO Stop                                                             */
    } HOCOCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED7;

  union {
    __IO uint8_t   MOCOCR;                          /*!< Middle-Speed On-Chip Oscillator Control Register                      */

    struct {
      __IO uint8_t   MCSTP      :  1;               /*!< MOCO Stop                                                             */
    } MOCOCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED8[3];

  union {
    __I  uint8_t   OSCSF;                           /*!< Oscillation Stabilization Flag Register                               */

    struct {
      __I  uint8_t   HOCOSF     :  1;               /*!< HOCO Clock Oscillation Stabilization FlagNOTE: The HOCOSF bit
                                                         value after a reset is 1 when the OFS1.HOCOEN bit is 0. It is
                                                          0 when the OFS1.HOCOEN bit is 1.                                     */
           uint8_t              :  2;
      __I  uint8_t   MOSCSF     :  1;               /*!< Main Clock Oscillation Stabilization Flag                             */
           uint8_t              :  1;
      __I  uint8_t   PLLSF      :  1;               /*!< PLL Clock Oscillation Stabilization Flag                              */
    } OSCSF_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9;

  union {
    __IO uint8_t   CKOCR;                           /*!< Clock Out Control Register                                            */

    struct {
      __IO uint8_t   CKOSEL     :  3;               /*!< Clock out source select                                               */
           uint8_t              :  1;
      __IO uint8_t   CKODIV     :  3;               /*!< Clock out input frequency Division Select                             */
      __IO uint8_t   CKOEN      :  1;               /*!< Clock out enable                                                      */
    } CKOCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED10;

  union {
    __IO uint8_t   OSTDCR;                          /*!< Oscillation Stop Detection Control Register                           */

    struct {
      __IO uint8_t   OSTDIE     :  1;               /*!< Oscillation Stop Detection Interrupt Enable                           */
           uint8_t              :  6;
      __IO uint8_t   OSTDE      :  1;               /*!< Oscillation Stop Detection Function Enable                            */
    } OSTDCR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   OSTDSR;                          /*!< Oscillation Stop Detection Status Register                            */

    struct {
      __IO uint8_t   OSTDF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
    } OSTDSR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED11A[14];

  union {
    __IO uint8_t   SLCDSCKCR;                       /*!< Segment LCD Source Clock Control Register                            */

    struct {
    __IO uint8_t  LCDSCKSEL     :  4;               /*!< LCD Source Clock                                       */
      uint8_t                   :  3;
    __IO uint8_t  LCDSCKEN      :  1;               /*!< LCD Source Clock Out Enable                                       */
    } SLCDSCKCR_b;                                  /*!< BitSize                                                               */
  };

  __I  uint8_t  RESERVED11B[1];
  union {
    __IO uint8_t   EBCKOCR;                         /*!< External Bus Clock Output Control Register                            */

    struct {
      __IO uint8_t   EBCKOEN    :  1;               /*!< BCLK Pin Output Control                                               */
    } EBCKOCR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SDCKOCR;                         /*!< SDRAM Clock Output Control Register                                   */

    struct {
      __IO uint8_t   SDCKOEN    :  1;               /*!< SDCLK Pin Output Control                                              */
    } SDCKOCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED12[13];

  union {
    __IO uint8_t   MOCOUTCR;                        /*!< MOCO User Trimming Control Register                                   */

    struct {
      __IO uint8_t   MOCOUTRM   :  8;               /*!< MOCO User Trimming 1000_0000 : -128 1000_0001 : -127 1000_0010
                                                         : -126 . . . 1111_1111 : -1 0000_0000 : Center Code 0000_0001
                                                          : +1 . . . 0111_1101 : +125 0111_1110 : +126 0111_1111 : +127These
                                                          bits are added to original MOCO trimming bits                        */
    } MOCOUTCR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   HOCOUTCR;                        /*!< HOCO User Trimming Control Register                                   */

    struct {
      __IO uint8_t   HOCOUTRM   :  8;               /*!< HOCO User Trimming 1000_0000 : -128 1000_0001 : -127 1000_0010
                                                         : -126 . . . 1111_1111 : -1 0000_0000 : Center Code 0000_0001
                                                          : +1 . . . 0111_1101 : +125 0111_1110 : +126 0111_1111 : +127These
                                                          bits are added to original HOCO trimming bits                        */
    } HOCOUTCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED13[47];



  union {
    __IO uint8_t   SNZCR;                           /*!< Snooze Control Register                                               */

    struct {
      __IO uint8_t   RXDREQEN   :  1;               /*!< RXD0 Snooze Request EnableNote:Do not set to 1 other than in
                                                         asynchronous mode.                                                    */
      __IO uint8_t   SNZDTCEN   :  1;               /*!< DTC Enable in Snooze Mode                                             */
           uint8_t              :  5;
      __IO uint8_t   SNZE       :  1;               /*!< Snooze Mode Enable                                                    */
    } SNZCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED14;

  union {
    __IO uint8_t   SNZEDCR;                         /*!< Snooze End Control Register                                           */

    struct {
      __IO uint8_t   AGT1UNFED  :  1;               /*!< AGT1 underflow Snooze End Enable                                      */
      __IO uint8_t   DTCZRED    :  1;               /*!< Last DTC transmission completion Snooze End Enable                    */
      __IO uint8_t   DTCNZRED   :  1;               /*!< Not Last DTC transmission completion Snooze End Enable                */
      __IO uint8_t   AD0MATED   :  1;               /*!< AD ch0 result match Snooze End Enable                                 */
      __IO uint8_t   AD0UMTED   :  1;               /*!< AD ch0 result unmatch Snooze End Enable                               */
      __IO uint8_t   AD1MATED   :  1;               /*!< AD ch1 result match Snooze End Enable                                 */
      __IO uint8_t   AD1UMTED   :  1;               /*!< AD ch1 result unmatch Snooze End Enable                               */
      __IO uint8_t   SCI0UMTED  :  1;               /*!< SCI0 address unmatch Snooze End EnableNote: Do not set to 1
                                                         other than in asynchronous mode.                                      */
    } SNZEDCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED15[3];

  union {
    __IO uint32_t  SNZREQCR;                        /*!< Snooze Request Control Register                                       */

    struct {
      __IO uint32_t  SNZREQEN0  :  1;               /*!< Snooze Request Enable 0Enable IRQ0 pin snooze request                 */
      __IO uint32_t  SNZREQEN1  :  1;               /*!< Snooze Request Enable 1Enable IRQ1 pin snooze request                 */
      __IO uint32_t  SNZREQEN2  :  1;               /*!< Snooze Request Enable 2Enable IRQ2 pin snooze request                 */
      __IO uint32_t  SNZREQEN3  :  1;               /*!< Snooze Request Enable 3Enable IRQ3 pin snooze request                 */
      __IO uint32_t  SNZREQEN4  :  1;               /*!< Snooze Request Enable 4Enable IRQ4 pin snooze request                 */
      __IO uint32_t  SNZREQEN5  :  1;               /*!< Snooze Request Enable 5Enable IRQ5 pin snooze request                 */
      __IO uint32_t  SNZREQEN6  :  1;               /*!< Snooze Request Enable 6Enable IRQ6 pin snooze request                 */
      __IO uint32_t  SNZREQEN7  :  1;               /*!< Snooze Request Enable 7Enable IRQ7 pin snooze request                 */
      __IO uint32_t  SNZREQEN8  :  1;               /*!< Snooze Request Enable 8Enable IRQ8 pin snooze request                 */
      __IO uint32_t  SNZREQEN9  :  1;               /*!< Snooze Request Enable 9Enable IRQ9 pin snooze request                 */
      __IO uint32_t  SNZREQEN10 :  1;               /*!< Snooze Request Enable 10Enable IRQ10 pin snooze request               */
      __IO uint32_t  SNZREQEN11 :  1;               /*!< Snooze Request Enable 11Enable IRQ11 pin snooze request               */
      __IO uint32_t  SNZREQEN12 :  1;               /*!< Snooze Request Enable 12Enable IRQ12 pin snooze request               */
      __IO uint32_t  SNZREQEN13 :  1;               /*!< Snooze Request Enable 13Enable IRQ13 pin snooze request               */
      __IO uint32_t  SNZREQEN14 :  1;               /*!< Snooze Request Enable 14Enable IRQ14 pin snooze request               */
      __IO uint32_t  SNZREQEN15 :  1;               /*!< Snooze Request Enable 15Enable IRQ15 pin snooze request               */
           uint32_t             :  1;
      __IO uint32_t  SNZREQEN17 :  1;               /*!< Snooze Request Enable 17Enable KR snooze request                      */
           uint32_t             :  4;
      __IO uint32_t  SNZREQEN22 :  1;               /*!< Snooze Request Enable 22Enable Comparator-OC0 snooze request          */
           uint32_t             :  1;
      __IO uint32_t  SNZREQEN24 :  1;               /*!< Snooze Request Enable 24Enable RTC alarm snooze request               */
      __IO uint32_t  SNZREQEN25 :  1;               /*!< Snooze Request Enable 25Enable RTC period snooze request              */
           uint32_t             :  2;
      __IO uint32_t  SNZREQEN28 :  1;               /*!< Snooze Request Enable 28Enable AGT1 underflow snooze request          */
      __IO uint32_t  SNZREQEN29 :  1;               /*!< Snooze Request Enable 29Enable AGT1 compare match A snooze request    */
      __IO uint32_t  SNZREQEN30 :  1;               /*!< Snooze Request Enable 30Enable AGT1 compare match B snooze request    */
    } SNZREQCR_b;                                   /*!< BitSize                                                               */
  };

  __I  uint8_t  RESERVED16[2];

  union {
    __IO uint8_t   FLSTOPCR;                        /*!< Flash Operation Control Register                                      */

    struct {
      __IO uint8_t   FLSTOP     :  1;               /*!< Selecting ON/OFF of the Flash Memory Operation                        */
           uint8_t              :  3;
      __I  uint8_t   FLSTPF     :  1;               /*!< Flash Memory Operation Status Flag                                    */
    } FLSTOPCR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   PSMCR;                           /*!< Power Save Memory Control Register                                    */

    struct {
      __IO uint8_t   PSMC       :  2;               /*!< Power Save Memory Control                                             */
           uint8_t              :  6;
    } PSMCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   OPCCR;                           /*!< Operating Power Control Register                                      */

    struct {
      __IO uint8_t   OPCM       :  2;               /*!< Operating Power Control Mode Select                                   */
           uint8_t              :  2;
      __I  uint8_t   OPCMTSF    :  1;               /*!< Operating Power Control Mode Transition Status Flag                   */
    } OPCCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED17;

  union {
    __IO uint8_t   MOSCWTCR;                        /*!< Main Clock Oscillator Wait Control Register                           */

    struct {
      __IO uint8_t   MSTS       :  4;               /*!< Main clock oscillator wait time setting                               */
    } MOSCWTCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED18a[2];

  union {
    __IO uint8_t   HOCOWTCR;                        /*!< HOCO Clock Oscillator Wait Control Register                           */

    struct {
      __IO uint8_t   HSTS       :  3;               /*!< HOCO clock oscillator wait time setting                               */
    } HOCOWTCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED18b[4];

  union {
    __IO uint8_t   SOPCCR;                          /*!< Sub Operating Power Control Register                                  */

    struct {
      __IO uint8_t   SOPCM      :  1;               /*!< Sub Operating Power Control Mode Select                               */
           uint8_t              :  3;
      __I  uint8_t   SOPCMTSF   :  1;               /*!< Sub Operating Power Control Mode Transition Status Flag               */
    } SOPCCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED19[21];

  union {
    __IO uint16_t  RSTSR1;                          /*!< Reset Status Register 1                                               */

    struct {
      __IO uint16_t  IWDTRF     :  1;               /*!< Independent Watchdog Timer Reset Detect Flag                          */
      __IO uint16_t  WDTRF      :  1;               /*!< Watchdog Timer Reset Detect Flag                                      */
      __IO uint16_t  SWRF       :  1;               /*!< Software Reset Detect Flag                                            */
           uint16_t             :  5;
      __IO uint16_t  RPERF      :  1;               /*!< RAM Parity Error Reset Detect Flag                                    */
      __IO uint16_t  REERF      :  1;               /*!< RAM ECC Error Reset Detect Flag                                       */
      __IO uint16_t  BUSSRF     :  1;               /*!< Bus Slave MPU Reset Detect Flag                                       */
      __IO uint16_t  BUSMRF     :  1;               /*!< Bus Master MPU Reset Detect Flag                                      */
      __IO uint16_t  SPERF      :  1;               /*!< SP Error Reset Detect Flag                                            */
    } RSTSR1_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED20;

  union {
    __IO uint8_t   SWRRAGT;                         /*!< Software Reset Register for AGT                                       */

    struct {
      __IO uint8_t   AGTRST     :  1;               /*!< AG Timer Software Reset                                               */
    } SWRRAGT_b;                                    /*!< BitSize                                                               */
  };

  __I  uint8_t   RESERVED21[12];

  union {
    __IO uint8_t   SDADCCKCR;                       /*!< 24-bit Sigma-Delta A/D Converter Clock Control Register                            */

    struct {
    __IO uint8_t  SDADCCKSEL     :  1;              /*!< SDADC Source Clock                                       */
    uint8_t                      :  6;
    __IO uint8_t  SDADCCKEN      :  1;              /*!< SDADC Source Clock Out Enable                                       */
    } SDADCCKCR_b;                                  /*!< BitSize                                                               */
  };

  __I  uint8_t   RESERVED21B[14];

  R_SYSTEM_LVDnRC0_Type LVDnRC0[2];                 /*!< Voltage Monitoring %s Circuit Register Cluster 0                      */
  __I  uint16_t  RESERVED22[397];

  union {
    __IO uint16_t  PRCR;                            /*!< Protect Register                                                      */

    struct {
      __IO uint16_t  PRC0       :  1;               /*!< Enables writing to the registers related to the clock generation
                                                         circuit.                                                              */
      __IO uint16_t  PRC1       :  1;               /*!< Enables writing to the registers related to the operating modes,
                                                         the low power consumption modes and the battery backup function.      */
           uint16_t             :  1;
      __IO uint16_t  PRC3       :  1;               /*!< Enables writing to the registers related to the LVD.                  */
           uint16_t             :  4;
      __O  uint16_t  PRKEY      :  8;               /*!< PRKEY Key Code                                                        */
    } PRCR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSBYCR;                         /*!< Deep Standby Control Register                                         */

    struct {
      __IO uint8_t   DEEPCUT    :  2;               /*!< Power-Supply Control                                                  */
           uint8_t              :  4;
      __IO uint8_t   IOKEEP     :  1;               /*!< I/O Port Retention                                                    */
      __IO uint8_t   DPSBY      :  1;               /*!< Deep Software Standby                                                 */
    } DPSBYCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED23;

  union {
    __IO uint8_t   DPSIER0;                         /*!< Deep Standby Interrupt Enable Register 0                              */

    struct {
      __IO uint8_t   DIRQ0E     :  1;               /*!< IRQ0-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ1E     :  1;               /*!< IRQ1-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ2E     :  1;               /*!< IRQ2-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ3E     :  1;               /*!< IRQ3-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ4E     :  1;               /*!< IRQ4-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ5E     :  1;               /*!< IRQ5-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ6E     :  1;               /*!< IRQ6-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ7E     :  1;               /*!< IRQ7-DS Pin Enable                                                    */
    } DPSIER0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIER1;                         /*!< Deep Standby Interrupt Enable Register 1                              */

    struct {
      __IO uint8_t   DIRQ8E     :  1;               /*!< IRQ8-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ9E     :  1;               /*!< IRQ9-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ10E    :  1;               /*!< IRQ10-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ11E    :  1;               /*!< IRQ11-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ12E    :  1;               /*!< IRQ12-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ13E    :  1;               /*!< IRQ13-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ14E    :  1;               /*!< IRQ14-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ15E    :  1;               /*!< IRQ15-DS Pin Enable                                                   */
    } DPSIER1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIER2;                         /*!< Deep Standby Interrupt Enable Register 2                              */

    struct {
      __IO uint8_t   DLVD1IE    :  1;               /*!< LVD1 Deep Standby Cancel Signal Enable                                */
      __IO uint8_t   DLVD2IE    :  1;               /*!< LVD2 Deep Standby Cancel Signal Enable                                */
      __IO uint8_t   DTRTCIIE   :  1;               /*!< RTC Interval interrupt Deep Standby Cancel Signal Enable              */
      __IO uint8_t   DRTCAIE    :  1;               /*!< RTC Alarm interrupt Deep Standby Cancel Signal Enable                 */
      __IO uint8_t   DNMIE      :  1;               /*!< NMI Pin Enable                                                        */
    } DPSIER2_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIER3;                         /*!< Deep Standby Interrupt Enable Register 3                              */

    struct {
      __IO uint8_t   DUSBFSIE   :  1;               /*!< USBFS Suspend/Resume Deep Standby Cancel Signal Enable                */
      __IO uint8_t   DUSBHSIE   :  1;               /*!< USBHS Suspend/Resume Deep Standby Cancel Signal Enable                */
      __IO uint8_t   DAGT1IE    :  1;               /*!< AGT1 Underflow Deep Standby Cancel Signal Enable                      */
    } DPSIER3_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIFR0;                         /*!< Deep Standby Interrupt Flag Register 0                                */

    struct {
      __IO uint8_t   DIRQ0F     :  1;               /*!< IRQ0-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ1F     :  1;               /*!< IRQ1-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ2F     :  1;               /*!< IRQ2-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ3F     :  1;               /*!< IRQ3-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ4F     :  1;               /*!< IRQ4-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ5F     :  1;               /*!< IRQ5-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ6F     :  1;               /*!< IRQ6-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ7F     :  1;               /*!< IRQ7-DS Pin Deep Standby Cancel Flag                                  */
    } DPSIFR0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIFR1;                         /*!< Deep Standby Interrupt Flag Register 1                                */

    struct {
      __IO uint8_t   DIRQ8F     :  1;               /*!< IRQ8-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ9F     :  1;               /*!< IRQ9-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ10F    :  1;               /*!< IRQ10-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ11F    :  1;               /*!< IRQ11-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ12F    :  1;               /*!< IRQ12-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ13F    :  1;               /*!< IRQ13-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ14F    :  1;               /*!< IRQ14-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ15F    :  1;               /*!< IRQ15-DS Pin Deep Standby Cancel Flag                                 */
    } DPSIFR1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIFR2;                         /*!< Deep Standby Interrupt Flag Register 2                                */

    struct {
      __IO uint8_t   DLVD1IF    :  1;               /*!< LVD1 Deep Standby Cancel Flag                                         */
      __IO uint8_t   DLVD2IF    :  1;               /*!< LVD2 Deep Standby Cancel Flag                                         */
      __IO uint8_t   DTRTCIIF   :  1;               /*!< RTC Interval interrupt Deep Standby Cancel Flag                       */
      __IO uint8_t   DRTCAIF    :  1;               /*!< RTC Alarm interrupt Deep Standby Cancel Flag                          */
      __IO uint8_t   DNMIF      :  1;               /*!< NMI Pin Deep Standby Cancel Flag                                      */
    } DPSIFR2_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIFR3;                         /*!< Deep Standby Interrupt Flag Register 3                                */

    struct {
      __IO uint8_t   DUSBFSIF   :  1;               /*!< USBFS Suspend/Resume Deep Standby Cancel Flag                         */
      __IO uint8_t   DUSBHSIF   :  1;               /*!< USBHS Suspend/Resume Deep Standby Cancel Flag                         */
      __IO uint8_t   DAGT1IF    :  1;               /*!< AGT1 Underflow Deep Standby Cancel Flag                               */
    } DPSIFR3_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIEGR0;                        /*!< Deep Standby Interrupt Edge Register 0                                */

    struct {
      __IO uint8_t   DIRQ0EG    :  1;               /*!< IRQ0-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ1EG    :  1;               /*!< IRQ1-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ2EG    :  1;               /*!< IRQ2-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ3EG    :  1;               /*!< IRQ3-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ4EG    :  1;               /*!< IRQ4-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ5EG    :  1;               /*!< IRQ5-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ6EG    :  1;               /*!< IRQ6-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ7EG    :  1;               /*!< IRQ7-DS Pin Edge Select                                               */
    } DPSIEGR0_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIEGR1;                        /*!< Deep Standby Interrupt Edge Register 1                                */

    struct {
      __IO uint8_t   DIRQ8EG    :  1;               /*!< IRQ8-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ9EG    :  1;               /*!< IRQ9-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ10EG   :  1;               /*!< IRQ10-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ11EG   :  1;               /*!< IRQ11-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ12EG   :  1;               /*!< IRQ12-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ13EG   :  1;               /*!< IRQ13-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ14EG   :  1;               /*!< IRQ14-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ15EG   :  1;               /*!< IRQ15-DS Pin Edge Select                                              */
    } DPSIEGR1_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DPSIEGR2;                        /*!< Deep Standby Interrupt Edge Register 2                                */

    struct {
      __IO uint8_t   DLVD1IEG   :  1;               /*!< LVD1 Edge Select                                                      */
      __IO uint8_t   DLVD2IEG   :  1;               /*!< LVD2 Edge Select                                                      */
           uint8_t              :  2;
      __IO uint8_t   DNMIEG     :  1;               /*!< NMI Pin Edge Select                                                   */
    } DPSIEGR2_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED24;

  union {
    __IO uint8_t   SYOCDCR;                         /*!< System Control OCD Control Register                                */

    struct {
           uint8_t              :  7;
      __IO uint8_t   DBGEN      :  1;               /*!< Debugger Enable bit                                                   */
    } SYOCDCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED25;

  union {
    __IO uint8_t   RSTSR0;                          /*!< Reset Status Register 0                                               */

    struct {
      __IO uint8_t   PORF       :  1;               /*!< Power-On Reset Detect Flag                                            */
      __IO uint8_t   LVD0RF     :  1;               /*!< Voltage-Monitoring 0 Reset Detect Flag                                */
      __IO uint8_t   LVD1RF     :  1;               /*!< Voltage-Monitoring 1 Reset Detect Flag                                */
      __IO uint8_t   LVD2RF     :  1;               /*!< Voltage-Monitoring 2 Reset Detect Flag                                */
           uint8_t              :  3;
      __IO uint8_t   DPSRSTF    :  1;               /*!< Deep Software Standby Reset Flag                                      */
    } RSTSR0_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   RSTSR2;                          /*!< Reset Status Register 2                                               */

    struct {
      __IO uint8_t   CWSF       :  1;               /*!< Cold/Warm Start Determination Flag                                    */
    } RSTSR2_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED26;

  union {
    __IO uint8_t   MOMCR;                           /*!< Main Clock Oscillator Mode Oscillation Control Register               */

    struct {
           uint8_t              :  4;
      __IO uint8_t   MODRV0     :  2;               /*!< Main Clock Oscillator DriveCapability 0 Switching                     */
      __IO uint8_t   MOSEL      :  1;               /*!< Main Clock Oscillator Switching                                       */
    } MOMCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED27[3];

  union {
    __IO uint8_t   LVCMPCR;                         /*!< Voltage Monitoring Circuit Control Register                           */

    struct {
           uint8_t              :  5;
      __IO uint8_t   LVD1E      :  1;               /*!< Voltage Detection 1 Enable                                            */
      __IO uint8_t   LVD2E      :  1;               /*!< Voltage Detection 2 Enable                                            */
    } LVCMPCR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   LVDLVLR;                         /*!< Voltage Detection Level Select Register                               */

    struct {
      __IO uint8_t   LVD1LVL    :  5;               /*!< Voltage Detection 1 Level Select (Standard voltage during drop
                                                         in voltage)                                                           */
      __IO uint8_t   LVD2LVL    :  3;               /*!< Voltage Detection 2 Level Select (Standard voltage during drop
                                                         in voltage)                                                           */
    } LVDLVLR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED31;

  union {
    __IO uint8_t   LVDnCR0[2];                      /*!< Voltage Monitoring %s Circuit Control Register 0                      */

    struct {
      __IO uint8_t   RIE        :  1;               /*!< Voltage Monitoring Interrupt/Reset Enable                             */
      __IO uint8_t   DFDIS      :  1;               /*!< Voltage Monitoring Digital Filter Disable Mode Select                 */
      __IO uint8_t   CMPE       :  1;               /*!< Voltage Monitoring Circuit Comparison Result Output Enable            */
           uint8_t              :  1;
      __IO uint8_t   FSAMP      :  2;               /*!< Sampling Clock Select                                                 */
      __IO uint8_t   RI         :  1;               /*!< Voltage Monitoring Circuit Mode Select                                */
      __IO uint8_t   RN         :  1;               /*!< Voltage Monitoring Reset Negate Select                                */
    } LVDnCR0_b[2];                                 /*!< BitSize                                                               */
  };

  __I  uint8_t RESERVED33[25 * 4];

  union {
    __IO uint8_t   SOSCCR;                          /*!< Sub-clock oscillator control register                                 */

    struct {
      __IO uint8_t   SOSTP      :  1;               /*!< Sub-Clock Oscillator Stop                                             */
    } SOSCCR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SOMCR;                           /*!< Sub Clock Oscillator Mode Control Register                            */

    struct {
      __IO uint8_t   SODRV      :  2;               /*!< Sub Clock Oscillator Drive Capability Switching                       */
    } SOMCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED28[7 * 2];

  union {
    __IO uint8_t   LOCOCR;                          /*!< Low-Speed On-Chip Oscillator Control Register                         */

    struct {
      __IO uint8_t   LCSTP      :  1;               /*!< LOCO Stop                                                             */
    } LOCOCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED29;

  union {
    __IO uint8_t   LOCOUTCR;                        /*!< LOCO User Trimming Control Register                                   */

    struct {
      __IO uint8_t   LOCOUTRM   :  8;               /*!< LOCO User Trimming 1000_0000 : -128 1000_0001 : -127 1000_0010
                                                         : -126 . . . 1111_1111 : -1 0000_0000 : Center Code 0000_0001
                                                          : +1 . . . 0111_1101 : +125 0111_1110 : +126 0111_1111 : +127These
                                                          bits are added to original LOCO trimming bits                        */
    } LOCOUTCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED32[109];

  union {
    __IO uint8_t   VBTBKRn[512];                    /*!< VBATT Backup Register %s                                              */

    struct {
      __IO uint8_t   VBTBKR     :  8;               /*!< VBTBKR is a 512-byte readable/writeable register to store data
                                                         powered by VBATT.The value of this register is retained even
                                                          when VCC is not powered but VBATT is powered.VBTBKR is initialized
                                                          by VBATT selected voltage power-on-reset.                            */
    } VBTBKRn_b[512];                               /*!< BitSize                                                               */
  };
} R_SYSTEM_Type;


/* ================================================================================ */
/* ================                    R_IOPORT0                   ================ */
/* ================================================================================ */


/**
  * @brief Port 0 Control Registers (R_IOPORT0)
  */

typedef struct {                                    /*!< R_IOPORT0 Structure                                                   */
  __IO uint32_t  PCNTR1;                            /*!< Port Control Register 1                                               */
  __I  uint32_t  PCNTR2;                            /*!< Port Control Register 2                                               */
  __O  uint32_t  PCNTR3;                            /*!< Port Control Register 3                                               */
} R_IOPORT0_Type;


/* ================================================================================ */
/* ================                    R_IOPORT1                   ================ */
/* ================================================================================ */


/**
  * @brief Port 1 Control Registers (R_IOPORT1)
  */

typedef struct {                                    /*!< R_IOPORT1 Structure                                                   */
  __IO uint32_t  PCNTR1;                            /*!< Port Control Register 1                                               */
  __I  uint32_t  PCNTR2;                            /*!< Port Control Register 2                                               */
  __O  uint32_t  PCNTR3;                            /*!< Port Control Register 3                                               */
  __IO uint32_t  PCNTR4;                            /*!< Port Control Register 4                                               */
} R_IOPORT1_Type;


/* ================================================================================ */
/* ================                      R_PFS                     ================ */
/* ================================================================================ */


/**
  * @brief Pmn Pin Function Control Register (PmnPFS) (m = 0 to B, n=0 to 15) (R_PFS)
  */

typedef struct {                                    /*!< R_PFS Structure                                                       */

  union {
    __IO uint32_t  P000PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P000PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P001PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P001PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P002PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P002PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P003PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P003PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P004PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P004PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P005PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P005PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P006PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P006PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P007PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P007PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P008PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P008PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P009PFS;                         /*!< P00%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P009PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P010PFS;                         /*!< P0%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P010PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P011PFS;                         /*!< P0%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P011PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED24[2 * 4];                   // Added MEF 08/25/2015 P012 and P013 are not present

  union {
    __IO uint32_t  P014PFS;                         /*!< P0%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P014PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P015PFS;                         /*!< P0%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P015PFS_b;                                    /*!< BitSize                                                               */
  };
//  __I  uint32_t  RESERVED[2];                     // MEF 8/26/2015 - This is the wrong place for this

  union {
    __IO uint32_t  P100PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P100PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P101PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P101PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P102PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P102PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P103PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P103PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P104PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P104PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P105PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P105PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P106PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P106PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P107PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P107PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P108PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P108PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P109PFS;                         /*!< P10%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P109PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P110PFS;                         /*!< P1%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P110PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P111PFS;                         /*!< P1%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P111PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P112PFS;                         /*!< P1%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P112PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P113PFS;                         /*!< P1%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P113PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P114PFS;                         /*!< P1%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P114PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P115PFS;                         /*!< P1%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P115PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P200PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P200PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P201PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P201PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P202PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P202PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P203PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P203PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P204PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P204PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P205PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P205PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P206PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P206PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P207PFS;                         /*!< P20%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P207PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[4 * 4];                    // Added MEF 08/25/2015 P208, 209, 210, 211 are not present

  union {
    __IO uint32_t  P212PFS;                         /*!< P2%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P212PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P213PFS;                         /*!< P2%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P213PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[2 * 4];                    // Added MEF 09/02/2015 P214, 215 are not present

  union {
    __IO uint32_t  P300PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P300PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P301PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P301PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P302PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P302PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P303PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P303PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P304PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P304PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P305PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P305PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P306PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P306PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P307PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P307PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P308PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P308PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P309PFS;                         /*!< P30%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P309PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P310PFS;                         /*!< P3%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P310PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P311PFS;                         /*!< P3%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P311PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P312PFS;                         /*!< P3%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P312PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P313PFS;                         /*!< P3%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P313PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P314PFS;                         /*!< P3%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P314PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P315PFS;                         /*!< P3%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P315PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P400PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P400PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P401PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P401PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P402PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P402PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P403PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P403PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P404PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P404PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P405PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P405PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P406PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P406PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P407PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P407PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P408PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P408PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P409PFS;                         /*!< P40%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P409PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P410PFS;                         /*!< P4%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P410PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P411PFS;                         /*!< P4%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P411PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P412PFS;                         /*!< P4%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P412PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P413PFS;                         /*!< P4%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P413PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P414PFS;                         /*!< P4%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P414PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P415PFS;                         /*!< P4%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P415PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P500PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P500PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P501PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P501PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P502PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P502PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P503PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P503PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P504PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P504PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P505PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P505PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P506PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P506PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P507PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P507PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P508PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P508PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P509PFS;                         /*!< P50%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P509PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P510PFS;                         /*!< P5%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P510PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P511PFS;                         /*!< P5%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P511PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P512PFS;                         /*!< P5%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P512PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P513PFS;                         /*!< P5%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P513PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P514PFS;                         /*!< P5%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P514PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P515PFS;                         /*!< P5%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P515PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P600PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P600PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P601PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P601PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P602PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P602PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P603PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P603PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P604PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P604PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P605PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P605PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P606PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P606PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P607PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P607PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P608PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P608PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P609PFS;                         /*!< P60%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P609PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P610PFS;                         /*!< P6%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P610PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P611PFS;                         /*!< P6%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P611PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P612PFS;                         /*!< P6%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P612PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P613PFS;                         /*!< P6%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P613PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P614PFS;                         /*!< P6%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P614PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P615PFS;                         /*!< P6%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P615PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P700PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P700PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P701PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P701PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P702PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P702PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P703PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P703PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P704PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P704PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P705PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P705PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P706PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P706PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P707PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P707PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P708PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P708PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P709PFS;                         /*!< P70%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P709PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P710PFS;                         /*!< P7%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P710PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P711PFS;                         /*!< P7%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P711PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P712PFS;                         /*!< P7%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P712PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P713PFS;                         /*!< P7%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P713PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED3[2];

  union {
    __IO uint32_t  P800PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P800PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P801PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P801PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P802PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P802PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P803PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P803PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P804PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P804PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P805PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P805PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P806PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P806PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P807PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P807PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P808PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P808PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P809PFS;                         /*!< P80%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P809PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P810PFS;                         /*!< P8%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P810PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P811PFS;                         /*!< P8%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P811PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P812PFS;                         /*!< P8%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P812PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P813PFS;                         /*!< P8%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P813PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED4[2];

  union {
    __IO uint32_t  P900PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P900PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P901PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P901PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P902PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P902PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P903PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P903PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P904PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P904PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P905PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P905PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P906PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P906PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P907PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P907PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P908PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P908PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P909PFS;                         /*!< P90%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P909PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P910PFS;                         /*!< P9%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P910PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P911PFS;                         /*!< P9%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P911PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P912PFS;                         /*!< P9%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P912PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P913PFS;                         /*!< P9%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P913PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P914PFS;                         /*!< P9%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P914PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  P915PFS;                         /*!< P9%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P915PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA00PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA00PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA01PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA01PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA02PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA02PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA03PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA03PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA04PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA04PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA05PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA05PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA06PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA06PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA07PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA07PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA08PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA08PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA09PFS;                         /*!< PA0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA09PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA10PFS;                         /*!< PA%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA10PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA11PFS;                         /*!< PA%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA11PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA12PFS;                         /*!< PA%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA12PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA13PFS;                         /*!< PA%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA13PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA14PFS;                         /*!< PA%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA14PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PA15PFS;                         /*!< PA%s Pin Function Control Register                                    */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA15PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB00PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB00PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB01PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB01PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB02PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB02PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB03PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB03PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB04PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB04PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB05PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB05PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB06PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB06PFS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  PB07PFS;                         /*!< PB0%s Pin Function Control Register                                   */

    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB07PFS_b;                                    /*!< BitSize                                                               */
  };
} R_PFS_Type;


/* ================================================================================ */
/* ================                     R_PMISC                    ================ */
/* ================================================================================ */


/**
  * @brief Miscellaneous Port Control Register (R_PMISC)
  */

typedef struct {                                    /*!< R_PMISC Structure                                                     */

  union {
    __IO uint8_t   PFENET;                          /*!< Ethernet Control Register                                             */

    struct {
           uint8_t              :  4;
      __IO uint8_t   PHYMODE0   :  1;               /*!< Ethernet Mode Setting ch0                                             */
      __IO uint8_t   PHYMODE1   :  1;               /*!< Ethernet Mode Setting ch1                                             */
    } PFENET_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[2];

  union {
    __IO uint8_t   PWPR;                            /*!< Write-Protect Register                                                */

    struct {
           uint8_t              :  6;
      __IO uint8_t   PFSWE      :  1;               /*!< PFS Register Write Enable                                             */
      __IO uint8_t   BOWI       :  1;               /*!< PFSWE Bit Write Disable                                               */
    } PWPR_b;                                       /*!< BitSize                                                               */
  };
} R_PMISC_Type;


/* ================================================================================ */
/* ================                      R_ELC                     ================ */
/* ================================================================================ */


/**
  * @brief Event Link Controller  (R_ELC)
  */

typedef struct {                                    /*!< R_ELC Structure                                                       */
    union {
      __IO uint8_t   ELCR;                          /*!< Event Link Controller Register                                        */

      struct {
             uint8_t            :  7;
        __IO uint8_t   ELCON    :  1;               /*!< All Event Link Enable                                                 */
      } ELCR_b;                                     /*!< BitSize                                                               */
    };
  union {
    __I  uint16_t  RESERVED;
    R_ELC_ELSEGRnRC0_Type ELSEGRnRC0[2];            /*!< Event Link Software Event Generation Register %s Register Cluster
                                                        0                                                                     */
  };
  __I  uint16_t  RESERVED1[5];
  R_ELC_ELSRnRC0_Type ELSRnRC0[19];                 /*!< Event Link Setting Register %s Register Cluster 0                     */
} R_ELC_Type;


/* ================================================================================ */
/* ================                     R_POEG                     ================ */
/* ================================================================================ */


/**
  * @brief Port Output Enable Module for GPT (R_POEG)
  */

typedef struct {                                    /*!< R_POEG Structure                                                      */

  union {
    __IO uint32_t  POEGGA;                          /*!< POEG Group %s Setting Register                                        */

    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGA_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED[63];

  union {
    __IO uint32_t  POEGGB;                          /*!< POEG Group %s Setting Register                                        */

    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGB_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED1[63];

  union {
    __IO uint32_t  POEGGC;                          /*!< POEG Group %s Setting Register                                        */

    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGC_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED2[63];

  union {
    __IO uint32_t  POEGGD;                          /*!< POEG Group %s Setting Register                                        */

    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGD_b;                                     /*!< BitSize                                                               */
  };
} R_POEG_Type;


/* ================================================================================ */
/* ================                      R_RTC                     ================ */
/* ================================================================================ */


/**
  * @brief Realtime Clock (R_RTC)
  */

typedef struct {                                    /*!< R_RTC Structure                                                       */

  union {
    __I  uint8_t   R64CNT;                          /*!< 64-Hz Counter                                                         */

    struct {
      __I  uint8_t   F64HZ      :  1;               /*!< 64Hz                                                                  */
      __I  uint8_t   F32HZ      :  1;               /*!< 32Hz                                                                  */
      __I  uint8_t   F16HZ      :  1;               /*!< 16Hz                                                                  */
      __I  uint8_t   F8HZ       :  1;               /*!< 8Hz                                                                   */
      __I  uint8_t   F4HZ       :  1;               /*!< 4Hz                                                                   */
      __I  uint8_t   F2HZ       :  1;               /*!< 2Hz                                                                   */
      __I  uint8_t   F1HZ       :  1;               /*!< 1Hz                                                                   */
    } R64CNT_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;

  union {
    union {
      __IO uint8_t   BCNT0;                         /*!< Binary Counter 0                                                      */

      struct {
        __IO uint8_t   BCNT0    :  8;               /*!< The BCNT0 counter is a readable/writeable 32-bit binary counter
                                                         b7 to b0.                                                             */
      } BCNT0_b;                                    /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RSECCNT;                       /*!< Second Counter                                                        */

      struct {
        __IO uint8_t   SEC1     :  4;               /*!< 1-Second CountCounts from 0 to 9 every second. When a carry
                                                         is generated, 1 is added to the tens place.                           */
        __IO uint8_t   SEC10    :  3;               /*!< 10-Second CountCounts from 0 to 5 for 60-second counting.             */
      } RSECCNT_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED1;

  union {
    union {
      __IO uint8_t   BCNT1;                         /*!< Binary Counter 1                                                      */

      struct {
        __IO uint8_t   BCNT1    :  8;               /*!< The BCNT1 counter is a readable/writeable 32-bit binary counter
                                                         b15 to b8.                                                            */
      } BCNT1_b;                                    /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RMINCNT;                       /*!< Minute Counter                                                        */

      struct {
        __IO uint8_t   MIN1     :  4;               /*!< 1-Minute CountCounts from 0 to 9 every minute. When a carry
                                                         is generated, 1 is added to the tens place.                           */
        __IO uint8_t   MIN10    :  3;               /*!< 10-Minute CountCounts from 0 to 5 for 60-minute counting.             */
      } RMINCNT_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED2;

  union {
    union {
      __IO uint8_t   BCNT2;                         /*!< Binary Counter 2                                                      */

      struct {
        __IO uint8_t   BCNT2    :  8;               /*!< The BCNT2 counter is a readable/writeable 32-bit binary counter
                                                         b23 to b16.                                                           */
      } BCNT2_b;                                    /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RHRCNT;                        /*!< Hour Counter                                                          */

      struct {
        __IO uint8_t   HR1      :  4;               /*!< 1-Hour CountCounts from 0 to 9 once per hour. When a carry is
                                                         generated, 1 is added to the tens place.                              */
        __IO uint8_t   HR10     :  2;               /*!< 10-Hour CountCounts from 0 to 2 once per carry from the ones
                                                         place.                                                                */
        __IO uint8_t   PM       :  1;               /*!< Time Counter Setting for a.m./p.m.                                    */
      } RHRCNT_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED3;

  union {
    union {
      __IO uint8_t   BCNT3;                         /*!< Binary Counter 3                                                      */

      struct {
        __IO uint8_t   BCNT3    :  8;               /*!< The BCNT3 counter is a readable/writeable 32-bit binary counter
                                                         b31 to b24.                                                           */
      } BCNT3_b;                                    /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RWKCNT;                        /*!< Day-of-Week Counter                                                   */

      struct {
        __IO uint8_t   DAYW     :  3;               /*!< Day-of-Week Counting                                                  */
      } RWKCNT_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED4;

  union {
    __IO uint8_t   RDAYCNT;                         /*!< Date Counter                                                          */

    struct {
      __IO uint8_t   DATE1      :  4;               /*!< 1-Day CountCounts from 0 to 9 once per day. When a carry is
                                                         generated, 1 is added to the tens place.                              */
      __IO uint8_t   DATE10     :  2;               /*!< 10-Day CountCounts from 0 to 3 once per carry from the ones
                                                         place.                                                                */
    } RDAYCNT_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED5;

  union {
    __IO uint8_t   RMONCNT;                         /*!< Month Counter                                                         */

    struct {
      __IO uint8_t   MON1       :  4;               /*!< 1-Month CountCounts from 0 to 9 once per month. When a carry
                                                         is generated, 1 is added to the tens place.                           */
      __IO uint8_t   MON10      :  1;               /*!< 10-Month CountCounts from 0 to 1 once per carry from the ones
                                                         place.                                                                */
    } RMONCNT_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED6;

  union {
    __IO uint16_t  RYRCNT;                          /*!< Year Counter                                                          */

    struct {
      __IO uint16_t  YR1        :  4;               /*!< 1-Year CountCounts from 0 to 9 once per year. When a carry is
                                                         generated, 1 is added to the tens place.                              */
      __IO uint16_t  YR10       :  4;               /*!< 10-Year CountCounts from 0 to 9 once per carry from ones place.
                                                         When a carry is generated in the tens place, 1 is added to the
                                                          hundreds place.                                                      */
    } RYRCNT_b;                                     /*!< BitSize                                                               */
  };

  union {
    union {
      __IO uint8_t   BCNT0AR;                       /*!< Binary Counter 0 Alarm Register                                       */

      struct {
        __IO uint8_t   BCNT0AR  :  8;               /*!< he BCNT0AR counter is a readable/writeable alarm register corresponding
                                                         to 32-bit binary counter b7 to b0.                                    */
      } BCNT0AR_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RSECAR;                        /*!< Second Alarm Register                                                 */

      struct {
        __O  uint8_t   SEC1     :  4;               /*!< 1-SecondValue for the ones place of seconds                           */
        __IO uint8_t   SEC10    :  3;               /*!< 10-SecondsValue for the tens place of seconds                         */
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RSECAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED7;

  union {
    union {
      __IO uint8_t   BCNT1AR;                       /*!< Binary Counter 1 Alarm Register                                       */

      struct {
        __IO uint8_t   BCNT1AR  :  8;               /*!< he BCNT1AR counter is a readable/writeable alarm register corresponding
                                                         to 32-bit binary counter b15 to b8.                                   */
      } BCNT1AR_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RMINAR;                        /*!< Minute Alarm Register                                                 */

      struct {
        __IO uint8_t   MIN1     :  4;               /*!< 1-Minute CountValue for the ones place of minutes                     */
        __IO uint8_t   MIN10    :  3;               /*!< 10-Minute CountValue for the tens place of minutes                    */
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RMINAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED8;

  union {
    union {
      __IO uint8_t   BCNT2AR;                       /*!< Binary Counter 2 Alarm Register                                       */

      struct {
        __IO uint8_t   BCNT2AR  :  8;               /*!< The BCNT2AR counter is a readable/writeable 32-bit binary counter
                                                         b23 to b16.                                                           */
      } BCNT2AR_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RHRAR;                         /*!< Hour Alarm Register                                                   */

      struct {
        __IO uint8_t   HR1      :  4;               /*!< 1-Hour CountValue for the ones place of hours                         */
        __IO uint8_t   HR10     :  2;               /*!< 10-Hour CountValue for the tens place of hours                        */
        __IO uint8_t   PM       :  1;               /*!< Time Counter Setting for a.m./p.m.                                    */
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RHRAR_b;                                    /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED9;

  union {
    union {
      __IO uint8_t   BCNT3AR;                       /*!< Binary Counter 3 Alarm Register                                       */

      struct {
        __IO uint8_t   BCNT3AR  :  8;               /*!< The BCNT3AR counter is a readable/writeable 32-bit binary counter
                                                         b31 to b24.                                                           */
      } BCNT3AR_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RWKAR;                         /*!< Day-of-Week Alarm Register                                            */

      struct {
        __IO uint8_t   DAYW     :  3;               /*!< Day-of-Week Counting                                                  */
             uint8_t            :  4;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RWKAR_b;                                    /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED10;

  union {
    union {
      __IO uint8_t   BCNT0AER;                      /*!< Binary Counter 0 Alarm Enable Register                                */

      struct {
        __IO uint8_t   ENB      :  8;               /*!< The BCNT0AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b7 to
                                                          b0.                                                                  */
      } BCNT0AER_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RDAYAR;                        /*!< Date Alarm Register                                                   */

      struct {
        __IO uint8_t   DATE1    :  4;               /*!< 1 DayValue for the ones place of days                                 */
        __IO uint8_t   DATE10   :  2;               /*!< 10 DaysValue for the tens place of days                               */
             uint8_t            :  1;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RDAYAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED11;

  union {
    union {
      __IO uint8_t   BCNT1AER;                      /*!< Binary Counter 1 Alarm Enable Register                                */

      struct {
        __IO uint8_t   ENB      :  8;               /*!< The BCNT1AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b15
                                                          to b8.                                                               */
      } BCNT1AER_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RMONAR;                        /*!< Month Alarm Register                                                  */

      struct {
        __IO uint8_t   MON1     :  4;               /*!< 1 MonthValue for the ones place of months                             */
        __IO uint8_t   MON10    :  1;               /*!< 10 MonthsValue for the tens place of months                           */
             uint8_t            :  2;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RMONAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED12;

  union {
    union {
      __IO uint16_t  BCNT2AER;                      /*!< Binary Counter 2 Alarm Enable Register                                */

      struct {
        __IO uint16_t  ENB      :  8;               /*!< The BCNT2AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b23
                                                          to b16.                                                              */
      } BCNT2AER_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint16_t  RYRAR;                         /*!< Year Alarm Register                                                   */

      struct {
        __IO uint16_t  YR1      :  4;               /*!< 1 YearValue for the ones place of years                               */
        __IO uint16_t  YR10     :  4;               /*!< 10 YearsValue for the tens place of years                             */
      } RYRAR_b;                                    /*!< BitSize                                                               */
    };
  };

  union {
    union {
      __IO uint8_t   BCNT3AER;                      /*!< Binary Counter 3 Alarm Enable Register                                */

      struct {
        __IO uint8_t   ENB      :  8;               /*!< The BCNT3AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b31
                                                          to b24.                                                              */
      } BCNT3AER_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   RYRAREN;                       /*!< Year Alarm Enable Register                                            */

      struct {
             uint8_t            :  7;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RYRAREN_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED13[3];

  union {
    __IO uint8_t   RCR1;                            /*!< RTC Control Register 1                                                */

    struct {
      __IO uint8_t   AIE        :  1;               /*!< Alarm Interrupt Enable                                                */
      __IO uint8_t   CIE        :  1;               /*!< Carry Interrupt Enable                                                */
      __IO uint8_t   PIE        :  1;               /*!< Periodic Interrupt Enable                                             */
      __IO uint8_t   RTCOS      :  1;               /*!< RTCOUT Output Select                                                  */
      __IO uint8_t   PES        :  4;               /*!< Periodic Interrupt Select                                             */
    } RCR1_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED14;

  union {
    __IO uint8_t   RCR2;                            /*!< RTC Control Register 2                                                */

    struct {
      __IO uint8_t   START      :  1;               /*!< Start                                                                 */
      __IO uint8_t   RESET      :  1;               /*!< RTC Software Reset                                                    */
      __IO uint8_t   ADJ30      :  1;               /*!< 30-Second Adjustment                                                  */
      __IO uint8_t   RTCOE      :  1;               /*!< RTCOUT Output Enable                                                  */
      __IO uint8_t   AADJE      :  1;               /*!< Automatic Adjustment Enable (When the LOCO clock is selected,
                                                         the setting of this bit is disabled.)                                 */
      __IO uint8_t   AADJP      :  1;               /*!< Automatic Adjustment Period Select (When the LOCO clock is selected,
                                                         the setting of this bit is disabled.)                                 */
      __IO uint8_t   HR24       :  1;               /*!< Hours Mode                                                            */
      __IO uint8_t   CNTMD      :  1;               /*!< Count Mode Select                                                     */
    } RCR2_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED15[3];

  union {
    __IO uint8_t   RCR4;                            /*!< RTC Control Register 4                                                */

    struct {
      __IO uint8_t   RCKSEL     :  1;               /*!< Count Source Select                                                   */
    } RCR4_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED16;

  union {
    __IO uint16_t  RFRH;                            /*!< Frequency Register H                                                  */

    struct {
      __IO uint16_t  RFC16      :  1;               /*!< Frequency Comparison Value (b16)To generate the operating clock
                                                         from the LOCOclock, this bit sets the comparison value of the
                                                          128-Hz clock cycle.                                                  */
    } RFRH_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  RFRL;                            /*!< Frequency Register L                                                  */

    struct {
      __IO uint16_t  RFC        : 16;               /*!< Frequency Comparison Value(b15-b0)To generate the operating
                                                         clock from the main clock, this bit sets the comparison value
                                                          of the 128-Hz clock cycle.                                           */
    } RFRL_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   RADJ;                            /*!< Time Error Adjustment Register                                        */

    struct {
      __IO uint8_t   ADJ        :  6;               /*!< Adjustment ValueThese bits specify the adjustment value from
                                                         the prescaler.                                                        */
      __IO uint8_t   PMADJ      :  2;               /*!< Plus-Minus                                                            */
    } RADJ_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED17[17];
  R_RTC_RTCCRnRC0_Type RTCCRnRC0[3];                /*!< Time Capture Control Register %s Register Cluster 0                   */
  __I  uint8_t RESERVED18[3 * 4];
  R_RTC_CnRC0_Type CnRC0[3];                        /*!< Capture %s Register Cluster 0                                         */
} R_RTC_Type;


/* ================================================================================ */
/* ================                      R_WDT                     ================ */
/* ================================================================================ */


/**
  * @brief Watchdog Timer  (R_WDT)
  */

typedef struct {                                    /*!< R_WDT Structure                                                       */

  union {
    __IO uint8_t   WDTRR;                           /*!< WDT Refresh Register                                                  */

    struct {
      __IO uint8_t   WDTRR      :  8;               /*!< WDTRR is an 8-bit register that refreshes the down-counter of
                                                         the WDT.                                                              */
    } WDTRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;

  union {
    __IO uint16_t  WDTCR;                           /*!< WDT Control Register                                                  */

    struct {
      __IO uint16_t  TOPS       :  2;               /*!< Timeout Period Selection                                              */
           uint16_t             :  2;
      __IO uint16_t  CKS        :  4;               /*!< Clock Division Ratio Selection                                        */
      __IO uint16_t  RPES       :  2;               /*!< Window End Position Selection                                         */
           uint16_t             :  2;
      __IO uint16_t  RPSS       :  2;               /*!< Window Start Position Selection                                       */
    } WDTCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  WDTSR;                           /*!< WDT Status Register                                                   */

    struct {
      __I  uint16_t  CNTVAL     : 14;               /*!< Down-Counter ValueValue counted by the down-counter                   */
      __IO uint16_t  UNDFF      :  1;               /*!< Underflow Flag                                                        */
      __IO uint16_t  REFEF      :  1;               /*!< Refresh Error Flag                                                    */
    } WDTSR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   WDTRCR;                          /*!< WDT Reset Control Register                                            */

    struct {
           uint8_t              :  7;
      __IO uint8_t   RSTIRQS    :  1;               /*!< Reset Interrupt Request Selection                                     */
    } WDTRCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1;

  union {
    __IO uint8_t   WDTCSTPR;                        /*!< WDT Count Stop Control Register                                       */

    struct {
           uint8_t              :  7;
      __IO uint8_t   SLCSTP     :  1;               /*!< Sleep-Mode Count Stop Control                                         */
    } WDTCSTPR_b;                                   /*!< BitSize                                                               */
  };
} R_WDT_Type;


/* ================================================================================ */
/* ================                     R_IWDT                     ================ */
/* ================================================================================ */


/**
  * @brief Independent Watchdog Timer (R_IWDT)
  */

typedef struct {                                    /*!< R_IWDT Structure                                                      */

  union {
    __IO uint8_t   IWDTRR;                          /*!< IWDT Refresh Register                                                 */

    struct {
      __IO uint8_t   IWDTRR     :  8;               /*!< The counter is refreshed by writing 0x00 and then writing 0xFF
                                                         to this register.                                                     */
    } IWDTRR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED[3];

  union {
    __IO uint16_t  IWDTSR;                          /*!< IWDT Status Register                                                  */

    struct {
      __I  uint16_t  CNTVAL     : 14;               /*!< Counter ValueValue counted by the counter                             */
      __IO uint16_t  UNDFF      :  1;               /*!< Underflow Flag                                                        */
      __IO uint16_t  REFEF      :  1;               /*!< Refresh Error Flag                                                    */
    } IWDTSR_b;                                     /*!< BitSize                                                               */
  };
} R_IWDT_Type;


/* ================================================================================ */
/* ================                      R_CAC                     ================ */
/* ================================================================================ */


/**
  * @brief Clock Frequency Accuracy Measurement Circuit  (R_CAC)
  */

typedef struct {                                    /*!< R_CAC Structure                                                       */

  union {
    __IO uint8_t   CACR0;                           /*!< CAC Control Register 0                                                */

    struct {
      __IO uint8_t   CFME       :  1;               /*!< Clock Frequency Measurement Enable.                                   */
    } CACR0_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CACR1;                           /*!< CAC Control Register 1                                                */

    struct {
      __IO uint8_t   CACREFE    :  1;               /*!< CACREF Pin Input Enable                                               */
      __IO uint8_t   FMCS       :  3;               /*!< Frequency Measurement Output Clock Select                             */
      __IO uint8_t   TCSS       :  2;               /*!< Timer Count Clock Source Select                                       */
      __IO uint8_t   EDGES      :  2;               /*!< Valid Edge Select                                                     */
    } CACR1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CACR2;                           /*!< CAC Control Register 2                                                */

    struct {
      __IO uint8_t   RPS        :  1;               /*!< Reference Signal Select                                               */
      __IO uint8_t   RSCS       :  3;               /*!< Reference Signal Generation Output Clock Select                       */
      __IO uint8_t   RCDS       :  2;               /*!< Reference Signal Generation Clock Frequency Division Ratio Select
                                                                                                                               */
      __IO uint8_t   DFS        :  2;               /*!< Digital Filter Selection                                              */
    } CACR2_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CAICR;                           /*!< CAC Interrupt Control Register                                        */

    struct {
      __IO uint8_t   FERRIE     :  1;               /*!< Frequency Error Interrupt Enable                                      */
      __IO uint8_t   MENDIE     :  1;               /*!< Measurement End Interrupt Enable                                      */
      __IO uint8_t   OVFIE      :  1;               /*!< Overflow Interrupt Enable                                             */
           uint8_t              :  1;
      __O  uint8_t   FERRFCL    :  1;               /*!< FERRF Clear                                                           */
      __O  uint8_t   MENDFCL    :  1;               /*!< MENDF Clear                                                           */
      __O  uint8_t   OVFFCL     :  1;               /*!< OVFF Clear                                                            */
    } CAICR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CASTR;                           /*!< CAC Status Register                                                   */

    struct {
      __I  uint8_t   FERRF      :  1;               /*!< Frequency Error Flag                                                  */
      __I  uint8_t   MENDF      :  1;               /*!< Measurement End Flag                                                  */
      __I  uint8_t   OVFF       :  1;               /*!< Counter Overflow Flag                                                 */
    } CASTR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;

  union {
    __IO uint16_t  CAULVR;                          /*!< CAC Upper-Limit Value Setting Register                                */

    struct {
      __IO uint16_t  CAULVR     : 16;               /*!< CAULVR is a 16-bit readable/writeable register that stores the
                                                         upper-limit value of the frequency.                                   */
    } CAULVR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CALLVR;                          /*!< CAC Lower-Limit Value Setting Register                                */

    struct {
      __IO uint16_t  CALLVR     : 16;               /*!< CALLVR is a 16-bit readable/writeable register that stores the
                                                         lower-limit value of the frequency.                                   */
    } CALLVR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  CACNTBR;                         /*!< CAC Counter Buffer Register                                           */

    struct {
      __I  uint16_t  CACNTBR    : 16;               /*!< CACNTBR is a 16-bit read-only register that retains the counter
                                                         value at the time a valid reference signal edge is input              */
    } CACNTBR_b;                                    /*!< BitSize                                                               */
  };
} R_CAC_Type;


/* ================================================================================ */
/* ================                     R_MSTP                     ================ */
/* ================================================================================ */


/**
  * @brief Module Stop Control B,C,D (R_MSTP)
  */

typedef struct {                                    /*!< R_MSTP Structure                                                      */

  union {
    __IO uint32_t  MSTPCRB;                         /*!< Module Stop Control Register B                                        */

    struct {
           uint32_t             :  1;
      __IO uint32_t  MSTPB1     :  1;               /*!< RCAN1 Module Stop                                                     */
      __IO uint32_t  MSTPB2     :  1;               /*!< RCAN0 Module Stop                                                     */
           uint32_t             :  2;
      __IO uint32_t  MSTPB5     :  1;               /*!< IrDA Module Stop                                                      */
      __IO uint32_t  MSTPB6     :  1;               /*!< Queued Serial Peripheral Interface Module Stop                        */
      __IO uint32_t  MSTPB7     :  1;               /*!< I2C Bus Interface 2 Module Stop                                       */
      __IO uint32_t  MSTPB8     :  1;               /*!< I2C Bus Interface 1 Module Stop                                       */
      __IO uint32_t  MSTPB9     :  1;               /*!< I2C Bus Interface 0 Module Stop                                       */
           uint32_t             :  1;
      __IO uint32_t  MSTPB11    :  1;               /*!< Universal Serial Bus 2.0 FS Interface Module Stop                     */
      __IO uint32_t  MSTPB12    :  1;               /*!< Universal Serial Bus 2.0 HS Interface Module Stop                     */
      __IO uint32_t  MSTPB13    :  1;               /*!< EPTPC and PTPEDMAC Module Stop                                        */
      __IO uint32_t  MSTPB14    :  1;               /*!< ETHERC1 and EDMAC1 Module Stop                                        */
      __IO uint32_t  MSTPB15    :  1;               /*!< ETHERC0 and EDMAC0 Module Stop                                        */
           uint32_t             :  2;
      __IO uint32_t  MSTPB18    :  1;               /*!< Serial Peripheral Interface Module Stop                               */
      __IO uint32_t  MSTPB19    :  1;               /*!< Serial Peripheral Interface 0 Module Stop                             */
           uint32_t             :  2;
      __IO uint32_t  MSTPB22    :  1;               /*!< Serial Communication Interface 9 Module Stop                          */
      __IO uint32_t  MSTPB23    :  1;               /*!< Serial Communication Interface 8 Module Stop                          */
      __IO uint32_t  MSTPB24    :  1;               /*!< Serial Communication Interface 7 Module Stop                          */
      __IO uint32_t  MSTPB25    :  1;               /*!< Serial Communication Interface 6 Module Stop                          */
      __IO uint32_t  MSTPB26    :  1;               /*!< Serial Communication Interface 5 Module Stop                          */
      __IO uint32_t  MSTPB27    :  1;               /*!< Serial Communication Interface 4 Module Stop                          */
      __IO uint32_t  MSTPB28    :  1;               /*!< Serial Communication Interface 3 Module Stop                          */
      __IO uint32_t  MSTPB29    :  1;               /*!< Serial Communication Interface 2 Module Stop                          */
      __IO uint32_t  MSTPB30    :  1;               /*!< Serial Communication Interface 1 Module Stop                          */
      __IO uint32_t  MSTPB31    :  1;               /*!< Serial Communication Interface 0 Module Stop                          */
    } MSTPCRB_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MSTPCRC;                         /*!< Module Stop Control Register C                                        */

    struct {
      __IO uint32_t  MSTPC0     :  1;               /*!< CAC Module Stop                                                       */
      __IO uint32_t  MSTPC1     :  1;               /*!< CRC Calculator Module Stop                                            */
      __IO uint32_t  MSTPC2     :  1;               /*!< Parallel Data Capture Module Stop                                     */
      __IO uint32_t  MSTPC3     :  1;               /*!< Capacitive Touch Sensing Unit Module Stop                             */
      __IO uint32_t  MSTPC4     :  1;               /*!< Graphic LCD Controller Module Stop                                    */
      __IO uint32_t  MSTPC5     :  1;               /*!< JPEG codec engine Module Stop                                         */
      __IO uint32_t  MSTPC6     :  1;               /*!< 2DG engine Module Stop                                                */
      __IO uint32_t  MSTPC7     :  1;               /*!< Synchronous Serial Interface 1 Module Stop                            */
      __IO uint32_t  MSTPC8     :  1;               /*!< Synchronous Serial Interface 0 Module Stop                            */
      __IO uint32_t  MSTPC9     :  1;               /*!< Sampling Rate Converter Module Stop                                   */
           uint32_t             :  1;
      __IO uint32_t  MSTPC11    :  1;               /*!< Synchronous Digital Hierarchy/ Multi Media Card 1 Module Stop         */
      __IO uint32_t  MSTPC12    :  1;               /*!< Synchronous Digital Hierarchy/ Multi Media Card 0 Module Stop         */
      __IO uint32_t  MSTPC13    :  1;               /*!< Data Operation Circuit Module Stop                                    */
      __IO uint32_t  MSTPC14    :  1;               /*!< Event Link Controller Module Stop                                     */
           uint32_t             : 13;
      __IO uint32_t  MSTPC28    :  1;               /*!< TRNG Module Stop                                                      */
           uint32_t             :  2;
      __IO uint32_t  MSTPC31    :  1;               /*!< TSIP Module Stop                                                      */
    } MSTPCRC_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MSTPCRD;                         /*!< Module Stop Control Register D                                        */

    struct {
           uint32_t             :  2;
      __IO uint32_t  MSTPD2     :  1;               /*!< AGT1 Module StopNote: AGT1 is in the module stop state when
                                                         the count source is either of PCLKB, PCLKB/2 or PCLKB/8. In
                                                          case the count source is sub-clock or LOCO, this bit should
                                                          be set to 1 except when accessing the registers of AGT1.             */
      __IO uint32_t  MSTPD3     :  1;               /*!< AGT0 Module StopNote: AGT0 is in the module stop state when
                                                         the count source is either of PCLKB, PCLKB/2 or PCLKB/8. In
                                                          case the count source is sub-clock or LOCO, this bit should
                                                          be set to 1 except when accessing the registers of AGT0.             */
           uint32_t             :  1;
      __IO uint32_t  MSTPD5     :  1;               /*!< GPT ch7-ch0 Module Stop                                               */
      __IO uint32_t  MSTPD6     :  1;               /*!< GPT ch13-ch8 Module Stop                                              */
           uint32_t             :  7;
      __IO uint32_t  MSTPD14    :  1;               /*!< PGI Module Stop                                                       */
      __IO uint32_t  MSTPD15    :  1;               /*!< 12-bit A/D Converter 1 Module Stop                                    */
      __IO uint32_t  MSTPD16    :  1;               /*!< 12-bit A/D Converter 0 Module Stop                                    */
           uint32_t             :  3;
      __IO uint32_t  MSTPD20    :  1;               /*!< D/A Converter 0 Module Stop                                           */
           uint32_t             :  1;
      __IO uint32_t  MSTPD22    :  1;               /*!< Temperature Sensor Module Stop                                        */
      __IO uint32_t  MSTPD23    :  1;               /*!< Comparator-OC5 Module Stop                                            */
      __IO uint32_t  MSTPD24    :  1;               /*!< Comparator-OC4 Module Stop                                            */
      __IO uint32_t  MSTPD25    :  1;               /*!< Comparator-OC3 Module Stop                                            */
      __IO uint32_t  MSTPD26    :  1;               /*!< Comparator-OC2 Module Stop                                            */
      __IO uint32_t  MSTPD27    :  1;               /*!< Comparator-OC1 Module Stop                                            */
      __IO uint32_t  MSTPD28    :  1;               /*!< Comparator-OC0 Module Stop                                            */
    } MSTPCRD_b;                                    /*!< BitSize                                                               */
  };
} R_MSTP_Type;

/* ================================================================================ */
/* ================                     R_SSI0                     ================ */
/* ================================================================================ */


/**
  * @brief Serial Sound Interface 0 (R_SSI0)
  */

typedef struct {                                    /*!< R_SSI0 Structure                                                      */

  union {
    __IO uint32_t  SSICR;                           /*!< Control Register                                                      */

    struct {
      __IO uint32_t  REN        :  1;               /*!< Receive Enable                                                        */
      __IO uint32_t  TEN        :  1;               /*!< Transmit Enable                                                       */
           uint32_t             :  1;
      __IO uint32_t  MUEN       :  1;               /*!< Mute EnableNOTE: When this module is muted, the value of outputting
                                                         serial data is rewritten to 0 but data transmission is not stopped.
                                                          Write dummy data to the SSIFTDR not to generate a transmit underflow
                                                          because the number of data in the transmit FIFO is decreasing.       */
      __IO uint32_t  CKDV       :  4;               /*!< Serial Oversampling Clock Division Ratio                              */
      __IO uint32_t  DEL        :  1;               /*!< Serial Data Delay                                                     */
      __IO uint32_t  PDTA       :  1;               /*!< Parallel Data Alignment                                               */
      __IO uint32_t  SDTA       :  1;               /*!< Serial Data Alignment                                                 */
      __IO uint32_t  SPDP       :  1;               /*!< Serial Padding Polarity                                               */
      __IO uint32_t  SWSP       :  1;               /*!< Serial WS Polarity                                                    */
      __IO uint32_t  SCKP       :  1;               /*!< Serial Bit Clock Polarity                                             */
      __IO uint32_t  SWSD       :  1;               /*!< Serial WS DirectionNOTE: Only the following settings are allowed:
                                                         (SCKD, SWSD) = (0, 0) and (1, 1). Other settings are prohibited.      */
      __IO uint32_t  SCKD       :  1;               /*!< Serial Bit Clock DirectionNOTE: Only the following settings
                                                         are allowed: (SCKD, SWSD) = (0, 0) and (1, 1). Other settings
                                                          are prohibited.                                                      */
      __IO uint32_t  SWL        :  3;               /*!< System Word LengthSet the system word length to the bit clock
                                                         frequency/2 fs.                                                       */
      __IO uint32_t  DWL        :  3;               /*!< Data Word Length                                                      */
      __IO uint32_t  CHNL       :  2;               /*!< Channels                                                              */
           uint32_t             :  1;
      __IO uint32_t  IIEN       :  1;               /*!< Idle Mode Interrupt Enable                                            */
      __IO uint32_t  ROIEN      :  1;               /*!< Receive Overflow Interrupt Enable                                     */
      __IO uint32_t  RUIEN      :  1;               /*!< Receive Underflow Interrupt Enable                                    */
      __IO uint32_t  TOIEN      :  1;               /*!< Transmit Overflow Interrupt Enable                                    */
      __IO uint32_t  TUIEN      :  1;               /*!< Transmit Underflow Interrupt Enable                                   */
      __IO uint32_t  CKS        :  1;               /*!< Oversampling Clock Select                                             */
    } SSICR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  SSISR;                           /*!< Status Register                                                       */

    struct {
      __I  uint32_t  IDST       :  1;               /*!< Idle Mode Status Flag                                                 */
      __I  uint32_t  RSWNO      :  1;               /*!< Receive Serial Word Number                                            */
      __I  uint32_t  RCHNO      :  2;               /*!< Receive Channel Number.These bits are read as 00b.                    */
      __I  uint32_t  TSWNO      :  1;               /*!< Transmit Serial Word Number                                           */
      __I  uint32_t  TCHNO      :  2;               /*!< Transmit Channel Number                                               */
           uint32_t             : 18;
      __I  uint32_t  IIRQ       :  1;               /*!< Idle Mode Interrupt Status Flag                                       */
      __IO uint32_t  ROIRQ      :  1;               /*!< Receive Overflow Error Interrupt Status FlagNOTE: This bit can
                                                         be set to 0 by writing 0 after reading it as 1.                       */
      __IO uint32_t  RUIRQ      :  1;               /*!< Receive Underflow Error Interrupt Status FlagNOTE: This bit
                                                         can be set to 0 by writing 0 after reading it as 1.                   */
      __IO uint32_t  TOIRQ      :  1;               /*!< Transmit Overflow Error Interrupt Status FlagNOTE: This bit
                                                         can be set to 0 by writing 0 after reading it as 1.                   */
      __IO uint32_t  TUIRQ      :  1;               /*!< Transmit Underflow Error Interrupt Status FlagNOTE: This bit
                                                         can be set to 0 by writing 0 after reading it as 1.                   */
    } SSISR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED[2];

  union {
    __IO uint32_t  SSIFCR;                          /*!< FIFO Control Register                                                 */

    struct {
      __IO uint32_t  RFRST      :  1;               /*!< Receive FIFO Data Register Reset                                      */
      __IO uint32_t  TFRST      :  1;               /*!< Transmit FIFO Data Register Reset                                     */
      __IO uint32_t  RIE        :  1;               /*!< Receive Interrupt EnableNOTE: RXI can be cleared by clearing
                                                         either the RDF flag (see the description of the RDF bit for
                                                          details) or RIE bit.                                                 */
      __IO uint32_t  TIE        :  1;               /*!< Transmit Interrupt EnableNOTE: TXI can be cleared by clearing
                                                         either the TDE flag (see the description of the TDE bit for
                                                          details) or TIE bit.                                                 */
      __IO uint32_t  RTRG       :  2;               /*!< Receive Data Trigger Number                                           */
      __IO uint32_t  TTRG       :  2;               /*!< Transmit Data Trigger NumberNOTE: The values in parenthesis
                                                         are the number of empty stages in SSIFTDR at which the TDE flag
                                                          is set.                                                              */
           uint32_t             :  8;
      __IO uint32_t  SSIRST     :  1;               /*!< SSI soft ware reset                                                   */
           uint32_t             : 14;
      __IO uint32_t  AUCKE      :  1;               /*!< Oversampling Clock Enable                                             */
    } SSIFCR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  SSIFSR;                          /*!< FIFO Status Register                                                  */

    struct {
      __IO uint32_t  RDF        :  1;               /*!< Receive Data Full FlagNOTE: Since the SSIFRDR register is a
                                                         32-byte FIFO register, the maximum number of data bytes that
                                                          can be read from it while the RDF flag is 1 is indicated in
                                                          the RDC[3:0] flags. If reading data from the SSIFRDR register
                                                          is continued after all the data is read, undefined values will
                                                          be read.                                                             */
           uint32_t             :  7;
      __I  uint32_t  RDC        :  4;               /*!< Receive Data Indicate Flag(Indicates the number of data units
                                                         stored in SSIFRDR)                                                    */
           uint32_t             :  4;
      __IO uint32_t  TDE        :  1;               /*!< Transmit Data Empty FlagNOTE: Since the SSIFTDR register is
                                                         a 32-byte FIFO register, the maximum number of bytes that can
                                                          be written to it while the TDE flag is 1 is 8 - TDC[3:0]. If
                                                          writing data to the SSIFTDR register is continued after all
                                                          the data is written, writing will be invalid and an overflow
                                                          occurs.                                                              */
           uint32_t             :  7;
      __I  uint32_t  TDC        :  4;               /*!< Transmit Data Indicate Flag(Indicates the number of data units
                                                         stored in SSIFTDR)                                                    */
    } SSIFSR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __O  uint32_t  SSIFTDR;                         /*!< Transmit FIFO Data Register                                           */

    struct {
      __O  uint32_t  SSIFTDR    : 32;               /*!< SSIFTDR is a write-only FIFO register consisting of eight stages
                                                         of 32-bit registers for storing data to be serially transmitted.
                                                          NOTE: that when the SSIFTDR register is full of data (32 bytes),
                                                          the next data cannot be written to it. If writing is attempted,
                                                          it will be ignored and an overflow occurs.                           */
    } SSIFTDR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  SSIFRDR;                         /*!< Receive FIFO Data Register                                            */

    struct {
      __I  uint32_t  SSIFRDR    : 32;               /*!< SSIFRDR is a read-only FIFO register consisting of eight stages
                                                         of 32-bit registers for storing serially received data.               */
    } SSIFRDR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  SSITDMR;                         /*!< TDM Mode Register                                                     */

    struct {
           uint32_t             :  8;
      __IO uint32_t  CONT       :  1;               /*!< WS Continue Mode                                                      */
    } SSITDMR_b;                                    /*!< BitSize                                                               */
  };
} R_SSI0_Type;

/* ================================================================================ */
/* ================                     R_CAN0                     ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Network 0 Module (R_CAN0)
  */

typedef struct {                                    /*!< R_CAN0 Structure                                                      */
  __I  uint32_t  RESERVED[128];
  R_CAN0_MBn_Type MBn[32];                          /*!< Mailbox %s                                                            */

  union {
    __IO uint32_t  MKRn[8];                         /*!< Mask Register %s                                                      */

    struct {
      __IO uint32_t  EID        : 18;               /*!< Extended ID                                                           */
      __IO uint32_t  SID        : 11;               /*!< Standard ID                                                           */
    } MKRn_b[8];                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  FIDCRn[2];                       /*!< FIFO Received ID Compare Registers %s                                 */

    struct {
      __IO uint32_t  EID        : 18;               /*!< Extended ID                                                           */
      __IO uint32_t  SID        : 11;               /*!< Standard ID                                                           */
           uint32_t             :  1;
      __IO uint32_t  RTR        :  1;               /*!< Remote Transmission Request                                           */
      __IO uint32_t  IDE        :  1;               /*!< ID Extension                                                          */
    } FIDCRn_b[2];                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  MKIVLR;                          /*!< Mask Invalid Register                                                 */

    struct {
      __IO uint32_t  MB0        :  1;               /*!< mailbox 0 Mask Invalid                                                */
      __IO uint32_t  MB1        :  1;               /*!< mailbox 1 Mask Invalid                                                */
      __IO uint32_t  MB2        :  1;               /*!< mailbox 2 Mask Invalid                                                */
      __IO uint32_t  MB3        :  1;               /*!< mailbox 3 Mask Invalid                                                */
      __IO uint32_t  MB4        :  1;               /*!< mailbox 4 Mask Invalid                                                */
      __IO uint32_t  MB5        :  1;               /*!< mailbox 5 Mask Invalid                                                */
      __IO uint32_t  MB6        :  1;               /*!< mailbox 6 Mask Invalid                                                */
      __IO uint32_t  MB7        :  1;               /*!< mailbox 7 Mask Invalid                                                */
      __IO uint32_t  MB8        :  1;               /*!< mailbox 8 Mask Invalid                                                */
      __IO uint32_t  MB9        :  1;               /*!< mailbox 9 Mask Invalid                                                */
      __IO uint32_t  MB10       :  1;               /*!< mailbox 10 Mask Invalid                                               */
      __IO uint32_t  MB11       :  1;               /*!< mailbox 11 Mask Invalid                                               */
      __IO uint32_t  MB12       :  1;               /*!< mailbox 12 Mask Invalid                                               */
      __IO uint32_t  MB13       :  1;               /*!< mailbox 13 Mask Invalid                                               */
      __IO uint32_t  MB14       :  1;               /*!< mailbox 14 Mask Invalid                                               */
      __IO uint32_t  MB15       :  1;               /*!< mailbox 15 Mask Invalid                                               */
      __IO uint32_t  MB16       :  1;               /*!< mailbox 16 Mask Invalid                                               */
      __IO uint32_t  MB17       :  1;               /*!< mailbox 17 Mask Invalid                                               */
      __IO uint32_t  MB18       :  1;               /*!< mailbox 18 Mask Invalid                                               */
      __IO uint32_t  MB19       :  1;               /*!< mailbox 19 Mask Invalid                                               */
      __IO uint32_t  MB20       :  1;               /*!< mailbox 20 Mask Invalid                                               */
      __IO uint32_t  MB21       :  1;               /*!< mailbox 21 Mask Invalid                                               */
      __IO uint32_t  MB22       :  1;               /*!< mailbox 22 Mask Invalid                                               */
      __IO uint32_t  MB23       :  1;               /*!< mailbox 23 Mask Invalid                                               */
      __IO uint32_t  MB24       :  1;               /*!< mailbox 24 Mask Invalid                                               */
      __IO uint32_t  MB25       :  1;               /*!< mailbox 25 Mask Invalid                                               */
      __IO uint32_t  MB26       :  1;               /*!< mailbox 26 Mask Invalid                                               */
      __IO uint32_t  MB27       :  1;               /*!< mailbox 27 Mask Invalid                                               */
      __IO uint32_t  MB28       :  1;               /*!< mailbox 28 Mask Invalid                                               */
      __IO uint32_t  MB29       :  1;               /*!< mailbox 29 Mask Invalid                                               */
      __IO uint32_t  MB30       :  1;               /*!< mailbox 30 Mask Invalid                                               */
      __IO uint32_t  MB31       :  1;               /*!< mailbox 31 Mask Invalid                                               */
    } MKIVLR_b;                                     /*!< BitSize                                                               */
  };

  union {
    union {
      __IO uint32_t  MIER_FIFO;                     /*!< Mailbox Interrupt Enable Register (FIFO mailbox mode)                 */

      struct {
        __IO uint32_t  MB0      :  1;               /*!< mailbox 0 Interrupt Enable                                            */
        __IO uint32_t  MB1      :  1;               /*!< mailbox 1 Interrupt Enable                                            */
        __IO uint32_t  MB2      :  1;               /*!< mailbox 2 Interrupt Enable                                            */
        __IO uint32_t  MB3      :  1;               /*!< mailbox 3 Interrupt Enable                                            */
        __IO uint32_t  MB4      :  1;               /*!< mailbox 4 Interrupt Enable                                            */
        __IO uint32_t  MB5      :  1;               /*!< mailbox 5 Interrupt Enable                                            */
        __IO uint32_t  MB6      :  1;               /*!< mailbox 6 Interrupt Enable                                            */
        __IO uint32_t  MB7      :  1;               /*!< mailbox 7 Interrupt Enable                                            */
        __IO uint32_t  MB8      :  1;               /*!< mailbox 8 Interrupt Enable                                            */
        __IO uint32_t  MB9      :  1;               /*!< mailbox 9 Interrupt Enable                                            */
        __IO uint32_t  MB10     :  1;               /*!< mailbox 10 Interrupt Enable                                           */
        __IO uint32_t  MB11     :  1;               /*!< mailbox 11 Interrupt Enable                                           */
        __IO uint32_t  MB12     :  1;               /*!< mailbox 12 Interrupt Enable                                           */
        __IO uint32_t  MB13     :  1;               /*!< mailbox 13 Interrupt Enable                                           */
        __IO uint32_t  MB14     :  1;               /*!< mailbox 14 Interrupt Enable                                           */
        __IO uint32_t  MB15     :  1;               /*!< mailbox 15 Interrupt Enable                                           */
        __IO uint32_t  MB16     :  1;               /*!< mailbox 16 Interrupt Enable                                           */
        __IO uint32_t  MB17     :  1;               /*!< mailbox 17 Interrupt Enable                                           */
        __IO uint32_t  MB18     :  1;               /*!< mailbox 18 Interrupt Enable                                           */
        __IO uint32_t  MB19     :  1;               /*!< mailbox 19 Interrupt Enable                                           */
        __IO uint32_t  MB20     :  1;               /*!< mailbox 20 Interrupt Enable                                           */
        __IO uint32_t  MB21     :  1;               /*!< mailbox 21 Interrupt Enable                                           */
        __IO uint32_t  MB22     :  1;               /*!< mailbox 22 Interrupt Enable                                           */
        __IO uint32_t  MB23     :  1;               /*!< mailbox 23 Interrupt Enable                                           */
        __IO uint32_t  MB24     :  1;               /*!< Transmit FIFO Interrupt Enable                                        */
        __IO uint32_t  MB25     :  1;               /*!< Transmit FIFO Interrupt Generation Timing Control                     */
             uint32_t           :  2;
        __IO uint32_t  MB28     :  1;               /*!< Receive FIFO Interrupt Enable                                         */
        __IO uint32_t  MB29     :  1;               /*!< Receive FIFO Interrupt Generation Timing Control                      */
      } MIER_FIFO_b;                                /*!< BitSize                                                               */
    };

    union {
      __IO uint32_t  MIER;                          /*!< Mailbox Interrupt Enable Register (Normal mailbox mode)               */

      struct {
        __IO uint32_t  MB0      :  1;               /*!< mailbox 0 Interrupt Enable                                            */
        __IO uint32_t  MB1      :  1;               /*!< mailbox 1 Interrupt Enable                                            */
        __IO uint32_t  MB2      :  1;               /*!< mailbox 2 Interrupt Enable                                            */
        __IO uint32_t  MB3      :  1;               /*!< mailbox 3 Interrupt Enable                                            */
        __IO uint32_t  MB4      :  1;               /*!< mailbox 4 Interrupt Enable                                            */
        __IO uint32_t  MB5      :  1;               /*!< mailbox 5 Interrupt Enable                                            */
        __IO uint32_t  MB6      :  1;               /*!< mailbox 6 Interrupt Enable                                            */
        __IO uint32_t  MB7      :  1;               /*!< mailbox 7 Interrupt Enable                                            */
        __IO uint32_t  MB8      :  1;               /*!< mailbox 8 Interrupt Enable                                            */
        __IO uint32_t  MB9      :  1;               /*!< mailbox 9 Interrupt Enable                                            */
        __IO uint32_t  MB10     :  1;               /*!< mailbox 10 Interrupt Enable                                           */
        __IO uint32_t  MB11     :  1;               /*!< mailbox 11 Interrupt Enable                                           */
        __IO uint32_t  MB12     :  1;               /*!< mailbox 12 Interrupt Enable                                           */
        __IO uint32_t  MB13     :  1;               /*!< mailbox 13 Interrupt Enable                                           */
        __IO uint32_t  MB14     :  1;               /*!< mailbox 14 Interrupt Enable                                           */
        __IO uint32_t  MB15     :  1;               /*!< mailbox 15 Interrupt Enable                                           */
        __IO uint32_t  MB16     :  1;               /*!< mailbox 16 Interrupt Enable                                           */
        __IO uint32_t  MB17     :  1;               /*!< mailbox 17 Interrupt Enable                                           */
        __IO uint32_t  MB18     :  1;               /*!< mailbox 18 Interrupt Enable                                           */
        __IO uint32_t  MB19     :  1;               /*!< mailbox 19 Interrupt Enable                                           */
        __IO uint32_t  MB20     :  1;               /*!< mailbox 20 Interrupt Enable                                           */
        __IO uint32_t  MB21     :  1;               /*!< mailbox 21 Interrupt Enable                                           */
        __IO uint32_t  MB22     :  1;               /*!< mailbox 22 Interrupt Enable                                           */
        __IO uint32_t  MB23     :  1;               /*!< mailbox 23 Interrupt Enable                                           */
        __IO uint32_t  MB24     :  1;               /*!< mailbox 24 Interrupt Enable                                           */
        __IO uint32_t  MB25     :  1;               /*!< mailbox 25 Interrupt Enable                                           */
        __IO uint32_t  MB26     :  1;               /*!< mailbox 26 Interrupt Enable                                           */
        __IO uint32_t  MB27     :  1;               /*!< mailbox 27 Interrupt Enable                                           */
        __IO uint32_t  MB28     :  1;               /*!< mailbox 28 Interrupt Enable                                           */
        __IO uint32_t  MB29     :  1;               /*!< mailbox 29 Interrupt Enable                                           */
        __IO uint32_t  MB30     :  1;               /*!< mailbox 30 Interrupt Enable                                           */
        __IO uint32_t  MB31     :  1;               /*!< mailbox 31 Interrupt Enable                                           */
      } MIER_b;                                     /*!< BitSize                                                               */
    };
  };
  __I  uint32_t  RESERVED1[252];

  union {
    union {
      __IO uint8_t   MCTLn_RX[32];                  /*!< Message Control Register( Receive mode (when the TRMREQ bit
                                                         is 0 and the RECREQ bit is 1))                                        */

      struct {
        __IO uint8_t   NEWDATA  :  1;               /*!< Reception Complete Flag                                               */
        __I  uint8_t   INVALDATA:  1;               /*!< Reception-in-Progress Status Flag (Receive mailbox setting enabled)   */
        __IO uint8_t   MSGLOST  :  1;               /*!< Message Lost Flag(Receive mailbox setting enabled)                    */
             uint8_t            :  1;
        __IO uint8_t   ONESHOT  :  1;               /*!< One-Shot Enable                                                       */
             uint8_t            :  1;
        __IO uint8_t   RECREQ   :  1;               /*!< Receive Mailbox Request                                               */
        __IO uint8_t   TRMREQ   :  1;               /*!< Transmit Mailbox Request                                              */
      } MCTLn_RX_b[32];                             /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   MCTLn_TX[32];                  /*!< Message Control Register(Transmit mode (when the TRMREQ bit
                                                         is 1 and the RECREQ bit is 0))                                        */

      struct {
        __IO uint8_t   SENTDATA :  1;               /*!< Transmission Complete Flag                                            */
        __I  uint8_t   TRMACTIVE:  1;               /*!< Transmission-in-Progress Status Flag(Transmit mailbox setting
                                                         enabled)                                                              */
        __IO uint8_t   TRMABT   :  1;               /*!< Transmission Abort Complete Flag(Transmit mailbox setting enabled)    */
             uint8_t            :  1;
        __IO uint8_t   ONESHOT  :  1;               /*!< One-Shot Enable                                                       */
             uint8_t            :  1;
        __IO uint8_t   RECREQ   :  1;               /*!< Receive Mailbox Request                                               */
        __IO uint8_t   TRMREQ   :  1;               /*!< Transmit Mailbox Request                                              */
      } MCTLn_TX_b[32];                             /*!< BitSize                                                               */
    };
  };

  union {
    __IO uint16_t  CTLR;                            /*!< Control Register                                                      */

    struct {
      __IO uint16_t  MBM        :  1;               /*!< CAN Mailbox Mode Select                                               */
      __IO uint16_t  IDFM       :  2;               /*!< ID Format Mode Select                                                 */
      __IO uint16_t  MLM        :  1;               /*!< Message Lost Mode Select                                              */
      __IO uint16_t  TPM        :  1;               /*!< Transmission Priority Mode Select                                     */
      __IO uint16_t  TSRC       :  1;               /*!< Time Stamp Counter Reset Command                                      */
      __IO uint16_t  TSPS       :  2;               /*!< Time Stamp Prescaler Select                                           */
      __IO uint16_t  CANM       :  2;               /*!< CAN Operating Mode Select                                             */
      __IO uint16_t  SLPM       :  1;               /*!< CAN Sleep Mode                                                        */
      __IO uint16_t  BOM        :  2;               /*!< Bus-Off Recovery Mode by a program request                            */
      __IO uint16_t  RBOC       :  1;               /*!< Forcible Return From Bus-Off                                          */
    } CTLR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  STR;                             /*!< Status Register                                                       */

    struct {
      __I  uint16_t  NDST       :  1;               /*!< NEWDATA Status Flag                                                   */
      __I  uint16_t  SDST       :  1;               /*!< SENTDATA Status Flag                                                  */
      __I  uint16_t  RFST       :  1;               /*!< Receive FIFO Status Flag                                              */
      __I  uint16_t  TFST       :  1;               /*!< Transmit FIFO Status Flag                                             */
      __I  uint16_t  NMLST      :  1;               /*!< Normal Mailbox Message Lost Status Flag                               */
      __I  uint16_t  FMLST      :  1;               /*!< FIFO Mailbox Message Lost Status Flag                                 */
      __I  uint16_t  TABST      :  1;               /*!< Transmission Abort Status Flag                                        */
      __I  uint16_t  EST        :  1;               /*!< Error Status Flag                                                     */
      __I  uint16_t  RSTST      :  1;               /*!< CAN Reset Status Flag                                                 */
      __I  uint16_t  HLTST      :  1;               /*!< CAN Halt Status Flag                                                  */
      __I  uint16_t  SLPST      :  1;               /*!< CAN Sleep Status Flag                                                 */
      __I  uint16_t  EPST       :  1;               /*!< Error-Passive Status Flag                                             */
      __I  uint16_t  BOST       :  1;               /*!< Bus-Off Status Flag                                                   */
      __I  uint16_t  TRMST      :  1;               /*!< Transmit Status Flag (transmitter)                                    */
      __I  uint16_t  RECST      :  1;               /*!< Receive Status Flag (receiver)                                        */
    } STR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  BCR;                             /*!< Bit Configuration Register                                            */

    struct {
      __IO uint32_t  CCLKS      :  1;               /*!< CAN Clock Source Selection                                            */
           uint32_t             :  7;
      __IO uint32_t  TSEG2      :  3;               /*!< Time Segment 2 Control                                                */
           uint32_t             :  1;
      __IO uint32_t  SJW        :  2;               /*!< Resynchronization Jump Width Control                                  */
           uint32_t             :  2;
      __IO uint32_t  BRP        : 10;               /*!< Prescaler Division Ratio Select . These bits set the frequency
                                                         of the CAN communication clock (fCANCLK).                             */
           uint32_t             :  2;
      __IO uint32_t  TSEG1      :  4;               /*!< Time Segment 1 Control                                                */
    } BCR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   RFCR;                            /*!< Receive FIFO Control Register                                         */

    struct {
      __IO uint8_t   RFE        :  1;               /*!< Receive FIFO Enable                                                   */
      __I  uint8_t   RFUST      :  3;               /*!< Receive FIFO Unread Message Number Status                             */
      __IO uint8_t   RFMLF      :  1;               /*!< Receive FIFO Message Lost Flag                                        */
      __I  uint8_t   RFFST      :  1;               /*!< Receive FIFO Full Status Flag                                         */
      __I  uint8_t   RFWST      :  1;               /*!< Receive FIFO Buffer Warning Status Flag                               */
      __I  uint8_t   RFEST      :  1;               /*!< Receive FIFO Empty Status Flag                                        */
    } RFCR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __O  uint8_t   RFPCR;                           /*!< Receive FIFO Pointer Control Register                                 */

    struct {
      __O  uint8_t   RFPCR      :  8;               /*!< The CPU-side pointer for the receive FIFO is incremented by
                                                         writing FFh to RFPCR.                                                 */
    } RFPCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   TFCR;                            /*!< Transmit FIFO Control Register                                        */

    struct {
      __IO uint8_t   TFE        :  1;               /*!< Transmit FIFO Enable                                                  */
      __I  uint8_t   TFUST      :  3;               /*!< Transmit FIFO Unsent Message Number Status                            */
           uint8_t              :  2;
      __I  uint8_t   TFFST      :  1;               /*!< Transmit FIFO Full Status                                             */
      __I  uint8_t   TFEST      :  1;               /*!< Transmit FIFO Empty Status                                            */
    } TFCR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __O  uint8_t   TFPCR;                           /*!< Transmit FIFO Pointer Control Register                                */

    struct {
      __O  uint8_t   TFPCR      :  8;               /*!< The CPU-side pointer for the transmit FIFO is incremented by
                                                         writing FFh to TFPCR.                                                 */
    } TFPCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   EIER;                            /*!< Error Interrupt Enable Register                                       */

    struct {
      __IO uint8_t   BEIE       :  1;               /*!< Bus Error Interrupt Enable                                            */
      __IO uint8_t   EWIE       :  1;               /*!< Error-Warning Interrupt Enable                                        */
      __IO uint8_t   EPIE       :  1;               /*!< Error-Passive Interrupt Enable                                        */
      __IO uint8_t   BOEIE      :  1;               /*!< Bus-Off Entry Interrupt Enable                                        */
      __IO uint8_t   BORIE      :  1;               /*!< Bus-Off Recovery Interrupt Enable                                     */
      __IO uint8_t   ORIE       :  1;               /*!< Overrun Interrupt Enable                                              */
      __IO uint8_t   OLIE       :  1;               /*!< Overload Frame Transmit Interrupt Enable                              */
      __IO uint8_t   BLIE       :  1;               /*!< Bus Lock Interrupt Enable                                             */
    } EIER_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   EIFR;                            /*!< Error Interrupt Factor Judge Register                                 */

    struct {
      __IO uint8_t   BEIF       :  1;               /*!< Bus Error Detect Flag                                                 */
      __IO uint8_t   EWIF       :  1;               /*!< Error-Warning Detect Flag                                             */
      __IO uint8_t   EPIF       :  1;               /*!< Error-Passive Detect Flag                                             */
      __IO uint8_t   BOEIF      :  1;               /*!< Bus-Off Entry Detect Flag                                             */
      __IO uint8_t   BORIF      :  1;               /*!< Bus-Off Recovery Detect Flag                                          */
      __IO uint8_t   ORIF       :  1;               /*!< Receive Overrun Detect Flag                                           */
      __IO uint8_t   OLIF       :  1;               /*!< Overload Frame Transmission Detect Flag                               */
      __IO uint8_t   BLIF       :  1;               /*!< Bus Lock Detect Flag                                                  */
    } EIFR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __I  uint8_t   RECR;                            /*!< Receive Error Count Register                                          */

    struct {
      __I  uint8_t   RECR       :  8;               /*!< Receive error count functionRECR increments or decrements the
                                                         counter value according to the error status of the CAN module
                                                          during reception.                                                    */
    } RECR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __I  uint8_t   TECR;                            /*!< Transmit Error Count Register                                         */

    struct {
      __I  uint8_t   TECR       :  8;               /*!< Transmit error count functionTECR increments or decrements the
                                                         counter value according to the error status of the CAN module
                                                          during transmission.                                                 */
    } TECR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ECSR;                            /*!< Error Code Store Register                                             */

    struct {
      __IO uint8_t   SEF        :  1;               /*!< Stuff Error Flag                                                      */
      __IO uint8_t   FEF        :  1;               /*!< Form Error Flag                                                       */
      __IO uint8_t   AEF        :  1;               /*!< ACK Error Flag                                                        */
      __IO uint8_t   CEF        :  1;               /*!< CRC Error Flag                                                        */
      __IO uint8_t   BE1F       :  1;               /*!< Bit Error (recessive) Flag                                            */
      __IO uint8_t   BE0F       :  1;               /*!< Bit Error (dominant) Flag                                             */
      __IO uint8_t   ADEF       :  1;               /*!< ACK Delimiter Error Flag                                              */
      __IO uint8_t   EDPM       :  1;               /*!< Error Display Mode Select                                             */
    } ECSR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CSSR;                            /*!< Channel Search Support Register                                       */

    struct {
      __IO uint8_t   CSSR       :  8;               /*!< When the value for the channel search is input, the channel
                                                         number is output to MSSR.                                             */
    } CSSR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __I  uint8_t   MSSR;                            /*!< Mailbox Search Status Register                                        */

    struct {
      __I  uint8_t   MBNST      :  5;               /*!< Search Result Mailbox Number Status These bits output the smallest
                                                         mailbox number that is searched in each mode of MSMR.                 */
           uint8_t              :  2;
      __I  uint8_t   SEST       :  1;               /*!< Search Result Status                                                  */
    } MSSR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   MSMR;                            /*!< Mailbox Search Mode Register                                          */

    struct {
      __IO uint8_t   MBSM       :  2;               /*!< Mailbox Search Mode Select                                            */
    } MSMR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  TSR;                             /*!< Time Stamp Register                                                   */

    struct {
      __I  uint16_t  TSR        : 16;               /*!< Free-running counter value for the time stamp function                */
    } TSR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  AFSR;                            /*!< Acceptance Filter Support Register                                    */

    struct {
      __IO uint16_t  AFSR       : 16;               /*!< After the standard ID of a received message is written, the
                                                         value converted for data table search can be read.                    */
    } AFSR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   TCR;                             /*!< Test Control Register                                                 */

    struct {
      __IO uint8_t   TSTE       :  1;               /*!< CAN Test Mode Enable                                                  */
      __IO uint8_t   TSTM       :  2;               /*!< CAN Test Mode Select                                                  */
    } TCR_b;                                        /*!< BitSize                                                               */
  };
} R_CAN0_Type;


/* ================================================================================ */
/* ================                     R_IIC0                     ================ */
/* ================================================================================ */

/**
  * @brief Inter-Integrated Circuit 0 (R_IIC0)
  */

typedef struct {                                    /*!< R_IIC0 Structure                                                      */

  union {
    __IO uint8_t   ICCR1;                           /*!< I2C Bus Control Register 1                                            */

    struct {
      __I  uint8_t   SDAI       :  1;               /*!< SDA Line Monitor                                                      */
      __I  uint8_t   SCLI       :  1;               /*!< SCL Line Monitor                                                      */
      __IO uint8_t   SDAO       :  1;               /*!< SDA Output Control/Monitor                                            */
      __IO uint8_t   SCLO       :  1;               /*!< SCL Output Control/Monitor                                            */
      __O  uint8_t   SOWP       :  1;               /*!< SCLO/SDAO Write Protect (This bit is read as 1.)                      */
      __IO uint8_t   CLO        :  1;               /*!< Extra SCL Clock Cycle Output                                          */
      __IO uint8_t   IICRST     :  1;               /*!< I2C Bus Interface Internal ResetNote:If an internal reset is
                                                         initiated using the IICRST bit for a bus hang-up occurred during
                                                          communication with the master device in slave mode, the states
                                                          may become different between the slave device and the master
                                                          device (due to the difference in the bit counter information).       */
      __IO uint8_t   ICE        :  1;               /*!< I2C Bus Interface Enable                                              */
    } ICCR1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICCR2;                           /*!< I2C Bus Control Register 2                                            */

    struct {
           uint8_t              :  1;
      __IO uint8_t   ST         :  1;               /*!< Start Condition Issuance RequestSet the ST bit to 1 (start condition
                                                         issuance request) when the BBSY flag is set to 0 (bus free state).    */
      __IO uint8_t   RS         :  1;               /*!< Restart Condition Issuance RequestNote: Do not set the RS bit
                                                         to 1 while issuing a stop condition.                                  */
      __IO uint8_t   SP         :  1;               /*!< Stop Condition Issuance RequestNote: Writing to the SP bit is
                                                         not possible while the setting of the BBSY flag is 0 (bus free
                                                          state).Note: Do not set the SP bit to 1 while a restart condition
                                                          is being issued.                                                     */
           uint8_t              :  1;
      __IO uint8_t   TRS        :  1;               /*!< Transmit/Receive Mode                                                 */
      __IO uint8_t   MST        :  1;               /*!< Master/Slave Mode                                                     */
      __I  uint8_t   BBSY       :  1;               /*!< Bus Busy Detection Flag                                               */
    } ICCR2_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICMR1;                           /*!< I2C Bus Mode Register 1                                               */

    struct {
      __IO uint8_t   BC         :  3;               /*!< Bit Counter                                                           */
      __O  uint8_t   BCWP       :  1;               /*!< BC Write Protect(This bit is read as 1.)                              */
      __IO uint8_t   CKS        :  3;               /*!< Internal Reference Clock (fIIC) Selection ( fIIC = PCLKB / 2^CKS
                                                         )                                                                     */
      __IO uint8_t   MTWP       :  1;               /*!< MST/TRS Write Protect                                                 */
    } ICMR1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICMR2;                           /*!< I2C Bus Mode Register 2                                               */

    struct {
      __IO uint8_t   TMOS       :  1;               /*!< Timeout Detection Time Selection                                      */
      __IO uint8_t   TMOL       :  1;               /*!< Timeout L Count Control                                               */
      __IO uint8_t   TMOH       :  1;               /*!< Timeout H Count Control                                               */
           uint8_t              :  1;
      __IO uint8_t   SDDL       :  3;               /*!< SDA Output Delay Counter                                              */
      __IO uint8_t   DLCS       :  1;               /*!< SDA Output Delay Clock Source Selection                               */
    } ICMR2_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICMR3;                           /*!< I2C Bus Mode Register 3                                               */

    struct {
      __IO uint8_t   NF         :  2;               /*!< Noise Filter Stage Selection                                          */
      __I  uint8_t   ACKBR      :  1;               /*!< Receive Acknowledge                                                   */
      __IO uint8_t   ACKBT      :  1;               /*!< Transmit Acknowledge                                                  */
      __IO uint8_t   ACKWP      :  1;               /*!< ACKBT Write Protect                                                   */
      __IO uint8_t   RDRFS      :  1;               /*!< RDRF Flag Set Timing Selection                                        */
      __IO uint8_t   WAIT       :  1;               /*!< WAITNote: When the value of the WAIT bit is to be read, be sure
                                                         to read the ICDRR beforehand.                                         */
      __IO uint8_t   SMBE       :  1;               /*!< SMBus/I2C Bus Selection                                               */
    } ICMR3_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICFER;                           /*!< I2C Bus Function Enable Register                                      */

    struct {
      __IO uint8_t   TMOE       :  1;               /*!< Timeout Function Enable                                               */
      __IO uint8_t   MALE       :  1;               /*!< Master Arbitration-Lost Detection Enable                              */
      __IO uint8_t   NALE       :  1;               /*!< NACK Transmission Arbitration-Lost Detection Enable                   */
      __IO uint8_t   SALE       :  1;               /*!< Slave Arbitration-Lost Detection Enable                               */
      __IO uint8_t   NACKE      :  1;               /*!< NACK Reception Transfer Suspension Enable                             */
      __IO uint8_t   NFE        :  1;               /*!< Digital Noise Filter Circuit Enable                                   */
      __IO uint8_t   SCLE       :  1;               /*!< SCL Synchronous Circuit Enable                                        */
      __IO uint8_t   FMPE       :  1;               /*!< Fast-mode Plus Enable                                                 */
    } ICFER_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICSER;                           /*!< I2C Bus Status Enable Register                                        */

    struct {
      __IO uint8_t   SAR0       :  1;               /*!< Slave Address Register 0 Enable                                       */
      __IO uint8_t   SAR1       :  1;               /*!< Slave Address Register 1 Enable                                       */
      __IO uint8_t   SAR2       :  1;               /*!< Slave Address Register 2 Enable                                       */
      __IO uint8_t   GCE        :  1;               /*!< General Call Address Enable                                           */
           uint8_t              :  1;
      __IO uint8_t   DIDE       :  1;               /*!< Device-ID Address Detection Enable                                    */
           uint8_t              :  1;
      __IO uint8_t   HOAE       :  1;               /*!< Host Address Enable                                                   */
    } ICSER_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICIER;                           /*!< I2C Bus Interrupt Enable Register                                     */

    struct {
      __IO uint8_t   TMOIE      :  1;               /*!< Timeout Interrupt Request Enable                                      */
      __IO uint8_t   ALIE       :  1;               /*!< Arbitration-Lost Interrupt Request Enable                             */
      __IO uint8_t   STIE       :  1;               /*!< Start Condition Detection Interrupt Request Enable                    */
      __IO uint8_t   SPIE       :  1;               /*!< Stop Condition Detection Interrupt Request Enable                     */
      __IO uint8_t   NAKIE      :  1;               /*!< NACK Reception Interrupt Request Enable                               */
      __IO uint8_t   RIE        :  1;               /*!< Receive Data Full Interrupt Request Enable                            */
      __IO uint8_t   TEIE       :  1;               /*!< Transmit End Interrupt Request Enable                                 */
      __IO uint8_t   TIE        :  1;               /*!< Transmit Data Empty Interrupt Request Enable                          */
    } ICIER_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICSR1;                           /*!< I2C Bus Status Register 1                                             */

    struct {
      __IO uint8_t   AAS0   :  1;                   /*!< Slave Address 0 Detection Flag                                        */
      __IO uint8_t   AAS1   :  1;                   /*!< Slave Address 1 Detection Flag                                        */
      __IO uint8_t   AAS2   :  1;                   /*!< Slave Address 2 Detection Flag                                        */
      __IO uint8_t   ADZ    :  1;                   /*!< General Call Address Detection Flag                                   */
           uint8_t          :  1;
      __IO uint8_t   DID    :  1;                   /*!< Device-ID Address Detection Flag                                      */
           uint8_t          :  1;
      __IO uint8_t   HOA    :  1;                   /*!< Host Address Detection Flag                                           */
    } ICSR1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICSR2;                           /*!< I2C Bus Status Register 2                                             */

    struct {
      __IO uint8_t   TMOF   :  1;                   /*!< Timeout Detection Flag                                                */
      __IO uint8_t   AL     :  1;                   /*!< Arbitration-Lost Flag                                                 */
      __IO uint8_t   START  :  1;                   /*!< Start Condition Detection Flag                                        */
      __IO uint8_t   STOP   :  1;                   /*!< Stop Condition Detection Flag                                         */
      __IO uint8_t   NACKF  :  1;                   /*!< NACK Detection Flag                                                   */
      __IO uint8_t   RDRF   :  1;                   /*!< Receive Data Full Flag                                                */
      __IO uint8_t   TEND   :  1;                   /*!< Transmit End Flag                                                     */
      __I  uint8_t   TDRE   :  1;                   /*!< Transmit Data Empty Flag                                              */
    } ICSR2_b;                                      /*!< BitSize                                                               */
  };

  R_IIC0_SARLnRC0_Type SARLnRC0[3];                 /*!< Slave Address Register L%s                                            */

  union {
    __IO uint8_t   ICBRL;                           /*!< I2C Bus Bit Rate Low-Level Register                                   */

    struct {
      __IO uint8_t   BRL        :  5;               /*!< Bit Rate Low-Level Period(Low-level period of SCL clock)              */
    } ICBRL_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICBRH;                           /*!< I2C Bus Bit Rate High-Level Register                                  */

    struct {
      __IO uint8_t   BRH        :  5;               /*!< Bit Rate High-Level Period(High-level period of SCL clock)            */
    } ICBRH_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICDRT;                           /*!< I2C Bus Transmit Data Register                                        */

    struct {
      __IO uint8_t   ICDRT      :  8;               /*!< 8-bit read-write register that stores transmit data.                  */
    } ICDRT_b;                                      /*!< BitSize                                                               */
  };

  union {
    __I  uint8_t   ICDRR;                           /*!< I2C Bus Receive Data Register                                         */

    struct {
      __I  uint8_t   ICDRR      :  8;               /*!< 8-bit register that stores the received data                          */
    } ICDRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[2];   // Padding changed from uint16_t

  union {
    __IO uint8_t   ICWUR;                           /*!< I2C Bus Wake Up Unit Register                                         */

    struct {
      __IO uint8_t   WUAFA      :  1;               /*!< Wake-Up Analog Filter Additional Selection                            */
           uint8_t              :  2;
      __I  uint8_t   WUBFR      :  1;               /*!< Bus Free During Wake-Up Mode                                          */
      __IO uint8_t   WUACK      :  1;               /*!< Asynchronous/Synchronous Operation State Flag                         */
      __IO uint8_t   WUF        :  1;               /*!< Wake-Up Event Occurrence Flag                                         */
      __IO uint8_t   WUIE       :  1;               /*!< Wake Up Interrupt Request Enable                                      */
      __IO uint8_t   WUE        :  1;               /*!< Wake Up function Enable                                               */
    } ICWUR_b;                                      /*!< BitSize                                                               */
  };
} R_IIC0_Type;

/* ================================================================================ */
/* ================                      R_DOC                     ================ */
/* ================================================================================ */


/**
  * @brief Data Operation Circuit (R_DOC)
  */

typedef struct {                                    /*!< R_DOC Structure                                                       */

  union {
    __IO uint8_t   DOCR;                            /*!< DOC Control Register                                                  */

    struct {
      __IO uint8_t   OMS        :  2;               /*!< Operating Mode Select                                                 */
      __IO uint8_t   DCSEL      :  1;               /*!< Detection Condition Select Result of data comparison. Note:
                                                         Valid only when data comparison mode is selected.                     */
           uint8_t              :  2;
      __I  uint8_t   DOPCF      :  1;               /*!< Data Operation Circuit FlagIndicates the result of an operation.      */
      __IO uint8_t   DOPCFCL    :  1;               /*!< DOPCF Clear                                                           */
    } DOCR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;

  union {
    __IO uint16_t  DODIR;                           /*!< DOC Data Input Register                                               */

    struct {
      __IO uint16_t  DODIR      : 16;               /*!< 16-bit read-write register in which 16-bit data for use in the
                                                         operations are stored.                                                */
    } DODIR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  DODSR;                           /*!< DOC Data Setting Register                                             */

    struct {
      __IO uint16_t  DODSR      : 16;               /*!< This register stores 16-bit data for use as a reference in data
                                                         comparison mode. This register also stores the results of operations
                                                          in data addition and data subtraction modes.                         */
    } DODSR_b;                                      /*!< BitSize                                                               */
  };
} R_DOC_Type;


/* ================================================================================ */
/* ================                    R_S16ADC                    ================ */
/* ================================================================================ */


/**
  * @brief 16bit A/D Converter (R_S16ADC)
  */

typedef struct {                                    /*!< R_S16ADC Structure                                                    */

  union {
    __IO uint16_t  ADCSR;                           /*!< A/D Control Register                                                  */

    struct {
      __IO uint16_t  DBLANS     :  5;               /*!< Double Trigger Channel SelectThese bits select one analog input
                                                         channel for double triggered operation. The setting is only
                                                          effective while double trigger mode is selected.                     */
           uint16_t             :  1;
      __IO uint16_t  GBADIE     :  1;               /*!< Group B Scan End Interrupt Enable                                     */
      __IO uint16_t  DBLE       :  1;               /*!< Double Trigger Mode Select                                            */
      __IO uint16_t  EXTRG      :  1;               /*!< Trigger Select                                                        */
      __IO uint16_t  TRGE       :  1;               /*!< Trigger Start Enable                                                  */
           uint16_t             :  3;
      __IO uint16_t  ADCS       :  2;               /*!< Scan Mode Select                                                      */
      __IO uint16_t  ADST       :  1;               /*!< A/D Conversion Start                                                  */
    } ADCSR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED;

  union {
    __IO uint16_t  ADANSA0;                         /*!< A/D Channel Select Register A0                                        */

    struct {
      __IO uint16_t  ANSA00     :  1;               /*!< AN000 Select                                                          */
      __IO uint16_t  ANSA01     :  1;               /*!< AN001 Select                                                          */
      __IO uint16_t  ANSA02     :  1;               /*!< AN002 Select                                                          */
      __IO uint16_t  ANSA03     :  1;               /*!< AN003 Select                                                          */
      __IO uint16_t  ANSA04     :  1;               /*!< AN004 Select                                                          */
      __IO uint16_t  ANSA05     :  1;               /*!< AN005 Select                                                          */
      __IO uint16_t  ANSA06     :  1;               /*!< AN006 Select                                                          */
      __IO uint16_t  ANSA07     :  1;               /*!< AN007 Select                                                          */
      __IO uint16_t  ANSA08     :  1;               /*!< AN008 Select                                                          */
      __IO uint16_t  ANSA09     :  1;               /*!< AN009 Select                                                          */
      __IO uint16_t  ANSA010    :  1;               /*!< AN010 Select                                                          */
      __IO uint16_t  ANSA011    :  1;               /*!< AN011 Select                                                          */
      __IO uint16_t  ANSA012    :  1;               /*!< AN012 Select                                                          */
      __IO uint16_t  ANSA013    :  1;               /*!< AN013 Select                                                          */
      __IO uint16_t  ANSA014    :  1;               /*!< AN014 Select                                                          */
      __IO uint16_t  ANSA015    :  1;               /*!< AN015 Select                                                          */
    } ADANSA0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADANSA1;                         /*!< A/D Channel Select Register A1                                        */

    struct {
      __IO uint16_t  ANSA16     :  1;               /*!< AN016 Select                                                          */
      __IO uint16_t  ANSA17     :  1;               /*!< AN017 Select                                                          */
      __IO uint16_t  ANSA18     :  1;               /*!< AN018 Select                                                          */
      __IO uint16_t  ANSA19     :  1;               /*!< AN019 Select                                                          */
      __IO uint16_t  ANSA20     :  1;               /*!< AN020 Select                                                          */
      __IO uint16_t  ANSA21     :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  ANSA22     :  1;               /*!< AN022 Select                                                          */
      __IO uint16_t  ANSA23     :  1;               /*!< AN023 Select                                                          */
      __IO uint16_t  ANSA24     :  1;               /*!< AN024 Select                                                          */
      __IO uint16_t  ANSA25     :  1;               /*!< AN025 Select                                                          */
      __IO uint16_t  ANSA26     :  1;               /*!< AN026 Select                                                          */
      __IO uint16_t  ANSA27     :  1;               /*!< AN027 Select                                                          */
    } ADANSA1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADADS0;                          /*!< A/D-Converted Value Addition/Average Channel Select Register
                                                         0                                                                     */

    struct {
      __IO uint16_t  ADS00      :  1;               /*!< A/D-Converted Value Average Channel AN000 Select             */
      __IO uint16_t  ADS01      :  1;               /*!< A/D-Converted Value Average Channel AN001 Select             */
      __IO uint16_t  ADS02      :  1;               /*!< A/D-Converted Value Average Channel AN002 Select             */
      __IO uint16_t  ADS03      :  1;               /*!< A/D-Converted Value Average Channel AN003 Select             */
      __IO uint16_t  ADS04      :  1;               /*!< A/D-Converted Value Average Channel AN004 Select             */
      __IO uint16_t  ADS05      :  1;               /*!< A/D-Converted Value Average Channel AN005 Select             */
      __IO uint16_t  ADS06      :  1;               /*!< A/D-Converted Value Average Channel AN006 Select             */
      __IO uint16_t  ADS07      :  1;               /*!< A/D-Converted Value Average Channel AN007 Select             */
      __IO uint16_t  ADS08      :  1;               /*!< A/D-Converted Value Average Channel AN008 Select             */
      __IO uint16_t  ADS09      :  1;               /*!< A/D-Converted Value Average Channel AN009 Select             */
      __IO uint16_t  ADS10      :  1;               /*!< A/D-Converted Value Average Channel AN010 Select             */
      __IO uint16_t  ADS11      :  1;               /*!< A/D-Converted Value Average Channel AN011 Select             */
      __IO uint16_t  ADS12      :  1;               /*!< A/D-Converted Value Average Channel AN012 Select             */
      __IO uint16_t  ADS13      :  1;               /*!< A/D-Converted Value Average Channel AN013 Select             */
      __IO uint16_t  ADS14      :  1;               /*!< A/D-Converted Value Average Channel AN014 Select             */
      __IO uint16_t  ADS15      :  1;               /*!< A/D-Converted Value Average Channel AN015 Select             */
    } ADADS0_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADADS1;                          /*!< A/D-Converted Value Average Channel Select Register
                                                         1                                                                     */

    struct {
      __IO uint16_t  ADS16      :  1;               /*!< A/D-Converted Value Average Channel AN016 Select             */
      __IO uint16_t  ADS17      :  1;               /*!< A/D-Converted Value Average Channel AN017 Select             */
      __IO uint16_t  ADS18      :  1;               /*!< A/D-Converted Value Average Channel AN018 Select             */
      __IO uint16_t  ADS19      :  1;               /*!< A/D-Converted Value Average Channel AN019 Select             */
      __IO uint16_t  ADS20      :  1;               /*!< A/D-Converted Value Average Channel AN020 Select             */
      __IO uint16_t  ADS21      :  1;               /*!< A/D-Converted Value Average Channel AN021 Select             */
      __IO uint16_t  ADS22      :  1;               /*!< A/D-Converted Value Average Channel AN021 Select             */
      __IO uint16_t  ADS23      :  1;               /*!< A/D-Converted Value Average Channel AN021 Select             */
      __IO uint16_t  ADS24      :  1;               /*!< A/D-Converted Value Average Channel AN021 Select             */
      __IO uint16_t  ADS25      :  1;               /*!< A/D-Converted Value Average Channel AN021 Select             */
      __IO uint16_t  ADS26      :  1;               /*!< A/D-Converted Value Average Channel AN021 Select             */
      __IO uint16_t  ADS27      :  1;               /*!< A/D-Converted Value Average Channel AN021 Select             */
    } ADADS1_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADADC;                           /*!< A/D-Converted Value Average Count Select Register            */

    struct {
      __IO uint8_t   ADC        :  3;               /*!< Addition frequency selection bit.NOTE: AVEE bit is valid at
                                                         the only setting of ADC[2:0] bits = 001b or 011b. When average
                                                          mode is selected by setting the ADADC.AVEE bit to 1, do not
                                                          set the addition count to three times (ADADC.ADC[2:0] = 010b)        */
           uint8_t              :  5;
    } ADADC_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1;

  union {
    __IO uint16_t  ADCER;                           /*!< A/D Control Extended Register                                         */

    struct {
           uint16_t             :  5;
      __IO uint16_t  ACE        :  1;               /*!< A/D Data Register Automatic Clearing Enable                           */
           uint16_t             :  2;
      __IO uint16_t  DIAGVAL    :  2;               /*!< Self-Diagnosis Conversion Voltage Select                              */
      __IO uint16_t  DIAGLD     :  1;               /*!< Self-Diagnosis Mode Select                                            */
      __IO uint16_t  DIAGM      :  1;               /*!< Self-Diagnosis Enable                                                 */
           uint16_t             :  2;
      __IO uint16_t  ADINV      :  1;               /*!< Single-End Input A/D Converted Data Inversion Select                  */
           uint16_t             :  1;
    } ADCER_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADSTRGR;                         /*!< A/D Conversion Start Trigger Select Register                          */

    struct {
      __IO uint16_t  TRSB       :  6;               /*!< A/D Conversion Start Trigger Select for Group B Select the A/D
                                                         conversion start trigger for group B in group scan mode.              */
           uint16_t             :  2;
      __IO uint16_t  TRSA       :  6;               /*!< A/D Conversion Start Trigger Select Select the A/D conversion
                                                         start trigger in single scan mode and continuous mode. In group
                                                          scan mode, the A/D conversion start trigger for group A is selected. */
           uint16_t             :  2;
    } ADSTRGR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADEXICR;                         /*!< A/D Conversion Extended Input Control Register                        */

    struct {
      __IO uint16_t  TSSAD      :  1;               /*!< Temperature Sensor Output A/D converted Value Average
                                                         Mode Select                                                           */
      __IO uint16_t  OCSAD      :  1;               /*!< Internal Reference Voltage A/D converted Value Average
                                                         Mode Select                                                           */
           uint16_t             :  6;
      __IO uint16_t  TSSA       :  1;               /*!< Temperature Sensor Output A/D Conversion Select                       */
      __IO uint16_t  OCSA       :  1;               /*!< Internal Reference Voltage A/D Conversion Select                      */
      __IO uint16_t  TSSB       :  1;               /*!< Temperature Sensor Output A/D Conversion Select for Group B           */
      __IO uint16_t  OCSB       :  1;               /*!< Internal Reference Voltage A/D Conversion Select for Group B          */
    } ADEXICR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADANSB0;                         /*!< A/D Channel Select Register B0                                        */

    struct {
      __IO uint16_t  ANSB00     :  1;               /*!< AN000 Select                                                          */
      __IO uint16_t  ANSB01     :  1;               /*!< AN001 Select                                                          */
      __IO uint16_t  ANSB02     :  1;               /*!< AN002 Select                                                          */
      __IO uint16_t  ANSB03     :  1;               /*!< AN003 Select                                                          */
      __IO uint16_t  ANSB04     :  1;               /*!< AN004 Select                                                          */
      __IO uint16_t  ANSB05     :  1;               /*!< AN005 Select                                                          */
      __IO uint16_t  ANSB06     :  1;               /*!< AN006 Select                                                          */
      __IO uint16_t  ANSB07     :  1;               /*!< AN007 Select                                                          */
      __IO uint16_t  ANSB08     :  1;               /*!< AN008 Select                                                          */
      __IO uint16_t  ANSB09     :  1;               /*!< AN009 Select                                                          */
      __IO uint16_t  ANSB10     :  1;               /*!< AN010 Select                                                          */
      __IO uint16_t  ANSB11     :  1;               /*!< AN011 Select                                                          */
      __IO uint16_t  ANSB12     :  1;               /*!< AN012 Select                                                          */
      __IO uint16_t  ANSB13     :  1;               /*!< AN013 Select                                                          */
      __IO uint16_t  ANSB14     :  1;               /*!< AN014 Select                                                          */
      __IO uint16_t  ANSB15     :  1;               /*!< AN015 Select                                                          */
    } ADANSB0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADANSB1;                         /*!< A/D Channel Select Register B1                                        */

    struct {
      __IO uint16_t  ANSB16     :  1;               /*!< AN016 Select                                                          */
      __IO uint16_t  ANSB17     :  1;               /*!< AN017 Select                                                          */
      __IO uint16_t  ANSB18     :  1;               /*!< AN018 Select                                                          */
      __IO uint16_t  ANSB19     :  1;               /*!< AN019 Select                                                          */
      __IO uint16_t  ANSB20     :  1;               /*!< AN020 Select                                                          */
      __IO uint16_t  ANSB21     :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  ANSB22     :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  ANSB23     :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  ANSB24     :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  ANSB25     :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  ANSB26     :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  ANSB27     :  1;               /*!< AN021 Select                                                          */
    } ADANSB1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  ADDBLDR;                         /*!< A/D Data Duplication Register                                         */

    struct {
      __I  uint16_t  ADDBLDR    : 16;               /*!< This is a 16-bit read-only register for storing the result of
                                                         A/D conversion in response to the second trigger in double trigger
                                                          mode.                                                                */
    } ADDBLDR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  ADTSDR;                          /*!< A/D Temperature Sensor Data Register                                  */

    struct {
      __I  uint16_t  ADTSDR     : 16;               /*!< This is a 16-bit read-only register for storing the A/D conversion
                                                         result of temperature sensor output.                                  */
    } ADTSDR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  ADOCDR;                          /*!< A/D Internal Reference Voltage Data Register                          */

    struct {
      __I  uint16_t  ADOCDR     : 16;               /*!< This is a 16-bit read-only register for storing the A/D result
                                                         of internal reference voltage.                                        */
    } ADOCDR_b;                                     /*!< BitSize                                                               */
  };

  __I  uint16_t RESERVED16;

  union {
    __I  uint16_t  ADDRn[28];                       /*!< A/D Data Register %s                                                  */

    struct {
      __I  uint16_t  ADDR       : 16;               /*!< The ADDR register is a 16-bit read-only registers for storing
                                                         the result of A/D conversion.                                         */
    } ADDRn_b[28];                                  /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED2[7];

  union {
    __IO uint16_t  ADSHCR;                          /*!< A/D Sample and Hold Circuit Control Register                          */

    struct {
      __IO uint16_t  SSTSH      :  8;               /*!< Channel-Dedicated Sample-and-Hold Circuit Sampling Time Setting
                                                         Set the sampling time (4 to 255 states)                               */
      __IO uint16_t  SHANS      :  3;               /*!< ANn0m sample-and-hold circuit Select                                  */
    } ADSHCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED3[9];

  union {
    __IO uint8_t   ADDISCR;                         /*!< A/D Disconnection Detection Control Register                          */

    struct {
      __IO uint8_t   ADNDIS     :  4;               /*!< The charging time                                                     */
      __IO uint8_t   PCHG       :  2;               /*!< Precharge/Discharge select                                            */
           uint8_t              :  2;
    } ADDISCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED4;

  union {
    __IO uint8_t   ADSHMSR;                         /*!< A/D Sample and Hold Operation Mode Select Register                    */

    struct {
      __IO uint8_t   SHMD       :  1;               /*!< Channel-Dedicated Sample-and-Hold Circuit Operation Mode Select       */
    } ADSHMSR_b;                                    /*!< BitSize                                                               */
  };


  union {
      __IO uint8_t   ADICR;                         /*!< A/D Interrupt Control Register                                        */

      struct{
      __IO uint8_t   ADIC       :  2;               /*!< A/D Interrupt Control                                                 */
           uint8_t              :  6;
      } ADICR_b;
  };

  union {
    __IO uint8_t   ADELCCR;                         /*!< A/D Event Link Control Register                                       */

    struct {
      __IO uint8_t   ELCC       :  2;               /*!< Event Link Control                                                    */
    } ADELCCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED5;

  union {
    __IO uint16_t  ADGSPCR;                         /*!< A/D Group Scan Priority Control Register                              */

    struct {
      __IO uint16_t  PGS        :  1;               /*!< Group A priority control setting bit.Note: When the PGS bit
                                                         is to be set to 1, the ADCSR.ADCS[1:0] bits must be set to 01b
                                                          (group scan mode). If the bits are set to any other values,
                                                          proper operation is not guaranteed.                                  */
      __IO uint16_t  GBRSCN     :  1;               /*!< Group B Restart Setting(Enabled only when PGS = 1. Reserved
                                                         when PGS = 0.)                                                        */
           uint16_t             : 13;
      __IO uint16_t  GBRP       :  1;               /*!< Group B Single Scan Continuous Start(Enabled only when PGS =
                                                         1. Reserved when PGS = 0.)Note: When the GBRP bit has been set
                                                          to 1, single scan is performed continuously for group B regardless
                                                          of the setting of the GBRSCN bit.                                    */
    } ADGSPCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED6;

  union {
    __I  uint16_t  ADDBLDRA;                        /*!< A/D Data Duplication Register A                                       */

    struct {
      __I  uint16_t  ADDBLDRA   : 16;               /*!< This register is a 16-bit read-only registers for storing the
                                                         result of A/D conversion in response to the respective triggers
                                                          during extended operation in double trigger mode.                    */
    } ADDBLDRA_b;                                   /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  ADDBLDRB;                        /*!< A/D Data Duplication Register B                                       */

    struct {
      __I  uint16_t  ADDBLDRB   : 16;               /*!< This register is a 16-bit read-only registers for storing the
                                                         result of A/D conversion in response to the respective triggers
                                                          during extended operation in double trigger mode.                    */
    } ADDBLDRB_b;                                   /*!< BitSize                                                               */
  };

  __I  uint16_t  RESERVED7a;


  union {
      __I  uint8_t  ADHVREFCNT;                      /*!<A/D High-Potential/Low-Potential Reference Voltage Control Register */

   struct {
     __IO uint8_t  HVSEL        :  2;               /*!<High-Potential Reference Voltage Select bits
                                                    used to specify the high-potential reference voltage as AVCC0, VREFH0, or the internal reference voltage
                                                    (1.45 V).*/
          uint8_t               :  2;
     __IO uint8_t  LVSEL        :  1;              /*!<LVSEL bit specifies the low-potential reference voltage as AVSS0 or VREFL0*/
          uint8_t               :  2;
     __IO uint8_t  ADSLP        :  1;              /*!<The ADSLP bit transitions the A/D converter to the standby state. Set the ADSLP bit to 1 only when modifying the
                                                     ADCSR.ADHSC bit. In other cases, setting the ADSLP bit to 1 is prohibited.*/
      } ADHVREFCNT_b;                                   /*!< BitSize                                                               */
    };

   __I  uint8_t  RESERVED7;


  union {
    __IO uint8_t   ADWINMON;                        /*!< A/D Compare Function Window A/B Status Monitor Register               */

    struct {
      __IO uint8_t   MONCOMB    :  1;               /*!< Combination result monitorThis bit indicates the combination
                                                         result.This bit is valid when both window A operation and window
                                                          B operation are enabled.                                             */
           uint8_t              :  3;
      __IO uint8_t   MONCMPA    :  1;               /*!< Comparison Result Monitor A                                           */
      __IO uint8_t   MONCMPB    :  1;               /*!< Comparison Result Monitor B                                           */
    } ADWINMON_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED8[3];

  union {
    __IO uint16_t  ADCMPCR;                         /*!< A/D Compare Function Control Register                                 */

    struct {
      __IO uint16_t  CMPAB      :  2;               /*!< Window A/B Composite Conditions SettingNOTE: These bits are
                                                         valid when both window A and window B are enabled (CMPAE = 1
                                                          and CMPBE = 1).                                                      */
           uint16_t             :  7;
      __IO uint16_t  CMPBE      :  1;               /*!< Compare Window B Operation Enable                                     */
           uint16_t             :  1;
      __IO uint16_t  CMPAE      :  1;               /*!< Compare Window A Operation Enable                                     */
           uint16_t             :  1;
      __IO uint16_t  CMPBIE     :  1;               /*!< Compare B Interrupt Enable                                            */
      __IO uint16_t  WCMPE      :  1;               /*!< Window Function Setting                                               */
      __IO uint16_t  CMPAIE     :  1;               /*!< Compare A Interrupt Enable                                            */
    } ADCMPCR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADCMPANSER;                      /*!< A/D Compare Function Window A Extended Input Select Register          */

    struct {
      __IO uint8_t   CMPTSA     :  1;               /*!< Temperature sensor output Compare selection bit.                      */
      __IO uint8_t   CMPOCA     :  1;               /*!< Internal reference voltage Compare selection bit.                     */
    } ADCMPANSER_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADCMPLER;                        /*!< A/D Compare Function Window A Extended Input Comparison Condition
                                                         Setting Register                                                      */

    struct {
      __IO uint8_t   CMPLTSA    :  1;               /*!< Compare Window A Temperature Sensor Output Comparison Condition
                                                         Select                                                                */
      __IO uint8_t   CMPLOCA    :  1;               /*!< Compare Window A Internal Reference Voltage ComparisonCondition
                                                         Select                                                                */
    } ADCMPLER_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPANSR0;                      /*!< A/D Compare Function Window A Channel Select Register 0               */

    struct {
      __IO uint16_t  CMPCHA00   :  1;               /*!< AN000 Select                                                          */
      __IO uint16_t  CMPCHA01   :  1;               /*!< AN001 Select                                                          */
      __IO uint16_t  CMPCHA02   :  1;               /*!< AN002 Select                                                          */
      __IO uint16_t  CMPCHA03   :  1;               /*!< AN003 Select                                                          */
      __IO uint16_t  CMPCHA04   :  1;               /*!< AN004 Select                                                          */
      __IO uint16_t  CMPCHA05   :  1;               /*!< AN005 Select                                                          */
      __IO uint16_t  CMPCHA06   :  1;               /*!< AN006 Select                                                          */
      __IO uint16_t  CMPCHA07   :  1;               /*!< AN007 Select                                                          */
      __IO uint16_t  CMPCHA08   :  1;               /*!< AN008 Select                                                          */
      __IO uint16_t  CMPCHA09   :  1;               /*!< AN009 Select                                                          */
      __IO uint16_t  CMPCHA10   :  1;               /*!< AN010 Select                                                          */
      __IO uint16_t  CMPCHA11   :  1;               /*!< AN011 Select                                                          */
      __IO uint16_t  CMPCHA12   :  1;               /*!< AN012 Select                                                          */
      __IO uint16_t  CMPCHA13   :  1;               /*!< AN013 Select                                                          */
      __IO uint16_t  CMPCHA14   :  1;               /*!< AN014 Select                                                          */
      __IO uint16_t  CMPCHA15   :  1;               /*!< AN015 Select                                                          */
    } ADCMPANSR0_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPANSR1;                      /*!< A/D Compare Function Window A Channel Select Register 1               */

    struct {
      __IO uint16_t  CMPCHA16   :  1;               /*!< AN016 Select                                                          */
      __IO uint16_t  CMPCHA17   :  1;               /*!< AN017 Select                                                          */
      __IO uint16_t  CMPCHA18   :  1;               /*!< AN018 Select                                                          */
      __IO uint16_t  CMPCHA19   :  1;               /*!< AN019 Select                                                          */
      __IO uint16_t  CMPCHA20   :  1;               /*!< AN020 Select                                                          */
      __IO uint16_t  CMPCHA21   :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  CMPCHA22   :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  CMPCHA23   :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  CMPCHA24   :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  CMPCHA25   :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  CMPCHA26   :  1;               /*!< AN021 Select                                                          */
      __IO uint16_t  CMPCHA27   :  1;               /*!< AN021 Select                                                          */
    } ADCMPANSR1_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPLR0;                        /*!< A/D Compare Function Window A Comparison Condition Setting Register
                                                         0                                                                     */

    struct {
      __IO uint16_t  CMPLCHA00  :  1;               /*!< Comparison condition of AN000                                         */
      __IO uint16_t  CMPLCHA01  :  1;               /*!< Comparison condition of AN001                                         */
      __IO uint16_t  CMPLCHA02  :  1;               /*!< Comparison condition of AN002                                         */
      __IO uint16_t  CMPLCHA03  :  1;               /*!< Comparison condition of AN003                                         */
      __IO uint16_t  CMPLCHA04  :  1;               /*!< Comparison condition of AN004                                         */
      __IO uint16_t  CMPLCHA05  :  1;               /*!< Comparison condition of AN005                                         */
      __IO uint16_t  CMPLCHA06  :  1;               /*!< Comparison condition of AN006                                         */
      __IO uint16_t  CMPLCHA07  :  1;               /*!< Comparison condition of AN007                                         */
      __IO uint16_t  CMPLCHA08  :  1;               /*!< Comparison condition of AN008                                         */
      __IO uint16_t  CMPLCHA09  :  1;               /*!< Comparison condition of AN009                                         */
      __IO uint16_t  CMPLCHA10  :  1;               /*!< Comparison condition of AN010                                         */
      __IO uint16_t  CMPLCHA11  :  1;               /*!< Comparison condition of AN011                                         */
      __IO uint16_t  CMPLCHA12  :  1;               /*!< Comparison condition of AN012                                         */
      __IO uint16_t  CMPLCHA13  :  1;               /*!< Comparison condition of AN013                                         */
      __IO uint16_t  CMPLCHA14  :  1;               /*!< Comparison condition of AN014                                         */
      __IO uint16_t  CMPLCHA15  :  1;               /*!< Comparison condition of AN015                                         */
    } ADCMPLR0_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPLR1;                        /*!< A/D Compare Function Window A Comparison Condition Setting Register
                                                         1                                                                     */

    struct {
      __IO uint16_t  CMPLCHA16  :  1;               /*!< Comparison condition of AN016                                         */
      __IO uint16_t  CMPLCHA17  :  1;               /*!< Comparison condition of AN017                                         */
      __IO uint16_t  CMPLCHA18  :  1;               /*!< Comparison condition of AN018                                         */
      __IO uint16_t  CMPLCHA19  :  1;               /*!< Comparison condition of AN019                                         */
      __IO uint16_t  CMPLCHA20  :  1;               /*!< Comparison condition of AN020                                         */
      __IO uint16_t  CMPLCHA21  :  1;               /*!< Comparison condition of AN021                                         */
      __IO uint16_t  CMPLCHA22  :  1;               /*!< Comparison condition of AN022                                         */
      __IO uint16_t  CMPLCHA23  :  1;               /*!< Comparison condition of AN023                                         */
      __IO uint16_t  CMPLCHA24  :  1;               /*!< Comparison condition of AN024                                         */
      __IO uint16_t  CMPLCHA25  :  1;               /*!< Comparison condition of AN025                                         */
      __IO uint16_t  CMPLCHA26  :  1;               /*!< Comparison condition of AN026                                         */
      __IO uint16_t  CMPLCHA27  :  1;               /*!< Comparison condition of AN027                                         */
    } ADCMPLR1_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPDR0;                        /*!< A/D Compare Function Window A Lower-Side Level Setting Register       */

    struct {
      __IO uint16_t  ADCMPDR0   : 16;               /*!< The ADCMPDR0 register sets the reference data when the compare
                                                         window A function is used. ADCMPDR0 sets the lower-side level
                                                          of window A.                                                         */
    } ADCMPDR0_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPDR1;                        /*!< A/D Compare Function Window A Upper-Side Level Setting Register       */

    struct {
      __IO uint16_t  ADCMPDR1   : 16;               /*!< The ADCMPDR1 register sets the reference data when the compare
                                                         window A function is used. ADCMPDR1 sets the upper-side level
                                                          of window A..                                                        */
    } ADCMPDR1_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPSR0;                        /*!< A/D Compare Function Window A Channel Status Register 0               */

    struct {
      __IO uint16_t  CMPSTCHA00 :  1;               /*!< Compare window A flag of AN000                                        */
      __IO uint16_t  CMPSTCHA01 :  1;               /*!< Compare window A flag of AN001                                        */
      __IO uint16_t  CMPSTCHA02 :  1;               /*!< Compare window A flag of AN002                                        */
      __IO uint16_t  CMPSTCHA03 :  1;               /*!< Compare window A flag of AN003                                        */
      __IO uint16_t  CMPSTCHA04 :  1;               /*!< Compare window A flag of AN004                                        */
      __IO uint16_t  CMPSTCHA05 :  1;               /*!< Compare window A flag of AN005                                        */
      __IO uint16_t  CMPSTCHA06 :  1;               /*!< Compare window A flag of AN006                                        */
      __IO uint16_t  CMPSTCHA07 :  1;               /*!< Compare window A flag of AN007                                        */
      __IO uint16_t  CMPSTCHA08 :  1;               /*!< Compare window A flag of AN008                                        */
      __IO uint16_t  CMPSTCHA09 :  1;               /*!< Compare window A flag of AN009                                        */
      __IO uint16_t  CMPSTCHA10 :  1;               /*!< Compare window A flag of AN010                                        */
      __IO uint16_t  CMPSTCHA11 :  1;               /*!< Compare window A flag of AN011                                        */
      __IO uint16_t  CMPSTCHA12 :  1;               /*!< Compare window A flag of AN012                                        */
      __IO uint16_t  CMPSTCHA13 :  1;               /*!< Compare window A flag of AN013                                        */
      __IO uint16_t  CMPSTCHA14 :  1;               /*!< Compare window A flag of AN014                                        */
      __IO uint16_t  CMPSTCHA15 :  1;               /*!< Compare window A flag of AN015                                        */
    } ADCMPSR0_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPSR1;                        /*!< A/D Compare Function Window A Channel Status Register 1               */

    struct {
      __IO uint16_t  CMPSTCHA16 :  1;               /*!< Compare window A flag of AN016                                        */
      __IO uint16_t  CMPSTCHA17 :  1;               /*!< Compare window A flag of AN017                                        */
      __IO uint16_t  CMPSTCHA18 :  1;               /*!< Compare window A flag of AN018                                        */
      __IO uint16_t  CMPSTCHA19 :  1;               /*!< Compare window A flag of AN019                                        */
      __IO uint16_t  CMPSTCHA20 :  1;               /*!< Compare window A flag of AN020                                        */
      __IO uint16_t  CMPSTCHA21 :  1;               /*!< Compare window A flag of AN021                                        */
      __IO uint16_t  CMPSTCHA22 :  1;               /*!< Compare window A flag of AN022                                        */
      __IO uint16_t  CMPSTCHA23 :  1;               /*!< Compare window A flag of AN023                                        */
      __IO uint16_t  CMPSTCHA24 :  1;               /*!< Compare window A flag of AN024                                        */
      __IO uint16_t  CMPSTCHA25 :  1;               /*!< Compare window A flag of AN025                                        */
      __IO uint16_t  CMPSTCHA26 :  1;               /*!< Compare window A flag of AN026                                        */
      __IO uint16_t  CMPSTCHA27 :  1;               /*!< Compare window A flag of AN027                                        */
    } ADCMPSR1_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADCMPSER;                        /*!< A/D Compare Function Window A Extended Input Channel Status
                                                         Register                                                              */

    struct {
      __IO uint8_t   CMPSTTSA   :  1;               /*!< Compare window A Temperature Sensor Output Compare FlagWhen
                                                         window A operation is enabled (ADCMPCR.CMPAE = 1b), this bit
                                                          indicates the temperature sensor output comparison result. When
                                                          window A operation is disabled (ADCMPCR.CMPAE = 0b), comparison
                                                          conditions for CMPSTTSA are not met any time.                        */
      __IO uint8_t   CMPSTOCA   :  1;               /*!< Compare Window A Internal Reference Voltage Compare FlagWhen
                                                         window A operation is enabled (ADCMPCR.CMPAE = 1b), this bit
                                                          indicates the temperature sensor output comparison result. When
                                                          window A operation is disabled (ADCMPCR.CMPAE = 0b), comparison
                                                          conditions for CMPSTTSA are not met any time.                        */
    } ADCMPSER_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9;

  union {
    __IO uint8_t   ADCMPBNSR;                       /*!< A/D Compare Function Window B Channel Selection Register              */

    struct {
      __IO uint8_t   CMPCHB     :  6;               /*!< Compare window B channel selection bit.The channel that compares
                                                         it on the condition of compare window B is selected.                  */
           uint8_t              :  1;
      __IO uint8_t   CMPLB      :  1;               /*!< Compare window B Compare condition setting bit.                       */
    } ADCMPBNSR_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED10;

  union {
    __IO uint16_t  ADWINLLB;                        /*!< A/D Compare Function Window B Lower-Side Level Setting Register       */

    struct {
      __IO uint16_t  ADWINLLB   : 16;               /*!< This register is used to compare A window function is used to
                                                         set the lower level of the window B.                                  */
    } ADWINLLB_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADWINULB;                        /*!< A/D Compare Function Window B Upper-Side Level Setting Register       */

    struct {
      __IO uint16_t  ADWINULB   : 16;               /*!< This register is used to compare A window function is used to
                                                         set the higher level of the window B.                                 */
    } ADWINULB_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  ADCMPBSR;                        /*!< A/D Compare Function Window B Status Register                         */

    struct {
      __IO uint16_t  CMPSTB     :  1;               /*!< Compare window B flag.It is a status flag that shows the comparative
                                                         result of CH (AN000-AN027, temperature sensor, and internal
                                                          reference voltage) made the object of window B relation condition.   */
    } ADCMPBSR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED11;

  union {
    __I  uint16_t  ADBUFn[16];                      /*!< A/D Data Buffer Register [%s]                                         */

    struct {
      __I  uint16_t  ADBUF      : 16;               /*!< A/D data buffer registers (ADBUF) are 16-bit read-only registers
                                                         that sequentially store all A/D converted values. The automatic
                                                          clear function is not applied to these registers.                    */
    } ADBUFn_b[16];                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADBUFEN;                         /*!< A/D Data Buffer Enable Register                                       */

    struct {
      __IO uint8_t   BUFEN      :  1;               /*!< Data Buffer Enable                                                    */
    } ADBUFEN_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED12;

  union {
    __IO uint8_t   ADBUFPTR;                        /*!< A/D Data Buffer Pointer Register                                      */

    struct {
      __I  uint8_t   BUFPTR     :  4;               /*!< Data Buffer PointerThese bits indicate the number of data buffer
                                                         to which the next A/D converted data is transferred.                  */
      __I  uint8_t   PTROVF     :  1;               /*!< Pointer Overflow Flag                                                 */
    } ADBUFPTR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED13[10];

  union {
    __IO uint8_t   ADSSTRL;                         /*!< A/D Sampling State Register L                                         */

    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling Time Setting (AN016-AN027)                                   */
    } ADSSTRL_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADSSTRT;                         /*!< A/D Sampling State Register T                                         */

    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling Time Setting (temperature sensor output)                     */
    } ADSSTRT_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADSSTRO;                         /*!< A/D Sampling State Register O                                         */

    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling Time Setting (Internal reference voltage)                    */
    } ADSSTRO_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ADSSTR0n[16];                    /*!< A/D Sampling State Register %s (Corresponding Channel is AN00%s
                                                         )                                                                     */

    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling time setting                                                 */
    } ADSSTR0n_b[16];                               /*!< BitSize                                                               */
  };


  union {
      __IO uint16_t   ADANIM;                        /*!< A/D Channel Input Mode Select Register                               */

      struct{
      __IO uint16_t   ANIM       :  4;               /*!< Analog Channel Input Mode Select                                     */
           uint16_t              :  12;
      } ADANIM_b;
  };

  union {
      __IO uint8_t   ADCALEXE;                       /*!< A/D Calibration Execution Register                                   */

      struct{
             uint8_t                :  6;
        __IO uint8_t   CALMON       :  1;            /*!< Calibration Status Flag                                              */
        __IO uint8_t   CALEXE       :  1;            /*!< Calibration Start                                                    */
      } ADCALEXE_b;
  };

  __I  uint8_t RESERVED14;

  union {
      __IO uint8_t   VREFAMPCNT;                     /*!< A/D Dedicated Reference Voltage Circuit Control Register             */

      struct{
        __IO uint8_t   OLDETEN      :  1;            /*!< OLDET Enable                                                         */
        __IO uint8_t   VREFADCG     :  2;            /*!< VREFADCG                                                             */
        __IO uint8_t   VREFADCEN    :  1;            /*!< VREFADCEN                                                            */
        __IO uint8_t   BGREN        :  1;            /*!< BGR Enable                                                           */
             uint8_t                :  3;
      } VREFAMPCNT_b;
  };

  __I  uint16_t RESERVED15;

  union {
    __IO  uint16_t  ADRD;                            /*!< A/D Self-Diagnosis Data Register                                      */

    struct {
      __IO  uint16_t  AD         : 16;              /*!< A/D-converted value (right-justified)NOTE: Unused bits in the
                                                         AD bit field are fixed "0"                                            */
    } ADRD_b;                                       /*!< BitSize                                                               */
  };

  union {
      __IO uint8_t   ADRST;                        /*!< A/D Self-Diagnostic Status Register                                    */

      struct{
      __IO uint8_t   DIAGST     :  2;               /*!< Self-Diagnosis Status                                                 */
           uint8_t              :  6;
      } ADRST_b;
  };

  /* PGA registers added even though PGA is not present on MCU to allow SSP driver to be written
    * cleanly. The padding bits are removed since they do not mean anything anyway in this MCUs address space.*/
   union {
      __IO uint16_t  ADPGACR;                         /*!< A/D Programmable Gain Amplifier Control Register                      */

      struct {
        __IO uint16_t  P000SEL0   :  1;               /*!< A through amplifier is enable for PGA P000                            */
        __IO uint16_t  P000SEL1   :  1;               /*!< The amplifier passing is enable for PGA P000                          */
        __IO uint16_t  P000ENAMP  :  1;               /*!< Amplifier enable bit for PGA P000                                     */
        __IO uint16_t  P000GEN    :  1;               /*!< PGA P000 gain setting and enable bit                                  */
        __IO uint16_t  P001SEL0   :  1;               /*!< A through amplifier is enable for PGA P001                            */
        __IO uint16_t  P001SEL1   :  1;               /*!< The amplifier passing is enable for PGA P001                          */
        __IO uint16_t  P001ENAMP  :  1;               /*!< Amplifier enable bit for PGA P001                                     */
        __IO uint16_t  P001GEN    :  1;               /*!< PGA P001 gain setting and enable bit                                  */
        __IO uint16_t  P002SEL0   :  1;               /*!< A through amplifier is enable for PGA P002                            */
        __IO uint16_t  P002SEL1   :  1;               /*!< The amplifier passing is enable for PGA P002                          */
        __IO uint16_t  P002ENAMP  :  1;               /*!< Amplifier enable bit for PGA P002                                     */
        __IO uint16_t  P002GEN    :  1;               /*!< PGA P002 gain setting and enable bit                                  */
        __IO uint16_t  P003SEL0   :  1;               /*!< A through amplifier is enable for PGA P003                            */
        __IO uint16_t  P003SEL1   :  1;               /*!< The amplifier passing is enable for PGA P003                          */
        __IO uint16_t  P003ENAMP  :  1;               /*!< Amplifier enable bit for PGA P003                                     */
        __IO uint16_t  P003GEN    :  1;               /*!< PGA P003 gain setting and enable bit                                  */
      } ADPGACR_b;                                    /*!< BitSize                                                               */
    };

    union {
      __IO uint16_t  ADPGAGS0;                        /*!< A/D Programmable Gain Amplifier Gain Setting Register 0               */

      struct {
        __IO uint16_t  P000GAIN   :  4;               /*!< PGA P000 gain setting bit.The gain magnification of (ADPGSDCR0.P000GEN=0b)
                                                           when the shingle end is input and each PGA P000 is set. When
                                                            the differential motion is input, (ADPGSDCR0.P000GEN=1b) sets
                                                            the gain magnification when the differential motion is input
                                                            by the combination with ADPGSDCR0.P000DG 1:0.                        */
        __IO uint16_t  P001GAIN   :  4;               /*!< PGA P001 gain setting bit.The gain magnification of (ADPGSDCR0.P001GEN=0b)
                                                           when the shingle end is input and each PGA P001 is set. When
                                                            the differential motion is input, (ADPGSDCR0.P001GEN=1b) sets
                                                            the gain magnification when the differential motion is input
                                                            by the combination with ADPGSDCR0.P001DG 1:0.                        */
        __IO uint16_t  P002GAIN   :  4;               /*!< PGA P002 gain setting bit.The gain magnification of (ADPGSDCR0.P002GEN=0b)
                                                           when the shingle end is input and each PGA P002 is set. When
                                                            the differential motion is input, (ADPGSDCR0.P002GEN=1b) sets
                                                            the gain magnification when the differential motion is input
                                                            by the combination with ADPGSDCR0.P002DG 1:0.                        */
        __IO uint16_t  P003GAIN   :  4;               /*!< PGA P003 gain setting bit.The gain magnification of (ADPGSDCR0.P003GEN=0b)
                                                           when the shingle end is input and each PGA P003 is set. When
                                                            the differential motion is input, (ADPGSDCR0.P003GEN=1b) sets
                                                            the gain magnification when the differential motion is input
                                                            by the combination with ADPGSDCR0.P003DG 1:0.                        */
      } ADPGAGS0_b;                                   /*!< BitSize                                                               */
    };

    union {
      __IO uint16_t  ADPGADCR0;                       /*!< A/D Programmable Gain Amplifier Differential Input Control Register   */

      struct {
        __IO uint16_t  P000DG     :  2;               /*!< P000 Differential Input Gain SettingNOTE: When these bits are
                                                           used, set {P000DEN, P000GEN} to 11b.                                  */
             uint16_t             :  1;
        __IO uint16_t  P000DEN    :  1;               /*!< P000 Differential Input Enable                                        */
        __IO uint16_t  P001DG     :  2;               /*!< P001 Differential Input Gain SettingNOTE: When these bits are
                                                           used, set {P001DEN, P001GEN} to 11b.                                  */
             uint16_t             :  1;
        __IO uint16_t  P001DEN    :  1;               /*!< P001 Differential Input Enable                                        */
        __IO uint16_t  P002DG     :  2;               /*!< P002 Differential Input Gain SettingNOTE: When these bits are
                                                           used, set {P002DEN, P002GEN} to 11b.                                  */
             uint16_t             :  1;
        __IO uint16_t  P002DEN    :  1;               /*!< P002 Differential Input Enable                                        */
        __IO uint16_t  P003DG     :  2;               /*!< P003 Differential Input Gain SettingNOTE: When these bits are
                                                           used, set {P003DEN, P003GEN} to 11b.                                  */
             uint16_t             :  1;
        __IO uint16_t  P003DEN    :  1;               /*!< P003 Differential Input Enable                                        */
      } ADPGADCR0_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   ADPGADBS0;                       /*!< A/D Programmable Gain Amplifier Differential Input Bias Select
                                                           Register 0                                                            */

      struct {
        __IO uint8_t   P0BIAS     :  1;               /*!< Programmable Gain Amplifiers P000 to P002 Bias Voltage SelectNOTE:
                                                           This bit selects the input bias voltage value when differential
                                                            inputs are used.                                                     */
      } ADPGADBS0_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   ADPGADBS1;                       /*!< A/D Programmable Gain Amplifier Differential Input Bias Select
                                                           Register 1                                                            */

      struct {
        __IO uint8_t   P3BIAS     :  1;               /*!< Programmable Gain Amplifiers P003 Bias Voltage SelectNOTE: This
                                                           bit selects the input bias voltage value when differential inputs
                                                            are used.                                                            */
      } ADPGADBS1_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   ADREFMON;                        /*!< A/D External Reference Voltage Monitor Register                       */

      struct {
        __IO uint8_t   PGAMON     :  3;               /*!< PGA Monitor Output Enable                                             */
             uint8_t              :  1;
        __IO uint8_t   MONSEL     :  4;               /*!< Monitor output selection bit.                                         */
      } ADREFMON_b;                                   /*!< BitSize                                                               */
    };
} R_S16ADC_Type;


/* ================================================================================ */
/* ================                      R_DAC                     ================ */
/* ================================================================================ */


/**
  * @brief 12-bit D/A converter (R_DAC)
  */

typedef struct {                                    /*!< R_DAC Structure                                                       */

  union {
    __IO uint16_t  DADRn[2];                        /*!< D/A Data Register %s                                                  */

    struct {
      __IO uint16_t  DADR       : 16;               /*!< D/A Data RegisterNOTE: When DADPR.DPSEL = 0, the high-order
                                                         4 bits are fixed to 0: right justified format. When DADPR.DPSEL
                                                          = 1, the low-order 4 bits are fixed to 0: left justified format.     */
    } DADRn_b[2];                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DACR;                            /*!< D/A Control Register                                                  */

    struct {
           uint8_t              :  5;
      __IO uint8_t   DAE        :  1;               /*!< D/A Enable                                                            */
      __IO uint8_t   DAOE0      :  1;               /*!< D/A Output Enable 0                                                   */
      __IO uint8_t   DAOE1      :  1;               /*!< D/A Output Enable 1                                                   */
    } DACR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DADPR;                           /*!< DADRm Format Select Register                                          */

    struct {
           uint8_t              :  7;
      __IO uint8_t   DPSEL      :  1;               /*!< DADRm Format Select                                                   */
    } DADPR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DAADSCR;                         /*!< D/A-A/D Synchronous Start Control Register                            */

    struct {
           uint8_t              :  7;
      __IO uint8_t   DAADST     :  1;               /*!< D/A-A/D Synchronous Conversion                                        */
    } DAADSCR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DAVREFCR;                        /*!< D/A VREF Control Register                                             */

    struct {
      __IO uint8_t   REF        :  3;               /*!< D/A Reference Voltage Select                                          */
           uint8_t              :  5;
    } DAVREFCR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DAAMPCR;                         /*!< D/A Output Amplifier Control Register                                 */

    struct {
           uint8_t              :  6;
      __IO uint8_t   DAAMP0     :  1;               /*!< Amplifier Control 0                                                   */
      __IO uint8_t   DAAMP1     :  1;               /*!< Amplifier Control 1                                                   */
    } DAAMPCR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t  DAPC;                             /*!< DAPC Charge Pump Control                                              */
    
    struct {
      __IO uint8_t  PUMPEN :  1;                    /*!< D/A Charge Pump Enable                                                */
    } DAPC_b;                                       /*!< BitSize                                                               */
  };
} R_DAC_Type;

/* ================================================================================ */
/* ================                      R_DAC8                    ================ */
/* ================================================================================ */


/**
  * @brief 8-bit D/A converter (R_DAC8)
  */

typedef struct                                      /*!< DAC8 Structure */
{
    __IO uint8_t   DADRn[3];                      /*!< D/A Data Register %s */

    union
    {
        __IO uint8_t  DAM;                             /*!< D/A Mode Register */

        struct
        {
            __IO uint8_t  DAMD0 :  1;                   /*!< D/A Operation Mode 0 */
            __IO uint8_t  DAMD1 :  1;                   /*!< D/A Operation Mode 1 */
            __IO uint8_t  DAMD2 :  1;                   /*!< D/A Operation Mode 2 */

            uint8_t             :  1;

            __IO uint8_t  DACE0 :  1;                   /*!< D/A Operation Enable 0 */
            __IO uint8_t  DACE1 :  1;                   /*!< D/A Operation Enable 1 */
            __IO uint8_t  DACE2 :  1;                   /*!< D/A Operation Enable 2 */
        }  DACR_b;                                      /*!< BitSize */
    };

    uint8_t RESERVED2[2];

    union
    {
        __IO uint8_t DACADSCR;                          /*!< Synchronous Start Control Register */

        struct
        {
            __IO uint8_t DACADST : 1;                   /*!< Synchronize D/A with A/D */
        } DACADSCR_b;
    };

    union
    {
        __IO uint8_t  DACPC;                            /*!< DACPC Charge Pump Control */

        struct
        {
            __IO uint8_t  PUMPEN :  1;                   /*!< D/A Charge Pump Enable */
        } DACPC_b;
    };
} R_DAC8_Type;


/* ================================================================================ */
/* ================                      R_TSN                     ================ */
/* ================================================================================ */


/**
  * @brief Temperature Sensor (R_TSN_Control_Type).
  * This structure defines the control structure for the TSN peripheral.
  * This register is only present on the CM4 devices
  */

typedef struct {                                    /*!< R_TSN Structure                                                       */
                                                    /*!< Enable/Disable registers. Valid only on the CM4 devices             */
    union {
    __IO uint8_t   TSCR;                            /*!< Temperature Sensor Control Register                                   */

    struct {
    uint8_t              :  4;
    __IO uint8_t   TSOE       :  1;               /*!< Temperature Sensor Enable                                             */
    uint8_t              :  2;
    __IO uint8_t   TSEN       :  1;               /*!< Temperature Sensor Output Enable                                      */
    } TSCR_b;                                       /*!< BitSize                                                               */
    };
} R_TSN_Control_Type;

/**
  * @brief Temperature Sensor (R_TSN).
  * This structure defines the calibration structure for the TSN peripheral.
  * This register is only present on the CM0 devices and S5 devices
  */
typedef struct {                                    /*!< R_TSN Structure                                                       */
                                                        /*!< Calibration data registers. Valid only on the CM0 devices and S5 devices */
	union {
        struct{
           union {
              __I  uint8_t   TSCDRL;                            /*!< Calibration data register (Low)                                         */
              struct {
                __I  uint8_t   TSCDRL       :  8;               /*!< Lower byte of the calibration data.                                   */
              } TSCDRL_b;                                       /*!< BitSize                                                               */
            };

            union {
              __I  uint8_t   TSCDRH;                            /*!< Calibration data register (High)                                        */
              struct {
                __I  uint8_t   TSCDRH       :  8;               /*!< Higher byte of the calibration data. Only lower 4 bytes are valid     */
              } TSCDRH_b;                                       /*!< BitSize                                                               */
            };
            __I  uint16_t  RESERVED;
        } TSCDR_b;
      __I  uint32_t  TSCDR;
    };

} R_TSN_Calibration_Type;


/* ================================================================================ */
/* ================                     R_SCI0                     ================ */
/* ================================================================================ */


/**
  * @brief Serial Communication Interface 0 (R_SCI0)
  */

typedef struct {                                    /*!< R_SCI0 Structure                                                      */

  union {
    union {
      __IO uint8_t   SMR_SMCI;                      /*!< Serial mode register (SCMR.SMIF = 1)                                  */

      struct {
        __IO uint8_t   CKS      :  2;               /*!< Clock Select                                                          */
        __IO uint8_t   BCP      :  2;               /*!< Stop Bit Length(Valid only in asynchronous mode)                      */
        __IO uint8_t   PM       :  1;               /*!< Parity Mode (Valid only when the PE bit is 1)                         */
        __IO uint8_t   PE       :  1;               /*!< Parity Enable(Valid only in asynchronous mode)                        */
        __IO uint8_t   BLK      :  1;               /*!< Block Transfer Mode                                                   */
        __IO uint8_t   GM       :  1;               /*!< GSM Mode                                                              */
      } SMR_SMCI_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   SMR;                           /*!< Serial Mode Register (SCMR.SMIF = 0)                                  */

      struct {
        __IO uint8_t   CKS      :  2;               /*!< Clock Select                                                          */
        __IO uint8_t   MP       :  1;               /*!< Multi-Processor Mode(Valid only in asynchronous mode)                 */
        __IO uint8_t   STOP     :  1;               /*!< Stop Bit Length(Valid only in asynchronous mode)                      */
        __IO uint8_t   PM       :  1;               /*!< Parity Mode (Valid only when the PE bit is 1)                         */
        __IO uint8_t   PE       :  1;               /*!< Parity Enable(Valid only in asynchronous mode)                        */
        __IO uint8_t   CHR      :  1;               /*!< Character Length(Valid only in asynchronous mode)                     */
        __IO uint8_t   CM       :  1;               /*!< Communications Mode                                                   */
      } SMR_b;                                      /*!< BitSize                                                               */
    };
  };

  union {
    __IO uint8_t   BRR;                             /*!< Bit Rate Register                                                     */

    struct {
      __IO uint8_t   BRR        :  8;               /*!< BRR is an 8-bit register that adjusts the bit rate.                   */
    } BRR_b;                                        /*!< BitSize                                                               */
  };

  union {
    union {
      __IO uint8_t   SCR_SMCI;                      /*!< Serial Control Register (SCMR.SMIF =1)                                */

      struct {
        __IO uint8_t   CKE      :  2;               /*!< Clock Enable                                                          */
        __IO uint8_t   TEIE     :  1;               /*!< This bit should be "0" in smart card interface mode.                  */
        __IO uint8_t   MPIE     :  1;               /*!< This bit should be "0" in smart card interface mode.                  */
        __IO uint8_t   RE       :  1;               /*!< Receive Enable                                                        */
        __IO uint8_t   TE       :  1;               /*!< Transmit Enable                                                       */
        __IO uint8_t   RIE      :  1;               /*!< Receive Interrupt Enable                                              */
        __IO uint8_t   TIE      :  1;               /*!< Transmit Interrupt Enable                                             */
      } SCR_SMCI_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   SCR;                           /*!< Serial Control Register (SCMR.SMIF = 0)                               */

      struct {
        __IO uint8_t   CKE      :  2;               /*!< Clock Enable                                                          */
        __IO uint8_t   TEIE     :  1;               /*!< Transmit End Interrupt Enable                                         */
        __IO uint8_t   MPIE     :  1;               /*!< Multi-Processor Interrupt Enable(Valid in asynchronous mode
                                                         when SMR.MP = 1)                                                      */
        __IO uint8_t   RE       :  1;               /*!< Receive Enable                                                        */
        __IO uint8_t   TE       :  1;               /*!< Transmit Enable                                                       */
        __IO uint8_t   RIE      :  1;               /*!< Receive Interrupt Enable                                              */
        __IO uint8_t   TIE      :  1;               /*!< Transmit Interrupt Enable                                             */
      } SCR_b;                                      /*!< BitSize                                                               */
    };
  };

  union {
    __IO uint8_t   TDR;                             /*!< Transmit Data Register                                                */

    struct {
      __IO uint8_t   TDR        :  8;               /*!< TDR is an 8-bit register that stores transmit data.                   */
    } TDR_b;                                        /*!< BitSize                                                               */
  };

  union {
    union {
      __IO uint8_t   SSR_SMCI;                      /*!< Serial Status Register(SCMR.SMIF = 1)                                 */

      struct {
        __IO uint8_t   MPBT     :  1;               /*!< This bit should be 0 in smart card interface mode.                    */
        __I  uint8_t   MPB      :  1;               /*!< This bit should be 0 in smart card interface mode.                    */
        __I  uint8_t   TEND     :  1;               /*!< Transmit End Flag                                                     */
        __IO uint8_t   PER      :  1;               /*!< Parity Error Flag                                                     */
        __IO uint8_t   ERS      :  1;               /*!< Error Signal Status Flag                                              */
        __IO uint8_t   ORER     :  1;               /*!< Overrun Error Flag                                                    */
        __IO uint8_t   RDRF     :  1;               /*!< Receive Data Full Flag                                                */
        __IO uint8_t   TDRE     :  1;               /*!< Transmit Data Empty Flag                                              */
      } SSR_SMCI_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   SSR_FIFO;                      /*!< Serial Status Register(SCMR.SMIF = 0 and FCR.FM=1)                    */

      struct {
        __IO uint8_t   DR       :  1;               /*!< Receive Data Ready flag(Valid only in asynchronous mode(including
                                                         multi-processor) and FIFO selected)                                   */
             uint8_t            :  1;
        __IO uint8_t   TEND     :  1;               /*!< Transmit End Flag                                                     */
        __IO uint8_t   PER      :  1;               /*!< Parity Error Flag                                                     */
        __IO uint8_t   FER      :  1;               /*!< Framing Error Flag                                                    */
        __IO uint8_t   ORER     :  1;               /*!< Overrun Error Flag                                                    */
        __IO uint8_t   RDF      :  1;               /*!< Receive FIFO data full flag                                           */
        __IO uint8_t   TDFE     :  1;               /*!< Transmit FIFO data empty flag                                         */
      } SSR_FIFO_b;                                 /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   SSR;                           /*!< Serial Status Register(SCMR.SMIF = 0 and FCR.FM=0)                    */

      struct {
        __IO uint8_t   MPBT     :  1;               /*!< Multi-Processor Bit Transfer. Sets the multi-processor bit for
                                                         adding to the transmission frame                                      */
        __I  uint8_t   MPB      :  1;               /*!< Multi-Processor Bit. Value of the multi-processor bit in the
                                                         reception frame                                                       */
        __I  uint8_t   TEND     :  1;               /*!< Transmit End Flag                                                     */
        __IO uint8_t   PER      :  1;               /*!< Parity Error Flag                                                     */
        __IO uint8_t   FER      :  1;               /*!< Framing Error Flag                                                    */
        __IO uint8_t   ORER     :  1;               /*!< Overrun Error Flag                                                    */
        __IO uint8_t   RDRF     :  1;               /*!< Receive Data Full Flag                                                */
        __IO uint8_t   TDRE     :  1;               /*!< Transmit Data Empty Flag                                              */
      } SSR_b;                                      /*!< BitSize                                                               */
    };
  };

  union {
    __IO uint8_t   RDR;                             /*!< Receive Data Register                                                 */

    struct {
      __IO uint8_t   RDR        :  8;               /*!< RDR is an 8-bit register that stores receive data.                    */
    } RDR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SCMR;                            /*!< Smart Card Mode Register                                              */

    struct {
      __IO uint8_t   SMIF       :  1;               /*!< Smart Card Interface Mode Select                                      */
           uint8_t              :  1;
      __IO uint8_t   SINV       :  1;               /*!< Transmitted/Received Data InvertSet this bit to "0" if operation
                                                         is to be in simple I2C mode.                                          */
      __IO uint8_t   SDIR       :  1;               /*!< Transmitted/Received Data Transfer DirectionNOTE: The setting
                                                         is invalid and a fixed data length of 8 bits is used in modes
                                                          other than asynchronous mode.Set this bit to "1" if operation
                                                          is to be in simple I2C mode.                                         */
      __IO uint8_t   CHR1       :  1;               /*!< Character Length 1(Only valid in asynchronous mode)                   */
           uint8_t              :  2;
      __IO uint8_t   BCP2       :  1;               /*!< Base Clock Pulse 2Selects the number of base clock cycles in
                                                         combination with the SMR.BCP[1:0] bits                                */
    } SCMR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SEMR;                            /*!< Serial Extended Mode Register                                         */

    struct {
           uint8_t              :  2;
      __IO uint8_t   BRME       :  1;               /*!< Bit Modulation Enable                                                 */
      __IO uint8_t   ABCSE      :  1;               /*!< Asynchronous Mode Extended Base Clock Select1(Valid only in
                                                         asynchronous mode and SCR.CKE[1]=0)                                   */
      __IO uint8_t   ABCS       :  1;               /*!< Asynchronous Mode Base Clock Select(Valid only in asynchronous
                                                         mode)                                                                 */
      __IO uint8_t   NFEN       :  1;               /*!< Digital Noise Filter Function Enable(The NFEN bit should be
                                                         0 without simple I2C mode and asynchronous mode.)In asynchronous
                                                          mode, for RXDn input only. In simple I2C mode, for RXDn/TxDn
                                                          input.                                                               */
      __IO uint8_t   BGDM       :  1;               /*!< Baud Rate Generator Double-Speed Mode Select(Only valid the
                                                         CKE[1] bit in SCR is 0 in asynchronous mode).                         */
      __IO uint8_t   RXDESEL    :  1;               /*!< Asynchronous Start Bit Edge Detection Select(Valid only in asynchronous
                                                         mode)                                                                 */
    } SEMR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SNFR;                            /*!< Noise Filter Setting Register                                         */

    struct {
      __IO uint8_t   NFCS       :  3;               /*!< Noise Filter Clock Select                                             */
    } SNFR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SIMR1;                           /*!< I2C Mode Register 1                                                   */

    struct {
      __IO uint8_t   IICM       :  1;               /*!< Simple I2C Mode Select                                                */
           uint8_t              :  2;
      __IO uint8_t   IICDL      :  5;               /*!< SSDA Delay Output SelectCycles below are of the clock signal
                                                         from the on-chip baud rate generator.                                 */
    } SIMR1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SIMR2;                           /*!< I2C Mode Register 2                                                   */

    struct {
      __IO uint8_t   IICINTM    :  1;               /*!< I2C Interrupt Mode Select                                             */
      __IO uint8_t   IICCSC     :  1;               /*!< Clock Synchronization                                                 */
           uint8_t              :  3;
      __IO uint8_t   IICACKT    :  1;               /*!< ACK Transmission Data                                                 */
    } SIMR2_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SIMR3;                           /*!< I2C Mode Register 3                                                   */

    struct {
      __IO uint8_t   IICSTAREQ  :  1;               /*!< Start Condition Generation                                            */
      __IO uint8_t   IICRSTAREQ :  1;               /*!< Restart Condition Generation                                          */
      __IO uint8_t   IICSTPREQ  :  1;               /*!< Stop Condition Generation                                             */
      __IO uint8_t   IICSTIF    :  1;               /*!< Issuing of Start, Restart, or Stop Condition Completed Flag(When
                                                         0 is written to IICSTIF, it is cleared to 0.)                         */
      __IO uint8_t   IICSDAS    :  2;               /*!< SDA Output Select                                                     */
      __IO uint8_t   IICSCLS    :  2;               /*!< SCL Output Select                                                     */
    } SIMR3_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SISR;                            /*!< I2C Status Register                                                   */

    struct {
      __I  uint8_t   IICACKR    :  1;               /*!< ACK Reception Data Flag                                               */
    } SISR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPMR;                            /*!< SPI Mode Register                                                     */

    struct {
      __IO uint8_t   SSE        :  1;               /*!< SSn# Pin Function Enable                                              */
      __IO uint8_t   CTSE       :  1;               /*!< CTS Enable                                                            */
      __IO uint8_t   MSS        :  1;               /*!< Master or slave mode selection                                        */
           uint8_t              :  1;
      __IO uint8_t   MFF        :  1;               /*!< Mode Fault Flag                                                       */
           uint8_t              :  1;
      __IO uint8_t   CKPOL      :  1;               /*!< Clock Polarity Select                                                 */
      __IO uint8_t   CKPH       :  1;               /*!< Clock Phase Select                                                    */
    } SPMR_b;                                       /*!< BitSize                                                               */
  };

  union {
    union {
      __O  uint16_t  FTDR;                          /*!< Transmit FIFO Data Register (FCRL.FM=1)                               */

      struct {
        __O  uint16_t  TDAT     :  9;               /*!< Serial transmit data (Valid only in asynchronous mode(including
                                                         multi-processor) or clock synchronous mode, and FIFO selected)        */
        __O  uint16_t  MPBT     :  1;               /*!< Multi-processor transfer bit flag(Valid only in asynchronous
                                                         mode and SMR.MP=1 and FIFO selected)                                  */
      } FTDR_b;                                     /*!< BitSize                                                               */
    };

    union {
      __O  uint16_t  TDRHL;                         /*!< Transmit Data Register                                                */

      struct {
        __O  uint16_t  TDRL     :  8;               /*!< TDRL is a 8-bit register that stores transmit data low byte.          */
        __O  uint16_t  TDRH     :  8;               /*!< TDRH is a 8-bit register that stores transmit data high byte.         */
      } TDRHL_b;                                    /*!< BitSize                                                               */
    };
  };

  union {
    union {
      __I  uint8_t   FRDRH;                          /*!< Receive FIFO Data Register (stores High byte)                        */

      struct {

        __I  uint8_t   RDAT     :  1;                /*!< Serial receive data 9th bit(Valid only in asynchronous mode(including
                                                            multi-processor) or clock synchronous mode, and FIFO selected)     */
        __I  uint8_t   MPB      :  1;                /*!< Multi-processor bit flag(Valid only in asynchronous mode with
                                                            SMR.MP=1 and FIFO selected) It can read multi-processor bit
                                                            corresponded to serial receive data(RDATA[8:0])                    */
        __I  uint8_t   DR       :  1;                /*!< Receive data ready flag(It is same as SSR.DR)                        */
        __I  uint8_t   PER      :  1;                /*!< Parity error flag                                                    */
        __I  uint8_t   FER      :  1;                /*!< Framing error flag                                                   */
        __I  uint8_t   ORER     :  1;                /*!< Overrun error flag(It is same as SSR.ORER)                           */
        __I  uint8_t   RDF      :  1;                /*!< Receive FIFO data full flag(It is same as SSR.RDF)                   */
      } FRDRH_b;                                     /*!< BitSize                                                              */
    };

    union {
      __I  uint8_t   RDRH;                           /*!< Receive Data Register High byte.                                     */

      struct {
        __I  uint8_t   RDRH     :  8;               /*!< RDRH is an 8-bit register that stores receive data high byte.         */
      } RDRH_b;                                     /*!< BitSize                                                               */
    };
  };

  union {
    union {
      __I  uint8_t   FRDRL;                        /*!< Receive FIFO Data Register (stores Lower byte)                         */
        struct {
        __I  uint8_t   RDAT     :  8;              /*!< Serial receive data store 8-bit (Valid only in asynchronous mode
                                                     (including multi-processor) or clock synchronous mode, and FIFO selected) */
        } FRDRL_b;                                 /*!< BitSize                                                                */
    };

    union {
      __I  uint8_t   RDRL;                         /*!< Receive Data Register low byte.                                        */
        struct {
        __I  uint8_t   RDRL     :  8;              /*!< RDRL is an 8-bit register that stores receive data low byte.           */
        } RDRL_b;                                  /*!< BitSize                                                                */
    };
  };

  union {
    __IO uint8_t   MDDR;                            /*!< Modulation Duty Register                                              */

    struct {
      __IO uint8_t   MDDR       :  8;               /*!< MDDR corrects the bit rate adjusted by the BRR register.              */
    } MDDR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DCCR;                            /*!< Data Compare Match Control Register                                   */

    struct {
      __IO uint8_t   DCMF       :  1;               /*!< Data Compare Match Flag                                               */
           uint8_t              :  2;
      __IO uint8_t   DPER       :  1;               /*!< Data Compare Match Parity Error Flag                                  */
      __IO uint8_t   DFER       :  1;               /*!< Data Compare Match Framing Error Flag                                 */
           uint8_t              :  1;
      __IO uint8_t   IDSEL      :  1;               /*!< ID frame select Bit(Valid only in asynchronous mode(including
                                                         multi-processor)                                                      */
      __IO uint8_t   DCME       :  1;               /*!< Data Compare Match Enable(Valid only in asynchronous mode(including
                                                         multi-processor)                                                      */
    } DCCR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  FCR;                             /*!< FIFO Control Register                                                 */

    struct {
      __IO uint16_t  FM         :  1;               /*!< FIFO Mode Select(Valid only in asynchronous mode(including multi-processor
                                                         ) or clock synchronous mode)                                          */
      __IO uint16_t  RFRST      :  1;               /*!< Receive FIFO Data Register Reset(Valid only in FCR.FM=1)              */
      __IO uint16_t  TFRST      :  1;               /*!< Transmit FIFO Data Register Reset(Valid only in FCR.FM=1)             */
      __IO uint16_t  DRES       :  1;               /*!< Receive data ready error select bit(When detecting a reception
                                                         data ready, the interrupt request is selected.)                       */
      __IO uint16_t  TTRG       :  4;               /*!< Transmit FIFO data trigger number(Valid only in asynchronous
                                                         mode(including multi-processor) or clock synchronous mode)            */
      __IO uint16_t  RTRG       :  4;               /*!< Receive FIFO data trigger number                                      */
      __IO uint16_t  RSTRG      :  4;               /*!< RTS# Output Active Trigger Number Select(Valid only in asynchronous
                                                         mode(including multi-processor) or clock synchronous mode)            */
    } FCR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  FDR;                             /*!< FIFO Data Count Register                                              */

    struct {
      __I  uint16_t  R          :  5;               /*!< Receive FIFO Data CountIndicate the quantity of receive data
                                                         stored in FRDRH and FRDRL(Valid only in asynchronous mode(including
                                                          multi-processor) or clock synchronous mode, while FCR.FM=1)          */
           uint16_t             :  3;
      __I  uint16_t  T          :  5;               /*!< Transmit FIFO Data CountIndicate the quantity of non-transmit
                                                         data stored in FTDRH and FTDRL(Valid only in asynchronous mode(including
                                                          multi-processor) or clock synchronous mode, while FCR.FM=1)          */
    } FDR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  LSR;                             /*!< Line Status Register                                                  */

    struct {
      __I  uint16_t  ORER       :  1;               /*!< Overrun Error Flag (Valid only in asynchronous mode(including
                                                         multi-processor) or clock synchronous mode, and FIFO selected)        */
           uint16_t             :  1;
      __I  uint16_t  FNUM       :  5;               /*!< Framing Error CountIndicates the quantity of data with a framing
                                                         error among the receive data stored in the receive FIFO data
                                                          register (FRDRH and FRDRL).                                          */
           uint16_t             :  1;
      __I  uint16_t  PNUM       :  5;               /*!< Parity Error CountIndicates the quantity of data with a parity
                                                         error among the receive data stored in the receive FIFO data
                                                          register (FRDRH and FRDRL).                                          */
    } LSR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CDR;                             /*!< Compare Match Data Register                                           */

    struct {
      __IO uint16_t  CMPD       :  9;               /*!< Compare Match DataCompare data pattern for address match wake-up
                                                         function                                                              */
    } CDR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPTR;                            /*!< Serial Port Register                                                  */

    struct {
      __I  uint8_t   RXDMON     :  1;               /*!< Serial input data monitor bit(The state of the RXD terminal
                                                         is shown.)                                                            */
      __IO uint8_t   SPB2DT     :  1;               /*!< Serial port break data select bit(The output level of TxD terminal
                                                         is selected when SCR.TE = "0".)                                       */
      __IO uint8_t   SPB2IO     :  1;               /*!< Serial port break I/O bit(It's selected whether the value of
                                                         SPB2DT is output to TxD terminal.)                                    */
    } SPTR_b;                                       /*!< BitSize                                                               */
  };
} R_SCI0_Type;




/* ================================================================================ */
/* ================                     R_RSPI0                    ================ */
/* ================================================================================ */


/**
  * @brief Serial Peripheral Interface 0 (R_RSPI0)
  */

typedef struct {                                    /*!< R_RSPI0 Structure                                                     */

  union {
    __IO uint8_t   SPCR;                            /*!< RSPI Control Register                                                 */

    struct {
      __IO uint8_t   SPMS       :  1;               /*!< RSPI Mode Select                                                      */
      __IO uint8_t   TXMD       :  1;               /*!< Communications Operating Mode Select                                  */
      __IO uint8_t   MODFEN     :  1;               /*!< Mode Fault Error Detection Enable                                     */
      __IO uint8_t   MSTR       :  1;               /*!< RSPI Master/Slave Mode Select                                         */
      __IO uint8_t   SPEIE      :  1;               /*!< RSPI Error Interrupt Enable                                           */
      __IO uint8_t   SPTIE      :  1;               /*!< Transmit Buffer Empty Interrupt Enable                                */
      __IO uint8_t   SPE        :  1;               /*!< RSPI Function Enable                                                  */
      __IO uint8_t   SPRIE      :  1;               /*!< RSPI Receive Buffer Full Interrupt Enable                             */
    } SPCR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SSLP;                            /*!< RSPI Slave Select Polarity Register                                   */

    struct {
      __IO uint8_t   SSL0P      :  1;               /*!< SSL0 Signal Polarity Setting                                          */
      __IO uint8_t   SSL1P      :  1;               /*!< SSL1 Signal Polarity Setting                                          */
      __IO uint8_t   SSL2P      :  1;               /*!< SSL2 Signal Polarity Setting                                          */
      __IO uint8_t   SSL3P      :  1;               /*!< SSL3 Signal Polarity Setting                                          */
    } SSLP_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPPCR;                           /*!< RSPI Pin Control Register                                             */

    struct {
      __IO uint8_t   SPLP       :  1;               /*!< RSPI Loopback                                                         */
      __IO uint8_t   SPLP2      :  1;               /*!< RSPI Loopback 2                                                       */
           uint8_t              :  2;
      __IO uint8_t   MOIFV      :  1;               /*!< MOSI Idle Fixed Value                                                 */
      __IO uint8_t   MOIFE      :  1;               /*!< MOSI Idle Value Fixing Enable                                         */
    } SPPCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPSR;                            /*!< RSPI Status Register                                                  */

    struct {
      __IO uint8_t   OVRF       :  1;               /*!< Overrun Error Flag                                                    */
      __IO uint8_t   IDLNF      :  1;               /*!< RSPI Idle Flag                                                        */
      __IO uint8_t   MODF       :  1;               /*!< Mode Fault Error Flag                                                 */
      __IO uint8_t   PERF       :  1;               /*!< Parity Error Flag                                                     */
      __IO uint8_t   UDRF       :  1;               /*!< Underrun Error Flag(When MODF is 0, This bit is invalid.)             */
      __IO uint8_t   SPTEF      :  1;               /*!< RSPI Transmit Buffer Empty Flag                                       */
           uint8_t              :  1;
      __IO uint8_t   SPRF       :  1;               /*!< RSPI Receive Buffer Full Flag                                         */
    } SPSR_b;                                       /*!< BitSize                                                               */
  };

  union {
    union {
      __IO uint32_t  SPDR;                          /*!< RSPI Data Register                                                    */

      struct {
        __IO uint32_t  SPDR     : 32;               /*!< SPDR is the interface with the buffers that hold data for transmission
                                                         and reception by the RSPI.When accessing in word (SPDCR.SPLW=1),
                                                          access SPDR.                                                         */
      } SPDR_b;                                     /*!< BitSize                                                               */
    };

    union {
      __IO uint16_t  SPDR_HA;                       /*!< RSPI Data Register ( halfword access )                                */

      struct {
        __IO uint16_t  SPDR_HA  : 16;               /*!< SPDR is the interface with the buffers that hold data for transmission
                                                         and reception by the RSPI.When accessing in halfword (SPDCR.SPLW=0),
                                                          access SPDR_HA.                                                      */
      } SPDR_HA_b;                                  /*!< BitSize                                                               */
    };
  };

  union {
    __IO uint8_t   SPSCR;                           /*!< RSPI Sequence Control Register                                        */

    struct {
      __IO uint8_t   SPSLN      :  3;               /*!< RSPI Sequence Length SpecificationThe order in which the SPCMD0
                                                         to SPCMD07 registers are to be referenced is changed in accordance
                                                          with the sequence length that is set in these bits. The relationship
                                                          among the setting of these bits, sequence length, and SPCMD0
                                                          to SPCMD7 registers referenced by the RSPI is shown above. However,
                                                          the RSPI in slave mode always references SPCMD0.                     */
    } SPSCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __I  uint8_t   SPSSR;                           /*!< RSPI Sequence Status Register                                         */

    struct {
      __I  uint8_t   SPCP       :  3;               /*!< RSPI Command Pointer                                                  */
           uint8_t              :  1;
      __I  uint8_t   SPRCM      :  3;               /*!< RSPI Error Command                                                    */
    } SPSSR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPBR;                            /*!< RSPI Bit Rate Register                                                */

    struct {
      __IO uint8_t   SPR        :  8;               /*!< SPBR sets the bit rate in master mode.                                */
    } SPBR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPDCR;                           /*!< RSPI Data Control Register                                            */

    struct {
      __IO uint8_t   SPFC       :  2;               /*!< Number of Frames Specification                                        */
           uint8_t              :  2;
      __IO uint8_t   SPRDTD     :  1;               /*!< RSPI Receive/Transmit Data Selection                                  */
      __IO uint8_t   SPLW       :  1;               /*!< RSPI Long-Word Access/Word Access Specification                       */
    } SPDCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPCKD;                           /*!< RSPI Clock Delay Register                                             */

    struct {
      __IO uint8_t   SCKDL      :  3;               /*!< RSPCK Delay Setting                                                   */
    } SPCKD_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SSLND;                           /*!< RSPI Slave Select Negation Delay Register                             */

    struct {
      __IO uint8_t   SLNDL      :  3;               /*!< SSL Negation Delay Setting                                            */
    } SSLND_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPND;                            /*!< RSPI Next-Access Delay Register                                       */

    struct {
      __IO uint8_t   SPNDL      :  3;               /*!< RSPI Next-Access Delay Setting                                        */
    } SPND_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPCR2;                           /*!< RSPI Control Register 2                                               */

    struct {
      __IO uint8_t   SPPE       :  1;               /*!< Parity Enable                                                         */
      __IO uint8_t   SPOE       :  1;               /*!< Parity Mode                                                           */
      __IO uint8_t   SPIIE      :  1;               /*!< RSPCK Auto-Stop Function Enable                                       */
      __IO uint8_t   PTE        :  1;               /*!< RSPI Idle Interrupt Enable                                            */
      __IO uint8_t   SCKASE     :  1;               /*!< Parity Self-Testing                                                   */
    } SPCR2_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  SPCMDn[8];                       /*!< RSPI Command Register %s                                              */

    struct {
      __IO uint16_t  CPHA       :  1;               /*!< RSPCK Phase Setting                                                   */
      __IO uint16_t  CPOL       :  1;               /*!< RSPCK Polarity Setting                                                */
      __IO uint16_t  BRDV       :  2;               /*!< Bit Rate Division Setting                                             */
      __IO uint16_t  SSLA       :  3;               /*!< SSL Signal Assertion Setting                                          */
      __IO uint16_t  SSLKP      :  1;               /*!< SSL Signal Level Keeping                                              */
      __IO uint16_t  SPB        :  4;               /*!< RSPI Data Length Setting                                              */
      __IO uint16_t  LSBF       :  1;               /*!< RSPI LSB First                                                        */
      __IO uint16_t  SPNDEN     :  1;               /*!< RSPI Next-Access Delay Enable                                         */
      __IO uint16_t  SLNDEN     :  1;               /*!< SSL Negation Delay Setting Enable                                     */
      __IO uint16_t  SCKDEN     :  1;               /*!< RSPCK Delay Setting Enable                                            */
    } SPCMDn_b[8];                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   SPDCR2;                          /*!< RSPI swap setting bit.                                                */

    struct {
      __IO uint8_t   BYSW        :  1;              /*!< BitSize                                                               */
    } SPDCR2_b;
  };
} R_RSPI0_Type;


/* ================================================================================ */
/* ================                      R_CRC                     ================ */
/* ================================================================================ */


/**
  * @brief CRC Calculator (R_CRC)
  */

typedef struct {                                    /*!< R_CRC Structure                                                       */

  union {
    __IO uint8_t   CRCCR0;                          /*!< CRC Control Register0                                                 */

    struct {
      __IO uint8_t   GPS        :  3;               /*!< CRC Generating Polynomial Switching                                   */
           uint8_t              :  3;
      __IO uint8_t   LMS        :  1;               /*!< CRC Calculation Switching                                             */
      __O  uint8_t   DORCIR     :  1;               /*!< CRCDOR Register Clear                                                 */
    } CRCCR0_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CRCCR1;                          /*!< CRC Control Register1                                                 */

    struct {
           uint8_t              :  6;
      __IO uint8_t   CRCSWR     :  1;               /*!< Snoop-on-write/read switch bit                                        */
      __IO uint8_t   CRCSEN     :  1;               /*!< Snoop enable bit                                                      */
    } CRCCR1_b;                                     /*!< BitSize                                                               */
  };

  union {
    __I  uint16_t  RESERVED;

    union {
      __IO uint32_t  CRCDIR;                        /*!< CRC Data Input Register                                               */

      struct {
        __IO uint32_t  CRCDIR   : 32;               /*!< Calculation input Data (Case of CRC-32, CRC-32C )                     */
      } CRCDIR_b;                                   /*!< BitSize                                                               */
    };
    __I  uint16_t  RESERVED1;

    union {
      __IO uint8_t   CRCDIR_BY;                     /*!< CRC Data Input Register (byte access)                                 */

      struct {
        __IO uint8_t   CRCDIR_BY:  8;               /*!< Calculation input Data ( Case of CRC-8, CRC-16 or CRC-CCITT
                                                         )                                                                     */
      } CRCDIR_BY_b;                                /*!< BitSize                                                               */
    };
  };

  union {
    union {
      __IO uint32_t  CRCDOR;                        /*!< CRC Data Output Register                                              */

      struct {
        __IO uint32_t  CRCDOR   : 32;               /*!< Calculation output Data (Case of CRC-32, CRC-32C )                    */
      } CRCDOR_b;                                   /*!< BitSize                                                               */
    };

    union {
      __IO uint16_t  CRCDOR_HA;                     /*!< CRC Data Output Register (halfword access)                            */

      struct {
        __IO uint16_t  CRCDOR_HA: 16;               /*!< Calculation output Data (Case of CRC-16 or CRC-CCITT )                */
      } CRCDOR_HA_b;                                /*!< BitSize                                                               */
    };

    union {
      __IO uint8_t   CRCDOR_BY;                     /*!< CRC Data Output Register (Low Upper Byte)                             */

      struct {
        __IO uint8_t   CRCDOR_BY:  8;               /*!< Calculation output Data (Case of CRC-8 )                              */
      } CRCDOR_BY_b;                                /*!< BitSize                                                               */
    };
  };

  union {
    __IO uint16_t  CRCSAR;                          /*!< Snoop Address Register                                                */

    struct {
      __IO uint16_t  CRCSA      : 14;               /*!< snoop address bitSet the I/O register address to snoop                */
    } CRCSAR_b;                                     /*!< BitSize                                                               */
  };
} R_CRC_Type;


/* ================================================================================ */
/* ================                     R_GPTB0                    ================ */
/* ================================================================================ */


/**
  * @brief General PWM Timer 0 (Type-B) (R_GPTB0)
  */

typedef struct {                                    /*!< R_GPTB0 Structure                                                     */

  union {
    __IO uint32_t  GTWP;                            /*!< General PWM Timer Write-Protection Register                           */

    struct {
      __IO uint32_t  WP         :  1;               /*!< Register Write Disable                                                */
           uint32_t             :  7;
      __O  uint32_t  PRKEY      :  8;               /*!< GTWP Key Code                                                         */
      __IO uint32_t             :  16;
    } GTWP_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTSTR;                           /*!< General PWM Timer Software Start Register                             */

    struct {
      __IO uint32_t  CSTRT0     :  1;               /*!< Channel 0 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT1     :  1;               /*!< Channel 1 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT2     :  1;               /*!< Channel 2 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT3     :  1;               /*!< Channel 3 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT4     :  1;               /*!< Channel 4 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT5     :  1;               /*!< Channel 5 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT6     :  1;               /*!< Channel 6 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT7     :  1;               /*!< Channel 7 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT8     :  1;               /*!< Channel 8 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT9     :  1;               /*!< Channel 9 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT10    :  1;               /*!< Channel 10 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT11    :  1;               /*!< Channel 11 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT12    :  1;               /*!< Channel 12 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t  CSTRT13    :  1;               /*!< Channel 13 GTCNT Count StartRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter stop. 1 means counter
                                                          running.                                                             */
      __IO uint32_t             :  18;
    } GTSTR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTSTP;                           /*!< General PWM Timer Software Stop Register                              */

    struct {
      __IO uint32_t  CSTOP0     :  1;               /*!< Channel 0 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP1     :  1;               /*!< Channel 1 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP2     :  1;               /*!< Channel 2 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP3     :  1;               /*!< Channel 3 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP4     :  1;               /*!< Channel 4 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP5     :  1;               /*!< Channel 5 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP6     :  1;               /*!< Channel 6 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP7     :  1;               /*!< Channel 7 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP8     :  1;               /*!< Channel 8 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP9     :  1;               /*!< Channel 9 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP10    :  1;               /*!< Channel 10 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP11    :  1;               /*!< Channel 11 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP12    :  1;               /*!< Channel 12 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t  CSTOP13    :  1;               /*!< Channel 13 GTCNT Count StopRead data shows each channel's counter
                                                         status (GTCR.CST bit). 0 means counter running. 1 means counter
                                                          stop.                                                                */
      __IO uint32_t             :  18;
    } GTSTP_b;                                      /*!< BitSize                                                               */
  };

  union {
    __O  uint32_t  GTCLR;                           /*!< General PWM Timer Software Clear Register                             */

    struct {
      __O  uint32_t  CCLR0      :  1;               /*!< Channel 0 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR1      :  1;               /*!< Channel 1 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR2      :  1;               /*!< Channel 2 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR3      :  1;               /*!< Channel 3 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR4      :  1;               /*!< Channel 4 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR5      :  1;               /*!< Channel 5 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR6      :  1;               /*!< Channel 6 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR7      :  1;               /*!< Channel 7 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR8      :  1;               /*!< Channel 8 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR9      :  1;               /*!< Channel 9 GTCNT Count Clear                                           */
      __O  uint32_t  CCLR10     :  1;               /*!< Channel 10 GTCNT Count Clear                                          */
      __O  uint32_t  CCLR11     :  1;               /*!< Channel 11 GTCNT Count Clear                                          */
      __O  uint32_t  CCLR12     :  1;               /*!< Channel 12 GTCNT Count Clear                                          */
      __O  uint32_t  CCLR13     :  1;               /*!< Channel 13 GTCNT Count Clear                                          */
      __O uint32_t              :  18;
    } GTCLR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTSSR;                           /*!< General PWM Timer Start Source Select Register                        */

    struct {
      __IO uint32_t  SSGTRGAR   :  1;               /*!< GTETRGA Pin Rising Input Source Counter Start Enable                  */
      __IO uint32_t  SSGTRGAF   :  1;               /*!< GTETRGA Pin Falling Input Source Counter Start Enable                 */
      __IO uint32_t  SSGTRGBR   :  1;               /*!< GTETRGB Pin Rising Input Source Counter Start Enable                  */
      __IO uint32_t  SSGTRGBF   :  1;               /*!< GTETRGB Pin Falling Input Source Counter Start Enable                 */
      __IO uint32_t  SSGTRGCR   :  1;               /*!< GTETRGC Pin Rising Input Source Counter Start Enable                  */
      __IO uint32_t  SSGTRGCF   :  1;               /*!< GTETRGC Pin Falling Input Source Counter Start Enable                 */
      __IO uint32_t  SSGTRGDR   :  1;               /*!< GTETRGD Pin Rising Input Source Counter Start Enable                  */
      __IO uint32_t  SSGTRGDF   :  1;               /*!< GTETRGD Pin Falling Input Source Counter Start Enable                 */
      __IO uint32_t  SSCARBL    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value Low Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSCARBH    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value High Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSCAFBL    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value Low Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSCAFBH    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value High Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSCBRAL    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value Low Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSCBRAH    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value High Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSCBFAL    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value Low Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSCBFAH    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value High Source Counter
                                                         Start Enable                                                          */
      __IO uint32_t  SSELCA     :  1;               /*!< ELCA Event Source Counter Start Enable                                */
      __IO uint32_t  SSELCB     :  1;               /*!< ELCB Event Source Counter Start Enable                                */
      __IO uint32_t  SSELCC     :  1;               /*!< ELCC Event Source Counter Start Enable                                */
      __IO uint32_t  SSELCD     :  1;               /*!< ELCD Event Source Counter Start Enable                                */
      __IO uint32_t  SSELCE     :  1;               /*!< ELCE Event Source Counter Start Enable                                */
      __IO uint32_t  SSELCF     :  1;               /*!< ELCF Event Source Counter Start Enable                                */
      __IO uint32_t  SSELCG     :  1;               /*!< ELCG Event Source Counter Start Enable                                */
      __IO uint32_t  SSELCH     :  1;               /*!< ELCH Event Source Counter Start Enable                                */
           uint32_t             :  7;
      __IO uint32_t  CSTRT      :  1;               /*!< Software Source Counter Start Enable                                  */
    } GTSSR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTPSR;                           /*!< General PWM Timer Stop Source Select Register                         */

    struct {
      __IO uint32_t  PSGTRGAR   :  1;               /*!< GTETRGA Pin Rising Input Source Counter Stop Enable                   */
      __IO uint32_t  PSGTRGAF   :  1;               /*!< GTETRGA Pin Falling Input Source Counter Stop Enable                  */
      __IO uint32_t  PSGTRGBR   :  1;               /*!< GTETRGB Pin Rising Input Source Counter Stop Enable                   */
      __IO uint32_t  PSGTRGBF   :  1;               /*!< GTETRGB Pin Falling Input Source Counter Stop Enable                  */
      __IO uint32_t  PSGTRGCR   :  1;               /*!< GTETRGC Pin Rising Input Source Counter Stop Enable                   */
      __IO uint32_t  PSGTRGCF   :  1;               /*!< GTETRGC Pin Falling Input Source Counter Stop Enable                  */
      __IO uint32_t  PSGTRGDR   :  1;               /*!< GTETRGD Pin Rising Input Source Counter Stop Enable                   */
           uint32_t             :  1;
      __IO uint32_t  PSCARBL    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value Low Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSCARBH    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value High Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSCAFBL    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value Low Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSCAFBH    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value High Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSCBRAL    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value Low Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSCBRAH    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value High Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSCBFAL    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value Low Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSCBFAH    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value High Source Counter
                                                         Stop Enable                                                           */
      __IO uint32_t  PSELCA     :  1;               /*!< ELCA Event Source Counter Stop Enable                                 */
      __IO uint32_t  PSELCB     :  1;               /*!< ELCB Event Source Counter Stop Enable                                 */
      __IO uint32_t  PSELCC     :  1;               /*!< ELCC Event Source Counter Stop Enable                                 */
      __IO uint32_t  PSELCD     :  1;               /*!< ELCD Event Source Counter Stop Enable                                 */
      __IO uint32_t  PSELCE     :  1;               /*!< ELCE Event Source Counter Stop Enable                                 */
      __IO uint32_t  PSELCF     :  1;               /*!< ELCF Event Source Counter Stop Enable                                 */
      __IO uint32_t  PSELCG     :  1;               /*!< ELCG Event Source Counter Stop Enable                                 */
      __IO uint32_t  PSELCH     :  1;               /*!< ELCH Event Source Counter Stop Enable                                 */
           uint32_t             :  7;
      __IO uint32_t  CSTOP      :  1;               /*!< Software Source Counter Stop Enable                                   */
    } GTPSR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCSR;                           /*!< General PWM Timer Clear Source Select Register                        */

    struct {
      __IO uint32_t  CSGTRGAR   :  1;               /*!< GTETRGA Pin Rising Input Source Counter Clear Enable                  */
      __IO uint32_t  CSGTRGAF   :  1;               /*!< GTETRGA Pin Falling Input Source Counter Clear Enable                 */
      __IO uint32_t  CSGTRGBR   :  1;               /*!< GTETRGB Pin Rising Input Source Counter Clear Enable                  */
      __IO uint32_t  CSGTRGBF   :  1;               /*!< GTETRGB Pin Falling Input Source Counter Clear Enable                 */
      __IO uint32_t  CSGTRGCR   :  1;               /*!< GTETRGC Pin Rising Input Source Counter Clear Enable                  */
      __IO uint32_t  CSGTRGCF   :  1;               /*!< GTETRGC Pin Falling Input Source Counter Clear Enable                 */
      __IO uint32_t  CSGTRGDR   :  1;               /*!< GTETRGD Pin Rising Input Source Counter Clear Enable                  */
      __IO uint32_t  CSGTRGDF   :  1;               /*!< GTETRGD Pin Falling Input Source Counter Clear Enable                 */
      __IO uint32_t  CSCARBL    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value Low Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSCARBH    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value High Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSCAFBL    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value Low Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSCAFBH    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value High Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSCBRAL    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value Low Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSCBRAH    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value High Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSCBFAL    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value Low Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSCBFAH    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value High Source Counter
                                                         Clear Enable                                                          */
      __IO uint32_t  CSELCA     :  1;               /*!< ELCA Event Source Counter Clear Enable                                */
      __IO uint32_t  CSELCB     :  1;               /*!< ELCB Event Source Counter Clear Enable                                */
      __IO uint32_t  CSELCC     :  1;               /*!< ELCC Event Source Counter Clear Enable                                */
      __IO uint32_t  CSELCD     :  1;               /*!< ELCD Event Source Counter Clear Enable                                */
      __IO uint32_t  CSELCE     :  1;               /*!< ELCE Event Source Counter Clear Enable                                */
      __IO uint32_t  CSELCF     :  1;               /*!< ELCF Event Source Counter Clear Enable                                */
      __IO uint32_t  CSELCG     :  1;               /*!< ELCG Event Source Counter Clear Enable                                */
      __IO uint32_t  CSELCH     :  1;               /*!< ELCH Event Source Counter Clear Enable                                */
           uint32_t             :  7;
      __IO uint32_t  CCLR       :  1;               /*!< Software Source Counter Clear Enable                                  */
    } GTCSR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTUPSR;                          /*!< General PWM Timer Up Count Source Select Register                     */

    struct {
      __IO uint32_t  USGTRGAR   :  1;               /*!< GTETRGA Pin Rising Input Source Counter Count Up Enable               */
      __IO uint32_t  USGTRGAF   :  1;               /*!< GTETRGA Pin Falling Input Source Counter Count Up Enable              */
      __IO uint32_t  USGTRGBR   :  1;               /*!< GTETRGB Pin Rising Input Source Counter Count Up Enable               */
      __IO uint32_t  USGTRGBF   :  1;               /*!< GTETRGB Pin Falling Input Source Counter Count Up Enable              */
      __IO uint32_t  USGTRGCR   :  1;               /*!< GTETRGC Pin Rising Input Source Counter Count Up Enable               */
      __IO uint32_t  USGTRGCF   :  1;               /*!< GTETRGC Pin Falling Input Source Counter Count Up Enable              */
      __IO uint32_t  USGTRGDR   :  1;               /*!< GTETRGD Pin Rising Input Source Counter Count Up Enable               */
      __IO uint32_t  USGTRGDF   :  1;               /*!< GTETRGD Pin Falling Input Source Counter Count Up Enable              */
      __IO uint32_t  USCARBL    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value Low Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USCARBH    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value High Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USCAFBL    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value Low Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USCAFBH    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value High Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USCBRAL    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value Low Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USCBRAH    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value High Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USCBFAL    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value Low Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USCBFAH    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value High Source Counter
                                                         Count Up Enable                                                       */
      __IO uint32_t  USELCA     :  1;               /*!< ELCA Event Source Counter Count Up Enable                             */
      __IO uint32_t  USELCB     :  1;               /*!< ELCB Event Source Counter Count Up Enable                             */
      __IO uint32_t  USELCC     :  1;               /*!< ELCC Event Source Counter Count Up Enable                             */
      __IO uint32_t  USELCD     :  1;               /*!< ELCD Event Source Counter Count Up Enable                             */
      __IO uint32_t  USELCE     :  1;               /*!< ELCE Event Source Counter Count Up Enable                             */
      __IO uint32_t  USELCF     :  1;               /*!< ELCF Event Source Counter Count Up Enable                             */
      __IO uint32_t  USELCG     :  1;               /*!< ELCG Event Source Counter Count Up Enable                             */
      __IO uint32_t  USELCH     :  1;               /*!< ELCH Event Source Counter Count Up Enable                             */
    } GTUPSR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTDNSR;                          /*!< General PWM Timer Down Count Source Select Register                   */

    struct {
      __IO uint32_t  DSGTRGAR   :  1;               /*!< GTETRGA Pin Rising Input Source Counter Count Down Enable             */
      __IO uint32_t  DSGTRGAF   :  1;               /*!< GTETRGA Pin Falling Input Source Counter Count Down Enable            */
      __IO uint32_t  DSGTRGBR   :  1;               /*!< GTETRGB Pin Rising Input Source Counter Count Down Enable             */
      __IO uint32_t  DSGTRGBF   :  1;               /*!< GTETRGB Pin Falling Input Source Counter Count Down Enable            */
      __IO uint32_t  DSGTRGCR   :  1;               /*!< GTETRGC Pin Rising Input Source Counter Count Down Enable             */
      __IO uint32_t  DSGTRGCF   :  1;               /*!< GTETRGC Pin Falling Input Source Counter Count Down Enable            */
      __IO uint32_t  DSGTRGDR   :  1;               /*!< GTETRGD Pin Rising Input Source Counter Count Down Enable             */
      __IO uint32_t  DSGTRGDF   :  1;               /*!< GTETRGD Pin Falling Input Source Counter Count Down Enable            */
      __IO uint32_t  DSCARBL    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value Low Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSCARBH    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value High Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSCAFBL    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value Low Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSCAFBH    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value High Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSCBRAL    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value Low Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSCBRAH    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value High Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSCBFAL    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value Low Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSCBFAH    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value High Source Counter
                                                         Count Down Enable                                                     */
      __IO uint32_t  DSELCA     :  1;               /*!< ELCA Event Source Counter Count Down Enable                           */
      __IO uint32_t  DSELCB     :  1;               /*!< ELCB Event Source Counter Count Down Enable                           */
      __IO uint32_t  DSELCC     :  1;               /*!< ELCC Event Source Counter Count Down Enable                           */
      __IO uint32_t  DSELCD     :  1;               /*!< ELCD Event Source Counter Count Down Enable                           */
      __IO uint32_t  DSELCE     :  1;               /*!< ELCE Event Source Counter Count Down Enable                           */
      __IO uint32_t  DSELCF     :  1;               /*!< ELCF Event Source Counter Count Down Enable                           */
      __IO uint32_t  DSELCG     :  1;               /*!< ELCG Event Source Counter Count Down Enable                           */
      __IO uint32_t  DSELCH     :  1;               /*!< ELCH Event Source Counter Count Down Enable                           */
    } GTDNSR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTICASR;                         /*!< General PWM Timer Input Capture Source Select Register A              */

    struct {
      __IO uint32_t  ASGTRGAR   :  1;               /*!< GTETRGA Pin Rising Input Source GTCCRA Input Capture Enable           */
      __IO uint32_t  ASGTRGAF   :  1;               /*!< GTETRGA Pin Falling Input Source GTCCRA Input Capture Enable          */
      __IO uint32_t  ASGTRGBR   :  1;               /*!< GTETRGB Pin Rising Input Source GTCCRA Input Capture Enable           */
      __IO uint32_t  ASGTRGBF   :  1;               /*!< GTETRGB Pin Falling Input Source GTCCRA Input Capture Enable          */
      __IO uint32_t  ASGTRGCR   :  1;               /*!< GTETRGC Pin Rising Input Source GTCCRA Input Capture Enable           */
      __IO uint32_t  ASGTRGCF   :  1;               /*!< GTETRGC Pin Falling Input Source GTCCRA Input Capture Enable          */
      __IO uint32_t  ASGTRGDR   :  1;               /*!< GTETRGD Pin Rising Input Source GTCCRA Input Capture Enable           */
      __IO uint32_t  ASGTRGDF   :  1;               /*!< GTETRGD Pin Falling Input Source GTCCRA Input Capture Enable          */
      __IO uint32_t  ASCARBL    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value Low Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASCARBH    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value High Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASCAFBL    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value Low Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASCAFBH    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value High Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASCBRAL    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value Low Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASCBRAH    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value High Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASCBFAL    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value Low Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASCBFAH    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value High Source GTCCRA
                                                         Input Capture Enable                                                  */
      __IO uint32_t  ASELCA     :  1;               /*!< ELCA Event Source GTCCRA Input Capture Enable                         */
      __IO uint32_t  ASELCB     :  1;               /*!< ELCB Event Source GTCCRA Input Capture Enable                         */
      __IO uint32_t  ASELCC     :  1;               /*!< ELCC Event Source GTCCRA Input Capture Enable                         */
      __IO uint32_t  ASELCD     :  1;               /*!< ELCD Event Source GTCCRA Input Capture Enable                         */
      __IO uint32_t  ASELCE     :  1;               /*!< ELCE Event Source GTCCRA Input Capture Enable                         */
      __IO uint32_t  ASELCF     :  1;               /*!< ELCF Event Source GTCCRA Input Capture Enable                         */
      __IO uint32_t  ASELCG     :  1;               /*!< ELCG Event Source GTCCRA Input Capture Enable                         */
      __IO uint32_t  ASELCH     :  1;               /*!< ELCH Event Source GTCCRA Input Capture Enable                         */
    } GTICASR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTICBSR;                         /*!< General PWM Timer Input Capture Source Select Register B              */

    struct {
      __IO uint32_t  BSGTRGAR   :  1;               /*!< GTETRGA Pin Rising Input Source GTCCRB Input Capture Enable           */
      __IO uint32_t  BSGTRGAF   :  1;               /*!< GTETRGA Pin Falling Input Source GTCCRB Input Capture Enable          */
      __IO uint32_t  BSGTRGBR   :  1;               /*!< GTETRGB Pin Rising Input Source GTCCRB Input Capture Enable           */
      __IO uint32_t  BSGTRGBF   :  1;               /*!< GTETRGB Pin Falling Input Source GTCCRB Input Capture Enable          */
      __IO uint32_t  BSGTRGCR   :  1;               /*!< GTETRGC Pin Rising Input Source GTCCRB Input Capture Enable           */
      __IO uint32_t  BSGTRGCF   :  1;               /*!< GTETRGC Pin Falling Input Source GTCCRB Input Capture Enable          */
      __IO uint32_t  BSGTRGDR   :  1;               /*!< GTETRGD Pin Rising Input Source GTCCRB Input Capture Enable           */
      __IO uint32_t  BSGTRGDF   :  1;               /*!< GTETRGD Pin Falling Input Source GTCCRB Input Capture Enable          */
      __IO uint32_t  BSCARBL    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value Low Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSCARBH    :  1;               /*!< GTIOCA Pin Rising Input during GTIOCB Value High Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSCAFBL    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value Low Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSCAFBH    :  1;               /*!< GTIOCA Pin Falling Input during GTIOCB Value High Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSCBRAL    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value Low Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSCBRAH    :  1;               /*!< GTIOCB Pin Rising Input during GTIOCA Value High Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSCBFAL    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value Low Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSCBFAH    :  1;               /*!< GTIOCB Pin Falling Input during GTIOCA Value High Source GTCCRB
                                                         Input Capture Enable                                                  */
      __IO uint32_t  BSELCA     :  1;               /*!< ELCA Event Source GTCCRB Input Capture Enable                         */
      __IO uint32_t  BSELCB     :  1;               /*!< ELCB Event Source GTCCRB Input Capture Enable                         */
      __IO uint32_t  BSELCC     :  1;               /*!< ELCC Event Source GTCCRB Input Capture Enable                         */
      __IO uint32_t  BSELCD     :  1;               /*!< ELCD Event Source GTCCRB Input Capture Enable                         */
      __IO uint32_t  BSELCE     :  1;               /*!< ELCE Event Source GTCCRB Input Capture Enable                         */
      __IO uint32_t  BSELCF     :  1;               /*!< ELCF Event Source GTCCRB Input Capture Enable                         */
      __IO uint32_t  BSELCG     :  1;               /*!< ELCG Event Source GTCCRB Input Capture Enable                         */
      __IO uint32_t  BSELCH     :  1;               /*!< ELCH Event Source GTCCRB Input Capture Enable                         */
    } GTICBSR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCR;                            /*!< General PWM Timer Control Register                                    */

    struct {
      __IO uint32_t  CST        :  1;               /*!< Count Start                                                           */
           uint32_t             :  7;
      __IO uint32_t  ICDS       :  1;               /*!< Input Capture Behavior Select During Counter Stop                     */
           uint32_t             :  7;
      __IO uint32_t  MD         :  3;               /*!< Mode Select                                                           */
           uint32_t             :  5;
      __IO uint32_t  TPCS       :  3;               /*!< Timer Prescaler Select                                                */
    } GTCR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTUDDTYC;                        /*!< General PWM Timer Count Direction and Duty Setting Register           */

    struct {
      __IO uint32_t  UD         :  1;               /*!< Count Direction Setting                                               */
      __IO uint32_t  UDF        :  1;               /*!< Forcible Count Direction Setting                                      */
           uint32_t             : 14;
      __IO uint32_t  OADTY      :  2;               /*!< GTIOCA Output Duty Setting                                            */
      __IO uint32_t  OADTYF     :  1;               /*!< Forcible GTIOCA Output Duty Setting                                   */
      __IO uint32_t  OADTYR     :  1;               /*!< GTIOCA Output Value Selecting after Releasing 0%/100% Duty Setting    */
           uint32_t             :  4;
      __IO uint32_t  OBDTY      :  2;               /*!< GTIOCB Output Duty Setting                                            */
      __IO uint32_t  OBDTYF     :  1;               /*!< Forcible GTIOCB Output Duty Setting                                   */
      __IO uint32_t  OBDTYR     :  1;               /*!< GTIOCB Output Value Selecting after Releasing 0%/100% Duty Setting    */
    } GTUDDTYC_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTIOR;                           /*!< General PWM Timer I/O Control Register                                */

    struct {
      __IO uint32_t  GTIOA      :  5;               /*!< GTIOCA Pin Function Select                                            */
           uint32_t             :  1;
      __IO uint32_t  OADFLT     :  1;               /*!< GTIOCA Pin Output Value Setting at the Count Stop                     */
      __IO uint32_t  OAHLD      :  1;               /*!< GTIOCA Pin Output Setting at the Start/Stop Count                     */
      __IO uint32_t  OAE        :  1;               /*!< GTIOCA Pin Output Enable                                              */
      __IO uint32_t  OADF       :  2;               /*!< GTIOCA Pin Disable Value Setting                                      */
           uint32_t             :  2;
      __IO uint32_t  NFAEN      :  1;               /*!< Noise Filter A Enable                                                 */
      __IO uint32_t  NFCSA      :  2;               /*!< Noise Filter A Sampling Clock Select                                  */
      __IO uint32_t  GTIOB      :  5;               /*!< GTIOCB Pin Function Select                                            */
           uint32_t             :  1;
      __IO uint32_t  OBDFLT     :  1;               /*!< GTIOCB Pin Output Value Setting at the Count Stop                     */
      __IO uint32_t  OBHLD      :  1;               /*!< GTIOCB Pin Output Setting at the Start/Stop Count                     */
      __IO uint32_t  OBE        :  1;               /*!< GTIOCB Pin Output Enable                                              */
      __IO uint32_t  OBDF       :  2;               /*!< GTIOCB Pin Disable Value Setting                                      */
           uint32_t             :  2;
      __IO uint32_t  NFBEN      :  1;               /*!< Noise Filter B Enable                                                 */
      __IO uint32_t  NFCSB      :  2;               /*!< Noise Filter B Sampling Clock Select                                  */
    } GTIOR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTINTAD;                         /*!< General PWM Timer Interrupt Output Setting Register                   */

    struct {
           uint32_t             : 24;
      __IO uint32_t  GRP        :  2;               /*!< Output Disable Source Select                                          */
           uint32_t             :  3;
      __IO uint32_t  GRPABH     :  1;               /*!< Same Time Output Level High Disable Request Enable                    */
      __IO uint32_t  GRPABL     :  1;               /*!< Same Time Output Level Low Disable Request Enable                     */
    } GTINTAD_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTST;                            /*!< General PWM Timer Status Register                                     */

    struct {
      __IO uint32_t  TCFA       :  1;               /*!< Input Capture/Compare Match Flag A                                    */
      __IO uint32_t  TCFB       :  1;               /*!< Input Capture/Compare Match Flag B                                    */
      __IO uint32_t  TCFC       :  1;               /*!< Input Compare Match Flag C                                            */
      __IO uint32_t  TCFD       :  1;               /*!< Input Compare Match Flag D                                            */
      __IO uint32_t  TCFE       :  1;               /*!< Input Compare Match Flag E                                            */
      __IO uint32_t  TCFF       :  1;               /*!< Input Compare Match Flag F                                            */
      __IO uint32_t  TCPFO      :  1;               /*!< Overflow Flag                                                         */
      __IO uint32_t  TCFPU      :  1;               /*!< Underflow Flag                                                        */
           uint32_t             :  7;
      __I  uint32_t  TUCF       :  1;               /*!< Count Direction Flag                                                  */
      __IO uint32_t  ADTRAUF    :  1;               /*!< GTADTRA Compare Match (Up-Counting) A/D Converter Start Request
                                                         Interrupt Enable                                                      */
      __IO uint32_t  ADTRADF    :  1;               /*!< GTADTRA Compare Match(Down-Counting) A/D Converter Start Request
                                                         Flag                                                                  */
      __IO uint32_t  ADTRBUF    :  1;               /*!< GTADTRB Compare Match(Up-Counting) A/D Converter Start Request
                                                         Flag                                                                  */
      __IO uint32_t  ADTRBDF    :  1;               /*!< GTADTRB Compare Match(Down-Counting) A/D Converter Start Request
                                                         Flag                                                                  */
           uint32_t             :  4;
      __I  uint32_t  ODF        :  1;               /*!< Output Disable Flag                                                   */
           uint32_t             :  4;
      __I  uint32_t  OABHF      :  1;               /*!< Same Time Output Level High Disable Request Enable                    */
      __I  uint32_t  OABLF      :  1;               /*!< Same Time Output Level Low Disable Request Enable                     */
    } GTST_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTBER;                           /*!< General PWM Timer Buffer Enable Register                              */

    struct {
      __IO uint32_t  BD         :  2;               /*!< BD[1]: GTPR Buffer Operation DisableBD[0]: GTCCR Buffer Operation
                                                         Disable                                                               */
           uint32_t             : 14;
      __IO uint32_t  CCRA       :  2;               /*!< GTCCRA Buffer Operation                                               */
      __IO uint32_t  CCRB       :  2;               /*!< GTCCRB Buffer Operation                                               */
      __IO uint32_t  PR         :  2;               /*!< GTPR Buffer Operation                                                 */
      __O  uint32_t  CCRSWT     :  1;               /*!< GTCCRA and GTCCRB Forcible Buffer OperationThis bit is read
                                                         as 0.                                                                 */
    } GTBER_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED;

  union {
    __IO uint32_t  GTCNT;                           /*!< General PWM Timer Counter                                             */

    struct {
      __IO uint32_t  GTCNT      : 32;               /*!< Counter                                                               */
    } GTCNT_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCCRA;                          /*!< General PWM Timer Compare Capture Register A                          */

    struct {
      __IO uint32_t  GTCCRA     : 32;               /*!< Compare Capture Register A                                            */
    } GTCCRA_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCCRB;                          /*!< General PWM Timer Compare Capture Register B                          */

    struct {
      __IO uint32_t  GTCCRB     : 32;               /*!< Compare Capture Register B                                            */
    } GTCCRB_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCCRC;                          /*!< General PWM Timer Compare Capture Register C                          */

    struct {
      __IO uint32_t  GTCCRC     : 32;               /*!< Compare Capture Register C                                            */
    } GTCCRC_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCCRE;                          /*!< General PWM Timer Compare Capture Register E                          */

    struct {
      __IO uint32_t  GTCCRE     : 32;               /*!< Compare Capture Register E                                            */
    } GTCCRE_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCCRD;                          /*!< General PWM Timer Compare Capture Register D                          */

    struct {
      __IO uint32_t  GTCCRD     : 32;               /*!< Compare Capture Register D                                            */
    } GTCCRD_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTCCRF;                          /*!< General PWM Timer Compare Capture Register F                          */

    struct {
      __IO uint32_t  GTCCRF     : 32;               /*!< Compare Capture Register F                                            */
    } GTCCRF_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTPR;                            /*!< General PWM Timer Cycle Setting Register                              */

    struct {
      __IO uint32_t  GTPR       : 32;               /*!< Cycle Setting Register                                                */
    } GTPR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTPBR;                           /*!< General PWM Timer Cycle Setting Buffer Register                       */

    struct {
      __IO uint32_t  GTPBR      : 32;               /*!< Cycle Setting Buffer Register                                         */
    } GTPBR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED1[7];

  union {
    __IO uint32_t  GTDTCR;                          /*!< General PWM Timer Dead Time Control Register                          */

    struct {
      __IO uint32_t  TDE        :  1;               /*!< Negative-Phase Waveform Setting                                       */
      __IO uint32_t             :  31;
    } GTDTCR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  GTDVU;                           /*!< General PWM Timer Dead Time Value Register U                          */

    struct {
      __IO uint32_t  GTDVU      : 32;               /*!< Dead Time Value Register U                                            */
    } GTDVU_b;                                      /*!< BitSize                                                               */
  };
} R_GPTB0_Type;


/* ================================================================================ */
/* ================                    R_GPT_OPS                   ================ */
/* ================================================================================ */


/**
  * @brief Output Phase Switching Controller (R_GPT_OPS)
  */

typedef struct {                                    /*!< R_GPT_OPS Structure                                                   */

  union {
    __IO uint32_t  OPSCR;                           /*!< Output Phase Switching Control Register                               */

    struct {
      __IO uint32_t  UF         :  1;               /*!< Input Phase Soft Setting WFThis bit sets the input phase by
                                                         the software settings.This bit setting is valid when the OPSCR.FB
                                                          bit = 1.                                                             */
      __IO uint32_t  VF         :  1;               /*!< Input Phase Soft Setting VFThis bit sets the input phase by
                                                         the software settings.This bit setting is valid when the OPSCR.FB
                                                          bit = 1.                                                             */
      __IO uint32_t  WF         :  1;               /*!< Input Phase Soft Setting UFThis bit sets the input phase by
                                                         the software settings.This bit setting is valid when the OPSCR.FB
                                                          bit = 1.                                                             */
           uint32_t             :  1;
      __I  uint32_t  U          :  1;               /*!< Input U-Phase MonitorThis bit monitors the state of the input
                                                         phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Software
                                                          settings (UF/VF/WF)                                                  */
      __I  uint32_t  V          :  1;               /*!< Input V-Phase MonitorThis bit monitors the state of the input
                                                         phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Software
                                                          settings (UF/VF/WF)                                                  */
      __I  uint32_t  W          :  1;               /*!< Input W-Phase MonitorThis bit monitors the state of the input
                                                         phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Software
                                                          settings (UF/VF/WF)                                                  */
           uint32_t             :  1;
      __IO uint32_t  EN         :  1;               /*!< Enable-Phase Output Control                                           */
           uint32_t             :  7;
      __IO uint32_t  FB         :  1;               /*!< External Feedback Signal EnableThis bit selects the input phase
                                                         from the software settings and external input.                        */
      __IO uint32_t  P          :  1;               /*!< Positive-Phase Output (P) Control                                     */
      __IO uint32_t  N          :  1;               /*!< Negative-Phase Output (N) Control                                     */
      __IO uint32_t  INV        :  1;               /*!< Invert-Phase Output Control                                           */
      __IO uint32_t  RV         :  1;               /*!< Output phase rotation direction reversal                              */
      __IO uint32_t  ALIGN      :  1;               /*!< Input phase alignment                                                 */
           uint32_t             :  2;
      __IO uint32_t  GRP        :  2;               /*!< Output disabled source selection                                      */
      __IO uint32_t  GODF       :  1;               /*!< Group output disable function                                         */
           uint32_t             :  2;
      __IO uint32_t  NFEN       :  1;               /*!< External Input Noise Filter Enable                                    */
      __IO uint32_t  NFCS       :  2;               /*!< External Input Noise Filter Clock selectionNoise filter sampling
                                                         clock setting of the external input.                                  */
    } OPSCR_b;                                      /*!< BitSize                                                               */
  };
} R_GPT_OPS_Type;


/* ================================================================================ */
/* ================                    R_GPT_ODC                   ================ */
/* ================================================================================ */


/**
  * @brief Output Delay Control (R_GPT_ODC)
  */

typedef struct {                                    /*!< R_GPT_ODC Structure                                                   */

    union {
      __IO uint16_t  GTDLYCR;                       /*!< PWM Output Delay Control Register                                     */

      struct {
        __IO uint16_t  DLLEN    :  1;               /*!< DLL Operation Enable                                                  */
        __IO uint16_t  DLYRST   :  1;               /*!< PWM Delay Generation Circuit Reset                                    */
      } GTDLYCR_b;                                  /*!< BitSize                                                               */
    };

    union {
      __IO uint16_t  GTDLYCR2;                      /*!< PWM Output Delay Control Register2                                    */

      struct {
        __IO uint16_t  DLYBS0 :  1;                 /*!< PWM Delay Generation Circuit bypass for channel 0                     */
        __IO uint16_t  DLYBS1 :  1;                 /*!< PWM Delay Generation Circuit bypass for channel 1                     */
        __IO uint16_t  DLYBS2 :  1;                 /*!< PWM Delay Generation Circuit bypass for channel 2                     */
        __IO uint16_t  DLYBS3 :  1;                 /*!< PWM Delay Generation Circuit bypass for channel 3                     */
             uint16_t         :  4;
        __IO uint16_t  DLYEN0 :  1;                 /*!< PWM Delay Generation Circuit enable for channel 0                     */
        __IO uint16_t  DLYEN1 :  1;                 /*!< PWM Delay Generation Circuit enable for channel 1                     */
        __IO uint16_t  DLYEN2 :  1;                 /*!< PWM Delay Generation Circuit enable for channel 2                     */
        __IO uint16_t  DLYEN3 :  1;                 /*!< PWM Delay Generation Circuit enable for channel 3                     */
    } GTDLYCR2_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[5 * 4];
  R_GPT_ODC_GTDLYRnRC0_Type GTDLYRnRC0[4];          /*!< GTIOC%s Rising Output Delay Register Cluster 0                        */
  R_GPT_ODC_GTDLYFnRC0_Type GTDLYFnRC0[4];          /*!< GTIOC%s Falling Output Delay Register Cluster 0                       */
} R_GPT_ODC_Type;


/* ================================================================================ */
/* ================                     R_KINT                     ================ */
/* ================================================================================ */


/**
  * @brief Key Interrupt (R_KINT)
  */

typedef struct {                                    /*!< R_KINT Structure                                                      */

  union {
    __IO uint8_t   KRCTL;                           /*!< Key Return Control Register                                           */

    struct {
      __IO uint8_t   KREG       :  1;               /*!< Usage of Key Interrupt Flags (KRF0 to KRF7)                           */
           uint8_t              :  6;
      __IO uint8_t   KRMD       :  1;               /*!< Selection of Detection Edge (KR0 to KR7)                              */
    } KRCTL_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED[3];

  union {
    __IO uint8_t   KRF;                             /*!< Key Return Flag Register                                              */

    struct {
      __IO uint8_t   KRF0       :  1;               /*!< Key interrupt flag 0                                                  */
      __IO uint8_t   KRF1       :  1;               /*!< Key interrupt flag 1                                                  */
      __IO uint8_t   KRF2       :  1;               /*!< Key interrupt flag 2                                                  */
      __IO uint8_t   KRF3       :  1;               /*!< Key interrupt flag 3                                                  */
      __IO uint8_t   KRF4       :  1;               /*!< Key interrupt flag 4                                                  */
      __IO uint8_t   KRF5       :  1;               /*!< Key interrupt flag 5                                                  */
      __IO uint8_t   KRF6       :  1;               /*!< Key interrupt flag 6                                                  */
      __IO uint8_t   KRF7       :  1;               /*!< Key interrupt flag 7                                                  */
    } KRF_b;                                        /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1[3];

  union {
    __IO uint8_t   KRM;                             /*!< Key Return Mode Register                                              */

    struct {
      __IO uint8_t   KRM0       :  1;               /*!< Key interrupt mode control 0                                          */
      __IO uint8_t   KRM1       :  1;               /*!< Key interrupt mode control 1                                          */
      __IO uint8_t   KRM2       :  1;               /*!< Key interrupt mode control 2                                          */
      __IO uint8_t   KRM3       :  1;               /*!< Key interrupt mode control 3                                          */
      __IO uint8_t   KRM4       :  1;               /*!< Key interrupt mode control 4                                          */
      __IO uint8_t   KRM5       :  1;               /*!< Key interrupt mode control 5                                          */
      __IO uint8_t   KRM6       :  1;               /*!< Key interrupt mode control 6                                          */
      __IO uint8_t   KRM7       :  1;               /*!< Key interrupt mode control 7                                          */
    } KRM_b;                                        /*!< BitSize                                                               */
  };
} R_KINT_Type;


/* ================================================================================ */
/* ================                     R_CTSU                     ================ */
/* ================================================================================ */


/**
  * @brief Capacitive Touch Sensing Unit (R_CTSU)
  */

typedef struct {                                    /*!< R_CTSU Structure                                                      */

  union {
    __IO uint8_t   CTSUCR0;                         /*!< CTSU Control Register 0                                               */

    struct {
      __IO uint8_t   CTSUSTRT   :  1;               /*!< CTSU Measurement Operation Start                                      */
      __IO uint8_t   CTSUCAP    :  1;               /*!< CTSU Measurement Operation Start Trigger Select                       */
      __IO uint8_t   CTSUSNZ    :  1;               /*!< CTSU Wait State Power-Saving Enable                                   */
      __IO uint8_t   CTSUIOC    :  1;               /*!< CTSU Transmit Pin Control                                             */
      __IO uint8_t   CTSUINIT   :  1;               /*!< CTSU Control Block Initialization                                     */
    } CTSUCR0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCR1;                         /*!< CTSU Control Register 1                                               */

    struct {
      __IO uint8_t   CTSUPON    :  1;               /*!< CTSU Power Supply Enable                                              */
      __IO uint8_t   CTSUCSW    :  1;               /*!< CTSU LPF Capacitance Charging Control                                 */
      __IO uint8_t   CTSUATUNE0 :  1;               /*!< CTSU Power Supply Operating Mode Setting                              */
      __IO uint8_t   CTSUATUNE1 :  1;               /*!< CTSU Power Supply Capacity Adjustment                                 */
      __IO uint8_t   CTSUCLK    :  2;               /*!< CTSU Operating Clock Select                                           */
      __IO uint8_t   CTSUMD     :  2;               /*!< CTSU Measurement Mode Select                                          */
    } CTSUCR1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUSDPRS;                       /*!< CTSU Synchronous Noise Reduction Setting Register                     */

    struct {
      __IO uint8_t   CTSUPRRATIO:  4;               /*!< CTSU Measurement Time and Pulse Count Adjustment                      */
      __IO uint8_t   CTSUPRMODE :  2;               /*!< CTSU Base Period and Pulse Count Setting                              */
      __IO uint8_t   CTSUSOFF   :  1;               /*!< CTSU High-Pass Noise Reduction Function Off Setting                   */
    } CTSUSDPRS_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUSST;                         /*!< CTSU Sensor Stabilization Wait Control Register                       */

    struct {
      __IO uint8_t   CTSUSST    :  8;               /*!< CTSU Sensor Stabilization Wait ControlNOTE: The value of these
                                                         bits should be fixed to 00010000b.                                    */
    } CTSUSST_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUMCH0;                        /*!< CTSU Measurement Channel Register 0                                   */

    struct {
      __IO uint8_t   CTSUMCH0   :  4;               /*!< CTSU Measurement Channel 0                                            */
    } CTSUMCH0_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUMCH1;                        /*!< CTSU Measurement Channel Register 1                                   */

    struct {
      __IO uint8_t   CTSUMCH1   :  4;               /*!< CTSU Measurement Channel 1                                            */
    } CTSUMCH1_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHAC0;                       /*!< CTSU Channel Enable Control Register 0                                */

    struct {
      __IO uint8_t   CTSUCHAC0  :  8;               /*!< CTSU Channel Enable Control 0                                         */
    } CTSUCHAC0_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHAC1;                       /*!< CTSU Channel Enable Control Register 1                                */

    struct {
      __IO uint8_t   CTSUCHAC1  :  8;               /*!< CTSU Channel Enable Control 1                                         */
    } CTSUCHAC1_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHAC2;                       /*!< CTSU Channel Enable Control Register 2                                */

    struct {
      __IO uint8_t   CTSUCHAC2  :  8;               /*!< CTSU Channel Enable Control 2                                         */
    } CTSUCHAC2_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHAC3;                       /*!< CTSU Channel Enable Control Register 3                                */

    struct {
      __IO uint8_t   CTSUCHAC3  :  8;               /*!< CTSU Channel Enable Control 3                                         */
    } CTSUCHAC3_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHAC4;                       /*!< CTSU Channel Enable Control Register 4                                */

    struct {
      __IO uint8_t   CTSUCHAC4  :  4;               /*!< CTSU Channel Enable Control 4                                         */
    } CTSUCHAC4_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHTRC0;                      /*!< CTSU Channel Transmit/Receive Control Register 0                      */

    struct {
      __IO uint8_t   CTSUCHTRC0 :  8;               /*!< CTSU Channel Transmit/Receive Control 0                               */
    } CTSUCHTRC0_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHTRC1;                      /*!< CTSU Channel Transmit/Receive Control Register 1                      */

    struct {
      __IO uint8_t   CTSUCHTRC1  :  8;               /*!< CTSU Channel Transmit/Receive Control 1                               */
    } CTSUCHTRC1_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHTRC2;                      /*!< CTSU Channel Transmit/Receive Control Register 2                      */

    struct {
      __IO uint8_t   CTSUCHTRC2  :  8;               /*!< CTSU Channel Transmit/Receive Control 2                               */
    } CTSUCHTRC2_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUCHTRC3;                      /*!< CTSU Channel Transmit/Receive Control Register 3                      */

    struct {
      __IO uint8_t   CTSUCHTRC3  :  8;               /*!< CTSU Channel Transmit/Receive Control 3                               */
    } CTSUCHTRC3_b;                                 /*!< BitSize                                                               */
  };

    union {
    __IO uint8_t   CTSUCHTRC4;                      /*!< CTSU Channel Transmit/Receive Control Register 4                      */

    struct {
      __IO uint8_t   CTSUCHTRC4  :  4;               /*!< CTSU Channel Transmit/Receive Control 4                               */
    } CTSUCHTRC4_b;                                 /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUDCLKC;                       /*!< CTSU High-Pass Noise Reduction Control Register                       */

    struct {
      __IO uint8_t   CTSUSSMOD  :  2;               /*!< CTSU Diffusion Clock Mode SelectNOTE: This bit should be set
                                                         to 00b.                                                               */
           uint8_t              :  2;
      __IO uint8_t   CTSUSSCNT  :  2;               /*!< CTSU Diffusion Clock Mode ControlNOTE: This bit should be set
                                                         to 11b.                                                               */
    } CTSUDCLKC_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   CTSUST;                          /*!< CTSU Status Register                                                  */

    struct {
      __IO uint8_t   CTSUSTC    :  3;               /*!< CTSU Measurement Status Counter                                       */
           uint8_t              :  1;
      __IO uint8_t   CTSUDTSR   :  1;               /*!< CTSU Data Transfer Status Flag                                        */
      __IO uint8_t   CTSUSOVF   :  1;               /*!< CTSU Sensor Counter Overflow Flag                                     */
      __IO uint8_t   CTSUROVF   :  1;               /*!< CTSU Reference Counter Overflow Flag                                  */
      __IO uint8_t   CTSUPS     :  1;               /*!< CTSU Mutual Capacitance Status Flag                                   */
    } CTSUST_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CTSUSSC;                         /*!< CTSU High-Pass Noise Reduction Spectrum Diffusion Control Register
                                                                                                                               */

    struct {
           uint16_t             :  8;
      __IO uint16_t  CTSUSSDIV  :  4;               /*!< CTSU Spectrum Diffusion Frequency Division Setting                    */
    } CTSUSSC_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CTSUSO0;                         /*!< CTSU Sensor Offset Register 0                                         */

    struct {
      __IO uint16_t  CTSUSO     : 10;               /*!< CTSU Sensor Offset AdjustmentCurrent offset amount is CTSUSO
                                                         ( 0 to 1023 )                                                         */
      __IO uint16_t  CTSUSNUM   :  6;               /*!< CTSU Measurement Count Setting                                        */
    } CTSUSO0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CTSUSO1;                         /*!< CTSU Sensor Offset Register 1                                         */

    struct {
      __IO uint16_t  CTSURICOA  :  8;               /*!< CTSU Reference ICO Current AdjustmentCurrent offset amount is
                                                         CTSUSO ( 0 to 255 )                                                   */
      __IO uint16_t  CTSUSDPA   :  5;               /*!< CTSU Base Clock SettingOperating clock divided by ( CTSUSDPA
                                                         + 1 ) x 2                                                             */
      __IO uint16_t  CTSUICOG   :  2;               /*!< CTSU ICO Gain Adjustment                                              */
    } CTSUSO1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CTSUSC;                          /*!< CTSU Sensor Counter                                                   */

    struct {
      __IO uint16_t  CTSUSC     : 16;               /*!< CTSU Sensor CounterThese bits indicate the measurement result
                                                         of the CTSU. These bits indicate FFFFh when an overflow occurs.       */
    } CTSUSC_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CTSURC;                          /*!< CTSU Reference Counter                                                */

    struct {
      __IO uint16_t  CTSURC     : 16;               /*!< CTSU Reference Counter                                                */
    } CTSURC_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CTSUERRS;                        /*!< CTSU Error Status Register                                            */

    struct {
           uint16_t             : 15;
      __IO uint16_t  CTSUICOMP  :  1;               /*!< TSCAP Voltage Error Monitor                                           */
    } CTSUERRS_b;                                   /*!< BitSize                                                               */
  };
} R_CTSU_Type;





/* ================================================================================ */
/* ================                     R_AGT0                     ================ */
/* ================================================================================ */


/**
  * @brief Asynchronous General purpose Timer 0 (R_AGT0)
  */

typedef struct {                                    /*!< R_AGT0 Structure                                                      */

  union {
    __IO uint16_t  AGT;                             /*!< AGT Counter Register                                                  */

    struct {
      __IO uint16_t  AGT        : 16;               /*!< 16bit counter and reload registerNOTE : When 1 is written to
                                                         the TSTOP bit in the AGTCRn register, the 16-bit counter is
                                                          forcibly stopped and set to FFFFH.                                   */
    } AGT_b;                                        /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  AGTCMA;                          /*!< AGT Compare Match A Register                                          */

    struct {
      __IO uint16_t  AGTCMA     : 16;               /*!< AGT Compare Match A RegisterNOTE : When 1 is written to the
                                                         TSTOP bit in the AGTCRn register, set to FFFFH                        */
    } AGTCMA_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  AGTCMB;                          /*!< AGT Compare Match B Register                                          */

    struct {
      __IO uint16_t  AGTCMB     : 16;               /*!< AGT Compare Match B RegisterNOTE : When 1 is written to the
                                                         TSTOP bit in the AGTCR register, set to FFFFH                         */
    } AGTCMB_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED;

  union {
    __IO uint8_t   AGTCR;                           /*!< AGT Control Register                                                  */

    struct {
      __IO uint8_t   TSTART     :  1;               /*!< AGT count start                                                       */
      __I  uint8_t   TCSTF      :  1;               /*!< AGT count status flag                                                 */
      __O  uint8_t   TSTOP      :  1;               /*!< AGT count forced stop                                                 */
           uint8_t              :  1;
      __IO uint8_t   TEDGF      :  1;               /*!< Active edge judgement flag(This bit is cleared by writing "0"
                                                         in this bit. )                                                        */
      __IO uint8_t   TUNDF      :  1;               /*!< AGT underflow flag(This bit is cleared by writing "0" in this
                                                         bit. )                                                                */
      __IO uint8_t   TCMAF      :  1;               /*!< AGT compare match A flag(This bit is cleared by writing "0"
                                                         in this bit. )                                                        */
      __IO uint8_t   TCMBF      :  1;               /*!< AGT compare match B flag(This bit is cleared by writing "0"
                                                         in this bit. )                                                        */
    } AGTCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   AGTMR1;                          /*!< AGT Mode Register 1                                                   */

    struct {
      __IO uint8_t   TMOD       :  3;               /*!< AGT operating mode select                                             */
      __IO uint8_t   TEDGPL     :  1;               /*!< AGTIO edge polarity select                                            */
      __IO uint8_t   TCK        :  3;               /*!< AGT count source select                                               */
    } AGTMR1_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   AGTMR2;                          /*!< AGT Mode Register 2                                                   */

    struct {
      __IO uint8_t   CKS        :  3;               /*!< fsub/LOCO count source clock frequency division ratio select          */
           uint8_t              :  4;
      __IO uint8_t   LPM        :  1;               /*!< AGT Low Power Mode                                                    */
    } AGTMR2_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1;

  union {
    __IO uint8_t   AGTIOC;                          /*!< AGT I/O Control Register                                              */

    struct {
      __IO uint8_t   TEDGSEL    :  1;               /*!< I/O polarity switchFunction varies depending on the operating
                                                         mode.                                                                 */
           uint8_t              :  1;
      __IO uint8_t   TOE        :  1;               /*!< AGTO output enable                                                    */
           uint8_t              :  1;
      __IO uint8_t   TIPF       :  2;               /*!< AGTIO input filter select                                             */
      __IO uint8_t   TIOGT      :  2;               /*!< AGTIO count control                                                   */
    } AGTIOC_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   AGTISR;                          /*!< AGT Event Pin Select Register                                         */

    struct {
           uint8_t              :  2;
      __IO uint8_t   EEPS       :  1;               /*!< AGTEE polarity selection                                              */
    } AGTISR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   AGTCMSR;                         /*!< AGT Compare Match Function Select Register                            */

    struct {
      __IO uint8_t   TCMEA      :  1;               /*!< Compare match A register enable                                       */
      __IO uint8_t   TOEA       :  1;               /*!< AGTOA output enable                                                   */
      __IO uint8_t   TOPOLA     :  1;               /*!< AGTOA polarity select                                                 */
           uint8_t              :  1;
      __IO uint8_t   TCMEB      :  1;               /*!< Compare match B register enable                                       */
      __IO uint8_t   TOEB       :  1;               /*!< AGTOB output enable                                                   */
      __IO uint8_t   TOPOLB     :  1;               /*!< AGTOB polarity select                                                 */
    } AGTCMSR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   AGTIOSEL;                        /*!< AGT Pin Select Register                                               */

    struct {
      __IO uint8_t   SEL        :  2;               /*!< AGTIO pin select                                                      */
           uint8_t              :  2;
      __IO uint8_t   TIES       :  1;               /*!< AGTIO input enable                                                    */
    } AGTIOSEL_b;                                   /*!< BitSize                                                               */
  };
} R_AGT0_Type;



/* =========================================================================================================================== */
/* ================                                           R_OPAMP                                           ================ */
/* Note: 9/12/17 - The following structure for OPAMP was hand edited using the output from the R7FS1JA7.svd output file      */
/* =========================================================================================================================== */


/**
  * @brief OperationalAmplifier (R_OPAMP)
  */

typedef struct {                                /*!< (@ 0x40086800) R_OPAMP Structure                                            */

    __IM  uint8_t   RESERVED0[8];

  union {
    __IOM uint8_t AMPMC;                        /*!< (@ 0x00000000) Operational amplifier mode control register                */

    struct {
      __IM  uint8_t             : 6;
      __IOM uint8_t AMPSP       : 2;            /*!< [7..6] OPAMP Operation mode selection                                     */
    } AMPMC_b;
  } ;

  union {
    __IOM uint8_t AMPTRM;                       /*!< (@ 0x00000001) Operational amplifier trigger mode control register        */

    struct {
      __IOM uint8_t AMPTRM00    : 1;            /*!< [0..0] OPAMP function activation/stop trigger control                     */
      __IOM uint8_t AMPTRM01    : 1;            /*!< [1..1] OPAMP function activation/stop trigger control                     */
      __IOM uint8_t AMPTRM10    : 1;            /*!< [2..2] OPAMP function activation/stop trigger control                     */
      __IOM uint8_t AMPTRM11    : 1;            /*!< [3..3] OPAMP function activation/stop trigger control                     */
      __IOM uint8_t AMPTRM20    : 1;            /*!< [4..4] OPAMP function activation/stop trigger control                     */
      __IOM uint8_t AMPTRM21    : 1;            /*!< [5..5] OPAMP function activation/stop trigger control                     */
    } AMPTRM_b;
  } ;

  union {
    __IOM uint8_t AMPTRS;                       /*!< (@ 0x00000002) Operational Amplifier Activation Trigger Select
                                                                    Register                                                   */

    struct {
      __IOM uint8_t AMPTRS      : 2;            /*!< [1..0] Activation Trigger SelectionNote: Do not change the value
                                                     of the AMPTRS register after setting the AMPTRM register.                 */
    } AMPTRS_b;
  } ;

  union {
    __IOM uint8_t AMPC;                         /*!< (@ 0x00000003) Operational amplifier control register                     */

    struct {
      __IOM uint8_t AMPE0       : 1;            /*!< [0..0] Operation control of operational amplifier 0                       */
      __IOM uint8_t AMPE1       : 1;            /*!< [1..1] Operation control of operational amplifier 1                       */
      __IOM uint8_t AMPE2       : 1;            /*!< [2..2] Operation control of operational amplifier 2                       */
      __IM  uint8_t             : 4;
      __IOM uint8_t IREFE       : 1;            /*!< [7..7] Reference Current Circuit Operation Control                        */
    } AMPC_b;
  } ;

  union {
    __IM  uint8_t AMPMON;                       /*!< (@ 0x00000004) Operational amplifier monitor register                     */

    struct {
      __IM  uint8_t AMPMON0     : 1;            /*!< [0..0] OPAMP0 Status                                                      */
      __IM  uint8_t AMPMON1     : 1;            /*!< [1..1] OPAMP1 Status                                                      */
      __IM  uint8_t AMPMON2     : 1;            /*!< [2..2] OPAMP2 Status                                                      */
    } AMPMON_b;
  } ;
  __IM  uint8_t   RESERVED;

  union {
    __IOM uint8_t AMP0OS;                       /*!< (@ 0x00000006) Operational Amplifier 0 Output Select Register             */

    struct {
      __IOM uint8_t AMPOS0      : 1;            /*!< [0..0] AMP1- pin select                                                   */
      __IOM uint8_t AMPOS1      : 1;            /*!< [1..1] AMP1+ pin select                                                   */
      __IOM uint8_t AMPOS2      : 1;            /*!< [2..2] AMP2- pin select                                                   */
      __IOM uint8_t AMPOS3      : 1;            /*!< [3..3] AMP2+ pin select                                                   */
    } AMP0OS_b;
  } ;

  union {
    __IOM uint8_t AMP0MS;                       /*!< (@ 0x00000007) Operational Amplifier 0 Minus Input Select Register        */

    struct {
      __IOM uint8_t AMPMS0      : 1;            /*!< [0..0] AMP0- pin select                                                   */
      __IOM uint8_t AMPMS1      : 1;            /*!< [1..1] AMP0+ pin select                                                   */
      __IOM uint8_t AMPMS2      : 1;            /*!< [2..2] AMP1- pin select                                                   */
      __IOM uint8_t AMPMS3      : 1;            /*!< [3..3] AMP1+ pin select                                                   */
      __IOM uint8_t AMPMS4      : 1;            /*!< [4..4] AMP2- pin select                                                   */
      __IM  uint8_t             : 2;
      __IOM uint8_t AMPMS7      : 1;            /*!< [7..7] OPAMP0 output select                                               */
    } AMP0MS_b;
  } ;

  union {
    __IOM uint8_t AMP0PS;                       /*!< (@ 0x00000008) Operational Amplifier 0 Plus Input Select Register         */

    struct {
      __IOM uint8_t AMPPS0      : 1;            /*!< [0..0] AMP0+ pin select                                                   */
      __IOM uint8_t AMPPS1      : 1;            /*!< [1..1] AMP1- pin select                                                   */
      __IOM uint8_t AMPPS2      : 1;            /*!< [2..2] AMP1+pin select                                                    */
      __IOM uint8_t AMPPS3      : 1;            /*!< [3..3] AMP2+ pin select                                                   */
      __IM  uint8_t             : 3;
      __IOM uint8_t AMPPS7      : 1;            /*!< [7..7] DAC12 output select                                                */
    } AMP0PS_b;
  } ;
  __IM  uint8_t   RESERVED1;

  union {
    __IOM uint8_t AMP1MS;                       /*!< (@ 0x0000000A) Operational Amplifier 1 Minus Input Select Register        */

    struct {
      __IOM uint8_t AMPMS0      : 1;            /*!< [0..0] AMP1- pin select                                                   */
      __IM  uint8_t             : 6;
      __IOM uint8_t AMPMS7      : 1;            /*!< [7..7] OPAMP1 output select                                               */
    } AMP1MS_b;
  } ;

  union {
    __IOM uint8_t AMP1PS;                       /*!< (@ 0x0000000B) Operational Amplifier 1 Plus Input Select Register         */

    struct {
      __IOM uint8_t AMPPS0      : 1;            /*!< [0..0] AMP1- pin select                                                   */
      __IOM uint8_t AMPPS1      : 1;            /*!< [1..1] AMP1+ pin select                                                   */
      __IOM uint8_t AMPPS2      : 1;            /*!< [2..2] AMP2- pin select                                                   */
      __IOM uint8_t AMPPS3      : 1;            /*!< [3..3] AMP2+ pin select                                                   */
      __IM  uint8_t             : 3;
      __IOM uint8_t AMPPS7      : 1;            /*!< [7..7] OPAMP2 output select                                               */
    } AMP1PS_b;
  } ;
  __IM  uint8_t   RESERVED2;

  union {
    __IOM uint8_t AMP2MS;                       /*!< (@ 0x0000000D) Operational Amplifier 2 Minus Input Select Register        */

    struct {
      __IOM uint8_t AMPMS0      : 1;            /*!< [0..0] AMP2- pin select                                                   */
      __IM  uint8_t             : 6;
      __IOM uint8_t AMPMS7      : 1;            /*!< [7..7] OPAMP2 output select                                               */
    } AMP2MS_b;
  } ;

  union {
    __IOM uint8_t AMP2PS;                       /*!< (@ 0x0000000E) Operational Amplifier 2 Plus Input Select Register         */

    struct {
      __IOM uint8_t AMPPS0      : 1;            /*!< [0..0] AMP2- pin select                                                   */
      __IOM uint8_t AMPPS1      : 1;            /*!< [1..1] AMP2+ pin select                                                   */
      __IM  uint8_t             : 5;
      __IOM uint8_t AMPPS7      : 1;            /*!< [7..7] DAC8 channel 1output select                                        */
    } AMP2PS_b;
  } ;
  __IM  uint8_t   RESERVED3;
  __IM  uint16_t  RESERVED4;

  union {
    __IOM uint8_t AMPCPC;                       /*!< (@ 0x00000012) Operational Amplifier Switch Charge Pump Control
                                                                    Register                                                   */

    struct {
      __IOM uint8_t PUMP0EN     : 1;            /*!< [0..0] Charge Pump for AMP0 Enable                                        */
      __IOM uint8_t PUMP1EN     : 1;            /*!< [1..1] Charge Pump for AMP1 Enable                                        */
      __IOM uint8_t PUMP2EN     : 1;            /*!< [2..2] Charge Pump for AMP2 Enable                                        */
    } AMPCPC_b;
  } ;
  __IM  uint8_t   RESERVED5;
  __IM  uint16_t  RESERVED6;
  __IM  uint8_t   RESERVED7;

  union {
    __IOM uint8_t AMPUOTE;                      /*!< (@ 0x00000017) Operational Amplifier User Offset Trimming Enable
                                                                    Register                                                   */

    struct {
      __IOM uint8_t AMP0TE      : 1;            /*!< [0..0] AMP0OT write enable                                                */
      __IOM uint8_t AMP1TE      : 1;            /*!< [1..1] AMP1OT write enable                                                */
      __IOM uint8_t AMP2TE      : 1;            /*!< [2..2] AMP2OT write enable                                                */
    } AMPUOTE_b;
  } ;

  union {
    __IOM uint8_t AMP0OTP;                      /*!< (@ 0x00000018) Operational Amplifier 0 Offset Trimming Pch Register       */

    struct {
      __IOM uint8_t TRMP        : 5;            /*!< [4..0] AMP0 input offset trimming Pch side                                */
    } AMP0OTP_b;
  } ;

  union {
    __IOM uint8_t AMP0OTN;                      /*!< (@ 0x00000019) Operational Amplifier 0 Offset Trimming Nch Register       */

    struct {
      __IOM uint8_t TRMN        : 5;            /*!< [4..0] AMP0 input offset trimming Nch side                                */
    } AMP0OTN_b;
  } ;

  union {
    __IOM uint8_t AMP1OTP;                      /*!< (@ 0x0000001A) Operational Amplifier 1 Offset Trimming Pch Register       */

    struct {
      __IOM uint8_t TRMP        : 5;            /*!< [4..0] AMP1 input offset trimming Pch side                                */
    } AMP1OTP_b;
  } ;

  union {
    __IOM uint8_t AMP1OTN;                      /*!< (@ 0x0000001B) Operational Amplifier 1 Offset Trimming Nch Register       */

    struct {
      __IOM uint8_t TRMN        : 5;            /*!< [4..0] AMP1 input offset trimming Nch side                                */
    } AMP1OTN_b;
  } ;

  union {
    __IOM uint8_t AMP2OTP;                      /*!< (@ 0x0000001C) Operational Amplifier 2 Offset Trimming Pch Register       */

    struct {
      __IOM uint8_t TRMP        : 5;            /*!< [4..0] AMP2 input offset trimming Pch side                                */
    } AMP2OTP_b;
  } ;

  union {
    __IOM uint8_t AMP2OTN;                      /*!< (@ 0x0000001D) Operational Amplifier 2 Offset Trimming Nch Register       */

    struct {
      __IOM uint8_t TRMN        : 5;            /*!< [4..0] AMP2 input offset trimming Nch side                                */
    } AMP2OTN_b;
  } ;
} R_OPAMP_Type;                                   /*!< Size = 30 (0x1e)                                                          */



/* =========================================================================================================================== */
/* ================                                          R_SDADC24                                          ================ */
/* Note: 9/12/17 - The following structure for SDADC24 was hand edited using the output from the R7FS1JA7.svd output file      */
/* =========================================================================================================================== */


/**
  * @brief 24-Bit Sigma-Delta A/D Converter (R_SDADC24)
  */

typedef struct {                                /*!< (@ 0x4009C000) SDADC24 Structure                                          */

  union {
    __IOM uint16_t STC1;                        /*!< (@ 0x00000000) Startup Control Register 1                                 */

    struct {
      __IOM uint16_t CLKDIV     : 4;            /*!< [3..0] SDADC24 reference clock division select                            */
      __IM  uint16_t            : 3;
      __IOM uint16_t SDADLPM    : 1;            /*!< [7..7] A/D conversion operation mode select                               */
      __IOM uint16_t VSBIAS     : 4;            /*!< [11..8] Reference voltage select                                          */
      __IM  uint16_t            : 3;
      __IOM uint16_t VREFSEL    : 1;            /*!< [15..15] VREF mode select                                                 */
    } STC1_b;
  } ;
  __IM  uint16_t  RESERVED;

  union {
    __IOM uint8_t STC2;                         /*!< (@ 0x00000004) Startup Control Register 2                                 */

    struct {
      __IOM uint8_t BGRPON      : 1;            /*!< [0..0] BGR part power control                                             */
      __IOM uint8_t ADCPON      : 1;            /*!< [1..1] ADC reference supply part power control                            */
      __IOM uint8_t ADFPWDS     : 1;            /*!< [2..2] ADREG forced power-down mode                                       */
    } STC2_b;
  } ;
  __IM  uint8_t   RESERVED1;
  __IM  uint16_t  RESERVED2;

  union {
    __IOM uint32_t PGAC0;                       /*!< (@ 0x00000008) Input Multiplexer 0 Setting Register                       */

    struct {
      __IOM uint32_t PGAGC      : 5;            /*!< [4..0] Gain selection of a programmable gain instrumentation
                                                     amplifier ( Gset1, Gset2, Gtotal )                                        */
      __IOM uint32_t PGAOSR     : 3;            /*!< [7..5] Oversampling ratio select                                          */
      __IOM uint32_t PGAOFS     : 5;            /*!< [12..8] Offset voltage select                                             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGAPOL     : 1;            /*!< [14..14] Polarity select                                                  */
      __IOM uint32_t PGASEL     : 1;            /*!< [15..15] Analog Channel Input Mode Select                                 */
      __IOM uint32_t PGACTM     : 5;            /*!< [20..16] Coefficient (m) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGACTN     : 3;            /*!< [23..21] Coefficient (n) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGAAVN     : 2;            /*!< [25..24] Selection of the number of data to be averaged                   */
      __IOM uint32_t PGAAVE     : 2;            /*!< [27..26] Selection of averaging processing                                */
      __IOM uint32_t PGAREV     : 1;            /*!< [28..28] Single-End Input A/D Converted Data Inversion Select             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGACVE     : 1;            /*!< [30..30] Calibration enable                                               */
      __IOM uint32_t PGAASN     : 1;            /*!< [31..31] Selection of the mode for specifying the number of
                                                     A/D conversions in ADSCAN                                                 */
    } PGAC0_b;
  } ;

  union {
    __IOM uint32_t PGAC1;                       /*!< (@ 0x0000000C) Input Multiplexer 1 Setting Register                       */

    struct {
      __IOM uint32_t PGAGC      : 5;            /*!< [4..0] Gain selection of a programmable gain instrumentation
                                                     amplifier ( Gset1, Gset2, Gtotal )                                        */
      __IOM uint32_t PGAOSR     : 3;            /*!< [7..5] Oversampling ratio select                                          */
      __IOM uint32_t PGAOFS     : 5;            /*!< [12..8] Offset voltage select                                             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGAPOL     : 1;            /*!< [14..14] Polarity select                                                  */
      __IOM uint32_t PGASEL     : 1;            /*!< [15..15] Analog Channel Input Mode Select                                 */
      __IOM uint32_t PGACTM     : 5;            /*!< [20..16] Coefficient (m) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGACTN     : 3;            /*!< [23..21] Coefficient (n) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGAAVN     : 2;            /*!< [25..24] Selection of the number of data to be averaged                   */
      __IOM uint32_t PGAAVE     : 2;            /*!< [27..26] Selection of averaging processing                                */
      __IOM uint32_t PGAREV     : 1;            /*!< [28..28] Single-End Input A/D Converted Data Inversion Select             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGACVE     : 1;            /*!< [30..30] Calibration enable                                               */
      __IOM uint32_t PGAASN     : 1;            /*!< [31..31] Selection of the mode for specifying the number of
                                                     A/D conversions in ADSCAN                                                 */
    } PGAC1_b;
  } ;

  union {
    __IOM uint32_t PGAC2;                       /*!< (@ 0x00000010) Input Multiplexer 2 Setting Register                       */

    struct {
      __IOM uint32_t PGAGC      : 5;            /*!< [4..0] Gain selection of a programmable gain instrumentation
                                                     amplifier ( Gset1, Gset2, Gtotal )                                        */
      __IOM uint32_t PGAOSR     : 3;            /*!< [7..5] Oversampling ratio select                                          */
      __IOM uint32_t PGAOFS     : 5;            /*!< [12..8] Offset voltage select                                             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGAPOL     : 1;            /*!< [14..14] Polarity select                                                  */
      __IOM uint32_t PGASEL     : 1;            /*!< [15..15] Analog Channel Input Mode Select                                 */
      __IOM uint32_t PGACTM     : 5;            /*!< [20..16] Coefficient (m) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGACTN     : 3;            /*!< [23..21] Coefficient (n) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGAAVN     : 2;            /*!< [25..24] Selection of the number of data to be averaged                   */
      __IOM uint32_t PGAAVE     : 2;            /*!< [27..26] Selection of averaging processing                                */
      __IOM uint32_t PGAREV     : 1;            /*!< [28..28] Single-End Input A/D Converted Data Inversion Select             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGACVE     : 1;            /*!< [30..30] Calibration enable                                               */
      __IOM uint32_t PGAASN     : 1;            /*!< [31..31] Selection of the mode for specifying the number of
                                                     A/D conversions in ADSCAN                                                 */
    } PGAC2_b;
  } ;

  union {
    __IOM uint32_t PGAC3;                       /*!< (@ 0x00000014) Input Multiplexer 3 Setting Register                       */

    struct {
      __IOM uint32_t PGAGC      : 5;            /*!< [4..0] Gain selection of a programmable gain instrumentation
                                                     amplifier ( Gset1, Gset2, Gtotal )                                        */
      __IOM uint32_t PGAOSR     : 3;            /*!< [7..5] Oversampling ratio select                                          */
      __IOM uint32_t PGAOFS     : 5;            /*!< [12..8] Offset voltage select                                             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGAPOL     : 1;            /*!< [14..14] Polarity select                                                  */
      __IOM uint32_t PGASEL     : 1;            /*!< [15..15] Analog Channel Input Mode Select                                 */
      __IOM uint32_t PGACTM     : 5;            /*!< [20..16] Coefficient (m) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGACTN     : 3;            /*!< [23..21] Coefficient (n) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGAAVN     : 2;            /*!< [25..24] Selection of the number of data to be averaged                   */
      __IOM uint32_t PGAAVE     : 2;            /*!< [27..26] Selection of averaging processing                                */
      __IOM uint32_t PGAREV     : 1;            /*!< [28..28] Single-End Input A/D Converted Data Inversion Select             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGACVE     : 1;            /*!< [30..30] Calibration enable                                               */
      __IOM uint32_t PGAASN     : 1;            /*!< [31..31] Selection of the mode for specifying the number of
                                                     A/D conversions in ADSCAN                                                 */
    } PGAC3_b;
  } ;

  union {
    __IOM uint32_t PGAC4;                       /*!< (@ 0x00000018) Input Multiplexer 4 Setting Register                       */

    struct {
      __IOM uint32_t PGAGC      : 5;            /*!< [4..0] Gain selection of a programmable gain instrumentation
                                                     amplifier ( Gset1, Gset2, Gtotal )                                        */
      __IOM uint32_t PGAOSR     : 3;            /*!< [7..5] Oversampling ratio select                                          */
      __IOM uint32_t PGAOFS     : 5;            /*!< [12..8] Offset voltage select                                             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGAPOL     : 1;            /*!< [14..14] Polarity select                                                  */
      __IOM uint32_t PGASEL     : 1;            /*!< [15..15] Analog Channel Input Mode Select                                 */
      __IOM uint32_t PGACTM     : 5;            /*!< [20..16] Coefficient (m) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGACTN     : 3;            /*!< [23..21] Coefficient (n) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGAAVN     : 2;            /*!< [25..24] Selection of the number of data to be averaged                   */
      __IOM uint32_t PGAAVE     : 2;            /*!< [27..26] Selection of averaging processing                                */
      __IOM uint32_t PGAREV     : 1;            /*!< [28..28] Single-End Input A/D Converted Data Inversion Select             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGACVE     : 1;            /*!< [30..30] Calibration enable                                               */
      __IOM uint32_t PGAASN     : 1;            /*!< [31..31] Selection of the mode for specifying the number of
                                                     A/D conversions in ADSCAN                                                 */
    } PGAC4_b;
  } ;

  union {
    __IOM uint32_t ADC1;                        /*!< (@ 0x0000001C) Sigma-delta A/D Converter Control Register 1               */

    struct {
      __IOM uint32_t SDADSCM    : 1;            /*!< [0..0] Selection of autoscan mode                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t SDADTMD    : 1;            /*!< [4..4] Selection of A/D conversion trigger signal                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t SDADBMP    : 5;            /*!< [12..8] A/D conversion control of the signal from input multiplexer       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PGADISA    : 1;            /*!< [16..16] Control of disconnection detection                               */
      __IOM uint32_t PGADISC    : 1;            /*!< [17..17] Disconnection Detection Assist Setting                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PGASLFT    : 1;            /*!< [20..20] PGA offset self-diagnosis enable                                 */
    } ADC1_b;
  } ;

  union {
    __IOM uint8_t ADC2;                         /*!< (@ 0x00000020) Sigma-delta A/D Converter Control Register 2               */

    struct {
      __IOM uint8_t SDADST      : 1;            /*!< [0..0] Control of A/D conversion                                          */
    } ADC2_b;
  } ;
  __IM  uint8_t   RESERVED3;
  __IM  uint16_t  RESERVED4;

  union {
    __IOM uint32_t ADCR;                        /*!< (@ 0x00000024) Sigma-delta A/D Converter Conversion Result Register       */

    struct {
      __IM  uint32_t SDADCRD    : 24;           /*!< [23..0] The 24-bit A/D conversion result                                  */
      __IM  uint32_t SDADCRS    : 1;            /*!< [24..24] Status of an A/D conversion result                               */
      __IM  uint32_t SDADCRC    : 3;            /*!< [27..25] Channel number for an A/D conversion result                      */
    } ADCR_b;
  } ;

  union {
    __IM  uint32_t ADAR;                        /*!< (@ 0x00000028) Sigma-delta A/D Converter Average Value Register           */

    struct {
      __IM  uint32_t SDADMVD    : 24;           /*!< [23..0] The 24-bit A/D average value                                      */
      __IM  uint32_t SDADMVS    : 1;            /*!< [24..24] Status of an A/D conversion result                               */
      __IM  uint32_t SDADMVC    : 3;            /*!< [27..25] Channel number for an A/D conversion result                      */
    } ADAR_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint8_t CLBC;                         /*!< (@ 0x00000030) Calibration Control Register                               */

    struct {
      __IOM uint8_t CLBMD       : 2;            /*!< [1..0] These bits are read as 0. The write value should be 0.             */
    } CLBC_b;
  } ;
  __IM  uint8_t   RESERVED6;
  __IM  uint16_t  RESERVED7;

  union {
    __IOM uint8_t CLBSTR;                       /*!< (@ 0x00000034) Calibration Start Control Register                         */

    struct {
      __IOM uint8_t CLBST       : 1;            /*!< [0..0] Calibration start control                                          */
    } CLBSTR_b;
  } ;
  __IM  uint8_t   RESERVED8;
  __IM  uint16_t  RESERVED9;
  __IM  uint32_t  RESERVED10;

  union {
    __IM  uint8_t CLBSSR;                       /*!< (@ 0x0000003C) Calibration Status Register                                */

    struct {
      __IM  uint8_t CLBSS       : 1;            /*!< [0..0] Calibration status                                                 */
    } CLBSSR_b;
  } ;
} R_SDADC24_Type;                                 /*!< Size = 61 (0x3d)                                                          */


/* ================================================================================ */
/* ================                     R_USBFS                    ================ */
/* ================================================================================ */


/**
  * @brief USB 2.0 FS Host/Function Module (R_USBFS)
  */

typedef struct {                                    /*!< R_USBFS Structure                                                     */

  union {
    __IO uint16_t  SYSCFG;                          /*!< System Configuration Control Register                                 */

    struct {
      __IO uint16_t  USBE       :  1;               /*!< USB Operation Enable                                                  */
           uint16_t             :  3;
      __IO uint16_t  DPRPU      :  1;               /*!< D+Line Resistor Control                                               */
      __IO uint16_t  DRPD       :  1;               /*!< D+/D-Line Resistor Control                                            */
      __IO uint16_t  DCFM       :  1;               /*!< Controller Function Select                                            */
           uint16_t             :  3;
      __IO uint16_t  SCKE       :  1;               /*!< USB Clock Enable                                                      */
    } SYSCFG_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED;

  union {
    __I  uint16_t  SYSSTS0;                         /*!< System Configuration Status Register 0                                */

    struct {
      __I  uint16_t  LNST       :  2;               /*!< USB Data Line Status Monitor                                          */
      __I  uint16_t  IDMON      :  1;               /*!< External ID0 Input Pin Monitor                                        */
           uint16_t             :  2;
      __I  uint16_t  SOFEA      :  1;               /*!< Active Monitor When the Host Controller is Selected.                  */
      __I  uint16_t  HTACT      :  1;               /*!< USB Host Sequencer Status Monitor                                     */
           uint16_t             :  7;
      __I  uint16_t  OVCMON     :  2;               /*!< External USB0_OVRCURA/ USB0_OVRCURB Input Pin MonitorThe OCVMON[1]
                                                         bit indicates the status of the USBHS_OVRCURA pin. The OCVMON[0]
                                                          bit indicates the status of the USBHS_OVRCURB pin.                   */
    } SYSSTS0_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED1;

  union {
    __IO uint16_t  DVSTCTR0;                        /*!< Device State Control Register 0                                       */

    struct {
      __I  uint16_t  RHST       :  3;               /*!< USB Bus Reset Status                                                  */
           uint16_t             :  1;
      __IO uint16_t  UACT       :  1;               /*!< USB Bus Enable                                                        */
      __IO uint16_t  RESUME     :  1;               /*!< Resume Output                                                         */
      __IO uint16_t  USBRST     :  1;               /*!< USB Bus Reset Output                                                  */
      __IO uint16_t  RWUPE      :  1;               /*!< Wakeup Detection Enable                                               */
      __IO uint16_t  WKUP       :  1;               /*!< Wakeup Output                                                         */
      __IO uint16_t  VBUSEN     :  1;               /*!< USB0_VBUSEN Output Pin Control                                        */
      __IO uint16_t  EXICEN     :  1;               /*!< USB0_EXICEN Output Pin Control                                        */
      __IO uint16_t  HNPBTOA    :  1;               /*!< Host Negotiation Protocol (HNP) Control This bit is used when
                                                         switching from device B to device A while in OTG mode. If the
                                                          HNPBTOA bit is 1, the internal function control keeps the suspended
                                                          state until the HNP processing ends even though SYSCFG.DPRPU
                                                          = 0 or SYSCFG.DCFM = 1 is set.                                       */
    } DVSTCTR0_b;                                   /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED2[5];

  union {
    __IO uint16_t  CFIFO;                           /*!< CFIFO Port Register                                                   */

    struct {
      __IO uint16_t  FIFOPORT   : 16;               /*!< FIFO PortRead receive data from the FIFO buffer or write transmit
                                                         data to the FIFO buffer by accessing these bits.                      */
    } CFIFO_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED3;

  union {
    __IO uint16_t  D0FIFO;                          /*!< D0FIFO Port Register                                                  */

    struct {
      __IO uint16_t  FIFOPORT   : 16;               /*!< FIFO PortRead receive data from the FIFO buffer or write transmit
                                                         data to the FIFO buffer by accessing these bits.                      */
    } D0FIFO_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED4;

  union {
    __IO uint16_t  D1FIFO;                          /*!< D1FIFO Port Register                                                  */

    struct {
      __IO uint16_t  FIFOPORT   : 16;               /*!< FIFO PortRead receive data from the FIFO buffer or write transmit
                                                         data to the FIFO buffer by accessing these bits.                      */
    } D1FIFO_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED5;

  union {
    __IO uint16_t  CFIFOSEL;                        /*!< CFIFO Port Select Register                                            */

    struct {
      __IO uint16_t  CURPIPE    :  4;               /*!< CFIFO Port Access Pipe Specification                                  */
           uint16_t             :  1;
      __IO uint16_t  ISEL       :  1;               /*!< CFIFO Port Access Direction When DCP is Selected                      */
           uint16_t             :  2;
      __IO uint16_t  BIGEND     :  1;               /*!< CFIFO Port Endian Control                                             */
           uint16_t             :  1;
      __IO uint16_t  MBW        :  1;               /*!< CFIFO Port Access Bit Width                                           */
           uint16_t             :  3;
      __IO uint16_t  REW        :  1;               /*!< Buffer Pointer Rewind                                                 */
      __IO uint16_t  RCNT       :  1;               /*!< Read Count Mode                                                       */
    } CFIFOSEL_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  CFIFOCTR;                        /*!< CFIFO Port Control Register                                           */

    struct {
      __I  uint16_t  DTLN       :  9;               /*!< Receive Data LengthIndicates the length of the receive data.          */
           uint16_t             :  4;
      __I  uint16_t  FRDY       :  1;               /*!< FIFO Port Ready                                                       */
      __IO uint16_t  BCLR       :  1;               /*!< CPU Buffer Clear                                                      */
      __IO uint16_t  BVAL       :  1;               /*!< Buffer Memory Valid Flag                                              */
    } CFIFOCTR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED6;

  union {
    __IO uint16_t  D0FIFOSEL;                       /*!< D0FIFO Port Select Register                                           */

    struct {
      __IO uint16_t  CURPIPE    :  4;               /*!< FIFO Port Access Pipe Specification                                   */
           uint16_t             :  4;
      __IO uint16_t  BIGEND     :  1;               /*!< FIFO Port Endian Control                                              */
           uint16_t             :  1;
      __IO uint16_t  MBW        :  1;               /*!< FIFO Port Access Bit Width                                            */
           uint16_t             :  1;
      __IO uint16_t  DREQE      :  1;               /*!< DMA/DTC Transfer Request Enable                                       */
      __IO uint16_t  DCLRM      :  1;               /*!< Auto Buffer Memory Clear Mode Accessed after Specified Pipe
                                                         Data is Read                                                          */
      __IO uint16_t  REW        :  1;               /*!< Buffer Pointer Rewind                                                 */
      __IO uint16_t  RCNT       :  1;               /*!< Read Count Mode                                                       */
    } D0FIFOSEL_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  D0FIFOCTR;                       /*!< D0FIFO Port Control Register                                          */

    struct {
      __I  uint16_t  DTLN       :  9;               /*!< Receive Data LengthIndicates the length of the receive data.          */
           uint16_t             :  4;
      __I  uint16_t  FRDY       :  1;               /*!< FIFO Port Ready                                                       */
      __IO uint16_t  BCLR       :  1;               /*!< CPU Buffer Clear                                                      */
      __IO uint16_t  BVAL       :  1;               /*!< Buffer Memory Valid Flag                                              */
    } D0FIFOCTR_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  D1FIFOSEL;                       /*!< D1FIFO Port Select Register                                           */

    struct {
      __IO uint16_t  CURPIPE    :  4;               /*!< FIFO Port Access Pipe Specification                                   */
           uint16_t             :  4;
      __IO uint16_t  BIGEND     :  1;               /*!< FIFO Port Endian Control                                              */
           uint16_t             :  1;
      __IO uint16_t  MBW        :  1;               /*!< FIFO Port Access Bit Width                                            */
           uint16_t             :  1;
      __IO uint16_t  DREQE      :  1;               /*!< DMA/DTC Transfer Request Enable                                       */
      __IO uint16_t  DCLRM      :  1;               /*!< Auto Buffer Memory Clear Mode Accessed after Specified Pipe
                                                         Data is Read                                                          */
      __IO uint16_t  REW        :  1;               /*!< Buffer Pointer Rewind                                                 */
      __IO uint16_t  RCNT       :  1;               /*!< Read Count Mode                                                       */
    } D1FIFOSEL_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  D1FIFOCTR;                       /*!< D1FIFO Port Control Register                                          */

    struct {
      __I  uint16_t  DTLN       :  9;               /*!< Receive Data LengthIndicates the length of the receive data.          */
           uint16_t             :  4;
      __I  uint16_t  FRDY       :  1;               /*!< FIFO Port Ready                                                       */
      __IO uint16_t  BCLR       :  1;               /*!< CPU Buffer Clear                                                      */
      __IO uint16_t  BVAL       :  1;               /*!< Buffer Memory Valid Flag                                              */
    } D1FIFOCTR_b;                                  /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  INTENB0;                         /*!< Interrupt Enable Register 0                                           */

    struct {
           uint16_t             :  8;
      __IO uint16_t  BRDYE      :  1;               /*!< Buffer Ready Interrupt Enable                                         */
      __IO uint16_t  NRDYE      :  1;               /*!< Buffer Not Ready Response Interrupt Enable                            */
      __IO uint16_t  BEMPE      :  1;               /*!< Buffer Empty Interrupt Enable                                         */
      __IO uint16_t  CTRE       :  1;               /*!< Control Transfer Stage Transition Interrupt Enable                    */
      __IO uint16_t  DVSE       :  1;               /*!< Device State Transition Interrupt Enable                              */
      __IO uint16_t  SOFE       :  1;               /*!< Frame Number Update Interrupt Enable                                  */
      __IO uint16_t  RSME       :  1;               /*!< Resume Interrupt Enable                                               */
      __IO uint16_t  VBSE       :  1;               /*!< VBUS Interrupt Enable                                                 */
    } INTENB0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  INTENB1;                         /*!< Interrupt Enable Register 1                                           */

    struct {
           uint16_t             :  4;
      __IO uint16_t  SACKE      :  1;               /*!< Setup Transaction Normal Response Interrupt Enable                    */
      __IO uint16_t  SIGNE      :  1;               /*!< Setup Transaction Error Interrupt Enable                              */
      __IO uint16_t  EOFERRE    :  1;               /*!< EOF Error Detection Interrupt Enable                                  */
           uint16_t             :  4;
      __IO uint16_t  ATTCHE     :  1;               /*!< Connection Detection Interrupt Enable                                 */
      __IO uint16_t  DTCHE      :  1;               /*!< Disconnection Detection Interrupt Enable                              */
           uint16_t             :  1;
      __IO uint16_t  BCHGE      :  1;               /*!< USB Bus Change Interrupt Enable                                       */
      __IO uint16_t  OVRCRE     :  1;               /*!< Overcurrent Input Change Interrupt Enable                             */
    } INTENB1_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED7;

  union {
    __IO uint16_t  BRDYENB;                         /*!< BRDY Interrupt Enable Register                                        */

    struct {
      __IO uint16_t  PIPE0BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE0                                       */
      __IO uint16_t  PIPE1BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE1                                       */
      __IO uint16_t  PIPE2BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE2                                       */
      __IO uint16_t  PIPE3BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE3                                       */
      __IO uint16_t  PIPE4BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE4                                       */
      __IO uint16_t  PIPE5BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE5                                       */
      __IO uint16_t  PIPE6BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE6                                       */
      __IO uint16_t  PIPE7BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE7                                       */
      __IO uint16_t  PIPE8BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE8                                       */
      __IO uint16_t  PIPE9BRDY  :  1;               /*!< BRDY Interrupt Enable for PIPE9                                       */
    } BRDYENB_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  NRDYENB;                         /*!< NRDY Interrupt Enable Register                                        */

    struct {
      __IO uint16_t  PIPE0NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE0                                       */
      __IO uint16_t  PIPE1NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE1                                       */
      __IO uint16_t  PIPE2NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE2                                       */
      __IO uint16_t  PIPE3NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE3                                       */
      __IO uint16_t  PIPE4NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE4                                       */
      __IO uint16_t  PIPE5NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE5                                       */
      __IO uint16_t  PIPE6NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE6                                       */
      __IO uint16_t  PIPE7NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE7                                       */
      __IO uint16_t  PIPE8NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE8                                       */
      __IO uint16_t  PIPE9NRDY  :  1;               /*!< NRDY Interrupt Enable for PIPE9                                       */
    } NRDYENB_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  BEMPENB;                         /*!< BEMP Interrupt Enable Register                                        */

    struct {
      __IO uint16_t  PIPE0BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE0                                       */
      __IO uint16_t  PIPE1BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE1                                       */
      __IO uint16_t  PIPE2BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE2                                       */
      __IO uint16_t  PIPE3BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE3                                       */
      __IO uint16_t  PIPE4BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE4                                       */
      __IO uint16_t  PIPE5BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE5                                       */
      __IO uint16_t  PIPE6BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE6                                       */
      __IO uint16_t  PIPE7BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE7                                       */
      __IO uint16_t  PIPE8BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE8                                       */
      __IO uint16_t  PIPE9BEMP  :  1;               /*!< BEMP Interrupt Enable for PIPE9                                       */
    } BEMPENB_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  SOFCFG;                          /*!< SOF Output Configuration Register                                     */

    struct {
           uint16_t             :  4;
      __I  uint16_t  EDGESTS    :  1;               /*!< Edge Interrupt Output Status Monitor                                  */
           uint16_t             :  1;
      __IO uint16_t  BRDYM      :  1;               /*!< BRDY Interrupt Status Clear Timing                                    */
           uint16_t             :  1;
      __IO uint16_t  TRNENSEL   :  1;               /*!< Transaction-Enabled Time Select                                       */
    } SOFCFG_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED8;

  union {
    __IO uint16_t  INTSTS0;                         /*!< Interrupt Status Register 0                                           */

    struct {
      __I  uint16_t  CTSQ       :  3;               /*!< Control Transfer Stage                                                */
      __IO uint16_t  VALID      :  1;               /*!< USB Request Reception                                                 */
      __I  uint16_t  DVSQ       :  3;               /*!< Device State                                                          */
      __I  uint16_t  VBSTS      :  1;               /*!< VBUS Input Status                                                     */
      __I  uint16_t  BRDY       :  1;               /*!< Buffer Ready Interrupt Status                                         */
      __I  uint16_t  NRDY       :  1;               /*!< Buffer Not Ready Interrupt Status                                     */
      __I  uint16_t  BEMP       :  1;               /*!< Buffer Empty Interrupt Status                                         */
      __IO uint16_t  CTRT       :  1;               /*!< Control Transfer Stage Transition Interrupt Status                    */
      __IO uint16_t  DVST       :  1;               /*!< Device State Transition Interrupt Status                              */
      __IO uint16_t  SOFR       :  1;               /*!< Frame Number Refresh Interrupt Status                                 */
      __IO uint16_t  RESM       :  1;               /*!< Resume Interrupt Status                                               */
      __IO uint16_t  VBINT      :  1;               /*!< VBUS Interrupt Status                                                 */
    } INTSTS0_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  INTSTS1;                         /*!< Interrupt Status Register 1                                           */

    struct {
           uint16_t             :  4;
      __IO uint16_t  SACK       :  1;               /*!< Setup Transaction Normal Response Interrupt Status                    */
      __IO uint16_t  SIGN       :  1;               /*!< Setup Transaction Error Interrupt Status                              */
      __IO uint16_t  EOFERR     :  1;               /*!< EOF Error Detection Interrupt Status                                  */
           uint16_t             :  4;
      __IO uint16_t  ATTCH      :  1;               /*!< ATTCH Interrupt Status                                                */
      __IO uint16_t  DTCH       :  1;               /*!< USB Disconnection Detection Interrupt Status                          */
           uint16_t             :  1;
      __IO uint16_t  BCHG       :  1;               /*!< USB Bus Change Interrupt Status                                       */
      __IO uint16_t  OVRCR      :  1;               /*!< Overcurrent Input Change Interrupt Status                             */
    } INTSTS1_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED9;

  union {
    __IO uint16_t  BRDYSTS;                         /*!< BRDY Interrupt Status Register                                        */

    struct {
      __IO uint16_t  PIPE0BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE0                                       */
      __IO uint16_t  PIPE1BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE1                                       */
      __IO uint16_t  PIPE2BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE2                                       */
      __IO uint16_t  PIPE3BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE3                                       */
      __IO uint16_t  PIPE4BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE4                                       */
      __IO uint16_t  PIPE5BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE5                                       */
      __IO uint16_t  PIPE6BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE6                                       */
      __IO uint16_t  PIPE7BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE7                                       */
      __IO uint16_t  PIPE8BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE8                                       */
      __IO uint16_t  PIPE9BRDY  :  1;               /*!< BRDY Interrupt Status for PIPE9                                       */
    } BRDYSTS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  NRDYSTS;                         /*!< NRDY Interrupt Status Register                                        */

    struct {
      __IO uint16_t  PIPE0NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE0                                       */
      __IO uint16_t  PIPE1NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE1                                       */
      __IO uint16_t  PIPE2NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE2                                       */
      __IO uint16_t  PIPE3NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE3                                       */
      __IO uint16_t  PIPE4NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE4                                       */
      __IO uint16_t  PIPE5NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE5                                       */
      __IO uint16_t  PIPE6NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE6                                       */
      __IO uint16_t  PIPE7NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE7                                       */
      __IO uint16_t  PIPE8NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE8                                       */
      __IO uint16_t  PIPE9NRDY  :  1;               /*!< NRDY Interrupt Status for PIPE9                                       */
    } NRDYSTS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  BEMPSTS;                         /*!< BEMP Interrupt Status Register                                        */

    struct {
      __IO uint16_t  PIPE0BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE0                                       */
      __IO uint16_t  PIPE1BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE1                                       */
      __IO uint16_t  PIPE2BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE2                                       */
      __IO uint16_t  PIPE3BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE3                                       */
      __IO uint16_t  PIPE4BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE4                                       */
      __IO uint16_t  PIPE5BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE5                                       */
      __IO uint16_t  PIPE6BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE6                                       */
      __IO uint16_t  PIPE7BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE7                                       */
      __IO uint16_t  PIPE8BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE8                                       */
      __IO uint16_t  PIPE9BEMP  :  1;               /*!< BEMP Interrupt Status for PIPE9                                       */
    } BEMPSTS_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  FRMNUM;                          /*!< Frame Number Register                                                 */

    struct {
      __I  uint16_t  FRNM       : 11;               /*!< Frame NumberLatest frame number                                       */
           uint16_t             :  3;
      __IO uint16_t  CRCE       :  1;               /*!< Receive Data Error                                                    */
      __IO uint16_t  OVRN       :  1;               /*!< Overrun/Underrun Detection Status                                     */
    } FRMNUM_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  DVCHGR;                          /*!< Device State Change Register                                          */

    struct {
           uint16_t             : 15;
      __IO uint16_t  DVCHG      :  1;               /*!< Device State Change                                                   */
    } DVCHGR_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  USBADDR;                         /*!< USB Address Register                                                  */

    struct {
      __IO uint16_t  USBADDR    :  7;               /*!< USB AddressWhen the function controller is selected, these bits
                                                         indicate the USB address assigned by the host when the SET_ADDRESS
                                                          request is successfully processed.                                   */
           uint16_t             :  1;
      __IO uint16_t  STSRECOV   :  4;               /*!< Status Recovery                                                       */
    } USBADDR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED10;

  union {
    __IO uint16_t  USBREQ;                          /*!< USB Request Type Register                                             */

    struct {
      __IO uint16_t  BMREQUESTTYPE:  8;             /*!< Request TypeThese bits store the USB request bmRequestType value.     */
      __IO uint16_t  BREQUEST   :  8;               /*!< RequestThese bits store the USB request bRequest value.               */
    } USBREQ_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  USBVAL;                          /*!< USB Request Value Register                                            */

    struct {
      __IO uint16_t  WVALUE     : 16;               /*!< ValueThese bits store the USB request wValue value.                   */
    } USBVAL_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  USBINDX;                         /*!< USB Request Index Register                                            */

    struct {
      __IO uint16_t  WINDEX     : 16;               /*!< IndexThese bits store the USB request wIndex value.                   */
    } USBINDX_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  USBLENG;                         /*!< USB Request Length Register                                           */

    struct {
      __IO uint16_t  WLENGTH    : 16;               /*!< LengthThese bits store the USB request wLength value.                 */
    } USBLENG_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  DCPCFG;                          /*!< DCP Configuration Register                                            */

    struct {
           uint16_t             :  4;
      __IO uint16_t  DIR        :  1;               /*!< Transfer Direction                                                    */
           uint16_t             :  2;
      __IO uint16_t  SHTNAK     :  1;               /*!< Pipe Disabled at End of Transfer                                      */
    } DCPCFG_b;                                     /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  DCPMAXP;                         /*!< DCP Maximum Packet Size Register                                      */

    struct {
      __IO uint16_t  MXPS       :  7;               /*!< Maximum Packet SizeThese bits set the maximum amount of data
                                                         (maximum packet size) in payloads for the DCP.                        */
           uint16_t             :  5;
      __IO uint16_t  DEVSEL     :  4;               /*!< Device Select                                                         */
    } DCPMAXP_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  DCPCTR;                          /*!< DCP Control Register                                                  */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
      __IO uint16_t  CCPL       :  1;               /*!< Control Transfer End Enable                                           */
           uint16_t             :  2;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Monitor                                           */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
           uint16_t             :  2;
      __IO uint16_t  SUREQCLR   :  1;               /*!< SUREQ Bit Clear                                                       */
           uint16_t             :  2;
      __IO uint16_t  SUREQ      :  1;               /*!< Setup Token Transmission                                              */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } DCPCTR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED11;

  union {
    __IO uint16_t  PIPESEL;                         /*!< Pipe Window Select Register                                           */

    struct {
      __IO uint16_t  PIPESEL    :  4;               /*!< Pipe Window Select                                                    */
    } PIPESEL_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED12;

  union {
    __IO uint16_t  PIPECFG;                         /*!< Pipe Configuration Register                                           */

    struct {
      __IO uint16_t  EPNUM      :  4;               /*!< Endpoint NumberThese bits specify the endpoint number for the
                                                         selected pipe.Setting 0000b means unused pipe.                        */
      __IO uint16_t  DIR        :  1;               /*!< Transfer Direction                                                    */
           uint16_t             :  2;
      __IO uint16_t  SHTNAK     :  1;               /*!< Pipe Disabled at End of Transfer                                      */
           uint16_t             :  1;
      __IO uint16_t  DBLB       :  1;               /*!< Double Buffer Mode                                                    */
      __IO uint16_t  BFRE       :  1;               /*!< BRDY Interrupt Operation Specification                                */
           uint16_t             :  3;
      __IO uint16_t  TYPE       :  2;               /*!< Transfer Type                                                         */
    } PIPECFG_b;                                    /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED13;

  union {
    __IO uint16_t  PIPEMAXP;                        /*!< Pipe Maximum Packet Size Register                                     */

    struct {
      __IO uint16_t  MXPS       :  9;               /*!< Maximum Packet SizePIPE1 and PIPE2: 1 byte (001h) to 256 bytes
                                                         (100h)PIPE3 to PIPE5: 8 bytes (008h), 16 bytes (010h), 32 bytes
                                                          (020h), 64 bytes (040h) (Bits [8:7] and [2:0] are not provided.)PIPE6
                                                          to PIPE9: 1 byte (001h) to 64 bytes (040h) (Bits [8:7] are not
                                                          provided.)                                                           */
           uint16_t             :  3;
      __IO uint16_t  DEVSEL     :  4;               /*!< Device Select                                                         */
    } PIPEMAXP_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPEPERI;                        /*!< Pipe Cycle Control Register                                           */

    struct {
      __IO uint16_t  IITV       :  3;               /*!< Interval Error Detection IntervalSpecifies the interval error
                                                         detection timing for the selected pipe in terms of frames, which
                                                          is expressed as nth power of 2.                                      */
           uint16_t             :  9;
      __IO uint16_t  IFIS       :  1;               /*!< Isochronous IN Buffer Flush                                           */
    } PIPEPERI_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE1CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response Mode                                                    */
           uint16_t             :  3;
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer Monitor                                               */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE1CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE2CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response Mode                                                    */
           uint16_t             :  3;
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer Monitor                                               */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE2CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE3CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response Mode                                                    */
           uint16_t             :  3;
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer Monitor                                               */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE3CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE4CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response Mode                                                    */
           uint16_t             :  3;
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer Monitor                                               */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE4CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE5CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response Mode                                                    */
           uint16_t             :  3;
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer Monitor                                               */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE5CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE6CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
           uint16_t             :  5;
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE6CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE7CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
           uint16_t             :  5;
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE7CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE8CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
           uint16_t             :  5;
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE8CTR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE9CTR;                        /*!< Pipe %s Control Register                                              */

    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Confirmation                                      */
      __IO uint16_t  SQSET      :  1;               /*!< Sequence Toggle Bit Set                                               */
      __IO uint16_t  SQCLR      :  1;               /*!< Sequence Toggle Bit Clear                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear Mode                                                */
           uint16_t             :  5;
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } PIPE9CTR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED14[7];

  union {
    __IO uint16_t  PIPE1TRE;                        /*!< Pipe %s Transaction Counter Enable Register                           */

    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter Clear                                             */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter Enable                                            */
    } PIPE1TRE_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE1TRN;                        /*!< Pipe %s Transaction Counter Register                                  */

    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction Counter                                                   */
    } PIPE1TRN_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE2TRE;                        /*!< Pipe %s Transaction Counter Enable Register                           */

    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter Clear                                             */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter Enable                                            */
    } PIPE2TRE_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE2TRN;                        /*!< Pipe %s Transaction Counter Register                                  */

    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction Counter                                                   */
    } PIPE2TRN_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE3TRE;                        /*!< Pipe %s Transaction Counter Enable Register                           */

    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter Clear                                             */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter Enable                                            */
    } PIPE3TRE_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE3TRN;                        /*!< Pipe %s Transaction Counter Register                                  */

    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction Counter                                                   */
    } PIPE3TRN_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE4TRE;                        /*!< Pipe %s Transaction Counter Enable Register                           */

    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter Clear                                             */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter Enable                                            */
    } PIPE4TRE_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE4TRN;                        /*!< Pipe %s Transaction Counter Register                                  */

    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction Counter                                                   */
    } PIPE4TRN_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE5TRE;                        /*!< Pipe %s Transaction Counter Enable Register                           */

    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter Clear                                             */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter Enable                                            */
    } PIPE5TRE_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint16_t  PIPE5TRN;                        /*!< Pipe %s Transaction Counter Register                                  */

    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction Counter                                                   */
    } PIPE5TRN_b;                                   /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED15[3];

  union {
    __IO uint16_t  USBBCCTRL0;                      /*!< BC Control Register 0                                                 */

    struct {
      __IO uint16_t  RPDME0     :  1;               /*!< D- Pin Pull-Down Control                                              */
      __IO uint16_t  IDPSRCE0   :  1;               /*!< D+ Pin IDPSRC Output Control                                          */
      __IO uint16_t  IDMSINKE0  :  1;               /*!< D- Pin 0.6 V Input Detection (Comparator and Sink) Control            */
      __IO uint16_t  VDPSRCE0   :  1;               /*!< D+ Pin VDPSRC (0.6 V) Output Control                                  */
      __IO uint16_t  IDPSINKE0  :  1;               /*!< D+ Pin 0.6 V Input Detection (Comparator and Sink) Control            */
      __IO uint16_t  VDMSRCE0   :  1;               /*!< D- Pin VDMSRC (0.6 V) Output Control                                  */
           uint16_t             :  1;
      __IO uint16_t  BATCHGE0   :  1;               /*!< BC (Battery Charger) Function Ch0 General Enable Control              */
      __IO uint16_t  CHGDETSTS0 :  1;               /*!< D- Pin 0.6 V Input Detection Status                                   */
      __IO uint16_t  PDDETSTS0  :  1;               /*!< D+ Pin 0.6 V Input Detection Status                                   */
    } USBBCCTRL0_b;                                 /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED16[13];

  union {
    __IO uint16_t  USBMC;                           /*!< USB Module Control Register                                           */

    struct {
      __IO uint16_t  VDDUSBE    :  1;               /*!< USB Reference Power Supply Circuit On/Off Control                     */
           uint16_t             :  6;
      __IO uint16_t  VDCEN      :  1;               /*!< USB Regulator On/Off Control                                          */
    } USBMC_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED17;

  union {
    __IO uint16_t  DEVADDn[6];                      /*!< Device Address %s Configuration Register                              */

    struct {
           uint16_t             :  6;
      __IO uint16_t  USBSPD     :  2;               /*!< Transfer Speed of Communication Target Device                         */
    } DEVADDn_b[6];                                 /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED18[5];

  union {
    __IO uint32_t  PHYSLEW;                         /*!< PHY Cross Point Adjustment Register                                   */

    struct {
      __IO uint32_t  SLEWR00    :  1;               /*!< Receiver Cross Point Adjustment 00                                    */
      __IO uint32_t  SLEWR01    :  1;               /*!< Receiver Cross Point Adjustment 01                                    */
      __IO uint32_t  SLEWF00    :  1;               /*!< Receiver Cross Point Adjustment 00                                    */
      __IO uint32_t  SLEWF01    :  1;               /*!< Receiver Cross Point Adjustment 01                                    */
    } PHYSLEW_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED19[195];

  union {
    __IO uint32_t  DPUSR0R;                         /*!< Deep Standby USB Transceiver Control/Pin Monitoring Register          */

    struct {
      __IO uint32_t  SRPC0      :  1;               /*!< USB Single End Receiver Control                                       */
      __IO uint32_t  RPUE0      :  1;               /*!< DP Pull-Up Resistor Control                                           */
           uint32_t             :  1;
      __IO uint32_t  DRPD0      :  1;               /*!< D+/D- Pull-Down Resistor Control                                      */
      __IO uint32_t  FIXPHY0    :  1;               /*!< USB Transceiver Output Fix                                            */
           uint32_t             : 11;
      __I  uint32_t  DP0        :  1;               /*!< USB0 D+ InputIndicates the D+ input signal of the USB.                */
      __I  uint32_t  DM0        :  1;               /*!< USB D-InputIndicates the D- input signal of the USB.                  */
           uint32_t             :  2;
      __I  uint32_t  DOVCA0     :  1;               /*!< USB OVRCURA InputIndicates the OVRCURA input signal of the USB.       */
      __I  uint32_t  DOVCB0     :  1;               /*!< USB OVRCURB InputIndicates the OVRCURB input signal of the USB.       */
           uint32_t             :  1;
      __I  uint32_t  DVBSTS0    :  1;               /*!< USB VBUS InputIndicates the VBUS input signal of the USB.             */
    } DPUSR0R_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  DPUSR1R;                         /*!< Deep Standby USB Suspend/Resume Interrupt Register                    */

    struct {
      __IO uint32_t  DPINTE0    :  1;               /*!< USB DP Interrupt Enable/Clear                                         */
      __IO uint32_t  DMINTE0    :  1;               /*!< USB DM Interrupt Enable/Clear                                         */
           uint32_t             :  2;
      __IO uint32_t  DOVRCRAE0  :  1;               /*!< USB OVRCURA Interrupt Enable/Clear                                    */
      __IO uint32_t  DOVRCRBE0  :  1;               /*!< USB OVRCURB Interrupt Enable/Clear                                    */
           uint32_t             :  1;
      __IO uint32_t  DVBSE0     :  1;               /*!< USB VBUS Interrupt Enable/Clear                                       */
           uint32_t             :  8;
      __I  uint32_t  DPINT0     :  1;               /*!< USB DP Interrupt Source Recovery                                      */
      __I  uint32_t  DMINT0     :  1;               /*!< USB DM Interrupt Source Recovery                                      */
           uint32_t             :  2;
      __I  uint32_t  DOVRCRA0   :  1;               /*!< USB OVRCURA Interrupt Source Recovery                                 */
      __I  uint32_t  DOVRCRB0   :  1;               /*!< USB OVRCURB Interrupt Source Recovery                                 */
           uint32_t             :  1;
      __I  uint32_t  DVBINT0    :  1;               /*!< USB VBUS Interrupt Source Recovery                                    */
    } DPUSR1R_b;                                    /*!< BitSize                                                               */
  };
} R_USBFS_Type;


/* ================================================================================ */
/* ================                     R_FACI                     ================ */
/* ================================================================================ */


/**
  * @brief Flash Application Command Interface (R_FACI)
  */

typedef struct {                                    /*!< R_FACI Structure                                                      */
  __I  uint32_t  RESERVED[36];
  __IO uint8_t   DFLCTL;                            /*!< Flash P/E Mode Control Register                                       */
  __I  uint8_t   RESERVED1[111];

  union {
    __IO uint8_t   FPMCR;                           /*!< Flash P/E Mode Control Register                                       */

    struct {
           uint8_t              :  1;
      __IO uint8_t   FMS0       :  1;               /*!< Flash Operating Mode Select 0FMS2,1,0: 000: Read mode 011: Discharge
                                                         mode 1 111: Discharge mode 2 101: Code Flash P/E mode 010: Data
                                                          flash P/E mode Others: Setting prohibited.                           */
           uint8_t              :  1;
      __IO uint8_t   RPDIS      :  1;               /*!< Code Flash P/E Disable                                                */
      __IO uint8_t   FMS1       :  1;               /*!< The bit to make data flash a programming modeRefer to the description
                                                         of the FMS0 bit.                                                      */
           uint8_t              :  1;
      __IO uint8_t   VLPE       :  1;               /*!< Low-Voltage P/E Mode Enable                                           */
      __IO uint8_t   FMS2       :  1;               /*!< Flash Operating Mode Select 2.Refer to the description of the
                                                         FMS0 bit.                                                             */
    } FPMCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2[3];

  union {
    __IO uint8_t   FASR;                            /*!< Flash Area Select Register                                            */

    struct {
      __IO uint8_t   EXS        :  1;               /*!< Extra area select                                                     */
    } FASR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED3[3];

  union {
    __IO uint16_t  FSARL;                           /*!< Flash Processing Start Address Register L                             */

    struct {
      __IO uint16_t  FSAR15_0   : 16;               /*!< Start address                                                         */
    } FSARL_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED4[3];

  union {
    __IO uint16_t  FSARH;                           /*!< Flash Processing Start Address Register H                             */

    struct {
      __IO uint16_t  FSAR20_16  :  5;               /*!< Start address                                                         */
           uint16_t             :  4;
      __IO uint16_t  FSAR31_25  :  7;               /*!< Start address                                                         */
    } FSARH_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED5;

  union {
    __IO uint8_t   FCR;                             /*!< Flash Control Register                                                */

    struct {
      __IO uint8_t   CMD        :  4;               /*!< Software Command Setting                                              */
      __IO uint8_t   DRC        :  1;               /*!< Data Read Completion                                                  */
           uint8_t              :  1;
      __IO uint8_t   STOP       :  1;               /*!< Forced Processing Stop                                                */
      __IO uint8_t   OPST       :  1;               /*!< Processing Start                                                      */
    } FCR_b;                                        /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED6[3];

  union {
    __IO uint16_t  FEARL;                           /*!< Flash Processing End Address Register L                               */

    struct {
      __IO uint16_t  FEAR15_0   : 16;               /*!< End address                                                           */
    } FEARL_b;                                      /*!< BitSize                                                               */
  };
  __I  uint16_t  RESERVED7[3];

  union {
    __IO uint32_t  FEARH;                           /*!< Flash Processing End Address Register H                               */

    struct {
      __IO uint32_t  FEAR20_16  :  5;               /*!< End address                                                           */
           uint32_t             :  4;
      __IO uint32_t  FEAR31_25  :  7;               /*!< End address                                                           */
    } FEARH_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  FRESETR;                         /*!< Flash Reset Register                                                  */

    struct {
      __IO uint32_t  FRESET     :  1;               /*!< Software Reset of the registers                                       */
    } FRESETR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FSTATR00;                        /*!< Flash Status Register00                                               */

    struct {
      __I  uint32_t  ERERR0     :  1;               /*!< Erase Error Flag0                                                     */
      __I  uint32_t  PRGERR0    :  1;               /*!< Program Error Flag0                                                   */
      __I  uint32_t  PRGERR01   :  1;               /*!< Program Error Flag 01                                                 */
      __I  uint32_t  BCERR0     :  1;               /*!< Blank Check Error Flag0                                               */
      __I  uint32_t  ILGLERR    :  1;               /*!< Illegal Command Error Flag                                            */
      __I  uint32_t  EILGLERR   :  1;               /*!< Extra Area Illegal Command Error Flag                                 */
    } FSTATR00_b;                                   /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FSTATR1;                         /*!< Flash Status Register1                                                */

    struct {
           uint32_t             :  1;
      __I  uint32_t  DRRDY      :  1;               /*!< Data read request                                                     */
           uint32_t             :  4;
      __I  uint32_t  FRDY       :  1;               /*!< End status signal of a sequencer                                      */
      __I  uint32_t  EXRDY      :  1;               /*!< End status signal of a Extra programming sequencer                    */
    } FSTATR1_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  FWBL0;                           /*!< Flash Write Buffer Register L0                                        */

    struct {
      __IO uint32_t  WDATA      : 16;               /*!< Program data of the program command                                   */
    } FWBL0_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED8;

  union {
    __IO uint32_t  FWBH0;                           /*!< Flash Write Buffer Register H0                                        */

    struct {
      __IO uint32_t  WDATA      : 16;               /*!< Program data of the program command                                   */
    } FWBH0_b;                                      /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FSTATR01;                        /*!< Flash Status Register01                                               */

    struct {
      __I  uint32_t  ERERR1     :  1;               /*!< Erase Error Flag1                                                     */
      __I  uint32_t  PRGERR1    :  1;               /*!< Program Error Flag1                                                   */
           uint32_t             :  1;
      __I  uint32_t  BCERR1     :  1;               /*!< Blank Check Error Flag1                                               */
    } FSTATR01_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  FWBL1;                           /*!< Flash Write Buffer Register L1                                        */

    struct {
      __IO uint32_t  WDATA47_32 : 16;               /*!< Program data of the program command                                   */
    } FWBL1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  FWBH1;                           /*!< Flash Write Buffer Register H1                                        */

    struct {
      __IO uint32_t  WDATA63_48 : 16;               /*!< Program data of the program command                                   */
    } FWBH1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FRBL1;                           /*!< Flash Read Buffer Register L1                                         */

    struct {
      __I  uint32_t  RDATA47_32 : 16;               /*!< Read data of the consecutive read command                             */
    } FRBL1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FRBH1;                           /*!< Flash Read Buffer Register H1                                         */

    struct {
      __I  uint32_t  RDATA63_48 : 16;               /*!< Read data of the consecutive read command                             */
    } FRBH1_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED9[12];

  union {
    __O  uint32_t  FPR;                             /*!< Protection Unlock Register                                            */

    struct {
      __O  uint32_t  FPR        :  8;               /*!< Protection Unlock Register                                            */
    } FPR_b;                                        /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FPSR;                            /*!< Protection Unlock Status Register                                     */

    struct {
      __I  uint32_t  PERR       :  1;               /*!< Protect Error Flag                                                    */
    } FPSR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FRBL0;                           /*!< Flash Read Buffer Register L0                                         */

    struct {
      __I  uint32_t  RDATA      : 16;               /*!< Read data of the consecutive read command                             */
    } FRBL0_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED10;

  union {
    __I  uint32_t  FRBH0;                           /*!< Flash Read Buffer Register H0                                         */

    struct {
      __I  uint32_t  RDATA      : 16;               /*!< Read data of the consecutive read command                             */
    } FRBH0_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED11[11];

  union {
    __I  uint32_t  FSCMR;                           /*!< Flash Start-Up Setting Monitor Register                               */

    struct {
           uint32_t             :  8;
      __I  uint32_t  SASMF      :  1;               /*!< Start-up Area Setting Monitor Flag                                    */
           uint32_t             :  5;
      __I  uint32_t  FSPR       :  1;               /*!< Access Window Protection Flag                                         */
    } FSCMR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED12;

  union {
    __I  uint32_t  FAWSMR;                          /*!< Flash Access Window Start Address Monitor Register                    */

    struct {
      __I  uint32_t  FAWS       : 12;               /*!< Flash Access Window Start Address                                     */
    } FAWSMR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED13;

  union {
    __I  uint32_t  FAWEMR;                          /*!< Flash Access Window End Address Monitor Register                      */

    struct {
      __I  uint32_t  FAWE       : 12;               /*!< Flash Access Window End Address                                       */
    } FAWEMR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED14;

  union {
    __IO uint32_t  FISR;                            /*!< Flash Initial Setting Register                                        */

    struct {
      __IO uint32_t  PCKA       :  5;               /*!< Peripheral Clock Notification                                         */
           uint32_t             :  1;
      __IO uint32_t  SAS        :  2;               /*!< Temporary boot swap mode                                              */
    } FISR_b;                                       /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  FEXCR;                           /*!< Flash Extra Area Control Register                                     */

    struct {
      __IO uint32_t  CMD        :  3;               /*!< Processing Start)                                                     */
           uint32_t             :  4;
      __IO uint32_t  OPST       :  1;               /*!< Software Command Setting                                              */
    } FEXCR_b;                                      /*!< BitSize                                                               */
  };

  union {
    __I  uint32_t  FEAML;                           /*!< Flash Error Address Monitor Register L                                */

    struct {
      __I  uint32_t  FEAM       : 16;               /*!< Flash Error Address Monitor Register                                  */
    } FEAML_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED15;

  union {
    __I  uint32_t  FEAMH;                           /*!< Flash Error Address Monitor Register H                                */

    struct {
      __I  uint32_t  FEAM       : 16;               /*!< Flash Error Address Monitor Register                                  */
    } FEAMH_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  RESERVED16;

  union {
    __I  uint32_t  FSTATR2;                         /*!< Flash Status Register2                                                */

    struct {
      __I  uint32_t  ERERR      :  1;               /*!< Erase Error Flag                                                      */
      __I  uint32_t  PRGERR1    :  1;               /*!< Program Error Flag                                                    */
      __IO uint32_t  PRGERR01   :  1;               /*!< Program Error Flag 01                                                 */
      __I  uint32_t  BCERR      :  1;               /*!< Blank Check Error Flag                                                */
      __I  uint32_t  ILGLERR    :  1;               /*!< Illegal Command Error Flag                                            */
      __I  uint32_t  EILGLERR   :  1;               /*!< Extra Area Illegal Command Error Flag                                 */
    } FSTATR2_b;                                    /*!< BitSize                                                               */
  };
 // __I  uint16_t  RESERVED17[223];
    __I  uint16_t  RESERVED17[7903];


  __IO uint16_t  FENTRYR;                           /*!< Flash P/E Mode Entry Register                                         */
  __I  uint32_t  RESERVED18[3];
  __IO uint8_t   FLWAITR;                           /*!< Flash Wait Cycle Register                                             */
} R_FACI_Type;

/* =========================================================================================================================== */
/* ================                                        R_SDADC0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief R_SDADC0 (R_SDADC0)
  */

typedef struct {                                /*!< (@ 0x4009C000) SDADC0 Structure                                           */

  union {
    __IOM uint16_t STC1;                        /*!< (@ 0x00000000) Startup Control Register 1                                 */

    struct {
      __IOM uint16_t CLKDIV     : 4;            /*!< [3..0] SDADC24 Reference Clock Division                                   */
      __IM  uint16_t            : 3;
      __IOM uint16_t SDADLPM    : 1;            /*!< [7..7] A/D conversion operation model select                              */
      __IOM uint16_t VSBIAS     : 4;            /*!< [11..8] VSBIAS                                                            */
      __IM  uint16_t            : 3;
      __IOM uint16_t VREFSEL    : 1;            /*!< [15..15] VREFSEL                                                          */
    } STC1_b;
  } ;
  __IM  uint16_t  RESERVED;

  union {
    __IOM uint8_t STC2;                         /*!< (@ 0x00000004) Startup Control Register 2                                 */

    struct {
      __IOM uint8_t BGRPON      : 1;            /*!< [0..0] BGRPON                                                             */
      __IOM uint8_t ADCPON      : 1;            /*!< [1..1] ADCPON                                                             */
      __IOM uint8_t ADFPWDS     : 1;            /*!< [2..2] ADFPWDS                                                            */
    } STC2_b;
  } ;
  __IM  uint8_t   RESERVED1;
  __IM  uint16_t  RESERVED2;

  union {
    __IOM uint32_t PGAC[5];                     /*!< (@ 0x00000008) Input Multiplexer [0..4] Setting Register                  */

    struct {
      __IOM uint32_t PGAGC      : 5;            /*!< [4..0] Gain selection of a programmable gain instrumentation
                                                     amplifier ( Gset1, Gset2, Gtotal )                                        */
      __IOM uint32_t PGAOSR     : 3;            /*!< [7..5] Oversampling ratio select                                          */
      __IOM uint32_t PGAOFS     : 5;            /*!< [12..8] Offset voltage select                                             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGAPOL     : 1;            /*!< [14..14] Polarity select                                                  */
      __IOM uint32_t PGASEL     : 1;            /*!< [15..15] Analog Channel Input Mode Select                                 */
      __IOM uint32_t PGACTM     : 5;            /*!< [20..16] Coefficient (m) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGACTN     : 3;            /*!< [23..21] Coefficient (n) selection of the A/D conversion count
                                                     (N) in AUTOSCAN                                                           */
      __IOM uint32_t PGAAVN     : 2;            /*!< [25..24] Selection of the number of data to be averaged                   */
      __IOM uint32_t PGAAVE     : 2;            /*!< [27..26] Selection of averaging processing                                */
      __IOM uint32_t PGAREV     : 1;            /*!< [28..28] Single-End Input A/D Converted Data Inversion Select             */
      __IM  uint32_t            : 1;
      __IOM uint32_t PGACVE     : 1;            /*!< [30..30] Calibration enable                                               */
      __IOM uint32_t PGAASN     : 1;            /*!< [31..31] Selection of the mode for specifying the number of
                                                     A/D conversions in ADSCAN                                                 */
    } PGAC_b[5];
  } ;

  union {
    __IOM uint32_t ADC1;                        /*!< (@ 0x0000001C) Sigma-Delta A/D Converter Control Register 1               */

    struct {
      __IOM uint32_t SDADSCM    : 1;            /*!< [0..0] Selection of autoscan mode                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t SDADTMD    : 1;            /*!< [4..4] Selection of A/D conversion trigger signal                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t SDADBMP    : 5;            /*!< [12..8] A/D conversion control of the signal from input multiplexer       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PGADISA    : 1;            /*!< [16..16] Control of disconnection detection                               */
      __IOM uint32_t PGADISC    : 1;            /*!< [17..17] Disconnection Detection Assist Setting                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PGASLFT    : 1;            /*!< [20..20] PGA offset self-diagnosis enable                                 */
    } ADC1_b;
  } ;

  union {
    __IOM uint8_t ADC2;                         /*!< (@ 0x00000020) Sigma-Delta A/D Converter Control Register 2               */

    struct {
      __IOM uint8_t SDADST      : 1;            /*!< [0..0] Control of A/D conversion                                          */
    } ADC2_b;
  } ;
  __IM  uint8_t   RESERVED3;
  __IM  uint16_t  RESERVED4;

  union {
    __IOM uint32_t ADCR;                        /*!< (@ 0x00000024) Sigma-delta A/D Converter Conversion Result Register       */

    struct {
      __IM  uint32_t SDADCRD    : 24;           /*!< [23..0] The 24-bit A/D conversion result                                  */
      __IM  uint32_t SDADCRS    : 1;            /*!< [24..24] Status of an A/D conversion result                               */
      __IM  uint32_t SDADCRC    : 3;            /*!< [27..25] Channel number for an A/D conversion result                      */
    } ADCR_b;
  } ;

  union {
    __IM  uint32_t ADAR;                        /*!< (@ 0x00000028) Sigma-delta A/D Converter Average Value Register           */

    struct {
      __IM  uint32_t SDADMVD    : 24;           /*!< [23..0] The 24-bit A/D average value                                      */
      __IM  uint32_t SDADMVS    : 1;            /*!< [24..24] Status of an A/D conversion result                               */
      __IM  uint32_t SDADMVC    : 3;            /*!< [27..25] Channel number for an A/D conversion result                      */
    } ADAR_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint8_t CLBC;                         /*!< (@ 0x00000030) Calibration Control Register                               */

    struct {
      __IOM uint8_t CLBMD       : 2;            /*!< [1..0] These bits are read as 0. The write value should be 0.             */