#!/bin/sh

# this shell script refreshes world timezone definitions in
#   cores/rp2040/TZ.h
#
# to run it, use:
#   /path/to/TZupdate.sh
#   tools/TZupdate.sh
#   ./TZupdate.sh

dir=$(cd ${0%/*} 2>/dev/null; pwd)
base=${0##*/}

csv=https://raw.githubusercontent.com/nayarsystems/posix_tz_db/master/zones.csv

set -e

tz_tmpdir=$(mktemp -d)
trap 'rm -r $tz_tmpdir' EXIT

input=$tz_tmpdir/zones.csv
names=$tz_tmpdir/names.txt
values=$tz_tmpdir/values.txt

wget -O $input $csv  || curl $csv > $input

sed -e 's/^[^,]*,//g' -e 's,^,(,g' -e 's,$,),g' < $input > $values
sed -e 's/^\([^,]*\),.*/#define TZ_\1/g' -e 's,["],,g' < $input | tr '/\-+' '_mp' > $names

(

cat << EOF

// autogenerated from $csv
// by script <rp2040 arduino core>/tools/${base}
// $(date -u)
//
// This database is autogenerated from IANA timezone database
//    ${csv}
//    (using https://www.iana.org/time-zones)
// and can be updated on demand in this repository
// or by yourself using the above script

#pragma once

EOF

paste $names $values

) > $tz_tmpdir/TZ.h

backup=$(date +%s)
mv ${dir}/../cores/rp2040/TZ.h ${dir}/../cores/rp2040/TZ.h.$backup
mv $tz_tmpdir/TZ.h ${dir}/../cores/rp2040/TZ.h

cat << EOF

Done:
    '${dir}/../cores/rp2040/TZ.h' is updated

Diff:
----8<-------8<------8<---
$(diff -u ${dir}/../cores/rp2040/TZ.h.$backup ${dir}/../cores/rp2040/TZ.h)
--->8----->8------>8------

EOF
