#ifndef Arduino_h
#define Arduino_h

#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <basic.h>

typedef bool boolean;
typedef uint8_t byte;
typedef uint16_t word;

#include "wiring_constants.h"
/* sketch */
void setup( void );
void loop( void );

#include "WVariant.h"
#include "WCharacter.h"
#include "WString.h"
#include "WMath.h"
#include "delay.h"
#include "binary.h"
#include "uart.h"
extern uart Serial;

// Include board variant
#include "pins_arduino.h"
#include "Button.h"
#include "Touch.h"
#include "event.h"
#include "wiring_digital.h"
#include "wiring_analog.h"
#include "wiring_shift.h"
#include "WInterrupts.h"

// undefine stdlib's abs if encountered
#ifdef abs
#undef abs
#endif

// math
#define abs(x) ((x)>0?(x):-(x))
#define constrain(amt,low,high) ((amt)<(low)?(low):((amt)>(high)?(high):(amt)))
#define round(x)     ((x)>=0?(long)((x)+0.5):(long)((x)-0.5))
#define radians(deg) ((deg)*DEG_TO_RAD)
#define degrees(rad) ((rad)*RAD_TO_DEG)
#define sq(x) ((x)*(x))

// interrupts
#define interrupts() __enable_irq()
#define noInterrupts() __disable_irq()

// operation
#define lowByte(w) ((uint8_t) ((w) & 0xff))
#define highByte(w) ((uint8_t) ((w) >> 8))
#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitSet(value, bit) ((value) |= (1UL << (bit)))
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))
#define bitWrite(value, bit, bitvalue) (bitvalue ? bitSet(value, bit) : bitClear(value, bit))
#define bit(b) (1UL << (b))

// pin
#define digitalPinToPort(P)        ( &(NRF_GPIO[P]) )
#define digitalPinToBitMask(P)     ( 1 << g_ADigitalPinMap[P] )
#define portOutputRegister(port)   ( &(port->OUTSET) )
#define portInputRegister(port)    ( &(port->IN) )

#endif // Arduino_h
