#ifndef DF_Microbit_Event_H
#define DF_Microbit_Event_H
#include <Arduino.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_EVENT_NU 22

#define AR_MICROBIT_ID_IO_P0               7           //P0 is the left most pad (ANALOG/DIGITAL)
#define AR_MICROBIT_ID_IO_P1               8           //P1 is the middle pad (ANALOG/DIGITAL)
#define AR_MICROBIT_ID_IO_P2               9           //P2 is the right most pad (ANALOG/DIGITAL)
#define AR_MICROBIT_ID_IO_P3               10          //COL1 (ANALOG/DIGITAL)
#define AR_MICROBIT_ID_IO_P4               11          //BTN_A
#define AR_MICROBIT_ID_IO_P5               12          //COL2 (ANALOG/DIGITAL)
#define AR_MICROBIT_ID_IO_P6               13          //ROW2
#define AR_MICROBIT_ID_IO_P7               14          //ROW1
#define AR_MICROBIT_ID_IO_P8               15          //PIN 18
#define AR_MICROBIT_ID_IO_P9               16          //ROW3
#define AR_MICROBIT_ID_IO_P10              17          //COL3 (ANALOG/DIGITAL)
#define AR_MICROBIT_ID_IO_P11              18          //BTN_B
#define AR_MICROBIT_ID_IO_P12              19          //PIN 20
#define AR_MICROBIT_ID_IO_P13              20          //SCK
#define AR_MICROBIT_ID_IO_P14              21          //MISO
#define AR_MICROBIT_ID_IO_P15              22          //MOSI
#define AR_MICROBIT_ID_IO_P16              23          //PIN 16
#define AR_MICROBIT_ID_IO_P19              24          //SCL
#define AR_MICROBIT_ID_IO_P20              25          //SDA

#define AR_MICROBIT_ID_BUTTON_A            1
#define AR_MICROBIT_ID_BUTTON_B            2
#define AR_MICROBIT_ID_BUTTON_AB           26          // Button A+B multibutton

#define AR_MICROBIT_BUTTON_EVT_CLICK           3
//#define AR_MICROBIT_PIN_EVT_PULSE_HI           4
//#define AR_MICROBIT_PIN_EVT_PULSE_LO           5

enum ID{
    ID_P0 = AR_MICROBIT_ID_IO_P0,
    ID_P1 = AR_MICROBIT_ID_IO_P1,
    ID_P2 = AR_MICROBIT_ID_IO_P2,
    ID_P3 = AR_MICROBIT_ID_IO_P3,
    ID_P4 = AR_MICROBIT_ID_IO_P4,
    ID_P5 = AR_MICROBIT_ID_IO_P5,
    ID_P6 = AR_MICROBIT_ID_IO_P6,
    ID_P7 = AR_MICROBIT_ID_IO_P7,
    ID_P8 = AR_MICROBIT_ID_IO_P8,
    ID_P9 = AR_MICROBIT_ID_IO_P9,
    ID_P10 = AR_MICROBIT_ID_IO_P10,
    ID_P11 = AR_MICROBIT_ID_IO_P11,
    ID_P12 = AR_MICROBIT_ID_IO_P12,
    ID_P13 = AR_MICROBIT_ID_IO_P13,
    ID_P14 = AR_MICROBIT_ID_IO_P14,
    ID_P15 = AR_MICROBIT_ID_IO_P15,
    ID_P16 = AR_MICROBIT_ID_IO_P16,
    ID_P19 = AR_MICROBIT_ID_IO_P19,
    ID_P20 = AR_MICROBIT_ID_IO_P20,
    ID_BUTTON_B = AR_MICROBIT_ID_BUTTON_B,
    ID_BUTTON_A = AR_MICROBIT_ID_BUTTON_A,
    ID_BUTTON_AB = AR_MICROBIT_ID_BUTTON_AB
};


enum EVENT{
    PRESS = AR_MICROBIT_BUTTON_EVT_CLICK,
    TOUCH = AR_MICROBIT_BUTTON_EVT_CLICK
    //HIGHT = AR_MICROBIT_PIN_EVT_PULSE_HI,
    //LOW = AR_MICROBIT_PIN_EVT_PULSE_LO
};

typedef void (*voidFunc)(void);

extern void onEvent(ID id, EVENT event, voidFunc callback);

#ifdef __cplusplus
}
#endif

#endif
