/*
  Copyright (c) 2015 Arduino LLC.  All right reserved.
  Copyright (c) 2016 Sandeep Mistry All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "Arduino.h"

uart::uart(uint8_t _pinRX, uint8_t _pinTX)
{
  uc_pinRX = _pinRX;
  uc_pinTX = _pinTX;
}

uart::uart(uint8_t _pinRX, uint8_t _pinTX, uint8_t _pinCTS, uint8_t _pinRTS)
{
  uc_pinRX = _pinRX;
  uc_pinTX = _pinTX;
  uc_pinCTS = _pinCTS;
  uc_pinRTS = _pinRTS;
  uc_hwFlow = 1;
}

#ifdef ARDUINO_GENERIC
void uart::setPins(uint8_t _pinRX, uint8_t _pinTX)
{
  uc_pinRX = _pinRX;
  uc_pinTX = _pinTX;
}

void uart::setPins(uint8_t _pinRX, uint8_t _pinTX, uint8_t _pinCTS, uint8_t _pinRTS)
{
  uc_pinRX = _pinRX;
  uc_pinTX = _pinTX;
  uc_pinCTS = _pinCTS;
  uc_pinRTS = _pinRTS;
}
#endif // ARDUINO_GENERIC

void uart::begin(unsigned long baudrate)
{
  begin(baudrate, (uint8_t)SERIAL_8N1);
  //uBit.serial.read();
  uBit.serial.read(uBit.serial.rxBufferedSize(), MicroBitSerialMode::ASYNC);
  uBit.serial.clearRxBuffer();
  uBit.serial.clearTxBuffer();
}

void uart::begin(unsigned long baudrate, uint16_t /*config*/)
{
  uint32_t nrfBaudRate;

  if (baudrate <= 1200) {
    nrfBaudRate = BaudRate1200;
  } else if (baudrate <= 2400) {
    nrfBaudRate = BaudRate2400;
  } else if (baudrate <= 4800) {
    nrfBaudRate = BaudRate4800;
  } else if (baudrate <= 9600) {
    nrfBaudRate = BaudRate9600;
  } else if (baudrate <= 14400) {
    nrfBaudRate = BaudRate14400;
  } else if (baudrate <= 19200) {
    nrfBaudRate = BaudRate19200;
  } else if (baudrate <= 28800) {
    nrfBaudRate = BaudRate28800;
  } else if (baudrate <= 31250) {
    nrfBaudRate = 31520;
  } else if (baudrate <= 38400) {
    nrfBaudRate = BaudRate38400;
  } else if (baudrate <= 57600) {
    nrfBaudRate = BaudRate57600;
  } else if (baudrate <= 76800) {
    nrfBaudRate = BaudRate76800;
  } else if (baudrate <= 115200) {
    nrfBaudRate = BaudRate115200;
  } else if (baudrate <= 230400) {
    nrfBaudRate = BaudRate230400;
  } else if (baudrate <= 250000) {
    nrfBaudRate = BaudRate250000;
  } else if (baudrate <= 460800) {
    nrfBaudRate = BaudRate460800;
  } else if (baudrate <= 921600) {
    nrfBaudRate = BaudRate1M;
  } else {
    nrfBaudRate = UART_BAUDRATE_BAUDRATE_Baud1M;
  }

  uBit.serial.baud((int)nrfBaudRate);
}

void uart::end()
{
  uBit.serial.clearTxBuffer();
  uBit.serial.clearRxBuffer();
}

void uart::flush()
{
}

int uart::available()
{
  return uBit.serial.rxBufferedSize();
}

int uart::peek()
{
  //return rxBuffer.peek();
  return uBit.serial.peek();
}

int uart::read()
{
  if(!uBit.serial.rxBufferedSize())
    return -1;
  return uBit.serial.read();
}

size_t uart::write(const uint8_t data)
{
  uBit.serial.sendChar((char)data);
  return 1;
}

size_t uart::write(const uint8_t *buffer, size_t size)
{
  return uBit.serial.send((uint8_t *)buffer, size/*, MicroBitSerialMode::ASYNC*/);
}

uart Serial(USBRX, USBTX);

