/*
  Copyright (c) 2014 Arduino LLC.  All right reserved.
  Copyright (c) 2016 Sandeep Mistry All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "Arduino.h"
#include "basic.h"

extern "C" {

void analogReadResolution( int res )
{

}

void analogWriteResolution( int res )
{

}

/*
 * Internal VBG Reference is 1.2 V.
 * External References AREF0 and AREF1 should be between 0.83 V - 1.3 V.
 *
 * Warning : ADC should not be exposed to > 2.4 V, calculated after prescaling.
 *           GPIO pins must not be exposed to higher voltage than VDD + 0.3 V.
 */
void analogReference( eAnalogReference ulMode )
{

}

uint32_t analogRead( uint32_t ulPin )
{
  ulPin = g_PinID[ulPin];
  MicroBitPin *pin = getMicroBitPin(ulPin);

  if (!pin) return 0;
  return pin->getAnalogValue();
}

// Right now, PWM output only works on the pins with
// hardware support.  These are defined in the appropriate
// pins_*.c file.  For the rest of the pins, we default
// to digital output.
void analogWrite( uint32_t ulPin, uint32_t ulValue )
{
  ulPin = g_PinID[ulPin];
  MicroBitPin *pin = getMicroBitPin(ulPin);

  if (!pin) return;
  pin->setAnalogValue(ulValue);
}
}
