#ifndef MICORBIT_BLE_H
#define MICORBIT_BLE_H
#include "Arduino.h"

enum ValueTypeIndicator{ type_String, type_Number };

typedef void (*eventMBle) (void);
typedef void (*eventUartStringMBle) (String& message);
typedef void (*eventUartNumberMBle) (int value);

class DFMicrobitBle {

  public:

  DFMicrobitBle();

  void       startButtonService(),
             startAccelerometerService(),
             startLEDService(),
             startTemperatureService(),
             startIOPinService(),
             startMagnetometerService(),
             openBluetoothService();


  void       onBluetoothConnected(eventMBle event),
             onBluetoothDisconnected(eventMBle event);

  void       onUartDataReceived(String delimiters, eventMBle event);
  void       onUartDataReceived(const char* delimiters, eventMBle event)
             {onUartDataReceived(delimiters, event);};

  void       sendMessageWithStringValue(String key, String value),
             sendMessageWithNumberValue(String key, int value),
             sendMessageWithNumberValue(String key, double value);


  void       onStringReceived(String key, eventUartStringMBle event),
             onNumberReceived(String key, eventUartNumberMBle event);


  //String uartReadUntil(String del);
  //String *splitString(String splitOnChar, String input);

  private:

  void startUartService();
  void sendRawMessage(String key, ValueTypeIndicator type, String value);
  String getStringForValueTypeIndicator(ValueTypeIndicator vti);
  void uartWriteString(String data);
};

extern DFMicrobitBle MicrobitBle;

#endif
