/*
  Copyright (c) 2014-2015 Arduino LLC.  All right reserved.
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software.
*/

// Number of pins defined in PinDescription array
#ifndef Pins_Arduino_h
#define Pins_Arduino_h

#define PINS_COUNT              (26u)
#define NUM_DIGITAL_PINS        (19u)
#define NUM_ANALOG_INPUTS       (6u)
#define NUM_ANALOG_OUTPUTS      (19u)

// LEDs
#define PIN_LED                 (MICROBIT_PIN_P0)
#define LED_BUILTIN             (PIN_LED)
// #define

// Buttons
#define PIN_BUTTON_A            (MICROBIT_PIN_P5)
#define PIN_BUTTON_B            (MICROBIT_PIN_P11)

/*
 * Analog pins
 */
#define PIN_A0                  (0u)
#define PIN_A1                  (1u)
#define PIN_A2                  (2u)
#define PIN_A3                  (3u)
#define PIN_A4                  (4u)
#define PIN_A5                  (10u)

static const uint8_t A0 = PIN_A0;
static const uint8_t A1 = PIN_A1;
static const uint8_t A2 = PIN_A2;
static const uint8_t A3 = PIN_A3;
static const uint8_t A4 = PIN_A4;
static const uint8_t A5 = PIN_A5;

/*
 * Serial interfaces
 */
// Serial
#define PIN_SERIAL_RX           (25u)
#define PIN_SERIAL_TX           (24u)

/*
 * SPI Interfaces
 */
#define SPI_INTERFACES_COUNT    (1)

static const uint8_t SS = 16;

/*
 * Wire Interfaces
 */
#define WIRE_INTERFACES_COUNT   (1)

#define PIN_WIRE_SDA            (20u)
#define PIN_WIRE_SCL            (19u)

static const uint8_t SDA = PIN_WIRE_SDA;
static const uint8_t SCL = PIN_WIRE_SCL;

#endif
